/*****************************************************************************
 * crc32.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007 Greg Hosler
 * ghosler ['at'] users.sourceforge.net
 */

#ifndef CRC_H
#define CRC_H


#ifdef HAVE_STDINT_H
#include <stdint.h>
#include <sys/types.h>
#else
#include <limits.h>
#endif

#include <stddef.h>

/* crc32_t is an unsigned integral type    */
/* with at least 32 bits (but maybe more): */

#if HAVE_STDINT_H
typedef uint32_t crc32_t;
#else
#if UINT_MAX >= 0xffffffff
typedef unsigned int crc32_t;
#else
typedef unsigned long crc32_t;
#endif
#endif

crc32_t gyachi_crc32(const unsigned char *bytes, size_t n);

    /* Returns the 32-bit CRC of the first n bytes in the array.  */
    /* Each byte must be in the range 0..255.  This is equivalent */
    /* to crc32_update(0xffffffff,bytes,n) ^ 0xffffffff.          */


crc32_t gyachi_crc32_update(crc32_t crc, const unsigned char *bytes, size_t n);

    /* To compute the CRC incrementally, pass the first set     */
    /* of bytes to this function with crc = 0xffffffff.  Then   */
    /* pass each subsequent set of bytes with crc equal to the  */
    /* return value from the previous call.  After all bytes    */
    /* have been processed, the CRC of the entire sequence of   */
    /* bytes is r ^ 0xffffffff, where r is the return value     */
    /* from the last call, and ^ is the C bitwise xor operator, */
    /* not exponentiation.                                      */


#endif /* CRC_H */
