/* Header for the Socket-reading and image
   conversion module for the GyachE-Webcam viewer program */

/* This program borrows alot of code from both Ayttm and 
    Gyach-E itself, however, this program is a completely 
    restructured webcam viewer that handles sockets and threads
    in the Gyach-E way, not the Ayttm way of many threads, many 
    structs, etc.  It is designed for simplicity, speed, 
    memory-friendliness, and stability: It runs as an EXTERNAL 
    program to Gyach Enhanced, so that if it DOES crash, it 
    crashes ALONE, rather than taking down an entire chat program
    with it. It is a clean, efficient SINGLE-THREADED application */

/*****************************************************************************
 * gyachewebcam.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005 Erica Andrews (Phrozensmoke ['a'] yahoo.com)
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/


typedef struct {
	char *name;
	int v4l_version;
	int v4l2_CID;
	int toggle;
	int min;
	int max;
	int step;
	int default_value;
	int value;
	int orig_value;
	GtkWidget *widget;
} V4L_PROPERTY;

typedef enum { V4L_HUE=0, V4L_CONTRAST, V4L_BRIGHTNESS, V4L_COLOUR, V4L_WHITENESS, V4L_SHARPNESS } V4L_ATTRIBUTE;

extern GList *cam_property_list;
extern int exit_on_error;
extern int cam_is_open;


/* in gyacheupload-v4l */
extern char *v4l_version;
extern int fix_color_setting;
extern void cleanup_v4l(GtkWidget *parent);
extern void set_vid_properties(GtkWidget *parent);
extern void select_v4l_mode(const char *new_v4l_mode, GtkWidget *parent);
extern void read_webcamrc();
extern void write_webcamrc();
extern void set_video_device(char *myvdev);
extern void update_cam(GtkWidget *parent);
V4L_PROPERTY *find_property_by_name(char *name);

