/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Spicebird code.
 *
 * The Initial Developer of the Original Code is
 * Synovel Software Technologies
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Prasad Sunkari <prasad@synovel.com> (Original Author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _csTPConnection_H_
#define _csTPConnection_H_

#include "nsStringGlue.h"
#include "nsCOMPtr.h"
#include "nsArrayUtils.h"
#include "csITPConnection.h"
#include "csITPConnectionPresence.h"
#include "csITPConnectionAliasing.h"
#include "csITPConnectionAvatars.h"
#include "csITPConnectionInterfaces.h"
#include <telepathy-glib/connection.h>

class nsIArray;
class nsIMutableArray;

class csTPConnection : public csITPConnection,
                       public csITPConnectionAliasing,
                       public csITPConnectionPresence,
                       public csITPConnectionAvatars,
                       public csITPConnectionCapabilities,
                       public csITPConnectionRenaming,
                       public csITPConnectionSimplePresence
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPPROXY
  NS_DECL_CSITPCONNECTION
  NS_DECL_CSITPCONNECTIONALIASING
  NS_DECL_CSITPCONNECTIONPRESENCE
  NS_DECL_CSITPCONNECTIONAVATARS
  NS_DECL_CSITPCONNECTIONCAPABILITIES
  NS_DECL_CSITPCONNECTIONRENAMING
  NS_DECL_CSITPCONNECTIONSIMPLEPRESENCE

  csTPConnection();

  void HandleNewChannel(const gchar *aObjPath, const gchar *aChannelType,
                        guint aHandleType, guint aHandle,
                        gboolean aSupressHandler);

  void HandleStatusChanged(guint aStatus, guint aStatusReason);
  void HandleConnectionReady();
  void HandlePresenceUpdate(GHashTable *aPresenceHash);
  void HandleAliasesChanged(const GPtrArray *aAliasesArray);

private:
  ~csTPConnection();

protected:
  TpDBusDaemon *m_BusDaemon;
  TpConnection *m_Connection;

  nsCOMPtr<nsIMutableArray> m_NewChannelObservers;
  nsCOMPtr<nsIMutableArray> m_StatusChangeObservers;
  nsCOMPtr<nsIMutableArray> m_ConnectionReadyObservers;
  nsCOMPtr<nsIMutableArray> m_PresenceUpdateObservers;
  nsCOMPtr<nsIMutableArray> m_AliasesChangedObservers;

  CS_TELEPATHY_DECL_PROXY
};




class csTPPresenceStatusSpec : public csITPPresenceStatusSpec
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPPRESENCESTATUSSPEC

  csTPPresenceStatusSpec(nsCString aStatusString,
                         PRUint32 aType, PRBool aMaySetOnSelf,
                         PRBool aIsExclusive, nsIPropertyBag *aParameters);

  static NS_METHOD Create(nsCString aStatusString, PRUint32 aType, 
                          PRBool aMaySetOnSelf, PRBool aIsExclusive,
                          nsIPropertyBag *aParameters, void **aResult);

private:
  ~csTPPresenceStatusSpec();

protected:
  nsCString m_StatusString;
  PRUint32 m_Type;
  PRBool m_MaySetOnSelf;
  PRBool m_IsExclusive;
  nsCOMPtr<nsIPropertyBag> m_Parameters;
};




class csTPPresenceInfo : public csITPPresenceInfo
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPPRESENCEINFO

  csTPPresenceInfo(PRUint32 aHandle, PRUint32 aLastActivityTime,
                   nsIArray *aCurrentStatuses);

  static NS_METHOD Create(PRUint32 aHandle, PRUint32 aLastActivityTime,
                          nsIArray *aCurrentStatuses, void **aResult);

private:
  ~csTPPresenceInfo();

protected:
  PRUint32 m_Handle;
  PRUint32 m_LastActivityTime;
  nsCOMPtr<nsIArray> m_CurrentStatuses;
};



class csTPPresenceStatus : public csITPPresenceStatus
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPPRESENCESTATUS

  csTPPresenceStatus(nsCString aStatusString, nsIPropertyBag *aOptParams);

  static NS_METHOD Create(nsCString aStatusString, 
                          nsIPropertyBag *aOptParams, void **aResult);

private:
  ~csTPPresenceStatus();

protected:
  nsCOMPtr<nsIPropertyBag> m_OptParams;
  nsCString m_StatusString;
};



class csTPAliasingHandleAliasPair : public csITPAliasingHandleAliasPair
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPALIASINGHANDLEALIASPAIR

  csTPAliasingHandleAliasPair(PRUint32 aHandle, nsString aAlias);

  static NS_METHOD Create(PRUint32 aHandle,
                          nsString aAlias, void **aResult);

private:
  ~csTPAliasingHandleAliasPair();

protected:
  nsString m_Alias;
  PRUint32 m_Handle;
};

#endif
