/* Unit testing for outcomes
(C) 2013-2019 Niall Douglas <http://www.nedproductions.biz/> (6 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome/outcome.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

BOOST_OUTCOME_AUTO_TEST_CASE(issues_61_result, "result<T1, E1> does not compare to incompatible result<T2, E2>")
{
  using namespace BOOST_OUTCOME_V2_NAMESPACE;
  struct udt1
  {
    const char *_v{nullptr};
    udt1() = default;
    constexpr udt1(const char *v) noexcept : _v(v) {}  // NOLINT
    udt1(udt1 &&o) = delete;
    udt1(const udt1 &) = delete;
    udt1 &operator=(udt1 &&o) = delete;
    udt1 &operator=(const udt1 &) = delete;
    ~udt1() = default;
    constexpr const char *operator*() const noexcept { return _v; }
  };
  struct udt2
  {
    const char *_v{nullptr};
    udt2() = default;
    constexpr explicit udt2(const char *v) noexcept : _v(v) {}
    udt2(udt2 &&o) = delete;
    udt2(const udt2 &) = delete;
    udt2 &operator=(udt2 &&o) = delete;
    udt2 &operator=(const udt2 &) = delete;
    ~udt2() = default;
    constexpr const char *operator*() const noexcept { return _v; }
    bool operator==(const udt1 &o) const noexcept { return _v == *o; }
    bool operator!=(const udt1 &o) const noexcept { return _v != *o; }
  };
  using result1 = result<int, udt1>;
  using result2 = result<int, udt2>;

  result1 a(5);
  result2 b(5);
  BOOST_CHECK(b == a);     // udt2 will compare to udt1
  BOOST_CHECK(!(b != a));  // udt2 will compare to udt1

  result<void> c = success();
  result<void> d = success();
  BOOST_CHECK(c == d);
  BOOST_CHECK(!(c != d));

  BOOST_CHECK(a == success());
  BOOST_CHECK(success() == a);
  BOOST_CHECK(b != failure("foo"));
  BOOST_CHECK(failure("foo") != b);
}

BOOST_OUTCOME_AUTO_TEST_CASE(issues_61_outcome, "outcome<T1, E1, P1> does not compare to incompatible outcome<T2, E2, P2>")
{
  using namespace BOOST_OUTCOME_V2_NAMESPACE;
  struct udt1
  {
    const char *_v{nullptr};
    udt1() = default;
    constexpr udt1(const char *v) noexcept : _v(v) {}  // NOLINT
    udt1(udt1 &&o) = delete;
    udt1(const udt1 &) = delete;
    udt1 &operator=(udt1 &&o) = delete;
    udt1 &operator=(const udt1 &) = delete;
    ~udt1() = default;
    constexpr const char *operator*() const noexcept { return _v; }
  };
  struct udt2
  {
    const char *_v{nullptr};
    udt2() = default;
    constexpr explicit udt2(const char *v) noexcept : _v(v) {}
    udt2(udt2 &&o) = delete;
    udt2(const udt2 &) = delete;
    udt2 &operator=(udt2 &&o) = delete;
    udt2 &operator=(const udt2 &) = delete;
    ~udt2() = default;
    constexpr const char *operator*() const noexcept { return _v; }
    bool operator==(const udt1 &o) const noexcept { return _v == *o; }
    bool operator!=(const udt1 &o) const noexcept { return _v != *o; }
  };
  using outcome1 = outcome<int, udt1>;
  using outcome2 = outcome<int, udt2>;

  outcome1 a(5), _a(6);
  outcome2 b(5);
  BOOST_CHECK(b == a);     // udt2 will compare to udt1
  BOOST_CHECK(!(b != a));  // udt2 will compare to udt1

  outcome<void> c = success();
  outcome<void> d = success();
  BOOST_CHECK(c == d);
  BOOST_CHECK(!(c != d));

  BOOST_CHECK(a == success());
  BOOST_CHECK(success() == a);
  BOOST_CHECK(b != failure("foo"));
  BOOST_CHECK(failure("foo") != b);
}
