/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/SchemaTypesDoc/CClassCardinalityDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/ClassCardinalityXml.h"

using namespace Caf;

void ClassCardinalityXml::add(
	const SmartPtrCClassCardinalityDoc classCardinalityDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassCardinalityXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(classCardinalityDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string namespaceValVal = classCardinalityDoc->getNamespaceVal();
		CAF_CM_VALIDATE_STRING(namespaceValVal);
		thisXml->addAttribute("namespace", namespaceValVal);

		const std::string nameVal = classCardinalityDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string versionVal = classCardinalityDoc->getVersion();
		CAF_CM_VALIDATE_STRING(versionVal);
		thisXml->addAttribute("version", versionVal);

		const std::string cardinalityVal = classCardinalityDoc->getCardinality();
		CAF_CM_VALIDATE_STRING(cardinalityVal);
		thisXml->addAttribute("cardinality", cardinalityVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCClassCardinalityDoc ClassCardinalityXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassCardinalityXml", "parse");

	SmartPtrCClassCardinalityDoc classCardinalityDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string namespaceValStrVal =
			thisXml->findRequiredAttribute("namespace");
		const std::string namespaceValVal = namespaceValStrVal;

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string versionStrVal =
			thisXml->findRequiredAttribute("version");
		const std::string versionVal = versionStrVal;

		const std::string cardinalityStrVal =
			thisXml->findRequiredAttribute("cardinality");
		const std::string cardinalityVal = cardinalityStrVal;

		classCardinalityDoc.CreateInstance();
		classCardinalityDoc->initialize(
			namespaceValVal,
			nameVal,
			versionVal,
			cardinalityVal);
	}
	CAF_CM_EXIT;

	return classCardinalityDoc;
}

