#ifndef INCLUDE_MODULE_PMAC_H
#define INCLUDE_MODULE_PMAC_H
/* ----------------------------------------------------------------------------
 * module_pmac.h
 * prototypes and definitions for the laptop module pmac.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <glib.h>
#include <pbbtaglist.h>

#ifndef I2C_SLAVE
#define I2C_SLAVE   0x0703	/* Change slave address (7 or 10 bits) */
#endif
#define I2CCHIP		"uni-n"

#define ADB_BUFSIZE		32      /* Size of the ADB buffer, constant,
                                            must not be changed !! */

#define OHARE_PMU		9

#define KEYBLIGHTMAX		255
#define MAX_BATTERIES		2

#define DEFAULT_PMU		"/dev/pmu"
#define DEFAULT_ADB		"/dev/adb"
#define DEFAULT_BATLOG		"/var/lib/pbbuttons/%03d_battery.log"
#define DEFAULT_BATCYCLE	"/var/lib/pbbuttons/battery.cycle"
#define PATH_FNMODE		"/sys/module/usbhid/parameters/pb_fnmode"
#define OFBASE			"/proc/device-tree"
#define SYSI2CDEV		"/sys/class/i2c-dev"

/* definitions for input device config */
#define TRACKPAD_NOTAP_NAME	"notap"
#define TRACKPAD_TAP_NAME	"tap"
#define TRACKPAD_DRAG_NAME	"drag"
#define TRACKPAD_LOCK_NAME	"lock"
enum {TRACKPAD_NOTAP, TRACKPAD_TAP, TRACKPAD_DRAG, TRACKPAD_LOCK, TRACKPAD_LAST=TRACKPAD_LOCK};

#define KEYBOARD_FNDISABLED_NAME "disabled"
#define KEYBOARD_FNBACK_NAME	 "fkeyslast"
#define KEYBOARD_FNTOP_NAME		 "fkeysfirst"
enum {KEYBOARD_FNDISABLED, KEYBOARD_FNBACK, KEYBOARD_FNTOP, KEYBOARD_LAST=KEYBOARD_FNTOP};

#define BATLOG_NONE_NAME	"none"
#define BATLOG_CYCLE_NAME	"cycle"
#define BATLOG_LOG_NAME		"log"
enum {BATLOG_NONE, BATLOG_CYCLE, BATLOG_LOG, BATLOG_LAST=BATLOG_LOG};

#ifndef PMU_IOC_GRAB_BACKLIGHT
#define PMU_IOC_GRAB_BACKLIGHT	_IOR('B', 6, 0)
#endif

#ifndef PMU_ENV_AC_POWER
#define PMU_ENV_AC_POWER	0x04
#endif
#ifndef PMU_ENV_BATTERY_PRESENT
#define PMU_ENV_BATTERY_PRESENT	0x10
#endif

struct modflags_pmac {
	unsigned int coveropen :1;
	unsigned int ac_power:1;
	unsigned int batpresent:1;      /* set by pmu hardware */
	unsigned int sleepsupported:1;
	unsigned int notap_typing:1;     /* switch trackpad tap off while typing */
//	unsigned int set_tpmode:1;        /* delayed function triggered */
	unsigned int set_kbdmode:1;          /* delayed function triggered */
	unsigned int goto_sleep:1;             /* delayed function triggered */
	unsigned int bat_present:MAX_BATTERIES; /* set by /proc/pmu/battery_% */
	unsigned int bat_charging:MAX_BATTERIES;
	unsigned int :0;
};

/* public prototypes */
int pmac_init ();
int pmac_open (struct tagitem *taglist);
int pmac_close ();
int pmac_exit ();

/* private prototypes */
void pmac_keyboard (struct tagitem *taglist);
void pmac_mouse (struct tagitem *taglist);
void pmac_secure (struct tagitem *taglist);
void pmac_query (struct tagitem *taglist);
void pmac_configure (struct tagitem *taglist);
void pmac_handle_tags (int cfgure, struct tagitem *taglist);
gboolean pmac_pmu_handler (int fd, gpointer user_data);
void pmac_timer100 (struct tagitem *taglist);
void pmac_timer1000 (struct tagitem *taglist);

void pmac_update_batteryinfo ();
int pmac_get_procac ();
int pmac_update_flags ();
void activate_sleepmode ();
void pmac_set_lcdbacklight(int val);
int getMachineID(int pmu);
const char* getMachineName(int mid);
int isModifier (int code, int mod);
int haveADBKeyboard ();
int haveADBTrackpad ();
int haveI2CAmbient ();
int havePMUAmbient ();

int keyboard_get_config();
void keyboard_set_config(int config);
int keyboard_get_dev(int fd);
int trackpad_get_config();
void trackpad_set_config(int config);
int trackpad_get_dev(int fd);
void trackpad_set_prgmode(int fd, int dev, int mode);
int send_pmu_request(int fd, unsigned char *buffer, int params, ...);
int adb_read_reg(int fd, unsigned char *ADBBuffer, int dev, int reg);
int adb_write_reg(int fd, unsigned char *ADBBuffer, int len, int dev, int reg);
int get_pmu_version(int fd);
int get_button(int fd, int button);
int get_int_environment(int fd);
#ifndef WITH_PMUD
int get_cover_position(int fd);
#endif
int batlog_setup();
void batlog_save();
void batlog_write(long timerem);

/* functions for ambient light sensor and keyboard illumination */
int addPath(char *path, int maxlen, char *pattern);
int getLMUAddress();
int probeLMU(char *device, int addr);
const char *findLMUDevice(int addr);
int getAmbient ();
int getRawAmbient ();
void setKBDIllumination (unsigned short level);

#endif    /* INCLUDE_MODULE_PMAC_H */
