#!perl

#
# Copyright 2014 Chris West (Faux)
# Copyright 2015 Andrew Ayer
#
# This file is part of strip-nondeterminism.
#
# strip-nondeterminism is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# strip-nondeterminism is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with strip-nondeterminism.  If not, see <http://www.gnu.org/licenses/>.
#

use Archive::Zip qw( :ERROR_CODES :CONSTANTS );
use File::Temp 'tempdir';
use Test::More tests => 2;
use File::StripNondeterminism;
use strict;
use warnings;

File::StripNondeterminism::init();

my $dir = tempdir( CLEANUP => 1 );
my $path;
my $fh;
my $normalizer;

sub normalise {
    my $path = shift(@_);

    $normalizer = File::StripNondeterminism::get_normalizer_for_file($path);
    isnt(undef, $normalizer);
    $normalizer->($path);
}
#
# felix bundle pom.properties
#

$path = "$dir/foo.jar";
my $zip = Archive::Zip->new();
$zip->addString(<<'ORIGINAL'
#Generated by org.apache.felix.bundleplugin
#Mon Aug 10 07:12:44 GMT-12:00 2015
version=1.5
ORIGINAL
, 'pom.properties');

unless ($zip->writeToFileNamed($path) == AZ_OK) {
    die("couldn't write test zip");
}

normalise($path);

my $afterzip = Archive::Zip->new();
unless ( $afterzip->read($path) == AZ_OK ) {
    die("couldn't read test zip");
}

is($afterzip->memberNamed('pom.properties')->contents(), <<'EXPECTED'
#Generated by org.apache.felix.bundleplugin
version=1.5
EXPECTED
);
