/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.ExactPairHMM;

public class OriginalPairHMM
extends ExactPairHMM {
    @Override
    public double computeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        int iii;
        int X_METRIC_LENGTH = readBases.length + 2;
        int Y_METRIC_LENGTH = haplotypeBases.length + 2;
        for (iii = 0; iii < readQuals.length; ++iii) {
            readQuals[iii] = readQuals[iii] < 6 ? 6 : (readQuals[iii] > MAX_CACHED_QUAL ? (int)MAX_CACHED_QUAL.byteValue() : readQuals[iii]);
        }
        for (iii = 1; iii < X_METRIC_LENGTH; ++iii) {
            for (int jjj = hapStartIndex + 1; jjj < Y_METRIC_LENGTH; ++jjj) {
                if (iii == 1 && jjj == 1) continue;
                this.updateCell(iii, jjj, haplotypeBases, readBases, readQuals, insertionGOP, deletionGOP, overallGCP, this.matchMetricArray, this.XMetricArray, this.YMetricArray);
            }
        }
        int endI = X_METRIC_LENGTH - 1;
        int endJ = Y_METRIC_LENGTH - 1;
        return MathUtils.approximateLog10SumLog10(this.matchMetricArray[endI][endJ], this.XMetricArray[endI][endJ], this.YMetricArray[endI][endJ]);
    }

    private void updateCell(int indI, int indJ, byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, double[][] matchMetricArray, double[][] XMetricArray, double[][] YMetricArray) {
        int im1 = indI - 1;
        int jm1 = indJ - 1;
        double pBaseReadLog10 = 0.0;
        if (im1 > 0 && jm1 > 0) {
            byte x = readBases[im1 - 1];
            byte y = haplotypeBases[jm1 - 1];
            byte qual = readQuals[im1 - 1];
            double d = pBaseReadLog10 = x == y || x == 78 || y == 78 ? QualityUtils.qualToProbLog10(qual) : QualityUtils.qualToErrorProbLog10(qual);
        }
        int qualIndexGOP = im1 == 0 ? 90 : (insertionGOP[im1 - 1] + deletionGOP[im1 - 1] > MAX_CACHED_QUAL ? (int)MAX_CACHED_QUAL.byteValue() : insertionGOP[im1 - 1] + deletionGOP[im1 - 1]);
        double d0 = QualityUtils.qualToProbLog10((byte)qualIndexGOP);
        double e0 = im1 == 0 ? QualityUtils.qualToProbLog10((byte)10) : QualityUtils.qualToProbLog10(overallGCP[im1 - 1]);
        matchMetricArray[indI][indJ] = pBaseReadLog10 + MathUtils.approximateLog10SumLog10(matchMetricArray[indI - 1][indJ - 1] + d0, XMetricArray[indI - 1][indJ - 1] + e0, YMetricArray[indI - 1][indJ - 1] + e0);
        double d1 = im1 == 0 ? QualityUtils.qualToErrorProbLog10((byte)45) : QualityUtils.qualToErrorProbLog10(insertionGOP[im1 - 1]);
        double e1 = im1 == 0 ? QualityUtils.qualToErrorProbLog10((byte)10) : QualityUtils.qualToErrorProbLog10(overallGCP[im1 - 1]);
        double qBaseReadLog10 = 0.0;
        XMetricArray[indI][indJ] = 0.0 + MathUtils.approximateLog10SumLog10(matchMetricArray[indI - 1][indJ] + d1, XMetricArray[indI - 1][indJ] + e1);
        double d2 = im1 == 0 || im1 == readBases.length ? 0.0 : QualityUtils.qualToErrorProbLog10(deletionGOP[im1 - 1]);
        double e2 = im1 == 0 || im1 == readBases.length ? 0.0 : QualityUtils.qualToErrorProbLog10(overallGCP[im1 - 1]);
        double qBaseRefLog10 = 0.0;
        YMetricArray[indI][indJ] = 0.0 + MathUtils.approximateLog10SumLog10(matchMetricArray[indI][indJ - 1] + d2, YMetricArray[indI][indJ - 1] + e2);
    }
}

