/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LongSizeStringParser
extends StringParser {
    private static final Pattern PARSE_SIZE_REGEX = Pattern.compile("((#|0x|0X)?[0-9A-Fa-f]+)([KMGTP]i?)?");
    private static final BigInteger LONG_MAX_VALUE = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final HashMap UNIT2SIZE = new HashMap();
    static final LongSizeStringParser INSTANCE = new LongSizeStringParser();

    private LongSizeStringParser() {
    }

    public static LongSizeStringParser getParser() {
        return INSTANCE;
    }

    public Object parse(String string) throws ParseException {
        return new Long(LongSizeStringParser.parseSize(string));
    }

    public static long parseSize(CharSequence charSequence) throws ParseException {
        Long l;
        Object object;
        Matcher matcher = PARSE_SIZE_REGEX.matcher(charSequence);
        if (!matcher.matches()) {
            throw new ParseException("Invalid size specification '" + charSequence + "'.");
        }
        String string = matcher.group(3);
        BigInteger bigInteger = BigInteger.ONE;
        if (string != null) {
            object = (Long)UNIT2SIZE.get(string);
            if (object == null) {
                throw new ParseException("Invalid unit specification '" + string + "'.");
            }
            bigInteger = new BigInteger(((Long)object).toString());
        }
        object = matcher.group(1);
        try {
            l = Long.decode((String)object);
            if (l < 0L) {
                throw new ParseException("Sizes cannot be negative.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid number '" + (String)object + "'.");
        }
        BigInteger bigInteger2 = new BigInteger(l.toString()).multiply(bigInteger);
        if (bigInteger2.compareTo(LONG_MAX_VALUE) > 0) {
            throw new ParseException("Size '" + charSequence + "' is too big.");
        }
        return Long.parseLong(bigInteger2.toString());
    }

    static {
        UNIT2SIZE.put("K", new Long(1000L));
        UNIT2SIZE.put("M", new Long(1000000L));
        UNIT2SIZE.put("G", new Long(1000000000L));
        UNIT2SIZE.put("T", new Long(1000000000000L));
        UNIT2SIZE.put("P", new Long(1000000000000000L));
        UNIT2SIZE.put("Ki", new Long(1024L));
        UNIT2SIZE.put("Mi", new Long(0x100000L));
        UNIT2SIZE.put("Gi", new Long(0x40000000L));
        UNIT2SIZE.put("Ti", new Long(0x10000000000L));
        UNIT2SIZE.put("Pi", new Long(0x4000000000000L));
    }
}

