/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHPROTOCOLCAPABILITIESACCESS_H_
#define OPENDRIM_SSHPROTOCOLCAPABILITIESACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHProtocolCapabilities.h"
#include "assocOpenDRIM_SSHProtocolCapabilities.h"

int SSH_OpenDRIM_SSHProtocolCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_unload(string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHProtocolCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHProtocolCapabilities& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolCapabilities& newInstance, const OpenDRIM_SSHProtocolCapabilities& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolCapabilities& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolCapabilities& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SSHProtocolCapabilities>& OpenDRIM_SSHProtocolCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_SSHProtocolCapabilities>& OpenDRIM_SSHProtocolCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolCapabilities_populate(OpenDRIM_SSHProtocolCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_SSHPROTOCOLCAPABILITIESACCESS_H_*/
