    /*
     * Some or all of this work - Copyright (c) 2006 - 2020, Intel Corp.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without modification,
     * are permitted provided that the following conditions are met:
     *
     * Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
     * may be used to endorse or promote products derived from this software
     * without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */
    /*
     * Region Field objects definition and processing
     */
    /*
     * On testing following issues should be covered:
     * - Operation Regions of different Region Space types application
     *   for Field objects definition,
     * - application of any allowed AccessType Keywords,
     * - application of any allowed LockRule Keywords,
     * - application of any allowed UpdateRule Keywords,
     * - application of the Offset macros in the FieldUnitList,
     * - application of the AccessAs macros in the FieldUnitList,
     * - on writing taking into account the Access Type in accord with
     the Update Rule,
     * - splitting of an field causes appropriate splitting of the spanned bits,
     * - AccessAs macros influence on the remaining FieldUnits within the list,
     * - integer/buffer representation of the Unit contents as depends on its
     *   Length and DSDT ComplianceRevision (32/64-bit Integer),
     * - Data Type Conversion Rules on storing to Region Fields.
     *
     * Can not be tested following issues:
     * - exact use of given Access Type alignment on Access to Field data,
     * - exact use of specific Conversion Rules on storing of Buffers or Strings.
     */
    Name (Z143, 0x8F)
    Name (RS00, 0x0100)
    /* Generated benchmark buffers for comparison with */

    Name (BR10, Buffer (RS00){})
    Name (BR01, Buffer (RS00){})
    Name (BRB0, Buffer (RS00){})
    /* Buffer for filling the ground */

    Name (BRG0, Buffer (RS00){})
    /* Buffer for filling the field (over the ground) */

    Name (BRF0, Buffer (RS00){})
    /* Tested field unit offsets */

    Name (PFUO, Package (0x10)
    {
        0x00,
        0x01,
        0x02,
        0x03,
        0x04,
        0x05,
        0x06,
        0x07,
        0x08,
        0x09,
        0x1F,
        0x20,
        0x21,
        0x3F,
        0x40,
        0x41
    })
    /* Tested field unit length */

    Name (PFUL, Package (0x10)
    {
        0x01,
        0x06,
        0x07,
        0x08,
        0x09,
        0x1F,
        0x20,
        0x21,
        0x3F,
        0x40,
        0x41,
        0x45,
        0x81,
        0x0100,
        0x03FF,
        0x07BF
    })
    /* Dynamic Field test Control parameters Package */
    /* Layout of Package: */
    /* - <control flag>: 0 - none, 1 - IndexField, 2 - BankField, */
    /* - <Refof to Field>, */
    /* - <Benchmark value> */
    Name (FCP0, Package (0x03)
    {
        0x00
    })
    /* Testing parameters Packages */
    /* Layout of Package: */
    /* - <index of first offset>, */
    /* - <num of offsets>, */
    /* - <index of first length>, */
    /* - <num of lengths>, */
    /* - <testing parameters package>: */
    /*    - opcode of buffer to fill the ground */
    /*    - opcode of buffer to fill the field */
    /*      Opcodes of buffers: */
    /*        0 - all zeros */
    /*        1 - all units */
    /*        2 - some mix */
    /*    - Access Type opcode */
    /*        0 - AnyAcc, 1 - ByteAcc, 2 - WordAcc, */
    /*        3 - DWordAcc, 4 - QWordAcc, 5 - BufferAcc */
    /*    - Update Rule opcode */
    /*        0 - Preserve, 1 - WriteAsOnes, 2 - WriteAsZeros */
    /*    - Lock Rule opcode */
    /*        0 - Lock, 1 - NoLock */
    /*    - Method implementing creation of fields */
    /* ByteAcc, NoLock, Preserve */
    Name (PP00, Package (0x05)
    {
        /* examines the whole range possible for the field's */
        /* (off, len) in the underlying 256-byte Region: */
        0x00,
        0x04,
        0x00,
        0x04,
        Package (0x06)
        {
            0x00,
            0x01,
            0x01,
            0x00,
            0x01,
            "m730"
        }
    })
    /* ByteAcc, NoLock, WriteAsOnes */

    Name (PP01, Package (0x05)
    {
        0x00,
        0x04,
        0x04,
        0x04,
        Package (0x06)
        {
            0x00,
            0x01,
            0x01,
            0x01,
            0x01,
            "m731"
        }
    })
    /* ByteAcc, NoLock, WriteAsZeros */

    Name (PP02, Package (0x05)
    {
        0x00,
        0x04,
        0x08,
        0x04,
        Package (0x06)
        {
            0x00,
            0x02,
            0x01,
            0x02,
            0x01,
            "m732"
        }
    })
    /* WordAcc, NoLock, Preserve */

    Name (PP03, Package (0x05)
    {
        0x00,
        0x04,
        0x0C,
        0x04,
        Package (0x06)
        {
            0x01,
            0x00,
            0x02,
            0x00,
            0x01,
            "m733"
        }
    })
    /* WordAcc, NoLock, WriteAsOnes */

    Name (PP04, Package (0x05)
    {
        0x04,
        0x04,
        0x00,
        0x04,
        Package (0x06)
        {
            0x01,
            0x00,
            0x02,
            0x01,
            0x01,
            "m734"
        }
    })
    /* WordAcc, NoLock, WriteAsZeros */

    Name (PP05, Package (0x05)
    {
        0x04,
        0x04,
        0x04,
        0x04,
        Package (0x06)
        {
            0x01,
            0x02,
            0x02,
            0x02,
            0x01,
            "m735"
        }
    })
    /* DWordAcc, NoLock, Preserve */

    Name (PP06, Package (0x05)
    {
        0x04,
        0x04,
        0x08,
        0x04,
        Package (0x06)
        {
            0x02,
            0x00,
            0x03,
            0x00,
            0x01,
            "m736"
        }
    })
    /* DWordAcc, NoLock, WriteAsOnes */

    Name (PP07, Package (0x05)
    {
        0x04,
        0x04,
        0x0C,
        0x04,
        Package (0x06)
        {
            0x02,
            0x01,
            0x03,
            0x01,
            0x01,
            "m737"
        }
    })
    /* DWordAcc, NoLock, WriteAsZeros */

    Name (PP08, Package (0x05)
    {
        0x08,
        0x04,
        0x00,
        0x04,
        Package (0x06)
        {
            0x02,
            0x01,
            0x03,
            0x02,
            0x01,
            "m738"
        }
    })
    /* QWordAcc, NoLock, Preserve */

    Name (PP09, Package (0x05)
    {
        0x08,
        0x04,
        0x04,
        0x04,
        Package (0x06)
        {
            0x02,
            0x00,
            0x04,
            0x00,
            0x01,
            "m739"
        }
    })
    /* QWordAcc, NoLock, WriteAsOnes */

    Name (PP0A, Package (0x05)
    {
        0x08,
        0x04,
        0x08,
        0x04,
        Package (0x06)
        {
            0x00,
            0x01,
            0x04,
            0x01,
            0x01,
            "m73a"
        }
    })
    /* QWordAcc, NoLock, WriteAsZeros */

    Name (PP0B, Package (0x05)
    {
        0x08,
        0x04,
        0x0C,
        0x04,
        Package (0x06)
        {
            0x00,
            0x02,
            0x04,
            0x02,
            0x01,
            "m73b"
        }
    })
    /* AnyAcc, NoLock, Preserve */

    Name (PP0C, Package (0x05)
    {
        0x0C,
        0x04,
        0x00,
        0x04,
        Package (0x06)
        {
            0x01,
            0x00,
            0x00,
            0x00,
            0x01,
            "m73c"
        }
    })
    /* AnyAcc, NoLock, WriteAsOnes */

    Name (PP0D, Package (0x05)
    {
        0x0C,
        0x04,
        0x04,
        0x04,
        Package (0x06)
        {
            0x02,
            0x01,
            0x00,
            0x01,
            0x01,
            "m73d"
        }
    })
    /* AnyAcc, Lock, WriteAsZeros */

    Name (PP0E, Package (0x05)
    {
        0x0C,
        0x04,
        0x08,
        0x08,
        Package (0x06)
        {
            0x01,
            0x02,
            0x00,
            0x02,
            0x00,
            "m73e"
        }
    })
    /* Check common access: ByteAcc, NoLock, Preserve */
    /* m710(CallChain) */
    /* CallChain: String */
    Method (M710, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m710", Arg0)
        Debug = "TEST: m710, Check Region Fields specified as (ByteAcc, NoLock, Preserve)"
        M72F (Arg0, 0x01, "pp00", PP00)
    }

    /* Check common access: ByteAcc, NoLock, WriteAsOnes */
    /* m711(CallChain) */
    /* CallChain: String */
    Method (M711, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m711", Arg0)
        Debug = "TEST: m711, Check Region Fields specified as (ByteAcc, NoLock, WriteAsOnes)"
        M72F (Arg0, 0x01, "pp01", PP01)
    }

    /* Check common access: ByteAcc, NoLock, WriteAsZeros */
    /* m712(CallChain) */
    /* CallChain: String */
    Method (M712, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m712", Arg0)
        Debug = "TEST: m712, Check Region Fields specified as (ByteAcc, NoLock, WriteAsZeros)"
        M72F (Arg0, 0x01, "pp02", PP02)
    }

    /* Check common access: WordAcc, NoLock, Preserve */
    /* m713(CallChain) */
    /* CallChain: String */
    Method (M713, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m713", Arg0)
        Debug = "TEST: m713, Check Region Fields specified as (WordAcc, NoLock, Preserve)"
        M72F (Arg0, 0x01, "pp03", PP03)
    }

    /* Check common access: WordAcc, NoLock, WriteAsOnes */
    /* m714(CallChain) */
    /* CallChain: String */
    Method (M714, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m714", Arg0)
        Debug = "TEST: m714, Check Region Fields specified as (WordAcc, NoLock, WriteAsOnes)"
        M72F (Arg0, 0x01, "pp04", PP04)
    }

    /* Check common access: WordAcc, NoLock, WriteAsZeros */
    /* m715(CallChain) */
    /* CallChain: String */
    Method (M715, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m715", Arg0)
        Debug = "TEST: m715, Check Region Fields specified as (WordAcc, NoLock, WriteAsZeros)"
        M72F (Arg0, 0x01, "pp05", PP05)
    }

    /* Check common access: DWordAcc, NoLock, Preserve */
    /* m716(CallChain) */
    /* CallChain: String */
    Method (M716, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m716", Arg0)
        Debug = "TEST: m716, Check Region Fields specified as (DWordAcc, NoLock, Preserve)"
        M72F (Arg0, 0x01, "pp06", PP06)
    }

    /* Check common access: DWordAcc, NoLock, WriteAsOnes */
    /* m717(CallChain) */
    /* CallChain: String */
    Method (M717, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m717", Arg0)
        Debug = "TEST: m717, Check Region Fields specified as (DWordAcc, NoLock, WriteAsOnes)"
        M72F (Arg0, 0x01, "pp07", PP07)
    }

    /* Check common access: DWordAcc, NoLock, WriteAsZeros */
    /* m718(CallChain) */
    /* CallChain: String */
    Method (M718, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m718", Arg0)
        Debug = "TEST: m718, Check Region Fields specified as (DWordAcc, NoLock, WriteAsZeros)"
        M72F (Arg0, 0x01, "pp08", PP08)
    }

    /* Check common access: QWordAcc, NoLock, Preserve */
    /* m719(CallChain) */
    /* CallChain: String */
    Method (M719, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m719", Arg0)
        Debug = "TEST: m719, Check Region Fields specified as (QWordAcc, NoLock, Preserve)"
        M72F (Arg0, 0x01, "pp09", PP09)
    }

    /* Check common access: QWordAcc, NoLock, WriteAsOnes */
    /* m71a(CallChain) */
    /* CallChain: String */
    Method (M71A, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71a", Arg0)
        Debug = "TEST: m71a, Check Region Fields specified as (QWordAcc, NoLock, WriteAsOnes)"
        M72F (Arg0, 0x01, "pp0a", PP0A)
    }

    /* Check common access: QWordAcc, NoLock, WriteAsZeros */
    /* m71b(CallChain) */
    /* CallChain: String */
    Method (M71B, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71b", Arg0)
        Debug = "TEST: m71b, Check Region Fields specified as (QWordAcc, NoLock, WriteAsZeros)"
        M72F (Arg0, 0x01, "pp0b", PP0B)
    }

    /* Check common access: AnyAcc, NoLock, Preserve */
    /* m71c(CallChain) */
    /* CallChain: String */
    Method (M71C, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71c", Arg0)
        Debug = "TEST: m71c, Check Region Fields specified as (AnyAcc, NoLock, Preserve)"
        M72F (Arg0, 0x01, "pp0c", PP0C)
    }

    /* Check common access: AnyAcc, NoLock, WriteAsOnes */
    /* m71d(CallChain) */
    /* CallChain: String */
    Method (M71D, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71d", Arg0)
        Debug = "TEST: m71d, Check Region Fields specified as (AnyAcc, NoLock, WriteAsOnes)"
        M72F (Arg0, 0x01, "pp0d", PP0D)
    }

    /* Check common access: AnyAcc, Lock, WriteAsZeros */
    /* m71e(CallChain) */
    /* CallChain: String */
    Method (M71E, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71e", Arg0)
        Debug = "TEST: m71e, Check Region Fields specified as (AnyAcc, Lock, WriteAsZeros)"
        M72F (Arg0, 0x01, "pp0e", PP0E)
    }

    /* Check BufferAcc access for SMBus */
    /* m71f(CallChain) */
    /* CallChain: String */
    Method (M71F, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m71f", Arg0)
        Debug = "TEST: m71f, Check SMBus Region Fields (BufferAcc access)"
        /*
         * Examples from Acpi Spec (chapter 13.7 Using the SMBus Protocols)
         */
        /* Read/Write Quick (SMBQuick) */
        M751 (Arg0)
        /* Send/Receive Byte (SMBSendReceive) */

        M752 (Arg0)
        /* Read/Write Byte (SMBByte) */

        M753 (Arg0)
        /* Read/Write Word (SMBWord) */

        M754 (Arg0)
        /* Read/Write Block (SMBBlock) */

        M755 (Arg0)
        /* Word Process Call (SMBProcessCall) */

        M756 (Arg0)
        /* Block Process Call (SMBBlockProcessCall) */

        M757 (Arg0)
    }

    /* Read/Write Quick (SMBQuick) */
    /* m751(CallChain) */
    /* CallChain: String */
    Method (M751, 1, Serialized)
    {
        Concatenate (Arg0, "-m751", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribQuick),
            FLD0,   8
        }                        /* Virtual register at command value 0. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateByteField (BUFF, 0x02, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateByteField (BUFR, 0x02, DAT1)

        /* Signal device (e.g. ON) */

        BUFR = FLD0 = BUFF /* \M751.BUFF */      /* Invoke Write Quick transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x00)
        }

        If ((DAT0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0x00)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x00)
        }

        OB10 = 0x00
        LEN0 = 0xFF
        DAT0 = 0x00

        /* Signal device (e.g. OFF) */

        BUFF = FLD0                   /* Invoke Read Quick transaction */ /* \M751.FLD0 */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x00))
        {
            /* Length is zero for Quick operations */

            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x00)
        }
        /* Note: Since LEN0 should be zero there's no need to check DAT0 */
    }

    /* AttribSendReceive */
    /* m752(CallChain) */
    /* CallChain: String */
    Method (M752, 1, Serialized)
    {
        Concatenate (Arg0, "-m752", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribSendReceive),
            FLD0,   8
        }                            /* Virtual register at command value 0. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateByteField (BUFF, 0x02, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateByteField (BUFR, 0x02, DAT1)

        /* Send the byte '0x16' to the device */

        OB10 = 0x00
        LEN0 = 0x01
        DAT0 = 0x16                   /* Save 0x16 into the data buffer */
        BUFR = FLD0 = BUFF /* \M752.BUFF */      /* Invoke a Send Byte transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x01)
        }

        If ((DAT0 != 0x16))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0x16)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x01)
        }

        If ((DAT1 != 0xA0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA0)
        }

        /* Receive a byte of data from the device */

        BUFF = FLD0                   /* Invoke a Receive Byte transaction */ /* \M752.FLD0 */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x01)
        }

        If ((DAT0 != 0xA0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0xA0)
        }
    }

    /* Read/Write Byte (SMBByte) */
    /* m753(CallChain) */
    /* CallChain: String */
    Method (M753, 1, Serialized)
    {
        Concatenate (Arg0, "-m753", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribByte),
            FLD0,                        /* Virtual register at command value 0. */   8,
            FLD1,                        /* Virtual register at command value 1. */   8,
            FLD2,   8
        }                        /* Virtual register at command value 2. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateByteField (BUFF, 0x02, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateByteField (BUFR, 0x02, DAT1)
        /* Write the byte '0x16' to the device using command value 2 */

        OB10 = 0x00
        LEN0 = 0x01
        DAT0 = 0x16                   /* Save 0x16 into the data buffer */
        BUFR = FLD2 = BUFF /* \M753.BUFF */      /* Invoke a Write Byte transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x01)
        }

        If ((DAT0 != 0x16))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0x16)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x01)
        }

        If ((DAT1 != 0xA0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA0)
        }

        /* Read a byte of data from the device using command value 1 */

        BUFF = FLD1                   /* Invoke a Read Byte transaction */ /* \M753.FLD1 */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x01)
        }

        If ((DAT0 != 0xA0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0xA0)
        }
    }

    /* Read/Write Word (SMBWord) */
    /* m754(CallChain) */
    /* CallChain: String */
    Method (M754, 1, Serialized)
    {
        Concatenate (Arg0, "-m754", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribWord),
            FLD0,                        /* Virtual register at command value 0. */   8,
            FLD1,                        /* Virtual register at command value 1. */   8,
            FLD2,   8
        }                        /* Virtual register at command value 2. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateWordField (BUFF, 0x02, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateWordField (BUFR, 0x02, DAT1)
        /* Write the word '0x5416' to the device using command value 2 */

        OB10 = 0x00
        LEN0 = 0x00
        DAT0 = 0x5416                 /* Save 0x5416 into the data buffer */
        BUFR = FLD2 = BUFF /* \M754.BUFF */      /* Invoke a Write Word transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x00)
        }

        If ((DAT0 != 0x5416))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0x5416)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x02))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x02)
        }

        If ((DAT1 != 0xA1A0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA1A0)
        }

        /* Read two bytes of data from the device using command value 1 */

        BUFF = FLD1                   /* Invoke a Read Word transaction */ /* \M754.FLD1 */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x02))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x02)
        }

        If ((DAT0 != 0xA1A0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0xA1A0)
        }
    }

    /* Read/Write Block (SMBBlock) */
    /* m755(CallChain) */
    /* CallChain: String */
    Method (M755, 1, Serialized)
    {
        Concatenate (Arg0, "-m755", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribBlock),
            FLD0,                        /* Virtual register at command value 0. */   8,
            FLD1,                        /* Virtual register at command value 1. */   8,
            FLD2,   8
        }                        /* Virtual register at command value 2. */

        /* Create the SMBus data buffer */

        Name (BUF1, Buffer (24){})              /* Create SMBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateField (BUF1, 0x10, 0x0080, DAT1)

        // Read block of data from the device using command value 0

        BUF1 = FLD0
        Printf ("AttribBlock, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }

        // Perform write-then-read

        STA1 = 0x00
        LEN1 = 16
        DAT1 = Buffer() {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16}
        Printf ("AttribBlock, sent:     %o", BUF1)

        BUF1 = FLD2 = BUF1 /* \M75C.BUF1 */        /* Invoke a Send Byte transaction */
        Printf ("AttribBlock, received: %o", BUF1)
    }

    /* Word Process Call (SMBProcessCall) */
    /* m756(CallChain) */
    /* CallChain: String */
    Method (M756, 1, Serialized)
    {
        Concatenate (Arg0, "-m756", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribProcessCall),
            FLD0,                        /* Virtual register at command value 0. */   8,
            FLD1,                        /* Virtual register at command value 1. */   8,
            FLD2,   8
        }                        /* Virtual register at command value 2. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateWordField (BUFF, 0x02, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateWordField (BUFR, 0x02, DAT1)

        /* Process Call with input value '0x5416' to the device using command value 1 */

        OB10 = 0x00
        LEN0 = 0x00
        DAT0 = 0x5416                 /* Save 0x5416 into the data buffer */
        BUFR = FLD1 = BUFF /* \M756.BUFF */      /* Invoke a Process Call transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x00)
        }

        If ((DAT0 != 0x5416))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, 0x16)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x02))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x02)
        }

        If ((DAT1 != 0xA1A0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA1A0)
        }
    }

    /* Block Process Call (SMBBlockProcessCall) */
    /* m757(CallChain) */
    /* CallChain: String */
    Method (M757, 1, Serialized)
    {
        Concatenate (Arg0, "-m757", Arg0)
        OperationRegion (SMBD, SMBus, 0x4200, 0x0100)
        Field (SMBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribBlockProcessCall),
            FLD0,                        /* Virtual register at command value 0. */   8,
            FLD1,   8
        }                        /* Virtual register at command value 1. */

        /* Create the SMBus data buffer */

        Name (BUFF, Buffer (0x22){})            /* Create SMBus data buffer as BUFF */
        Name (BUFR, Buffer (0x22){})            /* Create SMBus result buffer */
        CreateByteField (BUFF, 0x00, OB10)   /* Status (Byte) */
        CreateByteField (BUFF, 0x01, LEN0)   /* Length (Byte) */
        CreateField (BUFF, 0x10, 0x0100, DAT0)

        CreateByteField (BUFR, 0x00, OB11)
        CreateByteField (BUFR, 0x01, LEN1)
        CreateField (BUFR, 0x10, 0x0100, DAT1)

        /* Process Call with input value "TEST" to the device using command value 1 */

        OB10 = 0x00
        LEN0 = 0x04
        DAT0 = "TEST"                 /* Save 'TEST' into the data buffer */
        BUFR = FLD1 = BUFF /* \M757.BUFF */      /* Invoke a Write Block transaction */
        If ((OB10 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB10, 0x00)
        }

        If ((LEN0 != 0x04))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x04)
        }

        Local0 = Buffer (0x20)
            {
                "TEST"
            }
        If ((DAT0 != Local0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, Local0)
        }

        If ((OB11 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, OB11, 0x00)
        }

        If ((LEN1 != 0x20))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x20)
        }

        Local1 = Buffer (0x20)
            {
                /* 0000 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 0008 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 0010 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 0018 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF   // ........
            }
        If ((DAT1 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, Local1)
        }
    }

    /***** GenericSerialBus (ACPI 5.0) - similar to SMBUS **************************** */

    Device (\GSB1)
    {
    }

    /* Check BufferAcc access for GenericSerialBus */
    /* m740(CallChain) */
    /* CallChain: String */
    Method (M740, 1, NotSerialized)
    {
        Concatenate (Arg0, "-m740", Arg0)
        Debug = "TEST: m740, Check GenericSerialBus Region Fields (BufferAcc access)"
        /*
         * Examples from Acpi Spec (Using the GenericSerialBus Protocols)
         */
        /* Read/Write Quick (AttribQuick) */
        M758 (Arg0)

        /* Send/Receive Byte (AttribSendReceive) */
        M759 (Arg0)

        /* Read/Write Byte (AttribByte) */
        M75A (Arg0)

        /* Read/Write Word (AttribWord) */
        M75B (Arg0)

        /* Read/Write Block (AttribBlock) */
        M75C (Arg0)

        /* Word Process Call (AttribProcessCall) */
        M75D (Arg0)

        /* Block Process Call (AttribBlockProcessCall) */
        M75E (Arg0)

        /* Next 3 types are exclusive to the GenericSerialBus */
        /* Read/Write N Bytes (AttribBytes) */
        M75F (Arg0)

        /* Raw Read/Write N Bytes (AttribRawBytes) */
        M760 (Arg0)

        /* Raw Process Call (AttribRawProcessBytes) */
        M761 (Arg0)
    }

    /* Read/Write Quick (AttribQuick) */
    /* m758(CallChain) */
    /* CallChain: String */
    Method (M758, 1, Serialized)
    {
        Concatenate (Arg0, "-m758", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x4400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribQuick),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8   /* Virtual register at command value 0. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (2){})               /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */

        /* Signal device (e.g. OFF) */

        BUF0 = FLD0 /* \M758.BUF0 */            /* Invoke Read Quick transaction */
        Printf ("AttribQuick, received: %o", BUF0)

        If ((STA0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA0, 0x00)
        }

        /* Signal device (e.g. ON) */

        LEN0 = 0
        FLD0 = BUF0                             /* Invoke Write Quick transaction */
        Printf ("AttribQuick, sent:     %o", BUF0)
    }

    /* AttribSendReceive */
    /* m759(CallChain) */
    /* CallChain: String */
    Method (M759, 1, Serialized)
    {
        Concatenate (Arg0, "-m759", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x5400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribSendReceive),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8                           /* Virtual register at command value 0. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (3){})               /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateByteField (BUF0, 0x02, DAT0)

        Name (BUF1, Buffer (3){})               /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateByteField (BUF1, 0x02, DAT1)

        /* Receive a byte of data from the device */

        BUF1 = FLD0
        Printf ("AttribSendReceive, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
        If ((LEN1 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x01)
        }
        If ((DAT1 != 0xA0))                 /* 0xA0 is from AcpiExec */
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA0)
        }

        /* Send the byte '0x16' to the device */

        STA0 = 0x00
        LEN0 = 0x01
        DAT0 = 0x16                         /* Save 0x16 into the data buffer */
        FLD0 = BUF0 /* \M759.BUF0 */        /* Invoke a Send Byte transaction */
        Printf ("AttribSendReceive, sent:     %o", BUF0)
    }

    /* Read/Write Byte (AttribByte) */
    /* m75a(CallChain) */
    /* CallChain: String */
    Method (M75A, 1, Serialized)
    {
        Concatenate (Arg0, "-m75a", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x6400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribByte),
            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                      /* Virtual register at command value 0. */
            FLD1,   8,                      /* Virtual register at command value 1. */
            FLD2,   8                       /* Virtual register at command value 2. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF1, Buffer (3){})           /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateByteField (BUF1, 0x02, DAT1)

        /* Receive a byte of data from the device, command value 1 */

        BUF1 = FLD1
        Printf ("AttribByte, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
        If ((LEN1 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x01)
        }
        If ((DAT1 != 0xA0))                 /* 0xA0 is from AcpiExec */
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA0)
        }

        /* Send the byte '0x16' to the device, command value 2 */

        STA1 = 0x00
        LEN1 = 0x01
        DAT1 = 0x16                         /* Save 0x16 into the data buffer */
        FLD2 = BUF1 /* \M75A.BUF1 */        /* Invoke a Send Byte transaction */
        Printf ("AttribByte, sent:     %o", BUF1)
    }

    /* Read/Write Word (AttribWord) */
    /* m75b(CallChain) */
    /* CallChain: String */
    Method (M75B, 1, Serialized)
    {
        Concatenate (Arg0, "-m75b", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x7400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribWord),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                      /* Virtual register at command value 0. */
            FLD1,   8,                      /* Virtual register at command value 1. */
            FLD2,   8                       /* Virtual register at command value 2. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF1, Buffer (4){})           /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateWordField (BUF1, 0x02, DAT1)

        /* Receive a word of data from the device, command value 1 */

        BUF1 = FLD1
        Printf ("AttribWord, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
        If ((LEN1 != 0x02))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x02)
        }
        If ((DAT1 != 0xA1A0))               /* 0xA1A0 is from AcpiExec */
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, 0xA1A0)
        }

        /* Send the word '0x5678' to the device, command value 2 */

        STA1 = 0x00
        LEN1 = 0x02
        DAT1 = 0x5678                       /* Save 0x16 into the data buffer */
        FLD2 = BUF1 /* \M75B.BUF1 */        /* Invoke a Send Byte transaction */
        Printf ("AttribWord, sent:     %o", BUF1)
    }

    /* Read/Write Block (AttribBlock) */
    /* m75c(CallChain) */
    /* CallChain: String */
    Method (M75C, 1, Serialized)
    {
        Concatenate (Arg0, "-m75c", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x8400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribBlock),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8,                          /* Virtual register at command value 1. */
            FLD2,   8                           /* Virtual register at command value 2. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF1, Buffer (24){})              /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateField (BUF1, 0x10, 0x0080, DAT1)

        // Read block of data from the device using command value 0

        BUF1 = FLD0
        Printf ("AttribBlock, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }

        // Perform write-then-read

        STA1 = 0x00
        LEN1 = 16
        DAT1 = Buffer() {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16}
        Printf ("AttribBlock, sent:     %o", BUF1)

        BUF1 = FLD2 = BUF1 /* \M75C.BUF1 */        /* Invoke a Send Byte transaction */
        Printf ("AttribBlock, received: %o", BUF1)
    }

    /* Word Process Call (AttribProcessCall) */
    /* m75d(CallChain) */
    /* CallChain: String */
    Method (M75D, 1, Serialized)
    {
        Concatenate (Arg0, "-m75d", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0x9400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribProcessCall),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8,                          /* Virtual register at command value 1. */
            FLD2,   8                           /* Virtual register at command value 2. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (4){})               /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateWordField (BUF0, 0x02, DAT0)

        Name (BUF1, Buffer (0){})               /* Create GenericSerialBus result buffer */

        /* Process Call with input value '0x5416' to the device using command value 1 */

        STA0 = 0x00
        LEN0 = 0x02
        DAT0 = 0x5416                           /* Save 0x5416 into the data buffer */
        Printf ("AttribProcessCall, sent:     %o", BUF0)

        BUF1 = FLD1 = BUF0 /* \M75D.BUF0 */     /* Invoke a Process Call transaction */
        Printf ("AttribProcessCall, received: %o", BUF1)

        /* Now that BUF1 is valid, can create fields within it */

        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateWordField (BUF1, 0x02, DAT1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
    }

    /* Block Process Call (AttribBlockProcessCall) */
    /* m75e(CallChain) */
    /* CallChain: String */
    Method (M75E, 1, Serialized)
    {
        Concatenate (Arg0, "-m75e", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0xA400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            AccessAs (BufferAcc, AttribBlockProcessCall),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8                           /* Virtual register at command value 1. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (8){})               /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateField (BUF0, 0x10, 32, DAT0)

        Name (BUF1, Buffer (0x14){})            /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateField (BUF1, 0x10, 32, DAT1)

        /* Process Call with input value "TEST" to the device using command value 1 */

        STA0 = 0x00
        LEN0 = 0x04
        DAT0 = "TEST"                           /* Save 'TEST' into the data buffer */
        Printf ("AttribBlockProcessCall, sent:     %o", BUF0)

        BUF1 = FLD1 = BUF0 /* \M75E.BUF0 */     /* Invoke a Write Block transaction */
        Printf ("AttribBlockProcessCall, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
        If ((LEN1 != 0x20))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x20)
        }

        Local0 = Buffer (0x4)
            {
                0x54, 0x45, 0x53, 0x54 //"TEST"
            }
        If ((DAT0 != Local0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, Local0)
        }
    }

    /* Read/Write N Bytes (AttribBytes) */
    /* m75f(CallChain) */
    /* CallChain: String */
    Method (M75F, 1, Serialized)
    {
        Concatenate (Arg0, "-m75f", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0xB400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            /*
             * Note: AccessLength for AttribBytes here must at least 2 less than the
             * transfer buffer to account for the status and length bytes
             */
            AccessAs (BufferAcc, AttribBytes (0x22)),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8                           /* Virtual register at command value 1. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (0x22){})            /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateField (BUF0, 0x10, 0x0100, DAT0)

        Name (BUF1, Buffer (0x22){})            /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateField (BUF1, 0x10, 0x0100, DAT1)

        /* Read buffer from FLD0 */

        BUF0 = FLD0
        Printf ("AttribBytes, received: %o", BUF0)

        If ((STA0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA0, 0x00)
        }
        If ((LEN0 != 0x20)) /* Size of BUF0 */
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x20)
        }

        /* WRITE then READ to FLD1  (Force READ by not using double store) */

        FLD1 = BUF0
        BUF1 = FLD1
        Printf ("AttribBytes, sent:     %o", BUF0)
        Printf ("AttribBytes, received: %o", BUF1)

        If ((STA1 != 0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0)
        }
        If ((LEN1 != 0x20))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x20)
        }

        Local1 = Buffer (0x20)
            {
                /* 0000 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 0008 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 0010 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 0018 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF   // ........
            }

        If ((DAT0 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, Local1)
        }
        If ((DAT0 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, Local1)
        }
    }

    /* Raw Read/Write N Bytes (AttribRawBytes) */
    /* m760(CallChain) */
    /* CallChain: String */
    Method (M760, 1, Serialized)
    {
        Concatenate (Arg0, "-m760", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0xB400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            /*
             * Note: AccessLength for AttribBytes here must at least 2 less than the
             * transfer buffer to account for the status and length bytes
             */
            AccessAs (BufferAcc, AttribRawBytes (0x22)),
            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8                           /* Virtual register at command value 1. */
        }

        /* Create the GenericSerialBus data buffer */

        Name (BUF0, Buffer (0x22){})            /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateField (BUF0, 0x10, 0x0100, DAT0)

        Name (BUF1, Buffer (0x22){})            /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateField (BUF1, 0x10, 0x0100, DAT1)

        /* Read buffer from FLD0 */

        BUF0 = FLD0
        Printf ("AttribRawBytes, received: %o", BUF0)

        If ((STA0 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA0, 0x00)
        }
        If ((LEN0 != 0x20)) /* Size of BUF0 */
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN0, 0x20)
        }

        /* WRITE then READ to FLD1  (Force READ by not using double store) */

        FLD1 = BUF0
        BUF1 = FLD1
        Printf ("AttribRawBytes, sent:     %o", BUF0)
        Printf ("AttribRawBytes, received: %o", BUF1)

        If ((STA1 != 0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0)
        }
        If ((LEN1 != 0x20))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x20)
        }

        Local1 = Buffer (0x20)
            {
                /* 0000 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 0008 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 0010 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 0018 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF   // ........
            }

        If ((DAT0 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, Local1)
        }
        If ((DAT0 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, Local1)
        }
    }

    /* Raw Process Call (AttribRawProcessBytes) */
    /* m761(CallChain) */
    /* CallChain: String */
    Method (M761, 1, Serialized)
    {
        Concatenate (Arg0, "-m761", Arg0)
        OperationRegion (GSBD, GenericSerialBus, 0xB400, 0x0100)
        Field (GSBD, BufferAcc, NoLock, Preserve)
        {
            /*
             * Note: AccessLength for AttribBytes here must at least 2 less than the
             * transfer buffer to account for the status and length bytes
             */
            AccessAs (BufferAcc, AttribRawProcessBytes (0x20)),

            /* A Connection is required */

            Connection (
                I2cSerialBusV2 (0x1234, DeviceInitiated, 0x88775544,
                    AddressingMode10Bit, "\\GPI1",
                    0xEE, ResourceConsumer, , Exclusive,
                    )
            ),
            FLD0,   8,                          /* Virtual register at command value 0. */
            FLD1,   8                           /* Virtual register at command value 1. */
        }

        /* Create the GenericSerialBus data buffers */

        Name (BUF0, Buffer (0x22){})            /* Create GenericSerialBus data buffer as BUF0 */
        CreateByteField (BUF0, 0x00, STA0)      /* Status (Byte) */
        CreateByteField (BUF0, 0x01, LEN0)      /* Length (Byte) */
        CreateWordField(BUF0, 0x02, CMD0)       // Command (Bytes 2 and 3)
        CreateField (BUF0, 0x10, 0x0100, DAT0)

        Name (BUF1, Buffer (0x22){})            /* Create GenericSerialBus result buffer */
        CreateByteField (BUF1, 0x00, STA1)
        CreateByteField (BUF1, 0x01, LEN1)
        CreateWordField(BUF1, 0x02, CMD1)       // Command (Bytes 2 and 3)
        CreateField (BUF1, 0x10, 0x0100, DAT1)

        /* Process Call with input value "TEST" to the device using command value 1 */

        STA0 = 0x00
        LEN0 = 0x08
        DAT0 = "TEST"                           /* Save 'TEST' into the data buffer */

        BUF1 = FLD1 = BUF0 /* \M761.BUF0 */     /* Invoke a Write Block transaction */
        Printf ("AttribRawProcessBytes, sent:     %o", BUF0)
        Printf ("AttribRawProcessBytes, received: %o", BUF1)

        If ((STA1 != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STA1, 0x00)
        }
        If ((LEN1 != 0x20))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, LEN1, 0x20)
        }

        Local0 = Buffer (0x20)
            {
                "TEST"
            }

        If ((DAT0 != Local0))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT0, Local0)
        }

        Local1 = Buffer (0x20)
            {
                /* 0000 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 0008 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 0010 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 0018 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF   // ........
            }

        If ((DAT1 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, DAT1, Local1)
        }
    }

    /***** GeneralPurposeIo (ACPI 5.0) ************************************** */
    /* */
    /* Test the use of Connection() operator and simple ByteAcc */
    /* */
    Method (M764, 1, Serialized)
    {
        Concatenate (Arg0, "-m764", Arg0)
        Debug = "TEST: m764, Check GeneralPurposeIo Region Fields (ByteAcc access required)"
        /*...Other required stuff for this device */

        Name (GMOD, ResourceTemplate ()
        {
            GpioIo (Exclusive, PullDown, 0x0000, 0x0000, IoRestrictionNone,
                "\\_SB.GPI2", 0x00, ResourceConsumer, ,
                )
                {
                    0x000A,
                    0x000C
                }
        })
        /* Offset is ignored (From ACPI spec) */

        OperationRegion (GPO2, GeneralPurposeIo, 0x00, 0x40)
        Method (_REG, 2, NotSerialized)  // _REG: Region Availability
        {
        }

        Name (_DEP, Package (0x01)  // _DEP: Dependencies
        {
            \_SB
        })
        /* Update rule must be Preserve */

        Field (GPO2, ByteAcc, NoLock, Preserve)
        {
            Connection (GMOD),       /* Reuse an existing connection (defined above) */
            MODE,                /* Power Mode */   2,
            Connection (
                GpioIo (Exclusive, PullUp, 0x0000, 0x0000, IoRestrictionNone,
                    "\\_SB.GPI2", 0x00, ResourceConsumer, ,
                    )
                    {
                        0x0007
                    }
            ),
            STAT,                /* e.g. Status signal from the device */   1,
            Connection (
                GpioIo (Exclusive, PullUp, 0x0000, 0x0000, IoRestrictionNone,
                    "\\_SB.GPI2", 0x00, ResourceConsumer, ,
                    )
                    {
                        0x0009
                    }
            ),
            RSET,                 /* e.g. Reset signal to the device */   1,
            Offset (0x20),
            BUFF,   128
        }

        MODE = 0x03
        Local0 = MODE /* \M764.MODE */
        If ((Local0 != 0x03))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local0, 0x03)
        }

        MODE = 0x01
        Local0 = MODE /* \M764.MODE */
        If ((Local0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local0, 0x01)
        }

        STAT = 0x01
        Local0 = STAT /* \M764.STAT */
        If ((Local0 != 0x01))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local0, 0x01)
        }

// August 2018:
// Use of Buffer objects with GeneralPurposeIo is disallowed, since it doesn't
// really make sense. Test removed.
//
//        Name (TBUF, Buffer (0x10)
//        {
//            0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
//            0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF
//        })
//        BUFF = TBUF
//        Local0 = BUFF
//        If ((Local0 != TBUF))
//        {
//            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local0, TBUF)
//        }
    }

    /***** IPMI (ACPI 4.0) - bidirectional buffer **************************** */

    Method (M768, 1, Serialized)
    {
        Concatenate (Arg0, "-m768", Arg0)
        Debug = "TEST: m768, Check IPMI Region Fields (BufferAcc access)"
        OperationRegion (POWR, IPMI, 0x3000, 0x0100) /* Power network function */
        Field (POWR, BufferAcc, NoLock, Preserve)
        {
            Offset (0xC1),
            SPWL,        /* Set power limit [command value 0xC1] */   8,
            GPWL,        /* Get power limit [command value 0xC2] */   8,
            Offset (0xC8),
            GPMM,         /* Get power meter measurement [command value 0xC8] */   8
        }

        /* Create the IPMI data buffer - ALWAYS 66 bytes */

        Name (BUFF, Buffer (0x42){})            /* Create IPMI data buffer as BUFF */
        CreateByteField (BUFF, 0x00, STAT)   /* STAT = Status (Byte) */
        CreateByteField (BUFF, 0x01, LENG)   /* LENG = Length (Byte) */
        CreateByteField (BUFF, 0x02, MODE)   /* MODE = Mode (Byte) */
        CreateByteField (BUFF, 0x03, RESV)   /* RESV = Reserved (Byte) */
        LENG = 0x02                    /* Request message is 2 bytes long */
        MODE = 0x01                    /* Set Mode to 1 */
        BUFF = GPMM = BUFF /* \M768.BUFF */      /* Write the request into the GPMM command, */
        /* then read the results */

        CreateByteField (BUFF, 0x02, CMPC)   /* CMPC = Completion code (Byte) */
        CreateWordField (BUFF, 0x03, RSVD)   /* Reserved */
        /* Buffer expected back from ACPIEXEC utility */

        Local1 = Buffer (0x42)
            {
                /* 0000 */  0x00, 0x40, 0x00, 0x00, 0x04, 0x05, 0x06, 0x07,  // .@......
                /* 0008 */  0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,  // ........
                /* 0010 */  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,  // ........
                /* 0018 */  0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,  // ........
                /* 0020 */  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,  //  !"#$%&'
                /* 0028 */  0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,  // ()*+,-./
                /* 0030 */  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  // 01234567
                /* 0038 */  0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,  // 89:;<=>?
                /* 0040 */  0x40, 0x41                                       // @A
            }
        If ((STAT != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, STAT, 0x00)
        }

        If ((CMPC != 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, CMPC, 0x00)
        }

        If ((BUFF != Local1))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local1, BUFF)
        }
    }

    /* Splitting of Fields */
    /* m742(CallChain) */
    Method (M742, 1, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, 0x0257)
        Concatenate (Arg0, "-m742", Arg0)
        Debug = "TEST: m742, Check Splitting of Fields"
        M720 (Arg0, OPR0)
        M721 (Arg0, OPR0)
        M722 (Arg0, OPR0)
        M723 (Arg0, OPR0)
        M724 (Arg0, OPR0)
        M725 (Arg0, OPR0)
        M726 (Arg0, OPR0)
        M727 (Arg0, OPR0)
        M728 (Arg0, OPR0)
        M729 (Arg0, OPR0)
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 0-bit offset. */
    /* m720(CallChain, OpRegion) */
    Method (M720, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m720", Arg0)
        CopyObject (Arg1, OPRM) /* \M720.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x00),
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x00),
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x00),
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x00),
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M720.FU10 */
                Local1 [0x01] = FU11 /* \M720.FU11 */
                Local1 [0x02] = FU12 /* \M720.FU12 */
                Local1 [0x03] = FU20 /* \M720.FU20 */
                Local1 [0x04] = FU21 /* \M720.FU21 */
                Local1 [0x05] = FU30 /* \M720.FU30 */
                Local1 [0x06] = FU31 /* \M720.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 1-bit offset. */
    /* m721(CallChain, OpRegion) */
    Method (M721, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m721", Arg0)
        CopyObject (Arg1, OPRM) /* \M721.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   1,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   1,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   1,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   1,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M721.FU10 */
                Local1 [0x01] = FU11 /* \M721.FU11 */
                Local1 [0x02] = FU12 /* \M721.FU12 */
                Local1 [0x03] = FU20 /* \M721.FU20 */
                Local1 [0x04] = FU21 /* \M721.FU21 */
                Local1 [0x05] = FU30 /* \M721.FU30 */
                Local1 [0x06] = FU31 /* \M721.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 2-bit offset. */
    /* m722(CallChain, OpRegion) */
    Method (M722, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m722", Arg0)
        CopyObject (Arg1, OPRM) /* \M722.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M722.FU10 */
                Local1 [0x01] = FU11 /* \M722.FU11 */
                Local1 [0x02] = FU12 /* \M722.FU12 */
                Local1 [0x03] = FU20 /* \M722.FU20 */
                Local1 [0x04] = FU21 /* \M722.FU21 */
                Local1 [0x05] = FU30 /* \M722.FU30 */
                Local1 [0x06] = FU31 /* \M722.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 3-bit offset. */
    /* m723(CallChain, OpRegion) */
    Method (M723, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m723", Arg0)
        CopyObject (Arg1, OPRM) /* \M723.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   3,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   3,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   3,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   3,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M723.FU10 */
                Local1 [0x01] = FU11 /* \M723.FU11 */
                Local1 [0x02] = FU12 /* \M723.FU12 */
                Local1 [0x03] = FU20 /* \M723.FU20 */
                Local1 [0x04] = FU21 /* \M723.FU21 */
                Local1 [0x05] = FU30 /* \M723.FU30 */
                Local1 [0x06] = FU31 /* \M723.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 4-bit offset. */
    /* m724(CallChain, OpRegion) */
    Method (M724, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m724", Arg0)
        CopyObject (Arg1, OPRM) /* \M724.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   4,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   4,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   4,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   4,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M724.FU10 */
                Local1 [0x01] = FU11 /* \M724.FU11 */
                Local1 [0x02] = FU12 /* \M724.FU12 */
                Local1 [0x03] = FU20 /* \M724.FU20 */
                Local1 [0x04] = FU21 /* \M724.FU21 */
                Local1 [0x05] = FU30 /* \M724.FU30 */
                Local1 [0x06] = FU31 /* \M724.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 5-bit offset. */
    /* m725(CallChain, OpRegion) */
    Method (M725, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m725", Arg0)
        CopyObject (Arg1, OPRM) /* \M725.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   5,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   5,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   5,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   5,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M725.FU10 */
                Local1 [0x01] = FU11 /* \M725.FU11 */
                Local1 [0x02] = FU12 /* \M725.FU12 */
                Local1 [0x03] = FU20 /* \M725.FU20 */
                Local1 [0x04] = FU21 /* \M725.FU21 */
                Local1 [0x05] = FU30 /* \M725.FU30 */
                Local1 [0x06] = FU31 /* \M725.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 6-bit offset. */
    /* m726(CallChain, OpRegion) */
    Method (M726, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m726", Arg0)
        CopyObject (Arg1, OPRM) /* \M726.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   6,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   6,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   6,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   6,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M726.FU10 */
                Local1 [0x01] = FU11 /* \M726.FU11 */
                Local1 [0x02] = FU12 /* \M726.FU12 */
                Local1 [0x03] = FU20 /* \M726.FU20 */
                Local1 [0x04] = FU21 /* \M726.FU21 */
                Local1 [0x05] = FU30 /* \M726.FU30 */
                Local1 [0x06] = FU31 /* \M726.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 7-bit offset. */
    /* m727(CallChain, OpRegion) */
    Method (M727, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m727", Arg0)
        CopyObject (Arg1, OPRM) /* \M727.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   7,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   7,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   7,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   7,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M727.FU10 */
                Local1 [0x01] = FU11 /* \M727.FU11 */
                Local1 [0x02] = FU12 /* \M727.FU12 */
                Local1 [0x03] = FU20 /* \M727.FU20 */
                Local1 [0x04] = FU21 /* \M727.FU21 */
                Local1 [0x05] = FU30 /* \M727.FU30 */
                Local1 [0x06] = FU31 /* \M727.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 8-bit offset. */
    /* m728(CallChain, OpRegion) */
    Method (M728, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m728", Arg0)
        CopyObject (Arg1, OPRM) /* \M728.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x01),
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x01),
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x01),
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
            Offset (0x01),
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M728.FU10 */
                Local1 [0x01] = FU11 /* \M728.FU11 */
                Local1 [0x02] = FU12 /* \M728.FU12 */
                Local1 [0x03] = FU20 /* \M728.FU20 */
                Local1 [0x04] = FU21 /* \M728.FU21 */
                Local1 [0x05] = FU30 /* \M728.FU30 */
                Local1 [0x06] = FU31 /* \M728.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Create Region Fields that spans the same bits */
    /* and check possible inconsistence, 2046-bit offset. */
    /* m729(CallChain, OpRegion) */
    Method (M729, 2, Serialized)
    {
        OperationRegion (OPRM, 0xFF, 0x00, 0x1000)
        Concatenate (Arg0, "-m729", Arg0)
        CopyObject (Arg1, OPRM) /* \M729.OPRM */
        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2046,
            FU00,   3
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2046,
            FU10,   1,
            FU11,   1,
            FU12,   1
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2046,
            FU20,   1,
            FU21,   2
        }

        Field (OPRM, ByteAcc, NoLock, Preserve)
        {
                ,   2046,
            FU30,   2,
            FU31,   1
        }

        Local0 = 0x08
        Local1 = Package (0x07)
            {
                FU10,
                FU11,
                FU12,
                FU20,
                FU21,
                FU30,
                FU31
            }
        While (Local0)
        {
            Local0--
            FU00 = Local0
            If (Y118){}
            Else
            {
                Local1 [0x00] = FU10 /* \M729.FU10 */
                Local1 [0x01] = FU11 /* \M729.FU11 */
                Local1 [0x02] = FU12 /* \M729.FU12 */
                Local1 [0x03] = FU20 /* \M729.FU20 */
                Local1 [0x04] = FU21 /* \M729.FU21 */
                Local1 [0x05] = FU30 /* \M729.FU30 */
                Local1 [0x06] = FU31 /* \M729.FU31 */
            }

            M72A (Arg0, Local0, Local1)
        }
    }

    /* Supports bunch of m720-m729 methods */
    /* checking splitting fields */
    /* m72a(CallChain, CheckInt, FieldsPkg) */
    Method (M72A, 3, NotSerialized)
    {
        Concatenate (Arg0, "-m72a", Arg0)
        Local3 = Arg1
        Local0 = ((Local3 >> 0x00) & 0x01)
        Local1 = ((Local3 >> 0x01) & 0x01)
        Local2 = ((Local3 >> 0x02) & 0x01)
        /* 1-1-1 */

        Local4 = DerefOf (Arg2 [0x00])
        If ((Local4 != Local0))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local0)
        }

        Local4 = DerefOf (Arg2 [0x01])
        If ((Local4 != Local1))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local1)
        }

        Local4 = DerefOf (Arg2 [0x02])
        If ((Local4 != Local2))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local2)
        }

        /* 1-2 */

        Local4 = DerefOf (Arg2 [0x03])
        If ((Local4 != Local0))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local0)
        }

        Local4 = DerefOf (Arg2 [0x04])
        Local5 = (Local1 | (Local2 << 0x01))
        If ((Local4 != Local5))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local5)
        }

        /* 2-1 */

        Local4 = DerefOf (Arg2 [0x05])
        Local5 = (Local0 | (Local1 << 0x01))
        If ((Local4 != Local5))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local5)
        }

        Local4 = DerefOf (Arg2 [0x06])
        If ((Local4 != Local2))
        {
            ERR (Arg0, Z143, __LINE__, Z143, Local3, Local4, Local2)
        }
    }

    Method (M72F, 4, Serialized)
    {
        Concatenate (Arg0, "-m72f", Arg0)
        /* For loop 0 */

        Name (LPN0, 0x00)
        Name (LPC0, 0x00)
        /* For loop 1 */

        Name (LPN1, 0x00)
        Name (LPC1, 0x00)
        /* For loop 2 */

        Name (LPN2, 0x00)
        Name (LPC2, 0x00)
        /* Index of offset */

        Name (IB00, 0x00)
        /* Number of offsets */

        Name (NB00, 0x00)
        LPN0 = Arg1
        LPC0 = 0x00
        While (LPN0)
        {

printf ("LPN0: %o\n", LPN0)
            /* Operands */

            Local6 = (LPC0 * 0x05)
            IB00 = DerefOf (Arg3 [Local6])
            Local6++
            LPN1 = DerefOf (Arg3 [Local6])
            Local6++
            Local0 = DerefOf (Arg3 [Local6])
            Local6++
            Local1 = DerefOf (Arg3 [Local6])
            Local6++
            Local2 = DerefOf (Arg3 [Local6])
            LPC1 = 0x00
            While (LPN1)
            {

printf ("LPN1: %o\n", LPN1)

                NB00 = Local0
                LPN2 = Local1
                LPC2 = 0x00
                Local6 = DerefOf (PFUO [IB00])
                While (LPN2)
                {

printf ("LPN2: %o\n", LPN2)

                    Local7 = DerefOf (PFUL [NB00])
                    /* Integer source */

printf ("BINT: %o %o %o %o\n", Arg2, Local6, Local7, Local2)
                    M72E (Concatenate (Arg0, "-BInt"), Arg2, Local6, Local7, Local2, 0x00)
                    If ((Local7 > 0x08))
                    {
                        /* Buffer source, shorter than field */

                        Local4 = ((Local7 - 0x01) / 0x08)
                        M72E (Concatenate (Arg0, "-BShort"), Arg2, Local6, Local7, Local2, Local4)
                    }

                    Divide (Local7, 0x08, Local5, Local4)
                    If (Local5)
                    {
                        /* Buffer source, longer than field, the same last byte */

                        M72E (Concatenate (Arg0, "-BLast"), Arg2, Local6, Local7, Local2, (Local4 + 0x01
                            ))
                    }
                    Else
                    {
                        /* Buffer source, equal to field in length */

                        M72E (Concatenate (Arg0, "-BEqual"), Arg2, Local6, Local7, Local2, Local4)
                    }

                    /* Buffer source, one byte longer than field */

                    If (Local5)
                    {
                        M72E (Concatenate (Arg0, "-BLong"), Arg2, Local6, Local7, Local2, (Local4 + 0x02
                            ))
                    }
                    Else
                    {
                        M72E (Concatenate (Arg0, "-BLong"), Arg2, Local6, Local7, Local2, (Local4 + 0x01
                            ))
                    }

                    NB00++
                    LPN2--
                    LPC2++
                }

                IB00++
                LPN1--
                LPC1++
            }

            LPC0++
            LPN0--
        }
    }

    /* <test name>, */
    /* <name of test-package>, */
    /* <index of bit>, */
    /* <num of bits>, */
    /* <ext param package>: */
    /*   <opcode of buffer to fill the ground> */
    /*   <opcode of buffer to fill the field> */
    /*   <Access Type opcode> */
    /*       0 - AnyAcc, 1 - ByteAcc, 2 - WordAcc, */
    /*       3 - DWordAcc, 4 - QWordAcc, 5 - BufferAcc */
    /*   <Update Rule opcode> */
    /*       0 - Preserve, 1 - WriteAsOnes, 2 - WriteAsZeros */
    /*   <Lock Rule opcode> */
    /*       0 - Lock, 1 - NoLock */
    /* <size of source object in bytes> */
    /*   Opcodes of size: */
    /*     0 - Integer */
    /*     <=256 - Buffer */
    /*     >256  - String (size-256) */
    Method (M72E, 6, Serialized)
    {
        Name (PR00, 0x00)
        /* For loop 1 */

        Name (LPN1, 0x00)
        Name (LPC1, 0x00)
        /* For loop 2 */

        Name (LPN2, 0x00)
        Name (LPC2, 0x00)
        /* byte size of field */

        Name (BSF0, 0x00)
        /* byte size of region affected by field */

        Name (BSR0, 0x00)
        /* index of the first byte of field in the region */

        Name (FB00, 0x00)
        /* index of the last byte of field in the region */

        Name (LB00, 0x00)
        Concatenate (Arg0, "-m72e", Arg0)
        /* Num of bits have to be non-zero */

        If ((Arg3 == 0x00))
        {
            ERR (Arg0, Z143, __LINE__, 0x00, 0x00, 0x00, 0x00)
            Return (Ones)
        }

        BSR0 = MBS0 (Arg2, Arg3)
        /* ========================================= */
        /* Prepare the buffer for filling the ground */
        /* ========================================= */
        M72C (DerefOf (Arg4 [0x00]), BRG0)
        /* ========================================================== */
        /* Prepare the buffer for filling the field (over the ground) */
        /* ========================================================== */
        M72C (DerefOf (Arg4 [0x01]), BRF0)
        /* ====================================================== */
        /* Prepare the benchmark buffer for Field COMPARISON with */
        /* Result in Local6 */
        /* ====================================================== */
        /* lpN1 - number of bytes minus one */
        Local0 = Arg3
        Local0--
        Divide (Local0, 0x08, Local7, LPN1) /* \M72E.LPN1 */
        Divide (Arg3, 0x08, Local7, Local0)
        BSF0 = LPN1 /* \M72E.LPN1 */
        BSF0++
        Local6 = Buffer (BSF0){}
        If (Arg5)
        {
            Local5 = Arg5
        }
        ElseIf (F64)
        {
            Local5 = 0x08
        }
        Else
        {
            Local5 = 0x04
        }

        If (((Local5 * 0x08) < Arg3))
        {
            LPN1 = Local5
        }
        Else
        {
            Local0 = DerefOf (BRF0 [LPN1])
            If (Local7)
            {
                Local1 = (0x08 - Local7)
                Local2 = (Local0 << Local1)
                Local3 = (Local2 & 0xFF)
                Local0 = (Local3 >> Local1)
            }

            Local6 [LPN1] = Local0
        }

        Local4 = DerefOf (Arg4 [0x02]) /* Access Type */
        Local5 = DerefOf (Arg4 [0x03]) /* Update Rule */
        LPC1 = 0x00
        While (LPN1)
        {
            Local0 = DerefOf (BRF0 [LPC1])
            Local6 [LPC1] = Local0
            LPN1--
            LPC1++
        }

        /* ================================================ */
        /* Prepare the benchmark buffer for comparison with */
        /* ================================================ */
        BRB0 = BRG0 /* \BRG0 */
        Divide (Arg2, 0x08, Local1, FB00) /* \M72E.FB00 */
        Local2 = DerefOf (BRB0 [FB00])
        LB00 = BSR0 /* \M72E.BSR0 */
        LB00--
        Local3 = DerefOf (BRB0 [LB00])
        /* Take into account Update Rule */

        If (Local5)
        {
            /* Update Rule filler: 0xff or 0 */

            Local7 = (0xFF * (0x02 - Local5))
            /* Take into account Access Type */

            If (((Local4 > 0x01) && (Local4 < 0x05)))
            {
                /* Access Width */

                Local2 = (0x01 << (Local4 - 0x01))
                /* Number of bytes touched by Access BEFORE field */

                Divide (FB00, Local2, Local2)
                /* Apply Rule */

                Local3 = FB00 /* \M72E.FB00 */
                While (Local2)
                {
                    Local2--
                    Local3--
                    BRB0 [Local3] = Local7
                }

                /* Number of bytes touched by Access AFTER field */

                Local2 = (0x01 << (Local4 - 0x01))
                Divide (BSR0, Local2, Local3)
                If (Local3)
                {
                    Local2 -= Local3
                    /* Apply Rule */

                    Local3 = LB00 /* \M72E.LB00 */
                    While (Local2)
                    {
                        Local2--
                        Local3++
                        If ((Local3 == RS00))
                        {
                            Break
                        }

                        BRB0 [Local3] = Local7
                    }
                }
            }

            Local2 = Local7
            Local3 = Local7
        }

        Local0 = SFT1 (Local6, Local1, Arg3, Local2, Local3)
        Local2 = FB00 /* \M72E.FB00 */
        LPN2 = SizeOf (Local0)
        LPC2 = 0x00
        While (LPN2)
        {
            Local1 = DerefOf (Local0 [LPC2])
            BRB0 [Local2] = Local1
            Local2++
            LPN2--
            LPC2++
        }

        If (((Arg3 < 0x21) || (F64 && (Arg3 < 0x41))))
        {
            ToInteger (Local6, Local6)
        }

        Switch (ToString (Mid (DerefOf (Arg4 [0x05]), 0x01, 0x03), Ones
            ))
        {
            Case ("730")
            {
                /* (ByteAcc, NoLock, Preserve) */

                M730 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("731")
            {
                /* (ByteAcc, NoLock, WriteAsOnes) */

                M731 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("732")
            {
                /* (ByteAcc, NoLock, WriteAsZeros) */

                M732 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("733")
            {
                /* (WordAcc, NoLock, Preserve) */

                M733 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("734")
            {
                /* (WordAcc, NoLock, WriteAsOnes) */

                M734 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("735")
            {
                /* (WordAcc, NoLock, WriteAsZeros) */

                M735 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("736")
            {
                /* (DWordAcc, NoLock, Preserve) */

                M736 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("737")
            {
                /* (DWordAcc, NoLock, WriteAsOnes) */

                M737 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("738")
            {
                /* (DWordAcc, NoLock, WriteAsZeros) */

                M738 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("739")
            {
                /* (QWordAcc, NoLock, Preserve) */

                M739 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("73a")
            {
                /* (QWordAcc, NoLock, WriteAsOnes) */

                M73A (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("73b")
            {
                /* (QWordAcc, NoLock, WriteAsZeros) */

                M73B (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("73c")
            {
                /* (AnyAcc, NoLock, Preserve) */

                M73C (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("73d")
            {
                /* (AnyAcc, NoLock, WriteAsOnes) */

                M73D (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("73e")
            {
                /* (AnyAcc, Lock, WriteAsZeros) */

                M73E (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("790")
            {
                /* IndexFields (ByteAcc, NoLock, Preserve) */

                M790 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("791")
            {
                /* IndexFields (WordAcc, NoLock, WriteAsOnes) */

                M791 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("792")
            {
                /* IndexFields (DWordAcc, NoLock, WriteAsZeros) */

                M792 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("793")
            {
                /* IndexFields (QWordAcc, NoLock, Preserve) */

                M793 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("794")
            {
                /* IndexFields (AnyAcc, Lock, Preserve) */

                M794 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("7d0")
            {
                /* BankFields (ByteAcc, NoLock, Preserve) */

                M7D0 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("7d1")
            {
                /* BankFields (WordAcc, NoLock, WriteAsOnes) */

                M7D1 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("7d2")
            {
                /* BankFields (DWordAcc, NoLock, WriteAsZeros) */

                M7D2 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("7d3")
            {
                /* BankFields (QWordAcc, NoLock, Preserve) */

                M7D3 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Case ("7d4")
            {
                /* BankFields (AnyAcc, Lock, Preserve) */

                M7D4 (Arg0, Arg1, Arg2, Arg3, Arg5, Local6)
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Local4, Local5)
                Return (Ones)
            }

        }

        Return (Zero)
    }

    /* Create Region Field Unit */
    /* (ByteAcc, NoLock, Preserve) */
    /* */
    /* <test name>, */
    /* <name of test-package>, */
    /* <index of bit>, */
    /* <num of bits>, */
    /* <size of source object in bytes> */
    /*   Opcodes of size: */
    /*     0 - Integer */
    /*     <=256 - Buffer */
    /*     >256  - String (size-256) */
    /* <the benchmark buffer for Field comparison with> */
    Method (M730, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m730", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (ByteAcc, NoLock, WriteAsOnes) */
    Method (M731, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m731", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (ByteAcc, NoLock, WriteAsZeros) */
    Method (M732, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m732", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, ByteAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (WordAcc, NoLock, Preserve) */
    Method (M733, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m733", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (WordAcc, NoLock, WriteAsOnes) */
    Method (M734, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m734", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (WordAcc, NoLock, WriteAsZeros) */
    Method (M735, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m735", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, WordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (DWordAcc, NoLock, Preserve) */
    Method (M736, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m736", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (DWordAcc, NoLock, WriteAsOnes) */
    Method (M737, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m737", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (DWordAcc, NoLock, WriteAsZeros) */
    Method (M738, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m738", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, DWordAcc, NoLock, WriteAsZeros)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (QWordAcc, NoLock, Preserve) */
    Method (M739, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m739", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F012,   7
                        }

                        Local3 = RefOf (F012)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F013,   8
                        }

                        Local3 = RefOf (F013)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F014,   9
                        }

                        Local3 = RefOf (F014)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F015,   31
                        }

                        Local3 = RefOf (F015)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F016,   32
                        }

                        Local3 = RefOf (F016)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F017,   33
                        }

                        Local3 = RefOf (F017)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F018,   63
                        }

                        Local3 = RefOf (F018)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F019,   64
                        }

                        Local3 = RefOf (F019)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01A,   65
                        }

                        Local3 = RefOf (F01A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01B,   69
                        }

                        Local3 = RefOf (F01B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01C,   129
                        }

                        Local3 = RefOf (F01C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01D,   256
                        }

                        Local3 = RefOf (F01D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01E,   1023
                        }

                        Local3 = RefOf (F01E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   1,
                            F01F,   1983
                        }

                        Local3 = RefOf (F01F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F020,   1
                        }

                        Local3 = RefOf (F020)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F021,   6
                        }

                        Local3 = RefOf (F021)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F022,   7
                        }

                        Local3 = RefOf (F022)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F023,   8
                        }

                        Local3 = RefOf (F023)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F024,   9
                        }

                        Local3 = RefOf (F024)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F025,   31
                        }

                        Local3 = RefOf (F025)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F026,   32
                        }

                        Local3 = RefOf (F026)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F027,   33
                        }

                        Local3 = RefOf (F027)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F028,   63
                        }

                        Local3 = RefOf (F028)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F029,   64
                        }

                        Local3 = RefOf (F029)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02A,   65
                        }

                        Local3 = RefOf (F02A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02B,   69
                        }

                        Local3 = RefOf (F02B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02C,   129
                        }

                        Local3 = RefOf (F02C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02D,   256
                        }

                        Local3 = RefOf (F02D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02E,   1023
                        }

                        Local3 = RefOf (F02E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x00),
                                ,   2,
                            F02F,   1983
                        }

                        Local3 = RefOf (F02F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F030,   1
                        }

                        Local3 = RefOf (F030)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F031,   6
                        }

                        Local3 = RefOf (F031)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F032,   7
                        }

                        Local3 = RefOf (F032)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F033,   8
                        }

                        Local3 = RefOf (F033)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F034,   9
                        }

                        Local3 = RefOf (F034)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F035,   31
                        }

                        Local3 = RefOf (F035)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F036,   32
                        }

                        Local3 = RefOf (F036)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F037,   33
                        }

                        Local3 = RefOf (F037)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F038,   63
                        }

                        Local3 = RefOf (F038)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F039,   64
                        }

                        Local3 = RefOf (F039)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03A,   65
                        }

                        Local3 = RefOf (F03A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03B,   69
                        }

                        Local3 = RefOf (F03B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03C,   129
                        }

                        Local3 = RefOf (F03C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03D,   256
                        }

                        Local3 = RefOf (F03D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03E,   1023
                        }

                        Local3 = RefOf (F03E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   3,
                            F03F,   1983
                        }

                        Local3 = RefOf (F03F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F040,   1
                        }

                        Local3 = RefOf (F040)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F041,   6
                        }

                        Local3 = RefOf (F041)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F042,   7
                        }

                        Local3 = RefOf (F042)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F043,   8
                        }

                        Local3 = RefOf (F043)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F044,   9
                        }

                        Local3 = RefOf (F044)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F045,   31
                        }

                        Local3 = RefOf (F045)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F046,   32
                        }

                        Local3 = RefOf (F046)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F047,   33
                        }

                        Local3 = RefOf (F047)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F048,   63
                        }

                        Local3 = RefOf (F048)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F049,   64
                        }

                        Local3 = RefOf (F049)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04A,   65
                        }

                        Local3 = RefOf (F04A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04B,   69
                        }

                        Local3 = RefOf (F04B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04C,   129
                        }

                        Local3 = RefOf (F04C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04D,   256
                        }

                        Local3 = RefOf (F04D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04E,   1023
                        }

                        Local3 = RefOf (F04E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   4,
                            F04F,   1983
                        }

                        Local3 = RefOf (F04F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F050,   1
                        }

                        Local3 = RefOf (F050)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F051,   6
                        }

                        Local3 = RefOf (F051)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F052,   7
                        }

                        Local3 = RefOf (F052)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F053,   8
                        }

                        Local3 = RefOf (F053)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F054,   9
                        }

                        Local3 = RefOf (F054)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F055,   31
                        }

                        Local3 = RefOf (F055)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F056,   32
                        }

                        Local3 = RefOf (F056)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F057,   33
                        }

                        Local3 = RefOf (F057)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F058,   63
                        }

                        Local3 = RefOf (F058)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F059,   64
                        }

                        Local3 = RefOf (F059)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05A,   65
                        }

                        Local3 = RefOf (F05A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05B,   69
                        }

                        Local3 = RefOf (F05B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05C,   129
                        }

                        Local3 = RefOf (F05C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05D,   256
                        }

                        Local3 = RefOf (F05D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05E,   1023
                        }

                        Local3 = RefOf (F05E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   5,
                            F05F,   1983
                        }

                        Local3 = RefOf (F05F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x06)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F060,   1
                        }

                        Local3 = RefOf (F060)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F061,   6
                        }

                        Local3 = RefOf (F061)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F062,   7
                        }

                        Local3 = RefOf (F062)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F063,   8
                        }

                        Local3 = RefOf (F063)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F064,   9
                        }

                        Local3 = RefOf (F064)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F065,   31
                        }

                        Local3 = RefOf (F065)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F066,   32
                        }

                        Local3 = RefOf (F066)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F067,   33
                        }

                        Local3 = RefOf (F067)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F068,   63
                        }

                        Local3 = RefOf (F068)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F069,   64
                        }

                        Local3 = RefOf (F069)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06A,   65
                        }

                        Local3 = RefOf (F06A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06B,   69
                        }

                        Local3 = RefOf (F06B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06C,   129
                        }

                        Local3 = RefOf (F06C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06D,   256
                        }

                        Local3 = RefOf (F06D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06E,   1023
                        }

                        Local3 = RefOf (F06E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   6,
                            F06F,   1983
                        }

                        Local3 = RefOf (F06F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x07)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F070,   1
                        }

                        Local3 = RefOf (F070)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F071,   6
                        }

                        Local3 = RefOf (F071)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F072,   7
                        }

                        Local3 = RefOf (F072)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F073,   8
                        }

                        Local3 = RefOf (F073)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F074,   9
                        }

                        Local3 = RefOf (F074)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F075,   31
                        }

                        Local3 = RefOf (F075)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F076,   32
                        }

                        Local3 = RefOf (F076)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F077,   33
                        }

                        Local3 = RefOf (F077)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F078,   63
                        }

                        Local3 = RefOf (F078)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F079,   64
                        }

                        Local3 = RefOf (F079)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07A,   65
                        }

                        Local3 = RefOf (F07A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07B,   69
                        }

                        Local3 = RefOf (F07B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07C,   129
                        }

                        Local3 = RefOf (F07C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07D,   256
                        }

                        Local3 = RefOf (F07D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07E,   1023
                        }

                        Local3 = RefOf (F07E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   7,
                            F07F,   1983
                        }

                        Local3 = RefOf (F07F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x08)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F080,   1
                        }

                        Local3 = RefOf (F080)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F081,   6
                        }

                        Local3 = RefOf (F081)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F082,   7
                        }

                        Local3 = RefOf (F082)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F083,   8
                        }

                        Local3 = RefOf (F083)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F084,   9
                        }

                        Local3 = RefOf (F084)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F085,   31
                        }

                        Local3 = RefOf (F085)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F086,   32
                        }

                        Local3 = RefOf (F086)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F087,   33
                        }

                        Local3 = RefOf (F087)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F088,   63
                        }

                        Local3 = RefOf (F088)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F089,   64
                        }

                        Local3 = RefOf (F089)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08A,   65
                        }

                        Local3 = RefOf (F08A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08B,   69
                        }

                        Local3 = RefOf (F08B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08C,   129
                        }

                        Local3 = RefOf (F08C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08D,   256
                        }

                        Local3 = RefOf (F08D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08E,   1023
                        }

                        Local3 = RefOf (F08E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x01),
                            F08F,   1983
                        }

                        Local3 = RefOf (F08F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x09)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F090,   1
                        }

                        Local3 = RefOf (F090)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F091,   6
                        }

                        Local3 = RefOf (F091)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F092,   7
                        }

                        Local3 = RefOf (F092)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F093,   8
                        }

                        Local3 = RefOf (F093)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F094,   9
                        }

                        Local3 = RefOf (F094)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F095,   31
                        }

                        Local3 = RefOf (F095)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F096,   32
                        }

                        Local3 = RefOf (F096)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F097,   33
                        }

                        Local3 = RefOf (F097)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F098,   63
                        }

                        Local3 = RefOf (F098)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F099,   64
                        }

                        Local3 = RefOf (F099)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09A,   65
                        }

                        Local3 = RefOf (F09A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09B,   69
                        }

                        Local3 = RefOf (F09B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09C,   129
                        }

                        Local3 = RefOf (F09C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09D,   256
                        }

                        Local3 = RefOf (F09D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09E,   1023
                        }

                        Local3 = RefOf (F09E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   9,
                            F09F,   1983
                        }

                        Local3 = RefOf (F09F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x1F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A0,   1
                        }

                        Local3 = RefOf (F0A0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A1,   6
                        }

                        Local3 = RefOf (F0A1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A2,   7
                        }

                        Local3 = RefOf (F0A2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A3,   8
                        }

                        Local3 = RefOf (F0A3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A4,   9
                        }

                        Local3 = RefOf (F0A4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A5,   31
                        }

                        Local3 = RefOf (F0A5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A6,   32
                        }

                        Local3 = RefOf (F0A6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A7,   33
                        }

                        Local3 = RefOf (F0A7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A8,   63
                        }

                        Local3 = RefOf (F0A8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0A9,   64
                        }

                        Local3 = RefOf (F0A9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AA,   65
                        }

                        Local3 = RefOf (F0AA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AB,   69
                        }

                        Local3 = RefOf (F0AB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AC,   129
                        }

                        Local3 = RefOf (F0AC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AD,   256
                        }

                        Local3 = RefOf (F0AD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AE,   1023
                        }

                        Local3 = RefOf (F0AE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x03),
                                ,   7,
                            F0AF,   1983
                        }

                        Local3 = RefOf (F0AF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x20)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B0,   1
                        }

                        Local3 = RefOf (F0B0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B1,   6
                        }

                        Local3 = RefOf (F0B1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B2,   7
                        }

                        Local3 = RefOf (F0B2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B3,   8
                        }

                        Local3 = RefOf (F0B3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B4,   9
                        }

                        Local3 = RefOf (F0B4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B5,   31
                        }

                        Local3 = RefOf (F0B5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B6,   32
                        }

                        Local3 = RefOf (F0B6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B7,   33
                        }

                        Local3 = RefOf (F0B7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B8,   63
                        }

                        Local3 = RefOf (F0B8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0B9,   64
                        }

                        Local3 = RefOf (F0B9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BA,   65
                        }

                        Local3 = RefOf (F0BA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BB,   69
                        }

                        Local3 = RefOf (F0BB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BC,   129
                        }

                        Local3 = RefOf (F0BC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BD,   256
                        }

                        Local3 = RefOf (F0BD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BE,   1023
                        }

                        Local3 = RefOf (F0BE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x04),
                            F0BF,   1983
                        }

                        Local3 = RefOf (F0BF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x21)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C0,   1
                        }

                        Local3 = RefOf (F0C0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C1,   6
                        }

                        Local3 = RefOf (F0C1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C2,   7
                        }

                        Local3 = RefOf (F0C2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C3,   8
                        }

                        Local3 = RefOf (F0C3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C4,   9
                        }

                        Local3 = RefOf (F0C4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C5,   31
                        }

                        Local3 = RefOf (F0C5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C6,   32
                        }

                        Local3 = RefOf (F0C6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C7,   33
                        }

                        Local3 = RefOf (F0C7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C8,   63
                        }

                        Local3 = RefOf (F0C8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0C9,   64
                        }

                        Local3 = RefOf (F0C9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CA,   65
                        }

                        Local3 = RefOf (F0CA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CB,   69
                        }

                        Local3 = RefOf (F0CB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CC,   129
                        }

                        Local3 = RefOf (F0CC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CD,   256
                        }

                        Local3 = RefOf (F0CD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CE,   1023
                        }

                        Local3 = RefOf (F0CE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   33,
                            F0CF,   1983
                        }

                        Local3 = RefOf (F0CF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x3F)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D0,   1
                        }

                        Local3 = RefOf (F0D0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D1,   6
                        }

                        Local3 = RefOf (F0D1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D2,   7
                        }

                        Local3 = RefOf (F0D2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D3,   8
                        }

                        Local3 = RefOf (F0D3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D4,   9
                        }

                        Local3 = RefOf (F0D4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D5,   31
                        }

                        Local3 = RefOf (F0D5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D6,   32
                        }

                        Local3 = RefOf (F0D6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D7,   33
                        }

                        Local3 = RefOf (F0D7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D8,   63
                        }

                        Local3 = RefOf (F0D8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0D9,   64
                        }

                        Local3 = RefOf (F0D9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DA,   65
                        }

                        Local3 = RefOf (F0DA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DB,   69
                        }

                        Local3 = RefOf (F0DB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DC,   129
                        }

                        Local3 = RefOf (F0DC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DD,   256
                        }

                        Local3 = RefOf (F0DD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DE,   1023
                        }

                        Local3 = RefOf (F0DE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                                ,   63,
                            F0DF,   1983
                        }

                        Local3 = RefOf (F0DF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x40)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E0,   1
                        }

                        Local3 = RefOf (F0E0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E1,   6
                        }

                        Local3 = RefOf (F0E1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E2,   7
                        }

                        Local3 = RefOf (F0E2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E3,   8
                        }

                        Local3 = RefOf (F0E3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E4,   9
                        }

                        Local3 = RefOf (F0E4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E5,   31
                        }

                        Local3 = RefOf (F0E5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E6,   32
                        }

                        Local3 = RefOf (F0E6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E7,   33
                        }

                        Local3 = RefOf (F0E7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E8,   63
                        }

                        Local3 = RefOf (F0E8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0E9,   64
                        }

                        Local3 = RefOf (F0E9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EA,   65
                        }

                        Local3 = RefOf (F0EA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EB,   69
                        }

                        Local3 = RefOf (F0EB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EC,   129
                        }

                        Local3 = RefOf (F0EC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0ED,   256
                        }

                        Local3 = RefOf (F0ED)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EE,   1023
                        }

                        Local3 = RefOf (F0EE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                            F0EF,   1983
                        }

                        Local3 = RefOf (F0EF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x41)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F0,   1
                        }

                        Local3 = RefOf (F0F0)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F1,   6
                        }

                        Local3 = RefOf (F0F1)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F2,   7
                        }

                        Local3 = RefOf (F0F2)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F3,   8
                        }

                        Local3 = RefOf (F0F3)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F4,   9
                        }

                        Local3 = RefOf (F0F4)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F5,   31
                        }

                        Local3 = RefOf (F0F5)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F6,   32
                        }

                        Local3 = RefOf (F0F6)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F7,   33
                        }

                        Local3 = RefOf (F0F7)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F8,   63
                        }

                        Local3 = RefOf (F0F8)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0F9,   64
                        }

                        Local3 = RefOf (F0F9)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FA,   65
                        }

                        Local3 = RefOf (F0FA)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FB,   69
                        }

                        Local3 = RefOf (F0FB)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FC,   129
                        }

                        Local3 = RefOf (F0FC)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FD,   256
                        }

                        Local3 = RefOf (F0FD)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FE,   1023
                        }

                        Local3 = RefOf (F0FE)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, Preserve)
                        {
                            Offset (0x08),
                                ,   1,
                            F0FF,   1983
                        }

                        Local3 = RefOf (F0FF)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Default
            {
                ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                Return (Zero)
            }

        }

        M72D (Arg0, Local3, Arg2, Arg3, Arg4, Arg5, RefOf (G001))
    }

    /* Create Region Field Unit */
    /* (QWordAcc, NoLock, WriteAsOnes) */
    Method (M73A, 6, Serialized)
    {
        OperationRegion (OPR0, SystemMemory, 0x00, RS00)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            G001,   2048
        }

        Concatenate (Arg0, "-m73a", Arg0)
        Switch (ToInteger (Arg2))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F000,   1
                        }

                        Local3 = RefOf (F000)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F001,   6
                        }

                        Local3 = RefOf (F001)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F002,   7
                        }

                        Local3 = RefOf (F002)
                    }
                    Case (0x08)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F003,   8
                        }

                        Local3 = RefOf (F003)
                    }
                    Case (0x09)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F004,   9
                        }

                        Local3 = RefOf (F004)
                    }
                    Case (0x1F)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F005,   31
                        }

                        Local3 = RefOf (F005)
                    }
                    Case (0x20)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F006,   32
                        }

                        Local3 = RefOf (F006)
                    }
                    Case (0x21)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F007,   33
                        }

                        Local3 = RefOf (F007)
                    }
                    Case (0x3F)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F008,   63
                        }

                        Local3 = RefOf (F008)
                    }
                    Case (0x40)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F009,   64
                        }

                        Local3 = RefOf (F009)
                    }
                    Case (0x41)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00A,   65
                        }

                        Local3 = RefOf (F00A)
                    }
                    Case (0x45)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00B,   69
                        }

                        Local3 = RefOf (F00B)
                    }
                    Case (0x81)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00C,   129
                        }

                        Local3 = RefOf (F00C)
                    }
                    Case (0x0100)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00D,   256
                        }

                        Local3 = RefOf (F00D)
                    }
                    Case (0x03FF)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00E,   1023
                        }

                        Local3 = RefOf (F00E)
                    }
                    Case (0x07BF)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                            Offset (0x00),
                            F00F,   1983
                        }

                        Local3 = RefOf (F00F)
                    }
                    Default
                    {
                        ERR (Arg0, Z143, __LINE__, 0x00, 0x00, Arg2, Arg3)
                        Return (Zero)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x01)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F010,   1
                        }

                        Local3 = RefOf (F010)
                    }
                    Case (0x06)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   1,
                            F011,   6
                        }

                        Local3 = RefOf (F011)
                    }
                    Case (0x07)
                    {
                        Field (OPR0, QWordAcc, NoLock, WriteAsOnes)
                        {
                                ,   