#ifndef SCALADIALOG_H
#define SCALADIALOG_H

#include <QtWidgets/QPushButton>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QLineEdit>
#include <QtWidgets/QLabel>
#include <QTextEdit>
#include <QColor>
#include "model.h"

class ScalaDialog : public QWidget
{
  Q_OBJECT

  private:
    Model *model;
    QString scalaFileName, scalaName;
    QLabel *scalaFileNameLabel;
    QLineEdit *scalaNameEdit;
    QLabel *scalaLenLabel, *octavePeriodLabel;
    QLineEdit *baseFreqEdit, *baseNoteEdit;
    QPushButton *loadScalaButton, *closeButton;
    QCheckBox *scalaModeCheck;
    QTextEdit *scalaOutput;

  public:
    ScalaDialog(Model *p_model, QWidget* parent=0, Qt::WindowFlags f=0);
    ~ScalaDialog();

  public slots: 
    void setScala(QString p_scalaName);
    QString getScala();
    void updateScala();
    void updateScalaOutput();
    void setScalaMode(bool on);
    void loadScala();
};

#endif
