/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:01:34 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.MUMmerComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class MUMmerComparisonData_ESTest extends MUMmerComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
      try { 
        mUMmerComparisonData0.makeMatchFromString("");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // unable to understand this line: 
         //
         verifyException("uk.ac.sanger.artemis.MUMmerComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("f'&@$V8 SxY~ H{c'", (String) null).when(linePushBackReader0).readLine();
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
      AlignMatch[] alignMatchArray0 = new AlignMatch[7];
      int int0 = 85;
      int int1 = 641;
      int int2 = 71;
      int int3 = 67;
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(int0, int1, int2, int0, int3, int0);
      alignMatchArray0[0] = alignMatch0;
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      MUMmerComparisonData mUMmerComparisonData0 = null;
      try {
        mUMmerComparisonData0 = new MUMmerComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
      AlignMatch alignMatch0 = mUMmerComparisonData0.makeMatchFromString("internal error - unreachable code");
      assertNull(alignMatch0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn(">w/O%+`DXP-", "HgPWmP^vvWv:'F Y( w", ">~dm'/a", ">h@al'W)C%YX", "dZ").when(linePushBackReader0).readLine();
      MUMmerComparisonData mUMmerComparisonData0 = null;
      try {
        mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // unable to understand this line: dZ
         //
         verifyException("uk.ac.sanger.artemis.MUMmerComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData();
      AlignMatch alignMatch0 = mUMmerComparisonData0.makeMatchFromString((String) null);
      assertNull(alignMatch0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData();
      SimpleComparisonData simpleComparisonData0 = mUMmerComparisonData0.getNewSimpleComparisonData();
      assertNotSame(simpleComparisonData0, mUMmerComparisonData0);
  }
}
