/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.visitor.BCVisitor;

public class ConstantValue
extends Attribute {
    int _valueIndex = 0;

    ConstantValue(int nameIndex, Attributes owner) {
        super(nameIndex, owner);
    }

    @Override
    int getLength() {
        return 2;
    }

    public BCField getField() {
        return (BCField)this.getOwner();
    }

    public int getValueIndex() {
        return this._valueIndex;
    }

    public void setValueIndex(int valueIndex) {
        this._valueIndex = valueIndex;
    }

    public String getTypeName() {
        Class type = this.getType();
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    public Class getType() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        return String.class;
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getType());
    }

    public Object getValue() {
        if (this._valueIndex <= 0) {
            return null;
        }
        return ((ConstantEntry)((Object)this.getPool().getEntry(this._valueIndex))).getConstant();
    }

    public void setValue(Object value) {
        Class<?> type = value.getClass();
        if (type == Boolean.class) {
            this.setIntValue((Boolean)value != false ? 1 : 0);
        } else if (type == Character.class) {
            this.setIntValue(((Character)value).charValue());
        } else if (type == Byte.class || type == Integer.class || type == Short.class) {
            this.setIntValue(((Number)value).intValue());
        } else if (type == Float.class) {
            this.setFloatValue(((Number)value).floatValue());
        } else if (type == Double.class) {
            this.setDoubleValue(((Number)value).doubleValue());
        } else if (type == Long.class) {
            this.setLongValue(((Number)value).longValue());
        } else {
            this.setStringValue(value.toString());
        }
    }

    public int getIntValue() {
        if (this.getValueIndex() <= 0) {
            return 0;
        }
        return ((IntEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setIntValue(int value) {
        this.setValueIndex(this.getPool().findIntEntry(value, true));
    }

    public float getFloatValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0f;
        }
        return ((FloatEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setFloatValue(float value) {
        this.setValueIndex(this.getPool().findFloatEntry(value, true));
    }

    public double getDoubleValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0;
        }
        return ((DoubleEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setDoubleValue(double value) {
        this.setValueIndex(this.getPool().findDoubleEntry(value, true));
    }

    public long getLongValue() {
        if (this.getValueIndex() <= 0) {
            return 0L;
        }
        return ((LongEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setLongValue(long value) {
        this.setValueIndex(this.getPool().findLongEntry(value, true));
    }

    public String getStringValue() {
        if (this.getValueIndex() <= 0) {
            return null;
        }
        return ((StringEntry)this.getPool().getEntry(this.getValueIndex())).getStringEntry().getValue();
    }

    public void setStringValue(String value) {
        this.setValueIndex(this.getPool().findStringEntry(value, true));
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterConstantValue(this);
        visit.exitConstantValue(this);
    }

    @Override
    void read(Attribute other) {
        this.setValue(((ConstantValue)other).getValue());
    }

    @Override
    void read(DataInput in, int length) throws IOException {
        this.setValueIndex(in.readUnsignedShort());
    }

    @Override
    void write(DataOutput out, int length) throws IOException {
        out.writeShort(this.getValueIndex());
    }
}

