subroutine recbec(nomres, typesd, basmod, modcyc, numsec)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
    implicit none
!-----------------------------------------------------------------------
!
!  BUT:  < RESTITUTION CRIAG-BAMPTON ECLATEE >
!
!   RESTITUER LES RESULTATS ISSUS D'UN CALCUL CYCLIQUE
!          AVEC DES INTERFACES DE TYPE CRAIG-BAMPTON
!     => RESULTAT COMPOSE DE TYPE MODE_MECA ALLOUE PAR LA
!   ROUTINE
!-----------------------------------------------------------------------
!
! NOMRES  /I/: NOM UT DU CONCEPT RESULTAT A REMPLIR
! TYPESD  /I/: NOM K16 DU TYPE DE LA STRUCTURE DE DONNEE
! BASMOD  /I/: NOM UT DE LA BASE MODALE EN AMONT DU CALCUL CYCLIQUE
! MODCYC  /I/: NOM UT DU RESULTAT ISSU DU CALCUL CYCLIQUE
! NUMSEC  /I/: NUMERO DU SECTEUR  SUR LEQUEL RESTITUER
!
!
!
!
#include "jeveux.h"
!
#include "asterc/r8depi.h"
#include "asterfort/bmnodi.h"
#include "asterfort/ctetgd.h"
#include "asterfort/dismoi.h"
#include "asterfort/genecy.h"
#include "asterfort/jedema.h"
#include "asterfort/jedetr.h"
#include "asterfort/jelira.h"
#include "asterfort/jemarq.h"
#include "asterfort/jeveuo.h"
#include "asterfort/mtdscr.h"
#include "asterfort/mtexis.h"
#include "asterfort/ordr8.h"
#include "asterfort/recbbn.h"
#include "asterfort/rsadpa.h"
#include "asterfort/rscrsd.h"
#include "asterfort/rsexch.h"
#include "asterfort/rsnoch.h"
#include "asterfort/u2mesg.h"
#include "asterfort/vtcrem.h"
#include "asterfort/wkvect.h"
#include "blas/daxpy.h"
    character(len=8) :: nomres, basmod, modcyc, kbid, k8b
    character(len=16) :: depl, typesd, typsup(1)
    character(len=19) :: chamva, numddl, matrix, mass
    character(len=24) :: tetgd, nomvec
    character(len=24) :: valk(2)
    complex(kind=8) :: dephc
    real(kind=8) :: para(2), depi, fact, genek, beta
!
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
    integer :: i, iad, ibid, icomp, iddi, idi, idia
    integer :: idiam, idicou, ier, ii, inum, iorc, iormo
    integer :: j, jj, ldfre, ldkge, ldmge, ldom2, ldomo
    integer :: ldotm, ldtyd, llcham, lldesc, lldiam, llfreq, llmoc
    integer :: llnsec, llnumi, llref, lmass, ltetgd, ltora, ltord
    integer :: ltorf, ltorg, ltorto, ltveco, ltvere, ltvezt, mdiapa
    integer :: nbdax, nbddg, nbddr, nbdia, nbmoc, nbmod, nbmor
    integer :: nborc, nbsec, nbtmp, neq, numa, numd, numg
    integer :: numsec
    real(kind=8) :: aaa, bbb, betsec
!-----------------------------------------------------------------------
    data depl   /'DEPL            '/
    data typsup /'MODE_MECA       '/
!-----------------------------------------------------------------------
!
    call jemarq()
!
    depi = r8depi()
    ltora = 1
!
!----------------VERIFICATION DU TYPE DE STRUCTURE RESULTAT-------------
!
    if (typesd .ne. typsup(1)) then
        valk (1) = typesd
        valk (2) = typsup(1)
        call u2mesg('F', 'ALGORITH14_4', 2, valk, 0,&
                    0, 0, 0.d0)
    endif
!
!--------------------------RECUPERATION DU .DESC------------------------
!
    call jeveuo(modcyc//'.CYCL_DESC', 'L', lldesc)
    nbmod = zi(lldesc)
    nbddr = zi(lldesc+1)
    nbdax = zi(lldesc+2)
!
!-------------------RECUPERATION DU NOMBRE DE SECTEUR-------------------
!
    call jeveuo(modcyc//'.CYCL_NBSC', 'L', llnsec)
    nbsec = zi(llnsec)
    mdiapa = int(nbsec/2)*(1-nbsec+(2*int(nbsec/2)))
!
!------------------RECUPERATION DES NOMBRES DE DIAMETRES MODAUX---------
!
    call jeveuo(modcyc//'.CYCL_DIAM', 'L', lldiam)
    call jelira(modcyc//'.CYCL_DIAM', 'LONMAX', nbdia, k8b)
    nbdia = nbdia / 2
!
!-----------------RECUPERATION DU NOMBRE DE DDL PHYSIQUES---------------
!
    call jeveuo(basmod//'           .REFD', 'L', llref)
    numddl = zk24(llref+3)
    matrix = zk24(llref)
    call dismoi('F', 'NB_EQUA', numddl, 'NUME_DDL', neq,&
                k8b, ier)
!
!-------------RECUPERATION DES FREQUENCES-------------------------------
!
    call jeveuo(modcyc//'.CYCL_FREQ', 'L', llfreq)
!
!----------------RECUPERATION MATRICE DE MASSE--------------------------
!
    mass = zk24(llref+1)
    call mtexis(mass, ier)
    if (ier .eq. 0) then
        valk (1) = mass(1:8)
        call u2mesg('F', 'ALGORITH12_39', 1, valk, 0,&
                    0, 0, 0.d0)
    endif
    call mtdscr(mass)
    call jeveuo(mass(1:19)//'.&INT', 'E', lmass)
!
!------------------ALLOCATION DES VECTEURS DE TRAVAIL-------------------
!
    call wkvect('&&RECBEC.VEC.TRAVC', 'V V C', neq, ltvezt)
    call wkvect('&&RECBEC.VEC.COMP', 'V V C', neq, ltveco)
    call wkvect('&&RECBEC.VEC.REEL', 'V V R', neq, ltvere)
!
!-----------------RECUPERATION DES NUMERO D'INTERFACE-------------------
!
    call jeveuo(modcyc//'.CYCL_NUIN', 'L', llnumi)
    numd = zi(llnumi)
    numg = zi(llnumi+1)
    numa = zi(llnumi+2)
!
!---------------RECUPERATION DU NUMERO ORDRE DES DEFORMEES--------------
!
    nomvec = '&&RECBEC.ORD.DEF.DR'
    call wkvect(nomvec, 'V V I', nbddr, ltord)
    kbid = ' '
    call bmnodi(basmod, kbid, '       ', numd, nbddr,&
                zi(ltord), ibid)
    nomvec = '&&RECBEC.ORD.DEF.GA'
    call wkvect(nomvec, 'V V I', nbddr, ltorg)
    kbid = ' '
    call bmnodi(basmod, kbid, '       ', numg, nbddr,&
                zi(ltorg), ibid)
!
    if (nbdax .gt. 0) then
        nomvec = '&&RECBEC.ORD.DEF.AX'
        call wkvect(nomvec, 'V V I', nbdax, ltora)
        kbid = ' '
        call bmnodi(basmod, kbid, '       ', numa, nbdax,&
                    zi(ltora), ibid)
    endif
!
!--------------------CLASSEMENT DES MODES PROPRES-----------------------
!               COMPTAGE DU NOMBRE DE MODES PHYSIQUES
!
    nbmoc = 0
    nbmor = 0
    do 5 iddi = 1, nbdia
        nbtmp = zi(lldiam+nbdia+iddi-1)
        nbmoc = nbmoc + nbtmp
        idia = zi(lldiam+iddi-1)
        if (idia .eq. 0 .or. idia .eq. mdiapa) then
            nbmor = nbmor + nbtmp
        else
            nbmor = nbmor + 2*nbtmp
        endif
 5  end do
    call wkvect('&&RECBEC.ORDRE.FREQ', 'V V I', nbmoc, ltorf)
    call wkvect('&&RECBEC.ORDRE.TMPO', 'V V I', nbmoc, ltorto)
    call ordr8(zr(llfreq), nbmoc, zi(ltorto))
!
!
!-----------------ALLOCATION STRUCTURE DE DONNEES-----------------------
!
    call rscrsd('G', nomres, typesd, nbmor)
!
!-------DETERMINATION DES FUTUR NUMERO ORDRES DE MODES REELS------------
!
    nborc = 0
    do 6 ii = 1, nbmoc
        iormo = zi(ltorto+ii-1)
        icomp = 0
        idicou = 0
        do 7 jj = 1, nbdia
            icomp = icomp + zi(lldiam+nbdia+jj-1)
            if (icomp .ge. iormo .and. idicou .eq. 0) idicou = jj
 7      continue
        nborc = nborc + 1
        zi(ltorf+iormo-1) = nborc
        idiam = zi(lldiam+idicou-1)
        if (idiam .ne. 0 .and. idiam .ne. mdiapa) nborc = nborc + 1
 6  end do
    call jedetr('&&RECBEC.ORDRE.TMPO')
!
!---------------------RECUPERATION DES MODES COMPLEXES------------------
!
    call jeveuo(modcyc//'.CYCL_CMODE', 'L', llmoc)
!
!--------------CALCUL DU TETA DE CHANGEMENT DE BASE GAUCHE DROITE-------
!
    tetgd = '&&RECBEC.TETGD'
    call wkvect(tetgd, 'V V R', nbddr*nbddr, ltetgd)
    call ctetgd(basmod, numd, numg, nbsec, zr(ltetgd),&
                nbddr)
!
!--------------------------RESTITUTION----------------------------------
!
    nbddg = nbmod + nbddr + nbdax
    icomp = 0
    inum = 0
!
! --- BOUCLE SUR LES DIAMETRES NODAUX
!
    do 10 idi = 1, nbdia
!
! ----- CALCUL DU DEPHASAGE DU SECTEUR DEMANDE
!
        idiam = zi(lldiam+idi-1)
        beta = (depi/nbsec)*idiam
        betsec = (numsec-1)*beta
        aaa = cos(betsec)
        bbb = sin(betsec)
        dephc = dcmplx(aaa,bbb)
!
! ----- BOUCLE SUR LES MODE DU DIAMETRE COURANT
!
        do 15 i = 1, zi(lldiam+nbdia+idi-1)
!
            icomp = icomp + 1
            inum = inum + 1
            iorc = zi(ltorf+icomp-1)
!
! ------- DETERMINATION DU NUMERO DE DIAMETRE MODAL
!
            iad = llmoc + ((icomp-1)*nbddg)
!
! ------- CALCUL MODE COMPLEXE SECTEUR DE BASE
!
            call recbbn(basmod, nbmod, nbddr, nbdax, tetgd,&
                        zi(ltord), zi(ltorg), zi(ltora), zc(iad), zc(ltveco),&
                        neq, beta)
!
! ------- CALCUL MASSE GENERALISEE
!
            call genecy(zc(ltveco), zc(ltveco), neq, lmass, para,&
                        nbsec, beta, beta, zc(ltvezt))
!
            do 20 j = 1, neq
                zc(ltveco+j-1) = zc(ltveco+j-1)*dephc
                zr(ltvere+j-1) = dble(zc(ltveco+j-1))
20          continue
!
! ------- RESTITUTION DU MODE PROPRE REEL (PARTIE RELLE)
!
            call rsexch(' ', nomres, depl, inum, chamva,&
                        ier)
            call vtcrem(chamva, matrix, 'G', 'R')
            call jeveuo(chamva//'.VALE', 'E', llcham)
!
! ------- COMMUN POUR MODE_MECA ET BASE_MODALE
!
            call rsadpa(nomres, 'E', 1, 'FREQ', inum,&
                        0, ldfre, k8b)
            call rsadpa(nomres, 'E', 1, 'RIGI_GENE', inum,&
                        0, ldkge, k8b)
            call rsadpa(nomres, 'E', 1, 'MASS_GENE', inum,&
                        0, ldmge, k8b)
            call rsadpa(nomres, 'E', 1, 'OMEGA2', inum,&
                        0, ldom2, k8b)
            call rsadpa(nomres, 'E', 1, 'NUME_MODE', inum,&
                        0, ldomo, k8b)
            call rsadpa(nomres, 'E', 1, 'TYPE_MODE', inum,&
                        0, ldotm, k8b)
!
            fact = 1.d0 / (para(1)**0.5d0)
            genek = (zr(llfreq+icomp-1)*depi)**2
            call daxpy(neq, fact, zr(ltvere), 1, zr(llcham),&
                       1)
            zr(ldfre) = zr(llfreq+icomp-1)
            zr(ldkge) = genek
            zr(ldmge) = 1.d0
            zr(ldom2) = genek
            zi(ldomo) = iorc
            zk16(ldotm) = 'MODE_DYN'
!
! ------- SPECIFIQUE A BASE_MODALE
!
            call rsadpa(nomres, 'E', 1, 'TYPE_DEFO', inum,&
                        0, ldtyd, k8b)
            zk16(ldtyd) = 'PROPRE          '
!
            call rsnoch(nomres, depl, inum)
!
! ------- EVENTUELLE RESTITUTION DE LA PARTIE IMAGINAIRE
!
            if (idiam .ne. 0 .and. idiam .ne. mdiapa) then
!
                do 30 j = 1, neq
                    zr(ltvere+j-1) = dimag(zc(ltveco+j-1))
30              continue
                iorc = iorc + 1
                inum = inum + 1
!
                call rsexch(' ', nomres, depl, inum, chamva,&
                            ier)
                call vtcrem(chamva, matrix, 'G', 'R')
                call jeveuo(chamva//'.VALE', 'E', llcham)
!
                call rsadpa(nomres, 'E', 1, 'FREQ', inum,&
                            0, ldfre, k8b)
                call rsadpa(nomres, 'E', 1, 'RIGI_GENE', inum,&
                            0, ldkge, k8b)
                call rsadpa(nomres, 'E', 1, 'MASS_GENE', inum,&
                            0, ldmge, k8b)
                call rsadpa(nomres, 'E', 1, 'OMEGA2', inum,&
                            0, ldom2, k8b)
                call rsadpa(nomres, 'E', 1, 'NUME_MODE', inum,&
                            0, ldomo, k8b)
                call rsadpa(nomres, 'E', 1, 'TYPE_MODE', inum,&
                            0, ldotm, k8b)
!
                fact = 1.d0 / (para(2)**0.5d0)
                genek = (zr(llfreq+icomp-1)*depi)**2
                call daxpy(neq, fact, zr(ltvere), 1, zr(llcham),&
                           1)
                zr(ldfre) = zr(llfreq+icomp-1)
                zr(ldkge) = genek
                zr(ldmge) = 1.d0
                zr(ldom2) = genek
                zi(ldomo) = iorc
                zk16(ldotm) = 'MODE_DYN'
!
                call rsadpa(nomres, 'E', 1, 'TYPE_DEFO', inum,&
                            0, ldtyd, k8b)
                zk16(ldtyd) = 'PROPRE          '
!
                call rsnoch(nomres, depl, inum)
!
            endif
!
15      continue
!
10  end do
!
    call jedetr('&&RECBEC.VEC.TRAVC')
    call jedetr('&&RECBEC.VEC.COMP')
    call jedetr('&&RECBEC.VEC.REEL')
    call jedetr('&&RECBEC.ORD.DEF.DR')
    call jedetr('&&RECBEC.ORD.DEF.GA')
    call jedetr('&&RECBEC.ORDRE.FREQ')
    call jedetr('&&RECBEC.TETGD')
    if (nbdax .gt. 0) call jedetr('&&RECBEC.ORD.DEF.AX')
!
    call jedema()
end subroutine
