#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _(
            "read to end of line, use review cursor if you are in review mode, "
            "otherwhise use text cursor"
        )

    def run(self):
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()

        x, y, curr_line = line_utils.get_current_line(
            cursor_pos["x"],
            cursor_pos["y"],
            self.env["screen"]["new_content_text"],
        )

        if curr_line.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                curr_line[cursor_pos["x"] :], interrupt=True
            )
        self.env["runtime"]["OutputManager"].announce_active_cursor()

    def set_callback(self, callback):
        pass
