/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import java.awt.Color;

public class CSSColourParser {
    public static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        return string;
    }

    static final Color hexToColor(String string) {
        Color color;
        int n = string.length();
        String string2 = string.startsWith("#") ? string.substring(1, Math.min(string.length(), 7)) : string;
        String string3 = "0x" + string2;
        try {
            color = Color.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    public static Color stringToColor(String string) {
        Color color = null;
        color = string == null || string.length() == 0 ? Color.black : (string.startsWith("rgb(") ? CSSColourParser.parseRGB(string) : (string.charAt(0) == '#' ? CSSColourParser.hexToColor(string) : (string.equalsIgnoreCase("Black") ? CSSColourParser.hexToColor("#000000") : (string.equalsIgnoreCase("Silver") ? CSSColourParser.hexToColor("#C0C0C0") : (string.equalsIgnoreCase("Gray") ? CSSColourParser.hexToColor("#808080") : (string.equalsIgnoreCase("White") ? CSSColourParser.hexToColor("#FFFFFF") : (string.equalsIgnoreCase("Maroon") ? CSSColourParser.hexToColor("#800000") : (string.equalsIgnoreCase("Red") ? CSSColourParser.hexToColor("#FF0000") : (string.equalsIgnoreCase("Purple") ? CSSColourParser.hexToColor("#800080") : (string.equalsIgnoreCase("Fuchsia") ? CSSColourParser.hexToColor("#FF00FF") : (string.equalsIgnoreCase("Green") ? CSSColourParser.hexToColor("#008000") : (string.equalsIgnoreCase("Lime") ? CSSColourParser.hexToColor("#00FF00") : (string.equalsIgnoreCase("Olive") ? CSSColourParser.hexToColor("#808000") : (string.equalsIgnoreCase("Yellow") ? CSSColourParser.hexToColor("#FFFF00") : (string.equalsIgnoreCase("Navy") ? CSSColourParser.hexToColor("#000080") : (string.equalsIgnoreCase("Blue") ? CSSColourParser.hexToColor("#0000FF") : (string.equalsIgnoreCase("Teal") ? CSSColourParser.hexToColor("#008080") : (string.equalsIgnoreCase("Aqua") ? CSSColourParser.hexToColor("#00FFFF") : CSSColourParser.hexToColor(string)))))))))))))))))));
        return color;
    }

    private static Color parseRGB(String string) {
        int[] nArray = new int[]{4};
        int n = CSSColourParser.getColorComponent(string, nArray);
        int n2 = CSSColourParser.getColorComponent(string, nArray);
        int n3 = CSSColourParser.getColorComponent(string, nArray);
        return new Color(n, n2, n3);
    }

    private static int getColorComponent(String string, int[] nArray) {
        char c;
        int n = string.length();
        while (nArray[0] < n && (c = string.charAt(nArray[0])) != '-' && !Character.isDigit(c) && c != '.') {
            nArray[0] = nArray[0] + 1;
        }
        int n2 = nArray[0];
        if (n2 < n && string.charAt(nArray[0]) == '-') {
            nArray[0] = nArray[0] + 1;
        }
        while (nArray[0] < n && Character.isDigit(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] < n && string.charAt(nArray[0]) == '.') {
            nArray[0] = nArray[0] + 1;
            while (nArray[0] < n && Character.isDigit(string.charAt(nArray[0]))) {
                nArray[0] = nArray[0] + 1;
            }
        }
        if (n2 != nArray[0]) {
            try {
                float f = Float.parseFloat(string.substring(n2, nArray[0]));
                if (nArray[0] < n && string.charAt(nArray[0]) == '%') {
                    nArray[0] = nArray[0] + 1;
                    f = f * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)f));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

