'\" t
.\" Manual page created with latex2man on Wed Feb 29 10:58:48 EST 2012
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "JELLYFISH" "1" "2010/10/1" "k\-mer counter " "k\-mer counter "
.SH NAME

.PP
Jellyfish
is a software to count k\-mers in DNA sequences. 
.PP
.SH SYNOPSIS

jellyfish count
[\fB\-o\fP\fIprefix\fP]
[\fB\-m\fP\fImerlength\fP]
[\fB\-t\fP\fIthreads\fP]
[\fB\-s\fP\fIhashsize\fP]
[\fB--both\-strands\fP]
\fIfasta\fP
[\fIfasta \&...
\fP]
.br
jellyfish merge
\fIhash1\fP
\fIhash2\fP
\&...
.br
jellyfish dump
\fIhash\fP
.br
jellyfish stats
\fIhash\fP
.br
jellyfish histo
[\fB\-h\fP\fIhigh\fP]
[\fB\-l\fP\fIlow\fP]
[\fB\-i\fP\fIincrement\fP]
\fIhash\fP
.br
jellyfish query
\fIhash\fP
.br
jellyfish cite
.br
.PP
Plus equivalent version for Quake
mode: qhisto,
qdump
and qmerge\&.
.PP
.SH DESCRIPTION

.PP
Jellyfish
is a k\-mer counter based on a multi\-threaded hash 
table implementation. 
.PP
.SS COUNTING AND MERGING
.PP
To count k\-mers, use a command like: 
.PP
.Vb
jellyfish count \-m 22 \-o output \-c 3 \-s 10000000 \-t 32 input.fasta
.Ve
.PP
This will count the the 22\-mers in input.fasta with 32 threads. The 
counter field in the hash uses only 3 bits and the hash has at least 
10 million entries. 
.PP
The output files will be named output_0, output_1, etc. (the prefix 
is specified with the \fB\-o\fP
switch). If the hash is large enough 
(has specified by the \fB\-s\fP
switch) to fit all the k\-mers, there 
will be only one output file named output_0. If the hash filled up 
before all the mers were read, the hash is dumped to disk, zeroed out 
and reading in mers resumes. Multiple intermediary files will be 
present on the disks, named output_0, output_1, etc. 
.PP
To obtain correct results from the other sub\-commands (such as histo, 
stats, etc.), the multiple output files, if any, need to be merged into one 
with the merge command. For example with the following command: 
.PP
.Vb
jellyfish merge \-o output.jf output\\_*
.Ve
.PP
Should you get many intermediary output files (say hundreds), the size 
of the hash table is too small. Rerunning Jellyfish
with a 
larger size (option \fB\-s\fP)
is probably faster than merging all the 
intermediary files. 
.PP
.SS ORIENTATION
When the orientation of the sequences in the input fasta file is not 
known, e.g. in sequencing reads, using \fB--both\-strands\fP
(\fB\-C\fP)
makes the most sense. 
.PP
For any k\-mer m, its canonical representation is m itself or its 
reverse\-complement, whichever comes first lexicographically. With the 
option \fB\-C\fP,
only the canonical representation of the mers are 
stored in the hash and the count value is the number of occurrences of 
both the mer and its reverse\-complement. 
.PP
.SS CHOOSING THE HASH SIZE
.PP
To achieve the best performance, a minimum number of intermediary 
files should be written to disk. So the parameter \fB\-s\fP
should be 
chosen to fit as many k\-mers as possible (ideally all of them) while 
still fitting in memory. 
.PP
We consider to examples: counting mers in sequencing reads and in a 
finished genome. 
.PP
First, suppose we count k\-mers in short sequencing reads: 
there are n reads and there is an average of 1 error per reads where 
each error generates k unique mers. If the genome size is G, the 
size of the hash (option \fB\-s\fP)
to fit all k\-mers at once is estimated to: $(G + 
k*n)/0.8$. The division by 0.8 compensates for the maximum usage of 
approximately $80%$ of the hash table. 
.PP
On the other hand, when counting k\-mers in an assembled sequence of 
length G, setting \fB\-s\fP
to G is appropriate. 
.PP
As a matter of convenience, Jellyfish understands ISO suffixes for the 
size of the hash. Hence \&'\-s 10M\&' stands 10 million entries while \&'\-s 
50G\&' stands for 50 billion entries. 
.PP
The actual memory usage of the hash table can be computed as 
follow. The actual size of the hash will be rounded up to the next 
power of 2: s=2^l\&. The parameter r is such that the maximum 
reprobe value (\fB\-p\fP)
plus one is less than 2^r\&. Then the memory usage per 
entry in the hash is (in bits, not bytes) 2k\-l+r+1\&. The total memory 
usage of the hash table in bytes is: 2^l*(2k\-l+r+1)/8\&. 
.PP
.SS CHOOSING THE COUNTING FIELD SIZE
To save space, the hash table supports variable length counter, i.e. a 
k\-mer occurring only a few times will use a small counter, a k\-mer 
occurring many times will used multiple entries in the hash. 
.PP
Important: the size of the couting field does NOT change the result, 
it only impacts the amount of memory used. In particular, there is no 
maximum value in the hash. Even if the counting field uses 5 bits, a 
k\-mer occuring 2 million times will have a value reported of 2 
million (i.e., it is not capped at 2^5). 
.PP
The \fB\-c\fP
specify the length (in bits) of the counting field. The 
trade off is as follows: a low value will save space per entry in the 
hash but can potentially increase the number of entries used, hence 
maybe requiring a larger hash. 
.PP
In practice, use a value for \fB\-c\fP
so that most of you k\-mers 
require only 1 entry. For example, to count k\-mers in a genome, 
where most of the sequence is unique, use \fB\-c\fP\fI1\fP
or 
\fB\-c\fP\fI2\fP\&.
For sequencing reads, use a value for \fB\-c\fP
large 
enough to counts up to twice the coverage. For example, if the 
coverage is 10X, choose a counter length of 5 (\fB\-c\fP\fI5\fP)
as $2^5 > 20$. 
.PP
.SH SUBCOMMANDS AND OPTIONS

.SS COUNT
Usage: jellyfish count [options] file:path+ 
.PP
Count k\-mers or qmers in fasta or fastq files 
.PP
Options (default value in (), *required): 
.TP
\fB\-m\fP,
\fB--mer\-len\fP\fI=uint32\fP
 *Length of mer 
.TP
\fB\-s\fP,
\fB--size\fP\fI=uint64\fP
 *Hash size 
.TP
\fB\-t\fP,
\fB--threads\fP\fI=uint32\fP
 Number of threads (1) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output prefix (mer_counts) 
.TP
\fB\-c\fP,
\fB--counter\-len\fP\fI=Length\fP
 in bits Length of counting field (7) 
.TP
\fB--out\-counter\-len\fP\fI=Length\fP
 in bytes Length of counter field in output (4) 
.TP
\fB\-C\fP,\fB--both\-strands\fP
 Count both strand, canonical representation (false) 
.TP
\fB\-p\fP,
\fB--reprobes\fP\fI=uint32\fP
 Maximum number of reprobes (62) 
.TP
\fB\-r\fP,\fB--raw\fP
 Write raw database (false) 
.TP
\fB\-q\fP,\fB--quake\fP
 Quake compatibility mode (false) 
.TP
\fB--quality\-start\fP\fI=uint32\fP
 Starting ASCII for quality values (64) 
.TP
\fB--min\-quality\fP\fI=uint32\fP
 Minimum quality. A base with lesser quality becomes an N (0) 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=uint64\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=uint64\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB--matrix\fP\fI=Matrix\fP
 file Hash function binary matrix 
.TP
\fB--timing\fP\fI=Timing\fP
 file Print timing information 
.TP
\fB--stats\fP\fI=Stats\fP
 file Print stats 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB--full\-help\fP
 Detailed help 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS STATS
Usage: jellyfish stats [options] db:path 
.PP
Statistics 
.PP
Display some statistics about the k\-mers in the hash: 
.PP
Unique: Number of k\-mers which occur only once. 
Distinct: Number of k\-mers, not counting multiplicity. 
Total: Number of k\-mers, including multiplicity. 
Max_count: Maximum number of occurrence of a k\-mer. 
.PP
Options (default value in (), *required): 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=uint64\fP
 Don\&'t consider k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=uint64\fP
 Don\&'t consider k\-mer with count > upper\-count 
.TP
\fB\-v\fP,\fB--verbose\fP
 Verbose (false) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB--full\-help\fP
 Detailed help 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS HISTO
Usage: jellyfish histo [options] db:path 
.PP
Create an histogram of k\-mer occurrences 
.PP
Create an histogram with the number of k\-mers having a given 
count. In bucket \&'i\&' are tallied the k\-mers which have a count \&'c\&' 
satisfying \&'low+i*inc <= c < low+(i+1)*inc\&'\&. Buckets in the output are 
labeled by the low end point (low+i*inc). 
.PP
The last bucket in the output behaves as a catchall: it tallies all 
k\-mers with a count greater or equal to the low end point of this 
bucket. 
.PP
Options (default value in (), *required): 
.TP
\fB\-l\fP,
\fB--low\fP\fI=uint64\fP
 Low count value of histogram (1) 
.TP
\fB\-h\fP,
\fB--high\fP\fI=uint64\fP
 High count value of histogram (10000) 
.TP
\fB\-i\fP,
\fB--increment\fP\fI=uint64\fP
 Increment value for buckets (1) 
.TP
\fB\-t\fP,
\fB--threads\fP\fI=uint32\fP
 Number of threads (1) 
.TP
\fB\-f\fP,\fB--full\fP
 Full histo. Don\&'t skip count 0. (false) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file 
.TP
\fB\-v\fP,\fB--verbose\fP
 Output information (false) 
.TP
\fB--usage\fP
 Usage 
.TP
\fB--help\fP
 This message 
.TP
\fB--full\-help\fP
 Detailed help 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS DUMP
Usage: jellyfish dump [options] db:path 
.PP
Dump k\-mer counts 
.PP
By default, dump in a fasta format where the header is the count and 
the sequence is the sequence of the k\-mer. The column format is a 2 
column output: k\-mer count. 
.PP
Options (default value in (), *required): 
.TP
\fB\-c\fP,\fB--column\fP
 Column format (false) 
.TP
\fB\-t\fP,\fB--tab\fP
 Tab separator (false) 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=uint64\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=uint64\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS MERGE
Usage: jellyfish merge [options] input:string+ 
.PP
Merge jellyfish databases 
.PP
Options (default value in (), *required): 
.TP
\fB\-s\fP,
\fB--buffer\-size\fP\fI=Buffer\fP
 length Length in bytes of input buffer (10000000) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file (mer_counts_merged.jf) 
.TP
\fB--out\-counter\-len\fP\fI=uint32\fP
 Length (in bytes) of counting field in output (4) 
.TP
\fB--out\-buffer\-size\fP\fI=uint64\fP
 Size of output buffer per thread (10000000) 
.TP
\fB\-v\fP,\fB--verbose\fP
 Be verbose (false) 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS QUERY
Usage: jellyfish query [options] db:path 
.PP
Query from a compacted database 
.PP
Query a hash. It reads k\-mers from the standard input and write the counts on the standard output. 
.PP
Options (default value in (), *required): 
.TP
\fB\-C\fP,\fB--both\-strands\fP
 Both strands (false) 
.TP
\fB\-c\fP,\fB--cary\-bit\fP
 Value field as the cary bit information (false) 
.TP
\fB\-i\fP,
\fB--input\fP\fI=file\fP
 Input file 
.TP
\fB\-o\fP,
\fB--output\fP\fI=file\fP
 Output file 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS QHISTO
Usage: jellyfish qhisto [options] db:string 
.PP
Create an histogram of k\-mer occurences 
.PP
Options (default value in (), *required): 
.TP
\fB\-l\fP,
\fB--low\fP\fI=double\fP
 Low count value of histogram (0.0) 
.TP
\fB\-h\fP,
\fB--high\fP\fI=double\fP
 High count value of histogram (10000.0) 
.TP
\fB\-i\fP,
\fB--increment\fP\fI=double\fP
 Increment value for buckets (1.0) 
.TP
\fB\-f\fP,\fB--full\fP
 Full histo. Don\&'t skip count 0. (false) 
.TP
\fB--usage\fP
 Usage 
.TP
\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS QDUMP
Usage: jellyfish qdump [options] db:path 
.PP
Dump k\-mer from a qmer database 
.PP
By default, dump in a fasta format where the header is the count and 
the sequence is the sequence of the k\-mer. The column format is a 2 
column output: k\-mer count. 
.PP
Options (default value in (), *required): 
.TP
\fB\-c\fP,\fB--column\fP
 Column format (false) 
.TP
\fB\-t\fP,\fB--tab\fP
 Tab separator (false) 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=double\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=double\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB\-v\fP,\fB--verbose\fP
 Be verbose (false) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS QMERGE
Usage: jellyfish merge [options] db:string+ 
.PP
Merge quake databases 
.PP
Options (default value in (), *required): 
.TP
\fB\-s\fP,
\fB--size\fP\fI=uint64\fP
 *Merged hash table size 
.TP
\fB\-m\fP,
\fB--mer\-len\fP\fI=uint32\fP
 *Mer length 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file (merged.jf) 
.TP
\fB\-p\fP,
\fB--reprobes\fP\fI=uint32\fP
 Maximum number of reprobes (62) 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB--full\-help\fP
 Detailed help 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SS CITE
Usage: jellyfish cite [options] 
.PP
How to cite Jellyfish\&'s paper 
.PP
Citation of paper 
.PP
Options (default value in (), *required): 
.TP
\fB\-b\fP,\fB--bibtex\fP
 Bibtex format (false) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=string\fP
 Output file 
.TP
\fB--usage\fP
 Usage 
.TP
\fB\-h\fP,\fB--help\fP
 This message 
.TP
\fB\-V\fP,\fB--version\fP
 Version 
.PP
.SH VERSION

.PP
Version: 1.1.4 of 2010/10/1
.PP
.SH BUGS

.PP
.TP
.B *
jellyfish merge has not been parallelized and is
relatively slow. 
.TP
.B *
The hash table does not grow in memory automatically and 
jellyfish merge
is not called automatically on the 
intermediary files (if any). 
.PP
.SH COPYRIGHT & LICENSE

.TP
Copyright 
(C)2010, Guillaume Marcais \fBguillaume@marcais.net\fP
and Carl Kingsford \fBcarlk@umiacs.umd.edu\fP\&.
.PP
.TP
License 
This program is free software: you can redistribute it 
and/or modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, either version 3 of 
the License, or (at your option) any later version. 
.br
This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
General Public License for more details. 
.br
You should have received a copy of the GNU General Public License 
along with this program. If not, see 
\fBhttp://www.gnu.org/licenses/\fP\&.
.PP
.SH AUTHORS

Guillaume Marcais 
.br
University of Maryland 
.br
\fBgmarcais@umd.edu\fP
.PP
Carl Kingsford 
.br
University of Maryland 
.br
\fBcarlk@umiacs.umd.edu\fP
.PP
.\" NOTE: This file is generated, DO NOT EDIT.
