/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.jetty.security.SslSocketConnector;

public class Krb5AndCertsSslSocketConnector
extends SslSocketConnector {
    public static final List<String> KRB5_CIPHER_SUITES = Collections.unmodifiableList(Collections.singletonList("TLS_KRB5_WITH_3DES_EDE_CBC_SHA"));
    private static final Log LOG;
    private static final String REMOTE_PRINCIPAL = "remote_principal";
    private final boolean useKrb;
    private final boolean useCerts;

    public Krb5AndCertsSslSocketConnector() {
        this.useKrb = true;
        this.useCerts = false;
        this.setPasswords();
    }

    public Krb5AndCertsSslSocketConnector(MODE mode) {
        this.useKrb = mode == MODE.KRB || mode == MODE.BOTH;
        this.useCerts = mode == MODE.CERTS || mode == MODE.BOTH;
        this.setPasswords();
        this.logIfDebug("useKerb = " + this.useKrb + ", useCerts = " + this.useCerts);
    }

    private void setPasswords() {
        if (!this.useCerts) {
            Random r = new Random();
            System.setProperty("jetty.ssl.password", String.valueOf(r.nextLong()));
            System.setProperty("jetty.ssl.keypassword", String.valueOf(r.nextLong()));
        }
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        if (this.useCerts) {
            return super.createFactory();
        }
        SSLContext context = super.getProvider() == null ? SSLContext.getInstance(super.getProtocol()) : SSLContext.getInstance(super.getProtocol(), super.getProvider());
        context.init(null, null, null);
        return context.getServerSocketFactory();
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        this.logIfDebug("Creating new KrbServerSocket for: " + host);
        SSLServerSocket ss = null;
        if (this.useCerts) {
            ss = (SSLServerSocket)super.newServerSocket(host, port, backlog);
        } else {
            try {
                ss = (SSLServerSocket)(host == null ? this.createFactory().createServerSocket(port, backlog) : this.createFactory().createServerSocket(port, backlog, InetAddress.getByName(host)));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not create KRB5 Listener", (Throwable)e);
                throw new IOException("Could not create KRB5 Listener: " + e.toString());
            }
        }
        if (this.useKrb) {
            String[] combined;
            ss.setNeedClientAuth(true);
            if (this.useCerts) {
                String[] certs = ss.getEnabledCipherSuites();
                combined = new String[certs.length + KRB5_CIPHER_SUITES.size()];
                System.arraycopy(certs, 0, combined, 0, certs.length);
                System.arraycopy(KRB5_CIPHER_SUITES.toArray(new String[0]), 0, combined, certs.length, KRB5_CIPHER_SUITES.size());
            } else {
                combined = KRB5_CIPHER_SUITES.toArray(new String[0]);
            }
            ss.setEnabledCipherSuites(combined);
        }
        return ss;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        if (this.useKrb) {
            SSLSocket sslSocket = (SSLSocket)endpoint.getTransport();
            Principal remotePrincipal = sslSocket.getSession().getPeerPrincipal();
            this.logIfDebug("Remote principal = " + remotePrincipal);
            request.setScheme("https");
            request.setAttribute(REMOTE_PRINCIPAL, (Object)remotePrincipal);
            if (!this.useCerts) {
                String cipherSuite = sslSocket.getSession().getCipherSuite();
                Integer keySize = ServletSSL.deduceKeyLength((String)cipherSuite);
                request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
                request.setAttribute("javax.servlet.request.key_size", (Object)keySize);
            }
        }
        if (this.useCerts) {
            super.customize(endpoint, request);
        }
    }

    private void logIfDebug(String s) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)s);
        }
    }

    static {
        System.setProperty("https.cipherSuites", KRB5_CIPHER_SUITES.get(0));
        LOG = LogFactory.getLog(Krb5AndCertsSslSocketConnector.class);
    }

    public static class Krb5SslFilter
    implements Filter {
        public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
            final Principal princ = (Principal)req.getAttribute(Krb5AndCertsSslSocketConnector.REMOTE_PRINCIPAL);
            if (princ == null || !(princ instanceof KerberosPrincipal)) {
                LOG.warn((Object)("User not authenticated via kerberos from " + req.getRemoteAddr()));
                ((HttpServletResponse)resp).sendError(403, "User not authenticated via Kerberos");
                return;
            }
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)req){

                public Principal getUserPrincipal() {
                    return princ;
                }

                public String getRemoteUser() {
                    return princ.getName();
                }
            };
            chain.doFilter((ServletRequest)wrapper, resp);
        }

        public void init(FilterConfig arg0) throws ServletException {
        }

        public void destroy() {
        }
    }

    public static enum MODE {
        KRB,
        CERTS,
        BOTH;

    }
}

