/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.misc.CVM;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;

    private Method() {
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Class[] classArray;
            Class[] classArray2;
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName().equals(method.getName()) && (classArray2 = this.parameterTypes).length == (classArray = method.parameterTypes).length) {
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object2 = null;
        if (object == null && (this.getModifiers() & 8) == 0) {
            throw new NullPointerException("Method.invoke()");
        }
        if (this.parameterTypes.length == 0 ? objectArray != null && objectArray.length != 0 : objectArray == null || objectArray.length != this.parameterTypes.length) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        CVM.setContextArtificial();
        try {
            if (this.returnType == Void.TYPE) {
                this.invokeV(object, objectArray);
            } else {
                object2 = this.returnType == Boolean.TYPE ? new Boolean(this.invokeZ(object, objectArray)) : (this.returnType == Character.TYPE ? new Character(this.invokeC(object, objectArray)) : (this.returnType == Float.TYPE ? new Float(this.invokeF(object, objectArray)) : (this.returnType == Double.TYPE ? new Double(this.invokeD(object, objectArray)) : (this.returnType == Byte.TYPE ? new Byte(this.invokeB(object, objectArray)) : (this.returnType == Short.TYPE ? new Short(this.invokeS(object, objectArray)) : (this.returnType == Integer.TYPE ? new Integer(this.invokeI(object, objectArray)) : (this.returnType == Long.TYPE ? new Long(this.invokeL(object, objectArray)) : this.invokeA(object, objectArray))))))));
            }
        }
        catch (ArgumentException argumentException) {
            throw new IllegalArgumentException("wrong object type, or unwrapping conversion failed: " + argumentException.getMessage());
        }
        catch (AccessException accessException) {
            throw new IllegalAccessException(this.name);
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
        return object2;
    }

    private native void invokeV(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native boolean invokeZ(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native char invokeC(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native float invokeF(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native double invokeD(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native byte invokeB(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native short invokeS(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native int invokeI(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native long invokeL(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private native Object invokeA(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    static Class[] copy(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray2[i] = classArray[i];
        }
        return classArray2;
    }

    private static class AccessException
    extends Exception {
        private AccessException() {
        }
    }

    private static class ArgumentException
    extends Exception {
        private ArgumentException() {
        }
    }
}

