/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable {
    private transient Calendar cal = null;
    private transient long fastTime;
    private static Calendar staticCal = null;
    private static Calendar utcCal = null;
    private static int defaultCenturyStart = 0;
    private static final long serialVersionUID = 7523967970034938905L;
    private static SoftReference simpleFormatter = null;
    private static SoftReference gmtFormatter = null;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this.fastTime = l;
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (date.cal != null) {
                date.cal = (Calendar)date.cal.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        return this.cal == null ? this.fastTime : this.cal.getTimeInMillis();
    }

    public void setTime(long l) {
        if (this.cal == null) {
            this.fastTime = l;
        } else {
            this.cal.setTimeInMillis(l);
        }
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int compareTo(Date date) {
        long l;
        long l2 = this.getTime();
        return l2 < (l = date.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DateFormat dateFormat = null;
        if (simpleFormatter != null) {
            dateFormat = (DateFormat)simpleFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            simpleFormatter = new SoftReference(dateFormat);
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setTimeZone(TimeZone.getDefault());
            return dateFormat.format(this);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTimeImpl());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getField(int n) {
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.fastTime);
                return staticCal.get(n);
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        if (!timeZone.equals(this.cal.getTimeZone())) {
            long l = this.cal.getTimeInMillis();
            this.cal.setTimeZone(TimeZone.getDefault());
            this.cal.setTimeInMillis(l);
        }
        return this.cal.get(n);
    }

    private final void setField(int n, int n2) {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
            this.cal.setTimeInMillis(this.fastTime);
        }
        this.cal.set(n, n2);
    }

    private static synchronized void makeStaticCalendars() {
        if (staticCal == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            utcCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            defaultCenturyStart = gregorianCalendar.get(1) - 80;
            staticCal = gregorianCalendar;
        }
    }
}

