/*
 * Copyright (C) 2013 Emmanuel Engelhart <kelson@kiwix.org>
 * Copyright (C) 2017 Matthieu Gautier <mgautier@kymeria.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

package org.kiwix.kiwixlib;

import org.kiwix.kiwixlib.JNIKiwixException;
import org.kiwix.kiwixlib.JNIKiwixString;
import org.kiwix.kiwixlib.JNIKiwixInt;
import org.kiwix.kiwixlib.JNIKiwixSearcher;
import org.kiwix.kiwixlib.Pair;

public class JNIKiwixReader
{
  public native String getMainPage();

  public native String getTitle();

  public native String getId();

  public native String getLanguage();

  public native String getMimeType(String url);

  public native byte[] getContent(String url,
                                  JNIKiwixString title,
                                  JNIKiwixString mimeType,
                                  JNIKiwixInt size);

  /**
   * getContentPart.
   *
   * Get only a part of the content of the article.
   * Return a byte array of `len` size starting from offset `offset`.
   * Set `size` to the number of bytes read
   * (`len` if everything is ok, 0 in case of error).
   * If `len` == 0, no bytes are read but `size` is set to the total size of the
   * article.
   */
  public native byte[] getContentPart(String url,
                                      int offest,
                                      int len,
                                      JNIKiwixInt size);

  /**
   * getDirectAccessInformation.
   *
   * Return information giving where the content is located in the zim file.
   *
   * Some contents (binary content) are stored uncompressed in the zim file.
   * Knowing this information, it could be interesting to directly open
   * the zim file (or zim part) and directly read the content from it (and so
   * bypassing the libzim).
   *
   * Return a `Pair` (filename, offset) where the content is located.
   *
   * If the content cannot be directly accessed (content is compressed or zim
   * file is cut in the middle of the content), the filename is an empty string
   * and offset is zero.
   */
  public native Pair getDirectAccessInformation(String url);

  public native boolean searchSuggestions(String prefix, int count);

  public native boolean getNextSuggestion(JNIKiwixString title);

  public native boolean getPageUrlFromTitle(String title, JNIKiwixString url);

  public native String getDescription();

  public native String getDate();

  public native String getFavicon();

  public native String getCreator();

  public native String getPublisher();

  public native String getName();

  public native int getFileSize();

  public native int getArticleCount();

  public native int getMediaCount();

  public native boolean getRandomPage(JNIKiwixString url);

  public JNIKiwixSearcher search(String query, int count)
  {
    JNIKiwixSearcher searcher = new JNIKiwixSearcher();
    searcher.addKiwixReader(this);
    searcher.search(query, count);
    return searcher;
  }

  public JNIKiwixReader(String filename) throws JNIKiwixException
  {
    nativeHandle = getNativeReader(filename);
    if (nativeHandle == 0) {
        throw new JNIKiwixException("Cannot open zimfile "+filename);
    }
  }
  public JNIKiwixReader() {

  }
  public native void dispose();

  private native long getNativeReader(String filename);
  private long nativeHandle;
}
