# vim:set ft= ts=4 sw=4 et fdm=marker:

our $SkipReason;

BEGIN {
    if ($ENV{TEST_NGINX_EVENT_TYPE} && $ENV{TEST_NGINX_EVENT_TYPE} ne 'poll') {
        $SkipReason = "unavailable for the event type '$ENV{TEST_NGINX_EVENT_TYPE}'";

    } elsif ($ENV{TEST_NGINX_USE_HTTP3}) {
        $SkipReason = "http3 does not support mockeagain";

    } elsif ($ENV{TEST_NGINX_USE_HTTP2}) {
        $SkipReason = "http2 does not support mockeagain";

    } else {
        if ($ENV{LD_PRELOAD} && $ENV{LD_PRELOAD} =~ /\bmockeagain\.so\b/) {
            $ENV{TEST_NGINX_POSTPONE_OUTPUT} = 1;
            $ENV{TEST_NGINX_EVENT_TYPE} = 'poll';
            $ENV{MOCKEAGAIN}='w'
        } else {
            $SkipReason = "'mockeagain.so' does not appear to be preloaded "
                . "with 'LD_PRELOAD'";
        }
    }
}

use Test::Nginx::Socket::Lua $SkipReason ? (skip_all => $SkipReason) : ();

#worker_connections(1014);
#master_process_enabled(1);
#log_level('warn');

log_level('debug');

repeat_each(2);

plan tests => repeat_each() * (blocks() * 5);

#no_diff();
no_long_string();

run_tests();

__DATA__

=== TEST 1: check ctx->busy_bufs
--- config
    location /t {
        postpone_output 1;
        content_by_lua_block {
            for i = 1, 5 do
                ngx.say(i, ": Hello World!")
            end
        }

        body_filter_by_lua_block {
            ngx.arg[1] = ngx.arg[1]
        }
    }
--- request
GET /t
--- response_body
1: Hello World!
2: Hello World!
3: Hello World!
4: Hello World!
5: Hello World!

--- error_log
waiting body filter busy buffer to be sent
lua say response has busy bufs
--- no_error_log
[error]



=== TEST 2: arg[1] not change and say long string
--- config
    location /t {
        header_filter_by_lua_block {ngx.header.content_length = nil}
        body_filter_by_lua_block {
            local function anyting_not_change_arg1()
                return
            end
            anyting_not_change_arg1()
        }
        content_by_lua_block {
            for i = 1, 100 do
                ngx.say("12345678901234567890")
            end
        }
    }
--- request
GET /t
--- response_body eval
("12345678901234567890\n" x 100)
--- no_error_log
[error]
[alert]
[crit]



=== TEST 3: arg[1] not change and chunked_transfer_encoding off
--- config
    location /t {
        header_filter_by_lua_block {ngx.header.content_length = nil}
        body_filter_by_lua_block {
            local function anyting_not_change_arg1()
                return
            end
            anyting_not_change_arg1()
        }
        chunked_transfer_encoding off;
        content_by_lua_block {
            for i = 1, 100 do
                ngx.say("12345678901234567890123456789012345678901234567890".."_"..tostring(i/3))
            end
        }
    }
--- request
GET /t
--- response_body
12345678901234567890123456789012345678901234567890_0.33333333333333
12345678901234567890123456789012345678901234567890_0.66666666666667
12345678901234567890123456789012345678901234567890_1
12345678901234567890123456789012345678901234567890_1.3333333333333
12345678901234567890123456789012345678901234567890_1.6666666666667
12345678901234567890123456789012345678901234567890_2
12345678901234567890123456789012345678901234567890_2.3333333333333
12345678901234567890123456789012345678901234567890_2.6666666666667
12345678901234567890123456789012345678901234567890_3
12345678901234567890123456789012345678901234567890_3.3333333333333
12345678901234567890123456789012345678901234567890_3.6666666666667
12345678901234567890123456789012345678901234567890_4
12345678901234567890123456789012345678901234567890_4.3333333333333
12345678901234567890123456789012345678901234567890_4.6666666666667
12345678901234567890123456789012345678901234567890_5
12345678901234567890123456789012345678901234567890_5.3333333333333
12345678901234567890123456789012345678901234567890_5.6666666666667
12345678901234567890123456789012345678901234567890_6
12345678901234567890123456789012345678901234567890_6.3333333333333
12345678901234567890123456789012345678901234567890_6.6666666666667
12345678901234567890123456789012345678901234567890_7
12345678901234567890123456789012345678901234567890_7.3333333333333
12345678901234567890123456789012345678901234567890_7.6666666666667
12345678901234567890123456789012345678901234567890_8
12345678901234567890123456789012345678901234567890_8.3333333333333
12345678901234567890123456789012345678901234567890_8.6666666666667
12345678901234567890123456789012345678901234567890_9
12345678901234567890123456789012345678901234567890_9.3333333333333
12345678901234567890123456789012345678901234567890_9.6666666666667
12345678901234567890123456789012345678901234567890_10
12345678901234567890123456789012345678901234567890_10.333333333333
12345678901234567890123456789012345678901234567890_10.666666666667
12345678901234567890123456789012345678901234567890_11
12345678901234567890123456789012345678901234567890_11.333333333333
12345678901234567890123456789012345678901234567890_11.666666666667
12345678901234567890123456789012345678901234567890_12
12345678901234567890123456789012345678901234567890_12.333333333333
12345678901234567890123456789012345678901234567890_12.666666666667
12345678901234567890123456789012345678901234567890_13
12345678901234567890123456789012345678901234567890_13.333333333333
12345678901234567890123456789012345678901234567890_13.666666666667
12345678901234567890123456789012345678901234567890_14
12345678901234567890123456789012345678901234567890_14.333333333333
12345678901234567890123456789012345678901234567890_14.666666666667
12345678901234567890123456789012345678901234567890_15
12345678901234567890123456789012345678901234567890_15.333333333333
12345678901234567890123456789012345678901234567890_15.666666666667
12345678901234567890123456789012345678901234567890_16
12345678901234567890123456789012345678901234567890_16.333333333333
12345678901234567890123456789012345678901234567890_16.666666666667
12345678901234567890123456789012345678901234567890_17
12345678901234567890123456789012345678901234567890_17.333333333333
12345678901234567890123456789012345678901234567890_17.666666666667
12345678901234567890123456789012345678901234567890_18
12345678901234567890123456789012345678901234567890_18.333333333333
12345678901234567890123456789012345678901234567890_18.666666666667
12345678901234567890123456789012345678901234567890_19
12345678901234567890123456789012345678901234567890_19.333333333333
12345678901234567890123456789012345678901234567890_19.666666666667
12345678901234567890123456789012345678901234567890_20
12345678901234567890123456789012345678901234567890_20.333333333333
12345678901234567890123456789012345678901234567890_20.666666666667
12345678901234567890123456789012345678901234567890_21
12345678901234567890123456789012345678901234567890_21.333333333333
12345678901234567890123456789012345678901234567890_21.666666666667
12345678901234567890123456789012345678901234567890_22
12345678901234567890123456789012345678901234567890_22.333333333333
12345678901234567890123456789012345678901234567890_22.666666666667
12345678901234567890123456789012345678901234567890_23
12345678901234567890123456789012345678901234567890_23.333333333333
12345678901234567890123456789012345678901234567890_23.666666666667
12345678901234567890123456789012345678901234567890_24
12345678901234567890123456789012345678901234567890_24.333333333333
12345678901234567890123456789012345678901234567890_24.666666666667
12345678901234567890123456789012345678901234567890_25
12345678901234567890123456789012345678901234567890_25.333333333333
12345678901234567890123456789012345678901234567890_25.666666666667
12345678901234567890123456789012345678901234567890_26
12345678901234567890123456789012345678901234567890_26.333333333333
12345678901234567890123456789012345678901234567890_26.666666666667
12345678901234567890123456789012345678901234567890_27
12345678901234567890123456789012345678901234567890_27.333333333333
12345678901234567890123456789012345678901234567890_27.666666666667
12345678901234567890123456789012345678901234567890_28
12345678901234567890123456789012345678901234567890_28.333333333333
12345678901234567890123456789012345678901234567890_28.666666666667
12345678901234567890123456789012345678901234567890_29
12345678901234567890123456789012345678901234567890_29.333333333333
12345678901234567890123456789012345678901234567890_29.666666666667
12345678901234567890123456789012345678901234567890_30
12345678901234567890123456789012345678901234567890_30.333333333333
12345678901234567890123456789012345678901234567890_30.666666666667
12345678901234567890123456789012345678901234567890_31
12345678901234567890123456789012345678901234567890_31.333333333333
12345678901234567890123456789012345678901234567890_31.666666666667
12345678901234567890123456789012345678901234567890_32
12345678901234567890123456789012345678901234567890_32.333333333333
12345678901234567890123456789012345678901234567890_32.666666666667
12345678901234567890123456789012345678901234567890_33
12345678901234567890123456789012345678901234567890_33.333333333333
--- no_error_log
[error]
[alert]
[crit]



=== TEST 4: set resp body nil with ngx.arg[1] first
--- config
    location /t {
        content_by_lua_block {
            ngx.say("Hello World!")
        }

        body_filter_by_lua_block {
            ngx.arg[1] = ""
            ngx.arg[2] = true
        }
    }
--- request
GET /t
--- response_body
--- no_error_log
[error]
[alert]
[crit]



=== TEST 5: set resp body nil with ngx.arg[2] first
--- config
    location /t {
        content_by_lua_block {
            ngx.say("Hello World!")
        }

        body_filter_by_lua_block {
            ngx.arg[2] = true
            ngx.arg[1] = ""
        }
    }
--- request
GET /t
--- response_body
--- no_error_log
[error]
[alert]
[crit]
