/*******************************************************************************
* Copyright 2019-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cpu/x64/gemm/f32/common_f32.hpp"
#include "cpu/x64/gemm/f32/jit_avx_kernel_sgemm_kern_autogen.hpp"
#include "cpu/x64/jit_generator.hpp"

namespace dnnl {
namespace impl {
namespace cpu {
namespace x64 {

void jit_avx_kernel_sgemm_kern::generate_part2(
        Xbyak::Label &l1efc, Xbyak::Label &l1f44, Xbyak::Label &l1f48) {
    std::vector<Xbyak::Label> labels(69);
    L(l1efc);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1 + 0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1 + 0x0], ymm8);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(l1f44);
    mov(A, AO);
    align(4);

    L(l1f48);
    test(J, 0x4);
    jle(labels[22], T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x10);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x10);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[7], T_NEAR);
    align(4);

    L(labels[0]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[4], T_NEAR);
    sub(H, 0x1e);
    jle(labels[2], T_NEAR);
    align(4);

    L(labels[1]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[1], T_NEAR);
    align(4);

    L(labels[2]);
    prefetcht0(byte[CO1 + 0xc]);
    prefetcht0(byte[CO1 + LDC * 1 + 0xc]);
    prefetcht0(byte[CO2 + 0xc]);
    prefetcht0(byte[CO2 + LDC * 1 + 0xc]);
    add(H, 0x1e);
    align(4);

    L(labels[3]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[3], T_NEAR);
    align(4);

    L(labels[4]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[6], T_NEAR);
    align(4);

    L(labels[5]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x70]);
    vmovups(ymm1, yword[AO - 0x50]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -16);
    sub(BO, -16);
    dec(H);
    jg(labels[5], T_NEAR);
    align(4);

    L(labels[6]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1 + 0x0], xmm8);
    vmovups(xmm0, xword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovups(xword[CO1 + LDC * 1 + 0x0], xmm9);
    vmovups(xmm0, xword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovups(xword[CO2], xmm10);
    vmovups(xmm0, xword[CO2 + LDC * 1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovups(xword[CO2 + LDC * 1], xmm11);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[0], T_NEAR);
    align(4);

    L(labels[7]);
    test(I, 0x2);
    jle(labels[14], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[11], T_NEAR);
    sub(H, 0x1e);
    jle(labels[9], T_NEAR);
    align(4);

    L(labels[8]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[8], T_NEAR);
    align(4);

    L(labels[9]);
    prefetcht0(byte[CO1 + 0xc]);
    prefetcht0(byte[CO1 + LDC * 1 + 0xc]);
    add(H, 0x1e);
    align(4);

    L(labels[10]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[10], T_NEAR);
    align(4);

    L(labels[11]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[13], T_NEAR);
    align(4);

    L(labels[12]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x70]);
    vmovups(ymm1, yword[AO - 0x50]);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    sub(AO, -16);
    sub(BO, -8);
    dec(H);
    jg(labels[12], T_NEAR);
    align(4);

    L(labels[13]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1 + 0x0], xmm8);
    vmovups(xmm0, xword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovups(xword[CO1 + LDC * 1 + 0x0], xmm9);
    lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
    align(4);

    L(labels[14]);
    test(I, 0x1);
    jle(labels[21], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[18], T_NEAR);
    sub(H, 0x1e);
    jle(labels[16], T_NEAR);
    align(4);

    L(labels[15]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[15], T_NEAR);
    align(4);

    L(labels[16]);
    prefetcht0(byte[CO1 + 0xc]);
    add(H, 0x1e);
    align(4);

    L(labels[17]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[17], T_NEAR);
    align(4);

    L(labels[18]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[20], T_NEAR);
    align(4);

    L(labels[19]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x70]);
    vmovups(ymm1, yword[AO - 0x50]);
    vbroadcastf128(ymm2, xword[BO - 0x7c]);
    sub(AO, -16);
    sub(BO, -4);
    dec(H);
    jg(labels[19], T_NEAR);
    align(4);

    L(labels[20]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1 + 0x0], xmm8);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(labels[21]);
    mov(A, AO);
    align(4);

    L(labels[22]);
    test(J, 0x2);
    jle(labels[45], T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x8);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x8);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[30], T_NEAR);
    align(4);

    L(labels[23]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[27], T_NEAR);
    sub(H, 0x1e);
    jle(labels[25], T_NEAR);
    align(4);

    L(labels[24]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[24], T_NEAR);
    align(4);

    L(labels[25]);
    prefetcht0(byte[CO1 + 0x4]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x4]);
    prefetcht0(byte[CO2 + 0x4]);
    prefetcht0(byte[CO2 + LDC * 1 + 0x4]);
    add(H, 0x1e);
    align(4);

    L(labels[26]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[26], T_NEAR);
    align(4);

    L(labels[27]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[29], T_NEAR);
    align(4);

    L(labels[28]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x78]);
    vmovups(ymm1, yword[AO - 0x58]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -8);
    sub(BO, -16);
    dec(H);
    jg(labels[28], T_NEAR);
    align(4);

    L(labels[29]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1 + 0x0], xmm8);
    vmovsd(xmm0, qword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovlps(qword[CO1 + LDC * 1 + 0x0], xmm9);
    vmovsd(xmm0, qword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovlps(qword[CO2], xmm10);
    vmovsd(xmm0, qword[CO2 + LDC * 1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovlps(qword[CO2 + LDC * 1], xmm11);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[23], T_NEAR);
    align(4);

    L(labels[30]);
    test(I, 0x2);
    jle(labels[37], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[34], T_NEAR);
    sub(H, 0x1e);
    jle(labels[32], T_NEAR);
    align(4);

    L(labels[31]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[31], T_NEAR);
    align(4);

    L(labels[32]);
    prefetcht0(byte[CO1 + 0x4]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x4]);
    add(H, 0x1e);
    align(4);

    L(labels[33]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[33], T_NEAR);
    align(4);

    L(labels[34]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[36], T_NEAR);
    align(4);

    L(labels[35]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x78]);
    vmovups(ymm1, yword[AO - 0x58]);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    sub(AO, -8);
    sub(BO, -8);
    dec(H);
    jg(labels[35], T_NEAR);
    align(4);

    L(labels[36]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1 + 0x0], xmm8);
    vmovsd(xmm0, qword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovlps(qword[CO1 + LDC * 1 + 0x0], xmm9);
    lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
    align(4);

    L(labels[37]);
    test(I, 0x1);
    jle(labels[44], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[41], T_NEAR);
    sub(H, 0x1e);
    jle(labels[39], T_NEAR);
    align(4);

    L(labels[38]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[38], T_NEAR);
    align(4);

    L(labels[39]);
    prefetcht0(byte[CO1 + 0x4]);
    add(H, 0x1e);
    align(4);

    L(labels[40]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    sub(AO, -32);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[40], T_NEAR);
    align(4);

    L(labels[41]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[43], T_NEAR);
    align(4);

    L(labels[42]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x78]);
    vmovups(ymm1, yword[AO - 0x58]);
    vbroadcastf128(ymm2, xword[BO - 0x7c]);
    sub(AO, -8);
    sub(BO, -4);
    dec(H);
    jg(labels[42], T_NEAR);
    align(4);

    L(labels[43]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1 + 0x0], xmm8);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(labels[44]);
    mov(A, AO);
    align(4);

    L(labels[45]);
    test(J, 0x1);
    jle(labels[68], T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x4);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x4);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[53], T_NEAR);
    align(4);

    L(labels[46]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[50], T_NEAR);
    sub(H, 0x1e);
    jle(labels[48], T_NEAR);
    align(4);

    L(labels[47]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[47], T_NEAR);
    align(4);

    L(labels[48]);
    prefetcht0(byte[CO1 + 0x0]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x0]);
    prefetcht0(byte[CO2]);
    prefetcht0(byte[CO2 + LDC * 1]);
    add(H, 0x1e);
    align(4);

    L(labels[49]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[49], T_NEAR);
    align(4);

    L(labels[50]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[52], T_NEAR);
    align(4);

    L(labels[51]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmovups(ymm1, yword[AO - 0x5c]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -4);
    sub(BO, -16);
    dec(H);
    jg(labels[51], T_NEAR);
    align(4);

    L(labels[52]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1 + 0x0], xmm8);
    vmovss(xmm0, dword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovss(dword[CO1 + LDC * 1 + 0x0], xmm9);
    vmovss(xmm0, dword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovss(dword[CO2], xmm10);
    vmovss(xmm0, dword[CO2 + LDC * 1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovss(dword[CO2 + LDC * 1], xmm11);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[46], T_NEAR);
    align(4);

    L(labels[53]);
    test(I, 0x2);
    jle(labels[60], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[57], T_NEAR);
    sub(H, 0x1e);
    jle(labels[55], T_NEAR);
    align(4);

    L(labels[54]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[54], T_NEAR);
    align(4);

    L(labels[55]);
    prefetcht0(byte[CO1 + 0x0]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x0]);
    add(H, 0x1e);
    align(4);

    L(labels[56]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[56], T_NEAR);
    align(4);

    L(labels[57]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[59], T_NEAR);
    align(4);

    L(labels[58]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmovups(ymm1, yword[AO - 0x5c]);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    sub(AO, -4);
    sub(BO, -8);
    dec(H);
    jg(labels[58], T_NEAR);
    align(4);

    L(labels[59]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1 + 0x0], xmm8);
    vmovss(xmm0, dword[CO1 + LDC * 1 + 0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovss(dword[CO1 + LDC * 1 + 0x0], xmm9);
    lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
    align(4);

    L(labels[60]);
    test(I, 0x1);
    jle(labels[67], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[64], T_NEAR);
    sub(H, 0x1e);
    jle(labels[62], T_NEAR);
    align(4);

    L(labels[61]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[61], T_NEAR);
    align(4);

    L(labels[62]);
    prefetcht0(byte[CO1 + 0x0]);
    add(H, 0x1e);
    align(4);

    L(labels[63]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    sub(AO, -16);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[63], T_NEAR);
    align(4);

    L(labels[64]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[66], T_NEAR);
    align(4);

    L(labels[65]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x7c]);
    vmovups(ymm1, yword[AO - 0x5c]);
    vbroadcastf128(ymm2, xword[BO - 0x7c]);
    sub(AO, -4);
    sub(BO, -4);
    dec(H);
    jg(labels[65], T_NEAR);
    align(4);

    L(labels[66]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1 + 0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1 + 0x0], xmm8);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(labels[67]);
    mov(A, AO);
    align(4);

    L(labels[68]);
}

} // namespace x64
} // namespace cpu
} // namespace impl
} // namespace dnnl
