# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1189-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57483);
 script_cve_id("CVE-2006-4924", "CVE-2006-5051");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1189-1 (openssh-krb5)";
 script_name(name);

 desc = "The remote host is missing an update to openssh-krb5
announced via advisory DSA 1189-1.

Several remote vulnerabilities have been discovered in OpenSSH, a free
implementation of the Secure Shell protocol, which may lead to denial of
service and potentially the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2006-4924

Tavis Ormandy of the Google Security Team discovered a denial of
service vulnerability in the mitigation code against complexity
attacks, which might lead to increased CPU consumption until a
timeout is triggered. This is only exploitable if support for
SSH protocol version 1 is enabled.

CVE-2006-5051

Mark Dowd discovered that insecure signal handler usage could
potentially lead to execution of arbitrary code through a double
free. The Debian Security Team doesn't believe the general openssh
package without Kerberos support to be exploitable by this issue.
However, due to the complexity of the underlying code we will
issue an update to rule out all eventualities.

For the stable distribution (sarge) these problems have been fixed in
version 3.8.1p1-7sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 4.3p2-4 of openssh. openssh-krb5 will soon be converted towards
a transitional package against openssh.

We recommend that you upgrade your openssh-krb5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201189-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1189-1 (openssh-krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssh-krb5", ver:"3.8.1p1-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
