# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10329 (python-markdown2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66143);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-10329 (python-markdown2)");

 desc = "The remote host is missing an update to python-markdown2
announced via advisory FEDORA-2009-10329.

Update Information:

Update from 1.0.1.11 to 1.0.1.15, which fixes some issues, including these two
security-related bugs:
- [Issue 30] Fix a possible XSS via JavaScript injection in a carefully
             crafted image reference (usage of double-quotes in the URL).
- [Issue 29] Fix security hole in the md5-hashing scheme for handling HTML
             chunks during processing.
	     
See http://code.google.com/p/python-markdown2/source/browse/trunk/CHANGES.txt
for the full changelog.

ChangeLog:

* Thu Oct  8 2009 Thomas Moschny  - 1.0.1.15-1
- Update to 1.0.1.15. Fixes three issues, two of them being security-related.

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update python-markdown2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10329

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10329 (python-markdown2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"python-markdown2", rpm:"python-markdown2~1.0.1.15~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
