/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "messagewithcheckbox.h"

MessageWithCheckBox::MessageWithCheckBox(const QString & title, const QString & msg, const QString & qstn, int* res, QWidget* parent)
 : QDialog(parent),
 m_result(res)
{
  QGridLayout* grid = new QGridLayout(this);

  m_msg      = new QLabel(msg, this);
  m_icon     = new QLabel(this);
  m_question = new QCheckBox(qstn, this);
  m_okBtn    = new QPushButton(tr("Ok"), this);

  grid->addWidget(m_icon    , 0, 0, Qt::AlignCenter);
  grid->addWidget(m_msg     , 0, 1);
  grid->addWidget(m_question, 1, 0, 1, 2);
  grid->addWidget(m_okBtn   , 2, 0, 1, 2, Qt::AlignCenter);

  grid->setRowStretch(0, 1);
  grid->setRowStretch(1, 2);

  grid->setHorizontalSpacing(20);
  grid->setVerticalSpacing(20);

  grid->setMargin(20);

  m_icon->setAlignment(Qt::AlignCenter);

  connect(m_okBtn, SIGNAL(clicked()), this, SLOT(finish()));

  setModal(true);

  setWindowTitle(title);
}
