/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef USERLIST_H
#define USERLIST_H

#include <QObject>
#include "userinfo.h"

class UserWgt;


/**
        @author Anistratov Oleg <ower@users.sourceforge.net>
*/
class UsersList
{
  private:
    UserWgt** m_users;
    quint32   m_usersNum;
    quint32   m_maxUsersNum;
    UserWgt** m_hiddenUsers;
    quint32   m_hiddenUsersNum;
    quint32   m_maxHiddenUsersNum;

  public:
    UsersList();
    ~UsersList();

    bool     enabled   (quint64) const;
    bool     exists    (quint64) const;
    UserWgt* findUser  (quint64) const;
    UserWgt* findHidden(quint64) const;
    qint32   findNum   (quint64) const;
    UserWgt* user      (int     n) const;
    quint32  num       (         ) const {return m_usersNum;}

    void addUser           (UserWgt*);
    void disableAll        ();
    void enableAll         ();
    UserWgt* disable       (quint64);
    UserWgt* enable        (quint64);
    UserWgt* enableIfExists(quint64);
};

#endif
