/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from xdg-decoration-unstable-v1.xml by mir_wayland_generator
 */

#include "xdg-decoration-unstable-v1_wrapper.h"

#include <boost/exception/diagnostic_information.hpp>
#include <wayland-server-core.h>

#include "mir/log.h"
#include "mir/wayland/protocol_error.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const xdg_toplevel_interface_data;
extern struct wl_interface const zxdg_decoration_manager_v1_interface_data;
extern struct wl_interface const zxdg_toplevel_decoration_v1_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// XdgDecorationManagerV1

struct mw::XdgDecorationManagerV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgDecorationManagerV1::destroy()");
        }
    }

    static void get_toplevel_decoration_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* toplevel)
    {
        wl_resource* id_resolved{
            wl_resource_create(client, &zxdg_toplevel_decoration_v1_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            auto me = static_cast<XdgDecorationManagerV1*>(wl_resource_get_user_data(resource));
            me->get_toplevel_decoration(id_resolved, toplevel);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgDecorationManagerV1::get_toplevel_decoration()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<XdgDecorationManagerV1*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<XdgDecorationManagerV1::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &zxdg_decoration_manager_v1_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgDecorationManagerV1 global bind");
        }
    }

    static struct wl_interface const* get_toplevel_decoration_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

int const mw::XdgDecorationManagerV1::Thunks::supported_version = 1;

mw::XdgDecorationManagerV1::XdgDecorationManagerV1(struct wl_resource* resource, Version<1>)
    : Resource{resource}
{
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::XdgDecorationManagerV1::~XdgDecorationManagerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

bool mw::XdgDecorationManagerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zxdg_decoration_manager_v1_interface_data, Thunks::request_vtable);
}

mw::XdgDecorationManagerV1::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &zxdg_decoration_manager_v1_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::XdgDecorationManagerV1::Global::interface_name() const -> char const*
{
    return XdgDecorationManagerV1::interface_name;
}

struct wl_interface const* mw::XdgDecorationManagerV1::Thunks::get_toplevel_decoration_types[] {
    &zxdg_toplevel_decoration_v1_interface_data,
    &xdg_toplevel_interface_data};

struct wl_message const mw::XdgDecorationManagerV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"get_toplevel_decoration", "no", get_toplevel_decoration_types}};

void const* mw::XdgDecorationManagerV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::get_toplevel_decoration_thunk};

mw::XdgDecorationManagerV1* mw::XdgDecorationManagerV1::from(struct wl_resource* resource)
{
    if (resource &&
        wl_resource_instance_of(resource, &zxdg_decoration_manager_v1_interface_data, XdgDecorationManagerV1::Thunks::request_vtable))
    {
        return static_cast<XdgDecorationManagerV1*>(wl_resource_get_user_data(resource));
    }
    else
    {
        return nullptr;
    }
}

// XdgToplevelDecorationV1

struct mw::XdgToplevelDecorationV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgToplevelDecorationV1::destroy()");
        }
    }

    static void set_mode_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t mode)
    {
        try
        {
            auto me = static_cast<XdgToplevelDecorationV1*>(wl_resource_get_user_data(resource));
            me->set_mode(mode);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgToplevelDecorationV1::set_mode()");
        }
    }

    static void unset_mode_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<XdgToplevelDecorationV1*>(wl_resource_get_user_data(resource));
            me->unset_mode();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "XdgToplevelDecorationV1::unset_mode()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<XdgToplevelDecorationV1*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::XdgToplevelDecorationV1::Thunks::supported_version = 1;

mw::XdgToplevelDecorationV1::XdgToplevelDecorationV1(struct wl_resource* resource, Version<1>)
    : Resource{resource}
{
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::XdgToplevelDecorationV1::~XdgToplevelDecorationV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::XdgToplevelDecorationV1::send_configure_event(uint32_t mode) const
{
    wl_resource_post_event(resource, Opcode::configure, mode);
}

bool mw::XdgToplevelDecorationV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zxdg_toplevel_decoration_v1_interface_data, Thunks::request_vtable);
}

uint32_t const mw::XdgToplevelDecorationV1::Error::unconfigured_buffer;
uint32_t const mw::XdgToplevelDecorationV1::Error::already_constructed;
uint32_t const mw::XdgToplevelDecorationV1::Error::orphaned;
uint32_t const mw::XdgToplevelDecorationV1::Mode::client_side;
uint32_t const mw::XdgToplevelDecorationV1::Mode::server_side;

struct wl_message const mw::XdgToplevelDecorationV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"set_mode", "u", all_null_types},
    {"unset_mode", "", all_null_types}};

struct wl_message const mw::XdgToplevelDecorationV1::Thunks::event_messages[] {
    {"configure", "u", all_null_types}};

void const* mw::XdgToplevelDecorationV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_mode_thunk,
    (void*)Thunks::unset_mode_thunk};

mw::XdgToplevelDecorationV1* mw::XdgToplevelDecorationV1::from(struct wl_resource* resource)
{
    if (resource &&
        wl_resource_instance_of(resource, &zxdg_toplevel_decoration_v1_interface_data, XdgToplevelDecorationV1::Thunks::request_vtable))
    {
        return static_cast<XdgToplevelDecorationV1*>(wl_resource_get_user_data(resource));
    }
    else
    {
        return nullptr;
    }
}

namespace mir
{
namespace wayland
{

struct wl_interface const zxdg_decoration_manager_v1_interface_data {
    mw::XdgDecorationManagerV1::interface_name,
    mw::XdgDecorationManagerV1::Thunks::supported_version,
    2, mw::XdgDecorationManagerV1::Thunks::request_messages,
    0, nullptr};

struct wl_interface const zxdg_toplevel_decoration_v1_interface_data {
    mw::XdgToplevelDecorationV1::interface_name,
    mw::XdgToplevelDecorationV1::Thunks::supported_version,
    3, mw::XdgToplevelDecorationV1::Thunks::request_messages,
    1, mw::XdgToplevelDecorationV1::Thunks::event_messages};

}
}
