#!/bin/sh
# 
# This script installs QuteCom 2.0

# Download QuteCom
echo " "
echo "Password required to install in /opt directory... "
echo " "
cd /opt
sudo wget http://download.qutecom.com/qutecom/rc/2006-10-03/QuteCom-2.0-linux-bin-x86.tar.bz2

# Install QuteCom 2.0
echo " "
echo "Installing QuteCom 2.0"

# Extract the build
sudo tar -xjvf QuteCom-2.0-linux-bin-x86.tar.bz2

# Renaming the folder
sudo mv qutecom-ng-binary-latest/ qutecom

# Make sure root owns the Swiftfox directory
sudo chown -hR root:root qutecom
#Applying permissions
sudo chmod 555 /opt/qutecom/*

# Add link to /usr/bin
sudo ln -s /opt/qutecom/qutecom.sh /usr/bin/qtqutecom

# Add QuteCom menu Entry
cd /usr/share/applications
sudo wget http://download.qutecom.com/qutecom/qutecom.desktop

# Copy qutecom icon
cp /opt/qutecom/pics/qutecom.png /usr/share/pixmaps/qutecom.png

# Download .protocol file
cd /usr/share/services
wget http://download.qutecom.com/qutecom/qutecom.protocol

# Remove the downloaded tarball
sudo rm /opt/QuteCom-2.0-linux-bin-x86.tar.bz2

echo " "
echo "QuteCom 2.0 is now installed, enjoy your freedom to talk :) !"
echo " "
exit
