/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.PerTileParser;
import net.sf.picard.illumina.parser.readers.BarcodeFileReader;
import net.sf.picard.util.CollectionUtil;
import net.sf.samtools.util.CloseableIterator;

class BarcodeParser
extends PerTileParser<BarcodeData> {
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Barcodes));

    public BarcodeParser(IlluminaFileMap tilesToFiles) {
        super(tilesToFiles);
    }

    public BarcodeParser(IlluminaFileMap tilesToFiles, int nextTile) {
        super(tilesToFiles, nextTile);
    }

    @Override
    protected CloseableIterator<BarcodeData> makeTileIterator(File nextTileFile) {
        return new BarcodeDataIterator(nextTileFile);
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    private static class BarcodeDataIterator
    implements CloseableIterator<BarcodeData> {
        private BarcodeFileReader bfr;

        public BarcodeDataIterator(File file) {
            this.bfr = new BarcodeFileReader(file);
        }

        public void close() {
            this.bfr.close();
        }

        public boolean hasNext() {
            return this.bfr.hasNext();
        }

        public BarcodeData next() {
            return new BarcodeData(){

                @Override
                public String getBarcode() {
                    return BarcodeDataIterator.this.bfr.next();
                }
            };
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

