/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITCTP1
extends TiffProfileClassIT {
    public TiffProfileClassITCTP1() {
        this._profileText = "TIFF/IT-CT/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        int n;
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesNewSubfileType(tiffIFD, 0L)) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray.length != 4) {
            return false;
        }
        for (n = 0; n < 4; ++n) {
            if (nArray[n] == 8) continue;
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 5)) {
            return false;
        }
        if (!this.satisfiesOrientation(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 4)) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        n = tiffIFD.getInkSet();
        if (n != 1) {
            return false;
        }
        int n2 = tiffIFD.getNumberOfInks();
        if (n2 != 4) {
            return false;
        }
        if (!this.satisfiesDotRange(tiffIFD, 0, 255)) {
            return false;
        }
        return tiffIFD.getDocumentName() == null && nisoImageMetadata.getScannerModelName() == null && tiffIFD.getPageName() == null && nisoImageMetadata.getHostComputer() == null && tiffIFD.getSite() == null && tiffIFD.getColorSequence() == null && tiffIFD.getIT8Header() == null;
    }
}

