/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMORYACCESS_H_
#define OPENDRIM_MEMORYACCESS_H_

#include "SystemMemory_Common.h"

#include "OpenDRIM_Memory.h"

int SystemMemory_OpenDRIM_Memory_load(const CMPIBroker* broker, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_unload(string& errorMessage);

int SystemMemory_OpenDRIM_Memory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Memory>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_Memory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Memory& instance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& newInstance, const OpenDRIM_Memory& oldInstance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, const OpenDRIM_Memory_RequestStateChange_In& in, OpenDRIM_Memory_RequestStateChange_Out& out, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, const OpenDRIM_Memory_SetPowerState_In& in, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, const OpenDRIM_Memory_EnableDevice_In& in, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, const OpenDRIM_Memory_OnlineDevice_In& in, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, const OpenDRIM_Memory_QuiesceDevice_In& in, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Memory& instance, unsigned int& returnValue, string& errorMessage);

int SystemMemory_OpenDRIM_Memory_populate(OpenDRIM_Memory& instance, string& errorMessage);

#endif /*OPENDRIM_MEMORYACCESS_H_*/
