#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Rogue Trader
###

script_version=20240720.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='warhammer-40k-rogue-trader'
GAME_NAME='Warhammer 40,000: Rogue Trader'

ARCHIVE_BASE_1_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681).exe'
ARCHIVE_BASE_1_MD5='4dacb9055aefe3aba3c0b9d69f1e7bbe'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='0992b9315611a76db8eb3ec16af01437'
ARCHIVE_BASE_1_PART2_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='8390e0d884653541edf3d489cf069aab'
ARCHIVE_BASE_1_PART3_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='0c8dcda2d01a9db6d48750213454ae46'
ARCHIVE_BASE_1_PART4_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-4.bin'
ARCHIVE_BASE_1_PART4_MD5='3857bdce47b4d311c1712eb8bf96e76d'
ARCHIVE_BASE_1_PART5_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-5.bin'
ARCHIVE_BASE_1_PART5_MD5='498fd37ca55b4082a5620e0892ef7e85'
ARCHIVE_BASE_1_PART6_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-6.bin'
ARCHIVE_BASE_1_PART6_MD5='c471fa41f77b39003e4cbcc5177636e2'
ARCHIVE_BASE_1_PART7_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-7.bin'
ARCHIVE_BASE_1_PART7_MD5='1d9ee45fd389fac0a34c9154f52068cf'
ARCHIVE_BASE_1_PART8_NAME='setup_warhammer_40000_rogue_trader_windows_1.1.58.505_release_(72681)-8.bin'
ARCHIVE_BASE_1_PART8_MD5='d36f057b4f24c2c4f0a6fe8341d258f4'
ARCHIVE_BASE_1_SIZE='37037198'
ARCHIVE_BASE_1_VERSION='1.1.58.505-gog72681'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/warhammer_40000_rogue_trader'

ARCHIVE_BASE_0_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073).exe'
ARCHIVE_BASE_0_MD5='adecb272b3abcafcdadcc661fd0fa16a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='750087be34c3e067e8f117cb75abf01b'
ARCHIVE_BASE_0_PART2_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='3ac14fc89b7770aaa91ace86b5d77fa0'
ARCHIVE_BASE_0_PART3_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='9d75b578aff00669425099c77d39c946'
ARCHIVE_BASE_0_PART4_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='4873f86957ee03b4c6d5a9b467300d43'
ARCHIVE_BASE_0_PART5_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-5.bin'
ARCHIVE_BASE_0_PART5_MD5='e63da686a49e98310fdc26a426d94fd2'
ARCHIVE_BASE_0_PART6_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-6.bin'
ARCHIVE_BASE_0_PART6_MD5='71395b57d293fabd7e2e930523cbf909'
ARCHIVE_BASE_0_PART7_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-7.bin'
ARCHIVE_BASE_0_PART7_MD5='e172106a1819cf3ff50229d01986ebbd'
ARCHIVE_BASE_0_PART8_NAME='setup_warhammer_40000_rogue_trader_windows_1.0.89.426_modded_(70073)-8.bin'
ARCHIVE_BASE_0_PART8_MD5='cd37f515a987c38b8bbef29c073f29f9'
ARCHIVE_BASE_0_SIZE='37034784'
ARCHIVE_BASE_0_VERSION='1.0.89.426-gog70073'

UNITY3D_NAME='wh40krt'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_BUNDLES_SCENES_1_FILES='
bundles/[a-p]*.scenes'
CONTENT_GAME_DATA_BUNDLES_SCENES_2_FILES='
bundles/*.scenes'
CONTENT_GAME_DATA_BUNDLES_UNIT_FILES='
bundles/*.unit'
CONTENT_GAME_DATA_BUNDLES_FILES='
bundles'
CONTENT_GAME0_DATA_FILES='
whrtmodificationtemplate-release.rar'

## While the game works with the default wined3d renderer,
## performances are much better when using dxvk instead.
WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Owlcat Games/Warhammer 40000 Rogue Trader'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_BUNDLES_SCENES_1
PKG_DATA_BUNDLES_SCENES_2
PKG_DATA_BUNDLES_UNIT
PKG_DATA_BUNDLES
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_BUNDLES'

PKG_DATA_BUNDLES_ID="${PKG_DATA_ID}-bundles"
PKG_DATA_BUNDLES_DESCRIPTION="$PKG_DATA_DESCRIPTION - bundles"
PKG_DATA_BUNDLES_DEPENDENCIES_SIBLINGS='
PKG_DATA_BUNDLES_SCENES_1
PKG_DATA_BUNDLES_SCENES_2
PKG_DATA_BUNDLES_UNIT'

PKG_DATA_BUNDLES_SCENES_ID="${PKG_DATA_BUNDLES_ID}-scenes"
PKG_DATA_BUNDLES_SCENES_1_ID="${PKG_DATA_BUNDLES_SCENES_ID}-1"
PKG_DATA_BUNDLES_SCENES_2_ID="${PKG_DATA_BUNDLES_SCENES_ID}-2"
PKG_DATA_BUNDLES_SCENES_DESCRIPTION="$PKG_DATA_BUNDLES_DESCRIPTION - scenes"
PKG_DATA_BUNDLES_SCENES_1_DESCRIPTION="$PKG_DATA_BUNDLES_SCENES_DESCRIPTION - 1"
PKG_DATA_BUNDLES_SCENES_2_DESCRIPTION="$PKG_DATA_BUNDLES_SCENES_DESCRIPTION - 2"

PKG_DATA_BUNDLES_UNIT_ID="${PKG_DATA_BUNDLES_ID}-unit"
PKG_DATA_BUNDLES_UNIT_DESCRIPTION="$PKG_DATA_BUNDLES_DESCRIPTION - unit"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Drop Steam-specific stuff.
	## --force is used because it is not included in all releases.
	rm --force --recursive 'steam workshop tool'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
