//  spoollist.cc for bbmail - an tool to display new mail in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "spoollist.hh"

SpoolList::SpoolList()
{
	filename=NULL;
	new_maildir=NULL;
	cur_maildir=NULL;
}

SpoolList::~SpoolList()
{
	delete [] filename;
	delete [] new_maildir;
	delete [] cur_maildir;
	delete [] name;
	delete [] runCommand;
	delete [] statusFlag;
	delete [] proc;
	delete [] reversedProc;
	delete [] newmailProc;
}

void SpoolList::LoadFilename(char *value)
{
	int len;

	len =strlen(value);
	filename = new char[len + 1];
	memset(filename, 0, len + 1);
	strncpy(filename, value, len);
	if (type==maildir) {
		new_maildir = new char[len + 5];
		sprintf (new_maildir, "%s/new", value);
		cur_maildir = new char[len + 5];
		sprintf (cur_maildir, "%s/cur", value);
	}
}

void SpoolList::LoadName(char *value)
{
	int len;

	len =strlen(value);
	name = new char[len + 16];
	memset(name, 0, len + 16);
	strncpy(name, value, len);
}

void SpoolList::LoadrunCommand(char *value)
{
	int len;

	len=strlen(value);
	if (value[len-1]!='&') {
		runCommand = new char[len + 2];
		memset(runCommand, 0, len + 2);
		strncpy(runCommand, value, len);
		runCommand[len]='&';
	} else {
		runCommand = new char[len + 1];
		memset(runCommand, 0, len + 1);
		strncpy(runCommand, value, len);
	}
}

void SpoolList::LoadstatusFlag(char *value)
{
	int len;

	len =strlen(value);
	statusFlag = new char[len + 1];
	memset(statusFlag, 0, len + 1);
	strncpy(statusFlag, value, len);
}

void SpoolList::LoadProc(char *value)
{
	int len;

	len =strlen(value);
	proc = new char[len + 2];
	memset(proc, 0, len + 2);
	strncpy(proc, value, len);
	if (value[len-1]!='&') {
		proc[len]='&';
		proc[len+1]='\0';
	}
}

void SpoolList::LoadreversedProc(char *value)
{
	int len;
	len =strlen(value);
	reversedProc = new char[len + 2];
	memset(reversedProc, 0, len + 2);
	strncpy(reversedProc, value, len);
	if (value[len-1]!='&') {
		reversedProc[len]='&';
		reversedProc[len+1]='\0';
	}
}

void SpoolList::LoadnewmailProc(char *value)
{
	int len;
	len =strlen(value);
	newmailProc = new char[len + 2];
	memset(newmailProc, 0, len + 2);
	strncpy(newmailProc, value, len);
	if (value[len-1]!='&') {
		newmailProc[len]='&';
		newmailProc[len+1]='\0';
	}
}
