# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Fri Mar  4 05:41:58 2005

import wx
import copy
from bibOOo.CONST import BIB_TYPE,BIB_FIELDS,NAME_FIELD,NAME_TYPE,TYPE_NAME

# styles = OR of following values
from bibOOo.CONST import bibOOo_italic,bibOOo_bold,bibOOo_caps,bibOOo_smallcaps,bibOOo_underline

bibEVT_STYLE = wx.NewEventType()	# event type which is used by Style class to tell the owning window that the style has been changed

def EVT_STYLE(win, id, func):		# macro to connect the event in the parent window
	win.Connect(id, -1, bibEVT_STYLE, func)

class bibStyleEvent(wx.PyCommandEvent):	# current style is stored in self.charStyle
	def SetStyle(self, charStyle):
		self.charStyle = charStyle
	def GetStyle(self):
		return self.charStyle

class Style(wx.Panel):
	def __init__(self, *args, **kwds):
		"""Panel to set/edit charStyle"""
		self.charStyle = 0	# current style
		# begin wxGlade: Style.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.check_italic = wx.CheckBox(self, -1, _("Italic"))
		self.check_bold = wx.CheckBox(self, -1, _("Bold"))
		self.check_underline = wx.CheckBox(self, -1, _("Underline"))
		self.radio_case = wx.RadioBox(self, -1, _("Case"), choices=[_("Normal"), _("Caps"), _("Small Caps")], majorDimension=1, style=wx.RA_SPECIFY_COLS)

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: Style.__set_properties
		self.radio_case.SetSelection(0)
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: Style.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_2 = wx.StaticBoxSizer(wx.StaticBox(self, -1, _("Style")), wx.VERTICAL)
		sizer_2.Add(self.check_italic, 0, 0, 0)
		sizer_2.Add(self.check_bold, 0, 0, 0)
		sizer_2.Add(self.check_underline, 0, 0, 0)
		sizer_1.Add(sizer_2, 1, wx.EXPAND, 0)
		sizer_1.Add(self.radio_case, 0, wx.EXPAND, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

	def __set_evt(self):
		wx.EVT_CHECKBOX(self,self.check_italic.GetId(),self.onChangeStyle)
		wx.EVT_CHECKBOX(self,self.check_bold.GetId(),self.onChangeStyle)
		wx.EVT_CHECKBOX(self,self.check_underline.GetId(),self.onChangeStyle)
		wx.EVT_RADIOBOX(self,self.radio_case.GetId(),self.onChangeStyle)

	def onChangeStyle(self,event):
		evt = bibStyleEvent(bibEVT_STYLE, self.GetId())
		evt.SetStyle(self.getStyle())
		self.GetEventHandler().ProcessEvent(evt)		# we post our event to be processed by the parent window
		event.Skip()

	def setStyle(self,charStyle):
		self.charStyle = charStyle
		self.check_italic.SetValue(charStyle & bibOOo_italic)
		self.check_bold.SetValue(charStyle & bibOOo_bold)
		self.check_underline.SetValue(charStyle & bibOOo_underline)
		#
		if charStyle & bibOOo_caps: self.radio_case.SetSelection(1)
		elif charStyle & bibOOo_smallcaps: self.radio_case.SetSelection(2)
		else: self.radio_case.SetSelection(0)

	def getStyle(self):
		"""Return the current style"""
		if self.radio_case.GetSelection() == 1: case = bibOOo_caps
		elif self.radio_case.GetSelection() == 2: case = bibOOo_smallcaps
		else: case = 0
		#
		return 	case | \
				self.check_italic.GetValue() * bibOOo_italic | \
				self.check_bold.GetValue() * bibOOo_bold | \
				self.check_underline.GetValue() * bibOOo_underline

# end of class Style

# ************************************
# Class for page  'fields ordering'  *
# ************************************
class page_Ordering(wx.Panel):
	"""Fields style"""
	def __init__(self, *args, **kwds):
		self.conv = kwds['conv']	# current fields ordering
		del kwds['conv']
		wx.Panel.__init__(self,*args, **kwds)
		self.selectedText = None	# last selected textCtrl to know where the insertion should take place
		self.lastInsertField = None	# wxToggleButton ON if exists
		self.textWidth = 30			# width textCtrl in fieldsScroll
		self.RefType = wx.ListBox(self,-1,choices = [NAME_TYPE[typ] for typ in BIB_TYPE],style=wx.LB_SINGLE)	# list of references types ARTICLE, BOOK, etc...
		# Radio box (top right)
		self.typeDef = wx.RadioBox(self,-1,_("Format reference as"),choices=[_("ARTICLE"),_("below")],style=wx.RA_SPECIFY_COLS)
		# Panel containing the controls bellow
		self.panel = wx.Panel(self,-1)
		# scrolled window to define fields ordering
		self.fieldsScroll = wx.ScrolledWindow(self.panel,-1)
		self.text=[]	# list of text between fields
		self.text.append(FieldText(self.fieldsScroll,-1,size=(self.textWidth,-1)))	# the first one is always present
		self.selectedText = self.text[0]
		self.insertField=[]	# list of fields to insert
		#
		self.insert = wx.Button(self.panel,-1,_("Insert"))	# insert a field in self.fieldsScroll
		self.delete = wx.Button(self.panel,-1,_("Delete"))	# delete a field in self.fieldsScroll
		self.fields = wx.Choice(self.panel,-1,choices=[ NAME_FIELD[field] for field in BIB_FIELDS ] )
		self.tab = wx.Button(self.panel,-1,_("Tabulation"))	# insert a tabulation in self.fieldsScrol
		self.styles = Style(self.panel,-1)
		# wxPanel for Tabulations
		self.panel_tab = wx.Panel(self.panel,-1)
		self.TabStopPosition = wx.SpinCtrl(self.panel_tab, -1, min=0, max=200)	# value in mm => put x100
		self.TabStopFillCharacter = wx.ComboBox(self.panel_tab, -1, choices=[' ','.','-','_'])
		self.TabStopRightAligned = wx.CheckBox(self.panel_tab, -1, _("Tab stop is right aligned"))
		#
		self.preview = wx.TextCtrl(self.panel,-1,style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH2)
		self.preview.Disable()
		#
		self.__set_layout()
		self.__set_start()
		self.__set_evt()

	def __set_start(self):
		"""set the state at startup"""
		# we select ARTICLE
		self.RefType.SetSelection(0,True) # we start with ARTICLE = Default
		# select below, disable 'As ARTICLE', enable choices
		self.typeDef.SetSelection(1)
		self.typeDef.EnableItem(0,False)
		self.panel.Enable(self.typeDef.GetSelection())
		# read the ARTICLE format
		self.__set_scrollFields('ARTICLE')
		self.lastSelection = u'ARTICLE'
		# set first choice in fields
		self.fields.SetSelection(0)
		# disable tab choices
		self.panel_tab.Enable(False)
		self.insert.Enable(False)
		self.tab.Enable(False)
		self.__toggle_button()
		self.__Preview()

	def __set_scrollFields(self,typ):
		"""set the fields and text in scroll fields according to self.conv[typ]"""
		# we delete all the fields except the first textctrl
		for field in self.insertField:
			self.s_fieldsScroll.Remove(field)
			field.Destroy()
		self.insertField = []
		for tt in self.text[1:]:
			self.s_fieldsScroll.Remove(tt)
			tt.Destroy()
		del self.text[1:]
		self.text[0].Clear()
		self.text[0].FieldStyle =0
		# we insert the new ones
		if not self.conv[typ] :		# == []
			return
		else:
			tokens = copy.deepcopy(self.conv[typ])
			previous = 'text'
			if tokens[0][0] == 'text':							# set the first FieldText
				self.text[0].SetValue(self.conv[typ][0][1])
				self.text[0].FieldStyle = self.conv[typ][0][2]
				previous = 'text'
				del tokens[0]
			#
			for token in tokens:
				if (token[0] in ('field','tab')) and (previous in ('field','tab')):	# empty text
					self.text.append(FieldText(self.fieldsScroll,-1,size=(self.textWidth,-1)))	# new textCtrl
					self.s_fieldsScroll.Add(self.text[-1],0,0)
					wx.EVT_SET_FOCUS(self.text[-1],self.onFocus)						# set evt
					wx.EVT_TEXT(self,self.text[-1].GetId(),lambda evt: self.__Preview()) # to update preview on change
				if token[0] == 'field':
					self.insertField.append(FieldToggle(self.fieldsScroll,-1,token[1]))	# new field togglebutton
					self.insertField[-1].FieldStyle = token[2]						# style
					self.s_fieldsScroll.Add(self.insertField[-1],0,0)				# add to sizer
					wx.EVT_TOGGLEBUTTON(self,self.insertField[-1].GetId(),self.onToggle)
					previous = 'field'
				elif token[0] == 'tab':
					self.insertField.append(TabToggle(self.fieldsScroll,-1,'TAB'))		# new table togglebutton
					if token[1] != None:
						self.insertField[-1].tabpos = token[1] / 100
					else:
						self.insertField[-1].tabpos = None
					self.insertField[-1].tabsep = token[2]
					self.s_fieldsScroll.Add(self.insertField[-1],0,0)				# add to sizer
					wx.EVT_TOGGLEBUTTON(self,self.insertField[-1].GetId(),self.onToggle)
					previous = 'tab'
				else:
					self.text.append(FieldText(self.fieldsScroll,-1,size=(self.textWidth,-1)))			# new textctrl
					self.text[-1].SetValue(token[1])								# value
					self.text[-1].FieldStyle = token[2]								# style
					self.s_fieldsScroll.Add(self.text[-1],0,0)						# add to sizer
					wx.EVT_SET_FOCUS(self.text[-1],self.onFocus)						# set evt
					wx.EVT_TEXT(self,self.text[-1].GetId(),lambda evt: self.__Preview()) # to update preview on change
					previous = 'text'
			if previous != 'text':
				# we must end with a text field
				self.text.append(FieldText(self.fieldsScroll,-1,size=(self.textWidth,-1)))			# new textctrl
				self.s_fieldsScroll.Add(self.text[-1],0,0)						# add to sizer
				wx.EVT_SET_FOCUS(self.text[-1],self.onFocus)						# set evt
				wx.EVT_TEXT(self,self.text[-1].GetId(),lambda evt: self.__Preview()) # to update preview on change
				previous = 'text'
		self.fieldsScroll.FitInside()
		self.panel.Layout()

	def __set_layout(self):
		s_main = wx.BoxSizer(wx.HORIZONTAL)
		s_right = wx.BoxSizer(wx.VERTICAL)	# right size
		s_panel = wx.BoxSizer(wx.VERTICAL)	# sizer of self.panel
		# fields scrolling window
		self.s_fieldsScroll = wx.BoxSizer(wx.HORIZONTAL)	# sizer of self.fieldsScroll
		self.s_fieldsScroll.Add( (0,2*self.text[0].GetSizeTuple()[1]) )	# needed to be sure that the scroll bar don't mask button/fields in Windows
		self.s_fieldsScroll.Add(self.text[0],0,0)
		self.fieldsScroll.SetSizerAndFit(self.s_fieldsScroll)
		self.fieldsScroll.SetScrollRate(10,0)
		# sizer tab settings
		s_tab = wx.GridSizer(3,2,5,5)
		s_tab.Add(self.TabStopRightAligned,0,wx.ALIGN_CENTER_VERTICAL)
		s_tab.Add((0,0),0,0)
		s_tab.Add(wx.StaticText(self.panel_tab,-1,_("Fill character in tab stops")),0,wx.ALIGN_CENTER_VERTICAL)
		s_tab.Add(self.TabStopFillCharacter,0,0)
		self.TabStopPositionTitle = wx.StaticText(self.panel_tab,-1,_("Position of the tab stop (mm)"))
		s_tab.Add(self.TabStopPositionTitle,0,wx.ALIGN_CENTER_VERTICAL)
		s_tab.Add(self.TabStopPosition,0,0)
		self.panel_tab.SetSizerAndFit(s_tab)
		self.panel_tab.Layout()
		# sizer with insert etc.
		s_insert = wx.BoxSizer(wx.HORIZONTAL)
		s_insert.Add(self.fields,0,wx.RIGHT,10)
		s_insert.Add(self.insert,0,wx.RIGHT,10)
		s_insert.Add(self.delete,0,wx.RIGHT,50)
		s_insert.Add(self.tab,0,wx.RIGHT,10)
		s_insert.Add(self.panel_tab,0,0,0)
		# sizer for character style
		s_style = wx.BoxSizer(wx.HORIZONTAL)
		s_style.Add(self.styles)
		#
		s_panel.Add(self.fieldsScroll,2,wx.EXPAND|wx.ALL,5)
		s_panel.Add(s_insert,0,wx.ALL,5)
		s_panel.Add(s_style,0,wx.ALL,5)
		s_panel.Add((0,50))
		s_panel.Add(wx.StaticText(self.panel,-1,_("Preview")),0,wx.ALL,5)
		s_panel.Add(self.preview,3,wx.EXPAND|wx.ALL,5)
		self.panel.SetSizerAndFit(s_panel)
		self.panel.Layout()
		#
		s_right.Add(self.typeDef,0,0,0)
		s_right.Add(self.panel,0,wx.EXPAND,0)
		s_main.Add(self.RefType,0,wx.EXPAND,0)
		s_main.Add(s_right,1,wx.EXPAND,0)
		self.SetSizer(s_main)
		self.Layout()

	def __set_evt(self):
		wx.EVT_SET_FOCUS(self.text[0],self.onFocus)
		wx.EVT_TEXT(self,self.text[0].GetId(),lambda evt: self.__Preview())		# to update preview on change
		wx.EVT_BUTTON(self,self.insert.GetId(),self.onInsert)
		wx.EVT_BUTTON(self,self.delete.GetId(),self.onDelete)
		wx.EVT_BUTTON(self,self.tab.GetId(),self.onTab)
		wx.EVT_RADIOBOX(self,self.typeDef.GetId(),self.onMode)
		EVT_STYLE(self,self.styles.GetId(),self.onStyle)						# personal event generated when Style is changed
		wx.EVT_LISTBOX(self,self.RefType.GetId(),self.__onRefType)
		wx.EVT_CHECKBOX(self,self.TabStopRightAligned.GetId(),self.__toggleTabRight)
		wx.EVT_SPINCTRL(self,self.TabStopPosition.GetId(),self.__tabPosition)
		wx.EVT_TEXT(self,self.TabStopFillCharacter.GetId(),self.__tabSeparator)
		wx.EVT_SET_FOCUS(self.preview,lambda evt: None)							# refuse focus

	def __tabSeparator(self,evt):
		self.lastInsertField.tabsep = self.TabStopFillCharacter.GetValue()
		self.__Preview()						# update preview

	def __tabPosition(self,evt):
		self.lastInsertField.tabpos = self.TabStopPosition.GetValue()
		self.__Preview()						# update preview

	def __toggleTabRight(self,evt):
		self.TabStopPosition.Enable(not self.TabStopRightAligned.GetValue())
		self.TabStopPositionTitle.Enable(not self.TabStopRightAligned.GetValue())
		if self.TabStopRightAligned.GetValue():
			self.lastInsertField.tabpos = None	# tab is right aligned
		else:
			self.lastInsertField.tabpos = self.TabStopPosition.GetValue()
		self.__Preview()						# update preview

	def getConv(self):
		"""return the settings"""
		self.__save_Conv(self.lastSelection,self.typeDef.GetSelection())
		return self.conv

	def __get_Conv(self):
		"""Return the converter corresponding to the current choices"""
		tmp=[]
		if self.text[0].GetValue():
			tmp.append(self.text[0].getTuple())
		for i in range(len(self.insertField)):
			tmp.append(self.insertField[i].getTuple())
			if self.text[i+1].GetValue():
				tmp.append(self.text[i+1].getTuple())
		return tmp

	def __save_Conv(self,reftype,typeDef):
		"""save choices for type = reftype ; 'As ARTICLE' if typeDef == 0"""
		if typeDef:									# particular definition
			tmp = self.__get_Conv()
			if reftype != u'ARTICLE':
				if tmp == self.conv[u'ARTICLE']: tmp = self.conv[u'ARTICLE'] # we link the style to 'ARTICLE'
				self.conv[reftype] = tmp
			else: # for ARTICLE we want to update on place to keep links to the other reftype
				self.conv[u'ARTICLE'][:] = tmp
		else:
			self.conv[reftype] = self.conv[u'ARTICLE']

	def __onRefType(self,evt):
		self.__save_Conv(self.lastSelection,self.typeDef.GetSelection())
		self.lastSelection = TYPE_NAME[self.RefType.GetStringSelection()]		# save the current selection
		if self.lastSelection == u'ARTICLE':
			self.typeDef.EnableItem(0,False)			# disable 'As ARTICLE'
			self.typeDef.SetSelection(1)
		else:
			self.typeDef.EnableItem(0,evt.GetSelection())		# enable 'As ARTICLE'
			self.typeDef.SetSelection(not self.conv[self.lastSelection] is self.conv['ARTICLE'])
		self.__set_scrollFields(self.lastSelection)			# set the fields scroll list
		self.onMode(None)
		self.__Preview()						# update preview

	def onMode(self,evt):
		self.panel.Enable(self.typeDef.GetSelection())

	def onFocus(self,evt):
		self.selectedText = evt.GetEventObject()	# last selected textCtrl to know where the insertion should take place
		self.styles.setStyle(self.selectedText.FieldStyle)	# select the style in self.styles
		if self.lastInsertField:
			self.lastInsertField.SetValue(False)	# we unselect curent FieldToggle
			self.lastInsertField = None
		self.panel_tab.Enable(False)				# tab settings off
		self.insert.Enable(True)
		self.tab.Enable(True)
		self.delete.Enable(False)
		evt.Skip()

	def __onInsert(self,name,token):
		try:
			index = self.text.index(self.selectedText)
		except ValueError:
			index = 0
		self.text.insert(1+index,FieldText(self.fieldsScroll,-1,size=(self.textWidth,-1)))	# new textCtrl
		if token == 'field':
			self.insertField.insert(index,FieldToggle(self.fieldsScroll,-1,name))	# new Field togglebutton
		else:
			self.insertField.insert(index,TabToggle(self.fieldsScroll,-1,name))		# new Tab togglebutton
		self.s_fieldsScroll.Insert(2*index+2,self.insertField[index],0,0)			# add them to scroll
		self.s_fieldsScroll.Insert(2*index+3,self.text[index+1],0,0)
		wx.EVT_SET_FOCUS(self.text[1+index],self.onFocus)	# set evt
		wx.EVT_TEXT(self,self.text[1+index].GetId(),lambda evt: self.__Preview())		# to update preview on change
		self.selectedText = self.text[1+index]			# we select the last text for insertion
		wx.EVT_TOGGLEBUTTON(self,self.insertField[index].GetId(),self.onToggle)
		self.text[index+1].SetFocus()						# give focus to the new FieldText
		self.s_fieldsScroll.Layout()
		self.fieldsScroll.FitInside()
		self.panel.Layout()

	def onToggle(self,evt):
		if self.lastInsertField: self.lastInsertField.SetValue(False)
		if evt.GetEventObject().GetValue():
			self.lastInsertField = evt.GetEventObject()
		else:
			self.lastInsertField = None
		self.__toggle_button()
		self.insert.Enable(False)
		self.tab.Enable(False)

	def onInsert(self,evt):
		self.__onInsert(BIB_FIELDS[self.fields.GetSelection()],'field')
		self.__Preview()							# update preview

	def onTab(self,evt):
		self.__onInsert('TAB','tab')
		self.__Preview()							# update preview

	def onDelete(self,evt):
		index = self.insertField.index(self.lastInsertField)
		ret = self.s_fieldsScroll.Remove(self.lastInsertField)
		if ret:
			#self.s_fieldsScroll.Layout()
			self.insertField.remove(self.lastInsertField)
			self.lastInsertField.Destroy()
			self.lastInsertField = None
			ret=self.s_fieldsScroll.Remove(self.text[index+1])
			if ret:
				self.text[index+1].Destroy()
				del self.text[index+1]
		self.s_fieldsScroll.Layout()
		self.fieldsScroll.FitInside()
		self.panel.Layout()
		self.__toggle_button()
		self.__Preview()							# update preview

	def __toggle_button(self):
		"""set buttons state according to selection"""
		self.panel_tab.Enable(False)
		if self.lastInsertField == None:
			self.delete.Enable(False)
		else:
			self.delete.Enable(True)
			self.styles.setStyle(self.lastInsertField.FieldStyle)
			self.selectedText = self.text[0]	# we forget the current FieldText (for insert)
			if self.lastInsertField.__class__ == TabToggle:
				self.panel_tab.Enable(True)
				if self.lastInsertField.tabpos != None:
					self.TabStopPosition.SetValue(self.lastInsertField.tabpos)
					self.TabStopRightAligned.SetValue(False)
				else:
					self.TabStopRightAligned.SetValue(True)
				self.TabStopPosition.Enable(not self.TabStopRightAligned.GetValue())
				self.TabStopPositionTitle.Enable(not self.TabStopRightAligned.GetValue())
				self.TabStopFillCharacter.SetValue(self.lastInsertField.tabsep)

	def onStyle(self,evt):
		"""set the style of the current FieldToggle or FieldText"""
		if self.lastInsertField:
			self.lastInsertField.FieldStyle = self.styles.getStyle()
		else:
			try: self.selectedText.FieldStyle = self.styles.getStyle()
			except: return
		self.__Preview()						# update preview

	def getwxStyle(self,charStyle):
		"""Return the wxFont corresponding to the Style"""
		if charStyle & bibOOo_italic: italic = wx.ITALIC
		else: italic = wx.NORMAL
		#
		if charStyle & bibOOo_bold: bold = wx.BOLD
		else: bold = wx.NORMAL
		#
		if charStyle & bibOOo_underline: underline = True
		else: underline = False
		#
		return wx.Font(wx.NORMAL_FONT.GetPointSize(),wx.DEFAULT,italic,bold,underline)	# underline works only on Windows

	def __Preview(self):
		"""Print the preview in preview TextCtrl according to conv"""
		self.preview.Clear()
		conv = self.__get_Conv()
		for token in conv:
			if token[0] == 'text':
				self.preview.SetDefaultStyle(wx.TextAttr(wx.NullColour,wx.NullColour,self.getwxStyle(token[2])))
				if token[2] & bibOOo_caps or token[2] & bibOOo_smallcaps:
					self.preview.AppendText(token[1].upper())
				else:
					self.preview.AppendText(token[1])
			elif token[0] == 'field':
				self.preview.SetDefaultStyle(wx.TextAttr(wx.NullColour,wx.NullColour,self.getwxStyle(token[2])))
				if token[2] & bibOOo_caps or token[2] & bibOOo_smallcaps:
					self.preview.AppendText(NAME_FIELD[token[1]].upper())
				else:
					self.preview.AppendText(NAME_FIELD[token[1]])
			elif token[0] == 'tab':
				if token[1] == None:	# right aligned
					self.preview.AppendText(token[2]*50)
				else:
					ntab=token[1]/250
					if token[1] != 0: ntab = max(1,ntab)	# we put at least one space
					self.preview.AppendText(token[2]*ntab)
			else:
				print "What are we doing here ? (page_ordering.py line 483)"

class FieldToggle(wx.ToggleButton):
	"""ToggleButton which stores the style in button.FieldStyle
	field is a field name in BIB_FIELD
	but we display NAME_FILE[field] in the button"""
	def __init__(self, parent, id, field, style=0):
		self.FieldStyle = style
		self.field = field
		wx.ToggleButton.__init__(self,parent,id,NAME_FIELD[field])
	def getTuple(self):
		"""return the tuple containing the values"""
		return ('field', self.field, self.FieldStyle)

class TabToggle(wx.ToggleButton):
	"""ToggleButton which stores the style in button.FieldStyle"""
	def __init__(self, *args, **kwds):
		wx.ToggleButton.__init__(self,*args, **kwds)
		self.FieldStyle = 0	# just to be able to use it to avoid cases / Fields
		self.tabpos = 10	# tab position in mm. If None => right aligned.
		self.tabsep = ' '	# tab separator
	def getTuple(self):
		"""return the tuple containing the values"""
		pos=None
		if self.tabpos != None: pos = self.tabpos *100	# value in OOo and in style stored in 1/100 of mm
		return ('tab', pos , self.tabsep)				# no style since it does not have any sens

class FieldText(wx.TextCtrl):
	"""TextCtrl which stores the style in textctrl.FieldStyle"""
	def __init__(self, *args, **kwds):
		try:
			self.FieldStyle = kwds['FieldStyle']
			del kwds['FieldStyle']
		except:
			self.FieldStyle = 0	# style normal
		wx.TextCtrl.__init__(self,*args, **kwds)
	def getTuple(self):
		"""return the tuple containing the values"""
		return ('text', self.GetValue(), self.FieldStyle)

