//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Common/DataAccessWidget.cpp
//! @brief     Defines class DataAccessWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Common/DataAccessWidget.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Data/IntensityDataItem.h"
#include "GUI/Model/Data/SpecularDataItem.h"

DataAccessWidget::DataAccessWidget(QWidget* parent)
    : QWidget(parent)
    , m_item(nullptr)
    , m_fftItem(nullptr)
{
}
DataAccessWidget::~DataAccessWidget() = default;

void DataAccessWidget::setJobOrRealItem(QObject* item)
{
    m_item = item;
    ASSERT(jobItem() || realItem());

    disconnect(m_item, &QObject::destroyed, this, nullptr);
    connect(m_item, &QObject::destroyed, this, [this]() { m_item = nullptr; });
}

void DataAccessWidget::setFourierItem(IntensityDataItem* fftItem)
{
    m_fftItem = fftItem;
}

QList<QAction*> DataAccessWidget::actionList()
{
    return QList<QAction*>();
}

JobItem* DataAccessWidget::jobItem() const
{
    return dynamic_cast<JobItem*>(m_item);
}

RealItem* DataAccessWidget::realItem() const
{
    return dynamic_cast<RealItem*>(m_item);
}

QObject* DataAccessWidget::jobRealBase() const
{
    return m_item;
}

SpecularDataItem* DataAccessWidget::realSpecularDataItem() const
{
    return realDataItem<SpecularDataItem>();
}

SpecularDataItem* DataAccessWidget::simuSpecularDataItem() const
{
    return simuDataItem<SpecularDataItem>();
}

SpecularDataItem* DataAccessWidget::diffSpecularDataItem() const
{
    return diffDataItem<SpecularDataItem>();
}

IntensityDataItem* DataAccessWidget::realIntensityDataItem() const
{
    return realDataItem<IntensityDataItem>();
}

IntensityDataItem* DataAccessWidget::simuIntensityDataItem() const
{
    return simuDataItem<IntensityDataItem>();
}

IntensityDataItem* DataAccessWidget::diffIntensityDataItem() const
{
    return diffDataItem<IntensityDataItem>();
}

QList<SpecularDataItem*> DataAccessWidget::mainSpecularDataItems() const
{
    return mainDataItems<SpecularDataItem>();
}

QList<SpecularDataItem*> DataAccessWidget::allSpecularDataItems() const
{
    return allDataItems<SpecularDataItem>();
}

SpecularDataItem* DataAccessWidget::currentSpecularDataItem() const
{
    if (allSpecularDataItems().size() == 0)
        return nullptr;
    return allSpecularDataItems().first();
}

QList<IntensityDataItem*> DataAccessWidget::mainIntensityDataItems() const
{
    if (m_fftItem)
        return {m_fftItem};
    return mainDataItems<IntensityDataItem>();
}

QList<IntensityDataItem*> DataAccessWidget::allIntensityDataItems() const
{
    if (m_fftItem)
        return {m_fftItem};
    return allDataItems<IntensityDataItem>();
}

IntensityDataItem* DataAccessWidget::currentIntensityDataItem() const
{
    if (allIntensityDataItems().size() == 0)
        return nullptr;
    return allIntensityDataItems().first();
}
