//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/DoubleLineEdit.h
//! @brief     Defines class DoubleLineEdit
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_NUMERIC_DOUBLELINEEDIT_H
#define BORNAGAIN_GUI_VIEW_NUMERIC_DOUBLELINEEDIT_H

#include "GUI/Model/Descriptor/DoubleProperty.h"
#include <QLineEdit>

class QDoubleValidator;

//! LineEdit to edit values in a scientific notation, operating on a DoubleProperty.
//!
//! In the future it can be enhanced to support units. At the moment, no DoubleProperty with units
//! is used with a DoubleLineEdit, therefore the handling of units is not implemented yet. Only the
//! naming is prepared already (also to have a naming alike to DoubleSpinBox).
class DoubleLineEdit : public QLineEdit {
    Q_OBJECT
public:
    DoubleLineEdit(QWidget* parent, const DoubleProperty& d);

    //! Set the base value (unit is the one of the contained descriptor).
    void setBaseValue(double baseValue);

    void updateBaseValue();

    QString displayUnitAsString() const;
signals:
    //! Emitted whenever the value changes.
    //!
    //! newBaseValue is in the unit of the valueProperty.
    void baseValueChanged(double newBaseValue);

private slots:
    void onEditingFinished();

private:
    QDoubleValidator* m_validator;
    const DoubleProperty& m_valueProperty;
};


#endif // BORNAGAIN_GUI_VIEW_NUMERIC_DOUBLELINEEDIT_H
