/*
 * $Id: floppy_gen_floppydrive_gui_gtk.c,v 1.24 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "fixme.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-led.h"
#include "glue-gui-gtk-change.h"
#include "glue.h"

#include "floppy_gen_floppydrive_gui_gtk.h"

#define COMP "floppy_gen_floppydrive"

struct cpssp {
	GtkWidget *led;
	GtkWidget *change;
	
	unsigned int n_state_led;

	struct sig_string *port_change;
};

/*
 * Simulator Callbacks
 */
static void
gui_floppy_opt_busy_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->led), val);
	cpssp->n_state_led = val;
	gui_gtk_flush();
}

static void
gui_floppy_change(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->change), path);
}

/*
 * GUI Callbacks
 */
static void
gui_floppy_insert_event(GtkWidget *w, const char *string, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, string);
}

static void
gui_floppy_remove_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, "");
}

void *
floppy_gen_floppydrive_gui_gtk_create(
	unsigned int page,
	const char *name,
	const char *model,
	const char *unit,
	struct sig_manage *port_manage,
	struct sig_power_device *port_power,
	struct sig_shugart_bus *port_shugart,
	struct sig_boolean *port_opt_busy_led,
	struct sig_floppy *port_media,
	struct sig_string *port_change
)
{
	static const struct sig_boolean_funcs opt_busy_led_funcs = {
		.set = gui_floppy_opt_busy_led_set,
	};
	static const struct sig_string_funcs change_funcs = {
		.set = gui_floppy_change,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	/* Busy LED */
	cpssp->led = gui_gtk_led_new("Busy");
	cpssp->n_state_led = 0;
	gtk_widget_show(cpssp->led);
	gtk_box_pack_start(GTK_BOX(vbox), cpssp->led, TRUE, FALSE, 1);

	/* Change Buttons */
	cpssp->change = gui_gtk_change_new("Floppy");
	GTK_WIDGET_UNSET_FLAGS(cpssp->change, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(cpssp->change), "change-inserted",
			G_CALLBACK(gui_floppy_insert_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->change), "change-removed",
			G_CALLBACK(gui_floppy_remove_event), cpssp);
	gtk_widget_show(cpssp->change);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->change, TRUE, FALSE, 1);

	gtk_widget_show(vbox);
	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_change = port_change;

	/* In */
	sig_boolean_connect_in(port_opt_busy_led, cpssp, &opt_busy_led_funcs);
	sig_string_connect(port_change, cpssp, &change_funcs);

	return cpssp;
}

void
floppy_gen_floppydrive_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
floppy_gen_floppydrive_gui_gtk_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
floppy_gen_floppydrive_gui_gtk_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *saveled = cpssp->led;
	GtkWidget *savechange = cpssp->change;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->led = saveled;
	cpssp->change = savechange;
	
	gui_floppy_opt_busy_led_set(cpssp, cpssp->n_state_led);
	
	fprintf(stdout, "\t\t\ttoDo: Handle GtkWidget change\n", 0);
}
