/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class SequenceFileRecordReader<K, V>
extends RecordReader<K, V> {
    private SequenceFile.Reader in;
    private long start;
    private long end;
    private boolean more = true;
    private K key = null;
    private V value = null;
    protected Configuration conf;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        this.conf = context.getConfiguration();
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(this.conf);
        this.in = new SequenceFile.Reader(fs, path, this.conf);
        this.end = fileSplit.getStart() + fileSplit.getLength();
        if (fileSplit.getStart() > this.in.getPosition()) {
            this.in.sync(fileSplit.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.more) {
            return false;
        }
        long pos = this.in.getPosition();
        this.key = this.in.next(this.key);
        if (this.key == null || pos >= this.end && this.in.syncSeen()) {
            this.more = false;
            this.key = null;
            this.value = null;
        } else {
            this.value = this.in.getCurrentValue(this.value);
        }
        return this.more;
    }

    @Override
    public K getCurrentKey() {
        return this.key;
    }

    @Override
    public V getCurrentValue() {
        return this.value;
    }

    @Override
    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized void close() throws IOException {
        this.in.close();
    }
}

