
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAudioOutput.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAudioOutput>
#include <QAudioDevice>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAudioOutput

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAudioOutput::staticMetaObject);
}


// QAudioDevice QAudioOutput::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioDevice > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioDevice > ((QAudioDevice)((QAudioOutput *)cls)->device ());
}


// bool QAudioOutput::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioOutput *)cls)->isMuted ());
}


// void QAudioOutput::setDevice(const QAudioDevice &device)


static void _init_f_setDevice_2484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_2484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput *)cls)->setDevice (arg1);
}


// void QAudioOutput::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput *)cls)->setMuted (arg1);
}


// void QAudioOutput::setVolume(float volume)


static void _init_f_setVolume_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput *)cls)->setVolume (arg1);
}


// float QAudioOutput::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QAudioOutput *)cls)->volume ());
}


// static QString QAudioOutput::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioOutput::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAudioOutput () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":device", "@brief Method QAudioDevice QAudioOutput::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QAudioOutput::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QAudioOutput::setDevice(const QAudioDevice &device)\n", false, &_init_f_setDevice_2484, &_call_f_setDevice_2484);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QAudioOutput::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QAudioOutput::setVolume(float volume)\n", false, &_init_f_setVolume_970, &_call_f_setVolume_970);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method float QAudioOutput::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAudioOutput::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("deviceChanged()", "deviceChanged", "@brief Signal declaration for QAudioOutput::deviceChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("mutedChanged(bool)", "mutedChanged", gsi::arg("muted"), "@brief Signal declaration for QAudioOutput::mutedChanged(bool muted)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAudioOutput::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("volumeChanged(float)", "volumeChanged", gsi::arg("volume"), "@brief Signal declaration for QAudioOutput::volumeChanged(float volume)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAudioOutput::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAudioOutput> decl_QAudioOutput (qtdecl_QObject (), "QtMultimedia", "QAudioOutput_Native",
  methods_QAudioOutput (),
  "@hide\n@alias QAudioOutput");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAudioOutput> &qtdecl_QAudioOutput () { return decl_QAudioOutput; }

}


class QAudioOutput_Adaptor : public QAudioOutput, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAudioOutput_Adaptor();

  //  [adaptor ctor] QAudioOutput::QAudioOutput(QObject *parent)
  QAudioOutput_Adaptor() : QAudioOutput()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAudioOutput::QAudioOutput(QObject *parent)
  QAudioOutput_Adaptor(QObject *parent) : QAudioOutput(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAudioOutput::QAudioOutput(const QAudioDevice &device, QObject *parent)
  QAudioOutput_Adaptor(const QAudioDevice &device) : QAudioOutput(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAudioOutput::QAudioOutput(const QAudioDevice &device, QObject *parent)
  QAudioOutput_Adaptor(const QAudioDevice &device, QObject *parent) : QAudioOutput(device, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAudioOutput::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAudioOutput_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAudioOutput::isSignalConnected(signal);
  }

  //  [expose] int QAudioOutput::receivers(const char *signal)
  int fp_QAudioOutput_receivers_c1731 (const char *signal) const {
    return QAudioOutput::receivers(signal);
  }

  //  [expose] QObject *QAudioOutput::sender()
  QObject * fp_QAudioOutput_sender_c0 () const {
    return QAudioOutput::sender();
  }

  //  [expose] int QAudioOutput::senderSignalIndex()
  int fp_QAudioOutput_senderSignalIndex_c0 () const {
    return QAudioOutput::senderSignalIndex();
  }

  //  [emitter impl] void QAudioOutput::destroyed(QObject *)
  void emitter_QAudioOutput_destroyed_1302(QObject *arg1)
  {
    emit QAudioOutput::destroyed(arg1);
  }

  //  [emitter impl] void QAudioOutput::deviceChanged()
  void emitter_QAudioOutput_deviceChanged_0()
  {
    emit QAudioOutput::deviceChanged();
  }

  //  [adaptor impl] bool QAudioOutput::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAudioOutput::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAudioOutput_Adaptor, bool, QEvent *>(&QAudioOutput_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAudioOutput::event(_event);
    }
  }

  //  [adaptor impl] bool QAudioOutput::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAudioOutput::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAudioOutput_Adaptor, bool, QObject *, QEvent *>(&QAudioOutput_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAudioOutput::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QAudioOutput::mutedChanged(bool muted)
  void emitter_QAudioOutput_mutedChanged_864(bool muted)
  {
    emit QAudioOutput::mutedChanged(muted);
  }

  //  [emitter impl] void QAudioOutput::objectNameChanged(const QString &objectName)
  void emitter_QAudioOutput_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAudioOutput::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QAudioOutput::volumeChanged(float volume)
  void emitter_QAudioOutput_volumeChanged_970(float volume)
  {
    emit QAudioOutput::volumeChanged(volume);
  }

  //  [adaptor impl] void QAudioOutput::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAudioOutput::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAudioOutput_Adaptor, QChildEvent *>(&QAudioOutput_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAudioOutput::childEvent(event);
    }
  }

  //  [adaptor impl] void QAudioOutput::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAudioOutput::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAudioOutput_Adaptor, QEvent *>(&QAudioOutput_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAudioOutput::customEvent(event);
    }
  }

  //  [adaptor impl] void QAudioOutput::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAudioOutput::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAudioOutput_Adaptor, const QMetaMethod &>(&QAudioOutput_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAudioOutput::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAudioOutput::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAudioOutput::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAudioOutput_Adaptor, QTimerEvent *>(&QAudioOutput_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAudioOutput::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAudioOutput_Adaptor::~QAudioOutput_Adaptor() { }

//  Constructor QAudioOutput::QAudioOutput(QObject *parent) (adaptor class)

static void _init_ctor_QAudioOutput_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAudioOutput_Adaptor> ();
}

static void _call_ctor_QAudioOutput_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAudioOutput_Adaptor *> (new QAudioOutput_Adaptor (arg1));
}


//  Constructor QAudioOutput::QAudioOutput(const QAudioDevice &device, QObject *parent) (adaptor class)

static void _init_ctor_QAudioOutput_Adaptor_3678 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAudioOutput_Adaptor> ();
}

static void _call_ctor_QAudioOutput_Adaptor_3678 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAudioOutput_Adaptor *> (new QAudioOutput_Adaptor (arg1, arg2));
}


// void QAudioOutput::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAudioOutput::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAudioOutput::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAudioOutput_Adaptor *)cls)->emitter_QAudioOutput_destroyed_1302 (arg1);
}


// emitter void QAudioOutput::deviceChanged()

static void _init_emitter_deviceChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_deviceChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAudioOutput_Adaptor *)cls)->emitter_QAudioOutput_deviceChanged_0 ();
}


// void QAudioOutput::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAudioOutput::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioOutput_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAudioOutput::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioOutput_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QAudioOutput::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAudioOutput_Adaptor *)cls)->fp_QAudioOutput_isSignalConnected_c2394 (arg1));
}


// emitter void QAudioOutput::mutedChanged(bool muted)

static void _init_emitter_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAudioOutput_Adaptor *)cls)->emitter_QAudioOutput_mutedChanged_864 (arg1);
}


// emitter void QAudioOutput::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAudioOutput_Adaptor *)cls)->emitter_QAudioOutput_objectNameChanged_4567 (arg1);
}


// exposed int QAudioOutput::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAudioOutput_Adaptor *)cls)->fp_QAudioOutput_receivers_c1731 (arg1));
}


// exposed QObject *QAudioOutput::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAudioOutput_Adaptor *)cls)->fp_QAudioOutput_sender_c0 ());
}


// exposed int QAudioOutput::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioOutput_Adaptor *)cls)->fp_QAudioOutput_senderSignalIndex_c0 ());
}


// void QAudioOutput::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioOutput_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioOutput_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QAudioOutput::volumeChanged(float volume)

static void _init_emitter_volumeChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_volumeChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QAudioOutput_Adaptor *)cls)->emitter_QAudioOutput_volumeChanged_970 (arg1);
}


namespace gsi
{

gsi::Class<QAudioOutput> &qtdecl_QAudioOutput ();

static gsi::Methods methods_QAudioOutput_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioOutput::QAudioOutput(QObject *parent)\nThis method creates an object of class QAudioOutput.", &_init_ctor_QAudioOutput_Adaptor_1302, &_call_ctor_QAudioOutput_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioOutput::QAudioOutput(const QAudioDevice &device, QObject *parent)\nThis method creates an object of class QAudioOutput.", &_init_ctor_QAudioOutput_Adaptor_3678, &_call_ctor_QAudioOutput_Adaptor_3678);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAudioOutput::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAudioOutput::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAudioOutput::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_deviceChanged", "@brief Emitter for signal void QAudioOutput::deviceChanged()\nCall this method to emit this signal.", false, &_init_emitter_deviceChanged_0, &_call_emitter_deviceChanged_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAudioOutput::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAudioOutput::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAudioOutput::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAudioOutput::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_mutedChanged", "@brief Emitter for signal void QAudioOutput::mutedChanged(bool muted)\nCall this method to emit this signal.", false, &_init_emitter_mutedChanged_864, &_call_emitter_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAudioOutput::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAudioOutput::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAudioOutput::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAudioOutput::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAudioOutput::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_volumeChanged", "@brief Emitter for signal void QAudioOutput::volumeChanged(float volume)\nCall this method to emit this signal.", false, &_init_emitter_volumeChanged_970, &_call_emitter_volumeChanged_970);
  return methods;
}

gsi::Class<QAudioOutput_Adaptor> decl_QAudioOutput_Adaptor (qtdecl_QAudioOutput (), "QtMultimedia", "QAudioOutput",
  methods_QAudioOutput_Adaptor (),
  "@qt\n@brief Binding of QAudioOutput");

}

