package org.jboss.cache.optimistic;

import org.jboss.cache.CacheException;

/**
 * Denotes exceptions to do with data versioning in optimistic locking
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 1.4.1
 */
public class DataVersioningException extends CacheException
{

   private static final long serialVersionUID = 7234086816998964356L;

   public DataVersioningException()
   {
   }

   public DataVersioningException(String msg)
   {
      super(msg);
   }

   public DataVersioningException(String msg, Throwable cause)
   {
      super(msg, cause);
   }
}
