# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 60912;

use Math::BigInt;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($n_str, $k_str, $expected_str) = split /:/;
    my ($n, $k, $c);

    {
        my $test = qq|\$n = Math::BigInt -> new("$n_str"); |
                 . qq|\$k = Math::BigInt -> new("$k_str"); |
                 . qq|\$c = \$n -> bnok(\$k);|;

        #note "\n$test\n\n";
        eval $test;

        is($@, "", '$@ is an empty string');
        isa_ok($c, "Math::BigInt");
        is($c -> bdstr, $expected_str, $test);
    }

}

__DATA__

NaN:0:NaN
0:NaN:NaN

inf:1:inf

# binomial(0, k) for 0 <= k <= 0

0:0:1

# binomial(1, k) for 0 <= k <= 1

1:0:1
1:1:1

# binomial(2, k) for 0 <= k <= 2

2:0:1
2:1:2
2:2:1

# binomial(3, k) for 0 <= k <= 3

3:0:1
3:1:3
3:2:3
3:3:1

# binomial(4, k) for 0 <= k <= 4

4:0:1
4:1:4
4:2:6
4:3:4
4:4:1

# binomial(5, k) for 0 <= k <= 5

5:0:1
5:1:5
5:2:10
5:3:10
5:4:5
5:5:1

# binomial(6, k) for 0 <= k <= 6

6:0:1
6:1:6
6:2:15
6:3:20
6:4:15
6:5:6
6:6:1

# binomial(7, k) for 0 <= k <= 7

7:0:1
7:1:7
7:2:21
7:3:35
7:4:35
7:5:21
7:6:7
7:7:1

# binomial(8, k) for 0 <= k <= 8

8:0:1
8:1:8
8:2:28
8:3:56
8:4:70
8:5:56
8:6:28
8:7:8
8:8:1

# binomial(9, k) for 0 <= k <= 9

9:0:1
9:1:9
9:2:36
9:3:84
9:4:126
9:5:126
9:6:84
9:7:36
9:8:9
9:9:1

# binomial(10, k) for 0 <= k <= 10

10:0:1
10:1:10
10:2:45
10:3:120
10:4:210
10:5:252
10:6:210
10:7:120
10:8:45
10:9:10
10:10:1

# binomial(11, k) for 0 <= k <= 11

11:0:1
11:1:11
11:2:55
11:3:165
11:4:330
11:5:462
11:6:462
11:7:330
11:8:165
11:9:55
11:10:11
11:11:1

# binomial(12, k) for 0 <= k <= 12

12:0:1
12:1:12
12:2:66
12:3:220
12:4:495
12:5:792
12:6:924
12:7:792
12:8:495
12:9:220
12:10:66
12:11:12
12:12:1

# binomial(13, k) for 0 <= k <= 13

13:0:1
13:1:13
13:2:78
13:3:286
13:4:715
13:5:1287
13:6:1716
13:7:1716
13:8:1287
13:9:715
13:10:286
13:11:78
13:12:13
13:13:1

# binomial(14, k) for 0 <= k <= 14

14:0:1
14:1:14
14:2:91
14:3:364
14:4:1001
14:5:2002
14:6:3003
14:7:3432
14:8:3003
14:9:2002
14:10:1001
14:11:364
14:12:91
14:13:14
14:14:1

# binomial(15, k) for 0 <= k <= 15

15:0:1
15:1:15
15:2:105
15:3:455
15:4:1365
15:5:3003
15:6:5005
15:7:6435
15:8:6435
15:9:5005
15:10:3003
15:11:1365
15:12:455
15:13:105
15:14:15
15:15:1

# binomial(16, k) for 0 <= k <= 16

16:0:1
16:1:16
16:2:120
16:3:560
16:4:1820
16:5:4368
16:6:8008
16:7:11440
16:8:12870
16:9:11440
16:10:8008
16:11:4368
16:12:1820
16:13:560
16:14:120
16:15:16
16:16:1

# binomial(17, k) for 0 <= k <= 17

17:0:1
17:1:17
17:2:136
17:3:680
17:4:2380
17:5:6188
17:6:12376
17:7:19448
17:8:24310
17:9:24310
17:10:19448
17:11:12376
17:12:6188
17:13:2380
17:14:680
17:15:136
17:16:17
17:17:1

# binomial(18, k) for 0 <= k <= 18

18:0:1
18:1:18
18:2:153
18:3:816
18:4:3060
18:5:8568
18:6:18564
18:7:31824
18:8:43758
18:9:48620
18:10:43758
18:11:31824
18:12:18564
18:13:8568
18:14:3060
18:15:816
18:16:153
18:17:18
18:18:1

# binomial(19, k) for 0 <= k <= 19

19:0:1
19:1:19
19:2:171
19:3:969
19:4:3876
19:5:11628
19:6:27132
19:7:50388
19:8:75582
19:9:92378
19:10:92378
19:11:75582
19:12:50388
19:13:27132
19:14:11628
19:15:3876
19:16:969
19:17:171
19:18:19
19:19:1

# binomial(20, k) for 0 <= k <= 20

20:0:1
20:1:20
20:2:190
20:3:1140
20:4:4845
20:5:15504
20:6:38760
20:7:77520
20:8:125970
20:9:167960
20:10:184756
20:11:167960
20:12:125970
20:13:77520
20:14:38760
20:15:15504
20:16:4845
20:17:1140
20:18:190
20:19:20
20:20:1

# binomial(21, k) for 0 <= k <= 21

21:0:1
21:1:21
21:2:210
21:3:1330
21:4:5985
21:5:20349
21:6:54264
21:7:116280
21:8:203490
21:9:293930
21:10:352716
21:11:352716
21:12:293930
21:13:203490
21:14:116280
21:15:54264
21:16:20349
21:17:5985
21:18:1330
21:19:210
21:20:21
21:21:1

# binomial(22, k) for 0 <= k <= 22

22:0:1
22:1:22
22:2:231
22:3:1540
22:4:7315
22:5:26334
22:6:74613
22:7:170544
22:8:319770
22:9:497420
22:10:646646
22:11:705432
22:12:646646
22:13:497420
22:14:319770
22:15:170544
22:16:74613
22:17:26334
22:18:7315
22:19:1540
22:20:231
22:21:22
22:22:1

# binomial(23, k) for 0 <= k <= 23

23:0:1
23:1:23
23:2:253
23:3:1771
23:4:8855
23:5:33649
23:6:100947
23:7:245157
23:8:490314
23:9:817190
23:10:1144066
23:11:1352078
23:12:1352078
23:13:1144066
23:14:817190
23:15:490314
23:16:245157
23:17:100947
23:18:33649
23:19:8855
23:20:1771
23:21:253
23:22:23
23:23:1

# binomial(24, k) for 0 <= k <= 24

24:0:1
24:1:24
24:2:276
24:3:2024
24:4:10626
24:5:42504
24:6:134596
24:7:346104
24:8:735471
24:9:1307504
24:10:1961256
24:11:2496144
24:12:2704156
24:13:2496144
24:14:1961256
24:15:1307504
24:16:735471
24:17:346104
24:18:134596
24:19:42504
24:20:10626
24:21:2024
24:22:276
24:23:24
24:24:1

# binomial(25, k) for 0 <= k <= 25

25:0:1
25:1:25
25:2:300
25:3:2300
25:4:12650
25:5:53130
25:6:177100
25:7:480700
25:8:1081575
25:9:2042975
25:10:3268760
25:11:4457400
25:12:5200300
25:13:5200300
25:14:4457400
25:15:3268760
25:16:2042975
25:17:1081575
25:18:480700
25:19:177100
25:20:53130
25:21:12650
25:22:2300
25:23:300
25:24:25
25:25:1

# binomial(26, k) for 0 <= k <= 26

26:0:1
26:1:26
26:2:325
26:3:2600
26:4:14950
26:5:65780
26:6:230230
26:7:657800
26:8:1562275
26:9:3124550
26:10:5311735
26:11:7726160
26:12:9657700
26:13:10400600
26:14:9657700
26:15:7726160
26:16:5311735
26:17:3124550
26:18:1562275
26:19:657800
26:20:230230
26:21:65780
26:22:14950
26:23:2600
26:24:325
26:25:26
26:26:1

# binomial(27, k) for 0 <= k <= 27

27:0:1
27:1:27
27:2:351
27:3:2925
27:4:17550
27:5:80730
27:6:296010
27:7:888030
27:8:2220075
27:9:4686825
27:10:8436285
27:11:13037895
27:12:17383860
27:13:20058300
27:14:20058300
27:15:17383860
27:16:13037895
27:17:8436285
27:18:4686825
27:19:2220075
27:20:888030
27:21:296010
27:22:80730
27:23:17550
27:24:2925
27:25:351
27:26:27
27:27:1

# binomial(28, k) for 0 <= k <= 28

28:0:1
28:1:28
28:2:378
28:3:3276
28:4:20475
28:5:98280
28:6:376740
28:7:1184040
28:8:3108105
28:9:6906900
28:10:13123110
28:11:21474180
28:12:30421755
28:13:37442160
28:14:40116600
28:15:37442160
28:16:30421755
28:17:21474180
28:18:13123110
28:19:6906900
28:20:3108105
28:21:1184040
28:22:376740
28:23:98280
28:24:20475
28:25:3276
28:26:378
28:27:28
28:28:1

# binomial(29, k) for 0 <= k <= 29

29:0:1
29:1:29
29:2:406
29:3:3654
29:4:23751
29:5:118755
29:6:475020
29:7:1560780
29:8:4292145
29:9:10015005
29:10:20030010
29:11:34597290
29:12:51895935
29:13:67863915
29:14:77558760
29:15:77558760
29:16:67863915
29:17:51895935
29:18:34597290
29:19:20030010
29:20:10015005
29:21:4292145
29:22:1560780
29:23:475020
29:24:118755
29:25:23751
29:26:3654
29:27:406
29:28:29
29:29:1

# binomial(30, k) for 0 <= k <= 30

30:0:1
30:1:30
30:2:435
30:3:4060
30:4:27405
30:5:142506
30:6:593775
30:7:2035800
30:8:5852925
30:9:14307150
30:10:30045015
30:11:54627300
30:12:86493225
30:13:119759850
30:14:145422675
30:15:155117520
30:16:145422675
30:17:119759850
30:18:86493225
30:19:54627300
30:20:30045015
30:21:14307150
30:22:5852925
30:23:2035800
30:24:593775
30:25:142506
30:26:27405
30:27:4060
30:28:435
30:29:30
30:30:1

# binomial(31, k) for 0 <= k <= 31

31:0:1
31:1:31
31:2:465
31:3:4495
31:4:31465
31:5:169911
31:6:736281
31:7:2629575
31:8:7888725
31:9:20160075
31:10:44352165
31:11:84672315
31:12:141120525
31:13:206253075
31:14:265182525
31:15:300540195
31:16:300540195
31:17:265182525
31:18:206253075
31:19:141120525
31:20:84672315
31:21:44352165
31:22:20160075
31:23:7888725
31:24:2629575
31:25:736281
31:26:169911
31:27:31465
31:28:4495
31:29:465
31:30:31
31:31:1

# binomial(32, k) for 0 <= k <= 32

32:0:1
32:1:32
32:2:496
32:3:4960
32:4:35960
32:5:201376
32:6:906192
32:7:3365856
32:8:10518300
32:9:28048800
32:10:64512240
32:11:129024480
32:12:225792840
32:13:347373600
32:14:471435600
32:15:565722720
32:16:601080390
32:17:565722720
32:18:471435600
32:19:347373600
32:20:225792840
32:21:129024480
32:22:64512240
32:23:28048800
32:24:10518300
32:25:3365856
32:26:906192
32:27:201376
32:28:35960
32:29:4960
32:30:496
32:31:32
32:32:1

# binomial(33, k) for 0 <= k <= 33

33:0:1
33:1:33
33:2:528
33:3:5456
33:4:40920
33:5:237336
33:6:1107568
33:7:4272048
33:8:13884156
33:9:38567100
33:10:92561040
33:11:193536720
33:12:354817320
33:13:573166440
33:14:818809200
33:15:1037158320
33:16:1166803110
33:17:1166803110
33:18:1037158320
33:19:818809200
33:20:573166440
33:21:354817320
33:22:193536720
33:23:92561040
33:24:38567100
33:25:13884156
33:26:4272048
33:27:1107568
33:28:237336
33:29:40920
33:30:5456
33:31:528
33:32:33
33:33:1

# binomial(34, k) for 0 <= k <= 34

34:0:1
34:1:34
34:2:561
34:3:5984
34:4:46376
34:5:278256
34:6:1344904
34:7:5379616
34:8:18156204
34:9:52451256
34:10:131128140
34:11:286097760
34:12:548354040
34:13:927983760
34:14:1391975640
34:15:1855967520
34:16:2203961430
34:17:2333606220
34:18:2203961430
34:19:1855967520
34:20:1391975640
34:21:927983760
34:22:548354040
34:23:286097760
34:24:131128140
34:25:52451256
34:26:18156204
34:27:5379616
34:28:1344904
34:29:278256
34:30:46376
34:31:5984
34:32:561
34:33:34
34:34:1

# binomial(35, k) for 0 <= k <= 35

35:0:1
35:1:35
35:2:595
35:3:6545
35:4:52360
35:5:324632
35:6:1623160
35:7:6724520
35:8:23535820
35:9:70607460
35:10:183579396
35:11:417225900
35:12:834451800
35:13:1476337800
35:14:2319959400
35:15:3247943160
35:16:4059928950
35:17:4537567650
35:18:4537567650
35:19:4059928950
35:20:3247943160
35:21:2319959400
35:22:1476337800
35:23:834451800
35:24:417225900
35:25:183579396
35:26:70607460
35:27:23535820
35:28:6724520
35:29:1623160
35:30:324632
35:31:52360
35:32:6545
35:33:595
35:34:35
35:35:1

# binomial(36, k) for 0 <= k <= 36

36:0:1
36:1:36
36:2:630
36:3:7140
36:4:58905
36:5:376992
36:6:1947792
36:7:8347680
36:8:30260340
36:9:94143280
36:10:254186856
36:11:600805296
36:12:1251677700
36:13:2310789600
36:14:3796297200
36:15:5567902560
36:16:7307872110
36:17:8597496600
36:18:9075135300
36:19:8597496600
36:20:7307872110
36:21:5567902560
36:22:3796297200
36:23:2310789600
36:24:1251677700
36:25:600805296
36:26:254186856
36:27:94143280
36:28:30260340
36:29:8347680
36:30:1947792
36:31:376992
36:32:58905
36:33:7140
36:34:630
36:35:36
36:36:1

# binomial(37, k) for 0 <= k <= 37

37:0:1
37:1:37
37:2:666
37:3:7770
37:4:66045
37:5:435897
37:6:2324784
37:7:10295472
37:8:38608020
37:9:124403620
37:10:348330136
37:11:854992152
37:12:1852482996
37:13:3562467300
37:14:6107086800
37:15:9364199760
37:16:12875774670
37:17:15905368710
37:18:17672631900
37:19:17672631900
37:20:15905368710
37:21:12875774670
37:22:9364199760
37:23:6107086800
37:24:3562467300
37:25:1852482996
37:26:854992152
37:27:348330136
37:28:124403620
37:29:38608020
37:30:10295472
37:31:2324784
37:32:435897
37:33:66045
37:34:7770
37:35:666
37:36:37
37:37:1

# binomial(38, k) for 0 <= k <= 38

38:0:1
38:1:38
38:2:703
38:3:8436
38:4:73815
38:5:501942
38:6:2760681
38:7:12620256
38:8:48903492
38:9:163011640
38:10:472733756
38:11:1203322288
38:12:2707475148
38:13:5414950296
38:14:9669554100
38:15:15471286560
38:16:22239974430
38:17:28781143380
38:18:33578000610
38:19:35345263800
38:20:33578000610
38:21:28781143380
38:22:22239974430
38:23:15471286560
38:24:9669554100
38:25:5414950296
38:26:2707475148
38:27:1203322288
38:28:472733756
38:29:163011640
38:30:48903492
38:31:12620256
38:32:2760681
38:33:501942
38:34:73815
38:35:8436
38:36:703
38:37:38
38:38:1

# binomial(39, k) for 0 <= k <= 39

39:0:1
39:1:39
39:2:741
39:3:9139
39:4:82251
39:5:575757
39:6:3262623
39:7:15380937
39:8:61523748
39:9:211915132
39:10:635745396
39:11:1676056044
39:12:3910797436
39:13:8122425444
39:14:15084504396
39:15:25140840660
39:16:37711260990
39:17:51021117810
39:18:62359143990
39:19:68923264410
39:20:68923264410
39:21:62359143990
39:22:51021117810
39:23:37711260990
39:24:25140840660
39:25:15084504396
39:26:8122425444
39:27:3910797436
39:28:1676056044
39:29:635745396
39:30:211915132
39:31:61523748
39:32:15380937
39:33:3262623
39:34:575757
39:35:82251
39:36:9139
39:37:741
39:38:39
39:39:1

# binomial(40, k) for 0 <= k <= 40

40:0:1
40:1:40
40:2:780
40:3:9880
40:4:91390
40:5:658008
40:6:3838380
40:7:18643560
40:8:76904685
40:9:273438880
40:10:847660528
40:11:2311801440
40:12:5586853480
40:13:12033222880
40:14:23206929840
40:15:40225345056
40:16:62852101650
40:17:88732378800
40:18:113380261800
40:19:131282408400
40:20:137846528820
40:21:131282408400
40:22:113380261800
40:23:88732378800
40:24:62852101650
40:25:40225345056
40:26:23206929840
40:27:12033222880
40:28:5586853480
40:29:2311801440
40:30:847660528
40:31:273438880
40:32:76904685
40:33:18643560
40:34:3838380
40:35:658008
40:36:91390
40:37:9880
40:38:780
40:39:40
40:40:1

# binomial(41, k) for 0 <= k <= 41

41:0:1
41:1:41
41:2:820
41:3:10660
41:4:101270
41:5:749398
41:6:4496388
41:7:22481940
41:8:95548245
41:9:350343565
41:10:1121099408
41:11:3159461968
41:12:7898654920
41:13:17620076360
41:14:35240152720
41:15:63432274896
41:16:103077446706
41:17:151584480450
41:18:202112640600
41:19:244662670200
41:20:269128937220
41:21:269128937220
41:22:244662670200
41:23:202112640600
41:24:151584480450
41:25:103077446706
41:26:63432274896
41:27:35240152720
41:28:17620076360
41:29:7898654920
41:30:3159461968
41:31:1121099408
41:32:350343565
41:33:95548245
41:34:22481940
41:35:4496388
41:36:749398
41:37:101270
41:38:10660
41:39:820
41:40:41
41:41:1

# binomial(42, k) for 0 <= k <= 42

42:0:1
42:1:42
42:2:861
42:3:11480
42:4:111930
42:5:850668
42:6:5245786
42:7:26978328
42:8:118030185
42:9:445891810
42:10:1471442973
42:11:4280561376
42:12:11058116888
42:13:25518731280
42:14:52860229080
42:15:98672427616
42:16:166509721602
42:17:254661927156
42:18:353697121050
42:19:446775310800
42:20:513791607420
42:21:538257874440
42:22:513791607420
42:23:446775310800
42:24:353697121050
42:25:254661927156
42:26:166509721602
42:27:98672427616
42:28:52860229080
42:29:25518731280
42:30:11058116888
42:31:4280561376
42:32:1471442973
42:33:445891810
42:34:118030185
42:35:26978328
42:36:5245786
42:37:850668
42:38:111930
42:39:11480
42:40:861
42:41:42
42:42:1

# binomial(43, k) for 0 <= k <= 43

43:0:1
43:1:43
43:2:903
43:3:12341
43:4:123410
43:5:962598
43:6:6096454
43:7:32224114
43:8:145008513
43:9:563921995
43:10:1917334783
43:11:5752004349
43:12:15338678264
43:13:36576848168
43:14:78378960360
43:15:151532656696
43:16:265182149218
43:17:421171648758
43:18:608359048206
43:19:800472431850
43:20:960566918220
43:21:1052049481860
43:22:1052049481860
43:23:960566918220
43:24:800472431850
43:25:608359048206
43:26:421171648758
43:27:265182149218
43:28:151532656696
43:29:78378960360
43:30:36576848168
43:31:15338678264
43:32:5752004349
43:33:1917334783
43:34:563921995
43:35:145008513
43:36:32224114
43:37:6096454
43:38:962598
43:39:123410
43:40:12341
43:41:903
43:42:43
43:43:1

# binomial(44, k) for 0 <= k <= 44

44:0:1
44:1:44
44:2:946
44:3:13244
44:4:135751
44:5:1086008
44:6:7059052
44:7:38320568
44:8:177232627
44:9:708930508
44:10:2481256778
44:11:7669339132
44:12:21090682613
44:13:51915526432
44:14:114955808528
44:15:229911617056
44:16:416714805914
44:17:686353797976
44:18:1029530696964
44:19:1408831480056
44:20:1761039350070
44:21:2012616400080
44:22:2104098963720
44:23:2012616400080
44:24:1761039350070
44:25:1408831480056
44:26:1029530696964
44:27:686353797976
44:28:416714805914
44:29:229911617056
44:30:114955808528
44:31:51915526432
44:32:21090682613
44:33:7669339132
44:34:2481256778
44:35:708930508
44:36:177232627
44:37:38320568
44:38:7059052
44:39:1086008
44:40:135751
44:41:13244
44:42:946
44:43:44
44:44:1

# binomial(45, k) for 0 <= k <= 45

45:0:1
45:1:45
45:2:990
45:3:14190
45:4:148995
45:5:1221759
45:6:8145060
45:7:45379620
45:8:215553195
45:9:886163135
45:10:3190187286
45:11:10150595910
45:12:28760021745
45:13:73006209045
45:14:166871334960
45:15:344867425584
45:16:646626422970
45:17:1103068603890
45:18:1715884494940
45:19:2438362177020
45:20:3169870830126
45:21:3773655750150
45:22:4116715363800
45:23:4116715363800
45:24:3773655750150
45:25:3169870830126
45:26:2438362177020
45:27:1715884494940
45:28:1103068603890
45:29:646626422970
45:30:344867425584
45:31:166871334960
45:32:73006209045
45:33:28760021745
45:34:10150595910
45:35:3190187286
45:36:886163135
45:37:215553195
45:38:45379620
45:39:8145060
45:40:1221759
45:41:148995
45:42:14190
45:43:990
45:44:45
45:45:1

# binomial(46, k) for 0 <= k <= 46

46:0:1
46:1:46
46:2:1035
46:3:15180
46:4:163185
46:5:1370754
46:6:9366819
46:7:53524680
46:8:260932815
46:9:1101716330
46:10:4076350421
46:11:13340783196
46:12:38910617655
46:13:101766230790
46:14:239877544005
46:15:511738760544
46:16:991493848554
46:17:1749695026860
46:18:2818953098830
46:19:4154246671960
46:20:5608233007146
46:21:6943526580276
46:22:7890371113950
46:23:8233430727600
46:24:7890371113950
46:25:6943526580276
46:26:5608233007146
46:27:4154246671960
46:28:2818953098830
46:29:1749695026860
46:30:991493848554
46:31:511738760544
46:32:239877544005
46:33:101766230790
46:34:38910617655
46:35:13340783196
46:36:4076350421
46:37:1101716330
46:38:260932815
46:39:53524680
46:40:9366819
46:41:1370754
46:42:163185
46:43:15180
46:44:1035
46:45:46
46:46:1

# binomial(47, k) for 0 <= k <= 47

47:0:1
47:1:47
47:2:1081
47:3:16215
47:4:178365
47:5:1533939
47:6:10737573
47:7:62891499
47:8:314457495
47:9:1362649145
47:10:5178066751
47:11:17417133617
47:12:52251400851
47:13:140676848445
47:14:341643774795
47:15:751616304549
47:16:1503232609098
47:17:2741188875414
47:18:4568648125690
47:19:6973199770790
47:20:9762479679106
47:21:12551759587422
47:22:14833897694226
47:23:16123801841550
47:24:16123801841550
47:25:14833897694226
47:26:12551759587422
47:27:9762479679106
47:28:6973199770790
47:29:4568648125690
47:30:2741188875414
47:31:1503232609098
47:32:751616304549
47:33:341643774795
47:34:140676848445
47:35:52251400851
47:36:17417133617
47:37:5178066751
47:38:1362649145
47:39:314457495
47:40:62891499
47:41:10737573
47:42:1533939
47:43:178365
47:44:16215
47:45:1081
47:46:47
47:47:1

# binomial(48, k) for 0 <= k <= 48

48:0:1
48:1:48
48:2:1128
48:3:17296
48:4:194580
48:5:1712304
48:6:12271512
48:7:73629072
48:8:377348994
48:9:1677106640
48:10:6540715896
48:11:22595200368
48:12:69668534468
48:13:192928249296
48:14:482320623240
48:15:1093260079344
48:16:2254848913647
48:17:4244421484512
48:18:7309837001104
48:19:11541847896480
48:20:16735679449896
48:21:22314239266528
48:22:27385657281648
48:23:30957699535776
48:24:32247603683100
48:25:30957699535776
48:26:27385657281648
48:27:22314239266528
48:28:16735679449896
48:29:11541847896480
48:30:7309837001104
48:31:4244421484512
48:32:2254848913647
48:33:1093260079344
48:34:482320623240
48:35:192928249296
48:36:69668534468
48:37:22595200368
48:38:6540715896
48:39:1677106640
48:40:377348994
48:41:73629072
48:42:12271512
48:43:1712304
48:44:194580
48:45:17296
48:46:1128
48:47:48
48:48:1

# binomial(49, k) for 0 <= k <= 49

49:0:1
49:1:49
49:2:1176
49:3:18424
49:4:211876
49:5:1906884
49:6:13983816
49:7:85900584
49:8:450978066
49:9:2054455634
49:10:8217822536
49:11:29135916264
49:12:92263734836
49:13:262596783764
49:14:675248872536
49:15:1575580702584
49:16:3348108992991
49:17:6499270398159
49:18:11554258485616
49:19:18851684897584
49:20:28277527346376
49:21:39049918716424
49:22:49699896548176
49:23:58343356817424
49:24:63205303218876
49:25:63205303218876
49:26:58343356817424
49:27:49699896548176
49:28:39049918716424
49:29:28277527346376
49:30:18851684897584
49:31:11554258485616
49:32:6499270398159
49:33:3348108992991
49:34:1575580702584
49:35:675248872536
49:36:262596783764
49:37:92263734836
49:38:29135916264
49:39:8217822536
49:40:2054455634
49:41:450978066
49:42:85900584
49:43:13983816
49:44:1906884
49:45:211876
49:46:18424
49:47:1176
49:48:49
49:49:1

# binomial(50, k) for 0 <= k <= 50

50:0:1
50:1:50
50:2:1225
50:3:19600
50:4:230300
50:5:2118760
50:6:15890700
50:7:99884400
50:8:536878650
50:9:2505433700
50:10:10272278170
50:11:37353738800
50:12:121399651100
50:13:354860518600
50:14:937845656300
50:15:2250829575120
50:16:4923689695575
50:17:9847379391150
50:18:18053528883775
50:19:30405943383200
50:20:47129212243960
50:21:67327446062800
50:22:88749815264600
50:23:108043253365600
50:24:121548660036300
50:25:126410606437752
50:26:121548660036300
50:27:108043253365600
50:28:88749815264600
50:29:67327446062800
50:30:47129212243960
50:31:30405943383200
50:32:18053528883775
50:33:9847379391150
50:34:4923689695575
50:35:2250829575120
50:36:937845656300
50:37:354860518600
50:38:121399651100
50:39:37353738800
50:40:10272278170
50:41:2505433700
50:42:536878650
50:43:99884400
50:44:15890700
50:45:2118760
50:46:230300
50:47:19600
50:48:1225
50:49:50
50:50:1

# binomial(51, k) for 0 <= k <= 51

51:0:1
51:1:51
51:2:1275
51:3:20825
51:4:249900
51:5:2349060
51:6:18009460
51:7:115775100
51:8:636763050
51:9:3042312350
51:10:12777711870
51:11:47626016970
51:12:158753389900
51:13:476260169700
51:14:1292706174900
51:15:3188675231420
51:16:7174519270695
51:17:14771069086725
51:18:27900908274925
51:19:48459472266975
51:20:77535155627160
51:21:114456658306760
51:22:156077261327400
51:23:196793068630200
51:24:229591913401900
51:25:247959266474052
51:26:247959266474052
51:27:229591913401900
51:28:196793068630200
51:29:156077261327400
51:30:114456658306760
51:31:77535155627160
51:32:48459472266975
51:33:27900908274925
51:34:14771069086725
51:35:7174519270695
51:36:3188675231420
51:37:1292706174900
51:38:476260169700
51:39:158753389900
51:40:47626016970
51:41:12777711870
51:42:3042312350
51:43:636763050
51:44:115775100
51:45:18009460
51:46:2349060
51:47:249900
51:48:20825
51:49:1275
51:50:51
51:51:1

# binomial(52, k) for 0 <= k <= 52

52:0:1
52:1:52
52:2:1326
52:3:22100
52:4:270725
52:5:2598960
52:6:20358520
52:7:133784560
52:8:752538150
52:9:3679075400
52:10:15820024220
52:11:60403728840
52:12:206379406870
52:13:635013559600
52:14:1768966344600
52:15:4481381406320
52:16:10363194502115
52:17:21945588357420
52:18:42671977361650
52:19:76360380541900
52:20:125994627894135
52:21:191991813933920
52:22:270533919634160
52:23:352870329957600
52:24:426384982032100
52:25:477551179875952
52:26:495918532948104
52:27:477551179875952
52:28:426384982032100
52:29:352870329957600
52:30:270533919634160
52:31:191991813933920
52:32:125994627894135
52:33:76360380541900
52:34:42671977361650
52:35:21945588357420
52:36:10363194502115
52:37:4481381406320
52:38:1768966344600
52:39:635013559600
52:40:206379406870
52:41:60403728840
52:42:15820024220
52:43:3679075400
52:44:752538150
52:45:133784560
52:46:20358520
52:47:2598960
52:48:270725
52:49:22100
52:50:1326
52:51:52
52:52:1

# binomial(53, k) for 0 <= k <= 53

53:0:1
53:1:53
53:2:1378
53:3:23426
53:4:292825
53:5:2869685
53:6:22957480
53:7:154143080
53:8:886322710
53:9:4431613550
53:10:19499099620
53:11:76223753060
53:12:266783135710
53:13:841392966470
53:14:2403979904200
53:15:6250347750920
53:16:14844575908435
53:17:32308782859535
53:18:64617565719070
53:19:119032357903550
53:20:202355008436035
53:21:317986441828055
53:22:462525733568080
53:23:623404249591760
53:24:779255311989700
53:25:903936161908052
53:26:973469712824056
53:27:973469712824056
53:28:903936161908052
53:29:779255311989700
53:30:623404249591760
53:31:462525733568080
53:32:317986441828055
53:33:202355008436035
53:34:119032357903550
53:35:64617565719070
53:36:32308782859535
53:37:14844575908435
53:38:6250347750920
53:39:2403979904200
53:40:841392966470
53:41:266783135710
53:42:76223753060
53:43:19499099620
53:44:4431613550
53:45:886322710
53:46:154143080
53:47:22957480
53:48:2869685
53:49:292825
53:50:23426
53:51:1378
53:52:53
53:53:1

# binomial(54, k) for 0 <= k <= 54

54:0:1
54:1:54
54:2:1431
54:3:24804
54:4:316251
54:5:3162510
54:6:25827165
54:7:177100560
54:8:1040465790
54:9:5317936260
54:10:23930713170
54:11:95722852680
54:12:343006888770
54:13:1108176102180
54:14:3245372870670
54:15:8654327655120
54:16:21094923659355
54:17:47153358767970
54:18:96926348578605
54:19:183649923622620
54:20:321387366339585
54:21:520341450264090
54:22:780512175396135
54:23:1085929983159840
54:24:1402659561581460
54:25:1683191473897752
54:26:1877405874732108
54:27:1946939425648112
54:28:1877405874732108
54:29:1683191473897752
54:30:1402659561581460
54:31:1085929983159840
54:32:780512175396135
54:33:520341450264090
54:34:321387366339585
54:35:183649923622620
54:36:96926348578605
54:37:47153358767970
54:38:21094923659355
54:39:8654327655120
54:40:3245372870670
54:41:1108176102180
54:42:343006888770
54:43:95722852680
54:44:23930713170
54:45:5317936260
54:46:1040465790
54:47:177100560
54:48:25827165
54:49:3162510
54:50:316251
54:51:24804
54:52:1431
54:53:54
54:54:1

# binomial(55, k) for 0 <= k <= 55

55:0:1
55:1:55
55:2:1485
55:3:26235
55:4:341055
55:5:3478761
55:6:28989675
55:7:202927725
55:8:1217566350
55:9:6358402050
55:10:29248649430
55:11:119653565850
55:12:438729741450
55:13:1451182990950
55:14:4353548972850
55:15:11899700525790
55:16:29749251314475
55:17:68248282427325
55:18:144079707346575
55:19:280576272201225
55:20:505037289962205
55:21:841728816603675
55:22:1300853625660225
55:23:1866442158555975
55:24:2488589544741300
55:25:3085851035479212
55:26:3560597348629860
55:27:3824345300380220
55:28:3824345300380220
55:29:3560597348629860
55:30:3085851035479212
55:31:2488589544741300
55:32:1866442158555975
55:33:1300853625660225
55:34:841728816603675
55:35:505037289962205
55:36:280576272201225
55:37:144079707346575
55:38:68248282427325
55:39:29749251314475
55:40:11899700525790
55:41:4353548972850
55:42:1451182990950
55:43:438729741450
55:44:119653565850
55:45:29248649430
55:46:6358402050
55:47:1217566350
55:48:202927725
55:49:28989675
55:50:3478761
55:51:341055
55:52:26235
55:53:1485
55:54:55
55:55:1

# binomial(56, k) for 0 <= k <= 56

56:0:1
56:1:56
56:2:1540
56:3:27720
56:4:367290
56:5:3819816
56:6:32468436
56:7:231917400
56:8:1420494075
56:9:7575968400
56:10:35607051480
56:11:148902215280
56:12:558383307300
56:13:1889912732400
56:14:5804731963800
56:15:16253249498640
56:16:41648951840265
56:17:97997533741800
56:18:212327989773900
56:19:424655979547800
56:20:785613562163430
56:21:1346766106565880
56:22:2142582442263900
56:23:3167295784216200
56:24:4355031703297275
56:25:5574440580220512
56:26:6646448384109072
56:27:7384942649010080
56:28:7648690600760440
56:29:7384942649010080
56:30:6646448384109072
56:31:5574440580220512
56:32:4355031703297275
56:33:3167295784216200
56:34:2142582442263900
56:35:1346766106565880
56:36:785613562163430
56:37:424655979547800
56:38:212327989773900
56:39:97997533741800
56:40:41648951840265
56:41:16253249498640
56:42:5804731963800
56:43:1889912732400
56:44:558383307300
56:45:148902215280
56:46:35607051480
56:47:7575968400
56:48:1420494075
56:49:231917400
56:50:32468436
56:51:3819816
56:52:367290
56:53:27720
56:54:1540
56:55:56
56:56:1

# binomial(57, k) for 0 <= k <= 57

57:0:1
57:1:57
57:2:1596
57:3:29260
57:4:395010
57:5:4187106
57:6:36288252
57:7:264385836
57:8:1652411475
57:9:8996462475
57:10:43183019880
57:11:184509266760
57:12:707285522580
57:13:2448296039700
57:14:7694644696200
57:15:22057981462440
57:16:57902201338905
57:17:139646485582065
57:18:310325523515700
57:19:636983969321700
57:20:1210269541711230
57:21:2132379668729310
57:22:3489348548829780
57:23:5309878226480100
57:24:7522327487513475
57:25:9929472283517787
57:26:12220888964329584
57:27:14031391033119152
57:28:15033633249770520
57:29:15033633249770520
57:30:14031391033119152
57:31:12220888964329584
57:32:9929472283517787
57:33:7522327487513475
57:34:5309878226480100
57:35:3489348548829780
57:36:2132379668729310
57:37:1210269541711230
57:38:636983969321700
57:39:310325523515700
57:40:139646485582065
57:41:57902201338905
57:42:22057981462440
57:43:7694644696200
57:44:2448296039700
57:45:707285522580
57:46:184509266760
57:47:43183019880
57:48:8996462475
57:49:1652411475
57:50:264385836
57:51:36288252
57:52:4187106
57:53:395010
57:54:29260
57:55:1596
57:56:57
57:57:1

# binomial(58, k) for 0 <= k <= 58

58:0:1
58:1:58
58:2:1653
58:3:30856
58:4:424270
58:5:4582116
58:6:40475358
58:7:300674088
58:8:1916797311
58:9:10648873950
58:10:52179482355
58:11:227692286640
58:12:891794789340
58:13:3155581562280
58:14:10142940735900
58:15:29752626158640
58:16:79960182801345
58:17:197548686920970
58:18:449972009097765
58:19:947309492837400
58:20:1847253511032930
58:21:3342649210440540
58:22:5621728217559090
58:23:8799226775309880
58:24:12832205713993575
58:25:17451799771031262
58:26:22150361247847371
58:27:26252279997448736
58:28:29065024282889672
58:29:30067266499541040
58:30:29065024282889672
58:31:26252279997448736
58:32:22150361247847371
58:33:17451799771031262
58:34:12832205713993575
58:35:8799226775309880
58:36:5621728217559090
58:37:3342649210440540
58:38:1847253511032930
58:39:947309492837400
58:40:449972009097765
58:41:197548686920970
58:42:79960182801345
58:43:29752626158640
58:44:10142940735900
58:45:3155581562280
58:46:891794789340
58:47:227692286640
58:48:52179482355
58:49:10648873950
58:50:1916797311
58:51:300674088
58:52:40475358
58:53:4582116
58:54:424270
58:55:30856
58:56:1653
58:57:58
58:58:1

# binomial(59, k) for 0 <= k <= 59

59:0:1
59:1:59
59:2:1711
59:3:32509
59:4:455126
59:5:5006386
59:6:45057474
59:7:341149446
59:8:2217471399
59:9:12565671261
59:10:62828356305
59:11:279871768995
59:12:1119487075980
59:13:4047376351620
59:14:13298522298180
59:15:39895566894540
59:16:109712808959985
59:17:277508869722315
59:18:647520696018735
59:19:1397281501935165
59:20:2794563003870330
59:21:5189902721473470
59:22:8964377427999630
59:23:14420954992868970
59:24:21631432489303455
59:25:30284005485024837
59:26:39602161018878633
59:27:48402641245296107
59:28:55317304280338408
59:29:59132290782430712
59:30:59132290782430712
59:31:55317304280338408
59:32:48402641245296107
59:33:39602161018878633
59:34:30284005485024837
59:35:21631432489303455
59:36:14420954992868970
59:37:8964377427999630
59:38:5189902721473470
59:39:2794563003870330
59:40:1397281501935165
59:41:647520696018735
59:42:277508869722315
59:43:109712808959985
59:44:39895566894540
59:45:13298522298180
59:46:4047376351620
59:47:1119487075980
59:48:279871768995
59:49:62828356305
59:50:12565671261
59:51:2217471399
59:52:341149446
59:53:45057474
59:54:5006386
59:55:455126
59:56:32509
59:57:1711
59:58:59
59:59:1

# binomial(60, k) for 0 <= k <= 60

60:0:1
60:1:60
60:2:1770
60:3:34220
60:4:487635
60:5:5461512
60:6:50063860
60:7:386206920
60:8:2558620845
60:9:14783142660
60:10:75394027566
60:11:342700125300
60:12:1399358844975
60:13:5166863427600
60:14:17345898649800
60:15:53194089192720
60:16:149608375854525
60:17:387221678682300
60:18:925029565741050
60:19:2044802197953900
60:20:4191844505805495
60:21:7984465725343800
60:22:14154280149473100
60:23:23385332420868600
60:24:36052387482172425
60:25:51915437974328292
60:26:69886166503903470
60:27:88004802264174740
60:28:103719945525634515
60:29:114449595062769120
60:30:118264581564861424
60:31:114449595062769120
60:32:103719945525634515
60:33:88004802264174740
60:34:69886166503903470
60:35:51915437974328292
60:36:36052387482172425
60:37:23385332420868600
60:38:14154280149473100
60:39:7984465725343800
60:40:4191844505805495
60:41:2044802197953900
60:42:925029565741050
60:43:387221678682300
60:44:149608375854525
60:45:53194089192720
60:46:17345898649800
60:47:5166863427600
60:48:1399358844975
60:49:342700125300
60:50:75394027566
60:51:14783142660
60:52:2558620845
60:53:386206920
60:54:50063860
60:55:5461512
60:56:487635
60:57:34220
60:58:1770
60:59:60
60:60:1

# binomial(61, k) for 0 <= k <= 61

61:0:1
61:1:61
61:2:1830
61:3:35990
61:4:521855
61:5:5949147
61:6:55525372
61:7:436270780
61:8:2944827765
61:9:17341763505
61:10:90177170226
61:11:418094152866
61:12:1742058970275
61:13:6566222272575
61:14:22512762077400
61:15:70539987842520
61:16:202802465047245
61:17:536830054536825
61:18:1312251244423350
61:19:2969831763694950
61:20:6236646703759395
61:21:12176310231149295
61:22:22138745874816900
61:23:37539612570341700
61:24:59437719903041025
61:25:87967825456500717
61:26:121801604478231762
61:27:157890968768078210
61:28:191724747789809255
61:29:218169540588403635
61:30:232714176627630544
61:31:232714176627630544
61:32:218169540588403635
61:33:191724747789809255
61:34:157890968768078210
61:35:121801604478231762
61:36:87967825456500717
61:37:59437719903041025
61:38:37539612570341700
61:39:22138745874816900
61:40:12176310231149295
61:41:6236646703759395
61:42:2969831763694950
61:43:1312251244423350
61:44:536830054536825
61:45:202802465047245
61:46:70539987842520
61:47:22512762077400
61:48:6566222272575
61:49:1742058970275
61:50:418094152866
61:51:90177170226
61:52:17341763505
61:53:2944827765
61:54:436270780
61:55:55525372
61:56:5949147
61:57:521855
61:58:35990
61:59:1830
61:60:61
61:61:1

# binomial(62, k) for 0 <= k <= 62

62:0:1
62:1:62
62:2:1891
62:3:37820
62:4:557845
62:5:6471002
62:6:61474519
62:7:491796152
62:8:3381098545
62:9:20286591270
62:10:107518933731
62:11:508271323092
62:12:2160153123141
62:13:8308281242850
62:14:29078984349975
62:15:93052749919920
62:16:273342452889765
62:17:739632519584070
62:18:1849081298960175
62:19:4282083008118300
62:20:9206478467454345
62:21:18412956934908690
62:22:34315056105966195
62:23:59678358445158600
62:24:96977332473382725
62:25:147405545359541742
62:26:209769429934732479
62:27:279692573246309972
62:28:349615716557887465
62:29:409894288378212890
62:30:450883717216034179
62:31:465428353255261088
62:32:450883717216034179
62:33:409894288378212890
62:34:349615716557887465
62:35:279692573246309972
62:36:209769429934732479
62:37:147405545359541742
62:38:96977332473382725
62:39:59678358445158600
62:40:34315056105966195
62:41:18412956934908690
62:42:9206478467454345
62:43:4282083008118300
62:44:1849081298960175
62:45:739632519584070
62:46:273342452889765
62:47:93052749919920
62:48:29078984349975
62:49:8308281242850
62:50:2160153123141
62:51:508271323092
62:52:107518933731
62:53:20286591270
62:54:3381098545
62:55:491796152
62:56:61474519
62:57:6471002
62:58:557845
62:59:37820
62:60:1891
62:61:62
62:62:1

# binomial(63, k) for 0 <= k <= 63

63:0:1
63:1:63
63:2:1953
63:3:39711
63:4:595665
63:5:7028847
63:6:67945521
63:7:553270671
63:8:3872894697
63:9:23667689815
63:10:127805525001
63:11:615790256823
63:12:2668424446233
63:13:10468434365991
63:14:37387265592825
63:15:122131734269895
63:16:366395202809685
63:17:1012974972473835
63:18:2588713818544245
63:19:6131164307078475
63:20:13488561475572645
63:21:27619435402363035
63:22:52728013040874885
63:23:93993414551124795
63:24:156655690918541325
63:25:244382877832924467
63:26:357174975294274221
63:27:489462003181042451
63:28:629308289804197437
63:29:759510004936100355
63:30:860778005594247069
63:31:916312070471295267
63:32:916312070471295267
63:33:860778005594247069
63:34:759510004936100355
63:35:629308289804197437
63:36:489462003181042451
63:37:357174975294274221
63:38:244382877832924467
63:39:156655690918541325
63:40:93993414551124795
63:41:52728013040874885
63:42:27619435402363035
63:43:13488561475572645
63:44:6131164307078475
63:45:2588713818544245
63:46:1012974972473835
63:47:366395202809685
63:48:122131734269895
63:49:37387265592825
63:50:10468434365991
63:51:2668424446233
63:52:615790256823
63:53:127805525001
63:54:23667689815
63:55:3872894697
63:56:553270671
63:57:67945521
63:58:7028847
63:59:595665
63:60:39711
63:61:1953
63:62:63
63:63:1

# binomial(64, k) for 0 <= k <= 64

64:0:1
64:1:64
64:2:2016
64:3:41664
64:4:635376
64:5:7624512
64:6:74974368
64:7:621216192
64:8:4426165368
64:9:27540584512
64:10:151473214816
64:11:743595781824
64:12:3284214703056
64:13:13136858812224
64:14:47855699958816
64:15:159518999862720
64:16:488526937079580
64:17:1379370175283520
64:18:3601688791018080
64:19:8719878125622720
64:20:19619725782651120
64:21:41107996877935680
64:22:80347448443237920
64:23:146721427591999680
64:24:250649105469666120
64:25:401038568751465792
64:26:601557853127198688
64:27:846636978475316672
64:28:1118770292985239888
64:29:1388818294740297792
64:30:1620288010530347424
64:31:1777090076065542336
64:32:1832624140942590534
64:33:1777090076065542336
64:34:1620288010530347424
64:35:1388818294740297792
64:36:1118770292985239888
64:37:846636978475316672
64:38:601557853127198688
64:39:401038568751465792
64:40:250649105469666120
64:41:146721427591999680
64:42:80347448443237920
64:43:41107996877935680
64:44:19619725782651120
64:45:8719878125622720
64:46:3601688791018080
64:47:1379370175283520
64:48:488526937079580
64:49:159518999862720
64:50:47855699958816
64:51:13136858812224
64:52:3284214703056
64:53:743595781824
64:54:151473214816
64:55:27540584512
64:56:4426165368
64:57:621216192
64:58:74974368
64:59:7624512
64:60:635376
64:61:41664
64:62:2016
64:63:64
64:64:1

# binomial(65, k) for 0 <= k <= 65

65:0:1
65:1:65
65:2:2080
65:3:43680
65:4:677040
65:5:8259888
65:6:82598880
65:7:696190560
65:8:5047381560
65:9:31966749880
65:10:179013799328
65:11:895068996640
65:12:4027810484880
65:13:16421073515280
65:14:60992558771040
65:15:207374699821536
65:16:648045936942300
65:17:1867897112363100
65:18:4981058966301600
65:19:12321566916640800
65:20:28339603908273840
65:21:60727722660586800
65:22:121455445321173600
65:23:227068876035237600
65:24:397370533061665800
65:25:651687674221131912
65:26:1002596421878664480
65:27:1448194831602515360
65:28:1965407271460556560
65:29:2507588587725537680
65:30:3009106305270645216
65:31:3397378086595889760
65:32:3609714217008132870
65:33:3609714217008132870
65:34:3397378086595889760
65:35:3009106305270645216
65:36:2507588587725537680
65:37:1965407271460556560
65:38:1448194831602515360
65:39:1002596421878664480
65:40:651687674221131912
65:41:397370533061665800
65:42:227068876035237600
65:43:121455445321173600
65:44:60727722660586800
65:45:28339603908273840
65:46:12321566916640800
65:47:4981058966301600
65:48:1867897112363100
65:49:648045936942300
65:50:207374699821536
65:51:60992558771040
65:52:16421073515280
65:53:4027810484880
65:54:895068996640
65:55:179013799328
65:56:31966749880
65:57:5047381560
65:58:696190560
65:59:82598880
65:60:8259888
65:61:677040
65:62:43680
65:63:2080
65:64:65
65:65:1

# binomial(66, k) for 0 <= k <= 66

66:0:1
66:1:66
66:2:2145
66:3:45760
66:4:720720
66:5:8936928
66:6:90858768
66:7:778789440
66:8:5743572120
66:9:37014131440
66:10:210980549208
66:11:1074082795968
66:12:4922879481520
66:13:20448884000160
66:14:77413632286320
66:15:268367258592576
66:16:855420636763836
66:17:2515943049305400
66:18:6848956078664700
66:19:17302625882942400
66:20:40661170824914640
66:21:89067326568860640
66:22:182183167981760400
66:23:348524321356411200
66:24:624439409096903400
66:25:1049058207282797712
66:26:1654284096099796392
66:27:2450791253481179840
66:28:3413602103063071920
66:29:4472995859186094240
66:30:5516694892996182896
66:31:6406484391866534976
66:32:7007092303604022630
66:33:7219428434016265740
66:34:7007092303604022630
66:35:6406484391866534976
66:36:5516694892996182896
66:37:4472995859186094240
66:38:3413602103063071920
66:39:2450791253481179840
66:40:1654284096099796392
66:41:1049058207282797712
66:42:624439409096903400
66:43:348524321356411200
66:44:182183167981760400
66:45:89067326568860640
66:46:40661170824914640
66:47:17302625882942400
66:48:6848956078664700
66:49:2515943049305400
66:50:855420636763836
66:51:268367258592576
66:52:77413632286320
66:53:20448884000160
66:54:4922879481520
66:55:1074082795968
66:56:210980549208
66:57:37014131440
66:58:5743572120
66:59:778789440
66:60:90858768
66:61:8936928
66:62:720720
66:63:45760
66:64:2145
66:65:66
66:66:1

# binomial(67, k) for 0 <= k <= 67

67:0:1
67:1:67
67:2:2211
67:3:47905
67:4:766480
67:5:9657648
67:6:99795696
67:7:869648208
67:8:6522361560
67:9:42757703560
67:10:247994680648
67:11:1285063345176
67:12:5996962277488
67:13:25371763481680
67:14:97862516286480
67:15:345780890878896
67:16:1123787895356412
67:17:3371363686069236
67:18:9364899127970100
67:19:24151581961607100
67:20:57963796707857040
67:21:129728497393775280
67:22:271250494550621040
67:23:530707489338171600
67:24:972963730453314600
67:25:1673497616379701112
67:26:2703342303382594104
67:27:4105075349580976232
67:28:5864393356544251760
67:29:7886597962249166160
67:30:9989690752182277136
67:31:11923179284862717872
67:32:13413576695470557606
67:33:14226520737620288370
67:34:14226520737620288370
67:35:13413576695470557606
67:36:11923179284862717872
67:37:9989690752182277136
67:38:7886597962249166160
67:39:5864393356544251760
67:40:4105075349580976232
67:41:2703342303382594104
67:42:1673497616379701112
67:43:972963730453314600
67:44:530707489338171600
67:45:271250494550621040
67:46:129728497393775280
67:47:57963796707857040
67:48:24151581961607100
67:49:9364899127970100
67:50:3371363686069236
67:51:1123787895356412
67:52:345780890878896
67:53:97862516286480
67:54:25371763481680
67:55:5996962277488
67:56:1285063345176
67:57:247994680648
67:58:42757703560
67:59:6522361560
67:60:869648208
67:61:99795696
67:62:9657648
67:63:766480
67:64:47905
67:65:2211
67:66:67
67:67:1

# binomial(68, k) for 0 <= k <= 68

68:0:1
68:1:68
68:2:2278
68:3:50116
68:4:814385
68:5:10424128
68:6:109453344
68:7:969443904
68:8:7392009768
68:9:49280065120
68:10:290752384208
68:11:1533058025824
68:12:7282025622664
68:13:31368725759168
68:14:123234279768160
68:15:443643407165376
68:16:1469568786235308
68:17:4495151581425648
68:18:12736262814039336
68:19:33516481089577200
68:20:82115378669464140
68:21:187692294101632320
68:22:400978991944396320
68:23:801957983888792640
68:24:1503671219791486200
68:25:2646461346833015712
68:26:4376839919762295216
68:27:6808417652963570336
68:28:9969468706125227992
68:29:13750991318793417920
68:30:17876288714431443296
68:31:21912870037044995008
68:32:25336755980333275478
68:33:27640097433090845976
68:34:28453041475240576740
68:35:27640097433090845976
68:36:25336755980333275478
68:37:21912870037044995008
68:38:17876288714431443296
68:39:13750991318793417920
68:40:9969468706125227992
68:41:6808417652963570336
68:42:4376839919762295216
68:43:2646461346833015712
68:44:1503671219791486200
68:45:801957983888792640
68:46:400978991944396320
68:47:187692294101632320
68:48:82115378669464140
68:49:33516481089577200
68:50:12736262814039336
68:51:4495151581425648
68:52:1469568786235308
68:53:443643407165376
68:54:123234279768160
68:55:31368725759168
68:56:7282025622664
68:57:1533058025824
68:58:290752384208
68:59:49280065120
68:60:7392009768
68:61:969443904
68:62:109453344
68:63:10424128
68:64:814385
68:65:50116
68:66:2278
68:67:68
68:68:1

# binomial(69, k) for 0 <= k <= 69

69:0:1
69:1:69
69:2:2346
69:3:52394
69:4:864501
69:5:11238513
69:6:119877472
69:7:1078897248
69:8:8361453672
69:9:56672074888
69:10:340032449328
69:11:1823810410032
69:12:8815083648488
69:13:38650751381832
69:14:154603005527328
69:15:566877686933536
69:16:1913212193400684
69:17:5964720367660956
69:18:17231414395464984
69:19:46252743903616536
69:20:115631859759041340
69:21:269807672771096460
69:22:588671286046028640
69:23:1202936975833188960
69:24:2305629203680278840
69:25:4150132566624501912
69:26:7023301266595310928
69:27:11185257572725865552
69:28:16777886359088798328
69:29:23720460024918645912
69:30:31627280033224861216
69:31:39789158751476438304
69:32:47249626017378270486
69:33:52976853413424121454
69:34:56093138908331422716
69:35:56093138908331422716
69:36:52976853413424121454
69:37:47249626017378270486
69:38:39789158751476438304
69:39:31627280033224861216
69:40:23720460024918645912
69:41:16777886359088798328
69:42:11185257572725865552
69:43:7023301266595310928
69:44:4150132566624501912
69:45:2305629203680278840
69:46:1202936975833188960
69:47:588671286046028640
69:48:269807672771096460
69:49:115631859759041340
69:50:46252743903616536
69:51:17231414395464984
69:52:5964720367660956
69:53:1913212193400684
69:54:566877686933536
69:55:154603005527328
69:56:38650751381832
69:57:8815083648488
69:58:1823810410032
69:59:340032449328
69:60:56672074888
69:61:8361453672
69:62:1078897248
69:63:119877472
69:64:11238513
69:65:864501
69:66:52394
69:67:2346
69:68:69
69:69:1

# binomial(70, k) for 0 <= k <= 70

70:0:1
70:1:70
70:2:2415
70:3:54740
70:4:916895
70:5:12103014
70:6:131115985
70:7:1198774720
70:8:9440350920
70:9:65033528560
70:10:396704524216
70:11:2163842859360
70:12:10638894058520
70:13:47465835030320
70:14:193253756909160
70:15:721480692460864
70:16:2480089880334220
70:17:7877932561061640
70:18:23196134763125940
70:19:63484158299081520
70:20:161884603662657876
70:21:385439532530137800
70:22:858478958817125100
70:23:1791608261879217600
70:24:3508566179513467800
70:25:6455761770304780752
70:26:11173433833219812840
70:27:18208558839321176480
70:28:27963143931814663880
70:29:40498346384007444240
70:30:55347740058143507128
70:31:71416438784701299520
70:32:87038784768854708790
70:33:100226479430802391940
70:34:109069992321755544170
70:35:112186277816662845432
70:36:109069992321755544170
70:37:100226479430802391940
70:38:87038784768854708790
70:39:71416438784701299520
70:40:55347740058143507128
70:41:40498346384007444240
70:42:27963143931814663880
70:43:18208558839321176480
70:44:11173433833219812840
70:45:6455761770304780752
70:46:3508566179513467800
70:47:1791608261879217600
70:48:858478958817125100
70:49:385439532530137800
70:50:161884603662657876
70:51:63484158299081520
70:52:23196134763125940
70:53:7877932561061640
70:54:2480089880334220
70:55:721480692460864
70:56:193253756909160
70:57:47465835030320
70:58:10638894058520
70:59:2163842859360
70:60:396704524216
70:61:65033528560
70:62:9440350920
70:63:1198774720
70:64:131115985
70:65:12103014
70:66:916895
70:67:54740
70:68:2415
70:69:70
70:70:1

# binomial(71, k) for 0 <= k <= 71

71:0:1
71:1:71
71:2:2485
71:3:57155
71:4:971635
71:5:13019909
71:6:143218999
71:7:1329890705
71:8:10639125640
71:9:74473879480
71:10:461738052776
71:11:2560547383576
71:12:12802736917880
71:13:58104729088840
71:14:240719591939480
71:15:914734449370024
71:16:3201570572795084
71:17:10358022441395860
71:18:31074067324187580
71:19:86680293062207460
71:20:225368761961739396
71:21:547324136192795676
71:22:1243918491347262900
71:23:2650087220696342700
71:24:5300174441392685400
71:25:9964327949818248552
71:26:17629195603524593592
71:27:29381992672540989320
71:28:46171702771135840360
71:29:68461490315822108120
71:30:95846086442150951368
71:31:126764178842844806648
71:32:158455223553556008310
71:33:187265264199657100730
71:34:209296471752557936110
71:35:221256270138418389602
71:36:221256270138418389602
71:37:209296471752557936110
71:38:187265264199657100730
71:39:158455223553556008310
71:40:126764178842844806648
71:41:95846086442150951368
71:42:68461490315822108120
71:43:46171702771135840360
71:44:29381992672540989320
71:45:17629195603524593592
71:46:9964327949818248552
71:47:5300174441392685400
71:48:2650087220696342700
71:49:1243918491347262900
71:50:547324136192795676
71:51:225368761961739396
71:52:86680293062207460
71:53:31074067324187580
71:54:10358022441395860
71:55:3201570572795084
71:56:914734449370024
71:57:240719591939480
71:58:58104729088840
71:59:12802736917880
71:60:2560547383576
71:61:461738052776
71:62:74473879480
71:63:10639125640
71:64:1329890705
71:65:143218999
71:66:13019909
71:67:971635
71:68:57155
71:69:2485
71:70:71
71:71:1

# binomial(72, k) for 0 <= k <= 72

72:0:1
72:1:72
72:2:2556
72:3:59640
72:4:1028790
72:5:13991544
72:6:156238908
72:7:1473109704
72:8:11969016345
72:9:85113005120
72:10:536211932256
72:11:3022285436352
72:12:15363284301456
72:13:70907466006720
72:14:298824321028320
72:15:1155454041309504
72:16:4116305022165108
72:17:13559593014190944
72:18:41432089765583440
72:19:117754360386395040
72:20:312049055023946856
72:21:772692898154535072
72:22:1791242627540058576
72:23:3894005712043605600
72:24:7950261662089028100
72:25:15264502391210933952
72:26:27593523553342842144
72:27:47011188276065582912
72:28:75553695443676829680
72:29:114633193086957948480
72:30:164307576757973059488
72:31:222610265284995758016
72:32:285219402396400814958
72:33:345720487753213109040
72:34:396561735952215036840
72:35:430552741890976325712
72:36:442512540276836779204
72:37:430552741890976325712
72:38:396561735952215036840
72:39:345720487753213109040
72:40:285219402396400814958
72:41:222610265284995758016
72:42:164307576757973059488
72:43:114633193086957948480
72:44:75553695443676829680
72:45:47011188276065582912
72:46:27593523553342842144
72:47:15264502391210933952
72:48:7950261662089028100
72:49:3894005712043605600
72:50:1791242627540058576
72:51:772692898154535072
72:52:312049055023946856
72:53:117754360386395040
72:54:41432089765583440
72:55:13559593014190944
72:56:4116305022165108
72:57:1155454041309504
72:58:298824321028320
72:59:70907466006720
72:60:15363284301456
72:61:3022285436352
72:62:536211932256
72:63:85113005120
72:64:11969016345
72:65:1473109704
72:66:156238908
72:67:13991544
72:68:1028790
72:69:59640
72:70:2556
72:71:72
72:72:1

# binomial(73, k) for 0 <= k <= 73

73:0:1
73:1:73
73:2:2628
73:3:62196
73:4:1088430
73:5:15020334
73:6:170230452
73:7:1629348612
73:8:13442126049
73:9:97082021465
73:10:621324937376
73:11:3558497368608
73:12:18385569737808
73:13:86270750308176
73:14:369731787035040
73:15:1454278362337824
73:16:5271759063474612
73:17:17675898036356052
73:18:54991682779774384
73:19:159186450151978480
73:20:429803415410341896
73:21:1084741953178481928
73:22:2563935525694593648
73:23:5685248339583664176
73:24:11844267374132633700
73:25:23214764053299962052
73:26:42858025944553776096
73:27:74604711829408425056
73:28:122564883719742412592
73:29:190186888530634778160
73:30:278940769844931007968
73:31:386917842042968817504
73:32:507829667681396572974
73:33:630939890149613923998
73:34:742282223705428145880
73:35:827114477843191362552
73:36:873065282167813104916
73:37:873065282167813104916
73:38:827114477843191362552
73:39:742282223705428145880
73:40:630939890149613923998
73:41:507829667681396572974
73:42:386917842042968817504
73:43:278940769844931007968
73:44:190186888530634778160
73:45:122564883719742412592
73:46:74604711829408425056
73:47:42858025944553776096
73:48:23214764053299962052
73:49:11844267374132633700
73:50:5685248339583664176
73:51:2563935525694593648
73:52:1084741953178481928
73:53:429803415410341896
73:54:159186450151978480
73:55:54991682779774384
73:56:17675898036356052
73:57:5271759063474612
73:58:1454278362337824
73:59:369731787035040
73:60:86270750308176
73:61:18385569737808
73:62:3558497368608
73:63:621324937376
73:64:97082021465
73:65:13442126049
73:66:1629348612
73:67:170230452
73:68:15020334
73:69:1088430
73:70:62196
73:71:2628
73:72:73
73:73:1

# binomial(74, k) for 0 <= k <= 74

74:0:1
74:1:74
74:2:2701
74:3:64824
74:4:1150626
74:5:16108764
74:6:185250786
74:7:1799579064
74:8:15071474661
74:9:110524147514
74:10:718406958841
74:11:4179822305984
74:12:21944067106416
74:13:104656320045984
74:14:456002537343216
74:15:1824010149372864
74:16:6726037425812436
74:17:22947657099830664
74:18:72667580816130436
74:19:214178132931752864
74:20:588989865562320376
74:21:1514545368588823824
74:22:3648677478873075576
74:23:8249183865278257824
74:24:17529515713716297876
74:25:35059031427432595752
74:26:66072789997853738148
74:27:117462737773962201152
74:28:197169595549150837648
74:29:312751772250377190752
74:30:469127658375565786128
74:31:665858611887899825472
74:32:894747509724365390478
74:33:1138769557831010496972
74:34:1373222113855042069878
74:35:1569396701548619508432
74:36:1700179760011004467468
74:37:1746130564335626209832
74:38:1700179760011004467468
74:39:1569396701548619508432
74:40:1373222113855042069878
74:41:1138769557831010496972
74:42:894747509724365390478
74:43:665858611887899825472
74:44:469127658375565786128
74:45:312751772250377190752
74:46:197169595549150837648
74:47:117462737773962201152
74:48:66072789997853738148
74:49:35059031427432595752
74:50:17529515713716297876
74:51:8249183865278257824
74:52:3648677478873075576
74:53:1514545368588823824
74:54:588989865562320376
74:55:214178132931752864
74:56:72667580816130436
74:57:22947657099830664
74:58:6726037425812436
74:59:1824010149372864
74:60:456002537343216
74:61:104656320045984
74:62:21944067106416
74:63:4179822305984
74:64:718406958841
74:65:110524147514
74:66:15071474661
74:67:1799579064
74:68:185250786
74:69:16108764
74:70:1150626
74:71:64824
74:72:2701
74:73:74
74:74:1

# binomial(75, k) for 0 <= k <= 75

75:0:1
75:1:75
75:2:2775
75:3:67525
75:4:1215450
75:5:17259390
75:6:201359550
75:7:1984829850
75:8:16871053725
75:9:125595622175
75:10:828931106355
75:11:4898229264825
75:12:26123889412400
75:13:126600387152400
75:14:560658857389200
75:15:2280012686716080
75:16:8550047575185300
75:17:29673694525643100
75:18:95615237915961100
75:19:286845713747883300
75:20:803167998494073240
75:21:2103535234151144200
75:22:5163222847461899400
75:23:11897861344151333400
75:24:25778699578994555700
75:25:52588547141148893628
75:26:101131821425286333900
75:27:183535527771815939300
75:28:314632333323113038800
75:29:509921367799528028400
75:30:781879430625942976880
75:31:1134986270263465611600
75:32:1560606121612265215950
75:33:2033517067555375887450
75:34:2511991671686052566850
75:35:2942618815403661578310
75:36:3269576461559623975900
75:37:3446310324346630677300
75:38:3446310324346630677300
75:39:3269576461559623975900
75:40:2942618815403661578310
75:41:2511991671686052566850
75:42:2033517067555375887450
75:43:1560606121612265215950
75:44:1134986270263465611600
75:45:781879430625942976880
75:46:509921367799528028400
75:47:314632333323113038800
75:48:183535527771815939300
75:49:101131821425286333900
75:50:52588547141148893628
75:51:25778699578994555700
75:52:11897861344151333400
75:53:5163222847461899400
75:54:2103535234151144200
75:55:803167998494073240
75:56:286845713747883300
75:57:95615237915961100
75:58:29673694525643100
75:59:8550047575185300
75:60:2280012686716080
75:61:560658857389200
75:62:126600387152400
75:63:26123889412400
75:64:4898229264825
75:65:828931106355
75:66:125595622175
75:67:16871053725
75:68:1984829850
75:69:201359550
75:70:17259390
75:71:1215450
75:72:67525
75:73:2775
75:74:75
75:75:1

# binomial(76, k) for 0 <= k <= 76

76:0:1
76:1:76
76:2:2850
76:3:70300
76:4:1282975
76:5:18474840
76:6:218618940
76:7:2186189400
76:8:18855883575
76:9:142466675900
76:10:954526728530
76:11:5727160371180
76:12:31022118677225
76:13:152724276564800
76:14:687259244541600
76:15:2840671544105280
76:16:10830060261901380
76:17:38223742100828400
76:18:125288932441604200
76:19:382460951663844400
76:20:1090013712241956540
76:21:2906703232645217440
76:22:7266758081613043600
76:23:17061084191613232800
76:24:37676560923145889100
76:25:78367246720143449328
76:26:153720368566435227528
76:27:284667349197102273200
76:28:498167861094928978100
76:29:824553701122641067200
76:30:1291800798425471005280
76:31:1916865700889408588480
76:32:2695592391875730827550
76:33:3594123189167641103400
76:34:4545508739241428454300
76:35:5454610487089714145160
76:36:6212195276963285554210
76:37:6715886785906254653200
76:38:6892620648693261354600
76:39:6715886785906254653200
76:40:6212195276963285554210
76:41:5454610487089714145160
76:42:4545508739241428454300
76:43:3594123189167641103400
76:44:2695592391875730827550
76:45:1916865700889408588480
76:46:1291800798425471005280
76:47:824553701122641067200
76:48:498167861094928978100
76:49:284667349197102273200
76:50:153720368566435227528
76:51:78367246720143449328
76:52:37676560923145889100
76:53:17061084191613232800
76:54:7266758081613043600
76:55:2906703232645217440
76:56:1090013712241956540
76:57:382460951663844400
76:58:125288932441604200
76:59:38223742100828400
76:60:10830060261901380
76:61:2840671544105280
76:62:687259244541600
76:63:152724276564800
76:64:31022118677225
76:65:5727160371180
76:66:954526728530
76:67:142466675900
76:68:18855883575
76:69:2186189400
76:70:218618940
76:71:18474840
76:72:1282975
76:73:70300
76:74:2850
76:75:76
76:76:1

# binomial(77, k) for 0 <= k <= 77

77:0:1
77:1:77
77:2:2926
77:3:73150
77:4:1353275
77:5:19757815
77:6:237093780
77:7:2404808340
77:8:21042072975
77:9:161322559475
77:10:1096993404430
77:11:6681687099710
77:12:36749279048405
77:13:183746395242025
77:14:839983521106400
77:15:3527930788646880
77:16:13670731806006660
77:17:49053802362729780
77:18:163512674542432600
77:19:507749884105448600
77:20:1472474663905800940
77:21:3996716944887173980
77:22:10173461314258261040
77:23:24327842273226276400
77:24:54737645114759121900
77:25:116043807643289338428
77:26:232087615286578676856
77:27:438387717763537500728
77:28:782835210292031251300
77:29:1322721562217570045300
77:30:2116354499548112072480
77:31:3208666499314879593760
77:32:4612458092765139416030
77:33:6289715581043371930950
77:34:8139631928409069557700
77:35:10000119226331142599460
77:36:11666805764052999699370
77:37:12928082062869540207410
77:38:13608507434599516007800
77:39:13608507434599516007800
77:40:12928082062869540207410
77:41:11666805764052999699370
77:42:10000119226331142599460
77:43:8139631928409069557700
77:44:6289715581043371930950
77:45:4612458092765139416030
77:46:3208666499314879593760
77:47:2116354499548112072480
77:48:1322721562217570045300
77:49:782835210292031251300
77:50:438387717763537500728
77:51:232087615286578676856
77:52:116043807643289338428
77:53:54737645114759121900
77:54:24327842273226276400
77:55:10173461314258261040
77:56:3996716944887173980
77:57:1472474663905800940
77:58:507749884105448600
77:59:163512674542432600
77:60:49053802362729780
77:61:13670731806006660
77:62:3527930788646880
77:63:839983521106400
77:64:183746395242025
77:65:36749279048405
77:66:6681687099710
77:67:1096993404430
77:68:161322559475
77:69:21042072975
77:70:2404808340
77:71:237093780
77:72:19757815
77:73:1353275
77:74:73150
77:75:2926
77:76:77
77:77:1

# binomial(78, k) for 0 <= k <= 78

78:0:1
78:1:78
78:2:3003
78:3:76076
78:4:1426425
78:5:21111090
78:6:256851595
78:7:2641902120
78:8:23446881315
78:9:182364632450
78:10:1258315963905
78:11:7778680504140
78:12:43430966148115
78:13:220495674290430
78:14:1023729916348425
78:15:4367914309753280
78:16:17198662594653540
78:17:62724534168736440
78:18:212566476905162380
78:19:671262558647881200
78:20:1980224548011249540
78:21:5469191608792974920
78:22:14170178259145435020
78:23:34501303587484537440
78:24:79065487387985398300
78:25:170781452758048460328
78:26:348131422929868015284
78:27:670475333050116177584
78:28:1221222928055568752028
78:29:2105556772509601296600
78:30:3439076061765682117780
78:31:5325020998862991666240
78:32:7821124592080019009790
78:33:10902173673808511346980
78:34:14429347509452441488650
78:35:18139751154740212157160
78:36:21666924990384142298830
78:37:24594887826922539906780
78:38:26536589497469056215210
78:39:27217014869199032015600
78:40:26536589497469056215210
78:41:24594887826922539906780
78:42:21666924990384142298830
78:43:18139751154740212157160
78:44:14429347509452441488650
78:45:10902173673808511346980
78:46:7821124592080019009790
78:47:5325020998862991666240
78:48:3439076061765682117780
78:49:2105556772509601296600
78:50:1221222928055568752028
78:51:670475333050116177584
78:52:348131422929868015284
78:53:170781452758048460328
78:54:79065487387985398300
78:55:34501303587484537440
78:56:14170178259145435020
78:57:5469191608792974920
78:58:1980224548011249540
78:59:671262558647881200
78:60:212566476905162380
78:61:62724534168736440
78:62:17198662594653540
78:63:4367914309753280
78:64:1023729916348425
78:65:220495674290430
78:66:43430966148115
78:67:7778680504140
78:68:1258315963905
78:69:182364632450
78:70:23446881315
78:71:2641902120
78:72:256851595
78:73:21111090
78:74:1426425
78:75:76076
78:76:3003
78:77:78
78:78:1

# binomial(79, k) for 0 <= k <= 79

79:0:1
79:1:79
79:2:3081
79:3:79079
79:4:1502501
79:5:22537515
79:6:277962685
79:7:2898753715
79:8:26088783435
79:9:205811513765
79:10:1440680596355
79:11:9036996468045
79:12:51209646652255
79:13:263926640438545
79:14:1244225590638855
79:15:5391644226101705
79:16:21566576904406820
79:17:79923196763389980
79:18:275291011073898820
79:19:883829035553043580
79:20:2651487106659130740
79:21:7449416156804224460
79:22:19639369867938409940
79:23:48671481846629972460
79:24:113566790975469935740
79:25:249846940146033858628
79:26:518912875687916475612
79:27:1018606755979984192868
79:28:1891698261105684929612
79:29:3326779700565170048628
79:30:5544632834275283414380
79:31:8764097060628673784020
79:32:13146145590943010676030
79:33:18723298265888530356770
79:34:25331521183260952835630
79:35:32569098664192653645810
79:36:39806676145124354455990
79:37:46261812817306682205610
79:38:51131477324391596121990
79:39:53753604366668088230810
79:40:53753604366668088230810
79:41:51131477324391596121990
79:42:46261812817306682205610
79:43:39806676145124354455990
79:44:32569098664192653645810
79:45:25331521183260952835630
79:46:18723298265888530356770
79:47:13146145590943010676030
79:48:8764097060628673784020
79:49:5544632834275283414380
79:50:3326779700565170048628
79:51:1891698261105684929612
79:52:1018606755979984192868
79:53:518912875687916475612
79:54:249846940146033858628
79:55:113566790975469935740
79:56:48671481846629972460
79:57:19639369867938409940
79:58:7449416156804224460
79:59:2651487106659130740
79:60:883829035553043580
79:61:275291011073898820
79:62:79923196763389980
79:63:21566576904406820
79:64:5391644226101705
79:65:1244225590638855
79:66:263926640438545
79:67:51209646652255
79:68:9036996468045
79:69:1440680596355
79:70:205811513765
79:71:26088783435
79:72:2898753715
79:73:277962685
79:74:22537515
79:75:1502501
79:76:79079
79:77:3081
79:78:79
79:79:1

# binomial(80, k) for 0 <= k <= 80

80:0:1
80:1:80
80:2:3160
80:3:82160
80:4:1581580
80:5:24040016
80:6:300500200
80:7:3176716400
80:8:28987537150
80:9:231900297200
80:10:1646492110120
80:11:10477677064400
80:12:60246643120300
80:13:315136287090800
80:14:1508152231077400
80:15:6635869816740560
80:16:26958221130508525
80:17:101489773667796800
80:18:355214207837288800
80:19:1159120046626942400
80:20:3535316142212174320
80:21:10100903263463355200
80:22:27088786024742634400
80:23:68310851714568382400
80:24:162238272822099908200
80:25:363413731121503794368
80:26:768759815833950334240
80:27:1537519631667900668480
80:28:2910305017085669122480
80:29:5218477961670854978240
80:30:8871412534840453463008
80:31:14308729894903957198400
80:32:21910242651571684460050
80:33:31869443856831541032800
80:34:44054819449149483192400
80:35:57900619847453606481440
80:36:72375774809317008101800
80:37:86068488962431036661600
80:38:97393290141698278327600
80:39:104885081691059684352800
80:40:107507208733336176461620
80:41:104885081691059684352800
80:42:97393290141698278327600
80:43:86068488962431036661600
80:44:72375774809317008101800
80:45:57900619847453606481440
80:46:44054819449149483192400
80:47:31869443856831541032800
80:48:21910242651571684460050
80:49:14308729894903957198400
80:50:8871412534840453463008
80:51:5218477961670854978240
80:52:2910305017085669122480
80:53:1537519631667900668480
80:54:768759815833950334240
80:55:363413731121503794368
80:56:162238272822099908200
80:57:68310851714568382400
80:58:27088786024742634400
80:59:10100903263463355200
80:60:3535316142212174320
80:61:1159120046626942400
80:62:355214207837288800
80:63:101489773667796800
80:64:26958221130508525
80:65:6635869816740560
80:66:1508152231077400
80:67:315136287090800
80:68:60246643120300
80:69:10477677064400
80:70:1646492110120
80:71:231900297200
80:72:28987537150
80:73:3176716400
80:74:300500200
80:75:24040016
80:76:1581580
80:77:82160
80:78:3160
80:79:80
80:80:1

# binomial(81, k) for 0 <= k <= 81

81:0:1
81:1:81
81:2:3240
81:3:85320
81:4:1663740
81:5:25621596
81:6:324540216
81:7:3477216600
81:8:32164253550
81:9:260887834350
81:10:1878392407320
81:11:12124169174520
81:12:70724320184700
81:13:375382930211100
81:14:1823288518168200
81:15:8144022047817960
81:16:33594090947249085
81:17:128447994798305325
81:18:456703981505085600
81:19:1514334254464231200
81:20:4694436188839116720
81:21:13636219405675529520
81:22:37189689288205989600
81:23:95399637739311016800
81:24:230549124536668290600
81:25:525652003943603702568
81:26:1132173546955454128608
81:27:2306279447501851002720
81:28:4447824648753569790960
81:29:8128782978756524100720
81:30:14089890496511308441248
81:31:23180142429744410661408
81:32:36218972546475641658450
81:33:53779686508403225492850
81:34:75924263305981024225200
81:35:101955439296603089673840
81:36:130276394656770614583240
81:37:158444263771748044763400
81:38:183461779104129314989200
81:39:202278371832757962680400
81:40:212392290424395860814420
81:41:212392290424395860814420
81:42:202278371832757962680400
81:43:183461779104129314989200
81:44:158444263771748044763400
81:45:130276394656770614583240
81:46:101955439296603089673840
81:47:75924263305981024225200
81:48:53779686508403225492850
81:49:36218972546475641658450
81:50:23180142429744410661408
81:51:14089890496511308441248
81:52:8128782978756524100720
81:53:4447824648753569790960
81:54:2306279447501851002720
81:55:1132173546955454128608
81:56:525652003943603702568
81:57:230549124536668290600
81:58:95399637739311016800
81:59:37189689288205989600
81:60:13636219405675529520
81:61:4694436188839116720
81:62:1514334254464231200
81:63:456703981505085600
81:64:128447994798305325
81:65:33594090947249085
81:66:8144022047817960
81:67:1823288518168200
81:68:375382930211100
81:69:70724320184700
81:70:12124169174520
81:71:1878392407320
81:72:260887834350
81:73:32164253550
81:74:3477216600
81:75:324540216
81:76:25621596
81:77:1663740
81:78:85320
81:79:3240
81:80:81
81:81:1

# binomial(82, k) for 0 <= k <= 82

82:0:1
82:1:82
82:2:3321
82:3:88560
82:4:1749060
82:5:27285336
82:6:350161812
82:7:3801756816
82:8:35641470150
82:9:293052087900
82:10:2139280241670
82:11:14002561581840
82:12:82848489359220
82:13:446107250395800
82:14:2198671448379300
82:15:9967310565986160
82:16:41738112995067045
82:17:162042085745554410
82:18:585151976303390925
82:19:1971038235969316800
82:20:6208770443303347920
82:21:18330655594514646240
82:22:50825908693881519120
82:23:132589327027517006400
82:24:325948762275979307400
82:25:756201128480271993168
82:26:1657825550899057831176
82:27:3438452994457305131328
82:28:6754104096255420793680
82:29:12576607627510093891680
82:30:22218673475267832541968
82:31:37270032926255719102656
82:32:59399114976220052319858
82:33:89998659054878867151300
82:34:129703949814384249718050
82:35:177879702602584113899040
82:36:232231833953373704257080
82:37:288720658428518659346640
82:38:341906042875877359752600
82:39:385740150936887277669600
82:40:414670662257153823494820
82:41:424784580848791721628840
82:42:414670662257153823494820
82:43:385740150936887277669600
82:44:341906042875877359752600
82:45:288720658428518659346640
82:46:232231833953373704257080
82:47:177879702602584113899040
82:48:129703949814384249718050
82:49:89998659054878867151300
82:50:59399114976220052319858
82:51:37270032926255719102656
82:52:22218673475267832541968
82:53:12576607627510093891680
82:54:6754104096255420793680
82:55:3438452994457305131328
82:56:1657825550899057831176
82:57:756201128480271993168
82:58:325948762275979307400
82:59:132589327027517006400
82:60:50825908693881519120
82:61:18330655594514646240
82:62:6208770443303347920
82:63:1971038235969316800
82:64:585151976303390925
82:65:162042085745554410
82:66:41738112995067045
82:67:9967310565986160
82:68:2198671448379300
82:69:446107250395800
82:70:82848489359220
82:71:14002561581840
82:72:2139280241670
82:73:293052087900
82:74:35641470150
82:75:3801756816
82:76:350161812
82:77:27285336
82:78:1749060
82:79:88560
82:80:3321
82:81:82
82:82:1

# binomial(83, k) for 0 <= k <= 83

83:0:1
83:1:83
83:2:3403
83:3:91881
83:4:1837620
83:5:29034396
83:6:377447148
83:7:4151918628
83:8:39443226966
83:9:328693558050
83:10:2432332329570
83:11:16141841823510
83:12:96851050941060
83:13:528955739755020
83:14:2644778698775100
83:15:12165982014365460
83:16:51705423561053205
83:17:203780198740621455
83:18:747194062048945335
83:19:2556190212272707725
83:20:8179808679272664720
83:21:24539426037817994160
83:22:69156564288396165360
83:23:183415235721398525520
83:24:458538089303496313800
83:25:1082149890756251300568
83:26:2414026679379329824344
83:27:5096278545356362962504
83:28:10192557090712725925008
83:29:19330711723765514685360
83:30:34795281102777926433648
83:31:59488706401523551644624
83:32:96669147902475771422514
83:33:149397774031098919471158
83:34:219702608869263116869350
83:35:307583652416968363617090
83:36:410111536555957818156120
83:37:520952492381892363603720
83:38:630626701304396019099240
83:39:727646193812764637422200
83:40:800410813194041101164420
83:41:839455243105945545123660
83:42:839455243105945545123660
83:43:800410813194041101164420
83:44:727646193812764637422200
83:45:630626701304396019099240
83:46:520952492381892363603720
83:47:410111536555957818156120
83:48:307583652416968363617090
83:49:219702608869263116869350
83:50:149397774031098919471158
83:51:96669147902475771422514
83:52:59488706401523551644624
83:53:34795281102777926433648
83:54:19330711723765514685360
83:55:10192557090712725925008
83:56:5096278545356362962504
83:57:2414026679379329824344
83:58:1082149890756251300568
83:59:458538089303496313800
83:60:183415235721398525520
83:61:69156564288396165360
83:62:24539426037817994160
83:63:8179808679272664720
83:64:2556190212272707725
83:65:747194062048945335
83:66:203780198740621455
83:67:51705423561053205
83:68:12165982014365460
83:69:2644778698775100
83:70:528955739755020
83:71:96851050941060
83:72:16141841823510
83:73:2432332329570
83:74:328693558050
83:75:39443226966
83:76:4151918628
83:77:377447148
83:78:29034396
83:79:1837620
83:80:91881
83:81:3403
83:82:83
83:83:1

# binomial(84, k) for 0 <= k <= 84

84:0:1
84:1:84
84:2:3486
84:3:95284
84:4:1929501
84:5:30872016
84:6:406481544
84:7:4529365776
84:8:43595145594
84:9:368136785016
84:10:2761025887620
84:11:18574174153080
84:12:112992892764570
84:13:625806790696080
84:14:3173734438530120
84:15:14810760713140560
84:16:63871405575418665
84:17:255485622301674660
84:18:950974260789566790
84:19:3303384274321653060
84:20:10735998891545372445
84:21:32719234717090658880
84:22:93695990326214159520
84:23:252571800009794690880
84:24:641953325024894839320
84:25:1540687980059747614368
84:26:3496176570135581124912
84:27:7510305224735692786848
84:28:15288835636069088887512
84:29:29523268814478240610368
84:30:54125992826543441119008
84:31:94283987504301478078272
84:32:156157854303999323067138
84:33:246066921933574690893672
84:34:369100382900362036340508
84:35:527286261286231480486440
84:36:717695188972926181773210
84:37:931064028937850181759840
84:38:1151579193686288382702960
84:39:1358272895117160656521440
84:40:1528057007006805738586620
84:41:1639866056299986646288080
84:42:1678910486211891090247320
84:43:1639866056299986646288080
84:44:1528057007006805738586620
84:45:1358272895117160656521440
84:46:1151579193686288382702960
84:47:931064028937850181759840
84:48:717695188972926181773210
84:49:527286261286231480486440
84:50:369100382900362036340508
84:51:246066921933574690893672
84:52:156157854303999323067138
84:53:94283987504301478078272
84:54:54125992826543441119008
84:55:29523268814478240610368
84:56:15288835636069088887512
84:57:7510305224735692786848
84:58:3496176570135581124912
84:59:1540687980059747614368
84:60:641953325024894839320
84:61:252571800009794690880
84:62:93695990326214159520
84:63:32719234717090658880
84:64:10735998891545372445
84:65:3303384274321653060
84:66:950974260789566790
84:67:255485622301674660
84:68:63871405575418665
84:69:14810760713140560
84:70:3173734438530120
84:71:625806790696080
84:72:112992892764570
84:73:18574174153080
84:74:2761025887620
84:75:368136785016
84:76:43595145594
84:77:4529365776
84:78:406481544
84:79:30872016
84:80:1929501
84:81:95284
84:82:3486
84:83:84
84:84:1

# binomial(85, k) for 0 <= k <= 85

85:0:1
85:1:85
85:2:3570
85:3:98770
85:4:2024785
85:5:32801517
85:6:437353560
85:7:4935847320
85:8:48124511370
85:9:411731930610
85:10:3129162672636
85:11:21335200040700
85:12:131567066917650
85:13:738799683460650
85:14:3799541229226200
85:15:17984495151670680
85:16:78682166288559225
85:17:319357027877093325
85:18:1206459883091241450
85:19:4254358535111219850
85:20:14039383165867025505
85:21:43455233608636031325
85:22:126415225043304818400
85:23:346267790336008850400
85:24:894525125034689530200
85:25:2182641305084642453688
85:26:5036864550195328739280
85:27:11006481794871273911760
85:28:22799140860804781674360
85:29:44812104450547329497880
85:30:83649261641021681729376
85:31:148409980330844919197280
85:32:250441841808300801145410
85:33:402224776237574013960810
85:34:615167304833936727234180
85:35:896386644186593516826948
85:36:1244981450259157662259650
85:37:1648759217910776363533050
85:38:2082643222624138564462800
85:39:2509852088803449039224400
85:40:2886329902123966395108060
85:41:3167923063306792384874700
85:42:3318776542511877736535400
85:43:3318776542511877736535400
85:44:3167923063306792384874700
85:45:2886329902123966395108060
85:46:2509852088803449039224400
85:47:2082643222624138564462800
85:48:1648759217910776363533050
85:49:1244981450259157662259650
85:50:896386644186593516826948
85:51:615167304833936727234180
85:52:402224776237574013960810
85:53:250441841808300801145410
85:54:148409980330844919197280
85:55:83649261641021681729376
85:56:44812104450547329497880
85:57:22799140860804781674360
85:58:11006481794871273911760
85:59:5036864550195328739280
85:60:2182641305084642453688
85:61:894525125034689530200
85:62:346267790336008850400
85:63:126415225043304818400
85:64:43455233608636031325
85:65:14039383165867025505
85:66:4254358535111219850
85:67:1206459883091241450
85:68:319357027877093325
85:69:78682166288559225
85:70:17984495151670680
85:71:3799541229226200
85:72:738799683460650
85:73:131567066917650
85:74:21335200040700
85:75:3129162672636
85:76:411731930610
85:77:48124511370
85:78:4935847320
85:79:437353560
85:80:32801517
85:81:2024785
85:82:98770
85:83:3570
85:84:85
85:85:1

# binomial(86, k) for 0 <= k <= 86

86:0:1
86:1:86
86:2:3655
86:3:102340
86:4:2123555
86:5:34826302
86:6:470155077
86:7:5373200880
86:8:53060358690
86:9:459856441980
86:10:3540894603246
86:11:24464362713336
86:12:152902266958350
86:13:870366750378300
86:14:4538340912686850
86:15:21784036380896880
86:16:96666661440229905
86:17:398039194165652550
86:18:1525816910968334775
86:19:5460818418202461300
86:20:18293741700978245355
86:21:57494616774503056830
86:22:169870458651940849725
86:23:472683015379313668800
86:24:1240792915370698380600
86:25:3077166430119331983888
86:26:7219505855279971192968
86:27:16043346345066602651040
86:28:33805622655676055586120
86:29:67611245311352111172240
86:30:128461366091569011227256
86:31:232059241971866600926656
86:32:398851822139145720342690
86:33:652666618045874815106220
86:34:1017392081071510741194990
86:35:1511553949020530244061128
86:36:2141368094445751179086598
86:37:2893740668169934025792700
86:38:3731402440534914927995850
86:39:4592495311427587603687200
86:40:5396181990927415434332460
86:41:6054252965430758779982760
86:42:6486699605818670121410100
86:43:6637553085023755473070800
86:44:6486699605818670121410100
86:45:6054252965430758779982760
86:46:5396181990927415434332460
86:47:4592495311427587603687200
86:48:3731402440534914927995850
86:49:2893740668169934025792700
86:50:2141368094445751179086598
86:51:1511553949020530244061128
86:52:1017392081071510741194990
86:53:652666618045874815106220
86:54:398851822139145720342690
86:55:232059241971866600926656
86:56:128461366091569011227256
86:57:67611245311352111172240
86:58:33805622655676055586120
86:59:16043346345066602651040
86:60:7219505855279971192968
86:61:3077166430119331983888
86:62:1240792915370698380600
86:63:472683015379313668800
86:64:169870458651940849725
86:65:57494616774503056830
86:66:18293741700978245355
86:67:5460818418202461300
86:68:1525816910968334775
86:69:398039194165652550
86:70:96666661440229905
86:71:21784036380896880
86:72:4538340912686850
86:73:870366750378300
86:74:152902266958350
86:75:24464362713336
86:76:3540894603246
86:77:459856441980
86:78:53060358690
86:79:5373200880
86:80:470155077
86:81:34826302
86:82:2123555
86:83:102340
86:84:3655
86:85:86
86:86:1

# binomial(87, k) for 0 <= k <= 87

87:0:1
87:1:87
87:2:3741
87:3:105995
87:4:2225895
87:5:36949857
87:6:504981379
87:7:5843355957
87:8:58433559570
87:9:512916800670
87:10:4000751045226
87:11:28005257316582
87:12:177366629671686
87:13:1023269017336650
87:14:5408707663065150
87:15:26322377293583730
87:16:118450697821126785
87:17:494705855605882455
87:18:1923856105133987325
87:19:6986635329170796075
87:20:23754560119180706655
87:21:75788358475481302185
87:22:227365075426443906555
87:23:642553474031254518525
87:24:1713475930750012049400
87:25:4317959345490030364488
87:26:10296672285399303176856
87:27:23262852200346573844008
87:28:49848969000742658237160
87:29:101416867967028166758360
87:30:196072611402921122399496
87:31:360520608063435612153912
87:32:630911064111012321269346
87:33:1051518440185020535448910
87:34:1670058699117385556301210
87:35:2528946030092040985256118
87:36:3652922043466281423147726
87:37:5035108762615685204879298
87:38:6625143108704848953788550
87:39:8323897751962502531683050
87:40:9988677302355003038019660
87:41:11450434956358174214315220
87:42:12540952571249428901392860
87:43:13124252690842425594480900
87:44:13124252690842425594480900
87:45:12540952571249428901392860
87:46:11450434956358174214315220
87:47:9988677302355003038019660
87:48:8323897751962502531683050
87:49:6625143108704848953788550
87:50:5035108762615685204879298
87:51:3652922043466281423147726
87:52:2528946030092040985256118
87:53:1670058699117385556301210
87:54:1051518440185020535448910
87:55:630911064111012321269346
87:56:360520608063435612153912
87:57:196072611402921122399496
87:58:101416867967028166758360
87:59:49848969000742658237160
87:60:23262852200346573844008
87:61:10296672285399303176856
87:62:4317959345490030364488
87:63:1713475930750012049400
87:64:642553474031254518525
87:65:227365075426443906555
87:66:75788358475481302185
87:67:23754560119180706655
87:68:6986635329170796075
87:69:1923856105133987325
87:70:494705855605882455
87:71:118450697821126785
87:72:26322377293583730
87:73:5408707663065150
87:74:1023269017336650
87:75:177366629671686
87:76:28005257316582
87:77:4000751045226
87:78:512916800670
87:79:58433559570
87:80:5843355957
87:81:504981379
87:82:36949857
87:83:2225895
87:84:105995
87:85:3741
87:86:87
87:87:1

# binomial(88, k) for 0 <= k <= 88

88:0:1
88:1:88
88:2:3828
88:3:109736
88:4:2331890
88:5:39175752
88:6:541931236
88:7:6348337336
88:8:64276915527
88:9:571350360240
88:10:4513667845896
88:11:32006008361808
88:12:205371886988268
88:13:1200635647008336
88:14:6431976680401800
88:15:31731084956648880
88:16:144773075114710515
88:17:613156553427009240
88:18:2418561960739869780
88:19:8910491434304783400
88:20:30741195448351502730
88:21:99542918594662008840
88:22:303153433901925208740
88:23:869918549457698425080
88:24:2356029404781266567925
88:25:6031435276240042413888
88:26:14614631630889333541344
88:27:33559524485745877020864
88:28:73111821201089232081168
88:29:151265836967770824995520
88:30:297489479369949289157856
88:31:556593219466356734553408
88:32:991431672174447933423258
88:33:1682429504296032856718256
88:34:2721577139302406091750120
88:35:4199004729209426541557328
88:36:6181868073558322408403844
88:37:8688030806081966628027024
88:38:11660251871320534158667848
88:39:14949040860667351485471600
88:40:18312575054317505569702710
88:41:21439112258713177252334880
88:42:23991387527607603115708080
88:43:25665205262091854495873760
88:44:26248505381684851188961800
88:45:25665205262091854495873760
88:46:23991387527607603115708080
88:47:21439112258713177252334880
88:48:18312575054317505569702710
88:49:14949040860667351485471600
88:50:11660251871320534158667848
88:51:8688030806081966628027024
88:52:6181868073558322408403844
88:53:4199004729209426541557328
88:54:2721577139302406091750120
88:55:1682429504296032856718256
88:56:991431672174447933423258
88:57:556593219466356734553408
88:58:297489479369949289157856
88:59:151265836967770824995520
88:60:73111821201089232081168
88:61:33559524485745877020864
88:62:14614631630889333541344
88:63:6031435276240042413888
88:64:2356029404781266567925
88:65:869918549457698425080
88:66:303153433901925208740
88:67:99542918594662008840
88:68:30741195448351502730
88:69:8910491434304783400
88:70:2418561960739869780
88:71:613156553427009240
88:72:144773075114710515
88:73:31731084956648880
88:74:6431976680401800
88:75:1200635647008336
88:76:205371886988268
88:77:32006008361808
88:78:4513667845896
88:79:571350360240
88:80:64276915527
88:81:6348337336
88:82:541931236
88:83:39175752
88:84:2331890
88:85:109736
88:86:3828
88:87:88
88:88:1

# binomial(89, k) for 0 <= k <= 89

89:0:1
89:1:89
89:2:3916
89:3:113564
89:4:2441626
89:5:41507642
89:6:581106988
89:7:6890268572
89:8:70625252863
89:9:635627275767
89:10:5085018206136
89:11:36519676207704
89:12:237377895350076
89:13:1406007533996604
89:14:7632612327410136
89:15:38163061637050680
89:16:176504160071359395
89:17:757929628541719755
89:18:3031718514166879020
89:19:11329053395044653180
89:20:39651686882656286130
89:21:130284114043013511570
89:22:402696352496587217580
89:23:1173071983359623633820
89:24:3225947954238964993005
89:25:8387464681021308981813
89:26:20646066907129375955232
89:27:48174156116635210562208
89:28:106671345686835109102032
89:29:224377658168860057076688
89:30:448755316337720114153376
89:31:854082698836306023711264
89:32:1548024891640804667976666
89:33:2673861176470480790141514
89:34:4404006643598438948468376
89:35:6920581868511832633307448
89:36:10380872802767748949961172
89:37:14869898879640289036430868
89:38:20348282677402500786694872
89:39:26609292731987885644139448
89:40:33261615914984857055174310
89:41:39751687313030682822037590
89:42:45430499786320780368042960
89:43:49656592789699457611581840
89:44:51913710643776705684835560
89:45:51913710643776705684835560
89:46:49656592789699457611581840
89:47:45430499786320780368042960
89:48:39751687313030682822037590
89:49:33261615914984857055174310
89:50:26609292731987885644139448
89:51:20348282677402500786694872
89:52:14869898879640289036430868
89:53:10380872802767748949961172
89:54:6920581868511832633307448
89:55:4404006643598438948468376
89:56:2673861176470480790141514
89:57:1548024891640804667976666
89:58:854082698836306023711264
89:59:448755316337720114153376
89:60:224377658168860057076688
89:61:106671345686835109102032
89:62:48174156116635210562208
89:63:20646066907129375955232
89:64:8387464681021308981813
89:65:3225947954238964993005
89:66:1173071983359623633820
89:67:402696352496587217580
89:68:130284114043013511570
89:69:39651686882656286130
89:70:11329053395044653180
89:71:3031718514166879020
89:72:757929628541719755
89:73:176504160071359395
89:74:38163061637050680
89:75:7632612327410136
89:76:1406007533996604
89:77:237377895350076
89:78:36519676207704
89:79:5085018206136
89:80:635627275767
89:81:70625252863
89:82:6890268572
89:83:581106988
89:84:41507642
89:85:2441626
89:86:113564
89:87:3916
89:88:89
89:89:1

# binomial(90, k) for 0 <= k <= 90

90:0:1
90:1:90
90:2:4005
90:3:117480
90:4:2555190
90:5:43949268
90:6:622614630
90:7:7471375560
90:8:77515521435
90:9:706252528630
90:10:5720645481903
90:11:41604694413840
90:12:273897571557780
90:13:1643385429346680
90:14:9038619861406740
90:15:45795673964460816
90:16:214667221708410075
90:17:934433788613079150
90:18:3789648142708598775
90:19:14360771909211532200
90:20:50980740277700939310
90:21:169935800925669797700
90:22:532980466539600729150
90:23:1575768335856210851400
90:24:4399019937598588626825
90:25:11613412635260273974818
90:26:29033531588150684937045
90:27:68820223023764586517440
90:28:154845501803470319664240
90:29:331049003855695166178720
90:30:673132974506580171230064
90:31:1302838015174026137864640
90:32:2402107590477110691687930
90:33:4221886068111285458118180
90:34:7077867820068919738609890
90:35:11324588512110271581775824
90:36:17301454671279581583268620
90:37:25250771682408037986392040
90:38:35218181557042789823125740
90:39:46957575409390386430834320
90:40:59870908646972742699313758
90:41:73013303228015539877211900
90:42:85182187099351463190080550
90:43:95087092576020237979624800
90:44:101570303433476163296417400
90:45:103827421287553411369671120
90:46:101570303433476163296417400
90:47:95087092576020237979624800
90:48:85182187099351463190080550
90:49:73013303228015539877211900
90:50:59870908646972742699313758
90:51:46957575409390386430834320
90:52:35218181557042789823125740
90:53:25250771682408037986392040
90:54:17301454671279581583268620
90:55:11324588512110271581775824
90:56:7077867820068919738609890
90:57:4221886068111285458118180
90:58:2402107590477110691687930
90:59:1302838015174026137864640
90:60:673132974506580171230064
90:61:331049003855695166178720
90:62:154845501803470319664240
90:63:68820223023764586517440
90:64:29033531588150684937045
90:65:11613412635260273974818
90:66:4399019937598588626825
90:67:1575768335856210851400
90:68:532980466539600729150
90:69:169935800925669797700
90:70:50980740277700939310
90:71:14360771909211532200
90:72:3789648142708598775
90:73:934433788613079150
90:74:214667221708410075
90:75:45795673964460816
90:76:9038619861406740
90:77:1643385429346680
90:78:273897571557780
90:79:41604694413840
90:80:5720645481903
90:81:706252528630
90:82:77515521435
90:83:7471375560
90:84:622614630
90:85:43949268
90:86:2555190
90:87:117480
90:88:4005
90:89:90
90:90:1

# binomial(91, k) for 0 <= k <= 91

91:0:1
91:1:91
91:2:4095
91:3:121485
91:4:2672670
91:5:46504458
91:6:666563898
91:7:8093990190
91:8:84986896995
91:9:783768050065
91:10:6426898010533
91:11:47325339895743
91:12:315502265971620
91:13:1917283000904460
91:14:10682005290753420
91:15:54834293825867556
91:16:260462895672870891
91:17:1149101010321489225
91:18:4724081931321677925
91:19:18150420051920130975
91:20:65341512186912471510
91:21:220916541203370737010
91:22:702916267465270526850
91:23:2108748802395811580550
91:24:5974788273454799478225
91:25:16012432572858862601643
91:26:40646944223410958911863
91:27:97853754611915271454485
91:28:223665724827234906181680
91:29:485894505659165485842960
91:30:1004181978362275337408784
91:31:1975970989680606309094704
91:32:3704945605651136829552570
91:33:6623993658588396149806110
91:34:11299753888180205196728070
91:35:18402456332179191320385714
91:36:28626043183389853165044444
91:37:42552226353687619569660660
91:38:60468953239450827809517780
91:39:82175756966433176253960060
91:40:106828484056363129130148078
91:41:132884211874988282576525658
91:42:158195490327367003067292450
91:43:180269279675371701169705350
91:44:196657396009496401276042200
91:45:205397724721029574666088520
91:46:205397724721029574666088520
91:47:196657396009496401276042200
91:48:180269279675371701169705350
91:49:158195490327367003067292450
91:50:132884211874988282576525658
91:51:106828484056363129130148078
91:52:82175756966433176253960060
91:53:60468953239450827809517780
91:54:42552226353687619569660660
91:55:28626043183389853165044444
91:56:18402456332179191320385714
91:57:11299753888180205196728070
91:58:6623993658588396149806110
91:59:3704945605651136829552570
91:60:1975970989680606309094704
91:61:1004181978362275337408784
91:62:485894505659165485842960
91:63:223665724827234906181680
91:64:97853754611915271454485
91:65:40646944223410958911863
91:66:16012432572858862601643
91:67:5974788273454799478225
91:68:2108748802395811580550
91:69:702916267465270526850
91:70:220916541203370737010
91:71:65341512186912471510
91:72:18150420051920130975
91:73:4724081931321677925
91:74:1149101010321489225
91:75:260462895672870891
91:76:54834293825867556
91:77:10682005290753420
91:78:1917283000904460
91:79:315502265971620
91:80:47325339895743
91:81:6426898010533
91:82:783768050065
91:83:84986896995
91:84:8093990190
91:85:666563898
91:86:46504458
91:87:2672670
91:88:121485
91:89:4095
91:90:91
91:91:1

# binomial(92, k) for 0 <= k <= 92

92:0:1
92:1:92
92:2:4186
92:3:125580
92:4:2794155
92:5:49177128
92:6:713068356
92:7:8760554088
92:8:93080887185
92:9:868754947060
92:10:7210666060598
92:11:53752237906276
92:12:362827605867363
92:13:2232785266876080
92:14:12599288291657880
92:15:65516299116620976
92:16:315297189498738447
92:17:1409563905994360116
92:18:5873182941643167150
92:19:22874501983241808900
92:20:83491932238832602485
92:21:286258053390283208520
92:22:923832808668641263860
92:23:2811665069861082107400
92:24:8083537075850611058775
92:25:21987220846313662079868
92:26:56659376796269821513506
92:27:138500698835326230366348
92:28:321519479439150177636165
92:29:709560230486400392024640
92:30:1490076484021440823251744
92:31:2980152968042881646503488
92:32:5680916595331743138647274
92:33:10328939264239532979358680
92:34:17923747546768601346534180
92:35:29702210220359396517113784
92:36:47028499515569044485430158
92:37:71178269537077472734705104
92:38:103021179593138447379178440
92:39:142644710205884004063477840
92:40:189004241022796305384108138
92:41:239712695931351411706673736
92:42:291079702202355285643818108
92:43:338464770002738704236997800
92:44:376926675684868102445747550
92:45:402055120730525975942130720
92:46:410795449442059149332177040
92:47:402055120730525975942130720
92:48:376926675684868102445747550
92:49:338464770002738704236997800
92:50:291079702202355285643818108
92:51:239712695931351411706673736
92:52:189004241022796305384108138
92:53:142644710205884004063477840
92:54:103021179593138447379178440
92:55:71178269537077472734705104
92:56:47028499515569044485430158
92:57:29702210220359396517113784
92:58:17923747546768601346534180
92:59:10328939264239532979358680
92:60:5680916595331743138647274
92:61:2980152968042881646503488
92:62:1490076484021440823251744
92:63:709560230486400392024640
92:64:321519479439150177636165
92:65:138500698835326230366348
92:66:56659376796269821513506
92:67:21987220846313662079868
92:68:8083537075850611058775
92:69:2811665069861082107400
92:70:923832808668641263860
92:71:286258053390283208520
92:72:83491932238832602485
92:73:22874501983241808900
92:74:5873182941643167150
92:75:1409563905994360116
92:76:315297189498738447
92:77:65516299116620976
92:78:12599288291657880
92:79:2232785266876080
92:80:362827605867363
92:81:53752237906276
92:82:7210666060598
92:83:868754947060
92:84:93080887185
92:85:8760554088
92:86:713068356
92:87:49177128
92:88:2794155
92:89:125580
92:90:4186
92:91:92
92:92:1

# binomial(93, k) for 0 <= k <= 93

93:0:1
93:1:93
93:2:4278
93:3:129766
93:4:2919735
93:5:51971283
93:6:762245484
93:7:9473622444
93:8:101841441273
93:9:961835834245
93:10:8079421007658
93:11:60962903966874
93:12:416579843773639
93:13:2595612872743443
93:14:14832073558533960
93:15:78115587408278856
93:16:380813488615359423
93:17:1724861095493098563
93:18:7282746847637527266
93:19:28747684924884976050
93:20:106366434222074411385
93:21:369749985629115811005
93:22:1210090862058924472380
93:23:3735497878529723371260
93:24:10895202145711693166175
93:25:30070757922164273138643
93:26:78646597642583483593374
93:27:195160075631596051879854
93:28:460020178274476408002513
93:29:1031079709925550569660805
93:30:2199636714507841215276384
93:31:4470229452064322469755232
93:32:8661069563374624785150762
93:33:16009855859571276118005954
93:34:28252686811008134325892860
93:35:47625957767127997863647964
93:36:76730709735928441002543942
93:37:118206769052646517220135262
93:38:174199449130215920113883544
93:39:245665889799022451442656280
93:40:331648951228680309447585978
93:41:428716936954147717090781874
93:42:530792398133706697350491844
93:43:629544472205093989880815908
93:44:715391445687606806682745350
93:45:778981796415394078387878270
93:46:812850570172585125274307760
93:47:812850570172585125274307760
93:48:778981796415394078387878270
93:49:715391445687606806682745350
93:50:629544472205093989880815908
93:51:530792398133706697350491844
93:52:428716936954147717090781874
93:53:331648951228680309447585978
93:54:245665889799022451442656280
93:55:174199449130215920113883544
93:56:118206769052646517220135262
93:57:76730709735928441002543942
93:58:47625957767127997863647964
93:59:28252686811008134325892860
93:60:16009855859571276118005954
93:61:8661069563374624785150762
93:62:4470229452064322469755232
93:63:2199636714507841215276384
93:64:1031079709925550569660805
93:65:460020178274476408002513
93:66:195160075631596051879854
93:67:78646597642583483593374
93:68:30070757922164273138643
93:69:10895202145711693166175
93:70:3735497878529723371260
93:71:1210090862058924472380
93:72:369749985629115811005
93:73:106366434222074411385
93:74:28747684924884976050
93:75:7282746847637527266
93:76:1724861095493098563
93:77:380813488615359423
93:78:78115587408278856
93:79:14832073558533960
93:80:2595612872743443
93:81:416579843773639
93:82:60962903966874
93:83:8079421007658
93:84:961835834245
93:85:101841441273
93:86:9473622444
93:87:762245484
93:88:51971283
93:89:2919735
93:90:129766
93:91:4278
93:92:93
93:93:1

# binomial(94, k) for 0 <= k <= 94

94:0:1
94:1:94
94:2:4371
94:3:134044
94:4:3049501
94:5:54891018
94:6:814216767
94:7:10235867928
94:8:111315063717
94:9:1063677275518
94:10:9041256841903
94:11:69042324974532
94:12:477542747740513
94:13:3012192716517082
94:14:17427686431277403
94:15:92947660966812816
94:16:458929076023638279
94:17:2105674584108457986
94:18:9007607943130625829
94:19:36030431772522503316
94:20:135114119146959387435
94:21:476116419851190222390
94:22:1579840847688040283385
94:23:4945588740588647843640
94:24:14630700024241416537435
94:25:40965960067875966304818
94:26:108717355564747756732017
94:27:273806673274179535473228
94:28:655180253906072459882367
94:29:1491099888200026977663318
94:30:3230716424433391784937189
94:31:6669866166572163685031616
94:32:13131299015438947254905994
94:33:24670925422945900903156716
94:34:44262542670579410443898814
94:35:75878644578136132189540824
94:36:124356667503056438866191906
94:37:194937478788574958222679204
94:38:292406218182862437334018806
94:39:419865338929238371556539824
94:40:577314841027702760890242258
94:41:760365888182828026538367852
94:42:959509335087854414441273718
94:43:1160336870338800687231307752
94:44:1344935917892700796563561258
94:45:1494373242103000885070623620
94:46:1591832366587979203662186030
94:47:1625701140345170250548615520
94:48:1591832366587979203662186030
94:49:1494373242103000885070623620
94:50:1344935917892700796563561258
94:51:1160336870338800687231307752
94:52:959509335087854414441273718
94:53:760365888182828026538367852
94:54:577314841027702760890242258
94:55:419865338929238371556539824
94:56:292406218182862437334018806
94:57:194937478788574958222679204
94:58:124356667503056438866191906
94:59:75878644578136132189540824
94:60:44262542670579410443898814
94:61:24670925422945900903156716
94:62:13131299015438947254905994
94:63:6669866166572163685031616
94:64:3230716424433391784937189
94:65:1491099888200026977663318
94:66:655180253906072459882367
94:67:273806673274179535473228
94:68:108717355564747756732017
94:69:40965960067875966304818
94:70:14630700024241416537435
94:71:4945588740588647843640
94:72:1579840847688040283385
94:73:476116419851190222390
94:74:135114119146959387435
94:75:36030431772522503316
94:76:9007607943130625829
94:77:2105674584108457986
94:78:458929076023638279
94:79:92947660966812816
94:80:17427686431277403
94:81:3012192716517082
94:82:477542747740513
94:83:69042324974532
94:84:9041256841903
94:85:1063677275518
94:86:111315063717
94:87:10235867928
94:88:814216767
94:89:54891018
94:90:3049501
94:91:134044
94:92:4371
94:93:94
94:94:1

# binomial(95, k) for 0 <= k <= 95

95:0:1
95:1:95
95:2:4465
95:3:138415
95:4:3183545
95:5:57940519
95:6:869107785
95:7:11050084695
95:8:121550931645
95:9:1174992339235
95:10:10104934117421
95:11:78083581816435
95:12:546585072715045
95:13:3489735464257595
95:14:20439879147794485
95:15:110375347398090219
95:16:551876736990451095
95:17:2564603660132096265
95:18:11113282527239083815
95:19:45038039715653129145
95:20:171144550919481890751
95:21:611230538998149609825
95:22:2055957267539230505775
95:23:6525429588276688127025
95:24:19576288764830064381075
95:25:55596660092117382842253
95:26:149683315632623723036835
95:27:382524028838927292205245
95:28:928986927180251995355595
95:29:2146280142106099437545685
95:30:4721816312633418762600507
95:31:9900582591005555469968805
95:32:19801165182011110939937610
95:33:37802224438384848158062710
95:34:68933468093525311347055530
95:35:120141187248715542633439638
95:36:200235312081192571055732730
95:37:319294146291631397088871110
95:38:487343696971437395556698010
95:39:712271557112100808890558630
95:40:997180179956941132446782082
95:41:1337680729210530787428610110
95:42:1719875223270682440979641570
95:43:2119846205426655101672581470
95:44:2505272788231501483794869010
95:45:2839309159995701681634184878
95:46:3086205608690980088732809650
95:47:3217533506933149454210801550
95:48:3217533506933149454210801550
95:49:3086205608690980088732809650
95:50:2839309159995701681634184878
95:51:2505272788231501483794869010
95:52:2119846205426655101672581470
95:53:1719875223270682440979641570
95:54:1337680729210530787428610110
95:55:997180179956941132446782082
95:56:712271557112100808890558630
95:57:487343696971437395556698010
95:58:319294146291631397088871110
95:59:200235312081192571055732730
95:60:120141187248715542633439638
95:61:68933468093525311347055530
95:62:37802224438384848158062710
95:63:19801165182011110939937610
95:64:9900582591005555469968805
95:65:4721816312633418762600507
95:66:2146280142106099437545685
95:67:928986927180251995355595
95:68:382524028838927292205245
95:69:149683315632623723036835
95:70:55596660092117382842253
95:71:19576288764830064381075
95:72:6525429588276688127025
95:73:2055957267539230505775
95:74:611230538998149609825
95:75:171144550919481890751
95:76:45038039715653129145
95:77:11113282527239083815
95:78:2564603660132096265
95:79:551876736990451095
95:80:110375347398090219
95:81:20439879147794485
95:82:3489735464257595
95:83:546585072715045
95:84:78083581816435
95:85:10104934117421
95:86:1174992339235
95:87:121550931645
95:88:11050084695
95:89:869107785
95:90:57940519
95:91:3183545
95:92:138415
95:93:4465
95:94:95
95:95:1

# binomial(96, k) for 0 <= k <= 96

96:0:1
96:1:96
96:2:4560
96:3:142880
96:4:3321960
96:5:61124064
96:6:927048304
96:7:11919192480
96:8:132601016340
96:9:1296543270880
96:10:11279926456656
96:11:88188515933856
96:12:624668654531480
96:13:4036320536972640
96:14:23929614612052080
96:15:130815226545884704
96:16:662252084388541314
96:17:3116480397122547360
96:18:13677886187371180080
96:19:56151322242892212960
96:20:216182590635135019896
96:21:782375089917631500576
96:22:2667187806537380115600
96:23:8581386855815918632800
96:24:26101718353106752508100
96:25:75172948856947447223328
96:26:205279975724741105879088
96:27:532207344471551015242080
96:28:1311510956019179287560840
96:29:3075267069286351432901280
96:30:6868096454739518200146192
96:31:14622398903638974232569312
96:32:29701747773016666409906415
96:33:57603389620395959098000320
96:34:106735692531910159505118240
96:35:189074655342240853980495168
96:36:320376499329908113689172368
96:37:519529458372823968144603840
96:38:806637843263068792645569120
96:39:1199615254083538204447256640
96:40:1709451737069041941337340712
96:41:2334860909167471919875392192
96:42:3057555952481213228408251680
96:43:3839721428697337542652223040
96:44:4625118993658156585467450480
96:45:5344581948227203165429053888
96:46:5925514768686681770366994528
96:47:6303739115624129542943611200
96:48:6435067013866298908421603100
96:49:6303739115624129542943611200
96:50:5925514768686681770366994528
96:51:5344581948227203165429053888
96:52:4625118993658156585467450480
96:53:3839721428697337542652223040
96:54:3057555952481213228408251680
96:55:2334860909167471919875392192
96:56:1709451737069041941337340712
96:57:1199615254083538204447256640
96:58:806637843263068792645569120
96:59:519529458372823968144603840
96:60:320376499329908113689172368
96:61:189074655342240853980495168
96:62:106735692531910159505118240
96:63:57603389620395959098000320
96:64:29701747773016666409906415
96:65:14622398903638974232569312
96:66:6868096454739518200146192
96:67:3075267069286351432901280
96:68:1311510956019179287560840
96:69:532207344471551015242080
96:70:205279975724741105879088
96:71:75172948856947447223328
96:72:26101718353106752508100
96:73:8581386855815918632800
96:74:2667187806537380115600
96:75:782375089917631500576
96:76:216182590635135019896
96:77:56151322242892212960
96:78:13677886187371180080
96:79:3116480397122547360
96:80:662252084388541314
96:81:130815226545884704
96:82:23929614612052080
96:83:4036320536972640
96:84:624668654531480
96:85:88188515933856
96:86:11279926456656
96:87:1296543270880
96:88:132601016340
96:89:11919192480
96:90:927048304
96:91:61124064
96:92:3321960
96:93:142880
96:94:4560
96:95:96
96:96:1

# binomial(97, k) for 0 <= k <= 97

97:0:1
97:1:97
97:2:4656
97:3:147440
97:4:3464840
97:5:64446024
97:6:988172368
97:7:12846240784
97:8:144520208820
97:9:1429144287220
97:10:12576469727536
97:11:99468442390512
97:12:712857170465336
97:13:4660989191504120
97:14:27965935149024720
97:15:154744841157936784
97:16:793067310934426018
97:17:3778732481511088674
97:18:16794366584493727440
97:19:69829208430263393040
97:20:272333912878027232856
97:21:998557680552766520472
97:22:3449562896455011616176
97:23:11248574662353298748400
97:24:34683105208922671140900
97:25:101274667210054199731428
97:26:280452924581688553102416
97:27:737487320196292121121168
97:28:1843718300490730302802920
97:29:4386778025305530720462120
97:30:9943363524025869633047472
97:31:21490495358378492432715504
97:32:44324146676655640642475727
97:33:87305137393412625507906735
97:34:164339082152306118603118560
97:35:295810347874151013485613408
97:36:509451154672148967669667536
97:37:839905957702732081833776208
97:38:1326167301635892760790172960
97:39:2006253097346606997092825760
97:40:2909066991152580145784597352
97:41:4044312646236513861212732904
97:42:5392416861648685148283643872
97:43:6897277381178550771060474720
97:44:8464840422355494128119673520
97:45:9969700941885359750896504368
97:46:11270096716913884935796048416
97:47:12229253884310811313310605728
97:48:12738806129490428451365214300
97:49:12738806129490428451365214300
97:50:12229253884310811313310605728
97:51:11270096716913884935796048416
97:52:9969700941885359750896504368
97:53:8464840422355494128119673520
97:54:6897277381178550771060474720
97:55:5392416861648685148283643872
97:56:4044312646236513861212732904
97:57:2909066991152580145784597352
97:58:2006253097346606997092825760
97:59:1326167301635892760790172960
97:60:839905957702732081833776208
97:61:509451154672148967669667536
97:62:295810347874151013485613408
97:63:164339082152306118603118560
97:64:87305137393412625507906735
97:65:44324146676655640642475727
97:66:21490495358378492432715504
97:67:9943363524025869633047472
97:68:4386778025305530720462120
97:69:1843718300490730302802920
97:70:737487320196292121121168
97:71:280452924581688553102416
97:72:101274667210054199731428
97:73:34683105208922671140900
97:74:11248574662353298748400
97:75:3449562896455011616176
97:76:998557680552766520472
97:77:272333912878027232856
97:78:69829208430263393040
97:79:16794366584493727440
97:80:3778732481511088674
97:81:793067310934426018
97:82:154744841157936784
97:83:27965935149024720
97:84:4660989191504120
97:85:712857170465336
97:86:99468442390512
97:87:12576469727536
97:88:1429144287220
97:89:144520208820
97:90:12846240784
97:91:988172368
97:92:64446024
97:93:3464840
97:94:147440
97:95:4656
97:96:97
97:97:1

# binomial(98, k) for 0 <= k <= 98

98:0:1
98:1:98
98:2:4753
98:3:152096
98:4:3612280
98:5:67910864
98:6:1052618392
98:7:13834413152
98:8:157366449604
98:9:1573664496040
98:10:14005614014756
98:11:112044912118048
98:12:812325612855848
98:13:5373846361969456
98:14:32626924340528840
98:15:182710776306961504
98:16:947812152092362802
98:17:4571799792445514692
98:18:20573099066004816114
98:19:86623575014757120480
98:20:342163121308290625896
98:21:1270891593430793753328
98:22:4448120577007778136648
98:23:14698137558808310364576
98:24:45931679871275969889300
98:25:135957772418976870872328
98:26:381727591791742752833844
98:27:1017940244777980674223584
98:28:2581205620687022423924088
98:29:6230496325796261023265040
98:30:14330141549331400353509592
98:31:31433858882404362065762976
98:32:65814642035034133075191231
98:33:131629284070068266150382462
98:34:251644219545718744111025295
98:35:460149430026457132088731968
98:36:805261502546299981155280944
98:37:1349357112374881049503443744
98:38:2166073259338624842623949168
98:39:3332420398982499757882998720
98:40:4915320088499187142877423112
98:41:6953379637389094006997330256
98:42:9436729507885199009496376776
98:43:12289694242827235919344118592
98:44:15362117803534044899180148240
98:45:18434541364240853879016177888
98:46:21239797658799244686692552784
98:47:23499350601224696249106654144
98:48:24968060013801239764675820028
98:49:25477612258980856902730428600
98:50:24968060013801239764675820028
98:51:23499350601224696249106654144
98:52:21239797658799244686692552784
98:53:18434541364240853879016177888
98:54:15362117803534044899180148240
98:55:12289694242827235919344118592
98:56:9436729507885199009496376776
98:57:6953379637389094006997330256
98:58:4915320088499187142877423112
98:59:3332420398982499757882998720
98:60:2166073259338624842623949168
98:61:1349357112374881049503443744
98:62:805261502546299981155280944
98:63:460149430026457132088731968
98:64:251644219545718744111025295
98:65:131629284070068266150382462
98:66:65814642035034133075191231
98:67:31433858882404362065762976
98:68:14330141549331400353509592
98:69:6230496325796261023265040
98:70:2581205620687022423924088
98:71:1017940244777980674223584
98:72:381727591791742752833844
98:73:135957772418976870872328
98:74:45931679871275969889300
98:75:14698137558808310364576
98:76:4448120577007778136648
98:77:1270891593430793753328
98:78:342163121308290625896
98:79:86623575014757120480
98:80:20573099066004816114
98:81:4571799792445514692
98:82:947812152092362802
98:83:182710776306961504
98:84:32626924340528840
98:85:5373846361969456
98:86:812325612855848
98:87:112044912118048
98:88:14005614014756
98:89:1573664496040
98:90:157366449604
98:91:13834413152
98:92:1052618392
98:93:67910864
98:94:3612280
98:95:152096
98:96:4753
98:97:98
98:98:1

# binomial(99, k) for 0 <= k <= 99

99:0:1
99:1:99
99:2:4851
99:3:156849
99:4:3764376
99:5:71523144
99:6:1120529256
99:7:14887031544
99:8:171200862756
99:9:1731030945644
99:10:15579278510796
99:11:126050526132804
99:12:924370524973896
99:13:6186171974825304
99:14:38000770702498296
99:15:215337700647490344
99:16:1130522928399324306
99:17:5519611944537877494
99:18:25144898858450330806
99:19:107196674080761936594
99:20:428786696323047746376
99:21:1613054714739084379224
99:22:5719012170438571889976
99:23:19146258135816088501224
99:24:60629817430084280253876
99:25:181889452290252840761628
99:26:517685364210719623706172
99:27:1399667836569723427057428
99:28:3599145865465003098147672
99:29:8811701946483283447189128
99:30:20560637875127661376774632
99:31:45764000431735762419272568
99:32:97248500917438495140954207
99:33:197443926105102399225573693
99:34:383273503615787010261407757
99:35:711793649572175876199757263
99:36:1265410932572757113244012912
99:37:2154618614921181030658724688
99:38:3515430371713505892127392912
99:39:5498493658321124600506947888
99:40:8247740487481686900760421832
99:41:11868699725888281149874753368
99:42:16390109145274293016493707032
99:43:21726423750712434928840495368
99:44:27651812046361280818524266832
99:45:33796659167774898778196326128
99:46:39674339023040098565708730672
99:47:44739148260023940935799206928
99:48:48467410615025936013782474172
99:49:50445672272782096667406248628
99:50:50445672272782096667406248628
99:51:48467410615025936013782474172
99:52:44739148260023940935799206928
99:53:39674339023040098565708730672
99:54:33796659167774898778196326128
99:55:27651812046361280818524266832
99:56:21726423750712434928840495368
99:57:16390109145274293016493707032
99:58:11868699725888281149874753368
99:59:8247740487481686900760421832
99:60:5498493658321124600506947888
99:61:3515430371713505892127392912
99:62:2154618614921181030658724688
99:63:1265410932572757113244012912
99:64:711793649572175876199757263
99:65:383273503615787010261407757
99:66:197443926105102399225573693
99:67:97248500917438495140954207
99:68:45764000431735762419272568
99:69:20560637875127661376774632
99:70:8811701946483283447189128
99:71:3599145865465003098147672
99:72:1399667836569723427057428
99:73:517685364210719623706172
99:74:181889452290252840761628
99:75:60629817430084280253876
99:76:19146258135816088501224
99:77:5719012170438571889976
99:78:1613054714739084379224
99:79:428786696323047746376
99:80:107196674080761936594
99:81:25144898858450330806
99:82:5519611944537877494
99:83:1130522928399324306
99:84:215337700647490344
99:85:38000770702498296
99:86:6186171974825304
99:87:924370524973896
99:88:126050526132804
99:89:15579278510796
99:90:1731030945644
99:91:171200862756
99:92:14887031544
99:93:1120529256
99:94:71523144
99:95:3764376
99:96:156849
99:97:4851
99:98:99
99:99:1

# binomial(100, k) for 0 <= k <= 100

100:0:1
100:1:100
100:2:4950
100:3:161700
100:4:3921225
100:5:75287520
100:6:1192052400
100:7:16007560800
100:8:186087894300
100:9:1902231808400
100:10:17310309456440
100:11:141629804643600
100:12:1050421051106700
100:13:7110542499799200
100:14:44186942677323600
100:15:253338471349988640
100:16:1345860629046814650
100:17:6650134872937201800
100:18:30664510802988208300
100:19:132341572939212267400
100:20:535983370403809682970
100:21:2041841411062132125600
100:22:7332066885177656269200
100:23:24865270306254660391200
100:24:79776075565900368755100
100:25:242519269720337121015504
100:26:699574816500972464467800
100:27:1917353200780443050763600
100:28:4998813702034726525205100
100:29:12410847811948286545336800
100:30:29372339821610944823963760
100:31:66324638306863423796047200
100:32:143012501349174257560226775
100:33:294692427022540894366527900
100:34:580717429720889409486981450
100:35:1095067153187962886461165020
100:36:1977204582144932989443770175
100:37:3420029547493938143902737600
100:38:5670048986634686922786117600
100:39:9013924030034630492634340800
100:40:13746234145802811501267369720
100:41:20116440213369968050635175200
100:42:28258808871162574166368460400
100:43:38116532895986727945334202400
100:44:49378235797073715747364762200
100:45:61448471214136179596720592960
100:46:73470998190814997343905056800
100:47:84413487283064039501507937600
100:48:93206558875049876949581681100
100:49:98913082887808032681188722800
100:50:100891344545564193334812497256
100:51:98913082887808032681188722800
100:52:93206558875049876949581681100
100:53:84413487283064039501507937600
100:54:73470998190814997343905056800
100:55:61448471214136179596720592960
100:56:49378235797073715747364762200
100:57:38116532895986727945334202400
100:58:28258808871162574166368460400
100:59:20116440213369968050635175200
100:60:13746234145802811501267369720
100:61:9013924030034630492634340800
100:62:5670048986634686922786117600
100:63:3420029547493938143902737600
100:64:1977204582144932989443770175
100:65:1095067153187962886461165020
100:66:580717429720889409486981450
100:67:294692427022540894366527900
100:68:143012501349174257560226775
100:69:66324638306863423796047200
100:70:29372339821610944823963760
100:71:12410847811948286545336800
100:72:4998813702034726525205100
100:73:1917353200780443050763600
100:74:699574816500972464467800
100:75:242519269720337121015504
100:76:79776075565900368755100
100:77:24865270306254660391200
100:78:7332066885177656269200
100:79:2041841411062132125600
100:80:535983370403809682970
100:81:132341572939212267400
100:82:30664510802988208300
100:83:6650134872937201800
100:84:1345860629046814650
100:85:253338471349988640
100:86:44186942677323600
100:87:7110542499799200
100:88:1050421051106700
100:89:141629804643600
100:90:17310309456440
100:91:1902231808400
100:92:186087894300
100:93:16007560800
100:94:1192052400
100:95:75287520
100:96:3921225
100:97:161700
100:98:4950
100:99:100
100:100:1

# binomial(101, k) for 0 <= k <= 101

101:0:1
101:1:101
101:2:5050
101:3:166650
101:4:4082925
101:5:79208745
101:6:1267339920
101:7:17199613200
101:8:202095455100
101:9:2088319702700
101:10:19212541264840
101:11:158940114100040
101:12:1192050855750300
101:13:8160963550905900
101:14:51297485177122800
101:15:297525414027312240
101:16:1599199100396803290
101:17:7995995501984016450
101:18:37314645675925410100
101:19:163006083742200475700
101:20:668324943343021950370
101:21:2577824781465941808570
101:22:9373908296239788394800
101:23:32197337191432316660400
101:24:104641345872155029146300
101:25:322295345286237489770604
101:26:942094086221309585483304
101:27:2616928017281415515231400
101:28:6916166902815169575968700
101:29:17409661513983013070541900
101:30:41783187633559231369300560
101:31:95696978128474368620010960
101:32:209337139656037681356273975
101:33:437704928371715151926754675
101:34:875409856743430303853509350
101:35:1675784582908852295948146470
101:36:3072271735332895875904935195
101:37:5397234129638871133346507775
101:38:9090078534128625066688855200
101:39:14683973016669317415420458400
101:40:22760158175837441993901710520
101:41:33862674359172779551902544920
101:42:48375249084532542217003635600
101:43:66375341767149302111702662800
101:44:87494768693060443692698964600
101:45:110826707011209895344085355160
101:46:134919469404951176940625649760
101:47:157884485473879036845412994400
101:48:177620046158113916451089618700
101:49:192119641762857909630770403900
101:50:199804427433372226016001220056
101:51:199804427433372226016001220056
101:52:192119641762857909630770403900
101:53:177620046158113916451089618700
101:54:157884485473879036845412994400
101:55:134919469404951176940625649760
101:56:110826707011209895344085355160
101:57:87494768693060443692698964600
101:58:66375341767149302111702662800
101:59:48375249084532542217003635600
101:60:33862674359172779551902544920
101:61:22760158175837441993901710520
101:62:14683973016669317415420458400
101:63:9090078534128625066688855200
101:64:5397234129638871133346507775
101:65:3072271735332895875904935195
101:66:1675784582908852295948146470
101:67:875409856743430303853509350
101:68:437704928371715151926754675
101:69:209337139656037681356273975
101:70:95696978128474368620010960
101:71:41783187633559231369300560
101:72:17409661513983013070541900
101:73:6916166902815169575968700
101:74:2616928017281415515231400
101:75:942094086221309585483304
101:76:322295345286237489770604
101:77:104641345872155029146300
101:78:32197337191432316660400
101:79:9373908296239788394800
101:80:2577824781465941808570
101:81:668324943343021950370
101:82:163006083742200475700
101:83:37314645675925410100
101:84:7995995501984016450
101:85:1599199100396803290
101:86:297525414027312240
101:87:51297485177122800
101:88:8160963550905900
101:89:1192050855750300
101:90:158940114100040
101:91:19212541264840
101:92:2088319702700
101:93:202095455100
101:94:17199613200
101:95:1267339920
101:96:79208745
101:97:4082925
101:98:166650
101:99:5050
101:100:101
101:101:1

# binomial(102, k) for 0 <= k <= 102

102:0:1
102:1:102
102:2:5151
102:3:171700
102:4:4249575
102:5:83291670
102:6:1346548665
102:7:18466953120
102:8:219295068300
102:9:2290415157800
102:10:21300860967540
102:11:178152655364880
102:12:1350990969850340
102:13:9353014406656200
102:14:59458448728028700
102:15:348822899204435040
102:16:1896724514424115530
102:17:9595194602380819740
102:18:45310641177909426550
102:19:200320729418125885800
102:20:831331027085222426070
102:21:3246149724808963758940
102:22:11951733077705730203370
102:23:41571245487672105055200
102:24:136838683063587345806700
102:25:426936691158392518916904
102:26:1264389431507547075253908
102:27:3559022103502725100714704
102:28:9533094920096585091200100
102:29:24325828416798182646510600
102:30:59192849147542244439842460
102:31:137480165762033599989311520
102:32:305034117784512049976284935
102:33:647042068027752833283028650
102:34:1313114785115145455780264025
102:35:2551194439652282599801655820
102:36:4748056318241748171853081665
102:37:8469505864971767009251442970
102:38:14487312663767496200035362975
102:39:23774051550797942482109313600
102:40:37444131192506759409322168920
102:41:56622832535010221545804255440
102:42:82237923443705321768906180520
102:43:114750590851681844328706298400
102:44:153870110460209745804401627400
102:45:198321475704270339036784319760
102:46:245746176416161072284711004920
102:47:292803954878830213786038644160
102:48:335504531631992953296502613100
102:49:369739687920971826081860022600
102:50:391924069196230135646771623956
102:51:399608854866744452032002440112
102:52:391924069196230135646771623956
102:53:369739687920971826081860022600
102:54:335504531631992953296502613100
102:55:292803954878830213786038644160
102:56:245746176416161072284711004920
102:57:198321475704270339036784319760
102:58:153870110460209745804401627400
102:59:114750590851681844328706298400
102:60:82237923443705321768906180520
102:61:56622832535010221545804255440
102:62:37444131192506759409322168920
102:63:23774051550797942482109313600
102:64:14487312663767496200035362975
102:65:8469505864971767009251442970
102:66:4748056318241748171853081665
102:67:2551194439652282599801655820
102:68:1313114785115145455780264025
102:69:647042068027752833283028650
102:70:305034117784512049976284935
102:71:137480165762033599989311520
102:72:59192849147542244439842460
102:73:24325828416798182646510600
102:74:9533094920096585091200100
102:75:3559022103502725100714704
102:76:1264389431507547075253908
102:77:426936691158392518916904
102:78:136838683063587345806700
102:79:41571245487672105055200
102:80:11951733077705730203370
102:81:3246149724808963758940
102:82:831331027085222426070
102:83:200320729418125885800
102:84:45310641177909426550
102:85:9595194602380819740
102:86:1896724514424115530
102:87:348822899204435040
102:88:59458448728028700
102:89:9353014406656200
102:90:1350990969850340
102:91:178152655364880
102:92:21300860967540
102:93:2290415157800
102:94:219295068300
102:95:18466953120
102:96:1346548665
102:97:83291670
102:98:4249575
102:99:171700
102:100:5151
102:101:102
102:102:1

# binomial(103, k) for 0 <= k <= 103

103:0:1
103:1:103
103:2:5253
103:3:176851
103:4:4421275
103:5:87541245
103:6:1429840335
103:7:19813501785
103:8:237762021420
103:9:2509710226100
103:10:23591276125340
103:11:199453516332420
103:12:1529143625215220
103:13:10704005376506540
103:14:68811463134684900
103:15:408281347932463740
103:16:2245547413628550570
103:17:11491919116804935270
103:18:54905835780290246290
103:19:245631370596035312350
103:20:1031651756503348311870
103:21:4077480751894186185010
103:22:15197882802514693962310
103:23:53522978565377835258570
103:24:178409928551259450861900
103:25:563775374221979864723604
103:26:1691326122665939594170812
103:27:4823411535010272175968612
103:28:13092117023599310191914804
103:29:33858923336894767737710700
103:30:83518677564340427086353060
103:31:196673014909575844429153980
103:32:442514283546545649965596455
103:33:952076185812264883259313585
103:34:1960156853142898289063292675
103:35:3864309224767428055581919845
103:36:7299250757894030771654737485
103:37:13217562183213515181104524635
103:38:22956818528739263209286805945
103:39:38261364214565438682144676575
103:40:61218182743304701891431482520
103:41:94066963727516980955126424360
103:42:138860755978715543314710435960
103:43:196988514295387166097612478920
103:44:268620701311891590133107925800
103:45:352191586164480084841185947160
103:46:444067652120431411321495324680
103:47:538550131294991286070749649080
103:48:628308486510823167082541257260
103:49:705244219552964779378362635700
103:50:761663757117201961728631646556
103:51:791532924062974587678774064068
103:52:791532924062974587678774064068
103:53:761663757117201961728631646556
103:54:705244219552964779378362635700
103:55:628308486510823167082541257260
103:56:538550131294991286070749649080
103:57:444067652120431411321495324680
103:58:352191586164480084841185947160
103:59:268620701311891590133107925800
103:60:196988514295387166097612478920
103:61:138860755978715543314710435960
103:62:94066963727516980955126424360
103:63:61218182743304701891431482520
103:64:38261364214565438682144676575
103:65:22956818528739263209286805945
103:66:13217562183213515181104524635
103:67:7299250757894030771654737485
103:68:3864309224767428055581919845
103:69:1960156853142898289063292675
103:70:952076185812264883259313585
103:71:442514283546545649965596455
103:72:196673014909575844429153980
103:73:83518677564340427086353060
103:74:33858923336894767737710700
103:75:13092117023599310191914804
103:76:4823411535010272175968612
103:77:1691326122665939594170812
103:78:563775374221979864723604
103:79:178409928551259450861900
103:80:53522978565377835258570
103:81:15197882802514693962310
103:82:4077480751894186185010
103:83:1031651756503348311870
103:84:245631370596035312350
103:85:54905835780290246290
103:86:11491919116804935270
103:87:2245547413628550570
103:88:408281347932463740
103:89:68811463134684900
103:90:10704005376506540
103:91:1529143625215220
103:92:199453516332420
103:93:23591276125340
103:94:2509710226100
103:95:237762021420
103:96:19813501785
103:97:1429840335
103:98:87541245
103:99:4421275
103:100:176851
103:101:5253
103:102:103
103:103:1

# binomial(104, k) for 0 <= k <= 104

104:0:1
104:1:104
104:2:5356
104:3:182104
104:4:4598126
104:5:91962520
104:6:1517381580
104:7:21243342120
104:8:257575523205
104:9:2747472247520
104:10:26100986351440
104:11:223044792457760
104:12:1728597141547640
104:13:12233149001721760
104:14:79515468511191440
104:15:477092811067148640
104:16:2653828761561014310
104:17:13737466530433485840
104:18:66397754897095181560
104:19:300537206376325558640
104:20:1277283127099383624220
104:21:5109132508397534496880
104:22:19275363554408880147320
104:23:68720861367892529220880
104:24:231932907116637286120470
104:25:742185302773239315585504
104:26:2255101496887919458894416
104:27:6514737657676211770139424
104:28:17915528558609582367883416
104:29:46951040360494077929625504
104:30:117377600901235194824063760
104:31:280191692473916271515507040
104:32:639187298456121494394750435
104:33:1394590469358810533224910040
104:34:2912233038955163172322606260
104:35:5824466077910326344645212520
104:36:11163559982661458827236657330
104:37:20516812941107545952759262120
104:38:36174380711952778390391330580
104:39:61218182743304701891431482520
104:40:99479546957870140573576159095
104:41:155285146470821682846557906880
104:42:232927719706232524269836860320
104:43:335849270274102709412322914880
104:44:465609215607278756230720404720
104:45:620812287476371674974293872960
104:46:796259238284911496162681271840
104:47:982617783415422697392244973760
104:48:1166858617805814453153290906340
104:49:1333552706063787946460903892960
104:50:1466907976670166741106994282256
104:51:1553196681180176549407405710624
104:52:1583065848125949175357548128136
104:53:1553196681180176549407405710624
104:54:1466907976670166741106994282256
104:55:1333552706063787946460903892960
104:56:1166858617805814453153290906340
104:57:982617783415422697392244973760
104:58:796259238284911496162681271840
104:59:620812287476371674974293872960
104:60:465609215607278756230720404720
104:61:335849270274102709412322914880
104:62:232927719706232524269836860320
104:63:155285146470821682846557906880
104:64:99479546957870140573576159095
104:65:61218182743304701891431482520
104:66:36174380711952778390391330580
104:67:20516812941107545952759262120
104:68:11163559982661458827236657330
104:69:5824466077910326344645212520
104:70:2912233038955163172322606260
104:71:1394590469358810533224910040
104:72:639187298456121494394750435
104:73:280191692473916271515507040
104:74:117377600901235194824063760
104:75:46951040360494077929625504
104:76:17915528558609582367883416
104:77:6514737657676211770139424
104:78:2255101496887919458894416
104:79:742185302773239315585504
104:80:231932907116637286120470
104:81:68720861367892529220880
104:82:19275363554408880147320
104:83:5109132508397534496880
104:84:1277283127099383624220
104:85:300537206376325558640
104:86:66397754897095181560
104:87:13737466530433485840
104:88:2653828761561014310
104:89:477092811067148640
104:90:79515468511191440
104:91:12233149001721760
104:92:1728597141547640
104:93:223044792457760
104:94:26100986351440
104:95:2747472247520
104:96:257575523205
104:97:21243342120
104:98:1517381580
104:99:91962520
104:100:4598126
104:101:182104
104:102:5356
104:103:104
104:104:1

# binomial(105, k) for 0 <= k <= 105

105:0:1
105:1:105
105:2:5460
105:3:187460
105:4:4780230
105:5:96560646
105:6:1609344100
105:7:22760723700
105:8:278818865325
105:9:3005047770725
105:10:28848458598960
105:11:249145778809200
105:12:1951641934005400
105:13:13961746143269400
105:14:91748617512913200
105:15:556608279578340080
105:16:3130921572628162950
105:17:16391295291994500150
105:18:80135221427528667400
105:19:366934961273420740200
105:20:1577820333475709182860
105:21:6386415635496918121100
105:22:24384496062806414644200
105:23:87996224922301409368200
105:24:300653768484529815341350
105:25:974118209889876601705974
105:26:2997286799661158774479920
105:27:8769839154564131229033840
105:28:24430266216285794138022840
105:29:64866568919103660297508920
105:30:164328641261729272753689264
105:31:397569293375151466339570800
105:32:919378990930037765910257475
105:33:2033777767814932027619660475
105:34:4306823508313973705547516300
105:35:8736699116865489516967818780
105:36:16988026060571785171881869850
105:37:31680372923769004779995919450
105:38:56691193653060324343150592700
105:39:97392563455257480281822813100
105:40:160697729701174842465007641615
105:41:254764693428691823420134065975
105:42:388212866177054207116394767200
105:43:568776989980335233682159775200
105:44:801458485881381465643043319600
105:45:1086421503083650431205014277680
105:46:1417071525761283171136975144800
105:47:1778877021700334193554926245600
105:48:2149476401221237150545535880100
105:49:2500411323869602399614194799300
105:50:2800460682733954687567898175216
105:51:3020104657850343290514399992880
105:52:3136262529306125724764953838760
105:53:3136262529306125724764953838760
105:54:3020104657850343290514399992880
105:55:2800460682733954687567898175216
105:56:2500411323869602399614194799300
105:57:2149476401221237150545535880100
105:58:1778877021700334193554926245600
105:59:1417071525761283171136975144800
105:60:1086421503083650431205014277680
105:61:801458485881381465643043319600
105:62:568776989980335233682159775200
105:63:388212866177054207116394767200
105:64:254764693428691823420134065975
105:65:160697729701174842465007641615
105:66:97392563455257480281822813100
105:67:56691193653060324343150592700
105:68:31680372923769004779995919450
105:69:16988026060571785171881869850
105:70:8736699116865489516967818780
105:71:4306823508313973705547516300
105:72:2033777767814932027619660475
105:73:919378990930037765910257475
105:74:397569293375151466339570800
105:75:164328641261729272753689264
105:76:64866568919103660297508920
105:77:24430266216285794138022840
105:78:8769839154564131229033840
105:79:2997286799661158774479920
105:80:974118209889876601705974
105:81:300653768484529815341350
105:82:87996224922301409368200
105:83:24384496062806414644200
105:84:6386415635496918121100
105:85:1577820333475709182860
105:86:366934961273420740200
105:87:80135221427528667400
105:88:16391295291994500150
105:89:3130921572628162950
105:90:556608279578340080
105:91:91748617512913200
105:92:13961746143269400
105:93:1951641934005400
105:94:249145778809200
105:95:28848458598960
105:96:3005047770725
105:97:278818865325
105:98:22760723700
105:99:1609344100
105:100:96560646
105:101:4780230
105:102:187460
105:103:5460
105:104:105
105:105:1

# binomial(106, k) for 0 <= k <= 106

106:0:1
106:1:106
106:2:5565
106:3:192920
106:4:4967690
106:5:101340876
106:6:1705904746
106:7:24370067800
106:8:301579589025
106:9:3283866636050
106:10:31853506369685
106:11:277994237408160
106:12:2200787712814600
106:13:15913388077274800
106:14:105710363656182600
106:15:648356897091253280
106:16:3687529852206503030
106:17:19522216864622663100
106:18:96526516719523167550
106:19:447070182700949407600
106:20:1944755294749129923060
106:21:7964235968972627303960
106:22:30770911698303332765300
106:23:112380720985107824012400
106:24:388649993406831224709550
106:25:1274771978374406417047324
106:26:3971405009551035376185894
106:27:11767125954225290003513760
106:28:33200105370849925367056680
106:29:89296835135389454435531760
106:30:229195210180832933051198184
106:31:561897934636880739093260064
106:32:1316948284305189232249828275
106:33:2953156758744969793529917950
106:34:6340601276128905733167176775
106:35:13043522625179463222515335080
106:36:25724725177437274688849688630
106:37:48668398984340789951877789300
106:38:88371566576829329123146512150
106:39:154083757108317804624973405800
106:40:258090293156432322746830454715
106:41:415462423129866665885141707590
106:42:642977559605746030536528833175
106:43:956989856157389440798554542400
106:44:1370235475861716699325203094800
106:45:1887879988965031896848057597280
106:46:2503493028844933602341989422480
106:47:3195948547461617364691901390400
106:48:3928353422921571344100462125700
106:49:4649887725090839550159730679400
106:50:5300872006603557087182092974516
106:51:5820565340584297978082298168096
106:52:6156367187156469015279353831640
106:53:6272525058612251449529907677520
106:54:6156367187156469015279353831640
106:55:5820565340584297978082298168096
106:56:5300872006603557087182092974516
106:57:4649887725090839550159730679400
106:58:3928353422921571344100462125700
106:59:3195948547461617364691901390400
106:60:2503493028844933602341989422480
106:61:1887879988965031896848057597280
106:62:1370235475861716699325203094800
106:63:956989856157389440798554542400
106:64:642977559605746030536528833175
106:65:415462423129866665885141707590
106:66:258090293156432322746830454715
106:67:154083757108317804624973405800
106:68:88371566576829329123146512150
106:69:48668398984340789951877789300
106:70:25724725177437274688849688630
106:71:13043522625179463222515335080
106:72:6340601276128905733167176775
106:73:2953156758744969793529917950
106:74:1316948284305189232249828275
106:75:561897934636880739093260064
106:76:229195210180832933051198184
106:77:89296835135389454435531760
106:78:33200105370849925367056680
106:79:11767125954225290003513760
106:80:3971405009551035376185894
106:81:1274771978374406417047324
106:82:388649993406831224709550
106:83:112380720985107824012400
106:84:30770911698303332765300
106:85:7964235968972627303960
106:86:1944755294749129923060
106:87:447070182700949407600
106:88:96526516719523167550
106:89:19522216864622663100
106:90:3687529852206503030
106:91:648356897091253280
106:92:105710363656182600
106:93:15913388077274800
106:94:2200787712814600
106:95:277994237408160
106:96:31853506369685
106:97:3283866636050
106:98:301579589025
106:99:24370067800
106:100:1705904746
106:101:101340876
106:102:4967690
106:103:192920
106:104:5565
106:105:106
106:106:1

# binomial(107, k) for 0 <= k <= 107

107:0:1
107:1:107
107:2:5671
107:3:198485
107:4:5160610
107:5:106308566
107:6:1807245622
107:7:26075972546
107:8:325949656825
107:9:3585446225075
107:10:35137373005735
107:11:309847743777845
107:12:2478781950222760
107:13:18114175790089400
107:14:121623751733457400
107:15:754067260747435880
107:16:4335886749297756310
107:17:23209746716829166130
107:18:116048733584145830650
107:19:543596699420472575150
107:20:2391825477450079330660
107:21:9908991263721757227020
107:22:38735147667275960069260
107:23:143151632683411156777700
107:24:501030714391939048721950
107:25:1663421971781237641756874
107:26:5246176987925441793233218
107:27:15738530963776325379699654
107:28:44967231325075215370570440
107:29:122496940506239379802588440
107:30:318492045316222387486729944
107:31:791093144817713672144458248
107:32:1878846218942069971343088339
107:33:4270105043050159025779746225
107:34:9293758034873875526697094725
107:35:19384123901308368955682511855
107:36:38768247802616737911365023710
107:37:74393124161778064640727477930
107:38:137039965561170119075024301450
107:39:242455323685147133748119917950
107:40:412174050264750127371803860515
107:41:673552716286298988631972162305
107:42:1058439982735612696421670540765
107:43:1599967415763135471335083375575
107:44:2327225332019106140123757637200
107:45:3258115464826748596173260692080
107:46:4391373017809965499190047019760
107:47:5699441576306550967033890812880
107:48:7124301970383188708792363516100
107:49:8578241148012410894260192805100
107:50:9950759731694396637341823653916
107:51:11121437347187855065264391142612
107:52:11976932527740766993361651999736
107:53:12428892245768720464809261509160
107:54:12428892245768720464809261509160
107:55:11976932527740766993361651999736
107:56:11121437347187855065264391142612
107:57:9950759731694396637341823653916
107:58:8578241148012410894260192805100
107:59:7124301970383188708792363516100
107:60:5699441576306550967033890812880
107:61:4391373017809965499190047019760
107:62:3258115464826748596173260692080
107:63:2327225332019106140123757637200
107:64:1599967415763135471335083375575
107:65:1058439982735612696421670540765
107:66:673552716286298988631972162305
107:67:412174050264750127371803860515
107:68:242455323685147133748119917950
107:69:137039965561170119075024301450
107:70:74393124161778064640727477930
107:71:38768247802616737911365023710
107:72:19384123901308368955682511855
107:73:9293758034873875526697094725
107:74:4270105043050159025779746225
107:75:1878846218942069971343088339
107:76:791093144817713672144458248
107:77:318492045316222387486729944
107:78:122496940506239379802588440
107:79:44967231325075215370570440
107:80:15738530963776325379699654
107:81:5246176987925441793233218
107:82:1663421971781237641756874
107:83:501030714391939048721950
107:84:143151632683411156777700
107:85:38735147667275960069260
107:86:9908991263721757227020
107:87:2391825477450079330660
107:88:543596699420472575150
107:89:116048733584145830650
107:90:23209746716829166130
107:91:4335886749297756310
107:92:754067260747435880
107:93:121623751733457400
107:94:18114175790089400
107:95:2478781950222760
107:96:309847743777845
107:97:35137373005735
107:98:3585446225075
107:99:325949656825
107:100:26075972546
107:101:1807245622
107:102:106308566
107:103:5160610
107:104:198485
107:105:5671
107:106:107
107:107:1

# binomial(108, k) for 0 <= k <= 108

108:0:1
108:1:108
108:2:5778
108:3:204156
108:4:5359095
108:5:111469176
108:6:1913554188
108:7:27883218168
108:8:352025629371
108:9:3911395881900
108:10:38722819230810
108:11:344985116783580
108:12:2788629694000605
108:13:20592957740312160
108:14:139737927523546800
108:15:875691012480893280
108:16:5089954010045192190
108:17:27545633466126922440
108:18:139258480300974996780
108:19:659645433004618405800
108:20:2935422176870551905810
108:21:12300816741171836557680
108:22:48644138930997717296280
108:23:181886780350687116846960
108:24:644182347075350205499650
108:25:2164452686173176690478824
108:26:6909598959706679434990092
108:27:20984707951701767172932872
108:28:60705762288851540750270094
108:29:167464171831314595173158880
108:30:440988985822461767289318384
108:31:1109585190133936059631188192
108:32:2669939363759783643487546587
108:33:6148951261992228997122834564
108:34:13563863077924034552476840950
108:35:28677881936182244482379606580
108:36:58152371703925106867047535565
108:37:113161371964394802552092501640
108:38:211433089722948183715751779380
108:39:379495289246317252823144219400
108:40:654629373949897261119923778465
108:41:1085726766551049116003776022820
108:42:1731992699021911685053642703070
108:43:2658407398498748167756753916340
108:44:3927192747782241611458841012775
108:45:5585340796845854736297018329280
108:46:7649488482636714095363307711840
108:47:10090814594116516466223937832640
108:48:12823743546689739675826254328980
108:49:15702543118395599603052556321200
108:50:18529000879706807531602016459016
108:51:21072197078882251702606214796528
108:52:23098369874928622058626043142348
108:53:24405824773509487458170913508896
108:54:24857784491537440929618523018320
108:55:24405824773509487458170913508896
108:56:23098369874928622058626043142348
108:57:21072197078882251702606214796528
108:58:18529000879706807531602016459016
108:59:15702543118395599603052556321200
108:60:12823743546689739675826254328980
108:61:10090814594116516466223937832640
108:62:7649488482636714095363307711840
108:63:5585340796845854736297018329280
108:64:3927192747782241611458841012775
108:65:2658407398498748167756753916340
108:66:1731992699021911685053642703070
108:67:1085726766551049116003776022820
108:68:654629373949897261119923778465
108:69:379495289246317252823144219400
108:70:211433089722948183715751779380
108:71:113161371964394802552092501640
108:72:58152371703925106867047535565
108:73:28677881936182244482379606580
108:74:13563863077924034552476840950
108:75:6148951261992228997122834564
108:76:2669939363759783643487546587
108:77:1109585190133936059631188192
108:78:440988985822461767289318384
108:79:167464171831314595173158880
108:80:60705762288851540750270094
108:81:20984707951701767172932872
108:82:6909598959706679434990092
108:83:2164452686173176690478824
108:84:644182347075350205499650
108:85:181886780350687116846960
108:86:48644138930997717296280
108:87:12300816741171836557680
108:88:2935422176870551905810
108:89:659645433004618405800
108:90:139258480300974996780
108:91:27545633466126922440
108:92:5089954010045192190
108:93:875691012480893280
108:94:139737927523546800
108:95:20592957740312160
108:96:2788629694000605
108:97:344985116783580
108:98:38722819230810
108:99:3911395881900
108:100:352025629371
108:101:27883218168
108:102:1913554188
108:103:111469176
108:104:5359095
108:105:204156
108:106:5778
108:107:108
108:108:1

# binomial(109, k) for 0 <= k <= 109

109:0:1
109:1:109
109:2:5886
109:3:209934
109:4:5563251
109:5:116828271
109:6:2025023364
109:7:29796772356
109:8:379908847539
109:9:4263421511271
109:10:42634215112710
109:11:383707936014390
109:12:3133614810784185
109:13:23381587434312765
109:14:160330885263858960
109:15:1015428940004440080
109:16:5965645022526085470
109:17:32635587476172114630
109:18:166804113767101919220
109:19:798903913305593402580
109:20:3595067609875170311610
109:21:15236238918042388463490
109:22:60944955672169553853960
109:23:230530919281684834143240
109:24:826069127426037322346610
109:25:2808635033248526895978474
109:26:9074051645879856125468916
109:27:27894306911408446607922964
109:28:81690470240553307923202966
109:29:228169934120166135923428974
109:30:608453157653776362462477264
109:31:1550574175956397826920506576
109:32:3779524553893719703118734779
109:33:8818890625752012640610381151
109:34:19712814339916263549599675514
109:35:42241745014106279034856447530
109:36:86830253640107351349427142145
109:37:171313743668319909419140037205
109:38:324594461687342986267844281020
109:39:590928378969265436538895998780
109:40:1034124663196214513943067997865
109:41:1740356140500946377123699801285
109:42:2817719465572960801057418725890
109:43:4390400097520659852810396619410
109:44:6585600146280989779215594929115
109:45:9512533544628096347755859342055
109:46:13234829279482568831660326041120
109:47:17740303076753230561587245544480
109:48:22914558140806256142050192161620
109:49:28526286665085339278878810650180
109:50:34231543998102407134654572780216
109:51:39601197958589059234208231255544
109:52:44170566953810873761232257938876
109:53:47504194648438109516796956651244
109:54:49263609265046928387789436527216
109:55:49263609265046928387789436527216
109:56:47504194648438109516796956651244
109:57:44170566953810873761232257938876
109:58:39601197958589059234208231255544
109:59:34231543998102407134654572780216
109:60:28526286665085339278878810650180
109:61:22914558140806256142050192161620
109:62:17740303076753230561587245544480
109:63:13234829279482568831660326041120
109:64:9512533544628096347755859342055
109:65:6585600146280989779215594929115
109:66:4390400097520659852810396619410
109:67:2817719465572960801057418725890
109:68:1740356140500946377123699801285
109:69:1034124663196214513943067997865
109:70:590928378969265436538895998780
109:71:324594461687342986267844281020
109:72:171313743668319909419140037205
109:73:86830253640107351349427142145
109:74:42241745014106279034856447530
109:75:19712814339916263549599675514
109:76:8818890625752012640610381151
109:77:3779524553893719703118734779
109:78:1550574175956397826920506576
109:79:608453157653776362462477264
109:80:228169934120166135923428974
109:81:81690470240553307923202966
109:82:27894306911408446607922964
109:83:9074051645879856125468916
109:84:2808635033248526895978474
109:85:826069127426037322346610
109:86:230530919281684834143240
109:87:60944955672169553853960
109:88:15236238918042388463490
109:89:3595067609875170311610
109:90:798903913305593402580
109:91:166804113767101919220
109:92:32635587476172114630
109:93:5965645022526085470
109:94:1015428940004440080
109:95:160330885263858960
109:96:23381587434312765
109:97:3133614810784185
109:98:383707936014390
109:99:42634215112710
109:100:4263421511271
109:101:379908847539
109:102:29796772356
109:103:2025023364
109:104:116828271
109:105:5563251
109:106:209934
109:107:5886
109:108:109
109:109:1

# binomial(110, k) for 0 <= k <= 110

110:0:1
110:1:110
110:2:5995
110:3:215820
110:4:5773185
110:5:122391522
110:6:2141851635
110:7:31821795720
110:8:409705619895
110:9:4643330358810
110:10:46897636623981
110:11:426342151127100
110:12:3517322746798575
110:13:26515202245096950
110:14:183712472698171725
110:15:1175759825268299040
110:16:6981073962530525550
110:17:38601232498698200100
110:18:199439701243274033850
110:19:965708027072695321800
110:20:4393971523180763714190
110:21:18831306527917558775100
110:22:76181194590211942317450
110:23:291475874953854387997200
110:24:1056600046707722156489850
110:25:3634704160674564218325084
110:26:11882686679128383021447390
110:27:36968358557288302733391880
110:28:109584777151961754531125930
110:29:309860404360719443846631940
110:30:836623091773942498385906238
110:31:2159027333610174189382983840
110:32:5330098729850117530039241355
110:33:12598415179645732343729115930
110:34:28531704965668276190210056665
110:35:61954559354022542584456123044
110:36:129071998654213630384283589675
110:37:258143997308427260768567179350
110:38:495908205355662895686984318225
110:39:915522840656608422806740279800
110:40:1625053042165479950481963996645
110:41:2774480803697160891066767799150
110:42:4558075606073907178181118527175
110:43:7208119563093620653867815345300
110:44:10976000243801649632025991548525
110:45:16098133690909086126971454271170
110:46:22747362824110665179416185383175
110:47:30975132356235799393247571585600
110:48:40654861217559486703637437706100
110:49:51440844805891595420929002811800
110:50:62757830663187746413533383430396
110:51:73832741956691466368862804035760
110:52:83771764912399932995440489194420
110:53:91674761602248983278029214590120
110:54:96767803913485037904586393178460
110:55:98527218530093856775578873054432
110:56:96767803913485037904586393178460
110:57:91674761602248983278029214590120
110:58:83771764912399932995440489194420
110:59:73832741956691466368862804035760
110:60:62757830663187746413533383430396
110:61:51440844805891595420929002811800
110:62:40654861217559486703637437706100
110:63:30975132356235799393247571585600
110:64:22747362824110665179416185383175
110:65:16098133690909086126971454271170
110:66:10976000243801649632025991548525
110:67:7208119563093620653867815345300
110:68:4558075606073907178181118527175
110:69:2774480803697160891066767799150
110:70:1625053042165479950481963996645
110:71:915522840656608422806740279800
110:72:495908205355662895686984318225
110:73:258143997308427260768567179350
110:74:129071998654213630384283589675
110:75:61954559354022542584456123044
110:76:28531704965668276190210056665
110:77:12598415179645732343729115930
110:78:5330098729850117530039241355
110:79:2159027333610174189382983840
110:80:836623091773942498385906238
110:81:309860404360719443846631940
110:82:109584777151961754531125930
110:83:36968358557288302733391880
110:84:11882686679128383021447390
110:85:3634704160674564218325084
110:86:1056600046707722156489850
110:87:291475874953854387997200
110:88:76181194590211942317450
110:89:18831306527917558775100
110:90:4393971523180763714190
110:91:965708027072695321800
110:92:199439701243274033850
110:93:38601232498698200100
110:94:6981073962530525550
110:95:1175759825268299040
110:96:183712472698171725
110:97:26515202245096950
110:98:3517322746798575
110:99:426342151127100
110:100:46897636623981
110:101:4643330358810
110:102:409705619895
110:103:31821795720
110:104:2141851635
110:105:122391522
110:106:5773185
110:107:215820
110:108:5995
110:109:110
110:110:1

# binomial(111, k) for 0 <= k <= 111

111:0:1
111:1:111
111:2:6105
111:3:221815
111:4:5989005
111:5:128164707
111:6:2264243157
111:7:33963647355
111:8:441527415615
111:9:5053035978705
111:10:51540966982791
111:11:473239787751081
111:12:3943664897925675
111:13:30032524991895525
111:14:210227674943268675
111:15:1359472297966470765
111:16:8156833787798824590
111:17:45582306461228725650
111:18:238040933741972233950
111:19:1165147728315969355650
111:20:5359679550253459035990
111:21:23225278051098322489290
111:22:95012501118129501092550
111:23:367657069544066330314650
111:24:1348075921661576544487050
111:25:4691304207382286374814934
111:26:15517390839802947239772474
111:27:48851045236416685754839270
111:28:146553135709250057264517810
111:29:419445181512681198377757870
111:30:1146483496134661942232538178
111:31:2995650425384116687768890078
111:32:7489126063460291719422225195
111:33:17928513909495849873768357285
111:34:41130120145314008533939172595
111:35:90486264319690818774666179709
111:36:191026558008236172968739712719
111:37:387215995962640891152850769025
111:38:754052202664090156455551497575
111:39:1411431046012271318493724598025
111:40:2540575882822088373288704276445
111:41:4399533845862640841548731795795
111:42:7332556409771068069247886326325
111:43:11766195169167527832048933872475
111:44:18184119806895270285893806893825
111:45:27074133934710735758997445819695
111:46:38845496515019751306387639654345
111:47:53722495180346464572663756968775
111:48:71629993573795286096885009291700
111:49:92095706023451082124566440517900
111:50:114198675469079341834462386242196
111:51:136590572619879212782396187466156
111:52:157604506869091399364303293230180
111:53:175446526514648916273469703784540
111:54:188442565515734021182615607768580
111:55:195295022443578894680165266232892
111:56:195295022443578894680165266232892
111:57:188442565515734021182615607768580
111:58:175446526514648916273469703784540
111:59:157604506869091399364303293230180
111:60:136590572619879212782396187466156
111:61:114198675469079341834462386242196
111:62:92095706023451082124566440517900
111:63:71629993573795286096885009291700
111:64:53722495180346464572663756968775
111:65:38845496515019751306387639654345
111:66:27074133934710735758997445819695
111:67:18184119806895270285893806893825
111:68:11766195169167527832048933872475
111:69:7332556409771068069247886326325
111:70:4399533845862640841548731795795
111:71:2540575882822088373288704276445
111:72:1411431046012271318493724598025
111:73:754052202664090156455551497575
111:74:387215995962640891152850769025
111:75:191026558008236172968739712719
111:76:90486264319690818774666179709
111:77:41130120145314008533939172595
111:78:17928513909495849873768357285
111:79:7489126063460291719422225195
111:80:2995650425384116687768890078
111:81:1146483496134661942232538178
111:82:419445181512681198377757870
111:83:146553135709250057264517810
111:84:48851045236416685754839270
111:85:15517390839802947239772474
111:86:4691304207382286374814934
111:87:1348075921661576544487050
111:88:367657069544066330314650
111:89:95012501118129501092550
111:90:23225278051098322489290
111:91:5359679550253459035990
111:92:1165147728315969355650
111:93:238040933741972233950
111:94:45582306461228725650
111:95:8156833787798824590
111:96:1359472297966470765
111:97:210227674943268675
111:98:30032524991895525
111:99:3943664897925675
111:100:473239787751081
111:101:51540966982791
111:102:5053035978705
111:103:441527415615
111:104:33963647355
111:105:2264243157
111:106:128164707
111:107:5989005
111:108:221815
111:109:6105
111:110:111
111:111:1

# binomial(112, k) for 0 <= k <= 112

112:0:1
112:1:112
112:2:6216
112:3:227920
112:4:6210820
112:5:134153712
112:6:2392407864
112:7:36227890512
112:8:475491062970
112:9:5494563394320
112:10:56594002961496
112:11:524780754733872
112:12:4416904685676756
112:13:33976189889821200
112:14:240260199935164200
112:15:1569699972909739440
112:16:9516306085765295355
112:17:53739140249027550240
112:18:283623240203200959600
112:19:1403188662057941589600
112:20:6524827278569428391640
112:21:28584957601351781525280
112:22:118237779169227823581840
112:23:462669570662195831407200
112:24:1715732991205642874801700
112:25:6039380129043862919301984
112:26:20208695047185233614587408
112:27:64368436076219632994611744
112:28:195404180945666743019357080
112:29:565998317221931255642275680
112:30:1565928677647343140610296048
112:31:4142133921518778630001428256
112:32:10484776488844408407191115273
112:33:25417639972956141593190582480
112:34:59058634054809858407707529880
112:35:131616384465004827308605352304
112:36:281512822327926991743405892428
112:37:578242553970877064121590481744
112:38:1141268198626731047608402266600
112:39:2165483248676361474949276095600
112:40:3952006928834359691782428874470
112:41:6940109728684729214837436072240
112:42:11732090255633708910796618122120
112:43:19098751578938595901296820198800
112:44:29950314976062798117942740766300
112:45:45258253741606006044891252713520
112:46:65919630449730487065385085474040
112:47:92567991695366215879051396623120
112:48:125352488754141750669548766260475
112:49:163725699597246368221451449809600
112:50:206294381492530423959028826760096
112:51:250789248088958554616858573708352
112:52:294195079488970612146699480696336
112:53:333051033383740315637772997014720
112:54:363889092030382937456085311553120
112:55:383737587959312915862780874001472
112:56:390590044887157789360330532465784
112:57:383737587959312915862780874001472
112:58:363889092030382937456085311553120
112:59:333051033383740315637772997014720
112:60:294195079488970612146699480696336
112:61:250789248088958554616858573708352
112:62:206294381492530423959028826760096
112:63:163725699597246368221451449809600
112:64:125352488754141750669548766260475
112:65:92567991695366215879051396623120
112:66:65919630449730487065385085474040
112:67:45258253741606006044891252713520
112:68:29950314976062798117942740766300
112:69:19098751578938595901296820198800
112:70:11732090255633708910796618122120
112:71:6940109728684729214837436072240
112:72:3952006928834359691782428874470
112:73:2165483248676361474949276095600
112:74:1141268198626731047608402266600
112:75:578242553970877064121590481744
112:76:281512822327926991743405892428
112:77:131616384465004827308605352304
112:78:59058634054809858407707529880
112:79:25417639972956141593190582480
112:80:10484776488844408407191115273
112:81:4142133921518778630001428256
112:82:1565928677647343140610296048
112:83:565998317221931255642275680
112:84:195404180945666743019357080
112:85:64368436076219632994611744
112:86:20208695047185233614587408
112:87:6039380129043862919301984
112:88:1715732991205642874801700
112:89:462669570662195831407200
112:90:118237779169227823581840
112:91:28584957601351781525280
112:92:6524827278569428391640
112:93:1403188662057941589600
112:94:283623240203200959600
112:95:53739140249027550240
112:96:9516306085765295355
112:97:1569699972909739440
112:98:240260199935164200
112:99:33976189889821200
112:100:4416904685676756
112:101:524780754733872
112:102:56594002961496
112:103:5494563394320
112:104:475491062970
112:105:36227890512
112:106:2392407864
112:107:134153712
112:108:6210820
112:109:227920
112:110:6216
112:111:112
112:112:1

# binomial(113, k) for 0 <= k <= 113

113:0:1
113:1:113
113:2:6328
113:3:234136
113:4:6438740
113:5:140364532
113:6:2526561576
113:7:38620298376
113:8:511718953482
113:9:5970054457290
113:10:62088566355816
113:11:581374757695368
113:12:4941685440410628
113:13:38393094575497956
113:14:274236389824985400
113:15:1809960172844903640
113:16:11086006058675034795
113:17:63255446334792845595
113:18:337362380452228509840
113:19:1686811902261142549200
113:20:7928015940627369981240
113:21:35109784879921209916920
113:22:146822736770579605107120
113:23:580907349831423654989040
113:24:2178402561867838706208900
113:25:7755113120249505794103684
113:26:26248075176229096533889392
113:27:84577131123404866609199152
113:28:259772617021886376013968824
113:29:761402498167597998661632760
113:30:2131926994869274396252571728
113:31:5708062599166121770611724304
113:32:14626910410363187037192543529
113:33:35902416461800550000381697753
113:34:84476274027766000000898112360
113:35:190675018519814685716312882184
113:36:413129206792931819052011244732
113:37:859755376298804055864996374172
113:38:1719510752597608111729992748344
113:39:3306751447303092522557678362200
113:40:6117490177510721166731704970070
113:41:10892116657519088906619864946710
113:42:18672199984318438125634054194360
113:43:30830841834572304812093438320920
113:44:49049066555001394019239560965100
113:45:75208568717668804162833993479820
113:46:111177884191336493110276338187560
113:47:158487622145096702944436482097160
113:48:217920480449507966548600162883595
113:49:289078188351388118891000216070075
113:50:370020081089776792180480276569696
113:51:457083629581488978575887400468448
113:52:544984327577929166763558054404688
113:53:627246112872710927784472477711056
113:54:696940125414123253093858308567840
113:55:747626679989695853318866185554592
113:56:774327632846470705223111406467256
113:57:774327632846470705223111406467256
113:58:747626679989695853318866185554592
113:59:696940125414123253093858308567840
113:60:627246112872710927784472477711056
113:61:544984327577929166763558054404688
113:62:457083629581488978575887400468448
113:63:370020081089776792180480276569696
113:64:289078188351388118891000216070075
113:65:217920480449507966548600162883595
113:66:158487622145096702944436482097160
113:67:111177884191336493110276338187560
113:68:75208568717668804162833993479820
113:69:49049066555001394019239560965100
113:70:30830841834572304812093438320920
113:71:18672199984318438125634054194360
113:72:10892116657519088906619864946710
113:73:6117490177510721166731704970070
113:74:3306751447303092522557678362200
113:75:1719510752597608111729992748344
113:76:859755376298804055864996374172
113:77:413129206792931819052011244732
113:78:190675018519814685716312882184
113:79:84476274027766000000898112360
113:80:35902416461800550000381697753
113:81:14626910410363187037192543529
113:82:5708062599166121770611724304
113:83:2131926994869274396252571728
113:84:761402498167597998661632760
113:85:259772617021886376013968824
113:86:84577131123404866609199152
113:87:26248075176229096533889392
113:88:7755113120249505794103684
113:89:2178402561867838706208900
113:90:580907349831423654989040
113:91:146822736770579605107120
113:92:35109784879921209916920
113:93:7928015940627369981240
113:94:1686811902261142549200
113:95:337362380452228509840
113:96:63255446334792845595
113:97:11086006058675034795
113:98:1809960172844903640
113:99:274236389824985400
113:100:38393094575497956
113:101:4941685440410628
113:102:581374757695368
113:103:62088566355816
113:104:5970054457290
113:105:511718953482
113:106:38620298376
113:107:2526561576
113:108:140364532
113:109:6438740
113:110:234136
113:111:6328
113:112:113
113:113:1

# binomial(114, k) for 0 <= k <= 114

114:0:1
114:1:114
114:2:6441
114:3:240464
114:4:6672876
114:5:146803272
114:6:2666926108
114:7:41146859952
114:8:550339251858
114:9:6481773410772
114:10:68058620813106
114:11:643463324051184
114:12:5523060198105996
114:13:43334780015908584
114:14:312629484400483356
114:15:2084196562669889040
114:16:12895966231519938435
114:17:74341452393467880390
114:18:400617826787021355435
114:19:2024174282713371059040
114:20:9614827842888512530440
114:21:43037800820548579898160
114:22:181932521650500815024040
114:23:727730086602003260096160
114:24:2759309911699262361197940
114:25:9933515682117344500312584
114:26:34003188296478602327993076
114:27:110825206299633963143088544
114:28:344349748145291242623167976
114:29:1021175115189484374675601584
114:30:2893329493036872394914204488
114:31:7839989594035396166864296032
114:32:20334973009529308807804267833
114:33:50529326872163737037574241282
114:34:120378690489566550001279810113
114:35:275151292547580685717210994544
114:36:603804225312746504768324126916
114:37:1272884583091735874917007618904
114:38:2579266128896412167594989122516
114:39:5026262199900700634287671110544
114:40:9424241624813813689289383332270
114:41:17009606835029810073351569916780
114:42:29564316641837527032253919141070
114:43:49503041818890742937727492515280
114:44:79879908389573698831332999286020
114:45:124257635272670198182073554444920
114:46:186386452909005297273110331667380
114:47:269665506336433196054712820284720
114:48:376408102594604669493036644980755
114:49:506998668800896085439600378953670
114:50:659098269441164911071480492639771
114:51:827103710671265770756367677038144
114:52:1002067957159418145339445454873136
114:53:1172230440450640094548030532115744
114:54:1324186238286834180878330786278896
114:55:1444566805403819106412724494122432
114:56:1521954312836166558541977592021848
114:57:1548655265692941410446222812934512
114:58:1521954312836166558541977592021848
114:59:1444566805403819106412724494122432
114:60:1324186238286834180878330786278896
114:61:1172230440450640094548030532115744
114:62:1002067957159418145339445454873136
114:63:827103710671265770756367677038144
114:64:659098269441164911071480492639771
114:65:506998668800896085439600378953670
114:66:376408102594604669493036644980755
114:67:269665506336433196054712820284720
114:68:186386452909005297273110331667380
114:69:124257635272670198182073554444920
114:70:79879908389573698831332999286020
114:71:49503041818890742937727492515280
114:72:29564316641837527032253919141070
114:73:17009606835029810073351569916780
114:74:9424241624813813689289383332270
114:75:5026262199900700634287671110544
114:76:2579266128896412167594989122516
114:77:1272884583091735874917007618904
114:78:603804225312746504768324126916
114:79:275151292547580685717210994544
114:80:120378690489566550001279810113
114:81:50529326872163737037574241282
114:82:20334973009529308807804267833
114:83:7839989594035396166864296032
114:84:2893329493036872394914204488
114:85:1021175115189484374675601584
114:86:344349748145291242623167976
114:87:110825206299633963143088544
114:88:34003188296478602327993076
114:89:9933515682117344500312584
114:90:2759309911699262361197940
114:91:727730086602003260096160
114:92:181932521650500815024040
114:93:43037800820548579898160
114:94:9614827842888512530440
114:95:2024174282713371059040
114:96:400617826787021355435
114:97:74341452393467880390
114:98:12895966231519938435
114:99:2084196562669889040
114:100:312629484400483356
114:101:43334780015908584
114:102:5523060198105996
114:103:643463324051184
114:104:68058620813106
114:105:6481773410772
114:106:550339251858
114:107:41146859952
114:108:2666926108
114:109:146803272
114:110:6672876
114:111:240464
114:112:6441
114:113:114
114:114:1

# binomial(115, k) for 0 <= k <= 115

115:0:1
115:1:115
115:2:6555
115:3:246905
115:4:6913340
115:5:153476148
115:6:2813729380
115:7:43813786060
115:8:591486111810
115:9:7032112662630
115:10:74540394223878
115:11:711521944864290
115:12:6166523522157180
115:13:48857840214014580
115:14:355964264416391940
115:15:2396826047070372396
115:16:14980162794189827475
115:17:87237418624987818825
115:18:474959279180489235825
115:19:2424792109500392414475
115:20:11639002125601883589480
115:21:52652628663437092428600
115:22:224970322471049394922200
115:23:909662608252504075120200
115:24:3487039998301265621294100
115:25:12692825593816606861510524
115:26:43936703978595946828305660
115:27:144828394596112565471081620
115:28:455174954444925205766256520
115:29:1365524863334775617298769560
115:30:3914504608226356769589806072
115:31:10733319087072268561778500520
115:32:28174962603564704974668563865
115:33:70864299881693045845378509115
115:34:170908017361730287038854051395
115:35:395529983037147235718490804657
115:36:878955517860327190485535121460
115:37:1876688808404482379685331745820
115:38:3852150711988148042511996741420
115:39:7605528328797112801882660233060
115:40:14450503824714514323577054442814
115:41:26433848459843623762640953249050
115:42:46573923476867337105605489057850
115:43:79067358460728269969981411656350
115:44:129382950208464441769060491801300
115:45:204137543662243897013406553730940
115:46:310644088181675495455183886112300
115:47:456051959245438493327823151952100
115:48:646073608931037865547749465265475
115:49:883406771395500754932637023934425
115:50:1166096938242060996511080871593441
115:51:1486201980112430681827848169677915
115:52:1829171667830683916095813131911280
115:53:2174298397610058239887475986988880
115:54:2496416678737474275426361318394640
115:55:2768753043690653287291055280401328
115:56:2966521118239985664954702086144280
115:57:3070609578529107968988200404956360
115:58:3070609578529107968988200404956360
115:59:2966521118239985664954702086144280
115:60:2768753043690653287291055280401328
115:61:2496416678737474275426361318394640
115:62:2174298397610058239887475986988880
115:63:1829171667830683916095813131911280
115:64:1486201980112430681827848169677915
115:65:1166096938242060996511080871593441
115:66:883406771395500754932637023934425
115:67:646073608931037865547749465265475
115:68:456051959245438493327823151952100
115:69:310644088181675495455183886112300
115:70:204137543662243897013406553730940
115:71:129382950208464441769060491801300
115:72:79067358460728269969981411656350
115:73:46573923476867337105605489057850
115:74:26433848459843623762640953249050
115:75:14450503824714514323577054442814
115:76:7605528328797112801882660233060
115:77:3852150711988148042511996741420
115:78:1876688808404482379685331745820
115:79:878955517860327190485535121460
115:80:395529983037147235718490804657
115:81:170908017361730287038854051395
115:82:70864299881693045845378509115
115:83:28174962603564704974668563865
115:84:10733319087072268561778500520
115:85:3914504608226356769589806072
115:86:1365524863334775617298769560
115:87:455174954444925205766256520
115:88:144828394596112565471081620
115:89:43936703978595946828305660
115:90:12692825593816606861510524
115:91:3487039998301265621294100
115:92:909662608252504075120200
115:93:224970322471049394922200
115:94:52652628663437092428600
115:95:11639002125601883589480
115:96:2424792109500392414475
115:97:474959279180489235825
115:98:87237418624987818825
115:99:14980162794189827475
115:100:2396826047070372396
115:101:355964264416391940
115:102:48857840214014580
115:103:6166523522157180
115:104:711521944864290
115:105:74540394223878
115:106:7032112662630
115:107:591486111810
115:108:43813786060
115:109:2813729380
115:110:153476148
115:111:6913340
115:112:246905
115:113:6555
115:114:115
115:115:1

# binomial(116, k) for 0 <= k <= 116

116:0:1
116:1:116
116:2:6670
116:3:253460
116:4:7160245
116:5:160389488
116:6:2967205528
116:7:46627515440
116:8:635299897870
116:9:7623598774440
116:10:81572506886508
116:11:786062339088168
116:12:6878045467021470
116:13:55024363736171760
116:14:404822104630406520
116:15:2752790311486764336
116:16:17376988841260199871
116:17:102217581419177646300
116:18:562196697805477054650
116:19:2899751388680881650300
116:20:14063794235102276003955
116:21:64291630789038976018080
116:22:277622951134486487350800
116:23:1134632930723553470042400
116:24:4396702606553769696414300
116:25:16179865592117872482804624
116:26:56629529572412553689816184
116:27:188765098574708512299387280
116:28:600003349041037771237338140
116:29:1820699817779700823065026080
116:30:5280029471561132386888575632
116:31:14647823695298625331368306592
116:32:38908281690636973536447064385
116:33:99039262485257750820047072980
116:34:241772317243423332884232560510
116:35:566438000398877522757344856052
116:36:1274485500897474426204025926117
116:37:2755644326264809570170866867280
116:38:5728839520392630422197328487240
116:39:11457679040785260844394656974480
116:40:22056032153511627125459714675874
116:41:40884352284558138086218007691864
116:42:73007771936710960868246442306900
116:43:125641281937595607075586900714200
116:44:208450308669192711739041903457650
116:45:333520493870708338782467045532240
116:46:514781631843919392468590439843240
116:47:766696047427113988783007038064400
116:48:1102125568176476358875572617217575
116:49:1529480380326538620480386489199900
116:50:2049503709637561751443717895527866
116:51:2652298918354491678338929041271356
116:52:3315373647943114597923661301589195
116:53:4003470065440742155983289118900160
116:54:4670715076347532515313837305383520
116:55:5265169722428127562717416598795968
116:56:5735274161930638952245757366545608
116:57:6037130696769093633942902491100640
116:58:6141219157058215937976400809912720
116:59:6037130696769093633942902491100640
116:60:5735274161930638952245757366545608
116:61:5265169722428127562717416598795968
116:62:4670715076347532515313837305383520
116:63:4003470065440742155983289118900160
116:64:3315373647943114597923661301589195
116:65:2652298918354491678338929041271356
116:66:2049503709637561751443717895527866
116:67:1529480380326538620480386489199900
116:68:1102125568176476358875572617217575
116:69:766696047427113988783007038064400
116:70:514781631843919392468590439843240
116:71:333520493870708338782467045532240
116:72:208450308669192711739041903457650
116:73:125641281937595607075586900714200
116:74:73007771936710960868246442306900
116:75:40884352284558138086218007691864
116:76:22056032153511627125459714675874
116:77:11457679040785260844394656974480
116:78:5728839520392630422197328487240
116:79:2755644326264809570170866867280
116:80:1274485500897474426204025926117
116:81:566438000398877522757344856052
116:82:241772317243423332884232560510
116:83:99039262485257750820047072980
116:84:38908281690636973536447064385
116:85:14647823695298625331368306592
116:86:5280029471561132386888575632
116:87:1820699817779700823065026080
116:88:600003349041037771237338140
116:89:188765098574708512299387280
116:90:56629529572412553689816184
116:91:16179865592117872482804624
116:92:4396702606553769696414300
116:93:1134632930723553470042400
116:94:277622951134486487350800
116:95:64291630789038976018080
116:96:14063794235102276003955
116:97:2899751388680881650300
116:98:562196697805477054650
116:99:102217581419177646300
116:100:17376988841260199871
116:101:2752790311486764336
116:102:404822104630406520
116:103:55024363736171760
116:104:6878045467021470
116:105:786062339088168
116:106:81572506886508
116:107:7623598774440
116:108:635299897870
116:109:46627515440
116:110:2967205528
116:111:160389488
116:112:7160245
116:113:253460
116:114:6670
116:115:116
116:116:1

# binomial(117, k) for 0 <= k <= 117

117:0:1
117:1:117
117:2:6786
117:3:260130
117:4:7413705
117:5:167549733
117:6:3127595016
117:7:49594720968
117:8:681927413310
117:9:8258898672310
117:10:89196105660948
117:11:867634845974676
117:12:7664107806109638
117:13:61902409203193230
117:14:459846468366578280
117:15:3157612416117170856
117:16:20129779152746964207
117:17:119594570260437846171
117:18:664414279224654700950
117:19:3461948086486358704950
117:20:16963545623783157654255
117:21:78355425024141252022035
117:22:341914581923525463368880
117:23:1412255881858039957393200
117:24:5531335537277323166456700
117:25:20576568198671642179218924
117:26:72809395164530426172620808
117:27:245394628147121065989203464
117:28:788768447615746283536725420
117:29:2420703166820738594302364220
117:30:7100729289340833209953601712
117:31:19927853166859757718256882224
117:32:53556105385935598867815370977
117:33:137947544175894724356494137365
117:34:340811579728681083704279633490
117:35:808210317642300855641577416562
117:36:1840923501296351948961370782169
117:37:4030129827162283996374892793397
117:38:8484483846657439992368195354520
117:39:17186518561177891266591985461720
117:40:33513711194296887969854371650354
117:41:62940384438069765211677722367738
117:42:113892124221269098954464449998764
117:43:198649053874306567943833343021100
117:44:334091590606788318814628804171850
117:45:541970802539901050521508948989890
117:46:848302125714627731251057485375480
117:47:1281477679271033381251597477907640
117:48:1868821615603590347658579655281975
117:49:2631605948503014979355959106417475
117:50:3578984089964100371924104384727766
117:51:4701802627992053429782646936799222
117:52:5967672566297606276262590342860551
117:53:7318843713383856753906950420489355
117:54:8674185141788274671297126424283680
117:55:9935884798775660078031253904179488
117:56:11000443884358766514963173965341576
117:57:11772404858699732586188659857646248
117:58:12178349853827309571919303301013360
117:59:12178349853827309571919303301013360
117:60:11772404858699732586188659857646248
117:61:11000443884358766514963173965341576
117:62:9935884798775660078031253904179488
117:63:8674185141788274671297126424283680
117:64:7318843713383856753906950420489355
117:65:5967672566297606276262590342860551
117:66:4701802627992053429782646936799222
117:67:3578984089964100371924104384727766
117:68:2631605948503014979355959106417475
117:69:1868821615603590347658579655281975
117:70:1281477679271033381251597477907640
117:71:848302125714627731251057485375480
117:72:541970802539901050521508948989890
117:73:334091590606788318814628804171850
117:74:198649053874306567943833343021100
117:75:113892124221269098954464449998764
117:76:62940384438069765211677722367738
117:77:33513711194296887969854371650354
117:78:17186518561177891266591985461720
117:79:8484483846657439992368195354520
117:80:4030129827162283996374892793397
117:81:1840923501296351948961370782169
117:82:808210317642300855641577416562
117:83:340811579728681083704279633490
117:84:137947544175894724356494137365
117:85:53556105385935598867815370977
117:86:19927853166859757718256882224
117:87:7100729289340833209953601712
117:88:2420703166820738594302364220
117:89:788768447615746283536725420
117:90:245394628147121065989203464
117:91:72809395164530426172620808
117:92:20576568198671642179218924
117:93:5531335537277323166456700
117:94:1412255881858039957393200
117:95:341914581923525463368880
117:96:78355425024141252022035
117:97:16963545623783157654255
117:98:3461948086486358704950
117:99:664414279224654700950
117:100:119594570260437846171
117:101:20129779152746964207
117:102:3157612416117170856
117:103:459846468366578280
117:104:61902409203193230
117:105:7664107806109638
117:106:867634845974676
117:107:89196105660948
117:108:8258898672310
117:109:681927413310
117:110:49594720968
117:111:3127595016
117:112:167549733
117:113:7413705
117:114:260130
117:115:6786
117:116:117
117:117:1

# binomial(118, k) for 0 <= k <= 118

118:0:1
118:1:118
118:2:6903
118:3:266916
118:4:7673835
118:5:174963438
118:6:3295144749
118:7:52722315984
118:8:731522134278
118:9:8940826085620
118:10:97455004333258
118:11:956830951635624
118:12:8531742652084314
118:13:69566517009302868
118:14:521748877569771510
118:15:3617458884483749136
118:16:23287391568864135063
118:17:139724349413184810378
118:18:784008849485092547121
118:19:4126362365711013405900
118:20:20425493710269516359205
118:21:95318970647924409676290
118:22:420270006947666715390915
118:23:1754170463781565420762080
118:24:6943591419135363123849900
118:25:26107903735948965345675624
118:26:93385963363202068351839732
118:27:318204023311651492161824272
118:28:1034163075762867349525928884
118:29:3209471614436484877839089640
118:30:9521432456161571804255965932
118:31:27028582456200590928210483936
118:32:73483958552795356586072253201
118:33:191503649561830323224309508342
118:34:478759123904575808060773770855
118:35:1149021897370981939345857050052
118:36:2649133818938652804602948198731
118:37:5871053328458635945336263575566
118:38:12514613673819723988743088147917
118:39:25671002407835331258960180816240
118:40:50700229755474779236446357112074
118:41:96454095632366653181532094018092
118:42:176832508659338864166142172366502
118:43:312541178095575666898297793019864
118:44:532740644481094886758462147192950
118:45:876062393146689369336137753161740
118:46:1390272928254528781772566434365370
118:47:2129779804985661112502654963283120
118:48:3150299294874623728910177133189615
118:49:4500427564106605327014538761699450
118:50:6210590038467115351280063491145241
118:51:8280786717956153801706751321526988
118:52:10669475194289659706045237279659773
118:53:13286516279681463030169540763349906
118:54:15993028855172131425204076844773035
118:55:18610069940563934749328380328463168
118:56:20936328683134426592994427869521064
118:57:22772848743058499101151833822987824
118:58:23950754712527042158107963158659608
118:59:24356699707654619143838606602026720
118:60:23950754712527042158107963158659608
118:61:22772848743058499101151833822987824
118:62:20936328683134426592994427869521064
118:63:18610069940563934749328380328463168
118:64:15993028855172131425204076844773035
118:65:13286516279681463030169540763349906
118:66:10669475194289659706045237279659773
118:67:8280786717956153801706751321526988
118:68:6210590038467115351280063491145241
118:69:4500427564106605327014538761699450
118:70:3150299294874623728910177133189615
118:71:2129779804985661112502654963283120
118:72:1390272928254528781772566434365370
118:73:876062393146689369336137753161740
118:74:532740644481094886758462147192950
118:75:312541178095575666898297793019864
118:76:176832508659338864166142172366502
118:77:96454095632366653181532094018092
118:78:50700229755474779236446357112074
118:79:25671002407835331258960180816240
118:80:12514613673819723988743088147917
118:81:5871053328458635945336263575566
118:82:2649133818938652804602948198731
118:83:1149021897370981939345857050052
118:84:478759123904575808060773770855
118:85:191503649561830323224309508342
118:86:73483958552795356586072253201
118:87:27028582456200590928210483936
118:88:9521432456161571804255965932
118:89:3209471614436484877839089640
118:90:1034163075762867349525928884
118:91:318204023311651492161824272
118:92:93385963363202068351839732
118:93:26107903735948965345675624
118:94:6943591419135363123849900
118:95:1754170463781565420762080
118:96:420270006947666715390915
118:97:95318970647924409676290
118:98:20425493710269516359205
118:99:4126362365711013405900
118:100:784008849485092547121
118:101:139724349413184810378
118:102:23287391568864135063
118:103:3617458884483749136
118:104:521748877569771510
118:105:69566517009302868
118:106:8531742652084314
118:107:956830951635624
118:108:97455004333258
118:109:8940826085620
118:110:731522134278
118:111:52722315984
118:112:3295144749
118:113:174963438
118:114:7673835
118:115:266916
118:116:6903
118:117:118
118:118:1

# binomial(119, k) for 0 <= k <= 119

119:0:1
119:1:119
119:2:7021
119:3:273819
119:4:7940751
119:5:182637273
119:6:3470108187
119:7:56017460733
119:8:784244450262
119:9:9672348219898
119:10:106395830418878
119:11:1054285955968882
119:12:9488573603719938
119:13:78098259661387182
119:14:591315394579074378
119:15:4139207762053520646
119:16:26904850453347884199
119:17:163011740982048945441
119:18:923733198898277357499
119:19:4910371215196105953021
119:20:24551856075980529765105
119:21:115744464358193926035495
119:22:515588977595591125067205
119:23:2174440470729232136152995
119:24:8697761882916928544611980
119:25:33051495155084328469525524
119:26:119493867099151033697515356
119:27:411589986674853560513664004
119:28:1352367099074518841687753156
119:29:4243634690199352227365018524
119:30:12730904070598056682095055572
119:31:36550014912362162732466449868
119:32:100512541008995947514282737137
119:33:264987608114625679810381761543
119:34:670262773466406131285083279197
119:35:1627781021275557747406630820907
119:36:3798155716309634743948805248783
119:37:8520187147397288749939211774297
119:38:18385667002278359934079351723483
119:39:38185616081655055247703268964157
119:40:76371232163310110495406537928314
119:41:147154325387841432417978451130166
119:42:273286604291705517347674266384594
119:43:489373686754914531064439965386366
119:44:845281822576670553656759940212814
119:45:1408803037627784256094599900354690
119:46:2266335321401218151108704187527110
119:47:3520052733240189894275221397648490
119:48:5280079099860284841412832096472735
119:49:7650726858981229055924715894889065
119:50:10711017602573720678294602252844691
119:51:14491376756423269152986814812672229
119:52:18950261912245813507751988601186761
119:53:23955991473971122736214778043009679
119:54:29279545134853594455373617608122941
119:55:34603098795736066174532457173236203
119:56:39546398623698361342322808197984232
119:57:43709177426192925694146261692508888
119:58:46723603455585541259259796981647432
119:59:48307454420181661301946569760686328
119:60:48307454420181661301946569760686328
119:61:46723603455585541259259796981647432
119:62:43709177426192925694146261692508888
119:63:39546398623698361342322808197984232
119:64:34603098795736066174532457173236203
119:65:29279545134853594455373617608122941
119:66:23955991473971122736214778043009679
119:67:18950261912245813507751988601186761
119:68:14491376756423269152986814812672229
119:69:10711017602573720678294602252844691
119:70:7650726858981229055924715894889065
119:71:5280079099860284841412832096472735
119:72:3520052733240189894275221397648490
119:73:2266335321401218151108704187527110
119:74:1408803037627784256094599900354690
119:75:845281822576670553656759940212814
119:76:489373686754914531064439965386366
119:77:273286604291705517347674266384594
119:78:147154325387841432417978451130166
119:79:76371232163310110495406537928314
119:80:38185616081655055247703268964157
119:81:18385667002278359934079351723483
119:82:8520187147397288749939211774297
119:83:3798155716309634743948805248783
119:84:1627781021275557747406630820907
119:85:670262773466406131285083279197
119:86:264987608114625679810381761543
119:87:100512541008995947514282737137
119:88:36550014912362162732466449868
119:89:12730904070598056682095055572
119:90:4243634690199352227365018524
119:91:1352367099074518841687753156
119:92:411589986674853560513664004
119:93:119493867099151033697515356
119:94:33051495155084328469525524
119:95:8697761882916928544611980
119:96:2174440470729232136152995
119:97:515588977595591125067205
119:98:115744464358193926035495
119:99:24551856075980529765105
119:100:4910371215196105953021
119:101:923733198898277357499
119:102:163011740982048945441
119:103:26904850453347884199
119:104:4139207762053520646
119:105:591315394579074378
119:106:78098259661387182
119:107:9488573603719938
119:108:1054285955968882
119:109:106395830418878
119:110:9672348219898
119:111:784244450262
119:112:56017460733
119:113:3470108187
119:114:182637273
119:115:7940751
119:116:273819
119:117:7021
119:118:119
119:119:1

# binomial(120, k) for 0 <= k <= 120

120:0:1
120:1:120
120:2:7140
120:3:280840
120:4:8214570
120:5:190578024
120:6:3652745460
120:7:59487568920
120:8:840261910995
120:9:10456592670160
120:10:116068178638776
120:11:1160681786387760
120:12:10542859559688820
120:13:87586833265107120
120:14:669413654240461560
120:15:4730523156632595024
120:16:31044058215401404845
120:17:189916591435396829640
120:18:1086744939880326302940
120:19:5834104414094383310520
120:20:29462227291176635718126
120:21:140296320434174455800600
120:22:631333441953785051102700
120:23:2690029448324823261220200
120:24:10872202353646160680764975
120:25:41749257038001257014137504
120:26:152545362254235362167040880
120:27:531083853774004594211179360
120:28:1763957085749372402201417160
120:29:5596001789273871069052771680
120:30:16974538760797408909460074096
120:31:49280918982960219414561505440
120:32:137062555921358110246749187005
120:33:365500149123621627324664498680
120:34:935250381581031811095465040740
120:35:2298043794741963878691714100104
120:36:5425936737585192491355436069690
120:37:12318342863706923493888017023080
120:38:26905854149675648684018563497780
120:39:56571283083933415181782620687640
120:40:114556848244965165743109806892471
120:41:223525557551151542913384989058480
120:42:420440929679546949765652717514760
120:43:762660291046620048412114231770960
120:44:1334655509331585084721199905599180
120:45:2254084860204454809751359840567504
120:46:3675138359029002407203304087881800
120:47:5786388054641408045383925585175600
120:48:8800131833100474735688053494121225
120:49:12930805958841513897337547991361800
120:50:18361744461554949734219318147733756
120:51:25202394358996989831281417065516920
120:52:33441638668669082660738803413858990
120:53:42906253386216936243966766644196440
120:54:53235536608824717191588395651132620
120:55:63882643930589660629906074781359144
120:56:74149497419434427516855265371220435
120:57:83255576049891287036469069890493120
120:58:90432780881778466953406058674156320
120:59:95031057875767202561206366742333760
120:60:96614908840363322603893139521372656
120:61:95031057875767202561206366742333760
120:62:90432780881778466953406058674156320
120:63:83255576049891287036469069890493120
120:64:74149497419434427516855265371220435
120:65:63882643930589660629906074781359144
120:66:53235536608824717191588395651132620
120:67:42906253386216936243966766644196440
120:68:33441638668669082660738803413858990
120:69:25202394358996989831281417065516920
120:70:18361744461554949734219318147733756
120:71:12930805958841513897337547991361800
120:72:8800131833100474735688053494121225
120:73:5786388054641408045383925585175600
120:74:3675138359029002407203304087881800
120:75:2254084860204454809751359840567504
120:76:1334655509331585084721199905599180
120:77:762660291046620048412114231770960
120:78:420440929679546949765652717514760
120:79:223525557551151542913384989058480
120:80:114556848244965165743109806892471
120:81:56571283083933415181782620687640
120:82:26905854149675648684018563497780
120:83:12318342863706923493888017023080
120:84:5425936737585192491355436069690
120:85:2298043794741963878691714100104
120:86:935250381581031811095465040740
120:87:365500149123621627324664498680
120:88:137062555921358110246749187005
120:89:49280918982960219414561505440
120:90:16974538760797408909460074096
120:91:5596001789273871069052771680
120:92:1763957085749372402201417160
120:93:531083853774004594211179360
120:94:152545362254235362167040880
120:95:41749257038001257014137504
120:96:10872202353646160680764975
120:97:2690029448324823261220200
120:98:631333441953785051102700
120:99:140296320434174455800600
120:100:29462227291176635718126
120:101:5834104414094383310520
120:102:1086744939880326302940
120:103:189916591435396829640
120:104:31044058215401404845
120:105:4730523156632595024
120:106:669413654240461560
120:107:87586833265107120
120:108:10542859559688820
120:109:1160681786387760
120:110:116068178638776
120:111:10456592670160
120:112:840261910995
120:113:59487568920
120:114:3652745460
120:115:190578024
120:116:8214570
120:117:280840
120:118:7140
120:119:120
120:120:1

# binomial(121, k) for 0 <= k <= 121

121:0:1
121:1:121
121:2:7260
121:3:287980
121:4:8495410
121:5:198792594
121:6:3843323484
121:7:63140314380
121:8:899749479915
121:9:11296854581155
121:10:126524771308936
121:11:1276749965026536
121:12:11703541346076580
121:13:98129692824795940
121:14:757000487505568680
121:15:5399936810873056584
121:16:35774581372033999869
121:17:220960649650798234485
121:18:1276661531315723132580
121:19:6920849353974709613460
121:20:35296331705271019028646
121:21:169758547725351091518726
121:22:771629762387959506903300
121:23:3321362890278608312322900
121:24:13562231801970983941985175
121:25:52621459391647417694902479
121:26:194294619292236619181178384
121:27:683629216028239956378220240
121:28:2295040939523376996412596520
121:29:7359958875023243471254188840
121:30:22570540550071279978512845776
121:31:66255457743757628324021579536
121:32:186343474904318329661310692445
121:33:502562705044979737571413685685
121:34:1300750530704653438420129539420
121:35:3233294176322995689787179140844
121:36:7723980532327156370047150169794
121:37:17744279601292115985243453092770
121:38:39224197013382572177906580520860
121:39:83477137233609063865801184185420
121:40:171128131328898580924892427580111
121:41:338082405796116708656494795950951
121:42:643966487230698492679037706573240
121:43:1183101220726166998177766949285720
121:44:2097315800378205133133314137370140
121:45:3588740369536039894472559746166684
121:46:5929223219233457216954663928449304
121:47:9461526413670410452587229673057400
121:48:14586519887741882781071979079296825
121:49:21730937791941988633025601485483025
121:50:31292550420396463631556866139095556
121:51:43564138820551939565500735213250676
121:52:58644033027666072492020220479375910
121:53:76347892054886018904705570058055430
121:54:96141789995041653435555162295329060
121:55:117118180539414377821494470432491764
121:56:138032141350024088146761340152579579
121:57:157405073469325714553324335261713555
121:58:173688356931669753989875128564649440
121:59:185463838757545669514612425416490080
121:60:191645966716130525165099506263706416
121:61:191645966716130525165099506263706416
121:62:185463838757545669514612425416490080
121:63:173688356931669753989875128564649440
121:64:157405073469325714553324335261713555
121:65:138032141350024088146761340152579579
121:66:117118180539414377821494470432491764
121:67:96141789995041653435555162295329060
121:68:76347892054886018904705570058055430
121:69:58644033027666072492020220479375910
121:70:43564138820551939565500735213250676
121:71:31292550420396463631556866139095556
121:72:21730937791941988633025601485483025
121:73:14586519887741882781071979079296825
121:74:9461526413670410452587229673057400
121:75:5929223219233457216954663928449304
121:76:3588740369536039894472559746166684
121:77:2097315800378205133133314137370140
121:78:1183101220726166998177766949285720
121:79:643966487230698492679037706573240
121:80:338082405796116708656494795950951
121:81:171128131328898580924892427580111
121:82:83477137233609063865801184185420
121:83:39224197013382572177906580520860
121:84:17744279601292115985243453092770
121:85:7723980532327156370047150169794
121:86:3233294176322995689787179140844
121:87:1300750530704653438420129539420
121:88:502562705044979737571413685685
121:89:186343474904318329661310692445
121:90:66255457743757628324021579536
121:91:22570540550071279978512845776
121:92:7359958875023243471254188840
121:93:2295040939523376996412596520
121:94:683629216028239956378220240
121:95:194294619292236619181178384
121:96:52621459391647417694902479
121:97:13562231801970983941985175
121:98:3321362890278608312322900
121:99:771629762387959506903300
121:100:169758547725351091518726
121:101:35296331705271019028646
121:102:6920849353974709613460
121:103:1276661531315723132580
121:104:220960649650798234485
121:105:35774581372033999869
121:106:5399936810873056584
121:107:757000487505568680
121:108:98129692824795940
121:109:11703541346076580
121:110:1276749965026536
121:111:126524771308936
121:112:11296854581155
121:113:899749479915
121:114:63140314380
121:115:3843323484
121:116:198792594
121:117:8495410
121:118:287980
121:119:7260
121:120:121
121:121:1

# binomial(122, k) for 0 <= k <= 122

122:0:1
122:1:122
122:2:7381
122:3:295240
122:4:8783390
122:5:207288004
122:6:4042116078
122:7:66983637864
122:8:962889794295
122:9:12196604061070
122:10:137821625890091
122:11:1403274736335472
122:12:12980291311103116
122:13:109833234170872520
122:14:855130180330364620
122:15:6156937298378625264
122:16:41174518182907056453
122:17:256735231022832234354
122:18:1497622180966521367065
122:19:8197510885290432746040
122:20:42217181059245728642106
122:21:205054879430622110547372
122:22:941388310113310598422026
122:23:4092992652666567819226200
122:24:16883594692249592254308075
122:25:66183691193618401636887654
122:26:246916078683884036876080863
122:27:877923835320476575559398624
122:28:2978670155551616952790816760
122:29:9654999814546620467666785360
122:30:29930499425094523449767034616
122:31:88825998293828908302534425312
122:32:252598932648075957985332271981
122:33:688906179949298067232724378130
122:34:1803313235749633175991543225105
122:35:4534044707027649128207308680264
122:36:10957274708650152059834329310638
122:37:25468260133619272355290603262564
122:38:56968476614674688163150033613630
122:39:122701334246991636043707764706280
122:40:254605268562507644790693611765531
122:41:509210537125015289581387223531062
122:42:982048893026815201335532502524191
122:43:1827067707956865490856804655858960
122:44:3280417021104372131311081086655860
122:45:5686056169914245027605873883536824
122:46:9517963588769497111427223674615988
122:47:15390749632903867669541893601506704
122:48:24048046301412293233659208752354225
122:49:36317457679683871414097580564779850
122:50:53023488212338452264582467624578581
122:51:74856689240948403197057601352346232
122:52:102208171848218012057520955692626586
122:53:134991925082552091396725790537431340
122:54:172489682049927672340260732353384490
122:55:213259970534456031257049632727820824
122:56:255150321889438465968255810585071343
122:57:295437214819349802700085675414293134
122:58:331093430400995468543199463826362995
122:59:359152195689215423504487553981139520
122:60:377109805473676194679711931680196496
122:61:383291933432261050330199012527412832
122:62:377109805473676194679711931680196496
122:63:359152195689215423504487553981139520
122:64:331093430400995468543199463826362995
122:65:295437214819349802700085675414293134
122:66:255150321889438465968255810585071343
122:67:213259970534456031257049632727820824
122:68:172489682049927672340260732353384490
122:69:134991925082552091396725790537431340
122:70:102208171848218012057520955692626586
122:71:74856689240948403197057601352346232
122:72:53023488212338452264582467624578581
122:73:36317457679683871414097580564779850
122:74:24048046301412293233659208752354225
122:75:15390749632903867669541893601506704
122:76:9517963588769497111427223674615988
122:77:5686056169914245027605873883536824
122:78:3280417021104372131311081086655860
122:79:1827067707956865490856804655858960
122:80:982048893026815201335532502524191
122:81:509210537125015289581387223531062
122:82:254605268562507644790693611765531
122:83:122701334246991636043707764706280
122:84:56968476614674688163150033613630
122:85:25468260133619272355290603262564
122:86:10957274708650152059834329310638
122:87:4534044707027649128207308680264
122:88:1803313235749633175991543225105
122:89:688906179949298067232724378130
122:90:252598932648075957985332271981
122:91:88825998293828908302534425312
122:92:29930499425094523449767034616
122:93:9654999814546620467666785360
122:94:2978670155551616952790816760
122:95:877923835320476575559398624
122:96:246916078683884036876080863
122:97:66183691193618401636887654
122:98:16883594692249592254308075
122:99:4092992652666567819226200
122:100:941388310113310598422026
122:101:205054879430622110547372
122:102:42217181059245728642106
122:103:8197510885290432746040
122:104:1497622180966521367065
122:105:256735231022832234354
122:106:41174518182907056453
122:107:6156937298378625264
122:108:855130180330364620
122:109:109833234170872520
122:110:12980291311103116
122:111:1403274736335472
122:112:137821625890091
122:113:12196604061070
122:114:962889794295
122:115:66983637864
122:116:4042116078
122:117:207288004
122:118:8783390
122:119:295240
122:120:7381
122:121:122
122:122:1

# binomial(123, k) for 0 <= k <= 123

123:0:1
123:1:123
123:2:7503
123:3:302621
123:4:9078630
123:5:216071394
123:6:4249404082
123:7:71025753942
123:8:1029873432159
123:9:13159493855365
123:10:150018229951161
123:11:1541096362225563
123:12:14383566047438588
123:13:122813525481975636
123:14:964963414501237140
123:15:7012067478708989884
123:16:47331455481285681717
123:17:297909749205739290807
123:18:1754357411989353601419
123:19:9695133066256954113105
123:20:50414691944536161388146
123:21:247272060489867839189478
123:22:1146443189543932708969398
123:23:5034380962779878417648226
123:24:20976587344916160073534275
123:25:83067285885867993891195729
123:26:313099769877502438512968517
123:27:1124839914004360612435479487
123:28:3856593990872093528350215384
123:29:12633669970098237420457602120
123:30:39585499239641143917433819976
123:31:118756497718923431752301459928
123:32:341424930941904866287866697293
123:33:941505112597374025218056650111
123:34:2492219415698931243224267603235
123:35:6337357942777282304198851905369
123:36:15491319415677801188041637990902
123:37:36425534842269424415124932573202
123:38:82436736748293960518440636876194
123:39:179669810861666324206857798319910
123:40:377306602809499280834401376471811
123:41:763815805687522934372080835296593
123:42:1491259430151830490916919726055253
123:43:2809116600983680692192337158383151
123:44:5107484729061237622167885742514820
123:45:8966473191018617158916954970192684
123:46:15204019758683742139033097558152812
123:47:24908713221673364780969117276122692
123:48:39438795934316160903201102353860929
123:49:60365503981096164647756789317134075
123:50:89340945892022323678680048189358431
123:51:127880177453286855461640068976924813
123:52:177064861089166415254578557044972818
123:53:237200096930770103454246746230057926
123:54:307481607132479763736986522890815830
123:55:385749652584383703597310365081205314
123:56:468410292423894497225305443312892167
123:57:550587536708788268668341485999364477
123:58:626530645220345271243285139240656129
123:59:690245626090210892047687017807502515
123:60:736262001162891618184199485661336016
123:61:760401738905937245009910944207609328
123:62:760401738905937245009910944207609328
123:63:736262001162891618184199485661336016
123:64:690245626090210892047687017807502515
123:65:626530645220345271243285139240656129
123:66:550587536708788268668341485999364477
123:67:468410292423894497225305443312892167
123:68:385749652584383703597310365081205314
123:69:307481607132479763736986522890815830
123:70:237200096930770103454246746230057926
123:71:177064861089166415254578557044972818
123:72:127880177453286855461640068976924813
123:73:89340945892022323678680048189358431
123:74:60365503981096164647756789317134075
123:75:39438795934316160903201102353860929
123:76:24908713221673364780969117276122692
123:77:15204019758683742139033097558152812
123:78:8966473191018617158916954970192684
123:79:5107484729061237622167885742514820
123:80:2809116600983680692192337158383151
123:81:1491259430151830490916919726055253
123:82:763815805687522934372080835296593
123:83:377306602809499280834401376471811
123:84:179669810861666324206857798319910
123:85:82436736748293960518440636876194
123:86:36425534842269424415124932573202
123:87:15491319415677801188041637990902
123:88:6337357942777282304198851905369
123:89:2492219415698931243224267603235
123:90:941505112597374025218056650111
123:91:341424930941904866287866697293
123:92:118756497718923431752301459928
123:93:39585499239641143917433819976
123:94:12633669970098237420457602120
123:95:3856593990872093528350215384
123:96:1124839914004360612435479487
123:97:313099769877502438512968517
123:98:83067285885867993891195729
123:99:20976587344916160073534275
123:100:5034380962779878417648226
123:101:1146443189543932708969398
123:102:247272060489867839189478
123:103:50414691944536161388146
123:104:9695133066256954113105
123:105:1754357411989353601419
123:106:297909749205739290807
123:107:47331455481285681717
123:108:7012067478708989884
123:109:964963414501237140
123:110:122813525481975636
123:111:14383566047438588
123:112:1541096362225563
123:113:150018229951161
123:114:13159493855365
123:115:1029873432159
123:116:71025753942
123:117:4249404082
123:118:216071394
123:119:9078630
123:120:302621
123:121:7503
123:122:123
123:123:1

# binomial(124, k) for 0 <= k <= 124

124:0:1
124:1:124
124:2:7626
124:3:310124
124:4:9381251
124:5:225150024
124:6:4465475476
124:7:75275158024
124:8:1100899186101
124:9:14189367287524
124:10:163177723806526
124:11:1691114592176724
124:12:15924662409664151
124:13:137197091529414224
124:14:1087776939983212776
124:15:7977030893210227024
124:16:54343522959994671601
124:17:345241204687024972524
124:18:2052267161195092892226
124:19:11449490478246307714524
124:20:60109825010793115501251
124:21:297686752434404000577624
124:22:1393715250033800548158876
124:23:6180824152323811126617624
124:24:26010968307696038491182501
124:25:104043873230784153964730004
124:26:396167055763370432404164246
124:27:1437939683881863050948448004
124:28:4981433904876454140785694871
124:29:16490263960970330948807817504
124:30:52219169209739381337891422096
124:31:158341996958564575669735279904
124:32:460181428660828298040168157221
124:33:1282930043539278891505923347404
124:34:3433724528296305268442324253346
124:35:8829577358476213547423119508604
124:36:21828677358455083492240489896271
124:37:51916854257947225603166570564104
124:38:118862271590563384933565569449396
124:39:262106547609960284725298435196104
124:40:556976413671165605041259174791721
124:41:1141122408497022215206482211768404
124:42:2255075235839353425289000561351846
124:43:4300376031135511183109256884438404
124:44:7916601330044918314360222900897971
124:45:14073957920079854781084840712707504
124:46:24170492949702359297950052528345496
124:47:40112732980357106920002214834275504
124:48:64347509155989525684170219629983621
124:49:99804299915412325550957891670995004
124:50:149706449873118488326436837506492506
124:51:217221123345309179140320117166283244
124:52:304945038542453270716218626021897631
124:53:414264958019936518708825303275030744
124:54:544681704063249867191233269120873756
124:55:693231259716863467334296887972021144
124:56:854159945008278200822615808394097481
124:57:1018997829132682765893646929312256644
124:58:1177118181929133539911626625240020606
124:59:1316776271310556163290972157048158644
124:60:1426507627253102510231886503468838531
124:61:1496663740068828863194110429868945344
124:62:1520803477811874490019821888415218656
124:63:1496663740068828863194110429868945344
124:64:1426507627253102510231886503468838531
124:65:1316776271310556163290972157048158644
124:66:1177118181929133539911626625240020606
124:67:1018997829132682765893646929312256644
124:68:854159945008278200822615808394097481
124:69:693231259716863467334296887972021144
124:70:544681704063249867191233269120873756
124:71:414264958019936518708825303275030744
124:72:304945038542453270716218626021897631
124:73:217221123345309179140320117166283244
124:74:149706449873118488326436837506492506
124:75:99804299915412325550957891670995004
124:76:64347509155989525684170219629983621
124:77:40112732980357106920002214834275504
124:78:24170492949702359297950052528345496
124:79:14073957920079854781084840712707504
124:80:7916601330044918314360222900897971
124:81:4300376031135511183109256884438404
124:82:2255075235839353425289000561351846
124:83:1141122408497022215206482211768404
124:84:556976413671165605041259174791721
124:85:262106547609960284725298435196104
124:86:118862271590563384933565569449396
124:87:51916854257947225603166570564104
124:88:21828677358455083492240489896271
124:89:8829577358476213547423119508604
124:90:3433724528296305268442324253346
124:91:1282930043539278891505923347404
124:92:460181428660828298040168157221
124:93:158341996958564575669735279904
124:94:52219169209739381337891422096
124:95:16490263960970330948807817504
124:96:4981433904876454140785694871
124:97:1437939683881863050948448004
124:98:396167055763370432404164246
124:99:104043873230784153964730004
124:100:26010968307696038491182501
124:101:6180824152323811126617624
124:102:1393715250033800548158876
124:103:297686752434404000577624
124:104:60109825010793115501251
124:105:11449490478246307714524
124:106:2052267161195092892226
124:107:345241204687024972524
124:108:54343522959994671601
124:109:7977030893210227024
124:110:1087776939983212776
124:111:137197091529414224
124:112:15924662409664151
124:113:1691114592176724
124:114:163177723806526
124:115:14189367287524
124:116:1100899186101
124:117:75275158024
124:118:4465475476
124:119:225150024
124:120:9381251
124:121:310124
124:122:7626
124:123:124
124:124:1

# binomial(125, k) for 0 <= k <= 125

125:0:1
125:1:125
125:2:7750
125:3:317750
125:4:9691375
125:5:234531275
125:6:4690625500
125:7:79740633500
125:8:1176174344125
125:9:15290266473625
125:10:177367091094050
125:11:1854292315983250
125:12:17615777001840875
125:13:153121753939078375
125:14:1224974031512627000
125:15:9064807833193439800
125:16:62320553853204898625
125:17:399584727647019644125
125:18:2397508365882117864750
125:19:13501757639441400606750
125:20:71559315489039423215775
125:21:357796577445197116078875
125:22:1691402002468204548736500
125:23:7574539402357611674776500
125:24:32191792460019849617800125
125:25:130054841538480192455912505
125:26:500210928994154586368894250
125:27:1834106739645233483352612250
125:28:6419373588758317191734142875
125:29:21471697865846785089593512375
125:30:68709433170709712286699239600
125:31:210561166168303957007626702000
125:32:618523425619392873709903437125
125:33:1743111472200107189546091504625
125:34:4716654571835584159948247600750
125:35:12263301886772518815865443761950
125:36:30658254716931297039663609404875
125:37:73745531616402309095407060460375
125:38:170779125848510610536732140013500
125:39:380968819200523669658864004645500
125:40:819082961281125889766557609987825
125:41:1698098822168187820247741386560125
125:42:3396197644336375640495482773120250
125:43:6555451266974864608398257445790250
125:44:12216977361180429497469479785336375
125:45:21990559250124773095445063613605475
125:46:38244450869782214079034893241053000
125:47:64283225930059466217952267362621000
125:48:104460242136346632604172434464259125
125:49:164151809071401851235128111300978625
125:50:249510749788530813877394729177487510
125:51:366927573218427667466756954672775750
125:52:522166161887762449856538743188180875
125:53:719209996562389789425043929296928375
125:54:958946662083186385900058572395904500
125:55:1237912963780113334525530157092894900
125:56:1547391204725141668156912696366118625
125:57:1873157774140960966716262737706354125
125:58:2196116011061816305805273554552277250
125:59:2493894453239689703202598782288179250
125:60:2743283898563658673522858660516997175
125:61:2923171367321931373425996933337783875
125:62:3017467217880703353213932318284164000
125:63:3017467217880703353213932318284164000
125:64:2923171367321931373425996933337783875
125:65:2743283898563658673522858660516997175
125:66:2493894453239689703202598782288179250
125:67:2196116011061816305805273554552277250
125:68:1873157774140960966716262737706354125
125:69:1547391204725141668156912696366118625
125:70:1237912963780113334525530157092894900
125:71:958946662083186385900058572395904500
125:72:719209996562389789425043929296928375
125:73:522166161887762449856538743188180875
125:74:366927573218427667466756954672775750
125:75:249510749788530813877394729177487510
125:76:164151809071401851235128111300978625
125:77:104460242136346632604172434464259125
125:78:64283225930059466217952267362621000
125:79:38244450869782214079034893241053000
125:80:21990559250124773095445063613605475
125:81:12216977361180429497469479785336375
125:82:6555451266974864608398257445790250
125:83:3396197644336375640495482773120250
125:84:1698098822168187820247741386560125
125:85:819082961281125889766557609987825
125:86:380968819200523669658864004645500
125:87:170779125848510610536732140013500
125:88:73745531616402309095407060460375
125:89:30658254716931297039663609404875
125:90:12263301886772518815865443761950
125:91:4716654571835584159948247600750
125:92:1743111472200107189546091504625
125:93:618523425619392873709903437125
125:94:210561166168303957007626702000
125:95:68709433170709712286699239600
125:96:21471697865846785089593512375
125:97:6419373588758317191734142875
125:98:1834106739645233483352612250
125:99:500210928994154586368894250
125:100:130054841538480192455912505
125:101:32191792460019849617800125
125:102:7574539402357611674776500
125:103:1691402002468204548736500
125:104:357796577445197116078875
125:105:71559315489039423215775
125:106:13501757639441400606750
125:107:2397508365882117864750
125:108:399584727647019644125
125:109:62320553853204898625
125:110:9064807833193439800
125:111:1224974031512627000
125:112:153121753939078375
125:113:17615777001840875
125:114:1854292315983250
125:115:177367091094050
125:116:15290266473625
125:117:1176174344125
125:118:79740633500
125:119:4690625500
125:120:234531275
125:121:9691375
125:122:317750
125:123:7750
125:124:125
125:125:1

# binomial(126, k) for 0 <= k <= 126

126:0:1
126:1:126
126:2:7875
126:3:325500
126:4:10009125
126:5:244222650
126:6:4925156775
126:7:84431259000
126:8:1255914977625
126:9:16466440817750
126:10:192657357567675
126:11:2031659407077300
126:12:19470069317824125
126:13:170737530940919250
126:14:1378095785451705375
126:15:10289781864706066800
126:16:71385361686398338425
126:17:461905281500224542750
126:18:2797093093529137508875
126:19:15899266005323518471500
126:20:85061073128480823822525
126:21:429355892934236539294650
126:22:2049198579913401664815375
126:23:9265941404825816223513000
126:24:39766331862377461292576625
126:25:162246633998500042073712630
126:26:630265770532634778824806755
126:27:2334317668639388069721506500
126:28:8253480328403550675086755125
126:29:27891071454605102281327655250
126:30:90181131036556497376292751975
126:31:279270599339013669294325941600
126:32:829084591787696830717530139125
126:33:2361634897819500063255994941750
126:34:6459766044035691349494339105375
126:35:16979956458608102975813691362700
126:36:42921556603703815855529053166825
126:37:104403786333333606135070669865250
126:38:244524657464912919632139200473875
126:39:551747945049034280195596144659000
126:40:1200051780481649559425421614633325
126:41:2517181783449313710014298996547950
126:42:5094296466504563460743224159680375
126:43:9951648911311240248893740218910500
126:44:18772428628155294105867737231126625
126:45:34207536611305202592914543398941850
126:46:60235010119906987174479956854658475
126:47:102527676799841680296987160603674000
126:48:168743468066406098822124701826880125
126:49:268612051207748483839300545765237750
126:50:413662558859932665112522840478466135
126:51:616438323006958481344151683850263260
126:52:889093735106190117323295697860956625
126:53:1241376158450152239281582672485109250
126:54:1678156658645576175325102501692832875
126:55:2196859625863299720425588729488799400
126:56:2785304168505255002682442853459013525
126:57:3420548978866102634873175434072472750
126:58:4069273785202777272521536292258631375
126:59:4690010464301506009007872336840456500
126:60:5237178351803348376725457442805176425
126:61:5666455265885590046948855593854781050
126:62:5940638585202634726639929251621947875
126:63:6034934435761406706427864636568328000
126:64:5940638585202634726639929251621947875
126:65:5666455265885590046948855593854781050
126:66:5237178351803348376725457442805176425
126:67:4690010464301506009007872336840456500
126:68:4069273785202777272521536292258631375
126:69:3420548978866102634873175434072472750
126:70:2785304168505255002682442853459013525
126:71:2196859625863299720425588729488799400
126:72:1678156658645576175325102501692832875
126:73:1241376158450152239281582672485109250
126:74:889093735106190117323295697860956625
126:75:616438323006958481344151683850263260
126:76:413662558859932665112522840478466135
126:77:268612051207748483839300545765237750
126:78:168743468066406098822124701826880125
126:79:102527676799841680296987160603674000
126:80:60235010119906987174479956854658475
126:81:34207536611305202592914543398941850
126:82:18772428628155294105867737231126625
126:83:9951648911311240248893740218910500
126:84:5094296466504563460743224159680375
126:85:2517181783449313710014298996547950
126:86:1200051780481649559425421614633325
126:87:551747945049034280195596144659000
126:88:244524657464912919632139200473875
126:89:104403786333333606135070669865250
126:90:42921556603703815855529053166825
126:91:16979956458608102975813691362700
126:92:6459766044035691349494339105375
126:93:2361634897819500063255994941750
126:94:829084591787696830717530139125
126:95:279270599339013669294325941600
126:96:90181131036556497376292751975
126:97:27891071454605102281327655250
126:98:8253480328403550675086755125
126:99:2334317668639388069721506500
126:100:630265770532634778824806755
126:101:162246633998500042073712630
126:102:39766331862377461292576625
126:103:9265941404825816223513000
126:104:2049198579913401664815375
126:105:429355892934236539294650
126:106:85061073128480823822525
126:107:15899266005323518471500
126:108:2797093093529137508875
126:109:461905281500224542750
126:110:71385361686398338425
126:111:10289781864706066800
126:112:1378095785451705375
126:113:170737530940919250
126:114:19470069317824125
126:115:2031659407077300
126:116:192657357567675
126:117:16466440817750
126:118:1255914977625
126:119:84431259000
126:120:4925156775
126:121:244222650
126:122:10009125
126:123:325500
126:124:7875
126:125:126
126:126:1

# binomial(127, k) for 0 <= k <= 127

127:0:1
127:1:127
127:2:8001
127:3:333375
127:4:10334625
127:5:254231775
127:6:5169379425
127:7:89356415775
127:8:1340346236625
127:9:17722355795375
127:10:209123798385425
127:11:2224316764644975
127:12:21501728724901425
127:13:190207600258743375
127:14:1548833316392624625
127:15:11667877650157772175
127:16:81675143551104405225
127:17:533290643186622881175
127:18:3258998375029362051625
127:19:18696359098852655980375
127:20:100960339133804342294025
127:21:514416966062717363117175
127:22:2478554472847638204110025
127:23:11315139984739217888328375
127:24:49032273267203277516089625
127:25:202012965860877503366289255
127:26:792512404531134820898519385
127:27:2964583439172022848546313255
127:28:10587797997042938744808261625
127:29:36144551783008652956414410375
127:30:118072202491161599657620407225
127:31:369451730375570166670618693575
127:32:1108355191126710500011856080725
127:33:3190719489607196893973525080875
127:34:8821400941855191412750334047125
127:35:23439722502643794325308030468075
127:36:59901513062311918831342744529525
127:37:147325342937037421990599723032075
127:38:348928443798246525767209870339125
127:39:796272602513947199827735345132875
127:40:1751799725530683839621017759292325
127:41:3717233563930963269439720611181275
127:42:7611478249953877170757523156228325
127:43:15045945377815803709636964378590875
127:44:28724077539466534354761477450037125
127:45:52979965239460496698782280630068475
127:46:94442546731212189767394500253600325
127:47:162762686919748667471467117458332475
127:48:271271144866247779119111862430554125
127:49:437355519274154582661425247592117875
127:50:682274610067681148951823386243703885
127:51:1030100881866891146456674524328729395
127:52:1505532058113148598667447381711219885
127:53:2130469893556342356604878370346065875
127:54:2919532817095728414606685174177942125
127:55:3875016284508875895750691231181632275
127:56:4982163794368554723108031582947812925
127:57:6205853147371357637555618287531486275
127:58:7489822764068879907394711726331104125
127:59:8759284249504283281529408629099087875
127:60:9927188816104854385733329779645632925
127:61:10903633617688938423674313036659957475
127:62:11607093851088224773588784845476728925
127:63:11975573020964041433067793888190275875
127:64:11975573020964041433067793888190275875
127:65:11607093851088224773588784845476728925
127:66:10903633617688938423674313036659957475
127:67:9927188816104854385733329779645632925
127:68:8759284249504283281529408629099087875
127:69:7489822764068879907394711726331104125
127:70:6205853147371357637555618287531486275
127:71:4982163794368554723108031582947812925
127:72:3875016284508875895750691231181632275
127:73:2919532817095728414606685174177942125
127:74:2130469893556342356604878370346065875
127:75:1505532058113148598667447381711219885
127:76:1030100881866891146456674524328729395
127:77:682274610067681148951823386243703885
127:78:437355519274154582661425247592117875
127:79:271271144866247779119111862430554125
127:80:162762686919748667471467117458332475
127:81:94442546731212189767394500253600325
127:82:52979965239460496698782280630068475
127:83:28724077539466534354761477450037125
127:84:15045945377815803709636964378590875
127:85:7611478249953877170757523156228325
127:86:3717233563930963269439720611181275
127:87:1751799725530683839621017759292325
127:88:796272602513947199827735345132875
127:89:348928443798246525767209870339125
127:90:147325342937037421990599723032075
127:91:59901513062311918831342744529525
127:92:23439722502643794325308030468075
127:93:8821400941855191412750334047125
127:94:3190719489607196893973525080875
127:95:1108355191126710500011856080725
127:96:369451730375570166670618693575
127:97:118072202491161599657620407225
127:98:36144551783008652956414410375
127:99:10587797997042938744808261625
127:100:2964583439172022848546313255
127:101:792512404531134820898519385
127:102:202012965860877503366289255
127:103:49032273267203277516089625
127:104:11315139984739217888328375
127:105:2478554472847638204110025
127:106:514416966062717363117175
127:107:100960339133804342294025
127:108:18696359098852655980375
127:109:3258998375029362051625
127:110:533290643186622881175
127:111:81675143551104405225
127:112:11667877650157772175
127:113:1548833316392624625
127:114:190207600258743375
127:115:21501728724901425
127:116:2224316764644975
127:117:209123798385425
127:118:17722355795375
127:119:1340346236625
127:120:89356415775
127:121:5169379425
127:122:254231775
127:123:10334625
127:124:333375
127:125:8001
127:126:127
127:127:1

# binomial(128, k) for 0 <= k <= 128

128:0:1
128:1:128
128:2:8128
128:3:341376
128:4:10668000
128:5:264566400
128:6:5423611200
128:7:94525795200
128:8:1429702652400
128:9:19062702032000
128:10:226846154180800
128:11:2433440563030400
128:12:23726045489546400
128:13:211709328983644800
128:14:1739040916651368000
128:15:13216710966550396800
128:16:93343021201262177400
128:17:614965786737727286400
128:18:3792289018215984932800
128:19:21955357473882018032000
128:20:119656698232656998274400
128:21:615377305196521705411200
128:22:2992971438910355567227200
128:23:13793694457586856092438400
128:24:60347413251942495404418000
128:25:251045239128080780882378880
128:26:994525370392012324264808640
128:27:3757095843703157669444832640
128:28:13552381436214961593354574880
128:29:46732349780051591701222672000
128:30:154216754274170252614034817600
128:31:487523932866731766328239100800
128:32:1477806921502280666682474774300
128:33:4299074680733907393985381161600
128:34:12012120431462388306723859128000
128:35:32261123444498985738058364515200
128:36:83341235564955713156650774997600
128:37:207226855999349340821942467561600
128:38:496253786735283947757809593371200
128:39:1145201046312193725594945215472000
128:40:2548072328044631039448753104425200
128:41:5469033289461647109060738370473600
128:42:11328711813884840440197243767409600
128:43:22657423627769680880394487534819200
128:44:43770022917282338064398441828628000
128:45:81704042778927031053543758080105600
128:46:147422511970672686466176780883668800
128:47:257205233650960857238861617711932800
128:48:434033831785996446590578979888886600
128:49:708626664140402361780537110022672000
128:50:1119630129341835731613248633835821760
128:51:1712375491934572295408497910572433280
128:52:2535632939980039745124121906039949280
128:53:3636001951669490955272325752057285760
128:54:5050002710652070771211563544524008000
128:55:6794549101604604310357376405359574400
128:56:8857180078877430618858722814129445200
128:57:11188016941739912360663649870479299200
128:58:13695675911440237544950330013862590400
128:59:16249107013573163188924120355430192000
128:60:18686473065609137667262738408744720800
128:61:20830822433793792809407642816305590400
128:62:22510727468777163197263097882136686400
128:63:23582666872052266206656578733667004800
128:64:23951146041928082866135587776380551750
128:65:23582666872052266206656578733667004800
128:66:22510727468777163197263097882136686400
128:67:20830822433793792809407642816305590400
128:68:18686473065609137667262738408744720800
128:69:16249107013573163188924120355430192000
128:70:13695675911440237544950330013862590400
128:71:11188016941739912360663649870479299200
128:72:8857180078877430618858722814129445200
128:73:6794549101604604310357376405359574400
128:74:5050002710652070771211563544524008000
128:75:3636001951669490955272325752057285760
128:76:2535632939980039745124121906039949280
128:77:1712375491934572295408497910572433280
128:78:1119630129341835731613248633835821760
128:79:708626664140402361780537110022672000
128:80:434033831785996446590578979888886600
128:81:257205233650960857238861617711932800
128:82:147422511970672686466176780883668800
128:83:81704042778927031053543758080105600
128:84:43770022917282338064398441828628000
128:85:22657423627769680880394487534819200
128:86:11328711813884840440197243767409600
128:87:5469033289461647109060738370473600
128:88:2548072328044631039448753104425200
128:89:1145201046312193725594945215472000
128:90:496253786735283947757809593371200
128:91:207226855999349340821942467561600
128:92:83341235564955713156650774997600
128:93:32261123444498985738058364515200
128:94:12012120431462388306723859128000
128:95:4299074680733907393985381161600
128:96:1477806921502280666682474774300
128:97:487523932866731766328239100800
128:98:154216754274170252614034817600
128:99:46732349780051591701222672000
128:100:13552381436214961593354574880
128:101:3757095843703157669444832640
128:102:994525370392012324264808640
128:103:251045239128080780882378880
128:104:60347413251942495404418000
128:105:13793694457586856092438400
128:106:2992971438910355567227200
128:107:615377305196521705411200
128:108:119656698232656998274400
128:109:21955357473882018032000
128:110:3792289018215984932800
128:111:614965786737727286400
128:112:93343021201262177400
128:113:13216710966550396800
128:114:1739040916651368000
128:115:211709328983644800
128:116:23726045489546400
128:117:2433440563030400
128:118:226846154180800
128:119:19062702032000
128:120:1429702652400
128:121:94525795200
128:122:5423611200
128:123:264566400
128:124:10668000
128:125:341376
128:126:8128
128:127:128
128:128:1

# binomial(129, k) for 0 <= k <= 129

129:0:1
129:1:129
129:2:8256
129:3:349504
129:4:11009376
129:5:275234400
129:6:5688177600
129:7:99949406400
129:8:1524228447600
129:9:20492404684400
129:10:245908856212800
129:11:2660286717211200
129:12:26159486052576800
129:13:235435374473191200
129:14:1950750245635012800
129:15:14955751883201764800
129:16:106559732167812574200
129:17:708308807938989463800
129:18:4407254804953712219200
129:19:25747646492098002964800
129:20:141612055706539016306400
129:21:735034003429178703685600
129:22:3608348744106877272638400
129:23:16786665896497211659665600
129:24:74141107709529351496856400
129:25:311392652380023276286796880
129:26:1245570609520093105147187520
129:27:4751621214095169993709641280
129:28:17309477279918119262799407520
129:29:60284731216266553294577246880
129:30:200949104054221844315257489600
129:31:641740687140902018942273918400
129:32:1965330854369012433010713875100
129:33:5776881602236188060667855935900
129:34:16311195112196295700709240289600
129:35:44273243875961374044782223643200
129:36:115602359009454698894709139512800
129:37:290568091564305053978593242559200
129:38:703480642734633288579752060932800
129:39:1641454833047477673352754808843200
129:40:3693273374356824765043698319897200
129:41:8017105617506278148509491474898800
129:42:16797745103346487549257982137883200
129:43:33986135441654521320591731302228800
129:44:66427446545052018944792929363447200
129:45:125474065696209369117942199908733600
129:46:229126554749599717519720538963774400
129:47:404627745621633543705038398595601600
129:48:691239065436957303829440597600819400
129:49:1142660495926398808371116089911558600
129:50:1828256793482238093393785743858493760
129:51:2832005621276408027021746544408255040
129:52:4248008431914612040532619816612382560
129:53:6171634891649530700396447658097235040
129:54:8686004662321561726483889296581293760
129:55:11844551812256675081568939949883582400
129:56:15651729180482034929216099219489019600
129:57:20045197020617342979522372684608744400
129:58:24883692853180149905613979884341889600
129:59:29944782925013400733874450369292782400
129:60:34935580079182300856186858764174912800
129:61:39517295499402930476670381225050311200
129:62:43341549902570956006670740698442276800
129:63:46093394340829429403919676615803691200
129:64:47533812913980349072792166510047556550
129:65:47533812913980349072792166510047556550
129:66:46093394340829429403919676615803691200
129:67:43341549902570956006670740698442276800
129:68:39517295499402930476670381225050311200
129:69:34935580079182300856186858764174912800
129:70:29944782925013400733874450369292782400
129:71:24883692853180149905613979884341889600
129:72:20045197020617342979522372684608744400
129:73:15651729180482034929216099219489019600
129:74:11844551812256675081568939949883582400
129:75:8686004662321561726483889296581293760
129:76:6171634891649530700396447658097235040
129:77:4248008431914612040532619816612382560
129:78:2832005621276408027021746544408255040
129:79:1828256793482238093393785743858493760
129:80:1142660495926398808371116089911558600
129:81:691239065436957303829440597600819400
129:82:404627745621633543705038398595601600
129:83:229126554749599717519720538963774400
129:84:125474065696209369117942199908733600
129:85:66427446545052018944792929363447200
129:86:33986135441654521320591731302228800
129:87:16797745103346487549257982137883200
129:88:8017105617506278148509491474898800
129:89:3693273374356824765043698319897200
129:90:1641454833047477673352754808843200
129:91:703480642734633288579752060932800
129:92:290568091564305053978593242559200
129:93:115602359009454698894709139512800
129:94:44273243875961374044782223643200
129:95:16311195112196295700709240289600
129:96:5776881602236188060667855935900
129:97:1965330854369012433010713875100
129:98:641740687140902018942273918400
129:99:200949104054221844315257489600
129:100:60284731216266553294577246880
129:101:17309477279918119262799407520
129:102:4751621214095169993709641280
129:103:1245570609520093105147187520
129:104:311392652380023276286796880
129:105:74141107709529351496856400
129:106:16786665896497211659665600
129:107:3608348744106877272638400
129:108:735034003429178703685600
129:109:141612055706539016306400
129:110:25747646492098002964800
129:111:4407254804953712219200
129:112:708308807938989463800
129:113:106559732167812574200
129:114:14955751883201764800
129:115:1950750245635012800
129:116:235435374473191200
129:117:26159486052576800
129:118:2660286717211200
129:119:245908856212800
129:120:20492404684400
129:121:1524228447600
129:122:99949406400
129:123:5688177600
129:124:275234400
129:125:11009376
129:126:349504
129:127:8256
129:128:129
129:129:1

# binomial(130, k) for 0 <= k <= 130

130:0:1
130:1:130
130:2:8385
130:3:357760
130:4:11358880
130:5:286243776
130:6:5963412000
130:7:105637584000
130:8:1624177854000
130:9:22016633132000
130:10:266401260897200
130:11:2906195573424000
130:12:28819772769788000
130:13:261594860525768000
130:14:2186185620108204000
130:15:16906502128836777600
130:16:121515484051014339000
130:17:814868540106802038000
130:18:5115563612892701683000
130:19:30154901297051715184000
130:20:167359702198637019271200
130:21:876646059135717719992000
130:22:4343382747536055976324000
130:23:20395014640604088932304000
130:24:90927773606026563156522000
130:25:385533760089552627783653280
130:26:1556963261900116381433984400
130:27:5997191823615263098856828800
130:28:22061098494013289256509048800
130:29:77594208496184672557376654400
130:30:261233835270488397609834736480
130:31:842689791195123863257531408000
130:32:2607071541509914451952987793500
130:33:7742212456605200493678569811000
130:34:22088076714432483761377096225500
130:35:60584438988157669745491463932800
130:36:159875602885416072939491363156000
130:37:406170450573759752873302382072000
130:38:994048734298938342558345303492000
130:39:2344935475782110961932506869776000
130:40:5334728207404302438396453128740400
130:41:11710378991863102913553189794796000
130:42:24814850720852765697767473612782000
130:43:50783880545001008869849713440112000
130:44:100413581986706540265384660665676000
130:45:191901512241261388062735129272180800
130:46:354600620445809086637662738872508000
130:47:633754300371233261224758937559376000
130:48:1095866811058590847534478996196421000
130:49:1833899561363356112200556687512378000
130:50:2970917289408636901764901833770052360
130:51:4660262414758646120415532288266748800
130:52:7080014053191020067554366361020637600
130:53:10419643323564142740929067474709617600
130:54:14857639553971092426880336954678528800
130:55:20530556474578236808052829246464876160
130:56:27496280992738710010785039169372602000
130:57:35696926201099377908738471904097764000
130:58:44928889873797492885136352568950634000
130:59:54828475778193550639488430253634672000
130:60:64880363004195701590061309133467695200
130:61:74452875578585231332857239989225224000
130:62:82858845401973886483341121923492588000
130:63:89434944243400385410590417314245968000
130:64:93627207254809778476711843125851247750
130:65:95067625827960698145584333020095113100
130:66:93627207254809778476711843125851247750
130:67:89434944243400385410590417314245968000
130:68:82858845401973886483341121923492588000
130:69:74452875578585231332857239989225224000
130:70:64880363004195701590061309133467695200
130:71:54828475778193550639488430253634672000
130:72:44928889873797492885136352568950634000
130:73:35696926201099377908738471904097764000
130:74:27496280992738710010785039169372602000
130:75:20530556474578236808052829246464876160
130:76:14857639553971092426880336954678528800
130:77:10419643323564142740929067474709617600
130:78:7080014053191020067554366361020637600
130:79:4660262414758646120415532288266748800
130:80:2970917289408636901764901833770052360
130:81:1833899561363356112200556687512378000
130:82:1095866811058590847534478996196421000
130:83:633754300371233261224758937559376000
130:84:354600620445809086637662738872508000
130:85:191901512241261388062735129272180800
130:86:100413581986706540265384660665676000
130:87:50783880545001008869849713440112000
130:88:24814850720852765697767473612782000
130:89:11710378991863102913553189794796000
130:90:5334728207404302438396453128740400
130:91:2344935475782110961932506869776000
130:92:994048734298938342558345303492000
130:93:406170450573759752873302382072000
130:94:159875602885416072939491363156000
130:95:60584438988157669745491463932800
130:96:22088076714432483761377096225500
130:97:7742212456605200493678569811000
130:98:2607071541509914451952987793500
130:99:842689791195123863257531408000
130:100:261233835270488397609834736480
130:101:77594208496184672557376654400
130:102:22061098494013289256509048800
130:103:5997191823615263098856828800
130:104:1556963261900116381433984400
130:105:385533760089552627783653280
130:106:90927773606026563156522000
130:107:20395014640604088932304000
130:108:4343382747536055976324000
130:109:876646059135717719992000
130:110:167359702198637019271200
130:111:30154901297051715184000
130:112:5115563612892701683000
130:113:814868540106802038000
130:114:121515484051014339000
130:115:16906502128836777600
130:116:2186185620108204000
130:117:261594860525768000
130:118:28819772769788000
130:119:2906195573424000
130:120:266401260897200
130:121:22016633132000
130:122:1624177854000
130:123:105637584000
130:124:5963412000
130:125:286243776
130:126:11358880
130:127:357760
130:128:8385
130:129:130
130:130:1

# binomial(131, k) for 0 <= k <= 131

131:0:1
131:1:131
131:2:8515
131:3:366145
131:4:11716640
131:5:297602656
131:6:6249655776
131:7:111600996000
131:8:1729815438000
131:9:23640810986000
131:10:288417894029200
131:11:3172596834321200
131:12:31725968343212000
131:13:290414633295556000
131:14:2447780480633972000
131:15:19092687748944981600
131:16:138421986179851116600
131:17:936384024157816377000
131:18:5930432152999503721000
131:19:35270464909944416867000
131:20:197514603495688734455200
131:21:1044005761334354739263200
131:22:5220028806671773696316000
131:23:24738397388140144908628000
131:24:111322788246630652088826000
131:25:476461533695579190940175280
131:26:1942497021989669009217637680
131:27:7554155085515379480290813200
131:28:28058290317628552355365877600
131:29:99655306990197961813885703200
131:30:338828043766673070167211390880
131:31:1103923626465612260867366144480
131:32:3449761332705038315210519201500
131:33:10349283998115114945631557604500
131:34:29830289171037684255055666036500
131:35:82672515702590153506868560158300
131:36:220460041873573742684982827088800
131:37:566046053459175825812793745228000
131:38:1400219184872698095431647685564000
131:39:3338984210081049304490852173268000
131:40:7679663683186413400328959998516400
131:41:17045107199267405351949642923536400
131:42:36525229712715868611320663407578000
131:43:75598731265853774567617187052894000
131:44:151197462531707549135234374105788000
131:45:292315094227967928328119789937856800
131:46:546502132687070474700397868144688800
131:47:988354920817042347862421676431884000
131:48:1729621111429824108759237933755797000
131:49:2929766372421946959735035683708799000
131:50:4804816850771993013965458521282430360
131:51:7631179704167283022180434122036801160
131:52:11740276467949666187969898649287386400
131:53:17499657376755162808483433835730255200
131:54:25277282877535235167809404429388146400
131:55:35388196028549329234933166201143404960
131:56:48026837467316946818837868415837478160
131:57:63193207193838087919523511073470366000
131:58:80625816074896870793874824473048398000
131:59:99757365651991043524624782822585306000
131:60:119708838782389252229549739387102367200
131:61:139333238582780932922918549122692919200
131:62:157311720980559117816198361912717812000
131:63:172293789645374271893931539237738556000
131:64:183062151498210163887302260440097215750
131:65:188694833082770476622296176145946360850
131:66:188694833082770476622296176145946360850
131:67:183062151498210163887302260440097215750
131:68:172293789645374271893931539237738556000
131:69:157311720980559117816198361912717812000
131:70:139333238582780932922918549122692919200
131:71:119708838782389252229549739387102367200
131:72:99757365651991043524624782822585306000
131:73:80625816074896870793874824473048398000
131:74:63193207193838087919523511073470366000
131:75:48026837467316946818837868415837478160
131:76:35388196028549329234933166201143404960
131:77:25277282877535235167809404429388146400
131:78:17499657376755162808483433835730255200
131:79:11740276467949666187969898649287386400
131:80:7631179704167283022180434122036801160
131:81:4804816850771993013965458521282430360
131:82:2929766372421946959735035683708799000
131:83:1729621111429824108759237933755797000
131:84:988354920817042347862421676431884000
131:85:546502132687070474700397868144688800
131:86:292315094227967928328119789937856800
131:87:151197462531707549135234374105788000
131:88:75598731265853774567617187052894000
131:89:36525229712715868611320663407578000
131:90:17045107199267405351949642923536400
131:91:7679663683186413400328959998516400
131:92:3338984210081049304490852173268000
131:93:1400219184872698095431647685564000
131:94:566046053459175825812793745228000
131:95:220460041873573742684982827088800
131:96:82672515702590153506868560158300
131:97:29830289171037684255055666036500
131:98:10349283998115114945631557604500
131:99:3449761332705038315210519201500
131:100:1103923626465612260867366144480
131:101:338828043766673070167211390880
131:102:99655306990197961813885703200
131:103:28058290317628552355365877600
131:104:7554155085515379480290813200
131:105:1942497021989669009217637680
131:106:476461533695579190940175280
131:107:111322788246630652088826000
131:108:24738397388140144908628000
131:109:5220028806671773696316000
131:110:1044005761334354739263200
131:111:197514603495688734455200
131:112:35270464909944416867000
131:113:5930432152999503721000
131:114:936384024157816377000
131:115:138421986179851116600
131:116:19092687748944981600
131:117:2447780480633972000
131:118:290414633295556000
131:119:31725968343212000
131:120:3172596834321200
131:121:288417894029200
131:122:23640810986000
131:123:1729815438000
131:124:111600996000
131:125:6249655776
131:126:297602656
131:127:11716640
131:128:366145
131:129:8515
131:130:131
131:131:1

# binomial(132, k) for 0 <= k <= 132

132:0:1
132:1:132
132:2:8646
132:3:374660
132:4:12082785
132:5:309319296
132:6:6547258432
132:7:117850651776
132:8:1841416434000
132:9:25370626424000
132:10:312058705015200
132:11:3461014728350400
132:12:34898565177533200
132:13:322140601638768000
132:14:2738195113929528000
132:15:21540468229578953600
132:16:157514673928796098200
132:17:1074806010337667493600
132:18:6866816177157320098000
132:19:41200897062943920588000
132:20:232785068405633151322200
132:21:1241520364830043473718400
132:22:6264034568006128435579200
132:23:29958426194811918604944000
132:24:136061185634770796997454000
132:25:587784321942209843029001280
132:26:2418958555685248200157812960
132:27:9496652107505048489508450880
132:28:35612445403143931835656690800
132:29:127713597307826514169251580800
132:30:438483350756871031981097094080
132:31:1442751670232285331034577535360
132:32:4553684959170650576077885345980
132:33:13799045330820153260842076806000
132:34:40179573169152799200687223641000
132:35:112502804873627837761924226194800
132:36:303132557576163896191851387247100
132:37:786506095332749568497776572316800
132:38:1966265238331873921244441430792000
132:39:4739203394953747399922499858832000
132:40:11018647893267462704819812171784400
132:41:24724770882453818752278602922052800
132:42:53570336911983273963270306331114400
132:43:112123960978569643178937850460472000
132:44:226796193797561323702851561158682000
132:45:443512556759675477463354164043644800
132:46:838817226915038403028517658082545600
132:47:1534857053504112822562819544576572800
132:48:2717976032246866456621659610187681000
132:49:4659387483851771068494273617464596000
132:50:7734583223193939973700494204991229360
132:51:12435996554939276036145892643319231520
132:52:19371456172116949210150332771324187560
132:53:29239933844704828996453332485017641600
132:54:42776940254290397976292838265118401600
132:55:60665478906084564402742570630531551360
132:56:83415033495866276053771034616980883120
132:57:111220044661155034738361379489307844160
132:58:143819023268734958713398335546518764000
132:59:180383181726887914318499607295633704000
132:60:219466204434380295754174522209687673200
132:61:259042077365170185152468288509795286400
132:62:296644959563340050739116911035410731200
132:63:329605510625933389710129901150456368000
132:64:355355941143584435781233799677835771750
132:65:371756984580980640509598436586043576600
132:66:377389666165540953244592352291892721700
132:67:371756984580980640509598436586043576600
132:68:355355941143584435781233799677835771750
132:69:329605510625933389710129901150456368000
132:70:296644959563340050739116911035410731200
132:71:259042077365170185152468288509795286400
132:72:219466204434380295754174522209687673200
132:73:180383181726887914318499607295633704000
132:74:143819023268734958713398335546518764000
132:75:111220044661155034738361379489307844160
132:76:83415033495866276053771034616980883120
132:77:60665478906084564402742570630531551360
132:78:42776940254290397976292838265118401600
132:79:29239933844704828996453332485017641600
132:80:19371456172116949210150332771324187560
132:81:12435996554939276036145892643319231520
132:82:7734583223193939973700494204991229360
132:83:4659387483851771068494273617464596000
132:84:2717976032246866456621659610187681000
132:85:1534857053504112822562819544576572800
132:86:838817226915038403028517658082545600
132:87:443512556759675477463354164043644800
132:88:226796193797561323702851561158682000
132:89:112123960978569643178937850460472000
132:90:53570336911983273963270306331114400
132:91:24724770882453818752278602922052800
132:92:11018647893267462704819812171784400
132:93:4739203394953747399922499858832000
132:94:1966265238331873921244441430792000
132:95:786506095332749568497776572316800
132:96:303132557576163896191851387247100
132:97:112502804873627837761924226194800
132:98:40179573169152799200687223641000
132:99:13799045330820153260842076806000
132:100:4553684959170650576077885345980
132:101:1442751670232285331034577535360
132:102:438483350756871031981097094080
132:103:127713597307826514169251580800
132:104:35612445403143931835656690800
132:105:9496652107505048489508450880
132:106:2418958555685248200157812960
132:107:587784321942209843029001280
132:108:136061185634770796997454000
132:109:29958426194811918604944000
132:110:6264034568006128435579200
132:111:1241520364830043473718400
132:112:232785068405633151322200
132:113:41200897062943920588000
132:114:6866816177157320098000
132:115:1074806010337667493600
132:116:157514673928796098200
132:117:21540468229578953600
132:118:2738195113929528000
132:119:322140601638768000
132:120:34898565177533200
132:121:3461014728350400
132:122:312058705015200
132:123:25370626424000
132:124:1841416434000
132:125:117850651776
132:126:6547258432
132:127:309319296
132:128:12082785
132:129:374660
132:130:8646
132:131:132
132:132:1

# binomial(133, k) for 0 <= k <= 133

133:0:1
133:1:133
133:2:8778
133:3:383306
133:4:12457445
133:5:321402081
133:6:6856577728
133:7:124397910208
133:8:1959267085776
133:9:27212042858000
133:10:337429331439200
133:11:3773073433365600
133:12:38359579905883600
133:13:357039166816301200
133:14:3060335715568296000
133:15:24278663343508481600
133:16:179055142158375051800
133:17:1232320684266463591800
133:18:7941622187494987591600
133:19:48067713240101240686000
133:20:273985965468577071910200
133:21:1474305433235676625040600
133:22:7505554932836171909297600
133:23:36222460762818047040523200
133:24:166019611829582715602398000
133:25:723845507576980640026455280
133:26:3006742877627458043186814240
133:27:11915610663190296689666263840
133:28:45109097510648980325165141680
133:29:163326042710970446004908271600
133:30:566196948064697546150348674880
133:31:1881235020989156363015674629440
133:32:5996436629402935907112462881340
133:33:18352730289990803836919962151980
133:34:53978618499972952461529300447000
133:35:152682378042780636962611449835800
133:36:415635362449791733953775613441900
133:37:1089638652908913464689627959563900
133:38:2752771333664623489742218003108800
133:39:6705468633285621321166941289624000
133:40:15757851288221210104742312030616400
133:41:35743418775721281457098415093837200
133:42:78295107794437092715548909253167200
133:43:165694297890552917142208156791586400
133:44:338920154776130966881789411619154000
133:45:670308750557236801166205725202326800
133:46:1282329783674713880491871822126190400
133:47:2373674280419151225591337202659118400
133:48:4252833085750979279184479154764253800
133:49:7377363516098637525115933227652277000
133:50:12393970707045711042194767822455825360
133:51:20170579778133216009846386848310460880
133:52:31807452727056225246296225414643419080
133:53:48611390016821778206603665256341829160
133:54:72016874098995226972746170750136043200
133:55:103442419160374962379035408895649952960
133:56:144080512401950840456513605247512434480
133:57:194635078157021310792132414106288727280
133:58:255039067929889993451759715035826608160
133:59:324202204995622873031897942842152468000
133:60:399849386161268210072674129505321377200
133:61:478508281799550480906642810719482959600
133:62:555687036928510235891585199545206017600
133:63:626250470189273440449246812185867099200
133:64:684961451769517825491363700828292139750
133:65:727112925724565076290832236263879348350
133:66:749146650746521593754190788877936298300
133:67:749146650746521593754190788877936298300
133:68:727112925724565076290832236263879348350
133:69:684961451769517825491363700828292139750
133:70:626250470189273440449246812185867099200
133:71:555687036928510235891585199545206017600
133:72:478508281799550480906642810719482959600
133:73:399849386161268210072674129505321377200
133:74:324202204995622873031897942842152468000
133:75:255039067929889993451759715035826608160
133:76:194635078157021310792132414106288727280
133:77:144080512401950840456513605247512434480
133:78:103442419160374962379035408895649952960
133:79:72016874098995226972746170750136043200
133:80:48611390016821778206603665256341829160
133:81:31807452727056225246296225414643419080
133:82:20170579778133216009846386848310460880
133:83:12393970707045711042194767822455825360
133:84:7377363516098637525115933227652277000
133:85:4252833085750979279184479154764253800
133:86:2373674280419151225591337202659118400
133:87:1282329783674713880491871822126190400
133:88:670308750557236801166205725202326800
133:89:338920154776130966881789411619154000
133:90:165694297890552917142208156791586400
133:91:78295107794437092715548909253167200
133:92:35743418775721281457098415093837200
133:93:15757851288221210104742312030616400
133:94:6705468633285621321166941289624000
133:95:2752771333664623489742218003108800
133:96:1089638652908913464689627959563900
133:97:415635362449791733953775613441900
133:98:152682378042780636962611449835800
133:99:53978618499972952461529300447000
133:100:18352730289990803836919962151980
133:101:5996436629402935907112462881340
133:102:1881235020989156363015674629440
133:103:566196948064697546150348674880
133:104:163326042710970446004908271600
133:105:45109097510648980325165141680
133:106:11915610663190296689666263840
133:107:3006742877627458043186814240
133:108:723845507576980640026455280
133:109:166019611829582715602398000
133:110:36222460762818047040523200
133:111:7505554932836171909297600
133:112:1474305433235676625040600
133:113:273985965468577071910200
133:114:48067713240101240686000
133:115:7941622187494987591600
133:116:1232320684266463591800
133:117:179055142158375051800
133:118:24278663343508481600
133:119:3060335715568296000
133:120:357039166816301200
133:121:38359579905883600
133:122:3773073433365600
133:123:337429331439200
133:124:27212042858000
133:125:1959267085776
133:126:124397910208
133:127:6856577728
133:128:321402081
133:129:12457445
133:130:383306
133:131:8778
133:132:133
133:133:1

# binomial(134, k) for 0 <= k <= 134

134:0:1
134:1:134
134:2:8911
134:3:392084
134:4:12840751
134:5:333859526
134:6:7177979809
134:7:131254487936
134:8:2083664995984
134:9:29171309943776
134:10:364641374297200
134:11:4110502764804800
134:12:42132653339249200
134:13:395398746722184800
134:14:3417374882384597200
134:15:27338999059076777600
134:16:203333805501883533400
134:17:1411375826424838643600
134:18:9173942871761451183400
134:19:56009335427596228277600
134:20:322053678708678312596200
134:21:1748291398704253696950800
134:22:8979860366071848534338200
134:23:43728015695654218949820800
134:24:202242072592400762642921200
134:25:889865119406563355628853280
134:26:3730588385204438683213269520
134:27:14922353540817754732853078080
134:28:57024708173839277014831405520
134:29:208435140221619426330073413280
134:30:729522990775667992155256946480
134:31:2447431969053853909166023304320
134:32:7877671650392092270128137510780
134:33:24349166919393739744032425033320
134:34:72331348789963756298449262598980
134:35:206660996542753589424140750282800
134:36:568317740492572370916387063277700
134:37:1505274015358705198643403573005800
134:38:3842409986573536954431845962672700
134:39:9458239966950244810909159292732800
134:40:22463319921506831425909253320240400
134:41:51501270063942491561840727124453600
134:42:114038526570158374172647324347004400
134:43:243989405684990009857757066044753600
134:44:504614452666683884023997568410740400
134:45:1009228905333367768047995136821480800
134:46:1952638534231950681658077547328517200
134:47:3656004064093865106083209024785308800
134:48:6626507366170130504775816357423372200
134:49:11630196601849616804300412382416530800
134:50:19771334223144348567310701050108102360
134:51:32564550485178927052041154670766286240
134:52:51978032505189441256142612262953879960
134:53:80418842743878003452899890670985248240
134:54:120628264115817005179349836006477872360
134:55:175459293259370189351781579645785996160
134:56:247522931562325802835549014143162387440
134:57:338715590558972151248646019353801161760
134:58:449674146086911304243892129142115335440
134:59:579241272925512866483657657877979076160
134:60:724051591156891083104572072347473845200
134:61:878357667960818690979316940224804336800
134:62:1034195318728060716798228010264688977200
134:63:1181937507117783676340832011731073116800
134:64:1311211921958791265940610513014159238950
134:65:1412074377494082901782195937092171488100
134:66:1476259576471086670045023025141815646650
134:67:1498293301493043187508381577755872596600
134:68:1476259576471086670045023025141815646650
134:69:1412074377494082901782195937092171488100
134:70:1311211921958791265940610513014159238950
134:71:1181937507117783676340832011731073116800
134:72:1034195318728060716798228010264688977200
134:73:878357667960818690979316940224804336800
134:74:724051591156891083104572072347473845200
134:75:579241272925512866483657657877979076160
134:76:449674146086911304243892129142115335440
134:77:338715590558972151248646019353801161760
134:78:247522931562325802835549014143162387440
134:79:175459293259370189351781579645785996160
134:80:120628264115817005179349836006477872360
134:81:80418842743878003452899890670985248240
134:82:51978032505189441256142612262953879960
134:83:32564550485178927052041154670766286240
134:84:19771334223144348567310701050108102360
134:85:11630196601849616804300412382416530800
134:86:6626507366170130504775816357423372200
134:87:3656004064093865106083209024785308800
134:88:1952638534231950681658077547328517200
134:89:1009228905333367768047995136821480800
134:90:504614452666683884023997568410740400
134:91:243989405684990009857757066044753600
134:92:114038526570158374172647324347004400
134:93:51501270063942491561840727124453600
134:94:22463319921506831425909253320240400
134:95:9458239966950244810909159292732800
134:96:3842409986573536954431845962672700
134:97:1505274015358705198643403573005800
134:98:568317740492572370916387063277700
134:99:206660996542753589424140750282800
134:100:72331348789963756298449262598980
134:101:24349166919393739744032425033320
134:102:7877671650392092270128137510780
134:103:2447431969053853909166023304320
134:104:729522990775667992155256946480
134:105:208435140221619426330073413280
134:106:57024708173839277014831405520
134:107:14922353540817754732853078080
134:108:3730588385204438683213269520
134:109:889865119406563355628853280
134:110:202242072592400762642921200
134:111:43728015695654218949820800
134:112:8979860366071848534338200
134:113:1748291398704253696950800
134:114:322053678708678312596200
134:115:56009335427596228277600
134:116:9173942871761451183400
134:117:1411375826424838643600
134:118:203333805501883533400
134:119:27338999059076777600
134:120:3417374882384597200
134:121:395398746722184800
134:122:42132653339249200
134:123:4110502764804800
134:124:364641374297200
134:125:29171309943776
134:126:2083664995984
134:127:131254487936
134:128:7177979809
134:129:333859526
134:130:12840751
134:131:392084
134:132:8911
134:133:134
134:134:1

# binomial(135, k) for 0 <= k <= 135

135:0:1
135:1:135
135:2:9045
135:3:400995
135:4:13232835
135:5:346700277
135:6:7511839335
135:7:138432467745
135:8:2214919483920
135:9:31254974939760
135:10:393812684240976
135:11:4475144139102000
135:12:46243156104054000
135:13:437531400061434000
135:14:3812773629106782000
135:15:30756373941461374800
135:16:230672804560960311000
135:17:1614709631926722177000
135:18:10585318698186289827000
135:19:65183278299357679461000
135:20:378063014136274540873800
135:21:2070345077412932009547000
135:22:10728151764776102231289000
135:23:52707876061726067484159000
135:24:245970088288054981592742000
135:25:1092107191998964118271774480
135:26:4620453504611002038842122800
135:27:18652941926022193416066347600
135:28:71947061714657031747684483600
135:29:265459848395458703344904818800
135:30:937958130997287418485330359760
135:31:3176954959829521901321280250800
135:32:10325103619445946179294160815100
135:33:32226838569785832014160562544100
135:34:96680515709357496042481687632300
135:35:278992345332717345722590012881780
135:36:774978737035325960340527813560500
135:37:2073591755851277569559790636283500
135:38:5347684001932242153075249535678500
135:39:13300649953523781765341005255405500
135:40:31921559888457076236818412612973200
135:41:73964589985449322987749980444694000
135:42:165539796634100865734488051471458000
135:43:358027932255148384030404390391758000
135:44:748603858351673893881754634455494000
135:45:1513843358000051652071992705232221200
135:46:2961867439565318449706072684149998000
135:47:5608642598325815787741286572113826000
135:48:10282511430263995610859025382208681000
135:49:18256703968019747309076228739839903000
135:50:31401530824993965371611113432524633160
135:51:52335884708323275619351855720874388600
135:52:84542582990368368308183766933720166200
135:53:132396875249067444709042502933939128200
135:54:201047106859695008632249726677463120600
135:55:296087557375187194531131415652263868520
135:56:422982224821695992187330593788948383600
135:57:586238522121297954084195033496963549200
135:58:788389736645883455492538148495916497200
135:59:1028915419012424170727549787020094411600
135:60:1303292864082403949588229730225452921360
135:61:1602409259117709774083889012572278182000
135:62:1912552986688879407777544950489493314000
135:63:2216132825845844393139060021995762094000
135:64:2493149429076574942281442524745232355750
135:65:2723286299452874167722806450106330727050
135:66:2888333953965169571827218962233987134750
135:67:2974552877964129857553404602897688243250
135:68:2974552877964129857553404602897688243250
135:69:2888333953965169571827218962233987134750
135:70:2723286299452874167722806450106330727050
135:71:2493149429076574942281442524745232355750
135:72:2216132825845844393139060021995762094000
135:73:1912552986688879407777544950489493314000
135:74:1602409259117709774083889012572278182000
135:75:1303292864082403949588229730225452921360
135:76:1028915419012424170727549787020094411600
135:77:788389736645883455492538148495916497200
135:78:586238522121297954084195033496963549200
135:79:422982224821695992187330593788948383600
135:80:296087557375187194531131415652263868520
135:81:201047106859695008632249726677463120600
135:82:132396875249067444709042502933939128200
135:83:84542582990368368308183766933720166200
135:84:52335884708323275619351855720874388600
135:85:31401530824993965371611113432524633160
135:86:18256703968019747309076228739839903000
135:87:10282511430263995610859025382208681000
135:88:5608642598325815787741286572113826000
135:89:2961867439565318449706072684149998000
135:90:1513843358000051652071992705232221200
135:91:748603858351673893881754634455494000
135:92:358027932255148384030404390391758000
135:93:165539796634100865734488051471458000
135:94:73964589985449322987749980444694000
135:95:31921559888457076236818412612973200
135:96:13300649953523781765341005255405500
135:97:5347684001932242153075249535678500
135:98:2073591755851277569559790636283500
135:99:774978737035325960340527813560500
135:100:278992345332717345722590012881780
135:101:96680515709357496042481687632300
135:102:32226838569785832014160562544100
135:103:10325103619445946179294160815100
135:104:3176954959829521901321280250800
135:105:937958130997287418485330359760
135:106:265459848395458703344904818800
135:107:71947061714657031747684483600
135:108:18652941926022193416066347600
135:109:4620453504611002038842122800
135:110:1092107191998964118271774480
135:111:245970088288054981592742000
135:112:52707876061726067484159000
135:113:10728151764776102231289000
135:114:2070345077412932009547000
135:115:378063014136274540873800
135:116:65183278299357679461000
135:117:10585318698186289827000
135:118:1614709631926722177000
135:119:230672804560960311000
135:120:30756373941461374800
135:121:3812773629106782000
135:122:437531400061434000
135:123:46243156104054000
135:124:4475144139102000
135:125:393812684240976
135:126:31254974939760
135:127:2214919483920
135:128:138432467745
135:129:7511839335
135:130:346700277
135:131:13232835
135:132:400995
135:133:9045
135:134:135
135:135:1

# binomial(136, k) for 0 <= k <= 136

136:0:1
136:1:136
136:2:9180
136:3:410040
136:4:13633830
136:5:359933112
136:6:7858539612
136:7:145944307080
136:8:2353351951665
136:9:33469894423680
136:10:425067659180736
136:11:4868956823342976
136:12:50718300243156000
136:13:483774556165488000
136:14:4250305029168216000
136:15:34569147570568156800
136:16:261429178502421685800
136:17:1845382436487682488000
136:18:12200028330113012004000
136:19:75768596997543969288000
136:20:443246292435632220334800
136:21:2448408091549206550420800
136:22:12798496842189034240836000
136:23:63436027826502169715448000
136:24:298677964349781049076901000
136:25:1338077280287019099864516480
136:26:5712560696609966157113897280
136:27:23273395430633195454908470400
136:28:90600003640679225163750831200
136:29:337406910110115735092589302400
136:30:1203417979392746121830235178560
136:31:4114913090826809319806610610560
136:32:13502058579275468080615441065900
136:33:42551942189231778193454723359200
136:34:128907354279143328056642250176400
136:35:375672861042074841765071700514080
136:36:1053971082368043306063117826442280
136:37:2848570492886603529900318449844000
136:38:7421275757783519722635040171962000
136:39:18648333955456023918416254791084000
136:40:45222209841980858002159417868378700
136:41:105886149873906399224568393057667200
136:42:239504386619550188722238031916152000
136:43:523567728889249249764892441863216000
136:44:1106631790606822277912159024847252000
136:45:2262447216351725545953747339687715200
136:46:4475710797565370101778065389382219200
136:47:8570510037891134237447359256263824000
136:48:15891154028589811398600311954322507000
136:49:28539215398283742919935254122048584000
136:50:49658234793013712680687342172364536160
136:51:83737415533317240990962969153399021760
136:52:136878467698691643927535622654594554800
136:53:216939458239435813017226269867659294400
136:54:333443982108762453341292229611402248800
136:55:497134664234882203163381142329726989120
136:56:719069782196883186718462009441212252120
136:57:1009220746942993946271525627285911932800
136:58:1374628258767181409576733181992880046400
136:59:1817305155658307626220087935516010908800
136:60:2332208283094828120315779517245547332960
136:61:2905702123200113723672118742797731103360
136:62:3514962245806589181861433963061771496000
136:63:4128685812534723800916604972485255408000
136:64:4709282254922419335420502546740994449750
136:65:5216435728529449110004248974851563082800
136:66:5611620253418043739550025412340317861800
136:67:5862886831929299429380623565131675378000
136:68:5949105755928259715106809205795376486500
136:69:5862886831929299429380623565131675378000
136:70:5611620253418043739550025412340317861800
136:71:5216435728529449110004248974851563082800
136:72:4709282254922419335420502546740994449750
136:73:4128685812534723800916604972485255408000
136:74:3514962245806589181861433963061771496000
136:75:2905702123200113723672118742797731103360
136:76:2332208283094828120315779517245547332960
136:77:1817305155658307626220087935516010908800
136:78:1374628258767181409576733181992880046400
136:79:1009220746942993946271525627285911932800
136:80:719069782196883186718462009441212252120
136:81:497134664234882203163381142329726989120
136:82:333443982108762453341292229611402248800
136:83:216939458239435813017226269867659294400
136:84:136878467698691643927535622654594554800
136:85:83737415533317240990962969153399021760
136:86:49658234793013712680687342172364536160
136:87:28539215398283742919935254122048584000
136:88:15891154028589811398600311954322507000
136:89:8570510037891134237447359256263824000
136:90:4475710797565370101778065389382219200
136:91:2262447216351725545953747339687715200
136:92:1106631790606822277912159024847252000
136:93:523567728889249249764892441863216000
136:94:239504386619550188722238031916152000
136:95:105886149873906399224568393057667200
136:96:45222209841980858002159417868378700
136:97:18648333955456023918416254791084000
136:98:7421275757783519722635040171962000
136:99:2848570492886603529900318449844000
136:100:1053971082368043306063117826442280
136:101:375672861042074841765071700514080
136:102:128907354279143328056642250176400
136:103:42551942189231778193454723359200
136:104:13502058579275468080615441065900
136:105:4114913090826809319806610610560
136:106:1203417979392746121830235178560
136:107:337406910110115735092589302400
136:108:90600003640679225163750831200
136:109:23273395430633195454908470400
136:110:5712560696609966157113897280
136:111:1338077280287019099864516480
136:112:298677964349781049076901000
136:113:63436027826502169715448000
136:114:12798496842189034240836000
136:115:2448408091549206550420800
136:116:443246292435632220334800
136:117:75768596997543969288000
136:118:12200028330113012004000
136:119:1845382436487682488000
136:120:261429178502421685800
136:121:34569147570568156800
136:122:4250305029168216000
136:123:483774556165488000
136:124:50718300243156000
136:125:4868956823342976
136:126:425067659180736
136:127:33469894423680
136:128:2353351951665
136:129:145944307080
136:130:7858539612
136:131:359933112
136:132:13633830
136:133:410040
136:134:9180
136:135:136
136:136:1

# binomial(137, k) for 0 <= k <= 137

137:0:1
137:1:137
137:2:9316
137:3:419220
137:4:14043870
137:5:373566942
137:6:8218472724
137:7:153802846692
137:8:2499296258745
137:9:35823246375345
137:10:458537553604416
137:11:5294024482523712
137:12:55587257066498976
137:13:534492856408644000
137:14:4734079585333704000
137:15:38819452599736372800
137:16:295998326072989842600
137:17:2106811614990104173800
137:18:14045410766600694492000
137:19:87968625327656981292000
137:20:519014889433176189622800
137:21:2891654383984838770755600
137:22:15246904933738240791256800
137:23:76234524668691203956284000
137:24:362113992176283218792349000
137:25:1636755244636800148941417480
137:26:7050637976896985256978413760
137:27:28985956127243161612022367680
137:28:113873399071312420618659301600
137:29:428006913750794960256340133600
137:30:1540824889502861856922824480960
137:31:5318331070219555441636845789120
137:32:17616971670102277400422051676460
137:33:56054000768507246274070164425100
137:34:171459296468375106250096973535600
137:35:504580215321218169821713950690480
137:36:1429643943410118147828189526956360
137:37:3902541575254646835963436276286280
137:38:10269846250670123252535358621806000
137:39:26069609713239543641051294963046000
137:40:63870543797436881920575672659462700
137:41:151108359715887257226727810926045900
137:42:345390536493456587946806424973819200
137:43:763072115508799438487130473779368000
137:44:1630199519496071527677051466710468000
137:45:3369079006958547823865906364534967200
137:46:6738158013917095647731812729069934400
137:47:13046220835456504339225424645646043200
137:48:24461664066480945636047671210586331000
137:49:44430369426873554318535566076371091000
137:50:78197450191297455600622596294413120160
137:51:133395650326330953671650311325763557920
137:52:220615883232008884918498591807993576560
137:53:353817925938127456944761892522253849200
137:54:550383440348198266358518499479061543200
137:55:830578646343644656504673371941129237920
137:56:1216204446431765389881843151770939241240
137:57:1728290529139877132989987636727124184920
137:58:2383849005710175355848258809278791979200
137:59:3191933414425489035796821117508890955200
137:60:4149513438753135746535867452761558241760
137:61:5237910406294941843987898260043278436320
137:62:6420664369006702905533552705859502599360
137:63:7643648058341312982778038935547026904000
137:64:8837968067457143136337107519226249857750
137:65:9925717983451868445424751521592557532550
137:66:10828055981947492849554274387191880944600
137:67:11474507085347343168930648977471993239800
137:68:11811992587857559144487432770927051864500
137:69:11811992587857559144487432770927051864500
137:70:11474507085347343168930648977471993239800
137:71:10828055981947492849554274387191880944600
137:72:9925717983451868445424751521592557532550
137:73:8837968067457143136337107519226249857750
137:74:7643648058341312982778038935547026904000
137:75:6420664369006702905533552705859502599360
137:76:5237910406294941843987898260043278436320
137:77:4149513438753135746535867452761558241760
137:78:3191933414425489035796821117508890955200
137:79:2383849005710175355848258809278791979200
137:80:1728290529139877132989987636727124184920
137:81:1216204446431765389881843151770939241240
137:82:830578646343644656504673371941129237920
137:83:550383440348198266358518499479061543200
137:84:353817925938127456944761892522253849200
137:85:220615883232008884918498591807993576560
137:86:133395650326330953671650311325763557920
137:87:78197450191297455600622596294413120160
137:88:44430369426873554318535566076371091000
137:89:24461664066480945636047671210586331000
137:90:13046220835456504339225424645646043200
137:91:6738158013917095647731812729069934400
137:92:3369079006958547823865906364534967200
137:93:1630199519496071527677051466710468000
137:94:763072115508799438487130473779368000
137:95:345390536493456587946806424973819200
137:96:151108359715887257226727810926045900
137:97:63870543797436881920575672659462700
137:98:26069609713239543641051294963046000
137:99:10269846250670123252535358621806000
137:100:3902541575254646835963436276286280
137:101:1429643943410118147828189526956360
137:102:504580215321218169821713950690480
137:103:171459296468375106250096973535600
137:104:56054000768507246274070164425100
137:105:17616971670102277400422051676460
137:106:5318331070219555441636845789120
137:107:1540824889502861856922824480960
137:108:428006913750794960256340133600
137:109:113873399071312420618659301600
137:110:28985956127243161612022367680
137:111:7050637976896985256978413760
137:112:1636755244636800148941417480
137:113:362113992176283218792349000
137:114:76234524668691203956284000
137:115:15246904933738240791256800
137:116:2891654383984838770755600
137:117:519014889433176189622800
137:118:87968625327656981292000
137:119:14045410766600694492000
137:120:2106811614990104173800
137:121:295998326072989842600
137:122:38819452599736372800
137:123:4734079585333704000
137:124:534492856408644000
137:125:55587257066498976
137:126:5294024482523712
137:127:458537553604416
137:128:35823246375345
137:129:2499296258745
137:130:153802846692
137:131:8218472724
137:132:373566942
137:133:14043870
137:134:419220
137:135:9316
137:136:137
137:137:1

# binomial(138, k) for 0 <= k <= 138

138:0:1
138:1:138
138:2:9453
138:3:428536
138:4:14463090
138:5:387610812
138:6:8592039666
138:7:162021319416
138:8:2653099105437
138:9:38322542634090
138:10:494360799979761
138:11:5752562036128128
138:12:60881281549022688
138:13:590080113475142976
138:14:5268572441742348000
138:15:43553532185070076800
138:16:334817778672726215400
138:17:2402809941063094016400
138:18:16152222381590798665800
138:19:102014036094257675784000
138:20:606983514760833170914800
138:21:3410669273418014960378400
138:22:18138559317723079562012400
138:23:91481429602429444747540800
138:24:438348516844974422748633000
138:25:1998869236813083367733766480
138:26:8687393221533785405919831240
138:27:36036594104140146869000781440
138:28:142859355198555582230681669280
138:29:541880312822107380874999435200
138:30:1968831803253656817179164614560
138:31:6859155959722417298559670270080
138:32:22935302740321832842058897465580
138:33:73670972438609523674492216101560
138:34:227513297236882352524167137960700
138:35:676039511789593276071810924226080
138:36:1934224158731336317649903477646840
138:37:5332185518664764983791625803242640
138:38:14172387825924770088498794898092280
138:39:36339455963909666893586653584852000
138:40:89940153510676425561626967622508700
138:41:214978903513324139147303483585508600
138:42:496498896209343845173534235899865100
138:43:1108462652002256026433936898753187200
138:44:2393271635004870966164181940489836000
138:45:4999278526454619351542957831245435200
138:46:10107237020875643471597719093604901600
138:47:19784378849373599986957237374715977600
138:48:37507884901937449975273095856232374200
138:49:68892033493354499954583237286957422000
138:50:122627819618171009919158162370784211160
138:51:211593100517628409272272907620176678080
138:52:354011533558339838590148903133757134480
138:53:574433809170136341863260484330247425760
138:54:904201366286325723303280392001315392400
138:55:1380962086691842922863191871420190781120
138:56:2046783092775410046386516523712068479160
138:57:2944494975571642522871830788498063426160
138:58:4112139534850052488838246446005916164120
138:59:5575782420135664391645079926787682934400
138:60:7341446853178624782332688570270449196960
138:61:9387423845048077590523765712804836678080
138:62:11658574775301644749521450965902781035680
138:63:14064312427348015888311591641406529503360
138:64:16481616125798456119115146454773276761750
138:65:18763686050909011581761859040818807390300
138:66:20753773965399361294979025908784438477150
138:67:22302563067294836018484923364663874184400
138:68:23286499673204902313418081748399045104300
138:69:23623985175715118288974865541854103729000
138:70:23286499673204902313418081748399045104300
138:71:22302563067294836018484923364663874184400
138:72:20753773965399361294979025908784438477150
138:73:18763686050909011581761859040818807390300
138:74:16481616125798456119115146454773276761750
138:75:14064312427348015888311591641406529503360
138:76:11658574775301644749521450965902781035680
138:77:9387423845048077590523765712804836678080
138:78:7341446853178624782332688570270449196960
138:79:5575782420135664391645079926787682934400
138:80:4112139534850052488838246446005916164120
138:81:2944494975571642522871830788498063426160
138:82:2046783092775410046386516523712068479160
138:83:1380962086691842922863191871420190781120
138:84:904201366286325723303280392001315392400
138:85:574433809170136341863260484330247425760
138:86:354011533558339838590148903133757134480
138:87:211593100517628409272272907620176678080
138:88:122627819618171009919158162370784211160
138:89:68892033493354499954583237286957422000
138:90:37507884901937449975273095856232374200
138:91:19784378849373599986957237374715977600
138:92:10107237020875643471597719093604901600
138:93:4999278526454619351542957831245435200
138:94:2393271635004870966164181940489836000
138:95:1108462652002256026433936898753187200
138:96:496498896209343845173534235899865100
138:97:214978903513324139147303483585508600
138:98:89940153510676425561626967622508700
138:99:36339455963909666893586653584852000
138:100:14172387825924770088498794898092280
138:101:5332185518664764983791625803242640
138:102:1934224158731336317649903477646840
138:103:676039511789593276071810924226080
138:104:227513297236882352524167137960700
138:105:73670972438609523674492216101560
138:106:22935302740321832842058897465580
138:107:6859155959722417298559670270080
138:108:1968831803253656817179164614560
138:109:541880312822107380874999435200
138:110:142859355198555582230681669280
138:111:36036594104140146869000781440
138:112:8687393221533785405919831240
138:113:1998869236813083367733766480
138:114:438348516844974422748633000
138:115:91481429602429444747540800
138:116:18138559317723079562012400
138:117:3410669273418014960378400
138:118:606983514760833170914800
138:119:102014036094257675784000
138:120:16152222381590798665800
138:121:2402809941063094016400
138:122:334817778672726215400
138:123:43553532185070076800
138:124:5268572441742348000
138:125:590080113475142976
138:126:60881281549022688
138:127:5752562036128128
138:128:494360799979761
138:129:38322542634090
138:130:2653099105437
138:131:162021319416
138:132:8592039666
138:133:387610812
138:134:14463090
138:135:428536
138:136:9453
138:137:138
138:138:1

# binomial(139, k) for 0 <= k <= 139

139:0:1
139:1:139
139:2:9591
139:3:437989
139:4:14891626
139:5:402073902
139:6:8979650478
139:7:170613359082
139:8:2815120424853
139:9:40975641739527
139:10:532683342613851
139:11:6246922836107889
139:12:66633843585150816
139:13:650961395024165664
139:14:5858652555217490976
139:15:48822104626812424800
139:16:378371310857796292200
139:17:2737627719735820231800
139:18:18555032322653892682200
139:19:118166258475848474449800
139:20:708997550855090846698800
139:21:4017652788178848131293200
139:22:21549228591141094522390800
139:23:109619988920152524309553200
139:24:529829946447403867496173800
139:25:2437217753658057790482399480
139:26:10686262458346868773653597720
139:27:44723987325673932274920612680
139:28:178895949302695729099682450720
139:29:684739668020662963105681104480
139:30:2510712116075764198054164049760
139:31:8827987762976074115738834884640
139:32:29794458700044250140618567735660
139:33:96606275178931356516551113567140
139:34:301184269675491876198659354062260
139:35:903552809026475628595978062186780
139:36:2610263670520929593721714401872920
139:37:7266409677396101301441529280889480
139:38:19504573344589535072290420701334920
139:39:50511843789834436982085448482944280
139:40:126279609474586092455213621207360700
139:41:304919057024000564708930451208017300
139:42:711477799722667984320837719485373700
139:43:1604961548211599871607471134653052300
139:44:3501734287007126992598118839243023200
139:45:7392550161459490317707139771735271200
139:46:15106515547330262823140676924850336800
139:47:29891615870249243458554956468320879200
139:48:57292263751311049962230333230948351800
139:49:106399918395291949929856333143189796200
139:50:191519853111525509873741399657741633160
139:51:334220920135799419191431069990960889240
139:52:565604634075968247862421810753933812560
139:53:928445342728476180453409387464004560240
139:54:1478635175456462065166540876331562818160
139:55:2285163452978168646166472263421506173520
139:56:3427745179467252969249708395132259260280
139:57:4991278068347052569258347312210131905320
139:58:7056634510421695011710077234503979590280
139:59:9687921954985716880483326372793599098520
139:60:12917229273314289173977768497058132131360
139:61:16728870698226702372856454283075285875040
139:62:21045998620349722340045216678707617713760
139:63:25722887202649660637833042607309310539040
139:64:30545928553146472007426738096179806265110
139:65:35245302176707467700877005495592084152050
139:66:39517460016308372876740884949603245867450
139:67:43056337032694197313463949273448312661550
139:68:45589062740499738331903005113062919288700
139:69:46910484848920020602392947290253148833300
139:70:46910484848920020602392947290253148833300
139:71:45589062740499738331903005113062919288700
139:72:43056337032694197313463949273448312661550
139:73:39517460016308372876740884949603245867450
139:74:35245302176707467700877005495592084152050
139:75:30545928553146472007426738096179806265110
139:76:25722887202649660637833042607309310539040
139:77:21045998620349722340045216678707617713760
139:78:16728870698226702372856454283075285875040
139:79:12917229273314289173977768497058132131360
139:80:9687921954985716880483326372793599098520
139:81:7056634510421695011710077234503979590280
139:82:4991278068347052569258347312210131905320
139:83:3427745179467252969249708395132259260280
139:84:2285163452978168646166472263421506173520
139:85:1478635175456462065166540876331562818160
139:86:928445342728476180453409387464004560240
139:87:565604634075968247862421810753933812560
139:88:334220920135799419191431069990960889240
139:89:191519853111525509873741399657741633160
139:90:106399918395291949929856333143189796200
139:91:57292263751311049962230333230948351800
139:92:29891615870249243458554956468320879200
139:93:15106515547330262823140676924850336800
139:94:7392550161459490317707139771735271200
139:95:3501734287007126992598118839243023200
139:96:1604961548211599871607471134653052300
139:97:711477799722667984320837719485373700
139:98:304919057024000564708930451208017300
139:99:126279609474586092455213621207360700
139:100:50511843789834436982085448482944280
139:101:19504573344589535072290420701334920
139:102:7266409677396101301441529280889480
139:103:2610263670520929593721714401872920
139:104:903552809026475628595978062186780
139:105:301184269675491876198659354062260
139:106:96606275178931356516551113567140
139:107:29794458700044250140618567735660
139:108:8827987762976074115738834884640
139:109:2510712116075764198054164049760
139:110:684739668020662963105681104480
139:111:178895949302695729099682450720
139:112:44723987325673932274920612680
139:113:10686262458346868773653597720
139:114:2437217753658057790482399480
139:115:529829946447403867496173800
139:116:109619988920152524309553200
139:117:21549228591141094522390800
139:118:4017652788178848131293200
139:119:708997550855090846698800
139:120:118166258475848474449800
139:121:18555032322653892682200
139:122:2737627719735820231800
139:123:378371310857796292200
139:124:48822104626812424800
139:125:5858652555217490976
139:126:650961395024165664
139:127:66633843585150816
139:128:6246922836107889
139:129:532683342613851
139:130:40975641739527
139:131:2815120424853
139:132:170613359082
139:133:8979650478
139:134:402073902
139:135:14891626
139:136:437989
139:137:9591
139:138:139
139:139:1

# binomial(140, k) for 0 <= k <= 140

140:0:1
140:1:140
140:2:9730
140:3:447580
140:4:15329615
140:5:416965528
140:6:9381724380
140:7:179593009560
140:8:2985733783935
140:9:43790762164380
140:10:573658984353378
140:11:6779606178721740
140:12:72880766421258705
140:13:717595238609316480
140:14:6509613950241656640
140:15:54680757182029915776
140:16:427193415484608717000
140:17:3115999030593616524000
140:18:21292660042389712914000
140:19:136721290798502367132000
140:20:827163809330939321148600
140:21:4726650339033938977992000
140:22:25566881379319942653684000
140:23:131169217511293618831944000
140:24:639449935367556391805727000
140:25:2967047700105461657978573280
140:26:13123480212004926564135997200
140:27:55410249784020801048574210400
140:28:223619936628369661374603063400
140:29:863635617323358692205363555200
140:30:3195451784096427161159845154240
140:31:11338699879051838313792998934400
140:32:38622446463020324256357402620300
140:33:126400733878975606657169681302800
140:34:397790544854423232715210467629400
140:35:1204737078701967504794637416249040
140:36:3513816479547405222317692464059700
140:37:9876673347917030895163243682762400
140:38:26770983021985636373731949982224400
140:39:70016417134423972054375869184279200
140:40:176791453264420529437299069690304980
140:41:431198666498586657164144072415378000
140:42:1016396856746668549029768170693391000
140:43:2316439347934267855928308854138426000
140:44:5106695835218726864205589973896075500
140:45:10894284448466617310305258610978294400
140:46:22499065708789753140847816696585608000
140:47:44998131417579506281695633393171216000
140:48:87183879621560293420785289699269231000
140:49:163692182146602999892086666374138148000
140:50:297919771506817459803597732800931429360
140:51:525740773247324929065172469648702522400
140:52:899825554211767667053852880744894701800
140:53:1494049976804444428315831198217938372800
140:54:2407080518184938245619950263795567378400
140:55:3763798628434630711333013139753068991680
140:56:5712908632445421615416180658553765433800
140:57:8419023247814305538508055707342391165600
140:58:12047912578768747580968424546714111495600
140:59:16744556465407411892193403607297578688800
140:60:22605151228300006054461094869851731229880
140:61:29646099971540991546834222780133418006400
140:62:37774869318576424712901670961782903588800
140:63:46768885822999382977878259286016928252800
140:64:56268815755796132645259780703489116804150
140:65:65791230729853939708303743591771890417160
140:66:74762762193015840577617890445195330019500
140:67:82573797049002570190204834223051558529000
140:68:88645399773193935645366954386511231950250
140:69:92499547589419758934295952403316068122000
140:70:93820969697840041204785894580506297666600
140:71:92499547589419758934295952403316068122000
140:72:88645399773193935645366954386511231950250
140:73:82573797049002570190204834223051558529000
140:74:74762762193015840577617890445195330019500
140:75:65791230729853939708303743591771890417160
140:76:56268815755796132645259780703489116804150
140:77:46768885822999382977878259286016928252800
140:78:37774869318576424712901670961782903588800
140:79:29646099971540991546834222780133418006400
140:80:22605151228300006054461094869851731229880
140:81:16744556465407411892193403607297578688800
140:82:12047912578768747580968424546714111495600
140:83:8419023247814305538508055707342391165600
140:84:5712908632445421615416180658553765433800
140:85:3763798628434630711333013139753068991680
140:86:2407080518184938245619950263795567378400
140:87:1494049976804444428315831198217938372800
140:88:899825554211767667053852880744894701800
140:89:525740773247324929065172469648702522400
140:90:297919771506817459803597732800931429360
140:91:163692182146602999892086666374138148000
140:92:87183879621560293420785289699269231000
140:93:44998131417579506281695633393171216000
140:94:22499065708789753140847816696585608000
140:95:10894284448466617310305258610978294400
140:96:5106695835218726864205589973896075500
140:97:2316439347934267855928308854138426000
140:98:1016396856746668549029768170693391000
140:99:431198666498586657164144072415378000
140:100:176791453264420529437299069690304980
140:101:70016417134423972054375869184279200
140:102:26770983021985636373731949982224400
140:103:9876673347917030895163243682762400
140:104:3513816479547405222317692464059700
140:105:1204737078701967504794637416249040
140:106:397790544854423232715210467629400
140:107:126400733878975606657169681302800
140:108:38622446463020324256357402620300
140:109:11338699879051838313792998934400
140:110:3195451784096427161159845154240
140:111:863635617323358692205363555200
140:112:223619936628369661374603063400
140:113:55410249784020801048574210400
140:114:13123480212004926564135997200
140:115:2967047700105461657978573280
140:116:639449935367556391805727000
140:117:131169217511293618831944000
140:118:25566881379319942653684000
140:119:4726650339033938977992000
140:120:827163809330939321148600
140:121:136721290798502367132000
140:122:21292660042389712914000
140:123:3115999030593616524000
140:124:427193415484608717000
140:125:54680757182029915776
140:126:6509613950241656640
140:127:717595238609316480
140:128:72880766421258705
140:129:6779606178721740
140:130:573658984353378
140:131:43790762164380
140:132:2985733783935
140:133:179593009560
140:134:9381724380
140:135:416965528
140:136:15329615
140:137:447580
140:138:9730
140:139:140
140:140:1

# binomial(141, k) for 0 <= k <= 141

141:0:1
141:1:141
141:2:9870
141:3:457310
141:4:15777195
141:5:432295143
141:6:9798689908
141:7:188974733940
141:8:3165326793495
141:9:46776495948315
141:10:617449746517758
141:11:7353265163075118
141:12:79660372599980445
141:13:790476005030575185
141:14:7227209188850973120
141:15:61190371132271572416
141:16:481874172666638632776
141:17:3543192446078225241000
141:18:24408659072983329438000
141:19:158013950840892080046000
141:20:963885100129441688280600
141:21:5553814148364878299140600
141:22:30293531718353881631676000
141:23:156736098890613561485628000
141:24:770619152878850010637671000
141:25:3606497635473018049784300280
141:26:16090527912110388222114570480
141:27:68533729996025727612710207600
141:28:279030186412390462423177273800
141:29:1087255553951728353579966618600
141:30:4059087401419785853365208709440
141:31:14534151663148265474952844088640
141:32:49961146342072162570150401554700
141:33:165023180341995930913527083923100
141:34:524191278733398839372380148932200
141:35:1602527623556390737509847883878440
141:36:4718553558249372727112329880308740
141:37:13390489827464436117480936146822100
141:38:36647656369902667268895193664986800
141:39:96787400156409608428107819166503600
141:40:246807870398844501491674938874584180
141:41:607990119763007186601443142105682980
141:42:1447595523245255206193912243108769000
141:43:3332836204680936404958077024831817000
141:44:7423135183152994720133898828034501500
141:45:16000980283685344174510848584874369900
141:46:33393350157256370451153075307563902400
141:47:67497197126369259422543450089756824000
141:48:132182011039139799702480923092440447000
141:49:250876061768163293312871956073407379000
141:50:461611953653420459695684399175069577360
141:51:823660544754142388868770202449633951760
141:52:1425566327459092596119025350393597224200
141:53:2393875531016212095369684078962833074600
141:54:3901130494989382673935781462013505751200
141:55:6170879146619568956952963403548636370080
141:56:9476707260880052326749193798306834425480
141:57:14131931880259727153924236365896156599400
141:58:20466935826583053119476480254056502661200
141:59:28792469044176159473161828154011690184400
141:60:39349707693707417946654498477149309918680
141:61:52251251199840997601295317649985149236280
141:62:67420969290117416259735893741916321595200
141:63:84543755141575807690779930247799831841600
141:64:103037701578795515623138039989506045056950
141:65:122060046485650072353563524295261007221310
141:66:140553992922869780285921634036967220436660
141:67:157336559242018410767822724668246888548500
141:68:171219196822196505835571788609562790479250
141:69:181144947362613694579662906789827300072250
141:70:186320517287259800139081846983822365788600
141:71:186320517287259800139081846983822365788600
141:72:181144947362613694579662906789827300072250
141:73:171219196822196505835571788609562790479250
141:74:157336559242018410767822724668246888548500
141:75:140553992922869780285921634036967220436660
141:76:122060046485650072353563524295261007221310
141:77:103037701578795515623138039989506045056950
141:78:84543755141575807690779930247799831841600
141:79:67420969290117416259735893741916321595200
141:80:52251251199840997601295317649985149236280
141:81:39349707693707417946654498477149309918680
141:82:28792469044176159473161828154011690184400
141:83:20466935826583053119476480254056502661200
141:84:14131931880259727153924236365896156599400
141:85:9476707260880052326749193798306834425480
141:86:6170879146619568956952963403548636370080
141:87:3901130494989382673935781462013505751200
141:88:2393875531016212095369684078962833074600
141:89:1425566327459092596119025350393597224200
141:90:823660544754142388868770202449633951760
141:91:461611953653420459695684399175069577360
141:92:250876061768163293312871956073407379000
141:93:132182011039139799702480923092440447000
141:94:67497197126369259422543450089756824000
141:95:33393350157256370451153075307563902400
141:96:16000980283685344174510848584874369900
141:97:7423135183152994720133898828034501500
141:98:3332836204680936404958077024831817000
141:99:1447595523245255206193912243108769000
141:100:607990119763007186601443142105682980
141:101:246807870398844501491674938874584180
141:102:96787400156409608428107819166503600
141:103:36647656369902667268895193664986800
141:104:13390489827464436117480936146822100
141:105:4718553558249372727112329880308740
141:106:1602527623556390737509847883878440
141:107:524191278733398839372380148932200
141:108:165023180341995930913527083923100
141:109:49961146342072162570150401554700
141:110:14534151663148265474952844088640
141:111:4059087401419785853365208709440
141:112:1087255553951728353579966618600
141:113:279030186412390462423177273800
141:114:68533729996025727612710207600
141:115:16090527912110388222114570480
141:116:3606497635473018049784300280
141:117:770619152878850010637671000
141:118:156736098890613561485628000
141:119:30293531718353881631676000
141:120:5553814148364878299140600
141:121:963885100129441688280600
141:122:158013950840892080046000
141:123:24408659072983329438000
141:124:3543192446078225241000
141:125:481874172666638632776
141:126:61190371132271572416
141:127:7227209188850973120
141:128:790476005030575185
141:129:79660372599980445
141:130:7353265163075118
141:131:617449746517758
141:132:46776495948315
141:133:3165326793495
141:134:188974733940
141:135:9798689908
141:136:432295143
141:137:15777195
141:138:457310
141:139:9870
141:140:141
141:141:1

# binomial(142, k) for 0 <= k <= 142

142:0:1
142:1:142
142:2:10011
142:3:467180
142:4:16234505
142:5:448072338
142:6:10230985051
142:7:198773423848
142:8:3354301527435
142:9:49941822741810
142:10:664226242466073
142:11:7970714909592876
142:12:87013637763055563
142:13:870136377630555630
142:14:8017685193881548305
142:15:68417580321122545536
142:16:543064543798910205192
142:17:4025066618744863873776
142:18:27951851519061554679000
142:19:182422609913875409484000
142:20:1121899050970333768326600
142:21:6517699248494319987421200
142:22:35847345866718759930816600
142:23:187029630608967443117304000
142:24:927355251769463572123299000
142:25:4377116788351868060421971280
142:26:19697025547583406271898870760
142:27:84624257908136115834824778080
142:28:347563916408416190035887481400
142:29:1366285740364118816003143892400
142:30:5146342955371514206945175328040
142:31:18593239064568051328318052798080
142:32:64495298005220428045103245643340
142:33:214984326684068093483677485477800
142:34:689214459075394770285907232855300
142:35:2126718902289789576882228032810640
142:36:6321081181805763464622177764187180
142:37:18109043385713808844593266027130840
142:38:50038146197367103386376129811808900
142:39:133435056526312275697003012831490400
142:40:343595270555254109919782758041087780
142:41:854797990161851688093118080980267160
142:42:2055585643008262392795355385214451980
142:43:4780431727926191611151989267940586000
142:44:10755971387833931125091975852866318500
142:45:23424115466838338894644747412908871400
142:46:49394330440941714625663923892438272300
142:47:100890547283625629873696525397320726400
142:48:199679208165509059125024373182197271000
142:49:383058072807303093015352879165847826000
142:50:712488015421583753008556355248476956360
142:51:1285272498407562848564454601624703529120
142:52:2249226872213234984987795552843231175960
142:53:3819441858475304691488709429356430298800
142:54:6295006026005594769305465540976338825800
142:55:10072009641608951630888744865562142121280
142:56:15647586407499621283702157201855470795560
142:57:23608639141139779480673430164202991024880
142:58:34598867706842780273400716619952659260600
142:59:49259404870759212592638308408068192845600
142:60:68142176737883577419816326631161000103080
142:61:91600958893548415547949816127134459154960
142:62:119672220489958413861031211391901470831480
142:63:151964724431693223950515823989716153436800
142:64:187581456720371323313917970237305876898550
142:65:225097748064445587976701564284767052278260
142:66:262614039408519852639485158332228227657970
142:67:297890552164888191053744358705214108985160
142:68:328555756064214916603394513277809679027750
142:69:352364144184810200415234695399390090551500
142:70:367465464649873494718744753773649665860850
142:71:372641034574519600278163693967644731577200
142:72:367465464649873494718744753773649665860850
142:73:352364144184810200415234695399390090551500
142:74:328555756064214916603394513277809679027750
142:75:297890552164888191053744358705214108985160
142:76:262614039408519852639485158332228227657970
142:77:225097748064445587976701564284767052278260
142:78:187581456720371323313917970237305876898550
142:79:151964724431693223950515823989716153436800
142:80:119672220489958413861031211391901470831480
142:81:91600958893548415547949816127134459154960
142:82:68142176737883577419816326631161000103080
142:83:49259404870759212592638308408068192845600
142:84:34598867706842780273400716619952659260600
142:85:23608639141139779480673430164202991024880
142:86:15647586407499621283702157201855470795560
142:87:10072009641608951630888744865562142121280
142:88:6295006026005594769305465540976338825800
142:89:3819441858475304691488709429356430298800
142:90:2249226872213234984987795552843231175960
142:91:1285272498407562848564454601624703529120
142:92:712488015421583753008556355248476956360
142:93:383058072807303093015352879165847826000
142:94:199679208165509059125024373182197271000
142:95:100890547283625629873696525397320726400
142:96:49394330440941714625663923892438272300
142:97:23424115466838338894644747412908871400
142:98:10755971387833931125091975852866318500
142:99:4780431727926191611151989267940586000
142:100:2055585643008262392795355385214451980
142:101:854797990161851688093118080980267160
142:102:343595270555254109919782758041087780
142:103:133435056526312275697003012831490400
142:104:50038146197367103386376129811808900
142:105:18109043385713808844593266027130840
142:106:6321081181805763464622177764187180
142:107:2126718902289789576882228032810640
142:108:689214459075394770285907232855300
142:109:214984326684068093483677485477800
142:110:64495298005220428045103245643340
142:111:18593239064568051328318052798080
142:112:5146342955371514206945175328040
142:113:1366285740364118816003143892400
142:114:347563916408416190035887481400
142:115:84624257908136115834824778080
142:116:19697025547583406271898870760
142:117:4377116788351868060421971280
142:118:927355251769463572123299000
142:119:187029630608967443117304000
142:120:35847345866718759930816600
142:121:6517699248494319987421200
142:122:1121899050970333768326600
142:123:182422609913875409484000
142:124:27951851519061554679000
142:125:4025066618744863873776
142:126:543064543798910205192
142:127:68417580321122545536
142:128:8017685193881548305
142:129:870136377630555630
142:130:87013637763055563
142:131:7970714909592876
142:132:664226242466073
142:133:49941822741810
142:134:3354301527435
142:135:198773423848
142:136:10230985051
142:137:448072338
142:138:16234505
142:139:467180
142:140:10011
142:141:142
142:142:1

# binomial(143, k) for 0 <= k <= 143

143:0:1
143:1:143
143:2:10153
143:3:477191
143:4:16701685
143:5:464306843
143:6:10679057389
143:7:209004408899
143:8:3553074951283
143:9:53296124269245
143:10:714168065207883
143:11:8634941152058949
143:12:94984352672648439
143:13:957150015393611193
143:14:8887821571512103935
143:15:76435265515004093841
143:16:611482124120032750728
143:17:4568131162543774078968
143:18:31976918137806418552776
143:19:210374461432936964163000
143:20:1304321660884209177810600
143:21:7639598299464653755747800
143:22:42365045115213079918237800
143:23:222876976475686203048120600
143:24:1114384882378431015240603000
143:25:5304472040121331632545270280
143:26:24074142335935274332320842040
143:27:104321283455719522106723648840
143:28:432188174316552305870712259480
143:29:1713849656772535006039031373800
143:30:6512628695735633022948319220440
143:31:23739582019939565535263228126120
143:32:83088537069788479373421298441420
143:33:279479624689288521528780731121140
143:34:904198785759462863769584718333100
143:35:2815933361365184347168135265665940
143:36:8447800084095553041504405796997820
143:37:24430124567519572309215443791318020
143:38:68147189583080912230969395838939740
143:39:183473202723679379083379142643299300
143:40:477030327081566385616785770872578180
143:41:1198393260717105798012900839021354940
143:42:2910383633170114080888473466194719140
143:43:6836017370934454003947344653155037980
143:44:15536403115760122736243965120806904500
143:45:34180086854672270019736723265775189900
143:46:72818445907780053520308671305347143700
143:47:150284877724567344499360449289758998700
143:48:300569755449134688998720898579517997400
143:49:582737280972812152140377252348045097000
143:50:1095546088228886846023909234414324782360
143:51:1997760513829146601573010956873180485480
143:52:3534499370620797833552250154467934705080
143:53:6068668730688539676476504982199661474760
143:54:10114447884480899460794174970332769124600
143:55:16367015667614546400194210406538480947080
143:56:25719596049108572914590902067417612916840
143:57:39256225548639400764375587366058461820440
143:58:58207506847982559754074146784155650285480
143:59:83858272577601992866039025028020852106200
143:60:117401581608642790012454635039229192948680
143:61:159743135631431992967766142758295459258040
143:62:211273179383506829408981027519035929986440
143:63:271636944921651637811547035381617624268280
143:64:339546181152064547264433794227022030335350
143:65:412679204784816911290619534522072929176810
143:66:487711787472965440616186722616995279936230
143:67:560504591573408043693229517037442336643130
143:68:626446308229103107657138871983023788012910
143:69:680919900249025117018629208677199769579250
143:70:719829608834683695133979449173039756412350
143:71:740106499224393094996908447741294397438050
143:72:740106499224393094996908447741294397438050
143:73:719829608834683695133979449173039756412350
143:74:680919900249025117018629208677199769579250
143:75:626446308229103107657138871983023788012910
143:76:560504591573408043693229517037442336643130
143:77:487711787472965440616186722616995279936230
143:78:412679204784816911290619534522072929176810
143:79:339546181152064547264433794227022030335350
143:80:271636944921651637811547035381617624268280
143:81:211273179383506829408981027519035929986440
143:82:159743135631431992967766142758295459258040
143:83:117401581608642790012454635039229192948680
143:84:83858272577601992866039025028020852106200
143:85:58207506847982559754074146784155650285480
143:86:39256225548639400764375587366058461820440
143:87:25719596049108572914590902067417612916840
143:88:16367015667614546400194210406538480947080
143:89:10114447884480899460794174970332769124600
143:90:6068668730688539676476504982199661474760
143:91:3534499370620797833552250154467934705080
143:92:1997760513829146601573010956873180485480
143:93:1095546088228886846023909234414324782360
143:94:582737280972812152140377252348045097000
143:95:300569755449134688998720898579517997400
143:96:150284877724567344499360449289758998700
143:97:72818445907780053520308671305347143700
143:98:34180086854672270019736723265775189900
143:99:15536403115760122736243965120806904500
143:100:6836017370934454003947344653155037980
143:101:2910383633170114080888473466194719140
143:102:1198393260717105798012900839021354940
143:103:477030327081566385616785770872578180
143:104:183473202723679379083379142643299300
143:105:68147189583080912230969395838939740
143:106:24430124567519572309215443791318020
143:107:8447800084095553041504405796997820
143:108:2815933361365184347168135265665940
143:109:904198785759462863769584718333100
143:110:279479624689288521528780731121140
143:111:83088537069788479373421298441420
143:112:23739582019939565535263228126120
143:113:6512628695735633022948319220440
143:114:1713849656772535006039031373800
143:115:432188174316552305870712259480
143:116:104321283455719522106723648840
143:117:24074142335935274332320842040
143:118:5304472040121331632545270280
143:119:1114384882378431015240603000
143:120:222876976475686203048120600
143:121:42365045115213079918237800
143:122:7639598299464653755747800
143:123:1304321660884209177810600
143:124:210374461432936964163000
143:125:31976918137806418552776
143:126:4568131162543774078968
143:127:611482124120032750728
143:128:76435265515004093841
143:129:8887821571512103935
143:130:957150015393611193
143:131:94984352672648439
143:132:8634941152058949
143:133:714168065207883
143:134:53296124269245
143:135:3553074951283
143:136:209004408899
143:137:10679057389
143:138:464306843
143:139:16701685
143:140:477191
143:141:10153
143:142:143
143:143:1

# binomial(144, k) for 0 <= k <= 144

144:0:1
144:1:144
144:2:10296
144:3:487344
144:4:17178876
144:5:481008528
144:6:11143364232
144:7:219683466288
144:8:3762079360182
144:9:56849199220528
144:10:767464189477128
144:11:9349109217266832
144:12:103619293824707388
144:13:1052134368066259632
144:14:9844971586905715128
144:15:85323087086516197776
144:16:687917389635036844569
144:17:5179613286663806829696
144:18:36545049300350192631744
144:19:242351379570743382715776
144:20:1514696122317146141973600
144:21:8943919960348862933558400
144:22:50004643414677733673985600
144:23:265242021590899282966358400
144:24:1337261858854117218288723600
144:25:6418856922499762647785873280
144:26:29378614376056605964866112320
144:27:128395425791654796439044490880
144:28:536509457772271827977435908320
144:29:2146037831089087311909743633280
144:30:8226478352508168028987350594240
144:31:30252210715675198558211547346560
144:32:106828119089728044908684526567540
144:33:362568161759077000902202029562560
144:34:1183678410448751385298365449454240
144:35:3720132147124647210937719983999040
144:36:11263733445460737388672541062663760
144:37:32877924651615125350719849588315840
144:38:92577314150600484540184839630257760
144:39:251620392306760291314348538482239040
144:40:660503529805245764700164913515877480
144:41:1675423587798672183629686609893933120
144:42:4108776893887219878901374305216074080
144:43:9746401004104568084835818119349757120
144:44:22372420486694576740191309773961942480
144:45:49716489970432392755980688386582094400
144:46:106998532762452323540045394571122333600
144:47:223103323632347398019669120595106142400
144:48:450854633173702033498081347869276996100
144:49:883307036421946841139098150927563094400
144:50:1678283369201698998164286486762369879360
144:51:3093306602058033447596920191287505267840
144:52:5532259884449944435125261111341115190560
144:53:9603168101309337510028755136667596179840
144:54:16183116615169439137270679952532430599360
144:55:26481463552095445860988385376871250071680
144:56:42086611716723119314785112473956093863920
144:57:64975821597747973678966489433476074737280
144:58:97463732396621960518449734150214112105920
144:59:142065779425584552620113171812176502391680
144:60:201259854186244782878493660067250045054880
144:61:277144717240074782980220777797524652206720
144:62:371016315014938822376747170277331389244480
144:63:482910124305158467220528062900653554254720
144:64:611183126073716185075980829608639654603630
144:65:752225385936881458555053328749094959512160
144:66:900390992257782351906806257139068209113040
144:67:1048216379046373484309416239654437616579360
144:68:1186950899802511151350368389020466124656040
144:69:1307366208478128224675768080660223557592160
144:70:1400749509083708812152608657850239525991600
144:71:1459936108059076790130887896914334153850400
144:72:1480212998448786189993816895482588794876100
144:73:1459936108059076790130887896914334153850400
144:74:1400749509083708812152608657850239525991600
144:75:1307366208478128224675768080660223557592160
144:76:1186950899802511151350368389020466124656040
144:77:1048216379046373484309416239654437616579360
144:78:900390992257782351906806257139068209113040
144:79:752225385936881458555053328749094959512160
144:80:611183126073716185075980829608639654603630
144:81:482910124305158467220528062900653554254720
144:82:371016315014938822376747170277331389244480
144:83:277144717240074782980220777797524652206720
144:84:201259854186244782878493660067250045054880
144:85:142065779425584552620113171812176502391680
144:86:97463732396621960518449734150214112105920
144:87:64975821597747973678966489433476074737280
144:88:42086611716723119314785112473956093863920
144:89:26481463552095445860988385376871250071680
144:90:16183116615169439137270679952532430599360
144:91:9603168101309337510028755136667596179840
144:92:5532259884449944435125261111341115190560
144:93:3093306602058033447596920191287505267840
144:94:1678283369201698998164286486762369879360
144:95:883307036421946841139098150927563094400
144:96:450854633173702033498081347869276996100
144:97:223103323632347398019669120595106142400
144:98:106998532762452323540045394571122333600
144:99:49716489970432392755980688386582094400
144:100:22372420486694576740191309773961942480
144:101:9746401004104568084835818119349757120
144:102:4108776893887219878901374305216074080
144:103:1675423587798672183629686609893933120
144:104:660503529805245764700164913515877480
144:105:251620392306760291314348538482239040
144:106:92577314150600484540184839630257760
144:107:32877924651615125350719849588315840
144:108:11263733445460737388672541062663760
144:109:3720132147124647210937719983999040
144:110:1183678410448751385298365449454240
144:111:362568161759077000902202029562560
144:112:106828119089728044908684526567540
144:113:30252210715675198558211547346560
144:114:8226478352508168028987350594240
144:115:2146037831089087311909743633280
144:116:536509457772271827977435908320
144:117:128395425791654796439044490880
144:118:29378614376056605964866112320
144:119:6418856922499762647785873280
144:120:1337261858854117218288723600
144:121:265242021590899282966358400
144:122:50004643414677733673985600
144:123:8943919960348862933558400
144:124:1514696122317146141973600
144:125:242351379570743382715776
144:126:36545049300350192631744
144:127:5179613286663806829696
144:128:687917389635036844569
144:129:85323087086516197776
144:130:9844971586905715128
144:131:1052134368066259632
144:132:103619293824707388
144:133:9349109217266832
144:134:767464189477128
144:135:56849199220528
144:136:3762079360182
144:137:219683466288
144:138:11143364232
144:139:481008528
144:140:17178876
144:141:487344
144:142:10296
144:143:144
144:144:1

# binomial(145, k) for 0 <= k <= 145

145:0:1
145:1:145
145:2:10440
145:3:497640
145:4:17666220
145:5:498187404
145:6:11624372760
145:7:230826830520
145:8:3981762826470
145:9:60611278580710
145:10:824313388697656
145:11:10116573406743960
145:12:112968403041974220
145:13:1155753661890967020
145:14:10897105954971974760
145:15:95168058673421912904
145:16:773240476721553042345
145:17:5867530676298843674265
145:18:41724662587013999461440
145:19:278896428871093575347520
145:20:1757047501887889524689376
145:21:10458616082666009075532000
145:22:58948563375026596607544000
145:23:315246665005577016640344000
145:24:1602503880445016501255082000
145:25:7756118781353879866074596880
145:26:35797471298556368612651985600
145:27:157774040167711402403910603200
145:28:664904883563926624416480399200
145:29:2682547288861359139887179541600
145:30:10372516183597255340897094227520
145:31:38478689068183366587198897940800
145:32:137080329805403243466896073914100
145:33:469396280848805045810886556130100
145:34:1546246572207828386200567479016800
145:35:4903810557573398596236085433453280
145:36:14983865592585384599610261046662800
145:37:44141658097075862739392390650979600
145:38:125455238802215609890904689218573600
145:39:344197706457360775854533378112496800
145:40:912123922112006056014513451998116520
145:41:2335927117603917948329851523409810600
145:42:5784200481685892062531060915110007200
145:43:13855177897991787963737192424565831200
145:44:32118821490799144825027127893311699600
145:45:72088910457126969496171998160544036880
145:46:156715022732884716296026082957704428000
145:47:330101856394799721559714515166228476000
145:48:673957956806049431517750468464383138500
145:49:1334161669595648874637179498796840090500
145:50:2561590405623645839303384637689932973760
145:51:4771589971259732445761206678049875147200
145:52:8625566486507977882722181302628620458400
145:53:15135427985759281945154016248008711370400
145:54:25786284716478776647299435089200026779200
145:55:42664580167264884998259065329403680671040
145:56:68568075268818565175773497850827343935600
145:57:107062433314471092993751601907432168601200
145:58:162439553994369934197416223583690186843200
145:59:239529511822206513138562905962390614497600
145:60:343325633611829335498606831879426547446560
145:61:478404571426319565858714437864774697261600
145:62:648161032255013605356967948074856041451200
145:63:853926439320097289597275233177984943499200
145:64:1094093250378874652296508892509293208858350
145:65:1363408512010597643631034158357734614115790
145:66:1652616378194663810461859585888163168625200
145:67:1948607371304155836216222496793505825692400
145:68:2235167278848884635659784628674903741235400
145:69:2494317108280639376026136469680689682248200
145:70:2708115717561837036828376738510463083583760
145:71:2860685617142785602283496554764573679842000
145:72:2940149106507862980124704792396922948726500
145:73:2940149106507862980124704792396922948726500
145:74:2860685617142785602283496554764573679842000
145:75:2708115717561837036828376738510463083583760
145:76:2494317108280639376026136469680689682248200
145:77:2235167278848884635659784628674903741235400
145:78:1948607371304155836216222496793505825692400
145:79:1652616378194663810461859585888163168625200
145:80:1363408512010597643631034158357734614115790
145:81:1094093250378874652296508892509293208858350
145:82:853926439320097289597275233177984943499200
145:83:648161032255013605356967948074856041451200
145:84:478404571426319565858714437864774697261600
145:85:343325633611829335498606831879426547446560
145:86:239529511822206513138562905962390614497600
145:87:162439553994369934197416223583690186843200
145:88:107062433314471092993751601907432168601200
145:89:68568075268818565175773497850827343935600
145:90:42664580167264884998259065329403680671040
145:91:25786284716478776647299435089200026779200
145:92:15135427985759281945154016248008711370400
145:93:8625566486507977882722181302628620458400
145:94:4771589971259732445761206678049875147200
145:95:2561590405623645839303384637689932973760
145:96:1334161669595648874637179498796840090500
145:97:673957956806049431517750468464383138500
145:98:330101856394799721559714515166228476000
145:99:156715022732884716296026082957704428000
145:100:72088910457126969496171998160544036880
145:101:32118821490799144825027127893311699600
145:102:13855177897991787963737192424565831200
145:103:5784200481685892062531060915110007200
145:104:2335927117603917948329851523409810600
145:105:912123922112006056014513451998116520
145:106:344197706457360775854533378112496800
145:107:125455238802215609890904689218573600
145:108:44141658097075862739392390650979600
145:109:14983865592585384599610261046662800
145:110:4903810557573398596236085433453280
145:111:1546246572207828386200567479016800
145:112:469396280848805045810886556130100
145:113:137080329805403243466896073914100
145:114:38478689068183366587198897940800
145:115:10372516183597255340897094227520
145:116:2682547288861359139887179541600
145:117:664904883563926624416480399200
145:118:157774040167711402403910603200
145:119:35797471298556368612651985600
145:120:7756118781353879866074596880
145:121:1602503880445016501255082000
145:122:315246665005577016640344000
145:123:58948563375026596607544000
145:124:10458616082666009075532000
145:125:1757047501887889524689376
145:126:278896428871093575347520
145:127:41724662587013999461440
145:128:5867530676298843674265
145:129:773240476721553042345
145:130:95168058673421912904
145:131:10897105954971974760
145:132:1155753661890967020
145:133:112968403041974220
145:134:10116573406743960
145:135:824313388697656
145:136:60611278580710
145:137:3981762826470
145:138:230826830520
145:139:11624372760
145:140:498187404
145:141:17666220
145:142:497640
145:143:10440
145:144:145
145:145:1

# binomial(146, k) for 0 <= k <= 146

146:0:1
146:1:146
146:2:10585
146:3:508080
146:4:18163860
146:5:515853624
146:6:12122560164
146:7:242451203280
146:8:4212589656990
146:9:64593041407180
146:10:884924667278366
146:11:10940886795441616
146:12:123084976448718180
146:13:1268722064932941240
146:14:12052859616862941780
146:15:106065164628393887664
146:16:868408535394974955249
146:17:6640771153020396716610
146:18:47592193263312843135705
146:19:320621091458107574808960
146:20:2035943930758983100036896
146:21:12215663584553898600221376
146:22:69407179457692605683076000
146:23:374195228380603613247888000
146:24:1917750545450593517895426000
146:25:9358622661798896367329678880
146:26:43553590079910248478726582480
146:27:193571511466267771016562588800
146:28:822678923731638026820391002400
146:29:3347452172425285764303659940800
146:30:13055063472458614480784273769120
146:31:48851205251780621928095992168320
146:32:175559018873586610054094971854900
146:33:606476610654208289277782630044200
146:34:2015642853056633432011454035146900
146:35:6450057129781226982436652912470080
146:36:19887676150158783195846346480116080
146:37:59125523689661247339002651697642400
146:38:169596896899291472630297079869553200
146:39:469652945259576385745438067331070400
146:40:1256321628569366831869046830110613320
146:41:3248051039715924004344364975407927120
146:42:8120127599289810010860912438519817800
146:43:19639378379677680026268253339675838400
146:44:45973999388790932788764320317877530800
146:45:104207731947926114321199126053855736480
146:46:228803933190011685792198081118248464880
146:47:486816879127684437855740598123932904000
146:48:1004059813200849153077464983630611614500
146:49:2008119626401698306154929967261223229000
146:50:3895752075219294713940564136486773064260
146:51:7333180376883378285064591315739808120960
146:52:13397156457767710328483387980678495605600
146:53:23760994472267259827876197550637331828800
146:54:40921712702238058592453451337208738149600
146:55:68450864883743661645558500418603707450240
146:56:111232655436083450174032563180231024606640
146:57:175630508583289658169525099758259512536800
146:58:269501987308841027191167825491122355444400
146:59:401969065816576447335979129546080801340800
146:60:582855145434035848637169737841817161944160
146:61:821730205038148901357321269744201244708160
146:62:1126565603681333171215682385939630738712800
146:63:1502087471575110894954243181252840984950400
146:64:1948019689698971941893784125687278152357550
146:65:2457501762389472295927543050867027822974140
146:66:3016024890205261454092893744245897782740990
146:67:3601223749498819646678082082681668994317600
146:68:4183774650153040471876007125468409566927800
146:69:4729484387129524011685921098355593423483600
146:70:5202432825842476412854513208191152765831960
146:71:5568801334704622639111873293275036763425760
146:72:5800834723650648582408201347161496628568500
146:73:5880298213015725960249409584793845897453000
146:74:5800834723650648582408201347161496628568500
146:75:5568801334704622639111873293275036763425760
146:76:5202432825842476412854513208191152765831960
146:77:4729484387129524011685921098355593423483600
146:78:4183774650153040471876007125468409566927800
146:79:3601223749498819646678082082681668994317600
146:80:3016024890205261454092893744245897782740990
146:81:2457501762389472295927543050867027822974140
146:82:1948019689698971941893784125687278152357550
146:83:1502087471575110894954243181252840984950400
146:84:1126565603681333171215682385939630738712800
146:85:821730205038148901357321269744201244708160
146:86:582855145434035848637169737841817161944160
146:87:401969065816576447335979129546080801340800
146:88:269501987308841027191167825491122355444400
146:89:175630508583289658169525099758259512536800
146:90:111232655436083450174032563180231024606640
146:91:68450864883743661645558500418603707450240
146:92:40921712702238058592453451337208738149600
146:93:23760994472267259827876197550637331828800
146:94:13397156457767710328483387980678495605600
146:95:7333180376883378285064591315739808120960
146:96:3895752075219294713940564136486773064260
146:97:2008119626401698306154929967261223229000
146:98:1004059813200849153077464983630611614500
146:99:486816879127684437855740598123932904000
146:100:228803933190011685792198081118248464880
146:101:104207731947926114321199126053855736480
146:102:45973999388790932788764320317877530800
146:103:19639378379677680026268253339675838400
146:104:8120127599289810010860912438519817800
146:105:3248051039715924004344364975407927120
146:106:1256321628569366831869046830110613320
146:107:469652945259576385745438067331070400
146:108:169596896899291472630297079869553200
146:109:59125523689661247339002651697642400
146:110:19887676150158783195846346480116080
146:111:6450057129781226982436652912470080
146:112:2015642853056633432011454035146900
146:113:606476610654208289277782630044200
146:114:175559018873586610054094971854900
146:115:48851205251780621928095992168320
146:116:13055063472458614480784273769120
146:117:3347452172425285764303659940800
146:118:822678923731638026820391002400
146:119:193571511466267771016562588800
146:120:43553590079910248478726582480
146:121:9358622661798896367329678880
146:122:1917750545450593517895426000
146:123:374195228380603613247888000
146:124:69407179457692605683076000
146:125:12215663584553898600221376
146:126:2035943930758983100036896
146:127:320621091458107574808960
146:128:47592193263312843135705
146:129:6640771153020396716610
146:130:868408535394974955249
146:131:106065164628393887664
146:132:12052859616862941780
146:133:1268722064932941240
146:134:123084976448718180
146:135:10940886795441616
146:136:884924667278366
146:137:64593041407180
146:138:4212589656990
146:139:242451203280
146:140:12122560164
146:141:515853624
146:142:18163860
146:143:508080
146:144:10585
146:145:146
146:146:1

# binomial(147, k) for 0 <= k <= 147

147:0:1
147:1:147
147:2:10731
147:3:518665
147:4:18671940
147:5:534017484
147:6:12638413788
147:7:254573763444
147:8:4455040860270
147:9:68805631064170
147:10:949517708685546
147:11:11825811462719982
147:12:134025863244159796
147:13:1391807041381659420
147:14:13321581681795883020
147:15:118118024245256829444
147:16:974473700023368842913
147:17:7509179688415371671859
147:18:54232964416333239852315
147:19:368213284721420417944665
147:20:2356565022217090674845856
147:21:14251607515312881700258272
147:22:81622843042246504283297376
147:23:443602407838296218930964000
147:24:2291945773831197131143314000
147:25:11276373207249489885225104880
147:26:52912212741709144846056261360
147:27:237125101546178019495289171280
147:28:1016250435197905797836953591200
147:29:4170131096156923791124050943200
147:30:16402515644883900245087933709920
147:31:61906268724239236408880265937440
147:32:224410224125367231982190964023220
147:33:782035629527794899331877601899100
147:34:2622119463710841721289236665191100
147:35:8465699982837860414448106947616980
147:36:26337733279940010178282999392586160
147:37:79013199839820030534848998177758480
147:38:228722420588952719969299731567195600
147:39:639249842158867858375735147200623600
147:40:1725974573828943217614484897441683720
147:41:4504372668285290836213411805518540440
147:42:11368178639005734015205277413927744920
147:43:27759505978967490037129165778195656200
147:44:65613377768468612815032573657553369200
147:45:150181731336717047109963446371733267280
147:46:333011665137937800113397207172104201360
147:47:715620812317696123647938679242181368880
147:48:1490876692328533590933205581754544518500
147:49:3012179439602547459232394950891834843500
147:50:5903871701620993020095494103747996293260
147:51:11228932452102672999005155452226581185220
147:52:20730336834651088613547979296418303726560
147:53:37158150930034970156359585531315827434400
147:54:64682707174505318420329648887846069978400
147:55:109372577585981720238011951755812445599840
147:56:179683520319827111819591063598834732056880
147:57:286863164019373108343557662938490537143440
147:58:445132495892130685360692925249381867981200
147:59:671471053125417474527146955037203156785200
147:60:984824211250612295973148867387897963284960
147:61:1404585350472184749994491007586018406652320
147:62:1948295808719482072573003655683831983420960
147:63:2628653075256444066169925567192471723663200
147:64:3450107161274082836848027306940119137307950
147:65:4405521452088444237821327176554305975331690
147:66:5473526652594733750020436795112925605715130
147:67:6617248639704081100770975826927566777058590
147:68:7784998399651860118554089208150078561245400
147:69:8913259037282564483561928223824002990411400
147:70:9931917212972000424540434306546746189315560
147:71:10771234160547099051966386501466189529257720
147:72:11369636058355271221520074640436533391994260
147:73:11681132936666374542657610931955342526021500
147:74:11681132936666374542657610931955342526021500
147:75:11369636058355271221520074640436533391994260
147:76:10771234160547099051966386501466189529257720
147:77:9931917212972000424540434306546746189315560
147:78:8913259037282564483561928223824002990411400
147:79:7784998399651860118554089208150078561245400
147:80:6617248639704081100770975826927566777058590
147:81:5473526652594733750020436795112925605715130
147:82:4405521452088444237821327176554305975331690
147:83:3450107161274082836848027306940119137307950
147:84:2628653075256444066169925567192471723663200
147:85:1948295808719482072573003655683831983420960
147:86:1404585350472184749994491007586018406652320
147:87:984824211250612295973148867387897963284960
147:88:671471053125417474527146955037203156785200
147:89:445132495892130685360692925249381867981200
147:90:286863164019373108343557662938490537143440
147:91:179683520319827111819591063598834732056880
147:92:109372577585981720238011951755812445599840
147:93:64682707174505318420329648887846069978400
147:94:37158150930034970156359585531315827434400
147:95:20730336834651088613547979296418303726560
147:96:11228932452102672999005155452226581185220
147:97:5903871701620993020095494103747996293260
147:98:3012179439602547459232394950891834843500
147:99:1490876692328533590933205581754544518500
147:100:715620812317696123647938679242181368880
147:101:333011665137937800113397207172104201360
147:102:150181731336717047109963446371733267280
147:103:65613377768468612815032573657553369200
147:104:27759505978967490037129165778195656200
147:105:11368178639005734015205277413927744920
147:106:4504372668285290836213411805518540440
147:107:1725974573828943217614484897441683720
147:108:639249842158867858375735147200623600
147:109:228722420588952719969299731567195600
147:110:79013199839820030534848998177758480
147:111:26337733279940010178282999392586160
147:112:8465699982837860414448106947616980
147:113:2622119463710841721289236665191100
147:114:782035629527794899331877601899100
147:115:224410224125367231982190964023220
147:116:61906268724239236408880265937440
147:117:16402515644883900245087933709920
147:118:4170131096156923791124050943200
147:119:1016250435197905797836953591200
147:120:237125101546178019495289171280
147:121:52912212741709144846056261360
147:122:11276373207249489885225104880
147:123:2291945773831197131143314000
147:124:443602407838296218930964000
147:125:81622843042246504283297376
147:126:14251607515312881700258272
147:127:2356565022217090674845856
147:128:368213284721420417944665
147:129:54232964416333239852315
147:130:7509179688415371671859
147:131:974473700023368842913
147:132:118118024245256829444
147:133:13321581681795883020
147:134:1391807041381659420
147:135:134025863244159796
147:136:11825811462719982
147:137:949517708685546
147:138:68805631064170
147:139:4455040860270
147:140:254573763444
147:141:12638413788
147:142:534017484
147:143:18671940
147:144:518665
147:145:10731
147:146:147
147:147:1

# binomial(148, k) for 0 <= k <= 148

148:0:1
148:1:148
148:2:10878
148:3:529396
148:4:19190605
148:5:552689424
148:6:13172431272
148:7:267212177232
148:8:4709614623714
148:9:73260671924440
148:10:1018323339749716
148:11:12775329171405528
148:12:145851674706879778
148:13:1525832904625819216
148:14:14713388723177542440
148:15:131439605927052712464
148:16:1092591724268625672357
148:17:8483653388438740514772
148:18:61742144104748611524174
148:19:422446249137753657796980
148:20:2724778306938511092790521
148:21:16608172537529972375104128
148:22:95874450557559385983555648
148:23:525225250880542723214261376
148:24:2735548181669493350074278000
148:25:13568318981080687016368418880
148:26:64188585948958634731281366240
148:27:290037314287887164341345432640
148:28:1253375536744083817332242762480
148:29:5186381531354829588961004534400
148:30:20572646741040824036211984653120
148:31:78308784369123136653968199647360
148:32:286316492849606468391071229960660
148:33:1006445853653162131314068565922320
148:34:3404155093238636620621114267090200
148:35:11087819446548702135737343612808080
148:36:34803433262777870592731106340203140
148:37:105350933119760040713131997570344640
148:38:307735620428772750504148729744954080
148:39:867972262747820578345034878767819200
148:40:2365224415987811075990220044642307320
148:41:6230347242114234053827896702960224160
148:42:15872551307291024851418689219446285360
148:43:39127684617973224052334443192123401120
148:44:93372883747436102852161739435749025400
148:45:215795109105185659924996020029286636480
148:46:483193396474654847223360653543837468640
148:47:1048632477455633923761335886414285570240
148:48:2206497504646229714581144260996725887380
148:49:4503056131931081050165600532646379362000
148:50:8916051141223540479327889054639831136760
148:51:17132804153723666019100649555974577478480
148:52:31959269286753761612553134748644884911780
148:53:57888487764686058769907564827734131160960
148:54:101840858104540288576689234419161897412800
148:55:174055284760487038658341600643658515578240
148:56:289056097905808832057603015354647177656720
148:57:466546684339200220163148726537325269200320
148:58:731995659911503793704250588187872405124640
148:59:1116603549017548159887839880286585024766400
148:60:1656295264376029770500295822425101120070160
148:61:2389409561722797045967639874973916369937280
148:62:3352881159191666822567494663269850390073280
148:63:4576948883975926138742929222876303707084160
148:64:6078760236530526903017952874132590860971150
148:65:7855628613362527074669354483494425112639640
148:66:9879048104683177987841763971667231581046820
148:67:12090775292298814850791412622040492382773720
148:68:14402247039355941219325065035077645338303990
148:69:16698257436934424602116017431974081551656800
148:70:18845176250254564908102362530370749179726960
148:71:20703151373519099476506820808012935718573280
148:72:22140870218902370273486461141902722921251980
148:73:23050768995021645764177685572391875918015760
148:74:23362265873332749085315221863910685052043000
148:75:23050768995021645764177685572391875918015760
148:76:22140870218902370273486461141902722921251980
148:77:20703151373519099476506820808012935718573280
148:78:18845176250254564908102362530370749179726960
148:79:16698257436934424602116017431974081551656800
148:80:14402247039355941219325065035077645338303990
148:81:12090775292298814850791412622040492382773720
148:82:9879048104683177987841763971667231581046820
148:83:7855628613362527074669354483494425112639640
148:84:6078760236530526903017952874132590860971150
148:85:4576948883975926138742929222876303707084160
148:86:3352881159191666822567494663269850390073280
148:87:2389409561722797045967639874973916369937280
148:88:1656295264376029770500295822425101120070160
148:89:1116603549017548159887839880286585024766400
148:90:731995659911503793704250588187872405124640
148:91:466546684339200220163148726537325269200320
148:92:289056097905808832057603015354647177656720
148:93:174055284760487038658341600643658515578240
148:94:101840858104540288576689234419161897412800
148:95:57888487764686058769907564827734131160960
148:96:31959269286753761612553134748644884911780
148:97:17132804153723666019100649555974577478480
148:98:8916051141223540479327889054639831136760
148:99:4503056131931081050165600532646379362000
148:100:2206497504646229714581144260996725887380
148:101:1048632477455633923761335886414285570240
148:102:483193396474654847223360653543837468640
148:103:215795109105185659924996020029286636480
148:104:93372883747436102852161739435749025400
148:105:39127684617973224052334443192123401120
148:106:15872551307291024851418689219446285360
148:107:6230347242114234053827896702960224160
148:108:2365224415987811075990220044642307320
148:109:867972262747820578345034878767819200
148:110:307735620428772750504148729744954080
148:111:105350933119760040713131997570344640
148:112:34803433262777870592731106340203140
148:113:11087819446548702135737343612808080
148:114:3404155093238636620621114267090200
148:115:1006445853653162131314068565922320
148:116:286316492849606468391071229960660
148:117:78308784369123136653968199647360
148:118:20572646741040824036211984653120
148:119:5186381531354829588961004534400
148:120:1253375536744083817332242762480
148:121:290037314287887164341345432640
148:122:64188585948958634731281366240
148:123:13568318981080687016368418880
148:124:2735548181669493350074278000
148:125:525225250880542723214261376
148:126:95874450557559385983555648
148:127:16608172537529972375104128
148:128:2724778306938511092790521
148:129:422446249137753657796980
148:130:61742144104748611524174
148:131:8483653388438740514772
148:132:1092591724268625672357
148:133:131439605927052712464
148:134:14713388723177542440
148:135:1525832904625819216
148:136:145851674706879778
148:137:12775329171405528
148:138:1018323339749716
148:139:73260671924440
148:140:4709614623714
148:141:267212177232
148:142:13172431272
148:143:552689424
148:144:19190605
148:145:529396
148:146:10878
148:147:148
148:148:1

# binomial(149, k) for 0 <= k <= 149

149:0:1
149:1:149
149:2:11026
149:3:540274
149:4:19720001
149:5:571880029
149:6:13725120696
149:7:280384608504
149:8:4976826800946
149:9:77970286548154
149:10:1091584011674156
149:11:13793652511155244
149:12:158627003878285306
149:13:1671684579332698994
149:14:16239221627803361656
149:15:146152994650230254904
149:16:1224031330195678384821
149:17:9576245112707366187129
149:18:70225797493187352038946
149:19:484188393242502269321154
149:20:3147224556076264750587501
149:21:19332950844468483467894649
149:22:112482623095089358358659776
149:23:621099701438102109197817024
149:24:3260773432550036073288539376
149:25:16303867162750180366442696880
149:26:77756904930039321747649785120
149:27:354225900236845799072626798880
149:28:1543412851031970981673588195120
149:29:6439757068098913406293247296880
149:30:25759028272395653625172989187520
149:31:98881431110163960690180184300480
149:32:364625277218729605045039429608020
149:33:1292762346502768599705139795882980
149:34:4410600946891798751935182833012520
149:35:14491974539787338756358457879898280
149:36:45891252709326572728468449953011220
149:37:140154366382537911305863103910547780
149:38:413086553548532791217280727315298720
149:39:1175707883176593328849183608512773280
149:40:3233196678735631654335254923410126520
149:41:8595571658102045129818116747602531480
149:42:22102898549405258905246585922406509520
149:43:55000235925264248903753132411569686480
149:44:132500568365409326904496182627872426520
149:45:309167992852621762777157759465035661880
149:46:698988505579840507148356673573124105120
149:47:1531825873930288770984696539958123038880
149:48:3255129982101863638342480147411011457620
149:49:6709553636577310764746744793643105249380
149:50:13419107273154621529493489587286210498760
149:51:26048855294947206498428538610614408615240
149:52:49092073440477427631653784304619462390260
149:53:89847757051439820382460699576379016072740
149:54:159729345869226347346596799246896028573760
149:55:275896142865027327235030835062820412991040
149:56:463111382666295870715944615998305693234960
149:57:755602782245009052220751741891972446857040
149:58:1198542344250704013867399314725197674324960
149:59:1848599208929051953592090468474457429891040
149:60:2772898813393577930388135702711686144836560
149:61:4045704826098826816467935697399017490007440
149:62:5742290720914463868535134538243766760010560
149:63:7929830043167592961310423886146154097157440
149:64:10655709120506453041760882097008894568055310
149:65:13934388849893053977687307357627015973610790
149:66:17734676718045705062511118455161656693686460
149:67:21969823396981992838633176593707723963820540
149:68:26493022331654756070116477657118137721077710
149:69:31100504476290365821441082467051726889960790
149:70:35543433687188989510218379962344830731383760
149:71:39548327623773664384609183338383684898300240
149:72:42844021592421469749993281949915658639825260
149:73:45191639213924016037664146714294598839267740
149:74:46413034868354394849492907436302560970058760
149:75:46413034868354394849492907436302560970058760
149:76:45191639213924016037664146714294598839267740
149:77:42844021592421469749993281949915658639825260
149:78:39548327623773664384609183338383684898300240
149:79:35543433687188989510218379962344830731383760
149:80:31100504476290365821441082467051726889960790
149:81:26493022331654756070116477657118137721077710
149:82:21969823396981992838633176593707723963820540
149:83:17734676718045705062511118455161656693686460
149:84:13934388849893053977687307357627015973610790
149:85:10655709120506453041760882097008894568055310
149:86:7929830043167592961310423886146154097157440
149:87:5742290720914463868535134538243766760010560
149:88:4045704826098826816467935697399017490007440
149:89:2772898813393577930388135702711686144836560
149:90:1848599208929051953592090468474457429891040
149:91:1198542344250704013867399314725197674324960
149:92:755602782245009052220751741891972446857040
149:93:463111382666295870715944615998305693234960
149:94:275896142865027327235030835062820412991040
149:95:159729345869226347346596799246896028573760
149:96:89847757051439820382460699576379016072740
149:97:49092073440477427631653784304619462390260
149:98:26048855294947206498428538610614408615240
149:99:13419107273154621529493489587286210498760
149:100:6709553636577310764746744793643105249380
149:101:3255129982101863638342480147411011457620
149:102:1531825873930288770984696539958123038880
149:103:698988505579840507148356673573124105120
149:104:309167992852621762777157759465035661880
149:105:132500568365409326904496182627872426520
149:106:55000235925264248903753132411569686480
149:107:22102898549405258905246585922406509520
149:108:8595571658102045129818116747602531480
149:109:3233196678735631654335254923410126520
149:110:1175707883176593328849183608512773280
149:111:413086553548532791217280727315298720
149:112:140154366382537911305863103910547780
149:113:45891252709326572728468449953011220
149:114:14491974539787338756358457879898280
149:115:4410600946891798751935182833012520
149:116:1292762346502768599705139795882980
149:117:364625277218729605045039429608020
149:118:98881431110163960690180184300480
149:119:25759028272395653625172989187520
149:120:6439757068098913406293247296880
149:121:1543412851031970981673588195120
149:122:354225900236845799072626798880
149:123:77756904930039321747649785120
149:124:16303867162750180366442696880
149:125:3260773432550036073288539376
149:126:621099701438102109197817024
149:127:112482623095089358358659776
149:128:19332950844468483467894649
149:129:3147224556076264750587501
149:130:484188393242502269321154
149:131:70225797493187352038946
149:132:9576245112707366187129
149:133:1224031330195678384821
149:134:146152994650230254904
149:135:16239221627803361656
149:136:1671684579332698994
149:137:158627003878285306
149:138:13793652511155244
149:139:1091584011674156
149:140:77970286548154
149:141:4976826800946
149:142:280384608504
149:143:13725120696
149:144:571880029
149:145:19720001
149:146:540274
149:147:11026
149:148:149
149:149:1

# binomial(150, k) for 0 <= k <= 150

150:0:1
150:1:150
150:2:11175
150:3:551300
150:4:20260275
150:5:591600030
150:6:14297000725
150:7:294109729200
150:8:5257211409450
150:9:82947113349100
150:10:1169554298222310
150:11:14885236522829400
150:12:172420656389440550
150:13:1830311583210984300
150:14:17910906207136060650
150:15:162392216278033616560
150:16:1370184324845908639725
150:17:10800276442903044571950
150:18:79802042605894718226075
150:19:554414190735689621360100
150:20:3631412949318767019908655
150:21:22480175400544748218482150
150:22:131815573939557841826554425
150:23:733582324533191467556476800
150:24:3881873133988138182486356400
150:25:19564640595300216439731236256
150:26:94060772092789502114092482000
150:27:431982805166885120820276584000
150:28:1897638751268816780746214994000
150:29:7983169919130884387966835492000
150:30:32198785340494567031466236484400
150:31:124640459382559614315353173488000
150:32:463506708328893565735219613908500
150:33:1657387623721498204750179225491000
150:34:5703363293394567351640322628895500
150:35:18902575486679137508293640712910800
150:36:60383227249113911484826907832909500
150:37:186045619091864484034331553863559000
150:38:553240919931070702523143831225846500
150:39:1588794436725126120066464335828072000
150:40:4408904561912224983184438531922899800
150:41:11828768336837676784153371671012658000
150:42:30698470207507304035064702670009041000
150:43:77103134474669507808999718333976196000
150:44:187500804290673575808249315039442113000
150:45:441668561218031089681653942092908088400
150:46:1008156498432462269925514433038159767000
150:47:2230814379510129278133053213531247144000
150:48:4786955856032152409327176687369134496500
150:49:9964683618679174403089224941054116707000
150:50:20128660909731932294240234380929315748140
150:51:39467962568101828027922028197900619114000
150:52:75140928735424634130082322915233871005500
150:53:138939830491917248014114483880998478463000
150:54:249577102920666167729057498823275044646500
150:55:435625488734253674581627634309716441564800
150:56:739007525531323197950975451061126106226000
150:57:1218714164911304922936696357890278140092000
150:58:1954145126495713066088151056617170121182000
150:59:3047141553179755967459489783199655104216000
150:60:4621498022322629883980226171186143574727600
150:61:6818603639492404746856071400110703634844000
150:62:9787995547013290685003070235642784250018000
150:63:13672120764082056829845558424389920857168000
150:64:18585539163674046003071305983155048665212750
150:65:24590097970399507019448189454635910541666100
150:66:31669065567938759040198425812788672667297250
150:67:39704500115027697901144295048869380657507000
150:68:48462845728636748908749654250825861684898250
150:69:57593526807945121891557560124169864611038500
150:70:66643938163479355331659462429396557621344550
150:71:75091761310962653894827563300728515629684000
150:72:82392349216195134134602465288299343538125500
150:73:88035660806345485787657428664210257479093000
150:74:91604674082278410887157054150597159809326500
150:75:92826069736708789698985814872605121940117520
150:76:91604674082278410887157054150597159809326500
150:77:88035660806345485787657428664210257479093000
150:78:82392349216195134134602465288299343538125500
150:79:75091761310962653894827563300728515629684000
150:80:66643938163479355331659462429396557621344550
150:81:57593526807945121891557560124169864611038500
150:82:48462845728636748908749654250825861684898250
150:83:39704500115027697901144295048869380657507000
150:84:31669065567938759040198425812788672667297250
150:85:24590097970399507019448189454635910541666100
150:86:18585539163674046003071305983155048665212750
150:87:13672120764082056829845558424389920857168000
150:88:9787995547013290685003070235642784250018000
150:89:6818603639492404746856071400110703634844000
150:90:4621498022322629883980226171186143574727600
150:91:3047141553179755967459489783199655104216000
150:92:1954145126495713066088151056617170121182000
150:93:1218714164911304922936696357890278140092000
150:94:739007525531323197950975451061126106226000
150:95:435625488734253674581627634309716441564800
150:96:249577102920666167729057498823275044646500
150:97:138939830491917248014114483880998478463000
150:98:75140928735424634130082322915233871005500
150:99:39467962568101828027922028197900619114000
150:100:20128660909731932294240234380929315748140
150:101:9964683618679174403089224941054116707000
150:102:4786955856032152409327176687369134496500
150:103:2230814379510129278133053213531247144000
150:104:1008156498432462269925514433038159767000
150:105:441668561218031089681653942092908088400
150:106:187500804290673575808249315039442113000
150:107:77103134474669507808999718333976196000
150:108:30698470207507304035064702670009041000
150:109:11828768336837676784153371671012658000
150:110:4408904561912224983184438531922899800
150:111:1588794436725126120066464335828072000
150:112:553240919931070702523143831225846500
150:113:186045619091864484034331553863559000
150:114:60383227249113911484826907832909500
150:115:18902575486679137508293640712910800
150:116:5703363293394567351640322628895500
150:117:1657387623721498204750179225491000
150:118:463506708328893565735219613908500
150:119:124640459382559614315353173488000
150:120:32198785340494567031466236484400
150:121:7983169919130884387966835492000
150:122:1897638751268816780746214994000
150:123:431982805166885120820276584000
150:124:94060772092789502114092482000
150:125:19564640595300216439731236256
150:126:3881873133988138182486356400
150:127:733582324533191467556476800
150:128:131815573939557841826554425
150:129:22480175400544748218482150
150:130:3631412949318767019908655
150:131:554414190735689621360100
150:132:79802042605894718226075
150:133:10800276442903044571950
150:134:1370184324845908639725
150:135:162392216278033616560
150:136:17910906207136060650
150:137:1830311583210984300
150:138:172420656389440550
150:139:14885236522829400
150:140:1169554298222310
150:141:82947113349100
150:142:5257211409450
150:143:294109729200
150:144:14297000725
150:145:591600030
150:146:20260275
150:147:551300
150:148:11175
150:149:150
150:150:1

# binomial(151, k) for 0 <= k <= 151

151:0:1
151:1:151
151:2:11325
151:3:562475
151:4:20811575
151:5:611860305
151:6:14888600755
151:7:308406729925
151:8:5551321138650
151:9:88204324758550
151:10:1252501411571410
151:11:16054790821051710
151:12:187305892912269950
151:13:2002732239600424850
151:14:19741217790347044950
151:15:180303122485169677210
151:16:1532576541123942256285
151:17:12170460767748953211675
151:18:90602319048797762798025
151:19:634216233341584339586175
151:20:4185827140054456641268755
151:21:26111588349863515238390805
151:22:154295749340102590045036575
151:23:865397898472749309383031225
151:24:4615455458521329650042833200
151:25:23446513729288354622217592656
151:26:113625412688089718553823718256
151:27:526043577259674622934369066000
151:28:2329621556435701901566491578000
151:29:9880808670399701168713050486000
151:30:40181955259625451419433071976400
151:31:156839244723054181346819409972400
151:32:588147167711453180050572787396500
151:33:2120894332050391770485398839399500
151:34:7360750917116065556390501854386500
151:35:24605938780073704859933963341806300
151:36:79285802735793048993120548545820300
151:37:246428846340978395519158461696468500
151:38:739286539022935186557475385089405500
151:39:2142035356656196822589608167053918500
151:40:5997698998637351103250902867750971800
151:41:16237672898749901767337810202935557800
151:42:42527238544344980819218074341021699000
151:43:107801604682176811844064421003985237000
151:44:264603938765343083617249033373418309000
151:45:629169365508704665489903257132350201400
151:46:1449825059650493359607168375131067855400
151:47:3238970877942591548058567646569406911000
151:48:7017770235542281687460229900900381640500
151:49:14751639474711326812416401628423251203500
151:50:30093344528411106697329459321983432455140
151:51:59596623477833760322162262578829934862140
151:52:114608891303526462158004351113134490119500
151:53:214080759227341882144196806796232349468500
151:54:388516933412583415743171982704273523109500
151:55:685202591654919842310685133132991486211300
151:56:1174633014265576872532603085370842547790800
151:57:1957721690442628120887671808951404246318000
151:58:3172859291407017989024847414507448261274000
151:59:5001286679675469033547640839816825225398000
151:60:7668639575502385851439715954385798678943600
151:61:11440101661815034630836297571296847209571600
151:62:16606599186505695431859141635753487884862000
151:63:23460116311095347514848628660032705107186000
151:64:32257659927756102832916864407544969522380750
151:65:43175637134073553022519495437790959206878850
151:66:56259163538338266059646615267424583208963350
151:67:71373565682966456941342720861658053324804250
151:68:88167345843664446809893949299695242342405250
151:69:106056372536581870800307214374995726295936750
151:70:124237464971424477223217022553566422232383050
151:71:141735699474442009226487025730125073251028550
151:72:157484110527157788029430028589027859167809500
151:73:170428010022540619922259893952509601017218500
151:74:179640334888623896674814482814807417288419500
151:75:184430743818987200586142869023202281749444020
151:76:184430743818987200586142869023202281749444020
151:77:179640334888623896674814482814807417288419500
151:78:170428010022540619922259893952509601017218500
151:79:157484110527157788029430028589027859167809500
151:80:141735699474442009226487025730125073251028550
151:81:124237464971424477223217022553566422232383050
151:82:106056372536581870800307214374995726295936750
151:83:88167345843664446809893949299695242342405250
151:84:71373565682966456941342720861658053324804250
151:85:56259163538338266059646615267424583208963350
151:86:43175637134073553022519495437790959206878850
151:87:32257659927756102832916864407544969522380750
151:88:23460116311095347514848628660032705107186000
151:89:16606599186505695431859141635753487884862000
151:90:11440101661815034630836297571296847209571600
151:91:7668639575502385851439715954385798678943600
151:92:5001286679675469033547640839816825225398000
151:93:3172859291407017989024847414507448261274000
151:94:1957721690442628120887671808951404246318000
151:95:1174633014265576872532603085370842547790800
151:96:685202591654919842310685133132991486211300
151:97:388516933412583415743171982704273523109500
151:98:214080759227341882144196806796232349468500
151:99:114608891303526462158004351113134490119500
151:100:59596623477833760322162262578829934862140
151:101:30093344528411106697329459321983432455140
151:102:14751639474711326812416401628423251203500
151:103:7017770235542281687460229900900381640500
151:104:3238970877942591548058567646569406911000
151:105:1449825059650493359607168375131067855400
151:106:629169365508704665489903257132350201400
151:107:264603938765343083617249033373418309000
151:108:107801604682176811844064421003985237000
151:109:42527238544344980819218074341021699000
151:110:16237672898749901767337810202935557800
151:111:5997698998637351103250902867750971800
151:112:2142035356656196822589608167053918500
151:113:739286539022935186557475385089405500
151:114:246428846340978395519158461696468500
151:115:79285802735793048993120548545820300
151:116:24605938780073704859933963341806300
151:117:7360750917116065556390501854386500
151:118:2120894332050391770485398839399500
151:119:588147167711453180050572787396500
151:120:156839244723054181346819409972400
151:121:40181955259625451419433071976400
151:122:9880808670399701168713050486000
151:123:2329621556435701901566491578000
151:124:526043577259674622934369066000
151:125:113625412688089718553823718256
151:126:23446513729288354622217592656
151:127:4615455458521329650042833200
151:128:865397898472749309383031225
151:129:154295749340102590045036575
151:130:26111588349863515238390805
151:131:4185827140054456641268755
151:132:634216233341584339586175
151:133:90602319048797762798025
151:134:12170460767748953211675
151:135:1532576541123942256285
151:136:180303122485169677210
151:137:19741217790347044950
151:138:2002732239600424850
151:139:187305892912269950
151:140:16054790821051710
151:141:1252501411571410
151:142:88204324758550
151:143:5551321138650
151:144:308406729925
151:145:14888600755
151:146:611860305
151:147:20811575
151:148:562475
151:149:11325
151:150:151
151:151:1

# binomial(152, k) for 0 <= k <= 152

152:0:1
152:1:152
152:2:11476
152:3:573800
152:4:21374050
152:5:632671880
152:6:15500461060
152:7:323295330680
152:8:5859727868575
152:9:93755645897200
152:10:1340705736329960
152:11:17307292232623120
152:12:203360683733321660
152:13:2190038132512694800
152:14:21743950029947469800
152:15:200044340275516722160
152:16:1712879663609111933495
152:17:13703037308872895467960
152:18:102772779816546716009700
152:19:724818552390382102384200
152:20:4820043373396040980854930
152:21:30297415489917971879659560
152:22:180407337689966105283427380
152:23:1019693647812851899428067800
152:24:5480853356994078959425864425
152:25:28061969187809684272260425856
152:26:137071926417378073176041310912
152:27:639668989947764341488192784256
152:28:2855665133695376524500860644000
152:29:12210430226835403070279542064000
152:30:50062763930025152588146122462400
152:31:197021199982679632766252481948800
152:32:744986412434507361397392197368900
152:33:2709041499761844950535971626796000
152:34:9481645249166457326875900693786000
152:35:31966689697189770416324465196192800
152:36:103891741515866753853054511887626600
152:37:325714649076771444512279010242288800
152:38:985715385363913582076633846785874000
152:39:2881321895679132009147083552143324000
152:40:8139734355293547925840511034804890300
152:41:22235371897387252870588713070686529600
152:42:58764911443094882586555884543957256800
152:43:150328843226521792663282495345006936000
152:44:372405543447519895461313454377403546000
152:45:893773304274047749107152290505768510400
152:46:2078994425159198025097071632263418056800
152:47:4688795937593084907665736021700474766400
152:48:10256741113484873235518797547469788551500
152:49:21769409710253608499876631529323632844000
152:50:44844984003122433509745860950406683658640
152:51:89689968006244867019491721900813367317280
152:52:174205514781360222480166613691964424981640
152:53:328689650530868344302201157909366839588000
152:54:602597692639925297887368789500505872578000
152:55:1073719525067503258053857115837265009320800
152:56:1859835605920496714843288218503834034002100
152:57:3132354704708204993420274894322246794108800
152:58:5130580981849646109912519223458852507592000
152:59:8174145971082487022572488254324273486672000
152:60:12669926255177854884987356794202623904341600
152:61:19108741237317420482276013525682645888515200
152:62:28046700848320730062695439207050335094433600
152:63:40066715497601042946707770295786192992048000
152:64:55717776238851450347765493067577674629566750
152:65:75433297061829655855436359845335928729259600
152:66:99434800672411819082166110705215542415842200
152:67:127632729221304723000989336129082636533767600
152:68:159540911526630903751236670161353295667209500
152:69:194223718380246317610201163674690968638342000
152:70:230293837508006348023524236928562148528319800
152:71:265973164445866486449704048283691495483411600
152:72:299219810001599797255917054319152932418838050
152:73:327912120549698407951689922541537460185028000
152:74:350068344911164516597074376767317018305638000
152:75:364071078707611097260957351838009699037863520
152:76:368861487637974401172285738046404563498888040
152:77:364071078707611097260957351838009699037863520
152:78:350068344911164516597074376767317018305638000
152:79:327912120549698407951689922541537460185028000
152:80:299219810001599797255917054319152932418838050
152:81:265973164445866486449704048283691495483411600
152:82:230293837508006348023524236928562148528319800
152:83:194223718380246317610201163674690968638342000
152:84:159540911526630903751236670161353295667209500
152:85:127632729221304723000989336129082636533767600
152:86:99434800672411819082166110705215542415842200
152:87:75433297061829655855436359845335928729259600
152:88:55717776238851450347765493067577674629566750
152:89:40066715497601042946707770295786192992048000
152:90:28046700848320730062695439207050335094433600
152:91:19108741237317420482276013525682645888515200
152:92:12669926255177854884987356794202623904341600
152:93:8174145971082487022572488254324273486672000
152:94:5130580981849646109912519223458852507592000
152:95:3132354704708204993420274894322246794108800
152:96:1859835605920496714843288218503834034002100
152:97:1073719525067503258053857115837265009320800
152:98:602597692639925297887368789500505872578000
152:99:328689650530868344302201157909366839588000
152:100:174205514781360222480166613691964424981640
152:101:89689968006244867019491721900813367317280
152:102:44844984003122433509745860950406683658640
152:103:21769409710253608499876631529323632844000
152:104:10256741113484873235518797547469788551500
152:105:4688795937593084907665736021700474766400
152:106:2078994425159198025097071632263418056800
152:107:893773304274047749107152290505768510400
152:108:372405543447519895461313454377403546000
152:109:150328843226521792663282495345006936000
152:110:58764911443094882586555884543957256800
152:111:22235371897387252870588713070686529600
152:112:8139734355293547925840511034804890300
152:113:2881321895679132009147083552143324000
152:114:985715385363913582076633846785874000
152:115:325714649076771444512279010242288800
152:116:103891741515866753853054511887626600
152:117:31966689697189770416324465196192800
152:118:9481645249166457326875900693786000
152:119:2709041499761844950535971626796000
152:120:744986412434507361397392197368900
152:121:197021199982679632766252481948800
152:122:50062763930025152588146122462400
152:123:12210430226835403070279542064000
152:124:2855665133695376524500860644000
152:125:639668989947764341488192784256
152:126:137071926417378073176041310912
152:127:28061969187809684272260425856
152:128:5480853356994078959425864425
152:129:1019693647812851899428067800
152:130:180407337689966105283427380
152:131:30297415489917971879659560
152:132:4820043373396040980854930
152:133:724818552390382102384200
152:134:102772779816546716009700
152:135:13703037308872895467960
152:136:1712879663609111933495
152:137:200044340275516722160
152:138:21743950029947469800
152:139:2190038132512694800
152:140:203360683733321660
152:141:17307292232623120
152:142:1340705736329960
152:143:93755645897200
152:144:5859727868575
152:145:323295330680
152:146:15500461060
152:147:632671880
152:148:21374050
152:149:573800
152:150:11476
152:151:152
152:152:1

# binomial(153, k) for 0 <= k <= 153

153:0:1
153:1:153
153:2:11628
153:3:585276
153:4:21947850
153:5:654045930
153:6:16133132940
153:7:338795791740
153:8:6183023199255
153:9:99615373765775
153:10:1434461382227160
153:11:18647997968953080
153:12:220667975965944780
153:13:2393398816246016460
153:14:23933988162460164600
153:15:221788290305464191960
153:16:1912924003884628655655
153:17:15415916972482007401455
153:18:116475817125419611477660
153:19:827591332206928818393900
153:20:5544861925786423083239130
153:21:35117458863314012860514490
153:22:210704753179884077163086940
153:23:1200100985502818004711495180
153:24:6500547004806930858853932225
153:25:33542822544803763231686290281
153:26:165133895605187757448301736768
153:27:776740916365142414664234095168
153:28:3495334123643140865989053428256
153:29:15066095360530779594780402708000
153:30:62273194156860555658425664526400
153:31:247083963912704785354398604411200
153:32:942007612417186994163644679317700
153:33:3454027912196352311933363824164900
153:34:12190686748928302277411872320582000
153:35:41448334946356227743200365889978800
153:36:135858431213056524269378977083819400
153:37:429606390592638198365333522129915400
153:38:1311430034440685026588912857028162800
153:39:3867037281043045591223717398929198000
153:40:11021056250972679934987594586948214300
153:41:30375106252680800796429224105491419900
153:42:81000283340482135457144597614643786400
153:43:209093754669616675249838379888964192800
153:44:522734386674041688124595949722410482000
153:45:1266178847721567644568465744883172056400
153:46:2972767729433245774204223922769186567200
153:47:6767790362752282932762807653963892823200
153:48:14945537051077958143184533569170263317900
153:49:32026150823738481735395429076793421395500
153:50:66614393713376042009622492479730316502640
153:51:134534952009367300529237582851220050975920
153:52:263895482787605089499658335592777792298920
153:53:502895165312228566782367771601331264569640
153:54:931287343170793642189569947409872712166000
153:55:1676317217707428555941225905337770881898800
153:56:2933555130987999972897145334341099043322900
153:57:4992190310628701708263563112826080828110900
153:58:8262935686557851103332794117781099301700800
153:59:13304726952932133132485007477783125994264000
153:60:20844072226260341907559845048526897391013600
153:61:31778667492495275367263370319885269792856800
153:62:47155442085638150544971452732732980982948800
153:63:68113416345921773009403209502836528086481600
153:64:95784491736452493294473263363363867621614750
153:65:131151073300681106203201852912913603358826350
153:66:174868097734241474937602470550551471145101800
153:67:227067529893716542083155446834298178949609800
153:68:287173640747935626752226006290435932200977100
153:69:353764629906877221361437833836044264305551500
153:70:424517555888252665633725400603253117166661800
153:71:496267001953872834473228285212253644011731400
153:72:565192974447466283705621102602844427902249650
153:73:627131930551298205207606976860690392603866050
153:74:677980465460862924548764299308854478490666000
153:75:714139423618775613858031728605326717343501520
153:76:732932566345585498433243089884414262536751560
153:77:732932566345585498433243089884414262536751560
153:78:714139423618775613858031728605326717343501520
153:79:677980465460862924548764299308854478490666000
153:80:627131930551298205207606976860690392603866050
153:81:565192974447466283705621102602844427902249650
153:82:496267001953872834473228285212253644011731400
153:83:424517555888252665633725400603253117166661800
153:84:353764629906877221361437833836044264305551500
153:85:287173640747935626752226006290435932200977100
153:86:227067529893716542083155446834298178949609800
153:87:174868097734241474937602470550551471145101800
153:88:131151073300681106203201852912913603358826350
153:89:95784491736452493294473263363363867621614750
153:90:68113416345921773009403209502836528086481600
153:91:47155442085638150544971452732732980982948800
153:92:31778667492495275367263370319885269792856800
153:93:20844072226260341907559845048526897391013600
153:94:13304726952932133132485007477783125994264000
153:95:8262935686557851103332794117781099301700800
153:96:4992190310628701708263563112826080828110900
153:97:2933555130987999972897145334341099043322900
153:98:1676317217707428555941225905337770881898800
153:99:931287343170793642189569947409872712166000
153:100:502895165312228566782367771601331264569640
153:101:263895482787605089499658335592777792298920
153:102:134534952009367300529237582851220050975920
153:103:66614393713376042009622492479730316502640
153:104:32026150823738481735395429076793421395500
153:105:14945537051077958143184533569170263317900
153:106:6767790362752282932762807653963892823200
153:107:2972767729433245774204223922769186567200
153:108:1266178847721567644568465744883172056400
153:109:522734386674041688124595949722410482000
153:110:209093754669616675249838379888964192800
153:111:81000283340482135457144597614643786400
153:112:30375106252680800796429224105491419900
153:113:11021056250972679934987594586948214300
153:114:3867037281043045591223717398929198000
153:115:1311430034440685026588912857028162800
153:116:429606390592638198365333522129915400
153:117:135858431213056524269378977083819400
153:118:41448334946356227743200365889978800
153:119:12190686748928302277411872320582000
153:120:3454027912196352311933363824164900
153:121:942007612417186994163644679317700
153:122:247083963912704785354398604411200
153:123:62273194156860555658425664526400
153:124:15066095360530779594780402708000
153:125:3495334123643140865989053428256
153:126:776740916365142414664234095168
153:127:165133895605187757448301736768
153:128:33542822544803763231686290281
153:129:6500547004806930858853932225
153:130:1200100985502818004711495180
153:131:210704753179884077163086940
153:132:35117458863314012860514490
153:133:5544861925786423083239130
153:134:827591332206928818393900
153:135:116475817125419611477660
153:136:15415916972482007401455
153:137:1912924003884628655655
153:138:221788290305464191960
153:139:23933988162460164600
153:140:2393398816246016460
153:141:220667975965944780
153:142:18647997968953080
153:143:1434461382227160
153:144:99615373765775
153:145:6183023199255
153:146:338795791740
153:147:16133132940
153:148:654045930
153:149:21947850
153:150:585276
153:151:11628
153:152:153
153:153:1

# binomial(154, k) for 0 <= k <= 154

154:0:1
154:1:154
154:2:11781
154:3:596904
154:4:22533126
154:5:675993780
154:6:16787178870
154:7:354928924680
154:8:6521818990995
154:9:105798396965030
154:10:1534076755992935
154:11:20082459351180240
154:12:239315973934897860
154:13:2614066792211961240
154:14:26327386978706181060
154:15:245722278467924356560
154:16:2134712294190092847615
154:17:17328840976366636057110
154:18:131891734097901618879115
154:19:944067149332348429871560
154:20:6372453257993351901633030
154:21:40662320789100435943753620
154:22:245822212043198090023601430
154:23:1410805738682702081874582120
154:24:7700647990309748863565427405
154:25:40043369549610694090540222506
154:26:198676718149991520679988027049
154:27:941874811970330172112535831936
154:28:4272075040008283280653287523424
154:29:18561429484173920460769456136256
154:30:77339289517391335253206067234400
154:31:309357158069565341012824268937600
154:32:1189091576329891779518043283728900
154:33:4396035524613539306097008503482600
154:34:15644714661124654589345236144746900
154:35:53639021695284530020612238210560800
154:36:177306766159412752012579342973798200
154:37:565464821805694722634712499213734800
154:38:1741036425033323224954246379158078200
154:39:5178467315483730617812630255957360800
154:40:14888093532015725526211311985877412300
154:41:41396162503653480731416818692439634200
154:42:111375389593162936253573821720135206300
154:43:290094038010098810706982977503607979200
154:44:731828141343658363374434329611374674800
154:45:1788913234395609332693061694605582538400
154:46:4238946577154813418772689667652358623600
154:47:9740558092185528706967031576733079390400
154:48:21713327413830241075947341223134156141100
154:49:46971687874816439878579962645963684713400
154:50:98640544537114523745017921556523737898140
154:51:201149345722743342538860075330950367478560
154:52:398430434796972390028895918443997843274840
154:53:766790648099833656282026107194109056868560
154:54:1434182508483022208971937719011203976735640
154:55:2607604560878222198130795852747643594064800
154:56:4609872348695428528838371239678869925221700
154:57:7925745441616701681160708447167179871433800
154:58:13255125997186552811596357230607180129811700
154:59:21567662639489984235817801595564225295964800
154:60:34148799179192475040044852526310023385277600
154:61:52622739718755617274823215368412167183870400
154:62:78934109578133425912234823052618250775805600
154:63:115268858431559923554374662235569509069430400
154:64:163897908082374266303876472866200395708096350
154:65:226935565037133599497675116276277470980441100
154:66:306019171034922581140804323463465074503928150
154:67:401935627627958017020757917384849650094711600
154:68:514241170641652168835381453124734111150586900
154:69:640938270654812848113663840126480196506528600
154:70:778282185795129886995163234439297381472213300
154:71:920784557842125500106953685815506761178393200
154:72:1061459976401339118178849387815098071913981050
154:73:1192324904998764488913228079463534820506115700
154:74:1305112396012161129756371276169544871094532050
154:75:1392119889079638538406796027914181195834167520
154:76:1447071989964361112291274818489740979880253080
154:77:1465865132691170996866486179768828525073503120
154:78:1447071989964361112291274818489740979880253080
154:79:1392119889079638538406796027914181195834167520
154:80:1305112396012161129756371276169544871094532050
154:81:1192324904998764488913228079463534820506115700
154:82:1061459976401339118178849387815098071913981050
154:83:920784557842125500106953685815506761178393200
154:84:778282185795129886995163234439297381472213300
154:85:640938270654812848113663840126480196506528600
154:86:514241170641652168835381453124734111150586900
154:87:401935627627958017020757917384849650094711600
154:88:306019171034922581140804323463465074503928150
154:89:226935565037133599497675116276277470980441100
154:90:163897908082374266303876472866200395708096350
154:91:115268858431559923554374662235569509069430400
154:92:78934109578133425912234823052618250775805600
154:93:52622739718755617274823215368412167183870400
154:94:34148799179192475040044852526310023385277600
154:95:21567662639489984235817801595564225295964800
154:96:13255125997186552811596357230607180129811700
154:97:7925745441616701681160708447167179871433800
154:98:4609872348695428528838371239678869925221700
154:99:2607604560878222198130795852747643594064800
154:100:1434182508483022208971937719011203976735640
154:101:766790648099833656282026107194109056868560
154:102:398430434796972390028895918443997843274840
154:103:201149345722743342538860075330950367478560
154:104:98640544537114523745017921556523737898140
154:105:46971687874816439878579962645963684713400
154:106:21713327413830241075947341223134156141100
154:107:9740558092185528706967031576733079390400
154:108:4238946577154813418772689667652358623600
154:109:1788913234395609332693061694605582538400
154:110:731828141343658363374434329611374674800
154:111:290094038010098810706982977503607979200
154:112:111375389593162936253573821720135206300
154:113:41396162503653480731416818692439634200
154:114:14888093532015725526211311985877412300
154:115:5178467315483730617812630255957360800
154:116:1741036425033323224954246379158078200
154:117:565464821805694722634712499213734800
154:118:177306766159412752012579342973798200
154:119:53639021695284530020612238210560800
154:120:15644714661124654589345236144746900
154:121:4396035524613539306097008503482600
154:122:1189091576329891779518043283728900
154:123:309357158069565341012824268937600
154:124:77339289517391335253206067234400
154:125:18561429484173920460769456136256
154:126:4272075040008283280653287523424
154:127:941874811970330172112535831936
154:128:198676718149991520679988027049
154:129:40043369549610694090540222506
154:130:7700647990309748863565427405
154:131:1410805738682702081874582120
154:132:245822212043198090023601430
154:133:40662320789100435943753620
154:134:6372453257993351901633030
154:135:944067149332348429871560
154:136:131891734097901618879115
154:137:17328840976366636057110
154:138:2134712294190092847615
154:139:245722278467924356560
154:140:26327386978706181060
154:141:2614066792211961240
154:142:239315973934897860
154:143:20082459351180240
154:144:1534076755992935
154:145:105798396965030
154:146:6521818990995
154:147:354928924680
154:148:16787178870
154:149:675993780
154:150:22533126
154:151:596904
154:152:11781
154:153:154
154:154:1

# binomial(155, k) for 0 <= k <= 155

155:0:1
155:1:155
155:2:11935
155:3:608685
155:4:23130030
155:5:698526906
155:6:17463172650
155:7:371716103550
155:8:6876747915675
155:9:112320215956025
155:10:1639875152957965
155:11:21616536107173175
155:12:259398433286078100
155:13:2853382766146859100
155:14:28941453770918142300
155:15:272049665446630537620
155:16:2380434572658017204175
155:17:19463553270556728904725
155:18:149220575074268254936225
155:19:1075958883430250048750675
155:20:7316520407325700331504590
155:21:47034774047093787845386650
155:22:286484532832298525967355050
155:23:1656627950725900171898183550
155:24:9111453728992450945440009525
155:25:47744017539920442954105649911
155:26:238720087699602214770528249555
155:27:1140551530120321692792523858985
155:28:5213949851978613452765823355360
155:29:22833504524182203741422743659680
155:30:95900719001565255713975523370656
155:31:386696447586956676266030336172000
155:32:1498448734399457120530867552666500
155:33:5585127100943431085615051787211500
155:34:20040750185738193895442244648229500
155:35:69283736356409184609957474355307700
155:36:230945787854697282033191581184359000
155:37:742771587965107474647291842187533000
155:38:2306501246839017947588958878371813000
155:39:6919503740517053842766876635115439000
155:40:20066560847499456144023942241834773100
155:41:56284256035669206257628130678317046500
155:42:152771552096816416984990640412574840500
155:43:401469427603261746960556799223743185500
155:44:1021922179353757174081417307114982654000
155:45:2520741375739267696067496024216957213200
155:46:6027859811550422751465751362257941162000
155:47:13979504669340342125739721244385438014000
155:48:31453885506015769782914372799867235531500
155:49:68685015288646680954527303869097840854500
155:50:145612232411930963623597884202487422611540
155:51:299789890259857866283877996887474105376700
155:52:599579780519715732567755993774948210753400
155:53:1165221082896806046310922025638106900143400
155:54:2200973156582855865253963826205313033604200
155:55:4041787069361244407102733571758847570800440
155:56:7217476909573650726969167092426513519286500
155:57:12535617790312130209999079686846049796655500
155:58:21180871438803254492757065677774360001245500
155:59:34822788636676537047414158826171405425776500
155:60:55716461818682459275862654121874248681242400
155:61:86771538897948092314868067894722190569148000
155:62:131556849296889043187058038421030417959676000
155:63:194202968009693349466609485288187759845236000
155:64:279166766513934189858251135101769904777526750
155:65:390833473119507865801551589142477866688537450
155:66:532954736072056180638479439739742545484369250
155:67:707954798662880598161562240848314724598639750
155:68:916176798269610185856139370509583761245298500
155:69:1155179441296465016949045293251214307657115500
155:70:1419220456449942735108827074565777577978741900
155:71:1699066743637255387102116920254804142650606500
155:72:1982244534243464618285803073630604833092374250
155:73:2253784881400103607092077467278632892420096750
155:74:2497437301010925618669599355633079691600647750
155:75:2697232285091799668163167304083726066928699570
155:76:2839191879043999650698070846403922175714420600
155:77:2912937122655532109157760998258569504953756200
155:78:2912937122655532109157760998258569504953756200
155:79:2839191879043999650698070846403922175714420600
155:80:2697232285091799668163167304083726066928699570
155:81:2497437301010925618669599355633079691600647750
155:82:2253784881400103607092077467278632892420096750
155:83:1982244534243464618285803073630604833092374250
155:84:1699066743637255387102116920254804142650606500
155:85:1419220456449942735108827074565777577978741900
155:86:1155179441296465016949045293251214307657115500
155:87:916176798269610185856139370509583761245298500
155:88:707954798662880598161562240848314724598639750
155:89:532954736072056180638479439739742545484369250
155:90:390833473119507865801551589142477866688537450
155:91:279166766513934189858251135101769904777526750
155:92:194202968009693349466609485288187759845236000
155:93:131556849296889043187058038421030417959676000
155:94:86771538897948092314868067894722190569148000
155:95:55716461818682459275862654121874248681242400
155:96:34822788636676537047414158826171405425776500
155:97:21180871438803254492757065677774360001245500
155:98:12535617790312130209999079686846049796655500
155:99:7217476909573650726969167092426513519286500
155:100:4041787069361244407102733571758847570800440
155:101:2200973156582855865253963826205313033604200
155:102:1165221082896806046310922025638106900143400
155:103:599579780519715732567755993774948210753400
155:104:299789890259857866283877996887474105376700
155:105:145612232411930963623597884202487422611540
155:106:68685015288646680954527303869097840854500
155:107:31453885506015769782914372799867235531500
155:108:13979504669340342125739721244385438014000
155:109:6027859811550422751465751362257941162000
155:110:2520741375739267696067496024216957213200
155:111:1021922179353757174081417307114982654000
155:112:401469427603261746960556799223743185500
155:113:152771552096816416984990640412574840500
155:114:56284256035669206257628130678317046500
155:115:20066560847499456144023942241834773100
155:116:6919503740517053842766876635115439000
155:117:2306501246839017947588958878371813000
155:118:742771587965107474647291842187533000
155:119:230945787854697282033191581184359000
155:120:69283736356409184609957474355307700
155:121:20040750185738193895442244648229500
155:122:5585127100943431085615051787211500
155:123:1498448734399457120530867552666500
155:124:386696447586956676266030336172000
155:125:95900719001565255713975523370656
155:126:22833504524182203741422743659680
155:127:5213949851978613452765823355360
155:128:1140551530120321692792523858985
155:129:238720087699602214770528249555
155:130:47744017539920442954105649911
155:131:9111453728992450945440009525
155:132:1656627950725900171898183550
155:133:286484532832298525967355050
155:134:47034774047093787845386650
155:135:7316520407325700331504590
155:136:1075958883430250048750675
155:137:149220575074268254936225
155:138:19463553270556728904725
155:139:2380434572658017204175
155:140:272049665446630537620
155:141:28941453770918142300
155:142:2853382766146859100
155:143:259398433286078100
155:144:21616536107173175
155:145:1639875152957965
155:146:112320215956025
155:147:6876747915675
155:148:371716103550
155:149:17463172650
155:150:698526906
155:151:23130030
155:152:608685
155:153:11935
155:154:155
155:155:1

# binomial(156, k) for 0 <= k <= 156

156:0:1
156:1:156
156:2:12090
156:3:620620
156:4:23738715
156:5:721656936
156:6:18161699556
156:7:389179276200
156:8:7248464019225
156:9:119196963871700
156:10:1752195368913990
156:11:23256411260131140
156:12:281014969393251275
156:13:3112781199432937200
156:14:31794836537065001400
156:15:300991119217548679920
156:16:2652484238104647741795
156:17:21843987843214746108900
156:18:168684128344824983840950
156:19:1225179458504518303686900
156:20:8392479290755950380255265
156:21:54351294454419488176891240
156:22:333519306879392313812741700
156:23:1943112483558198697865538600
156:24:10768081679718351117338193075
156:25:56855471268912893899545659436
156:26:286464105239522657724633899466
156:27:1379271617819923907563052108540
156:28:6354501382098935145558347214345
156:29:28047454376160817194188567015040
156:30:118734223525747459455398267030336
156:31:482597166588521931980005859542656
156:32:1885145181986413796796897888838500
156:33:7083575835342888206145919339878000
156:34:25625877286681624981057296435441000
156:35:89324486542147378505399719003537200
156:36:300229524211106466643149055539666700
156:37:973717375819804756680483423371892000
156:38:3049272834804125422236250720559346000
156:39:9226004987356071790355835513487252000
156:40:26986064588016509986790818876950212100
156:41:76350816883168662401652072920151819600
156:42:209055808132485623242618771090891887000
156:43:554240979700078163945547439636318026000
156:44:1423391606957018921041974106338725839500
156:45:3542663555093024870148913331331939867200
156:46:8548601187289690447533247386474898375200
156:47:20007364480890764877205472606643379176000
156:48:45433390175356111908654094044252673545500
156:49:100138900794662450737441676668965076386000
156:50:214297247700577644578125188071585263466040
156:51:445402122671788829907475881089961527988240
156:52:899369670779573598851633990662422316130100
156:53:1764800863416521778878678019413055110896800
156:54:3366194239479661911564885851843419933747600
156:55:6242760225944100272356697397964160604404640
156:56:11259263978934895134071900664185361090086940
156:57:19753094699885780936968246779272563315942000
156:58:33716489229115384702756145364620409797901000
156:59:56003660075479791540171224503945765427022000
156:60:90539250455358996323276812948045654107018900
156:61:142488000716630551590730722016596439250390400
156:62:218328388194837135501926106315752608528824000
156:63:325759817306582392653667523709218177804912000
156:64:473369734523627539324860620389957664622762750
156:65:670000239633442055659802724244247771466064200
156:66:923788209191564046440031028882220412172906700
156:67:1240909534734936778800041680588057270083009000
156:68:1624131596932490784017701611357898485843938250
156:69:2071356239566075202805184663760798068902414000
156:70:2574399897746407752057872367816991885635857400
156:71:3118287200087198122210943994820581720629348400
156:72:3681311277880720005387919993885408975742980750
156:73:4236029415643568225377880540909237725512471000
156:74:4751222182411029225761676822911712584020744500
156:75:5194669586102725286832766659716805758529347320
156:76:5536424164135799318861238150487648242643120170
156:77:5752129001699531759855831844662491680668176800
156:78:5825874245311064218315521996517139009907512400
156:79:5752129001699531759855831844662491680668176800
156:80:5536424164135799318861238150487648242643120170
156:81:5194669586102725286832766659716805758529347320
156:82:4751222182411029225761676822911712584020744500
156:83:4236029415643568225377880540909237725512471000
156:84:3681311277880720005387919993885408975742980750
156:85:3118287200087198122210943994820581720629348400
156:86:2574399897746407752057872367816991885635857400
156:87:2071356239566075202805184663760798068902414000
156:88:1624131596932490784017701611357898485843938250
156:89:1240909534734936778800041680588057270083009000
156:90:923788209191564046440031028882220412172906700
156:91:670000239633442055659802724244247771466064200
156:92:473369734523627539324860620389957664622762750
156:93:325759817306582392653667523709218177804912000
156:94:218328388194837135501926106315752608528824000
156:95:142488000716630551590730722016596439250390400
156:96:90539250455358996323276812948045654107018900
156:97:56003660075479791540171224503945765427022000
156:98:33716489229115384702756145364620409797901000
156:99:19753094699885780936968246779272563315942000
156:100:11259263978934895134071900664185361090086940
156:101:6242760225944100272356697397964160604404640
156:102:3366194239479661911564885851843419933747600
156:103:1764800863416521778878678019413055110896800
156:104:899369670779573598851633990662422316130100
156:105:445402122671788829907475881089961527988240
156:106:214297247700577644578125188071585263466040
156:107:100138900794662450737441676668965076386000
156:108:45433390175356111908654094044252673545500
156:109:20007364480890764877205472606643379176000
156:110:8548601187289690447533247386474898375200
156:111:3542663555093024870148913331331939867200
156:112:1423391606957018921041974106338725839500
156:113:554240979700078163945547439636318026000
156:114:209055808132485623242618771090891887000
156:115:76350816883168662401652072920151819600
156:116:26986064588016509986790818876950212100
156:117:9226004987356071790355835513487252000
156:118:3049272834804125422236250720559346000
156:119:973717375819804756680483423371892000
156:120:300229524211106466643149055539666700
156:121:89324486542147378505399719003537200
156:122:25625877286681624981057296435441000
156:123:7083575835342888206145919339878000
156:124:1885145181986413796796897888838500
156:125:482597166588521931980005859542656
156:126:118734223525747459455398267030336
156:127:28047454376160817194188567015040
156:128:6354501382098935145558347214345
156:129:1379271617819923907563052108540
156:130:286464105239522657724633899466
156:131:56855471268912893899545659436
156:132:10768081679718351117338193075
156:133:1943112483558198697865538600
156:134:333519306879392313812741700
156:135:54351294454419488176891240
156:136:8392479290755950380255265
156:137:1225179458504518303686900
156:138:168684128344824983840950
156:139:21843987843214746108900
156:140:2652484238104647741795
156:141:300991119217548679920
156:142:31794836537065001400
156:143:3112781199432937200
156:144:281014969393251275
156:145:23256411260131140
156:146:1752195368913990
156:147:119196963871700
156:148:7248464019225
156:149:389179276200
156:150:18161699556
156:151:721656936
156:152:23738715
156:153:620620
156:154:12090
156:155:156
156:156:1

# binomial(157, k) for 0 <= k <= 157

157:0:1
157:1:157
157:2:12246
157:3:632710
157:4:24359335
157:5:745395651
157:6:18883356492
157:7:407340975756
157:8:7637643295425
157:9:126445427890925
157:10:1871392332785690
157:11:25008606629045130
157:12:304271380653382415
157:13:3393796168826188475
157:14:34907617736497938600
157:15:332785955754613681320
157:16:2953475357322196421715
157:17:24496472081319393850695
157:18:190528116188039729949850
157:19:1393863586849343287527850
157:20:9617658749260468683942165
157:21:62743773745175438557146505
157:22:387870601333811801989632940
157:23:2276631790437591011678280300
157:24:12711194163276549815203731675
157:25:67623552948631245016883852511
157:26:343319576508435551624179558902
157:27:1665735723059446565287686008006
157:28:7733772999918859053121399322885
157:29:34401955758259752339746914229385
157:30:146781677901908276649586834045376
157:31:601331390114269391435404126572992
157:32:2367742348574935728776903748381156
157:33:8968721017329302002942817228716500
157:34:32709453122024513187203215775319000
157:35:114950363828829003486457015438978200
157:36:389554010753253845148548774543203900
157:37:1273946900030911223323632478911558700
157:38:4022990210623930178916734143931238000
157:39:12275277822160197212592086234046598000
157:40:36212069575372581777146654390437464100
157:41:103336881471185172388442891797102031700
157:42:285406625015654285644270844011043706600
157:43:763296787832563787188166210727209913000
157:44:1977632586657097084987521545975043865500
157:45:4966055162050043791190887437670665706700
157:46:12091264742382715317682160717806838242400
157:47:28555965668180455324738719993118277551200
157:48:65440754656246876785859566650896052721500
157:49:145572290970018562646095770713217749931500
157:50:314436148495240095315566864740550339852040
157:51:659699370372366474485601069161546791454280
157:52:1344771793451362428759109871752383844118340
157:53:2664170534196095377730312010075477427026900
157:54:5130995102896183690443563871256475044644400
157:55:9608954465423762183921583249807580538152240
157:56:17502024204878995406428598062149521694491580
157:57:31012358678820676071040147443457924406028940
157:58:53469583929001165639724392143892973113843000
157:59:89720149304595176242927369868566175224923000
157:60:146542910530838787863448037451991419534040900
157:61:233027251171989547914007534964642093357409300
157:62:360816388911467687092656828332349047779214400
157:63:544088205501419528155593630024970786333736000
157:64:799129551830209931978528144099175842427674750
157:65:1143369974157069594984663344634205436088826950
157:66:1593788448825006102099833753126468183638970900
157:67:2164697743926500825240072709470277682255915700
157:68:2865041131667427562817743291945955755926947250
157:69:3695487836498565986822886275118696554746352250
157:70:4645756137312482954863057031577789954538271400
157:71:5692687097833605874268816362637573606265205800
157:72:6799598477967918127598863988705990696372329150
157:73:7917340693524288230765800534794646701255451750
157:74:8987251598054597451139557363820950309533215500
157:75:9945891768513754512594443482628518342550091820
157:76:10731093750238524605694004810204454001172467490
157:77:11288553165835331078717069995150139923311296970
157:78:11578003247010595978171353841179630690575689200
157:79:11578003247010595978171353841179630690575689200
157:80:11288553165835331078717069995150139923311296970
157:81:10731093750238524605694004810204454001172467490
157:82:9945891768513754512594443482628518342550091820
157:83:8987251598054597451139557363820950309533215500
157:84:7917340693524288230765800534794646701255451750
157:85:6799598477967918127598863988705990696372329150
157:86:5692687097833605874268816362637573606265205800
157:87:4645756137312482954863057031577789954538271400
157:88:3695487836498565986822886275118696554746352250
157:89:2865041131667427562817743291945955755926947250
157:90:2164697743926500825240072709470277682255915700
157:91:1593788448825006102099833753126468183638970900
157:92:1143369974157069594984663344634205436088826950
157:93:799129551830209931978528144099175842427674750
157:94:544088205501419528155593630024970786333736000
157:95:360816388911467687092656828332349047779214400
157:96:233027251171989547914007534964642093357409300
157:97:146542910530838787863448037451991419534040900
157:98:89720149304595176242927369868566175224923000
157:99:53469583929001165639724392143892973113843000
157:100:31012358678820676071040147443457924406028940
157:101:17502024204878995406428598062149521694491580
157:102:9608954465423762183921583249807580538152240
157:103:5130995102896183690443563871256475044644400
157:104:2664170534196095377730312010075477427026900
157:105:1344771793451362428759109871752383844118340
157:106:659699370372366474485601069161546791454280
157:107:314436148495240095315566864740550339852040
157:108:145572290970018562646095770713217749931500
157:109:65440754656246876785859566650896052721500
157:110:28555965668180455324738719993118277551200
157:111:12091264742382715317682160717806838242400
157:112:4966055162050043791190887437670665706700
157:113:1977632586657097084987521545975043865500
157:114:763296787832563787188166210727209913000
157:115:285406625015654285644270844011043706600
157:116:103336881471185172388442891797102031700
157:117:36212069575372581777146654390437464100
157:118:12275277822160197212592086234046598000
157:119:4022990210623930178916734143931238000
157:120:1273946900030911223323632478911558700
157:121:389554010753253845148548774543203900
157:122:114950363828829003486457015438978200
157:123:32709453122024513187203215775319000
157:124:8968721017329302002942817228716500
157:125:2367742348574935728776903748381156
157:126:601331390114269391435404126572992
157:127:146781677901908276649586834045376
157:128:34401955758259752339746914229385
157:129:7733772999918859053121399322885
157:130:1665735723059446565287686008006
157:131:343319576508435551624179558902
157:132:67623552948631245016883852511
157:133:12711194163276549815203731675
157:134:2276631790437591011678280300
157:135:387870601333811801989632940
157:136:62743773745175438557146505
157:137:9617658749260468683942165
157:138:1393863586849343287527850
157:139:190528116188039729949850
157:140:24496472081319393850695
157:141:2953475357322196421715
157:142:332785955754613681320
157:143:34907617736497938600
157:144:3393796168826188475
157:145:304271380653382415
157:146:25008606629045130
157:147:1871392332785690
157:148:126445427890925
157:149:7637643295425
157:150:407340975756
157:151:18883356492
157:152:745395651
157:153:24359335
157:154:632710
157:155:12246
157:156:157
157:157:1

# binomial(158, k) for 0 <= k <= 158

158:0:1
158:1:158
158:2:12403
158:3:644956
158:4:24992045
158:5:769754986
158:6:19628752143
158:7:426224332248
158:8:8044984271181
158:9:134083071186350
158:10:1997837760676615
158:11:26879998961830820
158:12:329279987282427545
158:13:3698067549479570890
158:14:38301413905324127075
158:15:367693573491111619920
158:16:3286261313076810103035
158:17:27449947438641590272410
158:18:215024588269359123800545
158:19:1584391703037383017477700
158:20:11011522336109811971470015
158:21:72361432494435907241088670
158:22:450614375078987240546779445
158:23:2664502391771402813667913240
158:24:14987825953714140826882011975
158:25:80334747111907794832087584186
158:26:410943129457066796641063411413
158:27:2009055299567882116911865566908
158:28:9399508722978305618409085330891
158:29:42135728758178611392868313552270
158:30:181183633660168028989333748274761
158:31:748113068016177668084990960618368
158:32:2969073738689205120212307874954148
158:33:11336463365904237731719720977097656
158:34:41678174139353815190146033004035500
158:35:147659816950853516673660231214297200
158:36:504504374582082848635005789982182100
158:37:1663500910784165068472181253454762600
158:38:5296937110654841402240366622842796700
158:39:16298268032784127391508820377977836000
158:40:48487347397532778989738740624484062100
158:41:139548951046557754165589546187539495800
158:42:388743506486839458032713735808145738300
158:43:1048703412848218072832437054738253619600
158:44:2740929374489660872175687756702253778500
158:45:6943687748707140876178408983645709572200
158:46:17057319904432759108873048155477503949100
158:47:40647230410563170642420880710925115793600
158:48:93996720324427332110598286644014330272700
158:49:211013045626265439431955337364113802653000
158:50:460008439465258657961662635453768089783540
158:51:974135518867606569801167933902097131306320
158:52:2004471163823728903244710940913930635572620
158:53:4008942327647457806489421881827861271145240
158:54:7795165637092279068173875881331952471671300
158:55:14739949568319945874365147121064055582796640
158:56:27110978670302757590350181311957102232643820
158:57:48514382883699671477468745505607446100520520
158:58:84481942607821841710764539587350897519871940
158:59:143189733233596341882651762012459148338766000
158:60:236263059835433964106375407320557594758963900
158:61:379570161702828335777455572416633512891450200
158:62:593843640083457235006664363296991141136623700
158:63:904904594412887215248250458357319834112950400
158:64:1343217757331629460134121774124146628761410750
158:65:1942499525987279526963191488733381278516501700
158:66:2737158422982075697084497097760673619727797850
158:67:3758486192751506927339906462596745865894886600
158:68:5029738875593928388057816001416233438182862950
158:69:6560528968165993549640629567064652310673299500
158:70:8341243973811048941685943306696486509284623650
158:71:10338443235146088829131873394215363560803477200
158:72:12492285575801524001867680351343564302637534950
158:73:14716939171492206358364664523500637397627780900
158:74:16904592291578885681905357898615597010788667250
158:75:18933143366568351963734000846449468652083307320
158:76:20676985518752279118288448292832972343722559310
158:77:22019646916073855684411074805354593924483764460
158:78:22866556412845927056888423836329770613886986170
158:79:23156006494021191956342707682359261381151378400
158:80:22866556412845927056888423836329770613886986170
158:81:22019646916073855684411074805354593924483764460
158:82:20676985518752279118288448292832972343722559310
158:83:18933143366568351963734000846449468652083307320
158:84:16904592291578885681905357898615597010788667250
158:85:14716939171492206358364664523500637397627780900
158:86:12492285575801524001867680351343564302637534950
158:87:10338443235146088829131873394215363560803477200
158:88:8341243973811048941685943306696486509284623650
158:89:6560528968165993549640629567064652310673299500
158:90:5029738875593928388057816001416233438182862950
158:91:3758486192751506927339906462596745865894886600
158:92:2737158422982075697084497097760673619727797850
158:93:1942499525987279526963191488733381278516501700
158:94:1343217757331629460134121774124146628761410750
158:95:904904594412887215248250458357319834112950400
158:96:593843640083457235006664363296991141136623700
158:97:379570161702828335777455572416633512891450200
158:98:236263059835433964106375407320557594758963900
158:99:143189733233596341882651762012459148338766000
158:100:84481942607821841710764539587350897519871940
158:101:48514382883699671477468745505607446100520520
158:102:27110978670302757590350181311957102232643820
158:103:14739949568319945874365147121064055582796640
158:104:7795165637092279068173875881331952471671300
158:105:4008942327647457806489421881827861271145240
158:106:2004471163823728903244710940913930635572620
158:107:974135518867606569801167933902097131306320
158:108:460008439465258657961662635453768089783540
158:109:211013045626265439431955337364113802653000
158:110:93996720324427332110598286644014330272700
158:111:40647230410563170642420880710925115793600
158:112:17057319904432759108873048155477503949100
158:113:6943687748707140876178408983645709572200
158:114:2740929374489660872175687756702253778500
158:115:1048703412848218072832437054738253619600
158:116:388743506486839458032713735808145738300
158:117:139548951046557754165589546187539495800
158:118:48487347397532778989738740624484062100
158:119:16298268032784127391508820377977836000
158:120:5296937110654841402240366622842796700
158:121:1663500910784165068472181253454762600
158:122:504504374582082848635005789982182100
158:123:147659816950853516673660231214297200
158:124:41678174139353815190146033004035500
158:125:11336463365904237731719720977097656
158:126:2969073738689205120212307874954148
158:127:748113068016177668084990960618368
158:128:181183633660168028989333748274761
158:129:42135728758178611392868313552270
158:130:9399508722978305618409085330891
158:131:2009055299567882116911865566908
158:132:410943129457066796641063411413
158:133:80334747111907794832087584186
158:134:14987825953714140826882011975
158:135:2664502391771402813667913240
158:136:450614375078987240546779445
158:137:72361432494435907241088670
158:138:11011522336109811971470015
158:139:1584391703037383017477700
158:140:215024588269359123800545
158:141:27449947438641590272410
158:142:3286261313076810103035
158:143:367693573491111619920
158:144:38301413905324127075
158:145:3698067549479570890
158:146:329279987282427545
158:147:26879998961830820
158:148:1997837760676615
158:149:134083071186350
158:150:8044984271181
158:151:426224332248
158:152:19628752143
158:153:769754986
158:154:24992045
158:155:644956
158:156:12403
158:157:158
158:158:1

# binomial(159, k) for 0 <= k <= 159

159:0:1
159:1:159
159:2:12561
159:3:657359
159:4:25637001
159:5:794747031
159:6:20398507129
159:7:445853084391
159:8:8471208603429
159:9:142128055457531
159:10:2131920831862965
159:11:28877836722507435
159:12:356159986244258365
159:13:4027347536761998435
159:14:41999481454803697965
159:15:405994987396435746995
159:16:3653954886567921722955
159:17:30736208751718400375445
159:18:242474535708000714072955
159:19:1799416291306742141278245
159:20:12595914039147194988947715
159:21:83372954830545719212558685
159:22:522975807573423147787868115
159:23:3115116766850390054214692685
159:24:17652328345485543640549925215
159:25:95322573065621935658969596161
159:26:491277876568974591473150995599
159:27:2419998429024948913552928978321
159:28:11408564022546187735320950897799
159:29:51535237481156917011277398883161
159:30:223319362418346640382202061827031
159:31:929296701676345697074324708893129
159:32:3717186806705382788297298835572516
159:33:14305537104593442851932028852051804
159:34:53014637505258052921865753981133156
159:35:189337991090207331863806264218332700
159:36:652164191532936365308666021196479300
159:37:2168005285366247917107187043436944700
159:38:6960438021439006470712547876297559300
159:39:21595205143438968793749187000820632700
159:40:64785615430316906381247561002461898100
159:41:188036298444090533155328286812023557900
159:42:528292457533397212198303281995685234100
159:43:1437446919335057530865150790546399357900
159:44:3789632787337878945008124811440507398100
159:45:9684617123196801748354096740347963350700
159:46:24001007653139899985051457139123213521300
159:47:57704550314995929751293928866402619742700
159:48:134643950734990502753019167354939446066300
159:49:305009765950692771542553624008128132925700
159:50:671021485091524097393617972817881892436540
159:51:1434143958332865227762830569355865221089860
159:52:2978606682691335473045878874816027766878940
159:53:6013413491471186709734132822741791906717860
159:54:11804107964739736874663297763159813742816540
159:55:22535115205412224942539023002396008054467940
159:56:41850928238622703464715328433021157815440460
159:57:75625361554002429067818926817564548333164340
159:58:132996325491521513188233285092958343620392460
159:59:227671675841418183593416301599810045858637940
159:60:379452793069030305989027169333016743097729900
159:61:615833221538262299883830979737191107650414100
159:62:973413801786285570784119935713624654028073900
159:63:1498748234496344450254914821654310975249574100
159:64:2248122351744516675382372232481466462874361150
159:65:3285717283318908987097313262857527907277912450
159:66:4679657948969355224047688586494054898244299550
159:67:6495644615733582624424403560357419485622684450
159:68:8788225068345435315397722464012979304077749550
159:69:11590267843759921937698445568480885748856162450
159:70:14901772941977042491326572873761138819957923150
159:71:18679687208957137770817816700911850070088100850
159:72:22830728810947612830999553745558927863441012150
159:73:27209224747293730360232344874844201700265315850
159:74:31621531463071092040270022422116234408416448150
159:75:35837735658147237645639358745065065662871974570
159:76:39610128885320631082022449139282440995805866630
159:77:42696632434826134802699523098187566268206323770
159:78:44886203328919782741299498641684364538370750630
159:79:46022562906867119013231131518689031995038364570
159:80:46022562906867119013231131518689031995038364570
159:81:44886203328919782741299498641684364538370750630
159:82:42696632434826134802699523098187566268206323770
159:83:39610128885320631082022449139282440995805866630
159:84:35837735658147237645639358745065065662871974570
159:85:31621531463071092040270022422116234408416448150
159:86:27209224747293730360232344874844201700265315850
159:87:22830728810947612830999553745558927863441012150
159:88:18679687208957137770817816700911850070088100850
159:89:14901772941977042491326572873761138819957923150
159:90:11590267843759921937698445568480885748856162450
159:91:8788225068345435315397722464012979304077749550
159:92:6495644615733582624424403560357419485622684450
159:93:4679657948969355224047688586494054898244299550
159:94:3285717283318908987097313262857527907277912450
159:95:2248122351744516675382372232481466462874361150
159:96:1498748234496344450254914821654310975249574100
159:97:973413801786285570784119935713624654028073900
159:98:615833221538262299883830979737191107650414100
159:99:379452793069030305989027169333016743097729900
159:100:227671675841418183593416301599810045858637940
159:101:132996325491521513188233285092958343620392460
159:102:75625361554002429067818926817564548333164340
159:103:41850928238622703464715328433021157815440460
159:104:22535115205412224942539023002396008054467940
159:105:11804107964739736874663297763159813742816540
159:106:6013413491471186709734132822741791906717860
159:107:2978606682691335473045878874816027766878940
159:108:1434143958332865227762830569355865221089860
159:109:671021485091524097393617972817881892436540
159:110:305009765950692771542553624008128132925700
159:111:134643950734990502753019167354939446066300
159:112:57704550314995929751293928866402619742700
159:113:24001007653139899985051457139123213521300
159:114:9684617123196801748354096740347963350700
159:115:3789632787337878945008124811440507398100
159:116:1437446919335057530865150790546399357900
159:117:528292457533397212198303281995685234100
159:118:188036298444090533155328286812023557900
159:119:64785615430316906381247561002461898100
159:120:21595205143438968793749187000820632700
159:121:6960438021439006470712547876297559300
159:122:2168005285366247917107187043436944700
159:123:652164191532936365308666021196479300
159:124:189337991090207331863806264218332700
159:125:53014637505258052921865753981133156
159:126:14305537104593442851932028852051804
159:127:3717186806705382788297298835572516
159:128:929296701676345697074324708893129
159:129:223319362418346640382202061827031
159:130:51535237481156917011277398883161
159:131:11408564022546187735320950897799
159:132:2419998429024948913552928978321
159:133:491277876568974591473150995599
159:134:95322573065621935658969596161
159:135:17652328345485543640549925215
159:136:3115116766850390054214692685
159:137:522975807573423147787868115
159:138:83372954830545719212558685
159:139:12595914039147194988947715
159:140:1799416291306742141278245
159:141:242474535708000714072955
159:142:30736208751718400375445
159:143:3653954886567921722955
159:144:405994987396435746995
159:145:41999481454803697965
159:146:4027347536761998435
159:147:356159986244258365
159:148:28877836722507435
159:149:2131920831862965
159:150:142128055457531
159:151:8471208603429
159:152:445853084391
159:153:20398507129
159:154:794747031
159:155:25637001
159:156:657359
159:157:12561
159:158:159
159:159:1

# binomial(160, k) for 0 <= k <= 160

160:0:1
160:1:160
160:2:12720
160:3:669920
160:4:26294360
160:5:820384032
160:6:21193254160
160:7:466251591520
160:8:8917061687820
160:9:150599264060960
160:10:2274048887320496
160:11:31009757554370400
160:12:385037822966765800
160:13:4383507523006256800
160:14:46026828991565696400
160:15:447994468851239444960
160:16:4059949873964357469950
160:17:34390163638286322098400
160:18:273210744459719114448400
160:19:2041890827014742855351200
160:20:14395330330453937130225960
160:21:95968868869692914201506400
160:22:606348762403968867000426800
160:23:3638092574423813202002560800
160:24:20767445112335933694764617900
160:25:112974901411107479299519521376
160:26:586600449634596527132120591760
160:27:2911276305593923505026079973920
160:28:13828562451571136648873879876120
160:29:62943801503703104746598349780960
160:30:274854599899503557393479460710192
160:31:1152616064094692337456526770720160
160:32:4646483508381728485371623544465645
160:33:18022723911298825640229327687624320
160:34:67320174609851495773797782833184960
160:35:242352628595465384785672018199465856
160:36:841502182623143697172472285414812000
160:37:2820169476899184282415853064633424000
160:38:9128443306805254387819734919734504000
160:39:28555643164877975264461734877118192000
160:40:86380820573755875174996748003282530800
160:41:252821913874407439536575847814485456000
160:42:716328755977487745353631568807708792000
160:43:1965739376868454743063454072542084592000
160:44:5227079706672936475873275601986906756000
160:45:13474249910534680693362221551788470748800
160:46:33685624776336701733405553879471176872000
160:47:81705557968135829736345386005525833264000
160:48:192348501049986432504313096221342065809000
160:49:439653716685683274295572791363067578992000
160:50:976031251042216868936171596826010025362240
160:51:2105165443424389325156448542173747113526400
160:52:4412750641024200700808709444171892987968800
160:53:8992020174162522182780011697557819673596800
160:54:17817521456210923584397430585901605649534400
160:55:34339223170151961817202320765555821797284480
160:56:64386043444034928407254351435417165869908400
160:57:117476289792625132532534255250585706148604800
160:58:208621687045523942256052211910522891953556800
160:59:360668001332939696781649586692768389479030400
160:60:607124468910448489582443470932826788956367840
160:61:995286014607292605872858149070207850748144000
160:62:1589247023324547870667950915450815761678488000
160:63:2472162036282630021039034757367935629277648000
160:64:3746870586240861125637287054135777438123935250
160:65:5533839635063425662479685495338994370152273600
160:66:7965375232288264211145001849351582805522212000
160:67:11175302564702937848472092146851474383866984000
160:68:15283869684079017939822126024370398789700434000
160:69:20378492912105357253096168032493865052933912000
160:70:26492040785736964429025018442242024568814085600
160:71:33581460150934180262144389574672988890046024000
160:72:41510416019904750601817370446470777933529113000
160:73:50039953558241343191231898620403129563706328000
160:74:58830756210364822400502367296960436108681764000
160:75:67459267121218329685909381167181300071288422720
160:76:75447864543467868727661807884347506658677841200
160:77:82306761320146765884721972237470007264012190400
160:78:87582835763745917543999021739871930806577074400
160:79:90908766235786901754530630160373396533409115200
160:80:92045125813734238026462263037378063990076729140
160:81:90908766235786901754530630160373396533409115200
160:82:87582835763745917543999021739871930806577074400
160:83:82306761320146765884721972237470007264012190400
160:84:75447864543467868727661807884347506658677841200
160:85:67459267121218329685909381167181300071288422720
160:86:58830756210364822400502367296960436108681764000
160:87:50039953558241343191231898620403129563706328000
160:88:41510416019904750601817370446470777933529113000
160:89:33581460150934180262144389574672988890046024000
160:90:26492040785736964429025018442242024568814085600
160:91:20378492912105357253096168032493865052933912000
160:92:15283869684079017939822126024370398789700434000
160:93:11175302564702937848472092146851474383866984000
160:94:7965375232288264211145001849351582805522212000
160:95:5533839635063425662479685495338994370152273600
160:96:3746870586240861125637287054135777438123935250
160:97:2472162036282630021039034757367935629277648000
160:98:1589247023324547870667950915450815761678488000
160:99:995286014607292605872858149070207850748144000
160:100:607124468910448489582443470932826788956367840
160:101:360668001332939696781649586692768389479030400
160:102:208621687045523942256052211910522891953556800
160:103:117476289792625132532534255250585706148604800
160:104:64386043444034928407254351435417165869908400
160:105:34339223170151961817202320765555821797284480
160:106:17817521456210923584397430585901605649534400
160:107:8992020174162522182780011697557819673596800
160:108:4412750641024200700808709444171892987968800
160:109:2105165443424389325156448542173747113526400
160:110:976031251042216868936171596826010025362240
160:111:439653716685683274295572791363067578992000
160:112:192348501049986432504313096221342065809000
160:113:81705557968135829736345386005525833264000
160:114:33685624776336701733405553879471176872000
160:115:13474249910534680693362221551788470748800
160:116:5227079706672936475873275601986906756000
160:117:1965739376868454743063454072542084592000
160:118:716328755977487745353631568807708792000
160:119:252821913874407439536575847814485456000
160:120:86380820573755875174996748003282530800
160:121:28555643164877975264461734877118192000
160:122:9128443306805254387819734919734504000
160:123:2820169476899184282415853064633424000
160:124:841502182623143697172472285414812000
160:125:242352628595465384785672018199465856
160:126:67320174609851495773797782833184960
160:127:18022723911298825640229327687624320
160:128:4646483508381728485371623544465645
160:129:1152616064094692337456526770720160
160:130:274854599899503557393479460710192
160:131:62943801503703104746598349780960
160:132:13828562451571136648873879876120
160:133:2911276305593923505026079973920
160:134:586600449634596527132120591760
160:135:112974901411107479299519521376
160:136:20767445112335933694764617900
160:137:3638092574423813202002560800
160:138:606348762403968867000426800
160:139:95968868869692914201506400
160:140:14395330330453937130225960
160:141:2041890827014742855351200
160:142:273210744459719114448400
160:143:34390163638286322098400
160:144:4059949873964357469950
160:145:447994468851239444960
160:146:46026828991565696400
160:147:4383507523006256800
160:148:385037822966765800
160:149:31009757554370400
160:150:2274048887320496
160:151:150599264060960
160:152:8917061687820
160:153:466251591520
160:154:21193254160
160:155:820384032
160:156:26294360
160:157:669920
160:158:12720
160:159:160
160:160:1

# binomial(161, k) for 0 <= k <= 161

161:0:1
161:1:161
161:2:12880
161:3:682640
161:4:26964280
161:5:846678392
161:6:22013638192
161:7:487444845680
161:8:9383313279340
161:9:159516325748780
161:10:2424648151381456
161:11:33283806441690896
161:12:416047580521136200
161:13:4768545345973022600
161:14:50410336514571953200
161:15:494021297842805141360
161:16:4507944342815596914910
161:17:38450113512250679568350
161:18:307600908098005436546800
161:19:2315101571474461969799600
161:20:16437221157468679985577160
161:21:110364199200146851331732360
161:22:702317631273661781201933200
161:23:4244441336827782069002987600
161:24:24405537686759746896767178700
161:25:133742346523443412994284139276
161:26:699575351045704006431640113136
161:27:3497876755228520032158200565680
161:28:16739838757165060153899959850040
161:29:76772363955274241395472229657080
161:30:337798401403206662140077810491152
161:31:1427470663994195894850006231430352
161:32:5799099572476420822828150315185805
161:33:22669207419680554125600951232089965
161:34:85342898521150321414027110520809280
161:35:309672803205316880559469801032650816
161:36:1083854811218609081958144303614277856
161:37:3661671659522327979588325350048236000
161:38:11948612783704438670235587984367928000
161:39:37684086471683229652281469796852696000
161:40:114936463738633850439458482880400722800
161:41:339202734448163314711572595817767986800
161:42:969150669851895184890207416622194248000
161:43:2682068132845942488417085641349793384000
161:44:7192819083541391218936729674528991348000
161:45:18701329617207617169235497153775377504800
161:46:47159874686871382426767775431259647620800
161:47:115391182744472531469750939884997010136000
161:48:274054059018122262240658482226867899073000
161:49:632002217735669706799885887584409644801000
161:50:1415684967727900143231744388189077604354240
161:51:3081196694466606194092620138999757138888640
161:52:6517916084448590025965157986345640101495200
161:53:13404770815186722883588721141729712661565600
161:54:26809541630373445767177442283459425323131200
161:55:52156744626362885401599751351457427446818880
161:56:98725266614186890224456672200972987667192880
161:57:181862333236660060939788606686002872018513200
161:58:326097976838149074788586467161108598102161600
161:59:569289688378463639037701798603291281432587200
161:60:967792470243388186364093057625595178435398240
161:61:1602410483517741095455301620003034639704511840
161:62:2584533037931840476540809064521023612426632000
161:63:4061409059607177891706985672818751390956136000
161:64:6219032622523491146676321811503713067401583250
161:65:9280710221304286788116972549474771808276208850
161:66:13499214867351689873624687344690577175674485600
161:67:19140677796991202059617093996203057189389196000
161:68:26459172248781955788294218171221873173567418000
161:69:35662362596184375192918294056864263842634346000
161:70:46870533697842321682121186474735889621747997600
161:71:60073500936671144691169408016915013458860109600
161:72:75091876170838930863961760021143766823575137000
161:73:91550369578146093793049269066873907497235441000
161:74:108870709768606165591734265917363565672388092000
161:75:126290023331583152086411748464141736179970186720
161:76:142907131664686198413571189051528806729966263920
161:77:157754625863614634612383780121817513922690031600
161:78:169889597083892683428720993977341938070589264800
161:79:178491601999532819298529651900245327339986189600
161:80:182953892049521139780992893197751460523485844340
161:81:182953892049521139780992893197751460523485844340
161:82:178491601999532819298529651900245327339986189600
161:83:169889597083892683428720993977341938070589264800
161:84:157754625863614634612383780121817513922690031600
161:85:142907131664686198413571189051528806729966263920
161:86:126290023331583152086411748464141736179970186720
161:87:108870709768606165591734265917363565672388092000
161:88:91550369578146093793049269066873907497235441000
161:89:75091876170838930863961760021143766823575137000
161:90:60073500936671144691169408016915013458860109600
161:91:46870533697842321682121186474735889621747997600
161:92:35662362596184375192918294056864263842634346000
161:93:26459172248781955788294218171221873173567418000
161:94:19140677796991202059617093996203057189389196000
161:95:13499214867351689873624687344690577175674485600
161:96:9280710221304286788116972549474771808276208850
161:97:6219032622523491146676321811503713067401583250
161:98:4061409059607177891706985672818751390956136000
161:99:2584533037931840476540809064521023612426632000
161:100:1602410483517741095455301620003034639704511840
161:101:967792470243388186364093057625595178435398240
161:102:569289688378463639037701798603291281432587200
161:103:326097976838149074788586467161108598102161600
161:104:181862333236660060939788606686002872018513200
161:105:98725266614186890224456672200972987667192880
161:106:52156744626362885401599751351457427446818880
161:107:26809541630373445767177442283459425323131200
161:108:13404770815186722883588721141729712661565600
161:109:6517916084448590025965157986345640101495200
161:110:3081196694466606194092620138999757138888640
161:111:1415684967727900143231744388189077604354240
161:112:632002217735669706799885887584409644801000
161:113:274054059018122262240658482226867899073000
161:114:115391182744472531469750939884997010136000
161:115:47159874686871382426767775431259647620800
161:116:18701329617207617169235497153775377504800
161:117:7192819083541391218936729674528991348000
161:118:2682068132845942488417085641349793384000
161:119:969150669851895184890207416622194248000
161:120:339202734448163314711572595817767986800
161:121:114936463738633850439458482880400722800
161:122:37684086471683229652281469796852696000
161:123:11948612783704438670235587984367928000
161:124:3661671659522327979588325350048236000
161:125:1083854811218609081958144303614277856
161:126:309672803205316880559469801032650816
161:127:85342898521150321414027110520809280
161:128:22669207419680554125600951232089965
161:129:5799099572476420822828150315185805
161:130:1427470663994195894850006231430352
161:131:337798401403206662140077810491152
161:132:76772363955274241395472229657080
161:133:16739838757165060153899959850040
161:134:3497876755228520032158200565680
161:135:699575351045704006431640113136
161:136:133742346523443412994284139276
161:137:24405537686759746896767178700
161:138:4244441336827782069002987600
161:139:702317631273661781201933200
161:140:110364199200146851331732360
161:141:16437221157468679985577160
161:142:2315101571474461969799600
161:143:307600908098005436546800
161:144:38450113512250679568350
161:145:4507944342815596914910
161:146:494021297842805141360
161:147:50410336514571953200
161:148:4768545345973022600
161:149:416047580521136200
161:150:33283806441690896
161:151:2424648151381456
161:152:159516325748780
161:153:9383313279340
161:154:487444845680
161:155:22013638192
161:156:846678392
161:157:26964280
161:158:682640
161:159:12880
161:160:161
161:161:1

# binomial(162, k) for 0 <= k <= 162

162:0:1
162:1:162
162:2:13041
162:3:695520
162:4:27646920
162:5:873642672
162:6:22860316584
162:7:509458483872
162:8:9870758125020
162:9:168899639028120
162:10:2584164477130236
162:11:35708454593072352
162:12:449331386962827096
162:13:5184592926494158800
162:14:55178881860544975800
162:15:544431634357377094560
162:16:5001965640658402056270
162:17:42958057855066276483260
162:18:346051021610256116115150
162:19:2622702479572467406346400
162:20:18752322728943141955376760
162:21:126801420357615531317309520
162:22:812681830473808632533665560
162:23:4946758968101443850204920800
162:24:28649979023587528965770166300
162:25:158147884210203159891051317976
162:26:833317697569147419425924252412
162:27:4197452106274224038589840678816
162:28:20237715512393580186058160415720
162:29:93512202712439301549372189507120
162:30:414570765358480903535550040148232
162:31:1765269065397402556990084041921504
162:32:7226570236470616717678156546616157
162:33:28468306992156974948429101547275770
162:34:108012105940830875539628061752899245
162:35:395015701726467201973496911553460096
162:36:1393527614423925962517614104646928672
162:37:4745526470740937061546469653662513856
162:38:15610284443226766649823913334416164000
162:39:49632699255387668322517057781220624000
162:40:152620550210317080091739952677253418800
162:41:454139198186797165151031078698168709600
162:42:1308353404300058499601780012439962234800
162:43:3651218802697837673307293057971987632000
162:44:9874887216387333707353815315878784732000
162:45:25894148700749008388172226828304368852800
162:46:65861204304078999596003272585035025125600
162:47:162551057431343913896518715316256657756800
162:48:389445241762594793710409422111864909209000
162:49:906056276753791969040544369811277543874000
162:50:2047687185463569850031630275773487249155240
162:51:4496881662194506337324364527188834743242880
162:52:9599112778915196220057778125345397240383840
162:53:19922686899635312909553879128075352763060800
162:54:40214312445560168650766163425189137984696800
162:55:78966286256736331168777193634916852769950080
162:56:150882011240549775626056423552430415114011760
162:57:280587599850846951164245278886975859685706080
162:58:507960310074809135728375073847111470120674800
162:59:895387665216612713826288265764399879534748800
162:60:1537082158621851825401794856228886459867985440
162:61:2570202953761129281819394677628629818139910080
162:62:4186943521449581571996110684524058252131143840
162:63:6645942097539018368247794737339775003382768000
162:64:10280441682130669038383307484322464458357719250
162:65:15499742843827777934793294360978484875677792100
162:66:22779925088655976661741659894165348983950694450
162:67:32639892664342891933241781340893634365063681600
162:68:45599850045773157847911312167424930362956614000
162:69:62121534844966330981212512228086137016201764000
162:70:82532896294026696875039480531600153464382343600
162:71:106944034634513466373290594491650903080608107200
162:72:135165377107510075555131168038058780282435246600
162:73:166642245748985024657011029088017674320810578000
162:74:200421079346752259384783534984237473169623533000
162:75:235160733100189317678146014381505301852358278720
162:76:269197154996269350499982937515670542909936450640
162:77:300661757528300833025954969173346320652656295520
162:78:327644222947507318041104774099159451993279296400
162:79:348381199083425502727250645877587265410575454400
162:80:361445494049053959079522545097996787863472033940
162:81:365907784099042279561985786395502921046971688680
162:82:361445494049053959079522545097996787863472033940
162:83:348381199083425502727250645877587265410575454400
162:84:327644222947507318041104774099159451993279296400
162:85:300661757528300833025954969173346320652656295520
162:86:269197154996269350499982937515670542909936450640
162:87:235160733100189317678146014381505301852358278720
162:88:200421079346752259384783534984237473169623533000
162:89:166642245748985024657011029088017674320810578000
162:90:135165377107510075555131168038058780282435246600
162:91:106944034634513466373290594491650903080608107200
162:92:82532896294026696875039480531600153464382343600
162:93:62121534844966330981212512228086137016201764000
162:94:45599850045773157847911312167424930362956614000
162:95:32639892664342891933241781340893634365063681600
162:96:22779925088655976661741659894165348983950694450
162:97:15499742843827777934793294360978484875677792100
162:98:10280441682130669038383307484322464458357719250
162:99:6645942097539018368247794737339775003382768000
162:100:4186943521449581571996110684524058252131143840
162:101:2570202953761129281819394677628629818139910080
162:102:1537082158621851825401794856228886459867985440
162:103:895387665216612713826288265764399879534748800
162:104:507960310074809135728375073847111470120674800
162:105:280587599850846951164245278886975859685706080
162:106:150882011240549775626056423552430415114011760
162:107:78966286256736331168777193634916852769950080
162:108:40214312445560168650766163425189137984696800
162:109:19922686899635312909553879128075352763060800
162:110:9599112778915196220057778125345397240383840
162:111:4496881662194506337324364527188834743242880
162:112:2047687185463569850031630275773487249155240
162:113:906056276753791969040544369811277543874000
162:114:389445241762594793710409422111864909209000
162:115:162551057431343913896518715316256657756800
162:116:65861204304078999596003272585035025125600
162:117:25894148700749008388172226828304368852800
162:118:9874887216387333707353815315878784732000
162:119:3651218802697837673307293057971987632000
162:120:1308353404300058499601780012439962234800
162:121:454139198186797165151031078698168709600
162:122:152620550210317080091739952677253418800
162:123:49632699255387668322517057781220624000
162:124:15610284443226766649823913334416164000
162:125:4745526470740937061546469653662513856
162:126:1393527614423925962517614104646928672
162:127:395015701726467201973496911553460096
162:128:108012105940830875539628061752899245
162:129:28468306992156974948429101547275770
162:130:7226570236470616717678156546616157
162:131:1765269065397402556990084041921504
162:132:414570765358480903535550040148232
162:133:93512202712439301549372189507120
162:134:20237715512393580186058160415720
162:135:4197452106274224038589840678816
162:136:833317697569147419425924252412
162:137:158147884210203159891051317976
162:138:28649979023587528965770166300
162:139:4946758968101443850204920800
162:140:812681830473808632533665560
162:141:126801420357615531317309520
162:142:18752322728943141955376760
162:143:2622702479572467406346400
162:144:346051021610256116115150
162:145:42958057855066276483260
162:146:5001965640658402056270
162:147:544431634357377094560
162:148:55178881860544975800
162:149:5184592926494158800
162:150:449331386962827096
162:151:35708454593072352
162:152:2584164477130236
162:153:168899639028120
162:154:9870758125020
162:155:509458483872
162:156:22860316584
162:157:873642672
162:158:27646920
162:159:695520
162:160:13041
162:161:162
162:162:1

# binomial(163, k) for 0 <= k <= 163

163:0:1
163:1:163
163:2:13203
163:3:708561
163:4:28342440
163:5:901289592
163:6:23733959256
163:7:532318800456
163:8:10380216608892
163:9:178770397153140
163:10:2753064116158356
163:11:38292619070202588
163:12:485039841555899448
163:13:5633924313456985896
163:14:60363474787039134600
163:15:599610516217922070360
163:16:5546397275015779150830
163:17:47960023495724678539530
163:18:389009079465322392598410
163:19:2968753501182723522461550
163:20:21375025208515609361723160
163:21:145553743086558673272686280
163:22:939483250831424163850975080
163:23:5759440798575252482738586360
163:24:33596737991688972815975087100
163:25:186797863233790688856821484276
163:26:991465581779350579316975570388
163:27:5030769803843371458015764931228
163:28:24435167618667804224648001094536
163:29:113749918224832881735430349922840
163:30:508082968070920205084922229655352
163:31:2179839830755883460525634082069736
163:32:8991839301868019274668240588537661
163:33:35694877228627591666107258093891927
163:34:136480412932987850488057163300175015
163:35:503027807667298077513124973306359341
163:36:1788543316150393164491111016200388768
163:37:6139054085164863024064083758309442528
163:38:20355810913967703711370382988078677856
163:39:65242983698614434972340971115636788000
163:40:202253249465704748414257010458474042800
163:41:606759748397114245242771031375422128400
163:42:1762492602486855664752811091138130944400
163:43:4959572206997896172909073070411949866800
163:44:13526106019085171380661108373850772364000
163:45:35769035917136342095526042144183153584800
163:46:91755353004828007984175499413339393978400
163:47:228412261735422913492521987901291682882400
163:48:551996299193938707606928137428121566965800
163:49:1295501518516386762750953791923142453083000
163:50:2953743462217361819072174645584764793029240
163:51:6544568847658076187355994802962321992398120
163:52:14095994441109702557382142652534231983626720
163:53:29521799678550509129611657253420750003444640
163:54:60136999345195481560320042553264490747757600
163:55:119180598702296499819543357060105990754646880
163:56:229848297497286106794833617187347267883961840
163:57:431469611091396726790301702439406274799717840
163:58:788547909925656086892620352734087329806380880
163:59:1403347975291421849554663339611511349655423600
163:60:2432469823838464539228083121993286339402734240
163:61:4107285112382981107221189533857516278007895520
163:62:6757146475210710853815505362152688070271053920
163:63:10832885618988599940243905421863833255513911840
163:64:16926383779669687406631102221662239461740487250
163:65:25780184525958446973176601845300949334035511350
163:66:38279667932483754596534954255143833859628486550
163:67:55419817752998868594983441235058983349014376050
163:68:78239742710116049781153093508318564728020295600
163:69:107721384890739488829123824395511067379158378000
163:70:144654431138993027856251992759686290480584107600
163:71:189476930928540163248330075023251056544990450800
163:72:242109411742023541928421762529709683363043353800
163:73:301807622856495100212142197126076454603245824600
163:74:367063325095737284041794564072255147490434111000
163:75:435581812446941577062929549365742775021981811720
163:76:504357888096458668178128951897175844762294729360
163:77:569858912524570183525937906689016863562592746160
163:78:628305980475808151067059743272505772645935591920
163:79:676025422030932820768355419976746717403854750800
163:80:709826693132479461806773190975584053274047488340
163:81:727353278148096238641508331493499708910443722620
163:82:727353278148096238641508331493499708910443722620
163:83:709826693132479461806773190975584053274047488340
163:84:676025422030932820768355419976746717403854750800
163:85:628305980475808151067059743272505772645935591920
163:86:569858912524570183525937906689016863562592746160
163:87:504357888096458668178128951897175844762294729360
163:88:435581812446941577062929549365742775021981811720
163:89:367063325095737284041794564072255147490434111000
163:90:301807622856495100212142197126076454603245824600
163:91:242109411742023541928421762529709683363043353800
163:92:189476930928540163248330075023251056544990450800
163:93:144654431138993027856251992759686290480584107600
163:94:107721384890739488829123824395511067379158378000
163:95:78239742710116049781153093508318564728020295600
163:96:55419817752998868594983441235058983349014376050
163:97:38279667932483754596534954255143833859628486550
163:98:25780184525958446973176601845300949334035511350
163:99:16926383779669687406631102221662239461740487250
163:100:10832885618988599940243905421863833255513911840
163:101:6757146475210710853815505362152688070271053920
163:102:4107285112382981107221189533857516278007895520
163:103:2432469823838464539228083121993286339402734240
163:104:1403347975291421849554663339611511349655423600
163:105:788547909925656086892620352734087329806380880
163:106:431469611091396726790301702439406274799717840
163:107:229848297497286106794833617187347267883961840
163:108:119180598702296499819543357060105990754646880
163:109:60136999345195481560320042553264490747757600
163:110:29521799678550509129611657253420750003444640
163:111:14095994441109702557382142652534231983626720
163:112:6544568847658076187355994802962321992398120
163:113:2953743462217361819072174645584764793029240
163:114:1295501518516386762750953791923142453083000
163:115:551996299193938707606928137428121566965800
163:116:228412261735422913492521987901291682882400
163:117:91755353004828007984175499413339393978400
163:118:35769035917136342095526042144183153584800
163:119:13526106019085171380661108373850772364000
163:120:4959572206997896172909073070411949866800
163:121:1762492602486855664752811091138130944400
163:122:606759748397114245242771031375422128400
163:123:202253249465704748414257010458474042800
163:124:65242983698614434972340971115636788000
163:125:20355810913967703711370382988078677856
163:126:6139054085164863024064083758309442528
163:127:1788543316150393164491111016200388768
163:128:503027807667298077513124973306359341
163:129:136480412932987850488057163300175015
163:130:35694877228627591666107258093891927
163:131:8991839301868019274668240588537661
163:132:2179839830755883460525634082069736
163:133:508082968070920205084922229655352
163:134:113749918224832881735430349922840
163:135:24435167618667804224648001094536
163:136:5030769803843371458015764931228
163:137:991465581779350579316975570388
163:138:186797863233790688856821484276
163:139:33596737991688972815975087100
163:140:5759440798575252482738586360
163:141:939483250831424163850975080
163:142:145553743086558673272686280
163:143:21375025208515609361723160
163:144:2968753501182723522461550
163:145:389009079465322392598410
163:146:47960023495724678539530
163:147:5546397275015779150830
163:148:599610516217922070360
163:149:60363474787039134600
163:150:5633924313456985896
163:151:485039841555899448
163:152:38292619070202588
163:153:2753064116158356
163:154:178770397153140
163:155:10380216608892
163:156:532318800456
163:157:23733959256
163:158:901289592
163:159:28342440
163:160:708561
163:161:13203
163:162:163
163:163:1

# binomial(164, k) for 0 <= k <= 164

164:0:1
164:1:164
164:2:13366
164:3:721764
164:4:29051001
164:5:929632032
164:6:24635248848
164:7:556052759712
164:8:10912535409348
164:9:189150613762032
164:10:2931834513311496
164:11:41045683186360944
164:12:523332460626102036
164:13:6118964155012885344
164:14:65997399100496120496
164:15:659973991004961204960
164:16:6146007791233701221190
164:17:53506420770740457690360
164:18:436969102961047071137940
164:19:3357762580648045915059960
164:20:24343778709698332884184710
164:21:166928768295074282634409440
164:22:1085036993917982837123661360
164:23:6698924049406676646589561440
164:24:39356178790264225298713673460
164:25:220394601225479661672796571376
164:26:1178263445013141268173797054664
164:27:6022235385622722037332740501616
164:28:29465937422511175682663766025764
164:29:138185085843500685960078351017376
164:30:621832886295753086820352579578192
164:31:2687922798826803665610556311725088
164:32:11171679132623902735193874670607397
164:33:44686716530495610940775498682429588
164:34:172175290161615442154164421394066942
164:35:639508220600285928001182136606534356
164:36:2291571123817691242004235989506748109
164:37:7927597401315256188555194774509831296
164:38:26494864999132566735434466746388120384
164:39:85598794612582138683711354103715465856
164:40:267496233164319183386597981574110830800
164:41:809012997862818993657028041833896171200
164:42:2369252350883969909995582122513553072800
164:43:6722064809484751837661884161550080811200
164:44:18485678226083067553570181444262722230800
164:45:49295141936221513476187150518033925948800
164:46:127524388921964350079701541557522547563200
164:47:320167614740250921476697487314631076860800
164:48:780408560929361621099450125329413249848200
164:49:1847497817710325470357881929351264020048800
164:50:4249244980733748581823128437507907246112240
164:51:9498312309875438006428169448547086785427360
164:52:20640563288767778744738137455496553976024840
164:53:43617794119660211686993799905954981987071360
164:54:89658799023745990689931699806685240751202240
164:55:179317598047491981379863399613370481502404480
164:56:349028896199582606614376974247453258638608720
164:57:661317908588682833585135319626753542683679680
164:58:1220017521017052813682922055173493604606098720
164:59:2191895885217077936447283692345598679461804480
164:60:3835817799129886388782746461604797689058157840
164:61:6539754936221445646449272655850802617410629760
164:62:10864431587593691961036694896010204348278949440
164:63:17590032094199310794059410784016521325784965760
164:64:27759269398658287346875007643526072717254399090
164:65:42706568305628134379807704066963188795775998600
164:66:64059852458442201569711556100444783193663997900
164:67:93699485685482623191518395490202817208642862600
164:68:133659560463114918376136534743377548077034671650
164:69:185961127600855538610276917903829632107178673600
164:70:252375816029732516685375817155197357859742485600
164:71:334131362067533191104582067782937347025574558400
164:72:431586342670563705176751837552960739908033804600
164:73:543917034598518642140563959655786137966289178400
164:74:668870947952232384253936761198331602093679935600
164:75:802645137542678861104724113437997922512415922720
164:76:939939700543400245241058501262918619784276541080
164:77:1074216800621028851704066858586192708324887475520
164:78:1198164893000378334592997649961522636208528338080
164:79:1304331402506740971835415163249252490049790342720
164:80:1385852115163412282575128610952330770677902239140
164:81:1437179971280575700448281522469083762184491210960
164:82:1454706556296192477283016662986999417820887445240
164:83:1437179971280575700448281522469083762184491210960
164:84:1385852115163412282575128610952330770677902239140
164:85:1304331402506740971835415163249252490049790342720
164:86:1198164893000378334592997649961522636208528338080
164:87:1074216800621028851704066858586192708324887475520
164:88:939939700543400245241058501262918619784276541080
164:89:802645137542678861104724113437997922512415922720
164:90:668870947952232384253936761198331602093679935600
164:91:543917034598518642140563959655786137966289178400
164:92:431586342670563705176751837552960739908033804600
164:93:334131362067533191104582067782937347025574558400
164:94:252375816029732516685375817155197357859742485600
164:95:185961127600855538610276917903829632107178673600
164:96:133659560463114918376136534743377548077034671650
164:97:93699485685482623191518395490202817208642862600
164:98:64059852458442201569711556100444783193663997900
164:99:42706568305628134379807704066963188795775998600
164:100:27759269398658287346875007643526072717254399090
164:101:17590032094199310794059410784016521325784965760
164:102:10864431587593691961036694896010204348278949440
164:103:6539754936221445646449272655850802617410629760
164:104:3835817799129886388782746461604797689058157840
164:105:2191895885217077936447283692345598679461804480
164:106:1220017521017052813682922055173493604606098720
164:107:661317908588682833585135319626753542683679680
164:108:349028896199582606614376974247453258638608720
164:109:179317598047491981379863399613370481502404480
164:110:89658799023745990689931699806685240751202240
164:111:43617794119660211686993799905954981987071360
164:112:20640563288767778744738137455496553976024840
164:113:9498312309875438006428169448547086785427360
164:114:4249244980733748581823128437507907246112240
164:115:1847497817710325470357881929351264020048800
164:116:780408560929361621099450125329413249848200
164:117:320167614740250921476697487314631076860800
164:118:127524388921964350079701541557522547563200
164:119:49295141936221513476187150518033925948800
164:120:18485678226083067553570181444262722230800
164:121:6722064809484751837661884161550080811200
164:122:2369252350883969909995582122513553072800
164:123:809012997862818993657028041833896171200
164:124:267496233164319183386597981574110830800
164:125:85598794612582138683711354103715465856
164:126:26494864999132566735434466746388120384
164:127:7927597401315256188555194774509831296
164:128:2291571123817691242004235989506748109
164:129:639508220600285928001182136606534356
164:130:172175290161615442154164421394066942
164:131:44686716530495610940775498682429588
164:132:11171679132623902735193874670607397
164:133:2687922798826803665610556311725088
164:134:621832886295753086820352579578192
164:135:138185085843500685960078351017376
164:136:29465937422511175682663766025764
164:137:6022235385622722037332740501616
164:138:1178263445013141268173797054664
164:139:220394601225479661672796571376
164:140:39356178790264225298713673460
164:141:6698924049406676646589561440
164:142:1085036993917982837123661360
164:143:166928768295074282634409440
164:144:24343778709698332884184710
164:145:3357762580648045915059960
164:146:436969102961047071137940
164:147:53506420770740457690360
164:148:6146007791233701221190
164:149:659973991004961204960
164:150:65997399100496120496
164:151:6118964155012885344
164:152:523332460626102036
164:153:41045683186360944
164:154:2931834513311496
164:155:189150613762032
164:156:10912535409348
164:157:556052759712
164:158:24635248848
164:159:929632032
164:160:29051001
164:161:721764
164:162:13366
164:163:164
164:164:1

# binomial(165, k) for 0 <= k <= 165

165:0:1
165:1:165
165:2:13530
165:3:735130
165:4:29772765
165:5:958683033
165:6:25564880880
165:7:580688008560
165:8:11468588169060
165:9:200063149171380
165:10:3120985127073528
165:11:43977517699672440
165:12:564378143812462980
165:13:6642296615638987380
165:14:72116363255509005840
165:15:725971390105457325456
165:16:6805981782238662426150
165:17:59652428561974158911550
165:18:490475523731787528828300
165:19:3794731683609092986197900
165:20:27701541290346378799244670
165:21:191272547004772615518594150
165:22:1251965762213057119758070800
165:23:7783961043324659483713222800
165:24:46055102839670901945303234900
165:25:259750780015743886971510244836
165:26:1398658046238620929846593626040
165:27:7200498830635863305506537556280
165:28:35488172808133897719996506527380
165:29:167651023266011861642742117043140
165:30:760017972139253772780430930595568
165:31:3309755685122556752430908891303280
165:32:13859601931450706400804430982332485
165:33:55858395663119513675969373353036985
165:34:216862006692111053094939920076496530
165:35:811683510761901370155346558000601298
165:36:2931079344417977170005418126113282465
165:37:10219168525132947430559430764016579405
165:38:34422462400447822923989661520897951680
165:39:112093659611714705419145820850103586240
165:40:353095027776901322070309335677826296656
165:41:1076509231027138177043626023408007002000
165:42:3178265348746788903652610164347449244000
165:43:9091317160368721747657466284063633884000
165:44:25207743035567819391232065605812803042000
165:45:67780820162304581029757331962296648179600
165:46:176819530858185863555888692075556473512000
165:47:447692003662215271556399028872153624424000
165:48:1100576175669612542576147612644044326709000
165:49:2627906378639687091457332054680677269897000
165:50:6096742798444074052181010366859171266161040
165:51:13747557290609186588251297886054994031539600
165:52:30138875598643216751166306904043640761452200
165:53:64258357408427990431731937361451535963096200
165:54:133276593143406202376925499712640222738273600
165:55:268976397071237972069795099420055722253606720
165:56:528346494247074587994240373860823740141013200
165:57:1010346804788265440199512293874206801322288400
165:58:1881335429605735647268057374800247147289778400
165:59:3411913406234130750130205747519092284067903200
165:60:6027713684346964325230030153950396368519962320
165:61:10375572735351332035232019117455600306468787600
165:62:17404186523815137607485967551861006965689579200
165:63:28454463681793002755096105680026725674063915200
165:64:45349301492857598140934418427542594043039364850
165:65:70465837704286421726682711710489261513030397690
165:66:106766420764070335949519260167407971989439996500
165:67:157759338143924824761229951590647600402306860500
165:68:227359046148597541567654930233580365285677534250
165:69:319620688063970456986413452647207180184213345250
165:70:438336943630588055295652735059026989966921159200
165:71:586507178097265707789957884938134704885317044000
165:72:765717704738096896281333905335898086933608363000
165:73:975503377269082347317315797208746877874322983000
165:74:1212787982550751026394500720854117740059969114000
165:75:1471516085494911245358660874636329524606095858320
165:76:1742584838086079106345782614700916542296692463800
165:77:2014156501164429096945125359849111328109164016600
165:78:2272381693621407186297064508547715344533415813600
165:79:2502496295507119306428412813210775126258318680800
165:80:2690183517670153254410543774201583260727692581860
165:81:2823032086443987983023410133421414532862393450100
165:82:2891886527576768177731298185456083180005378656200
165:83:2891886527576768177731298185456083180005378656200
165:84:2823032086443987983023410133421414532862393450100
165:85:2690183517670153254410543774201583260727692581860
165:86:2502496295507119306428412813210775126258318680800
165:87:2272381693621407186297064508547715344533415813600
165:88:2014156501164429096945125359849111328109164016600
165:89:1742584838086079106345782614700916542296692463800
165:90:1471516085494911245358660874636329524606095858320
165:91:1212787982550751026394500720854117740059969114000
165:92:975503377269082347317315797208746877874322983000
165:93:765717704738096896281333905335898086933608363000
165:94:586507178097265707789957884938134704885317044000
165:95:438336943630588055295652735059026989966921159200
165:96:319620688063970456986413452647207180184213345250
165:97:227359046148597541567654930233580365285677534250
165:98:157759338143924824761229951590647600402306860500
165:99:106766420764070335949519260167407971989439996500
165:100:70465837704286421726682711710489261513030397690
165:101:45349301492857598140934418427542594043039364850
165:102:28454463681793002755096105680026725674063915200
165:103:17404186523815137607485967551861006965689579200
165:104:10375572735351332035232019117455600306468787600
165:105:6027713684346964325230030153950396368519962320
165:106:3411913406234130750130205747519092284067903200
165:107:1881335429605735647268057374800247147289778400
165:108:1010346804788265440199512293874206801322288400
165:109:528346494247074587994240373860823740141013200
165:110:268976397071237972069795099420055722253606720
165:111:133276593143406202376925499712640222738273600
165:112:64258357408427990431731937361451535963096200
165:113:30138875598643216751166306904043640761452200
165:114:13747557290609186588251297886054994031539600
165:115:6096742798444074052181010366859171266161040
165:116:2627906378639687091457332054680677269897000
165:117:1100576175669612542576147612644044326709000
165:118:447692003662215271556399028872153624424000
165:119:176819530858185863555888692075556473512000
165:120:67780820162304581029757331962296648179600
165:121:25207743035567819391232065605812803042000
165:122:9091317160368721747657466284063633884000
165:123:3178265348746788903652610164347449244000
165:124:1076509231027138177043626023408007002000
165:125:353095027776901322070309335677826296656
165:126:112093659611714705419145820850103586240
165:127:34422462400447822923989661520897951680
165:128:10219168525132947430559430764016579405
165:129:2931079344417977170005418126113282465
165:130:811683510761901370155346558000601298
165:131:216862006692111053094939920076496530
165:132:55858395663119513675969373353036985
165:133:13859601931450706400804430982332485
165:134:3309755685122556752430908891303280
165:135:760017972139253772780430930595568
165:136:167651023266011861642742117043140
165:137:35488172808133897719996506527380
165:138:7200498830635863305506537556280
165:139:1398658046238620929846593626040
165:140:259750780015743886971510244836
165:141:46055102839670901945303234900
165:142:7783961043324659483713222800
165:143:1251965762213057119758070800
165:144:191272547004772615518594150
165:145:27701541290346378799244670
165:146:3794731683609092986197900
165:147:490475523731787528828300
165:148:59652428561974158911550
165:149:6805981782238662426150
165:150:725971390105457325456
165:151:72116363255509005840
165:152:6642296615638987380
165:153:564378143812462980
165:154:43977517699672440
165:155:3120985127073528
165:156:200063149171380
165:157:11468588169060
165:158:580688008560
165:159:25564880880
165:160:958683033
165:161:29772765
165:162:735130
165:163:13530
165:164:165
165:165:1

# binomial(166, k) for 0 <= k <= 166

166:0:1
166:1:166
166:2:13695
166:3:748660
166:4:30507895
166:5:988455798
166:6:26523563913
166:7:606252889440
166:8:12049276177620
166:9:211531737340440
166:10:3321048276244908
166:11:47098502826745968
166:12:608355661512135420
166:13:7206674759451450360
166:14:78758659871147993220
166:15:798087753360966331296
166:16:7531953172344119751606
166:17:66458410344212821337700
166:18:550127952293761687739850
166:19:4285207207340880515026200
166:20:31496272973955471785442570
166:21:218974088295118994317838820
166:22:1443238309217829735276664950
166:23:9035926805537716603471293600
166:24:53839063882995561429016457700
166:25:305805882855414788916813479736
166:26:1658408826254364816818103870876
166:27:8599156876874484235353131182320
166:28:42688671638769761025503044083660
166:29:203139196074145759362738623570520
166:30:927668995405265634423173047638708
166:31:4069773657261810525211339821898848
166:32:17169357616573263153235339873635765
166:33:69717997594570220076773804335369470
166:34:272720402355230566770909293429533515
166:35:1028545517454012423250286478077097828
166:36:3742762855179878540160764684113883763
166:37:13150247869550924600564848890129861870
166:38:44641630925580770354549092284914531085
166:39:146516122012162528343135482371001537920
166:40:465188687388616027489455156527929882896
166:41:1429604258804039499113935359085833298656
166:42:4254774579773927080696236187755456246000
166:43:12269582509115510651310076448411083128000
166:44:34299060195936541138889531889876436926000
166:45:92988563197872400420989397568109451221600
166:46:244600351020490444585646024037853121691600
166:47:624511534520401135112287720947710097936000
166:48:1548268179331827814132546641516197951133000
166:49:3728482554309299634033479667324721596606000
166:50:8724649177083761143638342421539848536058040
166:51:19844300089053260640432308252914165297700640
166:52:43886432889252403339417604790098634792991800
166:53:94397233007071207182898244265495176724548400
166:54:197534950551834192808657437074091758701369800
166:55:402252990214644174446720599132695944991880320
166:56:797322891318312560064035473280879462394619920
166:57:1538693299035340028193752667735030541463301600
166:58:2891682234394001087467569668674453948612066800
166:59:5293248835839866397398263122319339431357681600
166:60:9439627090581095075360235901469488652587865520
166:61:16403286419698296360462049271405996674988749920
166:62:27779759259166469642717986669316607272158366800
166:63:45858650205608140362582073231887732639753494400
166:64:73803765174650600896030524107569319717103280050
166:65:115815139197144019867617130138031855556069762540
166:66:177232258468356757676201971877897233502470394190
166:67:264525758907995160710749211758055572391746857000
166:68:385118384292522366328884881824227965687984394750
166:69:546979734212567998554068382880787545469890879500
166:70:757957631694558512282066187706234170151134504450
166:71:1024844121727853763085610619997161694852238203200
166:72:1352224882835362604071291790274032791818925407000
166:73:1741221082007179243598649702544644964807931346000
166:74:2188291359819833373711816518062864617934292097000
166:75:2684304068045662271753161595490447264666064972320
166:76:3214100923580990351704443489337246066902788322120
166:77:3756741339250508203290907974550027870405856480400
166:78:4286538194785836283242189868396826672642579830200
166:79:4774877989128526492725477321758490470791734494400
166:80:5192679813177272560838956587412358386986011262660
166:81:5513215604114141237433953907622997793590086031960
166:82:5714918614020756160754708318877497712867772106300
166:83:5783773055153536355462596370912166360010757312400
166:84:5714918614020756160754708318877497712867772106300
166:85:5513215604114141237433953907622997793590086031960
166:86:5192679813177272560838956587412358386986011262660
166:87:4774877989128526492725477321758490470791734494400
166:88:4286538194785836283242189868396826672642579830200
166:89:3756741339250508203290907974550027870405856480400
166:90:3214100923580990351704443489337246066902788322120
166:91:2684304068045662271753161595490447264666064972320
166:92:2188291359819833373711816518062864617934292097000
166:93:1741221082007179243598649702544644964807931346000
166:94:1352224882835362604071291790274032791818925407000
166:95:1024844121727853763085610619997161694852238203200
166:96:757957631694558512282066187706234170151134504450
166:97:546979734212567998554068382880787545469890879500
166:98:385118384292522366328884881824227965687984394750
166:99:264525758907995160710749211758055572391746857000
166:100:177232258468356757676201971877897233502470394190
166:101:115815139197144019867617130138031855556069762540
166:102:73803765174650600896030524107569319717103280050
166:103:45858650205608140362582073231887732639753494400
166:104:27779759259166469642717986669316607272158366800
166:105:16403286419698296360462049271405996674988749920
166:106:9439627090581095075360235901469488652587865520
166:107:5293248835839866397398263122319339431357681600
166:108:2891682234394001087467569668674453948612066800
166:109:1538693299035340028193752667735030541463301600
166:110:797322891318312560064035473280879462394619920
166:111:402252990214644174446720599132695944991880320
166:112:197534950551834192808657437074091758701369800
166:113:94397233007071207182898244265495176724548400
166:114:43886432889252403339417604790098634792991800
166:115:19844300089053260640432308252914165297700640
166:116:8724649177083761143638342421539848536058040
166:117:3728482554309299634033479667324721596606000
166:118:1548268179331827814132546641516197951133000
166:119:624511534520401135112287720947710097936000
166:120:244600351020490444585646024037853121691600
166:121:92988563197872400420989397568109451221600
166:122:34299060195936541138889531889876436926000
166:123:12269582509115510651310076448411083128000
166:124:4254774579773927080696236187755456246000
166:125:1429604258804039499113935359085833298656
166:126:465188687388616027489455156527929882896
166:127:146516122012162528343135482371001537920
166:128:44641630925580770354549092284914531085
166:129:13150247869550924600564848890129861870
166:130:3742762855179878540160764684113883763
166:131:1028545517454012423250286478077097828
166:132:272720402355230566770909293429533515
166:133:69717997594570220076773804335369470
166:134:17169357616573263153235339873635765
166:135:4069773657261810525211339821898848
166:136:927668995405265634423173047638708
166:137:203139196074145759362738623570520
166:138:42688671638769761025503044083660
166:139:8599156876874484235353131182320
166:140:1658408826254364816818103870876
166:141:305805882855414788916813479736
166:142:53839063882995561429016457700
166:143:9035926805537716603471293600
166:144:1443238309217829735276664950
166:145:218974088295118994317838820
166:146:31496272973955471785442570
166:147:4285207207340880515026200
166:148:550127952293761687739850
166:149:66458410344212821337700
166:150:7531953172344119751606
166:151:798087753360966331296
166:152:78758659871147993220
166:153:7206674759451450360
166:154:608355661512135420
166:155:47098502826745968
166:156:3321048276244908
166:157:211531737340440
166:158:12049276177620
166:159:606252889440
166:160:26523563913
166:161:988455798
166:162:30507895
166:163:748660
166:164:13695
166:165:166
166:166:1

# binomial(167, k) for 0 <= k <= 167

167:0:1
167:1:167
167:2:13861
167:3:762355
167:4:31256555
167:5:1018963693
167:6:27512019711
167:7:632776453353
167:8:12655529067060
167:9:223581013518060
167:10:3532580013585348
167:11:50419551102990876
167:12:655454164338881388
167:13:7815030420963585780
167:14:85965334630599443580
167:15:876846413232114324516
167:16:8330040925705086082902
167:17:73990363516556941089306
167:18:616586362637974509077550
167:19:4835335159634642202766050
167:20:35781480181296352300468770
167:21:250470361269074466103281390
167:22:1662212397512948729594503770
167:23:10479165114755546338747958550
167:24:62874990688533278032487751300
167:25:359644946738410350345829937436
167:26:1964214709109779605734917350612
167:27:10257565703128849052171235053196
167:28:51287828515644245260856175265980
167:29:245827867712915520388241667654180
167:30:1130808191479411393785911671209228
167:31:4997442652667076159634512869537556
167:32:21239131273835073678446679695534613
167:33:86887355211143483230009144209005235
167:34:342438399949800786847683097764902985
167:35:1301265919809242990021195771506631343
167:36:4771308372633890963411051162190981591
167:37:16893010724730803140725613574243745633
167:38:57791878795131694955113941175044392955
167:39:191157752937743298697684574655916069005
167:40:611704809400778555832590638898931420816
167:41:1894792946192655526603390515613763181552
167:42:5684378838577966579810171546841289544656
167:43:16524357088889437732006312636166539374000
167:44:46568642705052051790199608338287520054000
167:45:127287623393808941559878929457985888147600
167:46:337588914218362845006635421605962572913200
167:47:869111885540891579697933744985563219627600
167:48:2172779713852228949244834362463908049069000
167:49:5276750733641127448166026308840919547739000
167:50:12453131731393060777671822088864570132664040
167:51:28568949266137021784070650674454013833758680
167:52:63730732978305663979849913043012800090692440
167:53:138283665896323610522315849055593811517540200
167:54:291932183558905399991555681339586935425918200
167:55:599787940766478367255378036206787703693250120
167:56:1199575881532956734510756072413575407386500240
167:57:2336016190353652588257788141015910003857921520
167:58:4430375533429341115661322336409484490075368400
167:59:8184931070233867484865832790993793379969748400
167:60:14732875926420961472758499023788828083945547120
167:61:25842913510279391435822285172875485327576615440
167:62:44183045678864766003180035940722603947147116720
167:63:73638409464774610005300059901204339911911861200
167:64:119662415380258741258612597339457052356856774450
167:65:189618904371794620763647654245601175273173042590
167:66:293047397665500777543819102015929089058540156730
167:67:441758017376351918386951183635952805894217251190
167:68:649644143200517527039634093582283538079731251750
167:69:932098118505090364882953264705015511157875274250
167:70:1304937365907126510836134570587021715621025383950
167:71:1782801753422412275367676807703395865003372707650
167:72:2377069004563216367156902410271194486671163610200
167:73:3093445964842541847669941492818677756626856753000
167:74:3929512441827012617310466220607509582742223443000
167:75:4872595427865495645464978113553311882600357069320
167:76:5898404991626652623457605084827693331568853294440
167:77:6970842262831498554995351463887273937308644802520
167:78:8043279534036344486533097842946854543048436310600
167:79:9061416183914362775967667190155317143434314324600
167:80:9967557802305799053564433909170848857777745757060
167:81:10705895417291413798272910495035356180576097294620
167:82:11228134218134897398188662226500495506457858138260
167:83:11498691669174292516217304689789664072878529418700
167:84:11498691669174292516217304689789664072878529418700
167:85:11228134218134897398188662226500495506457858138260
167:86:10705895417291413798272910495035356180576097294620
167:87:9967557802305799053564433909170848857777745757060
167:88:9061416183914362775967667190155317143434314324600
167:89:8043279534036344486533097842946854543048436310600
167:90:6970842262831498554995351463887273937308644802520
167:91:5898404991626652623457605084827693331568853294440
167:92:4872595427865495645464978113553311882600357069320
167:93:3929512441827012617310466220607509582742223443000
167:94:3093445964842541847669941492818677756626856753000
167:95:2377069004563216367156902410271194486671163610200
167:96:1782801753422412275367676807703395865003372707650
167:97:1304937365907126510836134570587021715621025383950
167:98:932098118505090364882953264705015511157875274250
167:99:649644143200517527039634093582283538079731251750
167:100:441758017376351918386951183635952805894217251190
167:101:293047397665500777543819102015929089058540156730
167:102:189618904371794620763647654245601175273173042590
167:103:119662415380258741258612597339457052356856774450
167:104:73638409464774610005300059901204339911911861200
167:105:44183045678864766003180035940722603947147116720
167:106:25842913510279391435822285172875485327576615440
167:107:14732875926420961472758499023788828083945547120
167:108:8184931070233867484865832790993793379969748400
167:109:4430375533429341115661322336409484490075368400
167:110:2336016190353652588257788141015910003857921520
167:111:1199575881532956734510756072413575407386500240
167:112:599787940766478367255378036206787703693250120
167:113:291932183558905399991555681339586935425918200
167:114:138283665896323610522315849055593811517540200
167:115:63730732978305663979849913043012800090692440
167:116:28568949266137021784070650674454013833758680
167:117:12453131731393060777671822088864570132664040
167:118:5276750733641127448166026308840919547739000
167:119:2172779713852228949244834362463908049069000
167:120:869111885540891579697933744985563219627600
167:121:337588914218362845006635421605962572913200
167:122:127287623393808941559878929457985888147600
167:123:46568642705052051790199608338287520054000
167:124:16524357088889437732006312636166539374000
167:125:5684378838577966579810171546841289544656
167:126:1894792946192655526603390515613763181552
167:127:611704809400778555832590638898931420816
167:128:191157752937743298697684574655916069005
167:129:57791878795131694955113941175044392955
167:130:16893010724730803140725613574243745633
167:131:4771308372633890963411051162190981591
167:132:1301265919809242990021195771506631343
167:133:342438399949800786847683097764902985
167:134:86887355211143483230009144209005235
167:135:21239131273835073678446679695534613
167:136:4997442652667076159634512869537556
167:137:1130808191479411393785911671209228
167:138:245827867712915520388241667654180
167:139:51287828515644245260856175265980
167:140:10257565703128849052171235053196
167:141:1964214709109779605734917350612
167:142:359644946738410350345829937436
167:143:62874990688533278032487751300
167:144:10479165114755546338747958550
167:145:1662212397512948729594503770
167:146:250470361269074466103281390
167:147:35781480181296352300468770
167:148:4835335159634642202766050
167:149:616586362637974509077550
167:150:73990363516556941089306
167:151:8330040925705086082902
167:152:876846413232114324516
167:153:85965334630599443580
167:154:7815030420963585780
167:155:655454164338881388
167:156:50419551102990876
167:157:3532580013585348
167:158:223581013518060
167:159:12655529067060
167:160:632776453353
167:161:27512019711
167:162:1018963693
167:163:31256555
167:164:762355
167:165:13861
167:166:167
167:167:1

# binomial(168, k) for 0 <= k <= 168

168:0:1
168:1:168
168:2:14028
168:3:776216
168:4:32018910
168:5:1050220248
168:6:28530983404
168:7:660288473064
168:8:13288305520413
168:9:236236542585120
168:10:3756161027103408
168:11:53952131116576224
168:12:705873715441872264
168:13:8470484585302467168
168:14:93780365051563029360
168:15:962811747862713768096
168:16:9206887338937200407418
168:17:82320404442262027172208
168:18:690576726154531450166856
168:19:5451921522272616711843600
168:20:40616815340930994503234820
168:21:286251841450370818403750160
168:22:1912682758782023195697785160
168:23:12141377512268495068342462320
168:24:73354155803288824371235709850
168:25:422519937426943628378317688736
168:26:2323859655848189956080747288048
168:27:12221780412238628657906152403808
168:28:61545394218773094313027410319176
168:29:297115696228559765649097842920160
168:30:1376636059192326914174153338863408
168:31:6128250844146487553420424540746784
168:32:26236573926502149838081192565072169
168:33:108126486484978556908455823904539848
168:34:429325755160944270077692241973908220
168:35:1643704319759043776868878869271534328
168:36:6072574292443133953432246933697612934
168:37:21664319097364694104136664736434727224
168:38:74684889519862498095839554749288138588
168:39:248949631732874993652798515830960461960
168:40:802862562338521854530275213554847489821
168:41:2506497755593434082435981154512694602368
168:42:7579171784770622106413562062455052726208
168:43:22208735927467404311816484183007828918656
168:44:63092999793941489522205920974454059428000
168:45:173856266098860993350078537796273408201600
168:46:464876537612171786566514351063948461060800
168:47:1206700799759254424704569166591525792540800
168:48:3041891599393120528942768107449471268696600
168:49:7449530447493356397410860671304827596808000
168:50:17729882465034188225837848397705489680403040
168:51:41022080997530082561742472763318583966422720
168:52:92299682244442685763920563717466813924451120
168:53:202014398874629274502165762098606611608232640
168:54:430215849455229010513871530395180746943458400
168:55:891720124325383767246933717546374639119168320
168:56:1799363822299435101766134108620363111079750360
168:57:3535592071886609322768544213429485411244421760
168:58:6766391723782993703919110477425394493933289920
168:59:12615306603663208600527155127403277870045116800
168:60:22917806996654828957624331814782621463915295520
168:61:40575789436700352908580784196664313411522162560
168:62:70025959189144157439002321113598089274723732160
168:63:117821455143639376008480095841926943859058977920
168:64:193300824845033351263912657240661392268768635650
168:65:309281319752053362022260251585058227630029817040
168:66:482666302037295398307466756261530264331713199320
168:67:734805415041852695930770285651881894952757407920
168:68:1091402160576869445426585277218236343973948502940
168:69:1581742261705607891922587358287299049237606526000
168:70:2237035484412216875719087835292037226778900658200
168:71:3087739119329538786203811378290417580624398091600
168:72:4159870757985628642524579217974590351674536317850
168:73:5470514969405758214826843903089872243298020363200
168:74:7022958406669554464980407713426187339369080196000
168:75:8802107869692508262775444334160821465342580512320
168:76:10771000419492148268922583198381005214169210363760
168:77:12869247254458151178452956548714967268877498096960
168:78:15014121796867843041528449306834128480357081113120
168:79:17104695717950707262500765033102171686482750635200
168:80:19028973986220161829532101099326166001212060081660
168:81:20673453219597212851837344404206205038353843051680
168:82:21934029635426311196461572721535851687033955432880
168:83:22726825887309189914405966916290159579336387556960
168:84:22997383338348585032434609379579328145757058837400
168:85:22726825887309189914405966916290159579336387556960
168:86:21934029635426311196461572721535851687033955432880
168:87:20673453219597212851837344404206205038353843051680
168:88:19028973986220161829532101099326166001212060081660
168:89:17104695717950707262500765033102171686482750635200
168:90:15014121796867843041528449306834128480357081113120
168:91:12869247254458151178452956548714967268877498096960
168:92:10771000419492148268922583198381005214169210363760
168:93:8802107869692508262775444334160821465342580512320
168:94:7022958406669554464980407713426187339369080196000
168:95:5470514969405758214826843903089872243298020363200
168:96:4159870757985628642524579217974590351674536317850
168:97:3087739119329538786203811378290417580624398091600
168:98:2237035484412216875719087835292037226778900658200
168:99:1581742261705607891922587358287299049237606526000
168:100:1091402160576869445426585277218236343973948502940
168:101:734805415041852695930770285651881894952757407920
168:102:482666302037295398307466756261530264331713199320
168:103:309281319752053362022260251585058227630029817040
168:104:193300824845033351263912657240661392268768635650
168:105:117821455143639376008480095841926943859058977920
168:106:70025959189144157439002321113598089274723732160
168:107:40575789436700352908580784196664313411522162560
168:108:22917806996654828957624331814782621463915295520
168:109:12615306603663208600527155127403277870045116800
168:110:6766391723782993703919110477425394493933289920
168:111:3535592071886609322768544213429485411244421760
168:112:1799363822299435101766134108620363111079750360
168:113:891720124325383767246933717546374639119168320
168:114:430215849455229010513871530395180746943458400
168:115:202014398874629274502165762098606611608232640
168:116:92299682244442685763920563717466813924451120
168:117:41022080997530082561742472763318583966422720
168:118:17729882465034188225837848397705489680403040
168:119:7449530447493356397410860671304827596808000
168:120:3041891599393120528942768107449471268696600
168:121:1206700799759254424704569166591525792540800
168:122:464876537612171786566514351063948461060800
168:123:173856266098860993350078537796273408201600
168:124:63092999793941489522205920974454059428000
168:125:22208735927467404311816484183007828918656
168:126:7579171784770622106413562062455052726208
168:127:2506497755593434082435981154512694602368
168:128:802862562338521854530275213554847489821
168:129:248949631732874993652798515830960461960
168:130:74684889519862498095839554749288138588
168:131:21664319097364694104136664736434727224
168:132:6072574292443133953432246933697612934
168:133:1643704319759043776868878869271534328
168:134:429325755160944270077692241973908220
168:135:108126486484978556908455823904539848
168:136:26236573926502149838081192565072169
168:137:6128250844146487553420424540746784
168:138:1376636059192326914174153338863408
168:139:297115696228559765649097842920160
168:140:61545394218773094313027410319176
168:141:12221780412238628657906152403808
168:142:2323859655848189956080747288048
168:143:422519937426943628378317688736
168:144:73354155803288824371235709850
168:145:12141377512268495068342462320
168:146:1912682758782023195697785160
168:147:286251841450370818403750160
168:148:40616815340930994503234820
168:149:5451921522272616711843600
168:150:690576726154531450166856
168:151:82320404442262027172208
168:152:9206887338937200407418
168:153:962811747862713768096
168:154:93780365051563029360
168:155:8470484585302467168
168:156:705873715441872264
168:157:53952131116576224
168:158:3756161027103408
168:159:236236542585120
168:160:13288305520413
168:161:660288473064
168:162:28530983404
168:163:1050220248
168:164:32018910
168:165:776216
168:166:14028
168:167:168
168:168:1

# binomial(169, k) for 0 <= k <= 169

169:0:1
169:1:169
169:2:14196
169:3:790244
169:4:32795126
169:5:1082239158
169:6:29581203652
169:7:688819456468
169:8:13948593993477
169:9:249524848105533
169:10:3992397569688528
169:11:57708292143679632
169:12:759825846558448488
169:13:9176358300744339432
169:14:102250849636865496528
169:15:1056592112914276797456
169:16:10169699086799914175514
169:17:91527291781199227579626
169:18:772897130596793477339064
169:19:6142498248427148162010456
169:20:46068736863203611215078420
169:21:326868656791301812906984980
169:22:2198934600232394014101535320
169:23:14054060271050518264040247480
169:24:85495533315557319439578172170
169:25:495874093230232452749553398586
169:26:2746379593275133584459064976784
169:27:14545640068086818613986899691856
169:28:73767174631011722970933562722984
169:29:358661090447332859962125253239336
169:30:1673751755420886679823251181783568
169:31:7504886903338814467594577879610192
169:32:32364824770648637391501617105818953
169:33:134363060411480706746537016469612017
169:34:537452241645922826986148065878448068
169:35:2073030074919988046946571111245442548
169:36:7716278612202177730301125802969147262
169:37:27736893389807828057568911670132340158
169:38:96349208617227192199976219485722865812
169:39:323634521252737491748638070580248600548
169:40:1051812194071396848183073729385807951781
169:41:3309360317931955936966256368067542092189
169:42:10085669540364056188849543216967747328576
169:43:29787907712238026418230046245462881644864
169:44:85301735721408893834022405157461888346656
169:45:236949265892802482872284458770727467629600
169:46:638732803711032779916592888860221869262400
169:47:1671577337371426211271083517655474253601600
169:48:4248592399152374953647337274040997061237400
169:49:10491422046886476926353628778754298865504600
169:50:25179412912527544623248709069010317277211040
169:51:58751963462564270787580321161024073646825760
169:52:133321763241972768325663036480785397890873840
169:53:294314081119071960266086325816073425532683760
169:54:632230248329858285016037292493787358551691040
169:55:1321935973780612777760805247941555386062626720
169:56:2691083946624818869013067826166737750198918680
169:57:5334955894186044424534678322049848522324172120
169:58:10301983795669603026687654690854879905177711680
169:59:19381698327446202304446265604828672363978406720
169:60:35533113600318037558151486942185899333960412320
169:61:63493596433355181866205116011446934875437458080
169:62:110601748625844510347583105310262402686245894720
169:63:187847414332783533447482416955525033133782710080
169:64:311122279988672727272392753082588336127827613570
169:65:502582144597086713286172908825719619898798452690
169:66:791947621789348760329727007846588491961743016360
169:67:1217471717079148094238237041913412159284470607240
169:68:1826207575618722141357355562870118238926705910860
169:69:2673144422282477337349172635505535393211555028940
169:70:3818777746117824767641675193579336276016507184200
169:71:5324774603741755661922899213582454807403298749800
169:72:7247609877315167428728390596265007932298934409450
169:73:9630385727391386857351423121064462594972556681050
169:74:12493473376075312679807251616516059582667100559200
169:75:15825066276362062727755852047587008804711660708320
169:76:19573108289184656531698027532541826679511790876080
169:77:23640247673950299447375539747095972483046708460720
169:78:27883369051325994219981405855549095749234579210080
169:79:32118817514818550304029214339936300166839831748320
169:80:36133669704170869092032866132428337687694810716860
169:81:39702427205817374681369445503532371039565903133340
169:82:42607482855023524048298917125742056725387798484560
169:83:44660855522735501110867539637826011266370342989840
169:84:45724209225657774946840576295869487725093446394360
169:85:45724209225657774946840576295869487725093446394360
169:86:44660855522735501110867539637826011266370342989840
169:87:42607482855023524048298917125742056725387798484560
169:88:39702427205817374681369445503532371039565903133340
169:89:36133669704170869092032866132428337687694810716860
169:90:32118817514818550304029214339936300166839831748320
169:91:27883369051325994219981405855549095749234579210080
169:92:23640247673950299447375539747095972483046708460720
169:93:19573108289184656531698027532541826679511790876080
169:94:15825066276362062727755852047587008804711660708320
169:95:12493473376075312679807251616516059582667100559200
169:96:9630385727391386857351423121064462594972556681050
169:97:7247609877315167428728390596265007932298934409450
169:98:5324774603741755661922899213582454807403298749800
169:99:3818777746117824767641675193579336276016507184200
169:100:2673144422282477337349172635505535393211555028940
169:101:1826207575618722141357355562870118238926705910860
169:102:1217471717079148094238237041913412159284470607240
169:103:791947621789348760329727007846588491961743016360
169:104:502582144597086713286172908825719619898798452690
169:105:311122279988672727272392753082588336127827613570
169:106:187847414332783533447482416955525033133782710080
169:107:110601748625844510347583105310262402686245894720
169:108:63493596433355181866205116011446934875437458080
169:109:35533113600318037558151486942185899333960412320
169:110:19381698327446202304446265604828672363978406720
169:111:10301983795669603026687654690854879905177711680
169:112:5334955894186044424534678322049848522324172120
169:113:2691083946624818869013067826166737750198918680
169:114:1321935973780612777760805247941555386062626720
169:115:632230248329858285016037292493787358551691040
169:116:294314081119071960266086325816073425532683760
169:117:133321763241972768325663036480785397890873840
169:118:58751963462564270787580321161024073646825760
169:119:25179412912527544623248709069010317277211040
169:120:10491422046886476926353628778754298865504600
169:121:4248592399152374953647337274040997061237400
169:122:1671577337371426211271083517655474253601600
169:123:638732803711032779916592888860221869262400
169:124:236949265892802482872284458770727467629600
169:125:85301735721408893834022405157461888346656
169:126:29787907712238026418230046245462881644864
169:127:10085669540364056188849543216967747328576
169:128:3309360317931955936966256368067542092189
169:129:1051812194071396848183073729385807951781
169:130:323634521252737491748638070580248600548
169:131:96349208617227192199976219485722865812
169:132:27736893389807828057568911670132340158
169:133:7716278612202177730301125802969147262
169:134:2073030074919988046946571111245442548
169:135:537452241645922826986148065878448068
169:136:134363060411480706746537016469612017
169:137:32364824770648637391501617105818953
169:138:7504886903338814467594577879610192
169:139:1673751755420886679823251181783568
169:140:358661090447332859962125253239336
169:141:73767174631011722970933562722984
169:142:14545640068086818613986899691856
169:143:2746379593275133584459064976784
169:144:495874093230232452749553398586
169:145:85495533315557319439578172170
169:146:14054060271050518264040247480
169:147:2198934600232394014101535320
169:148:326868656791301812906984980
169:149:46068736863203611215078420
169:150:6142498248427148162010456
169:151:772897130596793477339064
169:152:91527291781199227579626
169:153:10169699086799914175514
169:154:1056592112914276797456
169:155:102250849636865496528
169:156:9176358300744339432
169:157:759825846558448488
169:158:57708292143679632
169:159:3992397569688528
169:160:249524848105533
169:161:13948593993477
169:162:688819456468
169:163:29581203652
169:164:1082239158
169:165:32795126
169:166:790244
169:167:14196
169:168:169
169:169:1

# binomial(170, k) for 0 <= k <= 170

170:0:1
170:1:170
170:2:14365
170:3:804440
170:4:33585370
170:5:1115034284
170:6:30663442810
170:7:718400660120
170:8:14637413449945
170:9:263473442099010
170:10:4241922417794061
170:11:61700689713368160
170:12:817534138702128120
170:13:9936184147302787920
170:14:111427207937609835960
170:15:1158842962551142293984
170:16:11226291199714190972970
170:17:101696990867999141755140
170:18:864424422377992704918690
170:19:6915395379023941639349520
170:20:52211235111630759377088876
170:21:372937393654505424122063400
170:22:2525803257023695827008520300
170:23:16252994871282912278141782800
170:24:99549593586607837703618419650
170:25:581369626545789772189131570756
170:26:3242253686505366037208618375370
170:27:17292019661361952198445964668640
170:28:88312814699098541584920462414840
170:29:432428265078344582933058815962320
170:30:2032412845868219539785376435022904
170:31:9178638658759701147417829061393760
170:32:39869711673987451859096194985429145
170:33:166727885182129344138038633575430970
170:34:671815302057403533732685082348060085
170:35:2610482316565910873932719177123890616
170:36:9789308687122165777247696914214589810
170:37:35453172002010005787870037473101487420
170:38:124086102007035020257545131155855205970
170:39:419983729869964683948614290065971466360
170:40:1375446715324134339931711799966056552329
170:41:4361172512003352785149330097453350043970
170:42:13395029858296012125815799585035289420765
170:43:39873577252602082607079589462430628973440
170:44:115089643433646920252252451402924769991520
170:45:322251001614211376706306863928189355976256
170:46:875682069603835262788877347630949336892000
170:47:2310310141082458991187676406515696122864000
170:48:5920169736523801164918420791696471314839000
170:49:14740014446038851880000966052795295926742000
170:50:35670834959414021549602337847764616142715640
170:51:83931376375091815410829030230034390924036800
170:52:192073726704537039113243357641809471537699600
170:53:427635844361044728591749362296858823423557600
170:54:926544329448930245282123618309860784084374800
170:55:1954166222110471062776842540435342744614317760
170:56:4013019920405431646773873074108293136261545400
170:57:8026039840810863293547746148216586272523090800
170:58:15636939689855647451222333012904728427501883800
170:59:29683682123115805331133920295683552269156118400
170:60:54914811927764239862597752547014571697938819040
170:61:99026710033673219424356602953632834209397870400
170:62:174095345059199692213788221321709337561683352800
170:63:298449162958628043795065522265787435820028604800
170:64:498969694321456260719875170038113369261610323650
170:65:813704424585759440558565661908307956026626066260
170:66:1294529766386435473615899916672308111860541469050
170:67:2009419338868496854567964049760000651246213623600
170:68:3043679292697870235595592604783530398211176518100
170:69:4499351997901199478706528198375653632138260939800
170:70:6491922168400302104990847829084871669228062213140
170:71:9143552349859580429564574407161791083419805934000
170:72:12572384481056923090651289809847462739702233159250
170:73:16877995604706554286079813717329470527271491090500
170:74:22123859103466699537158674737580522177639657240250
170:75:28318539652437375407563103664103068387378761267520
170:76:35398174565546719259453879580128835484223451584400
170:77:43213355963134955979073567279637799162558499336800
170:78:51523616725276293667356945602645068232281287670800
170:79:60002186566144544524010620195485395916074410958400
170:80:68252487218989419396062080472364637854534642465180
170:81:75836096909988243773402311635960708727260713850200
170:82:82309910060840898729668362629274427764953701617900
170:83:87268338377759025159166456763568067991758141474400
170:84:90385064748393276057708115933695498991463789384200
170:85:91448418451315549893681152591738975450186892788720
170:86:90385064748393276057708115933695498991463789384200
170:87:87268338377759025159166456763568067991758141474400
170:88:82309910060840898729668362629274427764953701617900
170:89:75836096909988243773402311635960708727260713850200
170:90:68252487218989419396062080472364637854534642465180
170:91:60002186566144544524010620195485395916074410958400
170:92:51523616725276293667356945602645068232281287670800
170:93:43213355963134955979073567279637799162558499336800
170:94:35398174565546719259453879580128835484223451584400
170:95:28318539652437375407563103664103068387378761267520
170:96:22123859103466699537158674737580522177639657240250
170:97:16877995604706554286079813717329470527271491090500
170:98:12572384481056923090651289809847462739702233159250
170:99:9143552349859580429564574407161791083419805934000
170:100:6491922168400302104990847829084871669228062213140
170:101:4499351997901199478706528198375653632138260939800
170:102:3043679292697870235595592604783530398211176518100
170:103:2009419338868496854567964049760000651246213623600
170:104:1294529766386435473615899916672308111860541469050
170:105:813704424585759440558565661908307956026626066260
170:106:498969694321456260719875170038113369261610323650
170:107:298449162958628043795065522265787435820028604800
170:108:174095345059199692213788221321709337561683352800
170:109:99026710033673219424356602953632834209397870400
170:110:54914811927764239862597752547014571697938819040
170:111:29683682123115805331133920295683552269156118400
170:112:15636939689855647451222333012904728427501883800
170:113:8026039840810863293547746148216586272523090800
170:114:4013019920405431646773873074108293136261545400
170:115:1954166222110471062776842540435342744614317760
170:116:926544329448930245282123618309860784084374800
170:117:427635844361044728591749362296858823423557600
170:118:192073726704537039113243357641809471537699600
170:119:83931376375091815410829030230034390924036800
170:120:35670834959414021549602337847764616142715640
170:121:14740014446038851880000966052795295926742000
170:122:5920169736523801164918420791696471314839000
170:123:2310310141082458991187676406515696122864000
170:124:875682069603835262788877347630949336892000
170:125:322251001614211376706306863928189355976256
170:126:115089643433646920252252451402924769991520
170:127:39873577252602082607079589462430628973440
170:128:13395029858296012125815799585035289420765
170:129:4361172512003352785149330097453350043970
170:130:1375446715324134339931711799966056552329
170:131:419983729869964683948614290065971466360
170:132:124086102007035020257545131155855205970
170:133:35453172002010005787870037473101487420
170:134:9789308687122165777247696914214589810
170:135:2610482316565910873932719177123890616
170:136:671815302057403533732685082348060085
170:137:166727885182129344138038633575430970
170:138:39869711673987451859096194985429145
170:139:9178638658759701147417829061393760
170:140:2032412845868219539785376435022904
170:141:432428265078344582933058815962320
170:142:88312814699098541584920462414840
170:143:17292019661361952198445964668640
170:144:3242253686505366037208618375370
170:145:581369626545789772189131570756
170:146:99549593586607837703618419650
170:147:16252994871282912278141782800
170:148:2525803257023695827008520300
170:149:372937393654505424122063400
170:150:52211235111630759377088876
170:151:6915395379023941639349520
170:152:864424422377992704918690
170:153:101696990867999141755140
170:154:11226291199714190972970
170:155:1158842962551142293984
170:156:111427207937609835960
170:157:9936184147302787920
170:158:817534138702128120
170:159:61700689713368160
170:160:4241922417794061
170:161:263473442099010
170:162:14637413449945
170:163:718400660120
170:164:30663442810
170:165:1115034284
170:166:33585370
170:167:804440
170:168:14365
170:169:170
170:170:1

# binomial(171, k) for 0 <= k <= 171

171:0:1
171:1:171
171:2:14535
171:3:818805
171:4:34389810
171:5:1148619654
171:6:31778477094
171:7:749064102930
171:8:15355814110065
171:9:278110855548955
171:10:4505395859893071
171:11:65942612131162221
171:12:879234828415496280
171:13:10753718286004916040
171:14:121363392084912623880
171:15:1270270170488752129944
171:16:12385134162265333266954
171:17:112923282067713332728110
171:18:966121413245991846673830
171:19:7779819801401934344268210
171:20:59126630490654701016438396
171:21:425148628766136183499152276
171:22:2898740650678201251130583700
171:23:18778798128306608105150303100
171:24:115802588457890749981760202450
171:25:680919220132397609892749990406
171:26:3823623313051155809397749946126
171:27:20534273347867318235654583044010
171:28:105604834360460493783366427083480
171:29:520741079777443124517979278377160
171:30:2464841110946564122718435250985224
171:31:11211051504627920687203205496416664
171:32:49048350332747153006514024046822905
171:33:206597596856116795997134828560860115
171:34:838543187239532877870723715923491055
171:35:3282297618623314407665404259471950701
171:36:12399791003688076651180416091338480426
171:37:45242480689132171565117734387316077230
171:38:159539274009045026045415168628956693390
171:39:544069831876999704206159421221826672330
171:40:1795430445194099023880326090032028018689
171:41:5736619227327487125081041897419406596299
171:42:17756202370299364910965129682488639464735
171:43:53268607110898094732895389047465918394205
171:44:154963220686249002859332040865355398964960
171:45:437340645047858296958559315331114125967776
171:46:1197933071218046639495184211559138692868256
171:47:3185992210686294253976553754146645459756000
171:48:8230479877606260156106097198212167437703000
171:49:20660184182562653044919386844491767241581000
171:50:50410849405452873429603303900559912069457640
171:51:119602211334505836960431368077799007066752440
171:52:276005103079628854524072387871843862461736400
171:53:619709571065581767704992719938668294961257200
171:54:1354180173809974973873872980606719607507932400
171:55:2880710551559401308058966158745203528698692560
171:56:5967186142515902709550715614543635880875863160
171:57:12039059761216294940321619222324879408784636200
171:58:23662979530666510744770079161121314700024974600
171:59:45320621812971452782356253308588280696658002200
171:60:84598494050880045193731672842698123967094937440
171:61:153941521961437459286954355500647405907336689440
171:62:273122055092872911638144824275342171771081223200
171:63:472544508017827736008853743587496773381711957600
171:64:797418857280084304514940692303900805081638928450
171:65:1312674118907215701278440831946421325288236389910
171:66:2108234190972194914174465578580616067887167535310
171:67:3303949105254932328183863966432308763106755092650
171:68:5053098631566367090163556654543531049457390141700
171:69:7543031290599069714302120803159184030349437457900
171:70:10991274166301501583697376027460525301366323152940
171:71:15635474518259882534555422236246662752647868147140
171:72:21715936830916503520215864217009253823122039093250
171:73:29450380085763477376731103527176933266973724249750
171:74:39001854708173253823238488454909992704911148330750
171:75:50442398755904074944721778401683590565018418507770
171:76:63716714217984094667016983244231903871602212851920
171:77:78611530528681675238527446859766634646781950921200
171:78:94736972688411249646430512882282867394839787007600
171:79:111525803291420838191367565798130464148355698629200
171:80:128254673785133963920072700667850033770609053423580
171:81:144088584128977663169464392108325346581795356315380
171:82:158146006970829142503070674265235136492214415468100
171:83:169578248438599923888834819392842495756711843092300
171:84:177653403126152301216874572697263566983221930858600
171:85:181833483199708825951389268525434474441650682172920
171:86:181833483199708825951389268525434474441650682172920
171:87:177653403126152301216874572697263566983221930858600
171:88:169578248438599923888834819392842495756711843092300
171:89:158146006970829142503070674265235136492214415468100
171:90:144088584128977663169464392108325346581795356315380
171:91:128254673785133963920072700667850033770609053423580
171:92:111525803291420838191367565798130464148355698629200
171:93:94736972688411249646430512882282867394839787007600
171:94:78611530528681675238527446859766634646781950921200
171:95:63716714217984094667016983244231903871602212851920
171:96:50442398755904074944721778401683590565018418507770
171:97:39001854708173253823238488454909992704911148330750
171:98:29450380085763477376731103527176933266973724249750
171:99:21715936830916503520215864217009253823122039093250
171:100:15635474518259882534555422236246662752647868147140
171:101:10991274166301501583697376027460525301366323152940
171:102:7543031290599069714302120803159184030349437457900
171:103:5053098631566367090163556654543531049457390141700
171:104:3303949105254932328183863966432308763106755092650
171:105:2108234190972194914174465578580616067887167535310
171:106:1312674118907215701278440831946421325288236389910
171:107:797418857280084304514940692303900805081638928450
171:108:472544508017827736008853743587496773381711957600
171:109:273122055092872911638144824275342171771081223200
171:110:153941521961437459286954355500647405907336689440
171:111:84598494050880045193731672842698123967094937440
171:112:45320621812971452782356253308588280696658002200
171:113:23662979530666510744770079161121314700024974600
171:114:12039059761216294940321619222324879408784636200
171:115:5967186142515902709550715614543635880875863160
171:116:2880710551559401308058966158745203528698692560
171:117:1354180173809974973873872980606719607507932400
171:118:619709571065581767704992719938668294961257200
171:119:276005103079628854524072387871843862461736400
171:120:119602211334505836960431368077799007066752440
171:121:50410849405452873429603303900559912069457640
171:122:20660184182562653044919386844491767241581000
171:123:8230479877606260156106097198212167437703000
171:124:3185992210686294253976553754146645459756000
171:125:1197933071218046639495184211559138692868256
171:126:437340645047858296958559315331114125967776
171:127:154963220686249002859332040865355398964960
171:128:53268607110898094732895389047465918394205
171:129:17756202370299364910965129682488639464735
171:130:5736619227327487125081041897419406596299
171:131:1795430445194099023880326090032028018689
171:132:544069831876999704206159421221826672330
171:133:159539274009045026045415168628956693390
171:134:45242480689132171565117734387316077230
171:135:12399791003688076651180416091338480426
171:136:3282297618623314407665404259471950701
171:137:838543187239532877870723715923491055
171:138:206597596856116795997134828560860115
171:139:49048350332747153006514024046822905
171:140:11211051504627920687203205496416664
171:141:2464841110946564122718435250985224
171:142:520741079777443124517979278377160
171:143:105604834360460493783366427083480
171:144:20534273347867318235654583044010
171:145:3823623313051155809397749946126
171:146:680919220132397609892749990406
171:147:115802588457890749981760202450
171:148:18778798128306608105150303100
171:149:2898740650678201251130583700
171:150:425148628766136183499152276
171:151:59126630490654701016438396
171:152:7779819801401934344268210
171:153:966121413245991846673830
171:154:112923282067713332728110
171:155:12385134162265333266954
171:156:1270270170488752129944
171:157:121363392084912623880
171:158:10753718286004916040
171:159:879234828415496280
171:160:65942612131162221
171:161:4505395859893071
171:162:278110855548955
171:163:15355814110065
171:164:749064102930
171:165:31778477094
171:166:1148619654
171:167:34389810
171:168:818805
171:169:14535
171:170:171
171:171:1

# binomial(172, k) for 0 <= k <= 172

172:0:1
172:1:172
172:2:14706
172:3:833340
172:4:35208615
172:5:1183009464
172:6:32927096748
172:7:780842580024
172:8:16104878212995
172:9:293466669659020
172:10:4783506715442026
172:11:70448007991055292
172:12:945177440546658501
172:13:11632953114420412320
172:14:132117110370917539920
172:15:1391633562573664753824
172:16:13655404332754085396898
172:17:125308416229978665995064
172:18:1079044695313705179401940
172:19:8745941214647926190942040
172:20:66906450292056635360706606
172:21:484275259256790884515590672
172:22:3323889279444337434629735976
172:23:21677538778984809356280886800
172:24:134581386586197358086910505550
172:25:796721808590288359874510192856
172:26:4504542533183553419290499936532
172:27:24357896660918474045052332990136
172:28:126139107708327812019021010127490
172:29:626345914137903618301345705460640
172:30:2985582190724007247236414529362384
172:31:13675892615574484809921640747401888
172:32:60259401837375073693717229543239569
172:33:255645947188863949003648852607683020
172:34:1045140784095649673867858544484351170
172:35:4120840805862847285536127975395441756
172:36:15682088622311391058845820350810431127
172:37:57642271692820248216298150478654557656
172:38:204781754698177197610532903016272770620
172:39:703609105886044730251574589850783365720
172:40:2339500277071098728086485511253854691019
172:41:7532049672521586148961367987451434614988
172:42:23492821597626852036046171579908046061034
172:43:71024809481197459643860518729954557858940
172:44:208231827797147097592227429912821317359165
172:45:592303865734107299817891356196469524932736
172:46:1635273716265904936453743526890252818836032
172:47:4383925281904340893471737965705784152624256
172:48:11416472088292554410082650952358812897459000
172:49:28890664060168913201025484042703934679284000
172:50:71071033588015526474522690745051679311038640
172:51:170013060739958710390034671978358919136210080
172:52:395607314414134691484503755949642869528488840
172:53:895714674145210622229065107810512157422993600
172:54:1973889744875556741578865700545387902469189600
172:55:4234890725369376281932839139351923136206624960
172:56:8847896694075304017609681773288839409574555720
172:57:18006245903732197649872334836868515289660499360
172:58:35702039291882805685091698383446194108809610800
172:59:68983601343637963527126332469709595396682976800
172:60:129919115863851497976087926151286404663752939640
172:61:238540016012317504480686028343345529874431626880
172:62:427063577054310370925099179775989577678417912640
172:63:745666563110700647646998567862838945152793180800
172:64:1269963365297912040523794435891397578463350886050
172:65:2110092976187300005793381524250322130369875318360
172:66:3420908309879410615452906410527037393175403925220
172:67:5412183296227127242358329545012924830993922627960
172:68:8357047736821299418347420620975839812564145234350
172:69:12596129922165436804465677457702715079806827599600
172:70:18534305456900571297999496830619709331715760610840
172:71:26626748684561384118252798263707188054014191300080
172:72:37351411349176386054771286453255916575769907240390
172:73:51166316916679980896946967744186187090095763343000
172:74:68452234793936731199969591982086925971884872580500
172:75:89444253464077328767960266856593583269929566838520
172:76:114159112973888169611738761645915494436620631359690
172:77:142328244746665769905544430103998538518384163773120
172:78:173348503217092924884957959742049502041621737928800
172:79:206262775979832087837798078680413331543195485636800
172:80:239780477076554802111440266465980497918964752052780
172:81:272343257914111627089537092776175380352404409738960
172:82:302234591099806805672535066373560483074009771783480
172:83:327724255409429066391905493658077632248926258560400
172:84:347231651564752225105709392090106062739933773950900
172:85:359486886325861127168263841222698041424872613031520
172:86:363666966399417651902778537050868948883301364345840
172:87:359486886325861127168263841222698041424872613031520
172:88:347231651564752225105709392090106062739933773950900
172:89:327724255409429066391905493658077632248926258560400
172:90:302234591099806805672535066373560483074009771783480
172:91:272343257914111627089537092776175380352404409738960
172:92:239780477076554802111440266465980497918964752052780
172:93:206262775979832087837798078680413331543195485636800
172:94:173348503217092924884957959742049502041621737928800
172:95:142328244746665769905544430103998538518384163773120
172:96:114159112973888169611738761645915494436620631359690
172:97:89444253464077328767960266856593583269929566838520
172:98:68452234793936731199969591982086925971884872580500
172:99:51166316916679980896946967744186187090095763343000
172:100:37351411349176386054771286453255916575769907240390
172:101:26626748684561384118252798263707188054014191300080
172:102:18534305456900571297999496830619709331715760610840
172:103:12596129922165436804465677457702715079806827599600
172:104:8357047736821299418347420620975839812564145234350
172:105:5412183296227127242358329545012924830993922627960
172:106:3420908309879410615452906410527037393175403925220
172:107:2110092976187300005793381524250322130369875318360
172:108:1269963365297912040523794435891397578463350886050
172:109:745666563110700647646998567862838945152793180800
172:110:427063577054310370925099179775989577678417912640
172:111:238540016012317504480686028343345529874431626880
172:112:129919115863851497976087926151286404663752939640
172:113:68983601343637963527126332469709595396682976800
172:114:35702039291882805685091698383446194108809610800
172:115:18006245903732197649872334836868515289660499360
172:116:8847896694075304017609681773288839409574555720
172:117:4234890725369376281932839139351923136206624960
172:118:1973889744875556741578865700545387902469189600
172:119:895714674145210622229065107810512157422993600
172:120:395607314414134691484503755949642869528488840
172:121:170013060739958710390034671978358919136210080
172:122:71071033588015526474522690745051679311038640
172:123:28890664060168913201025484042703934679284000
172:124:11416472088292554410082650952358812897459000
172:125:4383925281904340893471737965705784152624256
172:126:1635273716265904936453743526890252818836032
172:127:592303865734107299817891356196469524932736
172:128:208231827797147097592227429912821317359165
172:129:71024809481197459643860518729954557858940
172:130:23492821597626852036046171579908046061034
172:131:7532049672521586148961367987451434614988
172:132:2339500277071098728086485511253854691019
172:133:703609105886044730251574589850783365720
172:134:204781754698177197610532903016272770620
172:135:57642271692820248216298150478654557656
172:136:15682088622311391058845820350810431127
172:137:4120840805862847285536127975395441756
172:138:1045140784095649673867858544484351170
172:139:255645947188863949003648852607683020
172:140:60259401837375073693717229543239569
172:141:13675892615574484809921640747401888
172:142:2985582190724007247236414529362384
172:143:626345914137903618301345705460640
172:144:126139107708327812019021010127490
172:145:24357896660918474045052332990136
172:146:4504542533183553419290499936532
172:147:796721808590288359874510192856
172:148:134581386586197358086910505550
172:149:21677538778984809356280886800
172:150:3323889279444337434629735976
172:151:484275259256790884515590672
172:152:66906450292056635360706606
172:153:8745941214647926190942040
172:154:1079044695313705179401940
172:155:125308416229978665995064
172:156:13655404332754085396898
172:157:1391633562573664753824
172:158:132117110370917539920
172:159:11632953114420412320
172:160:945177440546658501
172:161:70448007991055292
172:162:4783506715442026
172:163:293466669659020
172:164:16104878212995
172:165:780842580024
172:166:32927096748
172:167:1183009464
172:168:35208615
172:169:833340
172:170:14706
172:171:172
172:172:1

# binomial(173, k) for 0 <= k <= 173

173:0:1
173:1:173
173:2:14878
173:3:848046
173:4:36041955
173:5:1218218079
173:6:34110106212
173:7:813769676772
173:8:16885720793019
173:9:309571547872015
173:10:5076973385101046
173:11:75231514706497318
173:12:1015625448537713793
173:13:12578130554967070821
173:14:143750063485337952240
173:15:1523750672944582293744
173:16:15047037895327750150722
173:17:138963820562732751391962
173:18:1204353111543683845397004
173:19:9824985909961631370343980
173:20:75652391506704561551648646
173:21:551181709548847519876297278
173:22:3808164538701128319145326648
173:23:25001428058429146790910622776
173:24:156258925365182167443191392350
173:25:931303195176485717961420698406
173:26:5301264341773841779165010129388
173:27:28862439194102027464342832926668
173:28:150497004369246286064073343117626
173:29:752485021846231430320366715588130
173:30:3611928104861910865537760234823024
173:31:16661474806298492057158055276764272
173:32:73935294452949558503638870290641457
173:33:315905349026239022697366082150922589
173:34:1300786731284513622871507397092034190
173:35:5165981589958496959403986519879792926
173:36:19802929428174238344381948326205872883
173:37:73324360315131639275143970829464988783
173:38:262424026390997445826831053494927328276
173:39:908390860584221927862107492867056136340
173:40:3043109382957143458338060101104638056739
173:41:9871549949592684877047853498705289306007
173:42:31024871270148438185007539567359480676022
173:43:94517631078824311679906690309862603919974
173:44:279256637278344557236087948642775875218105
173:45:800535693531254397410118786109290842291901
173:46:2227577582000012236271634883086722343768768
173:47:6019198998170245829925481492596036971460288
173:48:15800397370196895303554388918064597050083256
173:49:40307136148461467611108134995062747576743000
173:50:99961697648184439675548174787755613990322640
173:51:241084094327974236864557362723410598447248720
173:52:565620375154093401874538427928001788664698920
173:53:1291321988559345313713568863760155026951482440
173:54:2869604419020767363807930808355900059892183200
173:55:6208780470244933023511704839897311038675814560
173:56:13082787419444680299542520912640762545781180680
173:57:26854142597807501667482016610157354699235055080
173:58:53708285195615003334964033220314709398470110160
173:59:104685640635520769212218030853155789505492587600
173:60:198902717207489461503214258620996000060435916440
173:61:368459131876169002456773954494631934538184566520
173:62:665603593066627875405785208119335107552849539520
173:63:1172730140165011018572097747638828522831211093440
173:64:2015629928408612688170793003754236523616144066850
173:65:3380056341485212046317175960141719708833226204410
173:66:5531001286066710621246287934777359523545279243580
173:67:8833091606106537857811235955539962224169326553180
173:68:13769231033048426660705750165988764643558067862310
173:69:20953177658986736222813098078678554892370972833950
173:70:31130435379066008102465174288322424411522588210440
173:71:45161054141461955416252295094326897385729951910920
173:72:63978160033737770173024084716963104629784098540470
173:73:88517728265856366951718254197442103665865670583390
173:74:119618551710616712096916559726273113061980635923500
173:75:157896488258014059967929858838680509241814439419020
173:76:203603366437965498379699028502509077706550198198210
173:77:256487357720553939517283191749914032955004795132810
173:78:315676747963758694790502389846048040560005901701920
173:79:379611279196925012722756038422462833584817223565600
173:80:446043253056386889949238345146393829462160237689580
173:81:512123734990666429200977359242155878271369161791740
173:82:574577849013918432762072159149735863426414181522440
173:83:629958846509235872064440560031638115322936030343880
173:84:674955906974181291497614885748183694988860032511300
173:85:706718537890613352273973233312804104164806386982420
173:86:723153852725278779071042378273566990308173977377360
173:87:723153852725278779071042378273566990308173977377360
173:88:706718537890613352273973233312804104164806386982420
173:89:674955906974181291497614885748183694988860032511300
173:90:629958846509235872064440560031638115322936030343880
173:91:574577849013918432762072159149735863426414181522440
173:92:512123734990666429200977359242155878271369161791740
173:93:446043253056386889949238345146393829462160237689580
173:94:379611279196925012722756038422462833584817223565600
173:95:315676747963758694790502389846048040560005901701920
173:96:256487357720553939517283191749914032955004795132810
173:97:203603366437965498379699028502509077706550198198210
173:98:157896488258014059967929858838680509241814439419020
173:99:119618551710616712096916559726273113061980635923500
173:100:88517728265856366951718254197442103665865670583390
173:101:63978160033737770173024084716963104629784098540470
173:102:45161054141461955416252295094326897385729951910920
173:103:31130435379066008102465174288322424411522588210440
173:104:20953177658986736222813098078678554892370972833950
173:105:13769231033048426660705750165988764643558067862310
173:106:8833091606106537857811235955539962224169326553180
173:107:5531001286066710621246287934777359523545279243580
173:108:3380056341485212046317175960141719708833226204410
173:109:2015629928408612688170793003754236523616144066850
173:110:1172730140165011018572097747638828522831211093440
173:111:665603593066627875405785208119335107552849539520
173:112:368459131876169002456773954494631934538184566520
173:113:198902717207489461503214258620996000060435916440
173:114:104685640635520769212218030853155789505492587600
173:115:53708285195615003334964033220314709398470110160
173:116:26854142597807501667482016610157354699235055080
173:117:13082787419444680299542520912640762545781180680
173:118:6208780470244933023511704839897311038675814560
173:119:2869604419020767363807930808355900059892183200
173:120:1291321988559345313713568863760155026951482440
173:121:565620375154093401874538427928001788664698920
173:122:241084094327974236864557362723410598447248720
173:123:99961697648184439675548174787755613990322640
173:124:40307136148461467611108134995062747576743000
173:125:15800397370196895303554388918064597050083256
173:126:6019198998170245829925481492596036971460288
173:127:2227577582000012236271634883086722343768768
173:128:800535693531254397410118786109290842291901
173:129:279256637278344557236087948642775875218105
173:130:94517631078824311679906690309862603919974
173:131:31024871270148438185007539567359480676022
173:132:9871549949592684877047853498705289306007
173:133:3043109382957143458338060101104638056739
173:134:908390860584221927862107492867056136340
173:135:262424026390997445826831053494927328276
173:136:73324360315131639275143970829464988783
173:137:19802929428174238344381948326205872883
173:138:5165981589958496959403986519879792926
173:139:1300786731284513622871507397092034190
173:140:315905349026239022697366082150922589
173:141:73935294452949558503638870290641457
173:142:16661474806298492057158055276764272
173:143:3611928104861910865537760234823024
173:144:752485021846231430320366715588130
173:145:150497004369246286064073343117626
173:146:28862439194102027464342832926668
173:147:5301264341773841779165010129388
173:148:931303195176485717961420698406
173:149:156258925365182167443191392350
173:150:25001428058429146790910622776
173:151:3808164538701128319145326648
173:152:551181709548847519876297278
173:153:75652391506704561551648646
173:154:9824985909961631370343980
173:155:1204353111543683845397004
173:156:138963820562732751391962
173:157:15047037895327750150722
173:158:1523750672944582293744
173:159:143750063485337952240
173:160:12578130554967070821
173:161:1015625448537713793
173:162:75231514706497318
173:163:5076973385101046
173:164:309571547872015
173:165:16885720793019
173:166:813769676772
173:167:34110106212
173:168:1218218079
173:169:36041955
173:170:848046
173:171:14878
173:172:173
173:173:1

# binomial(174, k) for 0 <= k <= 174

174:0:1
174:1:174
174:2:15051
174:3:862924
174:4:36890001
174:5:1254260034
174:6:35328324291
174:7:847879782984
174:8:17699490469791
174:9:326457268665034
174:10:5386544932973061
174:11:80308488091598364
174:12:1090856963244211111
174:13:13593756003504784614
174:14:156328194040305023061
174:15:1667500736429920245984
174:16:16570788568272332444466
174:17:154010858458060501542684
174:18:1343316932106416596788966
174:19:11029339021505315215740984
174:20:85477377416666192921992626
174:21:626834101055552081427945924
174:22:4359346248249975839021623926
174:23:28809592597130275110055949424
174:24:181260353423611314234102015126
174:25:1087562120541667885404612090756
174:26:6232567536950327497126430827794
174:27:34163703535875869243507843056056
174:28:179359443563348313528416176044294
174:29:902982026215477716384440058705756
174:30:4364413126708142295858126950411154
174:31:20273402911160402922695815511587296
174:32:90596769259248050560796925567405729
174:33:389840643479188581201004952441564046
174:34:1616692080310752645568873479242956779
174:35:6466768321243010582275493916971827116
174:36:24968911018132735303785934846085665809
174:37:93127289743305877619525919155670861666
174:38:335748386706129085101975024324392317059
174:39:1170814886975219373688938546361983464616
174:40:3951500243541365386200167593971694193079
174:41:12914659332549828335385913599809927362746
174:42:40896421219741123062055393066064769982029
174:43:125542502348972749864914229877222084595996
174:44:373774268357168868915994638952638479138079
174:45:1079792330809598954646206734752066717510006
174:46:3028113275531266633681753669196013186060669
174:47:8246776580170258066197116375682759315229056
174:48:21819596368367141133479870410660634021543544
174:49:56107533518658362914662523913127344626826256
174:50:140268833796645907286656309782818361567065640
174:51:341045791976158676540105537511166212437571360
174:52:806704469482067638739095790651412387111947640
174:53:1856942363713438715588107291688156815616181360
174:54:4160926407580112677521499672116055086843665640
174:55:9078384889265700387319635648253211098567997760
174:56:19291567889689613323054225752538073584456995240
174:57:39936930017252181967024537522798117245016235760
174:58:80562427793422505002446049830472064097705165240
174:59:158393925831135772547182064073470498903962697760
174:60:303588357843010230715432289474151789565928504040
174:61:567361849083658463959988213115627934598620482960
174:62:1034062724942796877862559162613967042091034106040
174:63:1838333733231638893977882955758163630384060632960
174:64:3188360068573623706742890751393065046447355160290
174:65:5395686269893824734487968963895956232449370271260
174:66:8911057627551922667563463894919079232378505447990
174:67:14364092892173248479057523890317321747714605796760
174:68:22602322639154964518516986121528726867727394415490
174:69:34722408692035162883518848244667319535929040696260
174:70:52083613038052744325278272367000979303893561044390
174:71:76291489520527963518717469382649321797252540121360
174:72:109139214175199725589276379811290002015514050451390
174:73:152495888299594137124742338914405208295649769123860
174:74:208136279976473079048634813923715216727846306506890
174:75:277515039968630772064846418564953622303795075342520
174:76:361499854695979558347628887341189586948364637617230
174:77:460090724158519437896982220252423110661554993331020
174:78:572164105684312634307785581595962073515010696834730
174:79:695288027160683707513258428268510874144823125267520
174:80:825654532253311902671994383568856663046977461255180
174:81:958166988047053319150215704388549707733529399481320
174:82:1086701584004584861963049518391891741697783343314180
174:83:1204536695523154304826512719181373978749350211866320
174:84:1304914753483417163562055445779821810311796062855180
174:85:1381674444864794643771588119060987799153666419493720
174:86:1429872390615892131345015611586371094472980364359780
174:87:1446307705450557558142084756547133980616347954754720
174:88:1429872390615892131345015611586371094472980364359780
174:89:1381674444864794643771588119060987799153666419493720
174:90:1304914753483417163562055445779821810311796062855180
174:91:1204536695523154304826512719181373978749350211866320
174:92:1086701584004584861963049518391891741697783343314180
174:93:958166988047053319150215704388549707733529399481320
174:94:825654532253311902671994383568856663046977461255180
174:95:695288027160683707513258428268510874144823125267520
174:96:572164105684312634307785581595962073515010696834730
174:97:460090724158519437896982220252423110661554993331020
174:98:361499854695979558347628887341189586948364637617230
174:99:277515039968630772064846418564953622303795075342520
174:100:208136279976473079048634813923715216727846306506890
174:101:152495888299594137124742338914405208295649769123860
174:102:109139214175199725589276379811290002015514050451390
174:103:76291489520527963518717469382649321797252540121360
174:104:52083613038052744325278272367000979303893561044390
174:105:34722408692035162883518848244667319535929040696260
174:106:22602322639154964518516986121528726867727394415490
174:107:14364092892173248479057523890317321747714605796760
174:108:8911057627551922667563463894919079232378505447990
174:109:5395686269893824734487968963895956232449370271260
174:110:3188360068573623706742890751393065046447355160290
174:111:1838333733231638893977882955758163630384060632960
174:112:1034062724942796877862559162613967042091034106040
174:113:567361849083658463959988213115627934598620482960
174:114:303588357843010230715432289474151789565928504040
174:115:158393925831135772547182064073470498903962697760
174:116:80562427793422505002446049830472064097705165240
174:117:39936930017252181967024537522798117245016235760
174:118:19291567889689613323054225752538073584456995240
174:119:9078384889265700387319635648253211098567997760
174:120:4160926407580112677521499672116055086843665640
174:121:1856942363713438715588107291688156815616181360
174:122:806704469482067638739095790651412387111947640
174:123:341045791976158676540105537511166212437571360
174:124:140268833796645907286656309782818361567065640
174:125:56107533518658362914662523913127344626826256
174:126:21819596368367141133479870410660634021543544
174:127:8246776580170258066197116375682759315229056
174:128:3028113275531266633681753669196013186060669
174:129:1079792330809598954646206734752066717510006
174:130:373774268357168868915994638952638479138079
174:131:125542502348972749864914229877222084595996
174:132:40896421219741123062055393066064769982029
174:133:12914659332549828335385913599809927362746
174:134:3951500243541365386200167593971694193079
174:135:1170814886975219373688938546361983464616
174:136:335748386706129085101975024324392317059
174:137:93127289743305877619525919155670861666
174:138:24968911018132735303785934846085665809
174:139:6466768321243010582275493916971827116
174:140:1616692080310752645568873479242956779
174:141:389840643479188581201004952441564046
174:142:90596769259248050560796925567405729
174:143:20273402911160402922695815511587296
174:144:4364413126708142295858126950411154
174:145:902982026215477716384440058705756
174:146:179359443563348313528416176044294
174:147:34163703535875869243507843056056
174:148:6232567536950327497126430827794
174:149:1087562120541667885404612090756
174:150:181260353423611314234102015126
174:151:28809592597130275110055949424
174:152:4359346248249975839021623926
174:153:626834101055552081427945924
174:154:85477377416666192921992626
174:155:11029339021505315215740984
174:156:1343316932106416596788966
174:157:154010858458060501542684
174:158:16570788568272332444466
174:159:1667500736429920245984
174:160:156328194040305023061
174:161:13593756003504784614
174:162:1090856963244211111
174:163:80308488091598364
174:164:5386544932973061
174:165:326457268665034
174:166:17699490469791
174:167:847879782984
174:168:35328324291
174:169:1254260034
174:170:36890001
174:171:862924
174:172:15051
174:173:174
174:174:1

# binomial(175, k) for 0 <= k <= 175

175:0:1
175:1:175
175:2:15225
175:3:877975
175:4:37752925
175:5:1291150035
175:6:36582584325
175:7:883208107275
175:8:18547370252775
175:9:344156759134825
175:10:5713002201638095
175:11:85695033024571425
175:12:1171165451335809475
175:13:14684612966748995725
175:14:169921950043809807675
175:15:1823828930470225269045
175:16:18238289304702252690450
175:17:170581647026332833987150
175:18:1497327790564477098331650
175:19:12372655953611731812529950
175:20:96506716438171508137733610
175:21:712311478472218274349938550
175:22:4986180349305527920449569850
175:23:33168938845380250949077573350
175:24:210069946020741589344157964550
175:25:1268822473965279199638714105882
175:26:7320129657491995382531042918550
175:27:40396271072826196740634273883850
175:28:213523147099224182771924019100350
175:29:1082341469778826029912856234750050
175:30:5267395152923620012242567009116910
175:31:24637816037868545218553942461998450
175:32:110870172170408453483492741078993025
175:33:480437412738436631761801878008969775
175:34:2006532723789941226769878431684520825
175:35:8083460401553763227844367396214783895
175:36:31435679339375745886061428763057492925
175:37:118096200761438612923311854001756527475
175:38:428875676449434962721500943480063178725
175:39:1506563273681348458790913570686375781675
175:40:5122315130516584759889106140333677657695
175:41:16866159576091193721586081193781621555825
175:42:53811080552290951397441306665874697344775
175:43:166438923568713872926969622943286854578025
175:44:499316770706141618780908868829860563734075
175:45:1453566599166767823562201373704705196648085
175:46:4107905606340865588327960403948079903570675
175:47:11274889855701524699878870044878772501289725
175:48:30066372948537399199676986786343393336772600
175:49:77927129887025504048142394323787978648369800
175:50:196376367315304270201318833695945706193891896
175:51:481314625772804583826761847293984574004637000
175:52:1147750261458226315279201328162578599549519000
175:53:2663646833195506354327203082339569202728129000
175:54:6017868771293551393109606963804211902459847000
175:55:13239311296845813064841135320369266185411663400
175:56:28369952778955313710373861400791284683024993000
175:57:59228497906941795290078763275336190829473231000
175:58:120499357810674686969470587353270181342721401000
175:59:238956353624558277549628113903942563001667863000
175:60:461982283674146003262614353547622288469891201800
175:61:870950206926668694675420502589779724164548987000
175:62:1601424574026455341822547375729594976689654589000
175:63:2872396458174435771840442118372130672475094739000
175:64:5026693801805262600720773707151228676831415793250
175:65:8584046338467448441230859715289021278896725431550
175:66:14306743897445747402051432858815035464827875719250
175:67:23275150519725171146620987785236400980093111244750
175:68:36966415531328212997574510011846048615442000212250
175:69:57324731331190127402035834366196046403656435111750
175:70:86806021730087907208797120611668298839822601740650
175:71:128375102558580707843995741749650301101146101165750
175:72:185430703695727689107993849193939323812766590572750
175:73:261635102474793862714018718725695210311163819575250
175:74:360632168276067216173377152838120425023496075630750
175:75:485651319945103851113481232488668839031641381849410
175:76:639014894664610330412475305906143209252159712959750
175:77:821590578854498996244611107593612697609919630948250
175:78:1032254829842832072204767801848385184176565690165750
175:79:1267452132844996341821044009864472947659833822102250
175:80:1520942559413995610185252811837367537191800586522700
175:81:1783821520300365221822210087957406370780506860736500
175:82:2044868572051638181113265222780441449431312742795500
175:83:2291238279527739166789562237573265720447133555180500
175:84:2509451449006571468388568164961195789061146274721500
175:85:2686589198348211807333643564840809609465462482348900
175:86:2811546835480686775116603730647358893626646783853500
175:87:2876180096066449689487100368133505075089328319114500
175:88:2876180096066449689487100368133505075089328319114500
175:89:2811546835480686775116603730647358893626646783853500
175:90:2686589198348211807333643564840809609465462482348900
175:91:2509451449006571468388568164961195789061146274721500
175:92:2291238279527739166789562237573265720447133555180500
175:93:2044868572051638181113265222780441449431312742795500
175:94:1783821520300365221822210087957406370780506860736500
175:95:1520942559413995610185252811837367537191800586522700
175:96:1267452132844996341821044009864472947659833822102250
175:97:1032254829842832072204767801848385184176565690165750
175:98:821590578854498996244611107593612697609919630948250
175:99:639014894664610330412475305906143209252159712959750
175:100:485651319945103851113481232488668839031641381849410
175:101:360632168276067216173377152838120425023496075630750
175:102:261635102474793862714018718725695210311163819575250
175:103:185430703695727689107993849193939323812766590572750
175:104:128375102558580707843995741749650301101146101165750
175:105:86806021730087907208797120611668298839822601740650
175:106:57324731331190127402035834366196046403656435111750
175:107:36966415531328212997574510011846048615442000212250
175:108:23275150519725171146620987785236400980093111244750
175:109:14306743897445747402051432858815035464827875719250
175:110:8584046338467448441230859715289021278896725431550
175:111:5026693801805262600720773707151228676831415793250
175:112:2872396458174435771840442118372130672475094739000
175:113:1601424574026455341822547375729594976689654589000
175:114:870950206926668694675420502589779724164548987000
175:115:461982283674146003262614353547622288469891201800
175:116:238956353624558277549628113903942563001667863000
175:117:120499357810674686969470587353270181342721401000
175:118:59228497906941795290078763275336190829473231000
175:119:28369952778955313710373861400791284683024993000
175:120:13239311296845813064841135320369266185411663400
175:121:6017868771293551393109606963804211902459847000
175:122:2663646833195506354327203082339569202728129000
175:123:1147750261458226315279201328162578599549519000
175:124:481314625772804583826761847293984574004637000
175:125:196376367315304270201318833695945706193891896
175:126:77927129887025504048142394323787978648369800
175:127:30066372948537399199676986786343393336772600
175:128:11274889855701524699878870044878772501289725
175:129:4107905606340865588327960403948079903570675
175:130:1453566599166767823562201373704705196648085
175:131:499316770706141618780908868829860563734075
175:132:166438923568713872926969622943286854578025
175:133:53811080552290951397441306665874697344775
175:134:16866159576091193721586081193781621555825
175:135:5122315130516584759889106140333677657695
175:136:1506563273681348458790913570686375781675
175:137:428875676449434962721500943480063178725
175:138:118096200761438612923311854001756527475
175:139:31435679339375745886061428763057492925
175:140:8083460401553763227844367396214783895
175:141:2006532723789941226769878431684520825
175:142:480437412738436631761801878008969775
175:143:110870172170408453483492741078993025
175:144:24637816037868545218553942461998450
175:145:5267395152923620012242567009116910
175:146:1082341469778826029912856234750050
175:147:213523147099224182771924019100350
175:148:40396271072826196740634273883850
175:149:7320129657491995382531042918550
175:150:1268822473965279199638714105882
175:151:210069946020741589344157964550
175:152:33168938845380250949077573350
175:153:4986180349305527920449569850
175:154:712311478472218274349938550
175:155:96506716438171508137733610
175:156:12372655953611731812529950
175:157:1497327790564477098331650
175:158:170581647026332833987150
175:159:18238289304702252690450
175:160:1823828930470225269045
175:161:169921950043809807675
175:162:14684612966748995725
175:163:1171165451335809475
175:164:85695033024571425
175:165:5713002201638095
175:166:344156759134825
175:167:18547370252775
175:168:883208107275
175:169:36582584325
175:170:1291150035
175:171:37752925
175:172:877975
175:173:15225
175:174:175
175:175:1

# binomial(176, k) for 0 <= k <= 176

176:0:1
176:1:176
176:2:15400
176:3:893200
176:4:38630900
176:5:1328902960
176:6:37873734360
176:7:919790691600
176:8:19430578360050
176:9:362704129387600
176:10:6057158960772920
176:11:91408035226209520
176:12:1256860484360380900
176:13:15855778418084805200
176:14:184606563010558803400
176:15:1993750880514035076720
176:16:20062118235172477959495
176:17:188819936331035086677600
176:18:1667909437590809932318800
176:19:13869983744176208910861600
176:20:108879372391783239950263560
176:21:808818194910389782487672160
176:22:5698491827777746194799508400
176:23:38155119194685778869527143200
176:24:243238884866121840293235537900
176:25:1478892419986020788982872070432
176:26:8588952131457274582169757024432
176:27:47716400730318192123165316802400
176:28:253919418172050379512558292984200
176:29:1295864616878050212684780253850400
176:30:6349736622702446042155423243866960
176:31:29905211190792165230796509471115360
176:32:135507988208276998702046683540991475
176:33:591307584908845085245294619087962800
176:34:2486970136528377858531680309693490600
176:35:10089993125343704454614245827899304720
176:36:39519139740929509113905796159272276820
176:37:149531880100814358809373282764814020400
176:38:546971877210873575644812797481819706200
176:39:1935438950130783421512414514166438960400
176:40:6628878404197933218680019711020053439370
176:41:21988474706607778481475187334115299213520
176:42:70677240128382145119027387859656318900600
176:43:220250004121004824324410929609161551922800
176:44:665755694274855491707878491773147418312100
176:45:1952883369872909442343110242534565760382160
176:46:5561472205507633411890161777652785100218760
176:47:15382795462042390288206830448826852404860400
176:48:41341262804238923899555856831222165838062325
176:49:107993502835562903247819381110131371985142400
176:50:274303497202329774249461228019733684842261696
176:51:677690993088108854028080680989930280198528896
176:52:1629064887231030899105963175456563173554156000
176:53:3811397094653732669606404410502147802277648000
176:54:8681515604489057747436810046143781105187976000
176:55:19257180068139364457950742284173478087871510400
176:56:41609264075801126775214996721160550868436656400
176:57:87598450685897109000452624676127475512498224000
176:58:179727855717616482259549350628606372172194632000
176:59:359455711435232964519098701257212744344389264000
176:60:700938637298704280812242467451564851471559064800
176:61:1332932490600814697938034856137402012634440188800
176:62:2472374780953124036497967878319374700854203576000
176:63:4473821032200891113662989494101725649164749328000
176:64:7899090259979698372561215825523359349306510532250
176:65:13610740140272711041951633422440249955728141224800
176:66:22890790235913195843282292574104056743724601150800
176:67:37581894417170918548672420644051436444920986964000
176:68:60241566051053384144195497797082449595535111457000
176:69:94291146862518340399610344378042095019098435324000
176:70:144130753061278034610832954977864345243479036852400
176:71:215181124288668615052792862361318599940968702906400
176:72:313805806254308396951989590943589624913912691738500
176:73:447065806170521551822012567919634534123930410148000
176:74:622267270750861078887395871563815635334659895206000
176:75:846283488221171067286858385326789264055137457480160
176:76:1124666214609714181525956538394812048283801094809160
176:77:1460605473519109326657086413499755906862079343908000
176:78:1853845408697331068449378909441997881786485321114000
176:79:2299706962687828414025811811712858131836399512268000
176:80:2788394692258991952006296821701840484851634408624950
176:81:3304764079714360832007462899794773907972307447259200
176:82:3828690092352003402935475310737847820211819603532000
176:83:4336106851579377347902827460353707169878446297976000
176:84:4800689728534310635178130402534461509508279829902000
176:85:5196040647354783275722211729802005398526608757070400
176:86:5498136033828898582450247295488168503092109266202400
176:87:5687726931547136464603704098780863968715975102968000
176:88:5752360192132899378974200736267010150178656638229000
176:89:5687726931547136464603704098780863968715975102968000
176:90:5498136033828898582450247295488168503092109266202400
176:91:5196040647354783275722211729802005398526608757070400
176:92:4800689728534310635178130402534461509508279829902000
176:93:4336106851579377347902827460353707169878446297976000
176:94:3828690092352003402935475310737847820211819603532000
176:95:3304764079714360832007462899794773907972307447259200
176:96:2788394692258991952006296821701840484851634408624950
176:97:2299706962687828414025811811712858131836399512268000
176:98:1853845408697331068449378909441997881786485321114000
176:99:1460605473519109326657086413499755906862079343908000
176:100:1124666214609714181525956538394812048283801094809160
176:101:846283488221171067286858385326789264055137457480160
176:102:622267270750861078887395871563815635334659895206000
176:103:447065806170521551822012567919634534123930410148000
176:104:313805806254308396951989590943589624913912691738500
176:105:215181124288668615052792862361318599940968702906400
176:106:144130753061278034610832954977864345243479036852400
176:107:94291146862518340399610344378042095019098435324000
176:108:60241566051053384144195497797082449595535111457000
176:109:37581894417170918548672420644051436444920986964000
176:110:22890790235913195843282292574104056743724601150800
176:111:13610740140272711041951633422440249955728141224800
176:112:7899090259979698372561215825523359349306510532250
176:113:4473821032200891113662989494101725649164749328000
176:114:2472374780953124036497967878319374700854203576000
176:115:1332932490600814697938034856137402012634440188800
176:116:700938637298704280812242467451564851471559064800
176:117:359455711435232964519098701257212744344389264000
176:118:179727855717616482259549350628606372172194632000
176:119:87598450685897109000452624676127475512498224000
176:120:41609264075801126775214996721160550868436656400
176:121:19257180068139364457950742284173478087871510400
176:122:8681515604489057747436810046143781105187976000
176:123:3811397094653732669606404410502147802277648000
176:124:1629064887231030899105963175456563173554156000
176:125:677690993088108854028080680989930280198528896
176:126:274303497202329774249461228019733684842261696
176:127:107993502835562903247819381110131371985142400
176:128:41341262804238923899555856831222165838062325
176:129:15382795462042390288206830448826852404860400
176:130:5561472205507633411890161777652785100218760
176:131:1952883369872909442343110242534565760382160
176:132:665755694274855491707878491773147418312100
176:133:220250004121004824324410929609161551922800
176:134:70677240128382145119027387859656318900600
176:135:21988474706607778481475187334115299213520
176:136:6628878404197933218680019711020053439370
176:137:1935438950130783421512414514166438960400
176:138:546971877210873575644812797481819706200
176:139:149531880100814358809373282764814020400
176:140:39519139740929509113905796159272276820
176:141:10089993125343704454614245827899304720
176:142:2486970136528377858531680309693490600
176:143:591307584908845085245294619087962800
176:144:135507988208276998702046683540991475
176:145:29905211190792165230796509471115360
176:146:6349736622702446042155423243866960
176:147:1295864616878050212684780253850400
176:148:253919418172050379512558292984200
176:149:47716400730318192123165316802400
176:150:8588952131457274582169757024432
176:151:1478892419986020788982872070432
176:152:243238884866121840293235537900
176:153:38155119194685778869527143200
176:154:5698491827777746194799508400
176:155:808818194910389782487672160
176:156:108879372391783239950263560
176:157:13869983744176208910861600
176:158:1667909437590809932318800
176:159:188819936331035086677600
176:160:20062118235172477959495
176:161:1993750880514035076720
176:162:184606563010558803400
176:163:15855778418084805200
176:164:1256860484360380900
176:165:91408035226209520
176:166:6057158960772920
176:167:362704129387600
176:168:19430578360050
176:169:919790691600
176:170:37873734360
176:171:1328902960
176:172:38630900
176:173:893200
176:174:15400
176:175:176
176:176:1

# binomial(177, k) for 0 <= k <= 177

177:0:1
177:1:177
177:2:15576
177:3:908600
177:4:39524100
177:5:1367533860
177:6:39202637320
177:7:957664425960
177:8:20350369051650
177:9:382134707747650
177:10:6419863090160520
177:11:97465194186982440
177:12:1348268519586590420
177:13:17112638902445186100
177:14:200462341428643608600
177:15:2178357443524593880120
177:16:22055869115686513036215
177:17:208882054566207564637095
177:18:1856729373921845018996400
177:19:15537893181767018843180400
177:20:122749356135959448861125160
177:21:917697567302173022437935720
177:22:6507310022688135977287180560
177:23:43853611022463525064326651600
177:24:281394004060807619162762681100
177:25:1722131304852142629276107608332
177:26:10067844551443295371152629094864
177:27:56305352861775466705335073826832
177:28:301635818902368571635723609786600
177:29:1549784035050100592197338546834600
177:30:7645601239580496254840203497717360
177:31:36254947813494611272951932714982320
177:32:165413199399069163932843193012106835
177:33:726815573117122083947341302628954275
177:34:3078277721437222943776974928781453400
177:35:12576963261872082313145926137592795320
177:36:49609132866273213568520041987171581540
177:37:189051019841743867923279078924086297220
177:38:696503757311687934454186080246633726600
177:39:2482410827341656997157227311648258666600
177:40:8564317354328716640192434225186492399770
177:41:28617353110805711700155207045135352652890
177:42:92665714834989923600502575193771618114120
177:43:290927244249386969443438317468817870823400
177:44:886005698395860316032289421382308970234900
177:45:2618639064147764934050988734307713178694260
177:46:7514355575380542854233272020187350860600920
177:47:20944267667550023700096992226479637505079160
177:48:56724058266281314187762687280049018242922725
177:49:149334765639801827147375237941353537823204725
177:50:382297000037892677497280609129865056827404096
177:51:951994490290438628277541909009663965040790592
177:52:2306755880319139753134043856446493453752684896
177:53:5440461981884763568712367585958710975831804000
177:54:12492912699142790417043214456645928907465624000
177:55:27938695672628422205387552330317259193059486400
177:56:60866444143940491233165739005334028956308166800
177:57:129207714761698235775667621397288026380934880400
177:58:267326306403513591260001975304733847684692856000
177:59:539183567152849446778648051885819116516583896000
177:60:1060394348733937245331341168708777595815948328800
177:61:2033871127899518978750277323588966864105999253600
177:62:3805307271553938734436002734456776713488643764800
177:63:6946195813154015150160957372421100350018952904000
177:64:12372911292180589486224205319625084998471259860250
177:65:21509830400252409414512849247963609305034651757050
177:66:36501530376185906885233925996544306699452742375600
177:67:60472684653084114391954713218155493188645588114800
177:68:97823460468224302692867918441133886040456098421000
177:69:154532712913571724543805842175124544614633546781000
177:70:238421899923796375010443299355906440262577472176400
177:71:359311877349946649663625817339182945184447739758800
177:72:528986930542977012004782453304908224854881394644900
177:73:760871612424829948774002158863224159037843101886500
177:74:1069333076921382630709408439483450169458590305354000
177:75:1468550758972032146174254256890604899389797352686160
177:76:1970949702830885248812814923721601312338938552289320
177:77:2585271688128823508183042951894567955145880438717160
177:78:3314450882216440395106465322941753788648564665022000
177:79:4153552371385159482475190721154856013622884833382000
177:80:5088101654946820366032108633414698616688033920892950
177:81:6093158771973352784013759721496614392823941855884150
177:82:7133454172066364234942938210532621728184127050791200
177:83:8164796943931380750838302771091554990090265901508000
177:84:9136796580113687983080957862888168679386726127878000
177:85:9996730375889093910900342132336466908034888586972400
177:86:10694176681183681858172459025290173901618718023272800
177:87:11185862965376035047053951394269032471808084369170400
177:88:11440087123680035843577904835047874118894631741197000
177:89:11440087123680035843577904835047874118894631741197000
177:90:11185862965376035047053951394269032471808084369170400
177:91:10694176681183681858172459025290173901618718023272800
177:92:9996730375889093910900342132336466908034888586972400
177:93:9136796580113687983080957862888168679386726127878000
177:94:8164796943931380750838302771091554990090265901508000
177:95:7133454172066364234942938210532621728184127050791200
177:96:6093158771973352784013759721496614392823941855884150
177:97:5088101654946820366032108633414698616688033920892950
177:98:4153552371385159482475190721154856013622884833382000
177:99:3314450882216440395106465322941753788648564665022000
177:100:2585271688128823508183042951894567955145880438717160
177:101:1970949702830885248812814923721601312338938552289320
177:102:1468550758972032146174254256890604899389797352686160
177:103:1069333076921382630709408439483450169458590305354000
177:104:760871612424829948774002158863224159037843101886500
177:105:528986930542977012004782453304908224854881394644900
177:106:359311877349946649663625817339182945184447739758800
177:107:238421899923796375010443299355906440262577472176400
177:108:154532712913571724543805842175124544614633546781000
177:109:97823460468224302692867918441133886040456098421000
177:110:60472684653084114391954713218155493188645588114800
177:111:36501530376185906885233925996544306699452742375600
177:112:21509830400252409414512849247963609305034651757050
177:113:12372911292180589486224205319625084998471259860250
177:114:6946195813154015150160957372421100350018952904000
177:115:3805307271553938734436002734456776713488643764800
177:116:2033871127899518978750277323588966864105999253600
177:117:1060394348733937245331341168708777595815948328800
177:118:539183567152849446778648051885819116516583896000
177:119:267326306403513591260001975304733847684692856000
177:120:129207714761698235775667621397288026380934880400
177:121:60866444143940491233165739005334028956308166800
177:122:27938695672628422205387552330317259193059486400
177:123:12492912699142790417043214456645928907465624000
177:124:5440461981884763568712367585958710975831804000
177:125:2306755880319139753134043856446493453752684896
177:126:951994490290438628277541909009663965040790592
177:127:382297000037892677497280609129865056827404096
177:128:149334765639801827147375237941353537823204725
177:129:56724058266281314187762687280049018242922725
177:130:20944267667550023700096992226479637505079160
177:131:7514355575380542854233272020187350860600920
177:132:2618639064147764934050988734307713178694260
177:133:886005698395860316032289421382308970234900
177:134:290927244249386969443438317468817870823400
177:135:92665714834989923600502575193771618114120
177:136:28617353110805711700155207045135352652890
177:137:8564317354328716640192434225186492399770
177:138:2482410827341656997157227311648258666600
177:139:696503757311687934454186080246633726600
177:140:189051019841743867923279078924086297220
177:141:49609132866273213568520041987171581540
177:142:12576963261872082313145926137592795320
177:143:3078277721437222943776974928781453400
177:144:726815573117122083947341302628954275
177:145:165413199399069163932843193012106835
177:146:36254947813494611272951932714982320
177:147:7645601239580496254840203497717360
177:148:1549784035050100592197338546834600
177:149:301635818902368571635723609786600
177:150:56305352861775466705335073826832
177:151:10067844551443295371152629094864
177:152:1722131304852142629276107608332
177:153:281394004060807619162762681100
177:154:43853611022463525064326651600
177:155:6507310022688135977287180560
177:156:917697567302173022437935720
177:157:122749356135959448861125160
177:158:15537893181767018843180400
177:159:1856729373921845018996400
177:160:208882054566207564637095
177:161:22055869115686513036215
177:162:2178357443524593880120
177:163:200462341428643608600
177:164:17112638902445186100
177:165:1348268519586590420
177:166:97465194186982440
177:167:6419863090160520
177:168:382134707747650
177:169:20350369051650
177:170:957664425960
177:171:39202637320
177:172:1367533860
177:173:39524100
177:174:908600
177:175:15576
177:176:177
177:177:1

# binomial(178, k) for 0 <= k <= 178

178:0:1
178:1:178
178:2:15753
178:3:924176
178:4:40432700
178:5:1407057960
178:6:40570171180
178:7:996867063280
178:8:21308033477610
178:9:402485076799300
178:10:6801997797908170
178:11:103885057277142960
178:12:1445733713773572860
178:13:18460907422031776520
178:14:217574980331088794700
178:15:2378819784953237488720
178:16:24234226559211106916335
178:17:230937923681894077673310
178:18:2065611428488052583633495
178:19:17394622555688863862176800
178:20:138287249317726467704305560
178:21:1040446923438132471299060880
178:22:7425007589990308999725116280
178:23:50360921045151661041613832160
178:24:325247615083271144227089332700
178:25:2003525308912950248438870289432
178:26:11789975856295438000428736703196
178:27:66373197413218762076487702921696
178:28:357941171764144038341058683613432
178:29:1851419853952469163833062156621200
178:30:9195385274630596847037542044551960
178:31:43900549053075107527792136212699680
178:32:201668147212563775205795125727089155
178:33:892228772516191247880184495641061110
178:34:3805093294554345027724316231410407675
178:35:15655240983309305256922901066374248720
178:36:62186096128145295881665968124764376860
178:37:238660152708017081491799120911257878760
178:38:885554777153431802377465159170720023820
178:39:3178914584653344931611413391894892393200
178:40:11046728181670373637349661536834751066370
178:41:37181670465134428340347641270321845052660
178:42:121283067945795635300657782238906970767010
178:43:383592959084376893043940892662589488937520
178:44:1176932942645247285475727738851126841058300
178:45:3504644762543625250083278155690022148929160
178:46:10132994639528307788284260754495064039295180
178:47:28458623242930566554330264246666988365680080
178:48:77668325933831337887859679506528655748001885
178:49:206058823906083141335137925221402556066127450
178:50:531631765677694504644655847071218594650608821
178:51:1334291490328331305774822518139529021868194688
178:52:3258750370609578381411585765456157418793475488
178:53:7747217862203903321846411442405204429584488896
178:54:17933374681027553985755582042604639883297428000
178:55:40431608371771212622430766786963188100525110400
178:56:88805139816568913438553291335651288149367653200
178:57:190074158905638727008833360402622055337243047200
178:58:396534021165211827035669596702021874065627736400
178:59:806509873556363038038650027190552964201276752000
178:60:1599577915886786692109989220594596712332532224800
178:61:3094265476633456224081618492297744459921947582400
178:62:5839178399453457713186280058045743577594643018400
178:63:10751503084707953884596960106877877063507596668800
178:64:19319107105334604636385162692046185348490212764250
178:65:33882741692432998900737054567588694303505911617300
178:66:58011360776438316299746775244507916004487394132650
178:67:96974215029270021277188639214699799888098330490400
178:68:158296145121308417084822631659289379229101686535800
178:69:252356173381796027236673760616258430655089645202000
178:70:392954612837368099554249141531030984877211018957400
178:71:597733777273743024674069116695089385447025211935200
178:72:888298807892923661668408270644091170039329134403700
178:73:1289858542967806960778784612168132383892724496531400
178:74:1830204689346212579483410598346674328496433407240500
178:75:2537883835893414776883662696374055068848387658040160
178:76:3439500461802917394987069180612206211728735904975480
178:77:4556221390959708756995857875616169267484818991006480
178:78:5899722570345263903289508274836321743794445103739160
178:79:7468003253601599877581656044096609802271449498404000
178:80:9241654026331979848507299354569554630310918754274950
178:81:11181260426920173150045868354911313009511975776777100
178:82:13226612944039717018956697932029236121008068906675350
178:83:15298251115997744985781240981624176718274392952299200
178:84:17301593524045068733919260633979723669476992029386000
178:85:19133526956002781893981299995224635587421614714850400
178:86:20690907057072775769072801157626640809653606610245200
178:87:21880039646559716905226410419559206373426802392443200
178:88:22625950089056070890631856229316906590702716110367400
178:89:22880174247360071687155809670095748237789263482394000
178:90:22625950089056070890631856229316906590702716110367400
178:91:21880039646559716905226410419559206373426802392443200
178:92:20690907057072775769072801157626640809653606610245200
178:93:19133526956002781893981299995224635587421614714850400
178:94:17301593524045068733919260633979723669476992029386000
178:95:15298251115997744985781240981624176718274392952299200
178:96:13226612944039717018956697932029236121008068906675350
178:97:11181260426920173150045868354911313009511975776777100
178:98:9241654026331979848507299354569554630310918754274950
178:99:7468003253601599877581656044096609802271449498404000
178:100:5899722570345263903289508274836321743794445103739160
178:101:4556221390959708756995857875616169267484818991006480
178:102:3439500461802917394987069180612206211728735904975480
178:103:2537883835893414776883662696374055068848387658040160
178:104:1830204689346212579483410598346674328496433407240500
178:105:1289858542967806960778784612168132383892724496531400
178:106:888298807892923661668408270644091170039329134403700
178:107:597733777273743024674069116695089385447025211935200
178:108:392954612837368099554249141531030984877211018957400
178:109:252356173381796027236673760616258430655089645202000
178:110:158296145121308417084822631659289379229101686535800
178:111:96974215029270021277188639214699799888098330490400
178:112:58011360776438316299746775244507916004487394132650
178:113:33882741692432998900737054567588694303505911617300
178:114:19319107105334604636385162692046185348490212764250
178:115:10751503084707953884596960106877877063507596668800
178:116:5839178399453457713186280058045743577594643018400
178:117:3094265476633456224081618492297744459921947582400
178:118:1599577915886786692109989220594596712332532224800
178:119:806509873556363038038650027190552964201276752000
178:120:396534021165211827035669596702021874065627736400
178:121:190074158905638727008833360402622055337243047200
178:122:88805139816568913438553291335651288149367653200
178:123:40431608371771212622430766786963188100525110400
178:124:17933374681027553985755582042604639883297428000
178:125:7747217862203903321846411442405204429584488896
178:126:3258750370609578381411585765456157418793475488
178:127:1334291490328331305774822518139529021868194688
178:128:531631765677694504644655847071218594650608821
178:129:206058823906083141335137925221402556066127450
178:130:77668325933831337887859679506528655748001885
178:131:28458623242930566554330264246666988365680080
178:132:10132994639528307788284260754495064039295180
178:133:3504644762543625250083278155690022148929160
178:134:1176932942645247285475727738851126841058300
178:135:383592959084376893043940892662589488937520
178:136:121283067945795635300657782238906970767010
178:137:37181670465134428340347641270321845052660
178:138:11046728181670373637349661536834751066370
178:139:3178914584653344931611413391894892393200
178:140:885554777153431802377465159170720023820
178:141:238660152708017081491799120911257878760
178:142:62186096128145295881665968124764376860
178:143:15655240983309305256922901066374248720
178:144:3805093294554345027724316231410407675
178:145:892228772516191247880184495641061110
178:146:201668147212563775205795125727089155
178:147:43900549053075107527792136212699680
178:148:9195385274630596847037542044551960
178:149:1851419853952469163833062156621200
178:150:357941171764144038341058683613432
178:151:66373197413218762076487702921696
178:152:11789975856295438000428736703196
178:153:2003525308912950248438870289432
178:154:325247615083271144227089332700
178:155:50360921045151661041613832160
178:156:7425007589990308999725116280
178:157:1040446923438132471299060880
178:158:138287249317726467704305560
178:159:17394622555688863862176800
178:160:2065611428488052583633495
178:161:230937923681894077673310
178:162:24234226559211106916335
178:163:2378819784953237488720
178:164:217574980331088794700
178:165:18460907422031776520
178:166:1445733713773572860
178:167:103885057277142960
178:168:6801997797908170
178:169:402485076799300
178:170:21308033477610
178:171:996867063280
178:172:40570171180
178:173:1407057960
178:174:40432700
178:175:924176
178:176:15753
178:177:178
178:178:1

# binomial(179, k) for 0 <= k <= 179

179:0:1
179:1:179
179:2:15931
179:3:939929
179:4:41356876
179:5:1447490660
179:6:41977229140
179:7:1037437234460
179:8:22304900540890
179:9:423793110276910
179:10:7204482874707470
179:11:110687055075051130
179:12:1549618771050715820
179:13:19906641135805349380
179:14:236035887753120571220
179:15:2596394765284326283420
179:16:26613046344164344405055
179:17:255172150241105184589645
179:18:2296549352169946661306805
179:19:19460233984176916445810295
179:20:155681871873415331566482360
179:21:1178734172755858939003366440
179:22:8465454513428441471024177160
179:23:57785928635141970041338948440
179:24:375608536128422805268703164860
179:25:2328772923996221392665959622132
179:26:13793501165208388248867606992628
179:27:78163173269514200076916439624892
179:28:424314369177362800417546386535128
179:29:2209361025716613202174120840234632
179:30:11046805128583066010870604201173160
179:31:53095934327705704374829678257251640
179:32:245568696265638882733587261939788835
179:33:1093896919728755023085979621368150265
179:34:4697322067070536275604500727051468785
179:35:19460334277863650284647217297784656395
179:36:77841337111454601138588869191138625580
179:37:300846248836162377373465089036022255620
179:38:1124214929861448883869264280081977902580
179:39:4064469361806776733988878551065612417020
179:40:14225642766323718568961074928729643459570
179:41:48228398646804801977697302807156596119030
179:42:158464738410930063641005423509228815819670
179:43:504876027030172528344598674901496459704530
179:44:1560525901729624178519668631513716329995820
179:45:4681577705188872535559005894541148989987460
179:46:13637639402071933038367538910185086188224340
179:47:38591617882458874342614525001162052404975260
179:48:106126949176761904442189943753195644113681965
179:49:283727149839914479222997604727931211814129335
179:50:737690589583777645979793772292621150716736271
179:51:1865923256006025810419478365210747616518803509
179:52:4593041860937909687186408283595686440661670176
179:53:11005968232813481703257997207861361848377964384
179:54:25680592543231457307601993485009844312881916896
179:55:58364983052798766608186348829567827983822538400
179:56:129236748188340126060984058122614476249892763600
179:57:278879298722207640447386651738273343486610700400
179:58:586608180070850554044502957104643929402870783600
179:59:1203043894721574865074319623892574838266904488400
179:60:2406087789443149730148639247785149676533808976800
179:61:4693843392520242916191607712892341172254479807200
179:62:8933443876086913937267898550343488037516590600800
179:63:16590681484161411597783240164923620641102239687200
179:64:30070610190042558520982122798924062411997809433050
179:65:53201848797767603537122217259634879651996124381550
179:66:91894102468871315200483829812096610307993305749950
179:67:154985575805708337576935414459207715892585724623050
179:68:255270360150578438362011270873989179117200017026200
179:69:410652318503104444321496392275547809884191331737800
179:70:645310786219164126790922902147289415532300664159400
179:71:990688390111111124228318258226120370324236230892600
179:72:1486032585166666686342477387339180555486354346338900
179:73:2178157350860730622447192882812223553932053630935100
179:74:3120063232314019540262195210514806712389157903771900
179:75:4368088525239627356367073294720729397344821065280660
179:76:5977384297696332171870731876986261280577123563015640
179:77:7995721852762626151982927056228375479213554895981960
179:78:10455943961304972660285366150452491011279264094745640
179:79:13367725823946863780871164318932931546065894602143160
179:80:16709657279933579726088955398666164432582368252678950
179:81:20422914453252152998553167709480867639822894531052050
179:82:24407873370959890169002566286940549130520044683452450
179:83:28524864060037462004737938913653412839282461858974550
179:84:32599844640042813719700501615603900387751384981685200
179:85:36435120480047850627900560629204359256898606744236400
179:86:39824434013075557663054101152851276397075221325095600
179:87:42570946703632492674299211577185847183080409002688400
179:88:44505989735615787795858266648876112964129518502810600
179:89:45506124336416142577787665899412654828491979592761400
179:90:45506124336416142577787665899412654828491979592761400
179:91:44505989735615787795858266648876112964129518502810600
179:92:42570946703632492674299211577185847183080409002688400
179:93:39824434013075557663054101152851276397075221325095600
179:94:36435120480047850627900560629204359256898606744236400
179:95:32599844640042813719700501615603900387751384981685200
179:96:28524864060037462004737938913653412839282461858974550
179:97:24407873370959890169002566286940549130520044683452450
179:98:20422914453252152998553167709480867639822894531052050
179:99:16709657279933579726088955398666164432582368252678950
179:100:13367725823946863780871164318932931546065894602143160
179:101:10455943961304972660285366150452491011279264094745640
179:102:7995721852762626151982927056228375479213554895981960
179:103:5977384297696332171870731876986261280577123563015640
179:104:4368088525239627356367073294720729397344821065280660
179:105:3120063232314019540262195210514806712389157903771900
179:106:2178157350860730622447192882812223553932053630935100
179:107:1486032585166666686342477387339180555486354346338900
179:108:990688390111111124228318258226120370324236230892600
179:109:645310786219164126790922902147289415532300664159400
179:110:410652318503104444321496392275547809884191331737800
179:111:255270360150578438362011270873989179117200017026200
179:112:154985575805708337576935414459207715892585724623050
179:113:91894102468871315200483829812096610307993305749950
179:114:53201848797767603537122217259634879651996124381550
179:115:30070610190042558520982122798924062411997809433050
179:116:16590681484161411597783240164923620641102239687200
179:117:8933443876086913937267898550343488037516590600800
179:118:4693843392520242916191607712892341172254479807200
179:119:2406087789443149730148639247785149676533808976800
179:120:1203043894721574865074319623892574838266904488400
179:121:586608180070850554044502957104643929402870783600
179:122:278879298722207640447386651738273343486610700400
179:123:129236748188340126060984058122614476249892763600
179:124:58364983052798766608186348829567827983822538400
179:125:25680592543231457307601993485009844312881916896
179:126:11005968232813481703257997207861361848377964384
179:127:4593041860937909687186408283595686440661670176
179:128:1865923256006025810419478365210747616518803509
179:129:737690589583777645979793772292621150716736271
179:130:283727149839914479222997604727931211814129335
179:131:106126949176761904442189943753195644113681965
179:132:38591617882458874342614525001162052404975260
179:133:13637639402071933038367538910185086188224340
179:134:4681577705188872535559005894541148989987460
179:135:1560525901729624178519668631513716329995820
179:136:504876027030172528344598674901496459704530
179:137:158464738410930063641005423509228815819670
179:138:48228398646804801977697302807156596119030
179:139:14225642766323718568961074928729643459570
179:140:4064469361806776733988878551065612417020
179:141:1124214929861448883869264280081977902580
179:142:300846248836162377373465089036022255620
179:143:77841337111454601138588869191138625580
179:144:19460334277863650284647217297784656395
179:145:4697322067070536275604500727051468785
179:146:1093896919728755023085979621368150265
179:147:245568696265638882733587261939788835
179:148:53095934327705704374829678257251640
179:149:11046805128583066010870604201173160
179:150:2209361025716613202174120840234632
179:151:424314369177362800417546386535128
179:152:78163173269514200076916439624892
179:153:13793501165208388248867606992628
179:154:2328772923996221392665959622132
179:155:375608536128422805268703164860
179:156:57785928635141970041338948440
179:157:8465454513428441471024177160
179:158:1178734172755858939003366440
179:159:155681871873415331566482360
179:160:19460233984176916445810295
179:161:2296549352169946661306805
179:162:255172150241105184589645
179:163:26613046344164344405055
179:164:2596394765284326283420
179:165:236035887753120571220
179:166:19906641135805349380
179:167:1549618771050715820
179:168:110687055075051130
179:169:7204482874707470
179:170:423793110276910
179:171:22304900540890
179:172:1037437234460
179:173:41977229140
179:174:1447490660
179:175:41356876
179:176:939929
179:177:15931
179:178:179
179:179:1

# binomial(180, k) for 0 <= k <= 180

180:0:1
180:1:180
180:2:16110
180:3:955860
180:4:42296805
180:5:1488847536
180:6:43424719800
180:7:1079414463600
180:8:23342337775350
180:9:446098010817800
180:10:7628275984984380
180:11:117891537949758600
180:12:1660305826125766950
180:13:21456259906856065200
180:14:255942528888925920600
180:15:2832430653037446854640
180:16:29209441109448670688475
180:17:281785196585269528994700
180:18:2551721502411051845896450
180:19:21756783336346863107117100
180:20:175142105857592248012292655
180:21:1334416044629274270569848800
180:22:9644188686184300410027543600
180:23:66251383148570411512363125600
180:24:433394464763564775310042113300
180:25:2704381460124644197934662786992
180:26:16122274089204609641533566614760
180:27:91956674434722588325784046617520
180:28:502477542446877000494462826160020
180:29:2633675394893976002591667226769760
180:30:13256166154299679213044725041407792
180:31:64142739456288770385700282458424800
180:32:298664630593344587108416940197040475
180:33:1339465615994393905819566883307939100
180:34:5791218986799291298690480348419619050
180:35:24157656344934186560251718024836125180
180:36:97301671389318251423236086488923281975
180:37:378687585947616978512053958227160881200
180:38:1425061178697611261242729369118000158200
180:39:5188684291668225617858142831147590319600
180:40:18290112128130495302949953479795255876590
180:41:62454041413128520546658377735886239578600
180:42:206693137057734865618702726316385411938700
180:43:663340765441102591985604098410725275524200
180:44:2065401928759796706864267306415212789700350
180:45:6242103606918496714078674526054865319983280
180:46:18319217107260805573926544804726235178211800
180:47:52229257284530807380982063911347138593199600
180:48:144718567059220778784804468754357696518657225
180:49:389854099016676383665187548481126855927811300
180:50:1021417739423692125202791377020552362530865606
180:51:2603613845589803456399272137503368767235539780
180:52:6458965116943935497605886648806434057180473685
180:53:15599010093751391390444405491457048289039634560
180:54:36686560776044939010859990692871206161259881280
180:55:84045575596030223915788342314577672296704455296
180:56:187601731241138892669170406952182304233715302000
180:57:408116046910547766508370709860887819736503464000
180:58:865487478793058194491889608842917272889481484000
180:59:1789652074792425419118822580997218767669775272000
180:60:3609131684164724595222958871677724514800713465200
180:61:7099931181963392646340246960677490848788288784000
180:62:13627287268607156853459506263235829209771070408000
180:63:25524125360248325535051138715267108678618830288000
180:64:46661291674203970118765362963847683053100049120250
180:65:83272458987810162058104340058558942063993933814600
180:66:145095951266638918737606047071731489959989430131500
180:67:246879678274579652777419244271304326200579030373000
180:68:410255935956286775938946685333196895009785741649250
180:69:665922678653682882683507663149536989001391348764000
180:70:1055963104722268571112419294422837225416491995897200
180:71:1635999176330275251019241160373409785856536895052000
180:72:2476720975277777810570795645565300925810590577231500
180:73:3664189936027397308789670270151404109418407977274000
180:74:5298220583174750162709388093327030266321211534707000
180:75:7488151757553646896629268505235536109733978969052560
180:76:10345472822935959528237805171706990677921944628296300
180:77:13973106150458958323853658933214636759790678458997600
180:78:18451665814067598812268293206680866490492818990727600
180:79:23823669785251836441156530469385422557345158696888800
180:80:30077383103880443506960119717599095978648262854822110
180:81:37132571733185732724642123108147032072405262783731000
180:82:44830787824212043167555733996421416770342939214504500
180:83:52932737430997352173740505200593961969802506542427000
180:84:61124708700080275724438440529257313227033846840659750
180:85:69034965120090664347601062244808259644649991725921600
180:86:76259554493123408290954661782055635653973828069332000
180:87:82395380716708050337353312730037123580155630327784000
180:88:87076936439248280470157478226061960147209927505499000
180:89:90012114072031930373645932548288767792621498095572000
180:90:91012248672832285155575331798825309656983959185522800
180:91:90012114072031930373645932548288767792621498095572000
180:92:87076936439248280470157478226061960147209927505499000
180:93:82395380716708050337353312730037123580155630327784000
180:94:76259554493123408290954661782055635653973828069332000
180:95:69034965120090664347601062244808259644649991725921600
180:96:61124708700080275724438440529257313227033846840659750
180:97:52932737430997352173740505200593961969802506542427000
180:98:44830787824212043167555733996421416770342939214504500
180:99:37132571733185732724642123108147032072405262783731000
180:100:30077383103880443506960119717599095978648262854822110
180:101:23823669785251836441156530469385422557345158696888800
180:102:18451665814067598812268293206680866490492818990727600
180:103:13973106150458958323853658933214636759790678458997600
180:104:10345472822935959528237805171706990677921944628296300
180:105:7488151757553646896629268505235536109733978969052560
180:106:5298220583174750162709388093327030266321211534707000
180:107:3664189936027397308789670270151404109418407977274000
180:108:2476720975277777810570795645565300925810590577231500
180:109:1635999176330275251019241160373409785856536895052000
180:110:1055963104722268571112419294422837225416491995897200
180:111:665922678653682882683507663149536989001391348764000
180:112:410255935956286775938946685333196895009785741649250
180:113:246879678274579652777419244271304326200579030373000
180:114:145095951266638918737606047071731489959989430131500
180:115:83272458987810162058104340058558942063993933814600
180:116:46661291674203970118765362963847683053100049120250
180:117:25524125360248325535051138715267108678618830288000
180:118:13627287268607156853459506263235829209771070408000
180:119:7099931181963392646340246960677490848788288784000
180:120:3609131684164724595222958871677724514800713465200
180:121:1789652074792425419118822580997218767669775272000
180:122:865487478793058194491889608842917272889481484000
180:123:408116046910547766508370709860887819736503464000
180:124:187601731241138892669170406952182304233715302000
180:125:84045575596030223915788342314577672296704455296
180:126:36686560776044939010859990692871206161259881280
180:127:15599010093751391390444405491457048289039634560
180:128:6458965116943935497605886648806434057180473685
180:129:2603613845589803456399272137503368767235539780
180:130:1021417739423692125202791377020552362530865606
180:131:389854099016676383665187548481126855927811300
180:132:144718567059220778784804468754357696518657225
180:133:52229257284530807380982063911347138593199600
180:134:18319217107260805573926544804726235178211800
180:135:6242103606918496714078674526054865319983280
180:136:2065401928759796706864267306415212789700350
180:137:663340765441102591985604098410725275524200
180:138:206693137057734865618702726316385411938700
180:139:62454041413128520546658377735886239578600
180:140:18290112128130495302949953479795255876590
180:141:5188684291668225617858142831147590319600
180:142:1425061178697611261242729369118000158200
180:143:378687585947616978512053958227160881200
180:144:97301671389318251423236086488923281975
180:145:24157656344934186560251718024836125180
180:146:5791218986799291298690480348419619050
180:147:1339465615994393905819566883307939100
180:148:298664630593344587108416940197040475
180:149:64142739456288770385700282458424800
180:150:13256166154299679213044725041407792
180:151:2633675394893976002591667226769760
180:152:502477542446877000494462826160020
180:153:91956674434722588325784046617520
180:154:16122274089204609641533566614760
180:155:2704381460124644197934662786992
180:156:433394464763564775310042113300
180:157:66251383148570411512363125600
180:158:9644188686184300410027543600
180:159:1334416044629274270569848800
180:160:175142105857592248012292655
180:161:21756783336346863107117100
180:162:2551721502411051845896450
180:163:281785196585269528994700
180:164:29209441109448670688475
180:165:2832430653037446854640
180:166:255942528888925920600
180:167:21456259906856065200
180:168:1660305826125766950
180:169:117891537949758600
180:170:7628275984984380
180:171:446098010817800
180:172:23342337775350
180:173:1079414463600
180:174:43424719800
180:175:1488847536
180:176:42296805
180:177:955860
180:178:16110
180:179:180
180:180:1

# binomial(181, k) for 0 <= k <= 181

181:0:1
181:1:181
181:2:16290
181:3:971970
181:4:43252665
181:5:1531144341
181:6:44913567336
181:7:1122839183400
181:8:24421752238950
181:9:469440348593150
181:10:8074373995802180
181:11:125519813934742980
181:12:1778197364075525550
181:13:23116565732981832150
181:14:277398788795781985800
181:15:3088373181926372775240
181:16:32041871762486117543115
181:17:310994637694718199683175
181:18:2833506698996321374891150
181:19:24308504838757914953013550
181:20:196898889193939111119409755
181:21:1509558150486866518582141455
181:22:10978604730813574680597392400
181:23:75895571834754711922390669200
181:24:499645847912135186822405238900
181:25:3137775924888208973244704900292
181:26:18826655549329253839468229401752
181:27:108078948523927197967317613232280
181:28:594434216881599588820246872777540
181:29:3136152937340853003086130052929780
181:30:15889841549193655215636392268177552
181:31:77398905610588449598745007499832592
181:32:362807370049633357494117222655465275
181:33:1638130246587738492927983823504979575
181:34:7130684602793685204510047231727558150
181:35:29948875331733477858942198373255744230
181:36:121459327734252437983487804513759407155
181:37:475989257336935229935290044716084163175
181:38:1803748764645228239754783327345161039400
181:39:6613745470365836879100872200265590477800
181:40:23478796419798720920808096310942846196190
181:41:80744153541259015849608331215681495455190
181:42:269147178470863386165361104052271651517300
181:43:870033902498837457604306824727110687462900
181:44:2728742694200899298849871404825938065224550
181:45:8307505535678293420942941832470078109683630
181:46:24561320714179302288005219330781100498195080
181:47:70548474391791612954908608716073373771411400
181:48:196947824343751586165786532665704835111856825
181:49:534572666075897162449992017235484552446468525
181:50:1411271838440368508867978925501679218458676906
181:51:3625031585013495581602063514523921129766405386
181:52:9062578962533738954005158786309802824416013465
181:53:22057975210695326888050292140263482346220108245
181:54:52285570869796330401304396184328254450299515840
181:55:120732136372075162926648333007448878457964336576
181:56:271647306837169116584958749266759976530419757296
181:57:595717778151686659177541116813070123970218766000
181:58:1273603525703605961000260318703805092625984948000
181:59:2655139553585483613610712189840136040559256756000
181:60:5398783758957150014341781452674943282470488737200
181:61:10709062866128117241563205832355215363589002249200
181:62:20727218450570549499799753223913320058559359192000
181:63:39151412628855482388510644978502937888389900696000
181:64:72185417034452295653816501679114791731718879408250
181:65:129933750662014132176869703022406625117093982934850
181:66:228368410254449080795710387130290432023983363946100
181:67:391975629541218571515025291343035816160568460504500
181:68:657135614230866428716365929604501221210364772022250
181:69:1076178614609969658622454348482733884011177090413250
181:70:1721885783375951453795926957572374214417883344661200
181:71:2691962281052543822131660454796247011273028890949200
181:72:4112720151608053061590036805938710711667127472283500
181:73:6140910911305175119360465915716705035228998554505500
181:74:8962410519202147471499058363478434375739619511981000
181:75:12786372340728397059338656598562566376055190503759560
181:76:17833624580489606424867073676942526787655923597348860
181:77:24318578973394917852091464104921627437712623087293900
181:78:32424771964526557136121952139895503250283497449725200
181:79:42275335599319435253424823676066289047837977687616400
181:80:53901052889132279948116650186984518535993421551710910
181:81:67209954837066176231602242825746128051053525638553110
181:82:81963359557397775892197857104568448842748201998235500
181:83:97763525255209395341296239197015378740145445756931500
181:84:114057446131077627898178945729851275196836353383086750
181:85:130159673820170940072039502774065572871683838566581350
181:86:145294519613214072638555724026863895298623819795253600
181:87:158654935209831458628307974512092759234129458397116000
181:88:169472317155956330807510790956099083727365557833283000
181:89:177089050511280210843803410774350727939831425601071000
181:90:181024362744864215529221264347114077449605457281094800
181:91:181024362744864215529221264347114077449605457281094800
181:92:177089050511280210843803410774350727939831425601071000
181:93:169472317155956330807510790956099083727365557833283000
181:94:158654935209831458628307974512092759234129458397116000
181:95:145294519613214072638555724026863895298623819795253600
181:96:130159673820170940072039502774065572871683838566581350
181:97:114057446131077627898178945729851275196836353383086750
181:98:97763525255209395341296239197015378740145445756931500
181:99:81963359557397775892197857104568448842748201998235500
181:100:67209954837066176231602242825746128051053525638553110
181:101:53901052889132279948116650186984518535993421551710910
181:102:42275335599319435253424823676066289047837977687616400
181:103:32424771964526557136121952139895503250283497449725200
181:104:24318578973394917852091464104921627437712623087293900
181:105:17833624580489606424867073676942526787655923597348860
181:106:12786372340728397059338656598562566376055190503759560
181:107:8962410519202147471499058363478434375739619511981000
181:108:6140910911305175119360465915716705035228998554505500
181:109:4112720151608053061590036805938710711667127472283500
181:110:2691962281052543822131660454796247011273028890949200
181:111:1721885783375951453795926957572374214417883344661200
181:112:1076178614609969658622454348482733884011177090413250
181:113:657135614230866428716365929604501221210364772022250
181:114:391975629541218571515025291343035816160568460504500
181:115:228368410254449080795710387130290432023983363946100
181:116:129933750662014132176869703022406625117093982934850
181:117:72185417034452295653816501679114791731718879408250
181:118:39151412628855482388510644978502937888389900696000
181:119:20727218450570549499799753223913320058559359192000
181:120:10709062866128117241563205832355215363589002249200
181:121:5398783758957150014341781452674943282470488737200
181:122:2655139553585483613610712189840136040559256756000
181:123:1273603525703605961000260318703805092625984948000
181:124:595717778151686659177541116813070123970218766000
181:125:271647306837169116584958749266759976530419757296
181:126:120732136372075162926648333007448878457964336576
181:127:52285570869796330401304396184328254450299515840
181:128:22057975210695326888050292140263482346220108245
181:129:9062578962533738954005158786309802824416013465
181:130:3625031585013495581602063514523921129766405386
181:131:1411271838440368508867978925501679218458676906
181:132:534572666075897162449992017235484552446468525
181:133:196947824343751586165786532665704835111856825
181:134:70548474391791612954908608716073373771411400
181:135:24561320714179302288005219330781100498195080
181:136:8307505535678293420942941832470078109683630
181:137:2728742694200899298849871404825938065224550
181:138:870033902498837457604306824727110687462900
181:139:269147178470863386165361104052271651517300
181:140:80744153541259015849608331215681495455190
181:141:23478796419798720920808096310942846196190
181:142:6613745470365836879100872200265590477800
181:143:1803748764645228239754783327345161039400
181:144:475989257336935229935290044716084163175
181:145:121459327734252437983487804513759407155
181:146:29948875331733477858942198373255744230
181:147:7130684602793685204510047231727558150
181:148:1638130246587738492927983823504979575
181:149:362807370049633357494117222655465275
181:150:77398905610588449598745007499832592
181:151:15889841549193655215636392268177552
181:152:3136152937340853003086130052929780
181:153:594434216881599588820246872777540
181:154:108078948523927197967317613232280
181:155:18826655549329253839468229401752
181:156:3137775924888208973244704900292
181:157:499645847912135186822405238900
181:158:75895571834754711922390669200
181:159:10978604730813574680597392400
181:160:1509558150486866518582141455
181:161:196898889193939111119409755
181:162:24308504838757914953013550
181:163:2833506698996321374891150
181:164:310994637694718199683175
181:165:32041871762486117543115
181:166:3088373181926372775240
181:167:277398788795781985800
181:168:23116565732981832150
181:169:1778197364075525550
181:170:125519813934742980
181:171:8074373995802180
181:172:469440348593150
181:173:24421752238950
181:174:1122839183400
181:175:44913567336
181:176:1531144341
181:177:43252665
181:178:971970
181:179:16290
181:180:181
181:181:1

# binomial(182, k) for 0 <= k <= 182

182:0:1
182:1:182
182:2:16471
182:3:988260
182:4:44224635
182:5:1574397006
182:6:46444711677
182:7:1167752750736
182:8:25544591422350
182:9:493862100832100
182:10:8543814344395330
182:11:133594187930545160
182:12:1903717178010268530
182:13:24894763097057357700
182:14:300515354528763817950
182:15:3365771970722154761040
182:16:35130244944412490318355
182:17:343036509457204317226290
182:18:3144501336691039574574325
182:19:27142011537754236327904700
182:20:221207394032697026072423305
182:21:1706457039680805629701551210
182:22:12488162881300441199179533855
182:23:86874176565568286602988061600
182:24:575541419746889898744795908100
182:25:3637421772800344160067110139192
182:26:21964431474217462812712934302044
182:27:126905604073256451806785842634032
182:28:702513165405526786787564486009820
182:29:3730587154222452591906376925707320
182:30:19025994486534508218722522321107332
182:31:93288747159782104814381399768010144
182:32:440206275660221807092862230155297867
182:33:2000937616637371850422101046160444850
182:34:8768814849381423697438031055232537725
182:35:37079559934527163063452245604983302380
182:36:151408203065985915842430002887015151385
182:37:597448585071187667918777849229843570330
182:38:2279738021982163469690073372061245202575
182:39:8417494235011065118855655527610751517200
182:40:30092541890164557799908968511208436673990
182:41:104222949961057736770416427526624341651380
182:42:349891332012122402014969435267953146972490
182:43:1139181080969700843769667928779382338980200
182:44:3598776596699736756454178229553048752687450
182:45:11036248229879192719792813237296016174908180
182:46:32868826249857595708948161163251178607878710
182:47:95109795105970915242913828046854474269606480
182:48:267496298735543199120695141381778208883268225
182:49:731520490419648748615778549901189387558325350
182:50:1945844504516265671317970942737163770905145431
182:51:5036303423453864090470042440025600348225082292
182:52:12687610547547234535607222300833723954182418851
182:53:31120554173229065842055450926573285170636121710
182:54:74343546080491657289354688324591736796519624085
182:55:173017707241871493327952729191777132908263852416
182:56:392379443209244279511607082274208854988384093872
182:57:867365084988855775762499866079830100500638523296
182:58:1869321303855292620177801435516875216596203714000
182:59:3928743079289089574610972508543941133185241704000
182:60:8053923312542633627952493642515079323029745493200
182:61:16107846625085267255904987285030158646059490986400
182:62:31436281316698666741362959056268535422148361441200
182:63:59878631079426031888310398202416257946949259888000
182:64:111336829663307778042327146657617729620108780104250
182:65:202119167696466427830686204701521416848812862343100
182:66:358302160916463212972580090152697057141077346880950
182:67:620344039795667652310735678473326248184551824450600
182:68:1049111243772085000231391220947537037370933232526750
182:69:1733314228840836087338820278087235105221541862435500
182:70:2798064397985921112418381306055108098429060435074450
182:71:4413848064428495275927587412368621225690912235610400
182:72:6804682432660596883721697260734957722940156363232700
182:73:10253631062913228180950502721655415746896126026789000
182:74:15103321430507322590859524279195139410968618066486500
182:75:21748782859930544530837714962041000751794810015740560
182:76:30619996921218003484205730275505093163711114101108420
182:77:42152203553884524276958537781864154225368546684642760
182:78:56743350937921474988213416244817130687996120537019100
182:79:74700107563845992389546775815961792298121475137341600
182:80:96176388488451715201541473863050807583831399239327310
182:81:121111007726198456179718893012730646587046947190264020
182:82:149173314394463952123800099930314576893801727636788610
182:83:179726884812607171233494096301583827582893647755167000
182:84:211820971386287023239475184926866653936981799140018250
182:85:244217119951248567970218448503916848068520191949668100
182:86:275454193433385012710595226800929468170307658361834950
182:87:303949454823045531266863698538956654532753278192369600
182:88:328127252365787789435818765468191842961495016230399000
182:89:346561367667236541651314201730449811667196983434354000
182:90:358113413256144426373024675121464805389436882882165800
182:91:362048725489728431058442528694228154899210914562189600
182:92:358113413256144426373024675121464805389436882882165800
182:93:346561367667236541651314201730449811667196983434354000
182:94:328127252365787789435818765468191842961495016230399000
182:95:303949454823045531266863698538956654532753278192369600
182:96:275454193433385012710595226800929468170307658361834950
182:97:244217119951248567970218448503916848068520191949668100
182:98:211820971386287023239475184926866653936981799140018250
182:99:179726884812607171233494096301583827582893647755167000
182:100:149173314394463952123800099930314576893801727636788610
182:101:121111007726198456179718893012730646587046947190264020
182:102:96176388488451715201541473863050807583831399239327310
182:103:74700107563845992389546775815961792298121475137341600
182:104:56743350937921474988213416244817130687996120537019100
182:105:42152203553884524276958537781864154225368546684642760
182:106:30619996921218003484205730275505093163711114101108420
182:107:21748782859930544530837714962041000751794810015740560
182:108:15103321430507322590859524279195139410968618066486500
182:109:10253631062913228180950502721655415746896126026789000
182:110:6804682432660596883721697260734957722940156363232700
182:111:4413848064428495275927587412368621225690912235610400
182:112:2798064397985921112418381306055108098429060435074450
182:113:1733314228840836087338820278087235105221541862435500
182:114:1049111243772085000231391220947537037370933232526750
182:115:620344039795667652310735678473326248184551824450600
182:116:358302160916463212972580090152697057141077346880950
182:117:202119167696466427830686204701521416848812862343100
182:118:111336829663307778042327146657617729620108780104250
182:119:59878631079426031888310398202416257946949259888000
182:120:31436281316698666741362959056268535422148361441200
182:121:16107846625085267255904987285030158646059490986400
182:122:8053923312542633627952493642515079323029745493200
182:123:3928743079289089574610972508543941133185241704000
182:124:1869321303855292620177801435516875216596203714000
182:125:867365084988855775762499866079830100500638523296
182:126:392379443209244279511607082274208854988384093872
182:127:173017707241871493327952729191777132908263852416
182:128:74343546080491657289354688324591736796519624085
182:129:31120554173229065842055450926573285170636121710
182:130:12687610547547234535607222300833723954182418851
182:131:5036303423453864090470042440025600348225082292
182:132:1945844504516265671317970942737163770905145431
182:133:731520490419648748615778549901189387558325350
182:134:267496298735543199120695141381778208883268225
182:135:95109795105970915242913828046854474269606480
182:136:32868826249857595708948161163251178607878710
182:137:11036248229879192719792813237296016174908180
182:138:3598776596699736756454178229553048752687450
182:139:1139181080969700843769667928779382338980200
182:140:349891332012122402014969435267953146972490
182:141:104222949961057736770416427526624341651380
182:142:30092541890164557799908968511208436673990
182:143:8417494235011065118855655527610751517200
182:144:2279738021982163469690073372061245202575
182:145:597448585071187667918777849229843570330
182:146:151408203065985915842430002887015151385
182:147:37079559934527163063452245604983302380
182:148:8768814849381423697438031055232537725
182:149:2000937616637371850422101046160444850
182:150:440206275660221807092862230155297867
182:151:93288747159782104814381399768010144
182:152:19025994486534508218722522321107332
182:153:3730587154222452591906376925707320
182:154:702513165405526786787564486009820
182:155:126905604073256451806785842634032
182:156:21964431474217462812712934302044
182:157:3637421772800344160067110139192
182:158:575541419746889898744795908100
182:159:86874176565568286602988061600
182:160:12488162881300441199179533855
182:161:1706457039680805629701551210
182:162:221207394032697026072423305
182:163:27142011537754236327904700
182:164:3144501336691039574574325
182:165:343036509457204317226290
182:166:35130244944412490318355
182:167:3365771970722154761040
182:168:300515354528763817950
182:169:24894763097057357700
182:170:1903717178010268530
182:171:133594187930545160
182:172:8543814344395330
182:173:493862100832100
182:174:25544591422350
182:175:1167752750736
182:176:46444711677
182:177:1574397006
182:178:44224635
182:179:988260
182:180:16471
182:181:182
182:182:1

# binomial(183, k) for 0 <= k <= 183

183:0:1
183:1:183
183:2:16653
183:3:1004731
183:4:45212895
183:5:1618621641
183:6:48019108683
183:7:1214197462413
183:8:26712344173086
183:9:519406692254450
183:10:9037676445227430
183:11:142138002274940490
183:12:2037311365940813690
183:13:26798480275067626230
183:14:325410117625821175650
183:15:3666287325250918578990
183:16:38496016915134645079395
183:17:378166754401616807544645
183:18:3487537846148243891800615
183:19:30286512874445275902479025
183:20:248349405570451262400328005
183:21:1927664433713502655773974515
183:22:14194619920981246828881085065
183:23:99362339446868727802167595455
183:24:662415596312458185347783969700
183:25:4212963192547234058811906047292
183:26:25601853247017806972780044441236
183:27:148870035547473914619498776936076
183:28:829418769478783238594350328643852
183:29:4433100319627979378693941411717140
183:30:22756581640756960810628899246814652
183:31:112314741646316613033103922089117476
183:32:533495022820003911907243629923308011
183:33:2441143892297593657514963276315742717
183:34:10769752466018795547860132101392982575
183:35:45848374783908586760890276660215840105
183:36:188487763000513078905882248491998453765
183:37:748856788137173583761207852116858721715
183:38:2877186607053351137608851221291088772905
183:39:10697232256993228588545728899671996719775
183:40:38510036125175622918764624038819188191190
183:41:134315491851222294570325396037832778325370
183:42:454114281973180138785385862794577488623870
183:43:1489072412981823245784637364047335485952690
183:44:4737957677669437600223846158332431091667650
183:45:14635024826578929476246991466849064927595630
183:46:43905074479736788428740974400547194782786890
183:47:127978621355828510951861989210105652877485190
183:48:362606093841514114363608969428632683152874705
183:49:999016789155191947736473691282967596441593575
183:50:2677364994935914419933749492638353158463470781
183:51:6982147927970129761788013382762764119130227723
183:52:17723913971001098626077264740859324302407501143
183:53:43808164720776300377662673227407009124818540561
183:54:105464100253720723131410139251165021967155745795
183:55:247361253322363150617307417516368869704783476501
183:56:565397150451115772839559811465985987896647946288
183:57:1259744528198100055274106948354038955489022617168
183:58:2736686388844148395940301301596705317096842237296
183:59:5798064383144382194788773944060816349781445418000
183:60:11982666391831723202563466151059020456214987197200
183:61:24161769937627900883857480927545237969089236479600
183:62:47544127941783933997267946341298694068207852427600
183:63:91314912396124698629673357258684793369097621329200
183:64:171215460742733809930637544860033987567058039992250
183:65:313455997359774205873013351359139146468921642447350
183:66:560421328612929640803266294854218473989890209224050
183:67:978646200712130865283315768626023305325629171331550
183:68:1669455283567752652542126899420863285555485056977350
183:69:2782425472612921087570211499034772142592475094962250
183:70:4531378626826757199757201584142343203650602297509950
183:71:7211912462414416388345968718423729324119972670684850
183:72:11218530497089092159649284673103578948631068598843100
183:73:17058313495573825064672199982390373469836282390021700
183:74:25356952493420550771810027000850555157864744093275500
183:75:36852104290437867121697239241236140162763428082227060
183:76:52368779781148548015043445237546093915505924116848980
183:77:72772200475102527761164268057369247389079660785751180
183:78:98895554491805999265171954026681284913364667221661860
183:79:131443458501767467377760192060778922986117595674360700
183:80:170876496052297707591088249679012599881952874376668910
183:81:217287396214650171381260366875781454170878346429591330
183:82:270284322120662408303518992943045223480848674827052630
183:83:328900199207071123357294196231898404476695375391955610
183:84:391547856198894194472969281228450481519875446895185250
183:85:456038091337535591209693633430783502005501991089686350
183:86:519671313384633580680813675304846316238827850311503050
183:87:579403648256430543977458925339886122703060936554204550
183:88:632076707188833320702682464007148497494248294422768600
183:89:674688620033024331087132967198641654628691999664753000
183:90:704674780923380968024338876851914617056633866316519800
183:91:720162138745872857431467203815692960288647797444355400
183:92:720162138745872857431467203815692960288647797444355400
183:93:704674780923380968024338876851914617056633866316519800
183:94:674688620033024331087132967198641654628691999664753000
183:95:632076707188833320702682464007148497494248294422768600
183:96:579403648256430543977458925339886122703060936554204550
183:97:519671313384633580680813675304846316238827850311503050
183:98:456038091337535591209693633430783502005501991089686350
183:99:391547856198894194472969281228450481519875446895185250
183:100:328900199207071123357294196231898404476695375391955610
183:101:270284322120662408303518992943045223480848674827052630
183:102:217287396214650171381260366875781454170878346429591330
183:103:170876496052297707591088249679012599881952874376668910
183:104:131443458501767467377760192060778922986117595674360700
183:105:98895554491805999265171954026681284913364667221661860
183:106:72772200475102527761164268057369247389079660785751180
183:107:52368779781148548015043445237546093915505924116848980
183:108:36852104290437867121697239241236140162763428082227060
183:109:25356952493420550771810027000850555157864744093275500
183:110:17058313495573825064672199982390373469836282390021700
183:111:11218530497089092159649284673103578948631068598843100
183:112:7211912462414416388345968718423729324119972670684850
183:113:4531378626826757199757201584142343203650602297509950
183:114:2782425472612921087570211499034772142592475094962250
183:115:1669455283567752652542126899420863285555485056977350
183:116:978646200712130865283315768626023305325629171331550
183:117:560421328612929640803266294854218473989890209224050
183:118:313455997359774205873013351359139146468921642447350
183:119:171215460742733809930637544860033987567058039992250
183:120:91314912396124698629673357258684793369097621329200
183:121:47544127941783933997267946341298694068207852427600
183:122:24161769937627900883857480927545237969089236479600
183:123:11982666391831723202563466151059020456214987197200
183:124:5798064383144382194788773944060816349781445418000
183:125:2736686388844148395940301301596705317096842237296
183:126:1259744528198100055274106948354038955489022617168
183:127:565397150451115772839559811465985987896647946288
183:128:247361253322363150617307417516368869704783476501
183:129:105464100253720723131410139251165021967155745795
183:130:43808164720776300377662673227407009124818540561
183:131:17723913971001098626077264740859324302407501143
183:132:6982147927970129761788013382762764119130227723
183:133:2677364994935914419933749492638353158463470781
183:134:999016789155191947736473691282967596441593575
183:135:362606093841514114363608969428632683152874705
183:136:127978621355828510951861989210105652877485190
183:137:43905074479736788428740974400547194782786890
183:138:14635024826578929476246991466849064927595630
183:139:4737957677669437600223846158332431091667650
183:140:1489072412981823245784637364047335485952690
183:141:454114281973180138785385862794577488623870
183:142:134315491851222294570325396037832778325370
183:143:38510036125175622918764624038819188191190
183:144:10697232256993228588545728899671996719775
183:145:2877186607053351137608851221291088772905
183:146:748856788137173583761207852116858721715
183:147:188487763000513078905882248491998453765
183:148:45848374783908586760890276660215840105
183:149:10769752466018795547860132101392982575
183:150:2441143892297593657514963276315742717
183:151:533495022820003911907243629923308011
183:152:112314741646316613033103922089117476
183:153:22756581640756960810628899246814652
183:154:4433100319627979378693941411717140
183:155:829418769478783238594350328643852
183:156:148870035547473914619498776936076
183:157:25601853247017806972780044441236
183:158:4212963192547234058811906047292
183:159:662415596312458185347783969700
183:160:99362339446868727802167595455
183:161:14194619920981246828881085065
183:162:1927664433713502655773974515
183:163:248349405570451262400328005
183:164:30286512874445275902479025
183:165:3487537846148243891800615
183:166:378166754401616807544645
183:167:38496016915134645079395
183:168:3666287325250918578990
183:169:325410117625821175650
183:170:26798480275067626230
183:171:2037311365940813690
183:172:142138002274940490
183:173:9037676445227430
183:174:519406692254450
183:175:26712344173086
183:176:1214197462413
183:177:48019108683
183:178:1618621641
183:179:45212895
183:180:1004731
183:181:16653
183:182:183
183:183:1

# binomial(184, k) for 0 <= k <= 184

184:0:1
184:1:184
184:2:16836
184:3:1021384
184:4:46217626
184:5:1663834536
184:6:49637730324
184:7:1262216571096
184:8:27926541635499
184:9:546119036427536
184:10:9557083137481880
184:11:151175678720167920
184:12:2179449368215754180
184:13:28835791641008439920
184:14:352208597900888801880
184:15:3991697442876739754640
184:16:42162304240385563658385
184:17:416662771316751452624040
184:18:3865704600549860699345260
184:19:33774050720593519794279640
184:20:278635918444896538302807030
184:21:2176013839283953918174302520
184:22:16122284354694749484655059580
184:23:113556959367849974631048680520
184:24:761777935759326913149951565155
184:25:4875378788859692244159690016992
184:26:29814816439565041031591950488528
184:27:174471888794491721592278821377312
184:28:978288805026257153213849105579928
184:29:5262519089106762617288291740360992
184:30:27189681960384940189322840658531792
184:31:135071323287073573843732821335932128
184:32:645809764466320524940347552012425487
184:33:2974638915117597569422206906239050728
184:34:13210896358316389205375095377708725292
184:35:56618127249927382308750408761608822680
184:36:234336137784421665666772525152214293870
184:37:937344551137686662667090100608857175480
184:38:3626043395190524721370059073407947494620
184:39:13574418864046579726154580120963085492680
184:40:49207268382168851507310352938491184910965
184:41:172825527976397917489090020076651966516560
184:42:588429773824402433355711258832410266949240
184:43:1943186694955003384570023226841912974576560
184:44:6227030090651260846008483522379766577620340
184:45:19372982504248367076470837625181496019263280
184:46:58540099306315717904987965867396259710382520
184:47:171883695835565299380602963610652847660272080
184:48:490584715197342625315470958638738336030359895
184:49:1361622882996706062100082660711600279594468280
184:50:3676381784091106367670223183921320754905064356
184:51:9659512922906044181721762875401117277593698504
184:52:24706061898971228387865278123622088421537728866
184:53:61532078691777399003739937968266333427226041704
184:54:149272264974497023509072812478572031091974286356
184:55:352825353576083873748717556767533891671939222296
184:56:812758403773478923456867228982354857601431422789
184:57:1825141678649215828113666759820024943385670563456
184:58:3996430917042248451214408249950744272585864854464
184:59:8534750771988530590729075245657521666878287655296
184:60:17780730774976105397352240095119836805996432615200
184:61:36144436329459624086420947078604258425304223676800
184:62:71705897879411834881125427268843932037297088907200
184:63:138859040337908632626941303599983487437305473756800
184:64:262530373138858508560310902118718780936155661321450
184:65:484671458102508015803650896219173134035979682439600
184:66:873877325972703846676279646213357620458811851671400
184:67:1539067529325060506086582063480241779315519380555600
184:68:2648101484279883517825442668046886590881114228308900
184:69:4451880756180673740112338398455635428147960151939600
184:70:7313804099439678287327413083177115346243077392472200
184:71:11743291089241173588103170302566072527770574968194800
184:72:18430442959503508547995253391527308272751041269527950
184:73:28276843992662917224321484655493952418467350988864800
184:74:42415265988994375836482226983240928627701026483297200
184:75:62209056783858417893507266242086695320628172175502560
184:76:89220884071586415136740684478782234078269352199076040
184:77:125140980256251075776207713294915341304585584902600160
184:78:171667754966908527026336222084050532302444328007413040
184:79:230339012993573466642932146087460207899482262896022560
184:80:302319954554065174968848441739791522868070470051029610
184:81:388163892266947878972348616554794054052831220806260240
184:82:487571718335312579684779359818826677651727021256643960
184:83:599184521327733531660813189174943627957544050219008240
184:84:720448055405965317830263477460348885996570822287140860
184:85:847585947536429785682662914659233983525377437984871600
184:86:975709404722169171890507308735629818244329841401189400
184:87:1099074961641064124658272600644732438941888786865707600
184:88:1211480355445263864680141389347034620197309230976973150
184:89:1306765327221857651789815431205790152122940294087521600
184:90:1379363400956405299111471844050556271685325865981272800
184:91:1424836919669253825455806080667607577345281663760875200
184:92:1440324277491745714862934407631385920577295594888710800
184:93:1424836919669253825455806080667607577345281663760875200
184:94:1379363400956405299111471844050556271685325865981272800
184:95:1306765327221857651789815431205790152122940294087521600
184:96:1211480355445263864680141389347034620197309230976973150
184:97:1099074961641064124658272600644732438941888786865707600
184:98:975709404722169171890507308735629818244329841401189400
184:99:847585947536429785682662914659233983525377437984871600
184:100:720448055405965317830263477460348885996570822287140860
184:101:599184521327733531660813189174943627957544050219008240
184:102:487571718335312579684779359818826677651727021256643960
184:103:388163892266947878972348616554794054052831220806260240
184:104:302319954554065174968848441739791522868070470051029610
184:105:230339012993573466642932146087460207899482262896022560
184:106:171667754966908527026336222084050532302444328007413040
184:107:125140980256251075776207713294915341304585584902600160
184:108:89220884071586415136740684478782234078269352199076040
184:109:62209056783858417893507266242086695320628172175502560
184:110:42415265988994375836482226983240928627701026483297200
184:111:28276843992662917224321484655493952418467350988864800
184:112:18430442959503508547995253391527308272751041269527950
184:113:11743291089241173588103170302566072527770574968194800
184:114:7313804099439678287327413083177115346243077392472200
184:115:4451880756180673740112338398455635428147960151939600
184:116:2648101484279883517825442668046886590881114228308900
184:117:1539067529325060506086582063480241779315519380555600
184:118:873877325972703846676279646213357620458811851671400
184:119:484671458102508015803650896219173134035979682439600
184:120:262530373138858508560310902118718780936155661321450
184:121:138859040337908632626941303599983487437305473756800
184:122:71705897879411834881125427268843932037297088907200
184:123:36144436329459624086420947078604258425304223676800
184:124:17780730774976105397352240095119836805996432615200
184:125:8534750771988530590729075245657521666878287655296
184:126:3996430917042248451214408249950744272585864854464
184:127:1825141678649215828113666759820024943385670563456
184:128:812758403773478923456867228982354857601431422789
184:129:352825353576083873748717556767533891671939222296
184:130:149272264974497023509072812478572031091974286356
184:131:61532078691777399003739937968266333427226041704
184:132:24706061898971228387865278123622088421537728866
184:133:9659512922906044181721762875401117277593698504
184:134:3676381784091106367670223183921320754905064356
184:135:1361622882996706062100082660711600279594468280
184:136:490584715197342625315470958638738336030359895
184:137:171883695835565299380602963610652847660272080
184:138:58540099306315717904987965867396259710382520
184:139:19372982504248367076470837625181496019263280
184:140:6227030090651260846008483522379766577620340
184:141:1943186694955003384570023226841912974576560
184:142:588429773824402433355711258832410266949240
184:143:172825527976397917489090020076651966516560
184:144:49207268382168851507310352938491184910965
184:145:13574418864046579726154580120963085492680
184:146:3626043395190524721370059073407947494620
184:147:937344551137686662667090100608857175480
184:148:234336137784421665666772525152214293870
184:149:56618127249927382308750408761608822680
184:150:13210896358316389205375095377708725292
184:151:2974638915117597569422206906239050728
184:152:645809764466320524940347552012425487
184:153:135071323287073573843732821335932128
184:154:27189681960384940189322840658531792
184:155:5262519089106762617288291740360992
184:156:978288805026257153213849105579928
184:157:174471888794491721592278821377312
184:158:29814816439565041031591950488528
184:159:4875378788859692244159690016992
184:160:761777935759326913149951565155
184:161:113556959367849974631048680520
184:162:16122284354694749484655059580
184:163:2176013839283953918174302520
184:164:278635918444896538302807030
184:165:33774050720593519794279640
184:166:3865704600549860699345260
184:167:416662771316751452624040
184:168:42162304240385563658385
184:169:3991697442876739754640
184:170:352208597900888801880
184:171:28835791641008439920
184:172:2179449368215754180
184:173:151175678720167920
184:174:9557083137481880
184:175:546119036427536
184:176:27926541635499
184:177:1262216571096
184:178:49637730324
184:179:1663834536
184:180:46217626
184:181:1021384
184:182:16836
184:183:184
184:184:1

# binomial(185, k) for 0 <= k <= 185

185:0:1
185:1:185
185:2:17020
185:3:1038220
185:4:47239010
185:5:1710052162
185:6:51301564860
185:7:1311854301420
185:8:29188758206595
185:9:574045578063035
185:10:10103202173909416
185:11:160732761857649800
185:12:2330625046935922100
185:13:31015241009224194100
185:14:381044389541897241800
185:15:4343906040777628556520
185:16:46154001683262303413025
185:17:458825075557137016282425
185:18:4282367371866612151969300
185:19:37639755321143380493624900
185:20:312409969165490058097086670
185:21:2454649757728850456477109550
185:22:18298298193978703402829362100
185:23:129679243722544724115703740100
185:24:875334895127176887781000245675
185:25:5637156724619019157309641582147
185:26:34690195228424733275751640505520
185:27:204286705234056762623870771865840
185:28:1152760693820748874806127926957240
185:29:6240807894133019770502140845940920
185:30:32452201049491702806611132398892784
185:31:162261005247458514033055661994463920
185:32:780881087753394098784080373348357615
185:33:3620448679583918094362554458251476215
185:34:16185535273433986774797302283947776020
185:35:69829023608243771514125504139317547972
185:36:290954265034349047975522933913823116550
185:37:1171680688922108328333862625761071469350
185:38:4563387946328211384037149174016804670100
185:39:17200462259237104447524639194371032987300
185:40:62781687246215431233464933059454270403645
185:41:222032796358566768996400373015143151427525
185:42:761255301800800350844801278909062233465800
185:43:2531616468779405817925734485674323241525800
185:44:8170216785606264230578506749221679552196900
185:45:25600012594899627922479321147561262596883620
185:46:77913081810564084981458803492577755729645800
185:47:230423795141881017285590929478049107370654600
185:48:662468411032907924696073922249391183690631975
185:49:1852207598194048687415553619350338615624828175
185:50:5038004667087812429770305844632921034499532636
185:51:13335894706997150549391986059322438032498762860
185:52:34365574821877272569587040999023205699131427370
185:53:86238140590748627391605216091888421848763770570
185:54:210804343666274422512812750446838364519200328060
185:55:502097618550580897257790369246105922763913508652
185:56:1165583757349562797205584785749888749273370645085
185:57:2637900082422694751570533988802379800987101986245
185:58:5821572595691464279328075009770769215971535417920
185:59:12531181689030779041943483495608265939464152509760
185:60:26315481546964635988081315340777358472874720270496
185:61:53925167104435729483773187173724095231300656292000
185:62:107850334208871458967546374347448190462601312584000
185:63:210564938217320467508066730868827419474602562664000
185:64:401389413476767141187252205718702268373461135078250
185:65:747201831241366524363961798337891914972135343761050
185:66:1358548784075211862479930542432530754494791534111000
185:67:2412944855297764352762861709693599399774331232227000
185:68:4187169013604944023912024731527128370196633608864500
185:69:7099982240460557257937781066502522019029074380248500
185:70:11765684855620352027439751481632750774391037544411800
185:71:19057095188680851875430583385743187874013652360667000
185:72:30173734048744682136098423694093380800521616237722750
185:73:46707286952166425772316738047021260691218392258392750
185:74:70692109981657293060803711638734881046168377472162000
185:75:104624322772852793729989493225327623948329198658799760
185:76:151429940855444833030247950720868929398897524374578600
185:77:214361864327837490912948397773697575382854937101676200
185:78:296808735223159602802543935378965873607029912910013200
185:79:402006767960481993669268368171510740201926590903435600
185:80:532658967547638641611780587827251730767552732947052170
185:81:690483846821013053941197058294585576920901690857289850
185:82:875735610602260458657127976373620731704558242062904200
185:83:1086756239663046111345592548993770305609271071475652200
185:84:1319632576733698849491076666635292513954114872506149100
185:85:1568034002942395103512926392119582869521948260272012460
185:86:1823295352258598957573170223394863801769707279386061000
185:87:2074784366363233296548779909380362257186218628266897000
185:88:2310555317086327989338413989991767059139198017842680750
185:89:2518245682667121516469956820552824772320249525064494750
185:90:2686128728178262950901287275256346423808266160068794400
185:91:2804200320625659124567277924718163849030607529742148000
185:92:2865161197160999540318740488298993497922577258649586000
185:93:2865161197160999540318740488298993497922577258649586000
185:94:2804200320625659124567277924718163849030607529742148000
185:95:2686128728178262950901287275256346423808266160068794400
185:96:2518245682667121516469956820552824772320249525064494750
185:97:2310555317086327989338413989991767059139198017842680750
185:98:2074784366363233296548779909380362257186218628266897000
185:99:1823295352258598957573170223394863801769707279386061000
185:100:1568034002942395103512926392119582869521948260272012460
185:101:1319632576733698849491076666635292513954114872506149100
185:102:1086756239663046111345592548993770305609271071475652200
185:103:875735610602260458657127976373620731704558242062904200
185:104:690483846821013053941197058294585576920901690857289850
185:105:532658967547638641611780587827251730767552732947052170
185:106:402006767960481993669268368171510740201926590903435600
185:107:296808735223159602802543935378965873607029912910013200
185:108:214361864327837490912948397773697575382854937101676200
185:109:151429940855444833030247950720868929398897524374578600
185:110:104624322772852793729989493225327623948329198658799760
185:111:70692109981657293060803711638734881046168377472162000
185:112:46707286952166425772316738047021260691218392258392750
185:113:30173734048744682136098423694093380800521616237722750
185:114:19057095188680851875430583385743187874013652360667000
185:115:11765684855620352027439751481632750774391037544411800
185:116:7099982240460557257937781066502522019029074380248500
185:117:4187169013604944023912024731527128370196633608864500
185:118:2412944855297764352762861709693599399774331232227000
185:119:1358548784075211862479930542432530754494791534111000
185:120:747201831241366524363961798337891914972135343761050
185:121:401389413476767141187252205718702268373461135078250
185:122:210564938217320467508066730868827419474602562664000
185:123:107850334208871458967546374347448190462601312584000
185:124:53925167104435729483773187173724095231300656292000
185:125:26315481546964635988081315340777358472874720270496
185:126:12531181689030779041943483495608265939464152509760
185:127:5821572595691464279328075009770769215971535417920
185:128:2637900082422694751570533988802379800987101986245
185:129:1165583757349562797205584785749888749273370645085
185:130:502097618550580897257790369246105922763913508652
185:131:210804343666274422512812750446838364519200328060
185:132:86238140590748627391605216091888421848763770570
185:133:34365574821877272569587040999023205699131427370
185:134:13335894706997150549391986059322438032498762860
185:135:5038004667087812429770305844632921034499532636
185:136:1852207598194048687415553619350338615624828175
185:137:662468411032907924696073922249391183690631975
185:138:230423795141881017285590929478049107370654600
185:139:77913081810564084981458803492577755729645800
185:140:25600012594899627922479321147561262596883620
185:141:8170216785606264230578506749221679552196900
185:142:2531616468779405817925734485674323241525800
185:143:761255301800800350844801278909062233465800
185:144:222032796358566768996400373015143151427525
185:145:62781687246215431233464933059454270403645
185:146:17200462259237104447524639194371032987300
185:147:4563387946328211384037149174016804670100
185:148:1171680688922108328333862625761071469350
185:149:290954265034349047975522933913823116550
185:150:69829023608243771514125504139317547972
185:151:16185535273433986774797302283947776020
185:152:3620448679583918094362554458251476215
185:153:780881087753394098784080373348357615
185:154:162261005247458514033055661994463920
185:155:32452201049491702806611132398892784
185:156:6240807894133019770502140845940920
185:157:1152760693820748874806127926957240
185:158:204286705234056762623870771865840
185:159:34690195228424733275751640505520
185:160:5637156724619019157309641582147
185:161:875334895127176887781000245675
185:162:129679243722544724115703740100
185:163:18298298193978703402829362100
185:164:2454649757728850456477109550
185:165:312409969165490058097086670
185:166:37639755321143380493624900
185:167:4282367371866612151969300
185:168:458825075557137016282425
185:169:46154001683262303413025
185:170:4343906040777628556520
185:171:381044389541897241800
185:172:31015241009224194100
185:173:2330625046935922100
185:174:160732761857649800
185:175:10103202173909416
185:176:574045578063035
185:177:29188758206595
185:178:1311854301420
185:179:51301564860
185:180:1710052162
185:181:47239010
185:182:1038220
185:183:17020
185:184:185
185:185:1

# binomial(186, k) for 0 <= k <= 186

186:0:1
186:1:186
186:2:17205
186:3:1055240
186:4:48277230
186:5:1757291172
186:6:53011617022
186:7:1363155866280
186:8:30500612508015
186:9:603234336269630
186:10:10677247751972451
186:11:170835964031559216
186:12:2491357808793571900
186:13:33345866056160116200
186:14:412059630551121435900
186:15:4724950430319525798320
186:16:50497907724039931969545
186:17:504979077240399319695450
186:18:4741192447423749168251725
186:19:41922122693009992645594200
186:20:350049724486633438590711570
186:21:2767059726894340514574196220
186:22:20752947951707553859306471650
186:23:147977541916523427518533102200
186:24:1005014138849721611896703985775
186:25:6512491619746196045090641827822
186:26:40327351953043752433061282087667
186:27:238976900462481495899622412371360
186:28:1357047399054805637429998698823080
186:29:7393568587953768645308268772898160
186:30:38693008943624722577113273244833704
186:31:194713206296950216839666794393356704
186:32:943142093000852612817136035342821535
186:33:4401329767337312193146634831599833830
186:34:19805983953017904869159856742199252235
186:35:86014558881677758288922806423265323992
186:36:360783288642592819489648438053140664522
186:37:1462634953956457376309385559674894585900
186:38:5735068635250319712371011799777876139450
186:39:21763850205565315831561788368387837657400
186:40:79982149505452535680989572253825303390945
186:41:284814483604782200229865306074597421831170
186:42:983288098159367119841201651924205384893325
186:43:3292871770580206168770535764583385474991600
186:44:10701833254385670048504241234896002793722700
186:45:33770229380505892153057827896782942149080520
186:46:103513094405463712903938124640139018326529420
186:47:308336876952445102267049732970626863100300400
186:48:892892206174788941981664851727440291061286575
186:49:2514676009226956612111627541599729799315460150
186:50:6890212265281861117185859463983259650124360811
186:51:18373899374084962979162291903955359066998295496
186:52:47701469528874423118979027058345643731630190230
186:53:120603715412625899961192257090911627547895197940
186:54:297042484257023049904417966538726786367964098630
186:55:712901962216855319770603119692944287283113836712
186:56:1667681375900143694463375154995994672037284153737
186:57:3803483839772257548776118774552268550260472631330
186:58:8459472678114159030898608998573149016958637404165
186:59:18352754284722243321271558505379035155435687927680
186:60:38846663235995415030024798836385624412338872780256
186:61:80240648651400365471854502514501453704175376562496
186:62:161775501313307188451319561521172285693901968876000
186:63:318415272426191926475613105216275609937203875248000
186:64:611954351694087608695318936587529687848063697742250
186:65:1148591244718133665551214004056594183345596478839300
186:66:2105750615316578386843892340770422669466926877872050
186:67:3771493639372976215242792252126130154269122766338000
186:68:6600113868902708376674886441220727769970964841091500
186:69:11287151254065501281849805798029650389225707989113000
186:70:18865667096080909285377532548135272793420111924660300
186:71:30822780044301203902870334867375938648404689905078800
186:72:49230829237425534011529007079836568674535268598389750
186:73:76881021000911107908415161741114641491740008496115500
186:74:117399396933823718833120449685756141737386769730554750
186:75:175316432754510086790793204864062504994497576130961760
186:76:256054263628297626760237443946196553347226723033378360
186:77:365791805183282323943196348494566504781752461476254800
186:78:511170599550997093715492333152663448989884850011689400
186:79:698815503183641596471812303550476613808956503813448800
186:80:934665735508120635281048955998762470969479323850487770
186:81:1223142814368651695552977646121837307688454423804342020
186:82:1566219457423273512598325034668206308625459932920194050
186:83:1962491850265306570002720525367391037313829313538556400
186:84:2406388816396744960836669215629062819563385943981801300
186:85:2887666579676093953004003058754875383476063132778161560
186:86:3391329355200994061086096615514446671291655539658073460
186:87:3898079718621832254121950132775226058955925907652958000
186:88:4385339683449561285887193899372129316325416646109577750
186:89:4828800999753449505808370810544591831459447542907175500
186:90:5204374410845384467371244095809171196128515685133289150
186:91:5490329048803922075468565199974510272838873689810942400
186:92:5669361517786658664886018413017157346953184788391734000
186:93:5730322394321999080637480976597986995845154517299172000
186:94:5669361517786658664886018413017157346953184788391734000
186:95:5490329048803922075468565199974510272838873689810942400
186:96:5204374410845384467371244095809171196128515685133289150
186:97:4828800999753449505808370810544591831459447542907175500
186:98:4385339683449561285887193899372129316325416646109577750
186:99:3898079718621832254121950132775226058955925907652958000
186:100:3391329355200994061086096615514446671291655539658073460
186:101:2887666579676093953004003058754875383476063132778161560
186:102:2406388816396744960836669215629062819563385943981801300
186:103:1962491850265306570002720525367391037313829313538556400
186:104:1566219457423273512598325034668206308625459932920194050
186:105:1223142814368651695552977646121837307688454423804342020
186:106:934665735508120635281048955998762470969479323850487770
186:107:698815503183641596471812303550476613808956503813448800
186:108:511170599550997093715492333152663448989884850011689400
186:109:365791805183282323943196348494566504781752461476254800
186:110:256054263628297626760237443946196553347226723033378360
186:111:175316432754510086790793204864062504994497576130961760
186:112:117399396933823718833120449685756141737386769730554750
186:113:76881021000911107908415161741114641491740008496115500
186:114:49230829237425534011529007079836568674535268598389750
186:115:30822780044301203902870334867375938648404689905078800
186:116:18865667096080909285377532548135272793420111924660300
186:117:11287151254065501281849805798029650389225707989113000
186:118:6600113868902708376674886441220727769970964841091500
186:119:3771493639372976215242792252126130154269122766338000
186:120:2105750615316578386843892340770422669466926877872050
186:121:1148591244718133665551214004056594183345596478839300
186:122:611954351694087608695318936587529687848063697742250
186:123:318415272426191926475613105216275609937203875248000
186:124:161775501313307188451319561521172285693901968876000
186:125:80240648651400365471854502514501453704175376562496
186:126:38846663235995415030024798836385624412338872780256
186:127:18352754284722243321271558505379035155435687927680
186:128:8459472678114159030898608998573149016958637404165
186:129:3803483839772257548776118774552268550260472631330
186:130:1667681375900143694463375154995994672037284153737
186:131:712901962216855319770603119692944287283113836712
186:132:297042484257023049904417966538726786367964098630
186:133:120603715412625899961192257090911627547895197940
186:134:47701469528874423118979027058345643731630190230
186:135:18373899374084962979162291903955359066998295496
186:136:6890212265281861117185859463983259650124360811
186:137:2514676009226956612111627541599729799315460150
186:138:892892206174788941981664851727440291061286575
186:139:308336876952445102267049732970626863100300400
186:140:103513094405463712903938124640139018326529420
186:141:33770229380505892153057827896782942149080520
186:142:10701833254385670048504241234896002793722700
186:143:3292871770580206168770535764583385474991600
186:144:983288098159367119841201651924205384893325
186:145:284814483604782200229865306074597421831170
186:146:79982149505452535680989572253825303390945
186:147:21763850205565315831561788368387837657400
186:148:5735068635250319712371011799777876139450
186:149:1462634953956457376309385559674894585900
186:150:360783288642592819489648438053140664522
186:151:86014558881677758288922806423265323992
186:152:19805983953017904869159856742199252235
186:153:4401329767337312193146634831599833830
186:154:943142093000852612817136035342821535
186:155:194713206296950216839666794393356704
186:156:38693008943624722577113273244833704
186:157:7393568587953768645308268772898160
186:158:1357047399054805637429998698823080
186:159:238976900462481495899622412371360
186:160:40327351953043752433061282087667
186:161:6512491619746196045090641827822
186:162:1005014138849721611896703985775
186:163:147977541916523427518533102200
186:164:20752947951707553859306471650
186:165:2767059726894340514574196220
186:166:350049724486633438590711570
186:167:41922122693009992645594200
186:168:4741192447423749168251725
186:169:504979077240399319695450
186:170:50497907724039931969545
186:171:4724950430319525798320
186:172:412059630551121435900
186:173:33345866056160116200
186:174:2491357808793571900
186:175:170835964031559216
186:176:10677247751972451
186:177:603234336269630
186:178:30500612508015
186:179:1363155866280
186:180:53011617022
186:181:1757291172
186:182:48277230
186:183:1055240
186:184:17205
186:185:186
186:186:1

# binomial(187, k) for 0 <= k <= 187

187:0:1
187:1:187
187:2:17391
187:3:1072445
187:4:49332470
187:5:1805568402
187:6:54768908194
187:7:1416167483302
187:8:31863768374295
187:9:633734948777645
187:10:11280482088242081
187:11:181513211783531667
187:12:2662193772825131116
187:13:35837223864953688100
187:14:445405496607281552100
187:15:5137010060870647234220
187:16:55222858154359457767865
187:17:555476984964439251664995
187:18:5246171524664148487947175
187:19:46663315140433741813845925
187:20:391971847179643431236305770
187:21:3117109451380973953164907790
187:22:23520007678601894373880667870
187:23:168730489868230981377839573850
187:24:1152991680766245039415237087975
187:25:7517505758595917656987345813597
187:26:46839843572789948478151923915489
187:27:279304252415525248332683694459027
187:28:1596024299517287133329621111194440
187:29:8750615987008574282738267471721240
187:30:46086577531578491222421542017731864
187:31:233406215240574939416780067638190408
187:32:1137855299297802829656802829736178239
187:33:5344471860338164805963770866942655365
187:34:24207313720355217062306491573799086065
187:35:105820542834695663158082663165464576227
187:36:446797847524270577778571244476405988514
187:37:1823418242599050195799033997728035250422
187:38:7197703589206777088680397359452770725350
187:39:27498918840815635543932800168165713796850
187:40:101745999711017851512551360622213141048345
187:41:364796633110234735910854878328422725222115
187:42:1268102581764149320071066957998802806724495
187:43:4276159868739573288611737416507590859884925
187:44:13994705024965876217274776999479388268714300
187:45:44472062634891562201562069131678944942803220
187:46:137283323785969605056995952536921960475609940
187:47:411849971357908815170987857610765881426829820
187:48:1201229083127234044248714584698067154161586975
187:49:3407568215401745554093292393327170090376746725
187:50:9404888274508817729297487005582989449439820961
187:51:25264111639366824096348151367938618717122656307
187:52:66075368902959386098141318962301002798628485726
187:53:168305184941500323080171284149257271279525388170
187:54:417646199669648949865610223629638413915859296570
187:55:1009944446473878369675021086231671073651077935342
187:56:2380583338116999014233978274688938959320397990449
187:57:5471165215672401243239493929548263222297756785067
187:58:12262956517886416579674727773125417567219110035495
187:59:26812226962836402352170167503952184172394325331845
187:60:57199417520717658351296357341764659567774560707936
187:61:119087311887395780501879301350887078116514249342752
187:62:242016149964707553923174064035673739398077345438496
187:63:480190773739499114926932666737447895631105844124000
187:64:930369624120279535170932041803805297785267572990250
187:65:1760545596412221274246532940644123871193660176581550
187:66:3254341860034712052395106344827016852812523356711350
187:67:5877244254689554602086684592896552823736049644210050
187:68:10371607508275684591917678693346857924240087607429500
187:69:17887265122968209658524692239250378159196672830204500
187:70:30152818350146410567227338346164923182645819913773300
187:71:49688447140382113188247867415511211441824801829739100
187:72:80053609281726737914399341947212507322939958503468550
187:73:126111850238336641919944168820951210166275277094505250
187:74:194280417934734826741535611426870783229126778226670250
187:75:292715829688333805623913654549818646731884345861516510
187:76:431370696382807713551030648810259058341724299164340120
187:77:621846068811579950703433792440763058128979184509633160
187:78:876962404734279417658688681647229953771637311487944200
187:79:1209986102734638690187304636703140062798841353825138200
187:80:1633481238691762231752861259549239084778435827663936570
187:81:2157808549876772330834026602120599778657933747654829790
187:82:2789362271791925208151302680790043616313914356724536070
187:83:3528711307688580082601045560035597345939289246458750450
187:84:4368880666662051530839389740996453856877215257520357700
187:85:5294055396072838913840672274383938203039449076759962860
187:86:6278995934877088014090099674269322054767718672436235020
187:87:7289409073822826315208046748289672730247581447311031460
187:88:8283419402071393540009144032147355375281342553762535750
187:89:9214140683203010791695564709916721147784864189016753250
187:90:10033175410598833973179614906353763027587963228040464650
187:91:10694703459649306542839809295783681468967389374944231550
187:92:11159690566590580740354583612991667619792058478202676400
187:93:11399683912108657745523499389615144342798339305690906000
187:94:11399683912108657745523499389615144342798339305690906000
187:95:11159690566590580740354583612991667619792058478202676400
187:96:10694703459649306542839809295783681468967389374944231550
187:97:10033175410598833973179614906353763027587963228040464650
187:98:9214140683203010791695564709916721147784864189016753250
187:99:8283419402071393540009144032147355375281342553762535750
187:100:7289409073822826315208046748289672730247581447311031460
187:101:6278995934877088014090099674269322054767718672436235020
187:102:5294055396072838913840672274383938203039449076759962860
187:103:4368880666662051530839389740996453856877215257520357700
187:104:3528711307688580082601045560035597345939289246458750450
187:105:2789362271791925208151302680790043616313914356724536070
187:106:2157808549876772330834026602120599778657933747654829790
187:107:1633481238691762231752861259549239084778435827663936570
187:108:1209986102734638690187304636703140062798841353825138200
187:109:876962404734279417658688681647229953771637311487944200
187:110:621846068811579950703433792440763058128979184509633160
187:111:431370696382807713551030648810259058341724299164340120
187:112:292715829688333805623913654549818646731884345861516510
187:113:194280417934734826741535611426870783229126778226670250
187:114:126111850238336641919944168820951210166275277094505250
187:115:80053609281726737914399341947212507322939958503468550
187:116:49688447140382113188247867415511211441824801829739100
187:117:30152818350146410567227338346164923182645819913773300
187:118:17887265122968209658524692239250378159196672830204500
187:119:10371607508275684591917678693346857924240087607429500
187:120:5877244254689554602086684592896552823736049644210050
187:121:3254341860034712052395106344827016852812523356711350
187:122:1760545596412221274246532940644123871193660176581550
187:123:930369624120279535170932041803805297785267572990250
187:124:480190773739499114926932666737447895631105844124000
187:125:242016149964707553923174064035673739398077345438496
187:126:119087311887395780501879301350887078116514249342752
187:127:57199417520717658351296357341764659567774560707936
187:128:26812226962836402352170167503952184172394325331845
187:129:12262956517886416579674727773125417567219110035495
187:130:5471165215672401243239493929548263222297756785067
187:131:2380583338116999014233978274688938959320397990449
187:132:1009944446473878369675021086231671073651077935342
187:133:417646199669648949865610223629638413915859296570
187:134:168305184941500323080171284149257271279525388170
187:135:66075368902959386098141318962301002798628485726
187:136:25264111639366824096348151367938618717122656307
187:137:9404888274508817729297487005582989449439820961
187:138:3407568215401745554093292393327170090376746725
187:139:1201229083127234044248714584698067154161586975
187:140:411849971357908815170987857610765881426829820
187:141:137283323785969605056995952536921960475609940
187:142:44472062634891562201562069131678944942803220
187:143:13994705024965876217274776999479388268714300
187:144:4276159868739573288611737416507590859884925
187:145:1268102581764149320071066957998802806724495
187:146:364796633110234735910854878328422725222115
187:147:101745999711017851512551360622213141048345
187:148:27498918840815635543932800168165713796850
187:149:7197703589206777088680397359452770725350
187:150:1823418242599050195799033997728035250422
187:151:446797847524270577778571244476405988514
187:152:105820542834695663158082663165464576227
187:153:24207313720355217062306491573799086065
187:154:5344471860338164805963770866942655365
187:155:1137855299297802829656802829736178239
187:156:233406215240574939416780067638190408
187:157:46086577531578491222421542017731864
187:158:8750615987008574282738267471721240
187:159:1596024299517287133329621111194440
187:160:279304252415525248332683694459027
187:161:46839843572789948478151923915489
187:162:7517505758595917656987345813597
187:163:1152991680766245039415237087975
187:164:168730489868230981377839573850
187:165:23520007678601894373880667870
187:166:3117109451380973953164907790
187:167:391971847179643431236305770
187:168:46663315140433741813845925
187:169:5246171524664148487947175
187:170:555476984964439251664995
187:171:55222858154359457767865
187:172:5137010060870647234220
187:173:445405496607281552100
187:174:35837223864953688100
187:175:2662193772825131116
187:176:181513211783531667
187:177:11280482088242081
187:178:633734948777645
187:179:31863768374295
187:180:1416167483302
187:181:54768908194
187:182:1805568402
187:183:49332470
187:184:1072445
187:185:17391
187:186:187
187:187:1

# binomial(188, k) for 0 <= k <= 188

188:0:1
188:1:188
188:2:17578
188:3:1089836
188:4:50404915
188:5:1854900872
188:6:56574476596
188:7:1470936391496
188:8:33279935857597
188:9:665598717151940
188:10:11914217037019726
188:11:192793693871773748
188:12:2843706984608662783
188:13:38499417637778819216
188:14:481242720472235240200
188:15:5582415557477928786320
188:16:60359868215230105002085
188:17:610699843118798709432860
188:18:5801648509628587739612170
188:19:51909486665097890301793100
188:20:438635162320077173050151695
188:21:3509081298560617384401213560
188:22:26637117129982868327045575660
188:23:192250497546832875751720241720
188:24:1321722170634476020793076661825
188:25:8670497439362162696402582901572
188:26:54357349331385866135139269729086
188:27:326144095988315196810835618374516
188:28:1875328551932812381662304805653467
188:29:10346640286525861416067888582915680
188:30:54837193518587065505159809489453104
188:31:279492792772153430639201609655922272
188:32:1371261514538377769073582897374368647
188:33:6482327159635967635620573696678833604
188:34:29551785580693381868270262440741741430
188:35:130027856555050880220389154739263662292
188:36:552618390358966240936653907641870564741
188:37:2270216090123320773577605242204441238936
188:38:9021121831805827284479431357180805975772
188:39:34696622430022412632613197527618484522200
188:40:129244918551833487056484160790378854845195
188:41:466542632821252587423406238950635866270460
188:42:1632899214874384055981921836327225531946610
188:43:5544262450503722608682804374506393666609420
188:44:18270864893705449505886514415986979128599225
188:45:58466767659857438418836846131158333211517520
188:46:181755386420861167258558021668600905418413160
188:47:549133295143878420227983810147687841902439760
188:48:1613079054485142859419702442308833035588416795
188:49:4608797298528979598342006978025237244538333700
188:50:12812456489910563283390779398910159539816567686
188:51:34668999913875641825645638373521608166562477268
188:52:91339480542326210194489470330239621515751142033
188:53:234380553844459709178312603111558274078153873896
188:54:585951384611149272945781507778895685195384684740
188:55:1427590646143527319540631309861309487566937231912
188:56:3390527784590877383908999360920610032971475925791
188:57:7851748553789400257473472204237202181618154775516
188:58:17734121733558817822914221702673680789516866820562
188:59:39075183480722818931844895277077601739613435367340
188:60:84011644483554060703466524845716843740168886039781
188:61:176286729408113438853175658692651737684288810050688
188:62:361103461852103334425053365386560817514591594781248
188:63:722206923704206668850106730773121635029183189562496
188:64:1410560397859778650097864708541253193416373417114250
188:65:2690915220532500809417464982447929168978927749571800
188:66:5014887456446933326641639285471140724006183533292900
188:67:9131586114724266654481790937723569676548573000921400
188:68:16248851762965239194004363286243410747976137251639550
188:69:28258872631243894250442370932597236083436760437634000
188:70:48040083473114620225752030585415301341842492743977800
188:71:79841265490528523755475205761676134624470621743512400
188:72:129742056422108851102647209362723718764764760333207650
188:73:206165459520063379834343510768163717489215235597973800
188:74:320392268173071468661479780247821993395402055321175500
188:75:486996247623068632365449265976689429961011124088186760
188:76:724086526071141519174944303360077705073608645025856630
188:77:1053216765194387664254464441251022116470703483673973280
188:78:1498808473545859368362122474087993011900616495997577360
188:79:2086948507468918107845993318350370016570478665313082400
188:80:2843467341426400921940165896252379147577277181489074770
188:81:3791289788568534562586887861669838863436369575318766360
188:82:4947170821668697538985329282910643394971848104379365860
188:83:6318073579480505290752348240825640962253203603183286520
188:84:7897591974350631613440435301032051202816504503979108150
188:85:9662936062734890444680062015380392059916664334280320560
188:86:11573051330949926927930771948653260257807167749196197880
188:87:13568405008699914329298146422558994785015300119747266480
188:88:15572828475894219855217190780437028105528924001073567210
188:89:17497560085274404331704708742064076523066206742779289000
188:90:19247316093801844764875179616270484175372827417057217900
188:91:20727878870248140516019424202137444496555352602984696200
188:92:21854394026239887283194392908775349088759447853146907950
188:93:22559374478699238485878083002606811962590397783893582400
188:94:22799367824217315491046998779230288685596678611381812000
188:95:22559374478699238485878083002606811962590397783893582400
188:96:21854394026239887283194392908775349088759447853146907950
188:97:20727878870248140516019424202137444496555352602984696200
188:98:19247316093801844764875179616270484175372827417057217900
188:99:17497560085274404331704708742064076523066206742779289000
188:100:15572828475894219855217190780437028105528924001073567210
188:101:13568405008699914329298146422558994785015300119747266480
188:102:11573051330949926927930771948653260257807167749196197880
188:103:9662936062734890444680062015380392059916664334280320560
188:104:7897591974350631613440435301032051202816504503979108150
188:105:6318073579480505290752348240825640962253203603183286520
188:106:4947170821668697538985329282910643394971848104379365860
188:107:3791289788568534562586887861669838863436369575318766360
188:108:2843467341426400921940165896252379147577277181489074770
188:109:2086948507468918107845993318350370016570478665313082400
188:110:1498808473545859368362122474087993011900616495997577360
188:111:1053216765194387664254464441251022116470703483673973280
188:112:724086526071141519174944303360077705073608645025856630
188:113:486996247623068632365449265976689429961011124088186760
188:114:320392268173071468661479780247821993395402055321175500
188:115:206165459520063379834343510768163717489215235597973800
188:116:129742056422108851102647209362723718764764760333207650
188:117:79841265490528523755475205761676134624470621743512400
188:118:48040083473114620225752030585415301341842492743977800
188:119:28258872631243894250442370932597236083436760437634000
188:120:16248851762965239194004363286243410747976137251639550
188:121:9131586114724266654481790937723569676548573000921400
188:122:5014887456446933326641639285471140724006183533292900
188:123:2690915220532500809417464982447929168978927749571800
188:124:1410560397859778650097864708541253193416373417114250
188:125:722206923704206668850106730773121635029183189562496
188:126:361103461852103334425053365386560817514591594781248
188:127:176286729408113438853175658692651737684288810050688
188:128:84011644483554060703466524845716843740168886039781
188:129:39075183480722818931844895277077601739613435367340
188:130:17734121733558817822914221702673680789516866820562
188:131:7851748553789400257473472204237202181618154775516
188:132:3390527784590877383908999360920610032971475925791
188:133:1427590646143527319540631309861309487566937231912
188:134:585951384611149272945781507778895685195384684740
188:135:234380553844459709178312603111558274078153873896
188:136:91339480542326210194489470330239621515751142033
188:137:34668999913875641825645638373521608166562477268
188:138:12812456489910563283390779398910159539816567686
188:139:4608797298528979598342006978025237244538333700
188:140:1613079054485142859419702442308833035588416795
188:141:549133295143878420227983810147687841902439760
188:142:181755386420861167258558021668600905418413160
188:143:58466767659857438418836846131158333211517520
188:144:18270864893705449505886514415986979128599225
188:145:5544262450503722608682804374506393666609420
188:146:1632899214874384055981921836327225531946610
188:147:466542632821252587423406238950635866270460
188:148:129244918551833487056484160790378854845195
188:149:34696622430022412632613197527618484522200
188:150:9021121831805827284479431357180805975772
188:151:2270216090123320773577605242204441238936
188:152:552618390358966240936653907641870564741
188:153:130027856555050880220389154739263662292
188:154:29551785580693381868270262440741741430
188:155:6482327159635967635620573696678833604
188:156:1371261514538377769073582897374368647
188:157:279492792772153430639201609655922272
188:158:54837193518587065505159809489453104
188:159:10346640286525861416067888582915680
188:160:1875328551932812381662304805653467
188:161:326144095988315196810835618374516
188:162:54357349331385866135139269729086
188:163:8670497439362162696402582901572
188:164:1321722170634476020793076661825
188:165:192250497546832875751720241720
188:166:26637117129982868327045575660
188:167:3509081298560617384401213560
188:168:438635162320077173050151695
188:169:51909486665097890301793100
188:170:5801648509628587739612170
188:171:610699843118798709432860
188:172:60359868215230105002085
188:173:5582415557477928786320
188:174:481242720472235240200
188:175:38499417637778819216
188:176:2843706984608662783
188:177:192793693871773748
188:178:11914217037019726
188:179:665598717151940
188:180:33279935857597
188:181:1470936391496
188:182:56574476596
188:183:1854900872
188:184:50404915
188:185:1089836
188:186:17578
188:187:188
188:188:1

# binomial(189, k) for 0 <= k <= 189

189:0:1
189:1:189
189:2:17766
189:3:1107414
189:4:51494751
189:5:1905305787
189:6:58429377468
189:7:1527510868092
189:8:34750872249093
189:9:698878653009537
189:10:12579815754171666
189:11:204707910908793474
189:12:3036500678480436531
189:13:41343124622387481999
189:14:519742138110014059416
189:15:6063658277950164026520
189:16:65942283772708033788405
189:17:671059711334028814434945
189:18:6412348352747386449045030
189:19:57711135174726478041405270
189:20:490544648985175063351944795
189:21:3947716460880694557451365255
189:22:30146198428543485711446789220
189:23:218887614676815744078765817380
189:24:1513972668181308896544796903545
189:25:9992219609996638717195659563397
189:26:63027846770748028831541852630658
189:27:380501445319701062945974888103602
189:28:2201472647921127578473140424027983
189:29:12221968838458673797730193388569147
189:30:65183833805112926921227698072368784
189:31:334329986290740496144361419145375376
189:32:1650754307310531199712784507030290919
189:33:7853588674174345404694156594053202251
189:34:36034112740329349503890836137420575034
189:35:159579642135744262088659417180005403722
189:36:682646246914017121157043062381134227033
189:37:2822834480482287014514259149846311803677
189:38:11291337921929148058057036599385247214708
189:39:43717744261828239917092628884799290497972
189:40:163941540981855899689097358317997339367395
189:41:595787551373086074479890399741014721115655
189:42:2099441847695636643405328075277861398217070
189:43:7177161665378106664664726210833619198556030
189:44:23815127344209172114569318790493372795208645
189:45:76737632553562887924723360547145312340116745
189:46:240222154080718605677394867799759238629930680
189:47:730888681564739587486541831816288747320852920
189:48:2162212349629021279647686252456520877490856555
189:49:6221876353014122457761709420334070280126750495
189:50:17421253788439542881732786376935396784354901386
189:51:47481456403786205109036417772431767706379044954
189:52:126008480456201852020135108703761229682313619301
189:53:325720034386785919372802073441797895593905015929
189:54:820331938455608982124094110890453959273538558636
189:55:2013542030754676592486412817640205172762321916652
189:56:4818118430734404703449630670781919520538413157703
189:57:11242276338380277641382471565157812214589630701307
189:58:25585870287348218080387693906910882971135021596078
189:59:56809305214281636754759116979751282529130302187902
189:60:123086827964276879635311420122794445479782321407121
189:61:260298373891667499556642183538368581424457696090469
189:62:537390191260216773278229024079212555198880404831936
189:63:1083310385556310003275160096159682452543774784343744
189:64:2132767321563985318947971439314374828445556606676746
189:65:4101475618392279459515329690989182362395301166686050
189:66:7705802676979434136059104267919069892985111282864700
189:67:14146473571171199981123430223194710400554756534214300
189:68:25380437877689505848486154223966980424524710252560950
189:69:44507724394209133444446734218840646831412897689273550
189:70:76298956104358514476194401518012537425279253181611800
189:71:127881348963643143981227236347091435966313114487490200
189:72:209583321912637374858122415124399853389235382076720050
189:73:335907515942172230936990720130887436253979995931181450
189:74:526557727693134848495823291015985710884617290919149300
189:75:807388515796140101026929046224511423356413179409362260
189:76:1211082773694210151540393569336767135034619769114043390
189:77:1777303291265529183429408744611099821544312128699829910
189:78:2552025238740247032616586915339015128371319979671550640
189:79:3585756981014777476208115792438363028471095161310659760
189:80:4930415848895319029786159214602749164147755846802157170
189:81:6634757129994935484527053757922218011013646756807841130
189:82:8738460610237232101572217144580482258408217679698132220
189:83:11265244401149202829737677523736284357225051707562652380
189:84:14215665553831136904192783541857692165069708107162394670
189:85:17560528037085522058120497316412443262733168838259428710
189:86:21235987393684817372610833964033652317723832083476518440
189:87:25141456339649841257228918371212255042822467868943464360
189:88:29141233484594134184515337202996022890544224120820833690
189:89:33070388561168624186921899522501104628595130743852856210
189:90:36744876179076249096579888358334560698439034159836506900
189:91:39975194964049985280894603818407928671928180020041914100
189:92:42582272896488027799213817110912793585314800456131604150
189:93:44413768504939125769072475911382161051349845637040490350
189:94:45358742302916553976925081781837100648187076395275394400
189:95:45358742302916553976925081781837100648187076395275394400
189:96:44413768504939125769072475911382161051349845637040490350
189:97:42582272896488027799213817110912793585314800456131604150
189:98:39975194964049985280894603818407928671928180020041914100
189:99:36744876179076249096579888358334560698439034159836506900
189:100:33070388561168624186921899522501104628595130743852856210
189:101:29141233484594134184515337202996022890544224120820833690
189:102:25141456339649841257228918371212255042822467868943464360
189:103:21235987393684817372610833964033652317723832083476518440
189:104:17560528037085522058120497316412443262733168838259428710
189:105:14215665553831136904192783541857692165069708107162394670
189:106:11265244401149202829737677523736284357225051707562652380
189:107:8738460610237232101572217144580482258408217679698132220
189:108:6634757129994935484527053757922218011013646756807841130
189:109:4930415848895319029786159214602749164147755846802157170
189:110:3585756981014777476208115792438363028471095161310659760
189:111:2552025238740247032616586915339015128371319979671550640
189:112:1777303291265529183429408744611099821544312128699829910
189:113:1211082773694210151540393569336767135034619769114043390
189:114:807388515796140101026929046224511423356413179409362260
189:115:526557727693134848495823291015985710884617290919149300
189:116:335907515942172230936990720130887436253979995931181450
189:117:209583321912637374858122415124399853389235382076720050
189:118:127881348963643143981227236347091435966313114487490200
189:119:76298956104358514476194401518012537425279253181611800
189:120:44507724394209133444446734218840646831412897689273550
189:121:25380437877689505848486154223966980424524710252560950
189:122:14146473571171199981123430223194710400554756534214300
189:123:7705802676979434136059104267919069892985111282864700
189:124:4101475618392279459515329690989182362395301166686050
189:125:2132767321563985318947971439314374828445556606676746
189:126:1083310385556310003275160096159682452543774784343744
189:127:537390191260216773278229024079212555198880404831936
189:128:260298373891667499556642183538368581424457696090469
189:129:123086827964276879635311420122794445479782321407121
189:130:56809305214281636754759116979751282529130302187902
189:131:25585870287348218080387693906910882971135021596078
189:132:11242276338380277641382471565157812214589630701307
189:133:4818118430734404703449630670781919520538413157703
189:134:2013542030754676592486412817640205172762321916652
189:135:820331938455608982124094110890453959273538558636
189:136:325720034386785919372802073441797895593905015929
189:137:126008480456201852020135108703761229682313619301
189:138:47481456403786205109036417772431767706379044954
189:139:17421253788439542881732786376935396784354901386
189:140:6221876353014122457761709420334070280126750495
189:141:2162212349629021279647686252456520877490856555
189:142:730888681564739587486541831816288747320852920
189:143:240222154080718605677394867799759238629930680
189:144:76737632553562887924723360547145312340116745
189:145:23815127344209172114569318790493372795208645
189:146:7177161665378106664664726210833619198556030
189:147:2099441847695636643405328075277861398217070
189:148:595787551373086074479890399741014721115655
189:149:163941540981855899689097358317997339367395
189:150:43717744261828239917092628884799290497972
189:151:11291337921929148058057036599385247214708
189:152:2822834480482287014514259149846311803677
189:153:682646246914017121157043062381134227033
189:154:159579642135744262088659417180005403722
189:155:36034112740329349503890836137420575034
189:156:7853588674174345404694156594053202251
189:157:1650754307310531199712784507030290919
189:158:334329986290740496144361419145375376
189:159:65183833805112926921227698072368784
189:160:12221968838458673797730193388569147
189:161:2201472647921127578473140424027983
189:162:380501445319701062945974888103602
189:163:63027846770748028831541852630658
189:164:9992219609996638717195659563397
189:165:1513972668181308896544796903545
189:166:218887614676815744078765817380
189:167:30146198428543485711446789220
189:168:3947716460880694557451365255
189:169:490544648985175063351944795
189:170:57711135174726478041405270
189:171:6412348352747386449045030
189:172:671059711334028814434945
189:173:65942283772708033788405
189:174:6063658277950164026520
189:175:519742138110014059416
189:176:41343124622387481999
189:177:3036500678480436531
189:178:204707910908793474
189:179:12579815754171666
189:180:698878653009537
189:181:34750872249093
189:182:1527510868092
189:183:58429377468
189:184:1905305787
189:185:51494751
189:186:1107414
189:187:17766
189:188:189
189:189:1

# binomial(190, k) for 0 <= k <= 190

190:0:1
190:1:190
190:2:17955
190:3:1125180
190:4:52602165
190:5:1956800538
190:6:60334683255
190:7:1585940245560
190:8:36278383117185
190:9:733629525258630
190:10:13278694407181203
190:11:217287726662965140
190:12:3241208589389230005
190:13:44379625300867918530
190:14:561085262732401541415
190:15:6583400416060178085936
190:16:72005942050658197814925
190:17:737001995106736848223350
190:18:7083408064081415263479975
190:19:64123483527473864490450300
190:20:548255784159901541393350065
190:21:4438261109865869620803310050
190:22:34093914889424180268898154475
190:23:249033813105359229790212606600
190:24:1732860282858124640623562720925
190:25:11506192278177947613740456466942
190:26:73020066380744667548737512194055
190:27:443529292090449091777516740734260
190:28:2581974093240828641419115312131585
190:29:14423441486379801376203333812597130
190:30:77405802643571600718957891460937931
190:31:399513820095853423065589117217744160
190:32:1985084293601271695857145926175666295
190:33:9504342981484876604406941101083493170
190:34:43887701414503694908584992731473777285
190:35:195613754876073611592550253317425978756
190:36:842225889049761383245702479561139630755
190:37:3505480727396304135671302212227446030710
190:38:14114172402411435072571295749231559018385
190:39:55009082183757387975149665484184537712680
190:40:207659285243684139606189987202796629865367
190:41:759729092354941974168987758059012060483050
190:42:2695229399068722717885218475018876119332725
190:43:9276603513073743308070054286111480596773100
190:44:30992289009587278779234045001326991993764675
190:45:100552759897772060039292679337638685135325390
190:46:316959786634281493602118228346904550970047425
190:47:971110835645458193163936699616047985950783600
190:48:2893101031193760867134228084272809624811709475
190:49:8384088702643143737409395672790591157617607050
190:50:23643130141453665339494495797269467064481651881
190:51:64902710192225747990769204149367164490733946340
190:52:173489936859988057129171526476192997388692664255
190:53:451728514842987771392937182145559125276218635230
190:54:1146051972842394901496896184332251854867443574565
190:55:2833873969210285574610506928530659132035860475288
190:56:6831660461489081295936043488422124693300735074355
190:57:16060394769114682344832102235939731735128043859010
190:58:36828146625728495721770165472068695185724652297385
190:59:82395175501629854835146810886662165500265323783980
190:60:179896133178558516390070537102545728008912623595023
190:61:383385201855944379191953603661163026904240017497590
190:62:797688565151884272834871207617581136623338100922405
190:63:1620700576816526776553389120238895007742655189175680
190:64:3216077707120295322223131535474057280989331391020490
190:65:6234242939956264778463301130303557190840857773362796
190:66:11807278295371713595574433958908252255380412449550750
190:67:21852276248150634117182534491113780293539867817079000
190:68:39526911448860705829609584447161690825079466786775250
190:69:69888162271898639292932888442807627255937607941834500
190:70:120806680498567647920641135736853184256692150870885350
190:71:204180305068001658457421637865103973391592367669102000
190:72:337464670876280518839349651471491289355548496564210250
190:73:545490837854809605795113135255287289643215378007901500
190:74:862465243635307079432814011146873147138597286850330750
190:75:1333946243489274949522752337240497134241030470328511560
190:76:2018471289490350252567322615561278558391032948523405650
190:77:2988386064959739334969802313947866956578931897813873300
190:78:4329328530005776216045995659950114949915632108371380550
190:79:6137782219755024508824702707777378156842415140982210400
190:80:8516172829910096505994275007041112192618851008112816930
190:81:11565172978890254514313212972524967175161402603609998300
190:82:15373217740232167586099270902502700269421864436505973350
190:83:20003705011386434931309894668316766615633269387260784600
190:84:25480909954980339733930461065593976522294759814725047050
190:85:31776193590916658962313280858270135427802876945421823380
190:86:38796515430770339430731331280446095580457000921735947150
190:87:46377443733334658629839752335245907360546299952419982800
190:88:54282689824243975441744255574208277933366691989764298050
190:89:62211622045762758371437236725497127519139354864673689900
190:90:69815264740244873283501787880835665327034164903689363110
190:91:76720071143126234377474492176742489370367214179878421000
190:92:82557467860538013080108420929320722257242980476173518250
190:93:86996041401427153568286293022294954636664646093172094500
190:94:89772510807855679745997557693219261699536922032315884750
190:95:90717484605833107953850163563674201296374152790550788800
190:96:89772510807855679745997557693219261699536922032315884750
190:97:86996041401427153568286293022294954636664646093172094500
190:98:82557467860538013080108420929320722257242980476173518250
190:99:76720071143126234377474492176742489370367214179878421000
190:100:69815264740244873283501787880835665327034164903689363110
190:101:62211622045762758371437236725497127519139354864673689900
190:102:54282689824243975441744255574208277933366691989764298050
190:103:46377443733334658629839752335245907360546299952419982800
190:104:38796515430770339430731331280446095580457000921735947150
190:105:31776193590916658962313280858270135427802876945421823380
190:106:25480909954980339733930461065593976522294759814725047050
190:107:20003705011386434931309894668316766615633269387260784600
190:108:15373217740232167586099270902502700269421864436505973350
190:109:11565172978890254514313212972524967175161402603609998300
190:110:8516172829910096505994275007041112192618851008112816930
190:111:6137782219755024508824702707777378156842415140982210400
190:112:4329328530005776216045995659950114949915632108371380550
190:113:2988386064959739334969802313947866956578931897813873300
190:114:2018471289490350252567322615561278558391032948523405650
190:115:1333946243489274949522752337240497134241030470328511560
190:116:862465243635307079432814011146873147138597286850330750
190:117:545490837854809605795113135255287289643215378007901500
190:118:337464670876280518839349651471491289355548496564210250
190:119:204180305068001658457421637865103973391592367669102000
190:120:120806680498567647920641135736853184256692150870885350
190:121:69888162271898639292932888442807627255937607941834500
190:122:39526911448860705829609584447161690825079466786775250
190:123:21852276248150634117182534491113780293539867817079000
190:124:11807278295371713595574433958908252255380412449550750
190:125:6234242939956264778463301130303557190840857773362796
190:126:3216077707120295322223131535474057280989331391020490
190:127:1620700576816526776553389120238895007742655189175680
190:128:797688565151884272834871207617581136623338100922405
190:129:383385201855944379191953603661163026904240017497590
190:130:179896133178558516390070537102545728008912623595023
190:131:82395175501629854835146810886662165500265323783980
190:132:36828146625728495721770165472068695185724652297385
190:133:16060394769114682344832102235939731735128043859010
190:134:6831660461489081295936043488422124693300735074355
190:135:2833873969210285574610506928530659132035860475288
190:136:1146051972842394901496896184332251854867443574565
190:137:451728514842987771392937182145559125276218635230
190:138:173489936859988057129171526476192997388692664255
190:139:64902710192225747990769204149367164490733946340
190:140:23643130141453665339494495797269467064481651881
190:141:8384088702643143737409395672790591157617607050
190:142:2893101031193760867134228084272809624811709475
190:143:971110835645458193163936699616047985950783600
190:144:316959786634281493602118228346904550970047425
190:145:100552759897772060039292679337638685135325390
190:146:30992289009587278779234045001326991993764675
190:147:9276603513073743308070054286111480596773100
190:148:2695229399068722717885218475018876119332725
190:149:759729092354941974168987758059012060483050
190:150:207659285243684139606189987202796629865367
190:151:55009082183757387975149665484184537712680
190:152:14114172402411435072571295749231559018385
190:153:3505480727396304135671302212227446030710
190:154:842225889049761383245702479561139630755
190:155:195613754876073611592550253317425978756
190:156:43887701414503694908584992731473777285
190:157:9504342981484876604406941101083493170
190:158:1985084293601271695857145926175666295
190:159:399513820095853423065589117217744160
190:160:77405802643571600718957891460937931
190:161:14423441486379801376203333812597130
190:162:2581974093240828641419115312131585
190:163:443529292090449091777516740734260
190:164:73020066380744667548737512194055
190:165:11506192278177947613740456466942
190:166:1732860282858124640623562720925
190:167:249033813105359229790212606600
190:168:34093914889424180268898154475
190:169:4438261109865869620803310050
190:170:548255784159901541393350065
190:171:64123483527473864490450300
190:172:7083408064081415263479975
190:173:737001995106736848223350
190:174:72005942050658197814925
190:175:6583400416060178085936
190:176:561085262732401541415
190:177:44379625300867918530
190:178:3241208589389230005
190:179:217287726662965140
190:180:13278694407181203
190:181:733629525258630
190:182:36278383117185
190:183:1585940245560
190:184:60334683255
190:185:1956800538
190:186:52602165
190:187:1125180
190:188:17955
190:189:190
190:190:1

# binomial(191, k) for 0 <= k <= 191

191:0:1
191:1:191
191:2:18145
191:3:1143135
191:4:53727345
191:5:2009402703
191:6:62291483793
191:7:1646274928815
191:8:37864323362745
191:9:769907908375815
191:10:14012323932439833
191:11:230566421070146343
191:12:3458496316052195145
191:13:47620833890257148535
191:14:605464888033269459945
191:15:7144485678792579627351
191:16:78589342466718375900861
191:17:809007937157395046038275
191:18:7820410059188152111703325
191:19:71206891591555279753930275
191:20:612379267687375405883800365
191:21:4986516894025771162196660115
191:22:38532175999290049889701464525
191:23:283127727994783410059110761075
191:24:1981894095963483870413775327525
191:25:13239052561036072254364019187867
191:26:84526258658922615162477968660997
191:27:516549358471193759326254252928315
191:28:3025503385331277733196632052865845
191:29:17005415579620630017622449124728715
191:30:91829244129951402095161225273535061
191:31:476919622739425023784547008678682091
191:32:2384598113697125118922735043393410455
191:33:11489427275086148300264087027259159465
191:34:53392044395988571512991933832557270455
191:35:239501456290577306501135246048899756041
191:36:1037839643925834994838252732878565609511
191:37:4347706616446065518917004691788585661465
191:38:17619653129807739208242597961459005049095
191:39:69123254586168823047720961233416096731065
191:40:262668367427441527581339652686981167578047
191:41:967388377598626113775177745261808690348417
191:42:3454958491423664692054206233077888179815775
191:43:11971832912142466025955272761130356716105825
191:44:40268892522661022087304099287438472590537775
191:45:131545048907359338818526724338965677129090065
191:46:417512546532053553641410907684543236105372815
191:47:1288070622279739686766054927962952536920831025
191:48:3864211866839219060298164783888857610762493075
191:49:11277189733836904604543623757063400782429316525
191:50:32027218844096809076903891470060058222099258931
191:51:88545840333679413330263699946636631555215598221
191:52:238392647052213805119940730625560161879426610595
191:53:625218451702975828522108708621752122664911299485
191:54:1597780487685382672889833366477810980143662209795
191:55:3979925942052680476107403112862910986903304049853
191:56:9665534430699366870546550416952783825336595549643
191:57:22892055230603763640768145724361856428428778933365
191:58:52888541394843178066602267708008426920852696156395
191:59:119223322127358350556916976358730860685989976081365
191:60:262291308680188371225217347989207893509177947379003
191:61:563281335034502895582024140763708754913152641092613
191:62:1181073767007828652026824811278744163527578118419995
191:63:2418389141968411049388260327856476144365993290098085
191:64:4836778283936822098776520655712952288731986580196170
191:65:9450320647076560100686432665777614471830189164383286
191:66:18041521235327978374037735089211809446221270222913546
191:67:33659554543522347712756968450022032548920280266629750
191:68:61379187697011339946792118938275471118619334603854250
191:69:109415073720759345122542472889969318081017074728609750
191:70:190694842770466287213574024179660811512629758812719850
191:71:324986985566569306378062773601957157648284518539987350
191:72:541644975944282177296771289336595262747140864233312250
191:73:882955508731090124634462786726778578998763874572111750
191:74:1407956081490116685227927146402160436781812664858232250
191:75:2196411487124582028955566348387370281379627757178842310
191:76:3352417532979625202090074952801775692632063418851917210
191:77:5006857354450089587537124929509145514969964846337278950
191:78:7317714594965515551015797973897981906494564006185253850
191:79:10467110749760800724870698367727493106758047249353590950
191:80:14653955049665121014818977714818490349461266149095027330
191:81:20081345808800351020307487979566079367780253611722815230
191:82:26938390719122422100412483875027667444583267040115971650
191:83:35376922751618602517409165570819466885055133823766757950
191:84:45484614966366774665240355733910743137928029201985831650
191:85:57257103545896998696243741923864111950097636760146870430
191:86:70572709021686998393044612138716231008259877867157770530
191:87:85173959164104998060571083615692002941003300874155929950
191:88:100660133557578634071584007909454185293912991942184280850
191:89:116494311870006733813181492299705405452506046854437987950
191:90:132026886786007631654939024606332792846173519768363053010
191:91:146535335883371107660976280057578154697401379083567784110
191:92:159277539003664247457582913106063211627610194656051939250
191:93:169553509261965166648394713951615676893907626569345612750
191:94:176768552209282833314283850715514216336201568125487979250
191:95:180489995413688787699847721256893462995911074822866673550
191:96:180489995413688787699847721256893462995911074822866673550
191:97:176768552209282833314283850715514216336201568125487979250
191:98:169553509261965166648394713951615676893907626569345612750
191:99:159277539003664247457582913106063211627610194656051939250
191:100:146535335883371107660976280057578154697401379083567784110
191:101:132026886786007631654939024606332792846173519768363053010
191:102:116494311870006733813181492299705405452506046854437987950
191:103:100660133557578634071584007909454185293912991942184280850
191:104:85173959164104998060571083615692002941003300874155929950
191:105:70572709021686998393044612138716231008259877867157770530
191:106:57257103545896998696243741923864111950097636760146870430
191:107:45484614966366774665240355733910743137928029201985831650
191:108:35376922751618602517409165570819466885055133823766757950
191:109:26938390719122422100412483875027667444583267040115971650
191:110:20081345808800351020307487979566079367780253611722815230
191:111:14653955049665121014818977714818490349461266149095027330
191:112:10467110749760800724870698367727493106758047249353590950
191:113:7317714594965515551015797973897981906494564006185253850
191:114:5006857354450089587537124929509145514969964846337278950
191:115:3352417532979625202090074952801775692632063418851917210
191:116:2196411487124582028955566348387370281379627757178842310
191:117:1407956081490116685227927146402160436781812664858232250
191:118:882955508731090124634462786726778578998763874572111750
191:119:541644975944282177296771289336595262747140864233312250
191:120:324986985566569306378062773601957157648284518539987350
191:121:190694842770466287213574024179660811512629758812719850
191:122:109415073720759345122542472889969318081017074728609750
191:123:61379187697011339946792118938275471118619334603854250
191:124:33659554543522347712756968450022032548920280266629750
191:125:18041521235327978374037735089211809446221270222913546
191:126:9450320647076560100686432665777614471830189164383286
191:127:4836778283936822098776520655712952288731986580196170
191:128:2418389141968411049388260327856476144365993290098085
191:129:1181073767007828652026824811278744163527578118419995
191:130:563281335034502895582024140763708754913152641092613
191:131:262291308680188371225217347989207893509177947379003
191:132:119223322127358350556916976358730860685989976081365
191:133:52888541394843178066602267708008426920852696156395
191:134:22892055230603763640768145724361856428428778933365
191:135:9665534430699366870546550416952783825336595549643
191:136:3979925942052680476107403112862910986903304049853
191:137:1597780487685382672889833366477810980143662209795
191:138:625218451702975828522108708621752122664911299485
191:139:238392647052213805119940730625560161879426610595
191:140:88545840333679413330263699946636631555215598221
191:141:32027218844096809076903891470060058222099258931
191:142:11277189733836904604543623757063400782429316525
191:143:3864211866839219060298164783888857610762493075
191:144:1288070622279739686766054927962952536920831025
191:145:417512546532053553641410907684543236105372815
191:146:131545048907359338818526724338965677129090065
191:147:40268892522661022087304099287438472590537775
191:148:11971832912142466025955272761130356716105825
191:149:3454958491423664692054206233077888179815775
191:150:967388377598626113775177745261808690348417
191:151:262668367427441527581339652686981167578047
191:152:69123254586168823047720961233416096731065
191:153:17619653129807739208242597961459005049095
191:154:4347706616446065518917004691788585661465
191:155:1037839643925834994838252732878565609511
191:156:239501456290577306501135246048899756041
191:157:53392044395988571512991933832557270455
191:158:11489427275086148300264087027259159465
191:159:2384598113697125118922735043393410455
191:160:476919622739425023784547008678682091
191:161:91829244129951402095161225273535061
191:162:17005415579620630017622449124728715
191:163:3025503385331277733196632052865845
191:164:516549358471193759326254252928315
191:165:84526258658922615162477968660997
191:166:13239052561036072254364019187867
191:167:1981894095963483870413775327525
191:168:283127727994783410059110761075
191:169:38532175999290049889701464525
191:170:4986516894025771162196660115
191:171:612379267687375405883800365
191:172:71206891591555279753930275
191:173:7820410059188152111703325
191:174:809007937157395046038275
191:175:78589342466718375900861
191:176:7144485678792579627351
191:177:605464888033269459945
191:178:47620833890257148535
191:179:3458496316052195145
191:180:230566421070146343
191:181:14012323932439833
191:182:769907908375815
191:183:37864323362745
191:184:1646274928815
191:185:62291483793
191:186:2009402703
191:187:53727345
191:188:1143135
191:189:18145
191:190:191
191:191:1

# binomial(192, k) for 0 <= k <= 192

192:0:1
192:1:192
192:2:18336
192:3:1161280
192:4:54870480
192:5:2063130048
192:6:64300886496
192:7:1708566412608
192:8:39510598291560
192:9:807772231738560
192:10:14782231840815648
192:11:244578745002586176
192:12:3689062737122341488
192:13:51079330206309343680
192:14:653085721923526608480
192:15:7749950566825849087296
192:16:85733828145510955528212
192:17:887597279624113421939136
192:18:8629417996345547157741600
192:19:79027301650743431865633600
192:20:683586159278930685637730640
192:21:5598896161713146568080460480
192:22:43518692893315821051898124640
192:23:321659903994073459948812225600
192:24:2265021823958267280472886088600
192:25:15220946656999556124777794515392
192:26:97765311219958687416841987848864
192:27:601075617130116374488732221589312
192:28:3542052743802471492522886305794160
192:29:20030918964951907750819081177594560
192:30:108834659709572032112783674398263776
192:31:568748866869376425879708233952217152
192:32:2861517736436550142707282052072092546
192:33:13874025388783273419186822070652569920
192:34:64881471671074719813256020859816429920
192:35:292893500686565878014127179881457026496
192:36:1277341100216412301339387978927465365552
192:37:5385546260371900513755257424667151270976
192:38:21967359746253804727159602653247590710560
192:39:86742907715976562255963559194875101780160
192:40:331791622013610350629060613920397264309112
192:41:1230056745026067641356517397948789857926464
192:42:4422346869022290805829383978339696870164192
192:43:15426791403566130718009478994208244895921600
192:44:52240725434803488113259372048568829306643600
192:45:171813941430020360905830823626404149719627840
192:46:549057595439412892459937632023508913234462880
192:47:1705583168811793240407465835647495773026203840
192:48:5152282489118958747064219711851810147683324100
192:49:15141401600676123664841788540952258393191809600
192:50:43304408577933713681447515227123459004528575456
192:51:120573059177776222407167591416696689777314857152
192:52:326938487385893218450204430572196793434642208816
192:53:863611098755189633642049439247312284544337910080
192:54:2222998939388358501411942075099563102808573509280
192:55:5577706429738063148997236479340721967046966259648
192:56:13645460372752047346653953529815694812239899599496
192:57:32557589661303130511314696141314640253765374483008
192:58:75780596625446941707370413432370283349281475089760
192:59:172111863522201528623519244066739287606842672237760
192:60:381514630807546721782134324347938754195167923460368
192:61:825572643714691266807241488752916648422330588471616
192:62:1744355102042331547608848952042452918440730759512608
192:63:3599462908976239701415085139135220307893571408518080
192:64:7255167425905233148164780983569428433097979870294255
192:65:14287098931013382199462953321490566760562175744579456
192:66:27491841882404538474724167754989423918051459387296832
192:67:51701075778850326086794703539233841995141550489543296
192:68:95038742240533687659549087388297503667539614870484000
192:69:170794261417770685069334591828244789199636409332464000
192:70:300109916491225632336116497069630129593646833541329600
192:71:515681828337035593591636797781617969160914277352707200
192:72:866631961510851483674834062938552420395425382773299600
192:73:1424600484675372301931234076063373841745904738805424000
192:74:2290911590221206809862389933128939015780576539430344000
192:75:3604367568614698714183493494789530718161440422037074560
192:76:5548829020104207231045641301189145974011691176030759520
192:77:8359274887429714789627199882310921207602028265189196160
192:78:12324571949415605138552922903407127421464528852522532800
192:79:17784825344726316275886496341625475013252611255538844800
192:80:25121065799425921739689676082545983456219313398448618280
192:81:34735300858465472035126465694384569717241519760817842560
192:82:47019736527922773120719971854593746812363520651838786880
192:83:62315313470741024617821649445847134329638400863882729600
192:84:80861537717985377182649521304730210022983163025752589600
192:85:102741718512263773361484097657774855088025665962132702080
192:86:127829812567583997089288354062580342958357514627304640960
192:87:155746668185791996453615695754408233949263178741313700480
192:88:185834092721683632132155091525146188234916292816340210800
192:89:217154445427585367884765500209159590746419038796622268800
192:90:248521198656014365468120516906038198298679566622801040960
192:91:278562222669378739315915304663910947543574898851930837120
192:92:305812874887035355118559193163641366325011573739619723360
192:93:328831048265629414105977627057678888521517821225397552000
192:94:346322061471247999962678564667129893230109194694833592000
192:95:357258547622971621014131571972407679332112642948354652800
192:96:360979990827377575399695442513786925991822149645733347100
192:97:357258547622971621014131571972407679332112642948354652800
192:98:346322061471247999962678564667129893230109194694833592000
192:99:328831048265629414105977627057678888521517821225397552000
192:100:305812874887035355118559193163641366325011573739619723360
192:101:278562222669378739315915304663910947543574898851930837120
192:102:248521198656014365468120516906038198298679566622801040960
192:103:217154445427585367884765500209159590746419038796622268800
192:104:185834092721683632132155091525146188234916292816340210800
192:105:155746668185791996453615695754408233949263178741313700480
192:106:127829812567583997089288354062580342958357514627304640960
192:107:102741718512263773361484097657774855088025665962132702080
192:108:80861537717985377182649521304730210022983163025752589600
192:109:62315313470741024617821649445847134329638400863882729600
192:110:47019736527922773120719971854593746812363520651838786880
192:111:34735300858465472035126465694384569717241519760817842560
192:112:25121065799425921739689676082545983456219313398448618280
192:113:17784825344726316275886496341625475013252611255538844800
192:114:12324571949415605138552922903407127421464528852522532800
192:115:8359274887429714789627199882310921207602028265189196160
192:116:5548829020104207231045641301189145974011691176030759520
192:117:3604367568614698714183493494789530718161440422037074560
192:118:2290911590221206809862389933128939015780576539430344000
192:119:1424600484675372301931234076063373841745904738805424000
192:120:866631961510851483674834062938552420395425382773299600
192:121:515681828337035593591636797781617969160914277352707200
192:122:300109916491225632336116497069630129593646833541329600
192:123:170794261417770685069334591828244789199636409332464000
192:124:95038742240533687659549087388297503667539614870484000
192:125:51701075778850326086794703539233841995141550489543296
192:126:27491841882404538474724167754989423918051459387296832
192:127:14287098931013382199462953321490566760562175744579456
192:128:7255167425905233148164780983569428433097979870294255
192:129:3599462908976239701415085139135220307893571408518080
192:130:1744355102042331547608848952042452918440730759512608
192:131:825572643714691266807241488752916648422330588471616
192:132:381514630807546721782134324347938754195167923460368
192:133:172111863522201528623519244066739287606842672237760
192:134:75780596625446941707370413432370283349281475089760
192:135:32557589661303130511314696141314640253765374483008
192:136:13645460372752047346653953529815694812239899599496
192:137:5577706429738063148997236479340721967046966259648
192:138:2222998939388358501411942075099563102808573509280
192:139:863611098755189633642049439247312284544337910080
192:140:326938487385893218450204430572196793434642208816
192:141:120573059177776222407167591416696689777314857152
192:142:43304408577933713681447515227123459004528575456
192:143:15141401600676123664841788540952258393191809600
192:144:5152282489118958747064219711851810147683324100
192:145:1705583168811793240407465835647495773026203840
192:146:549057595439412892459937632023508913234462880
192:147:171813941430020360905830823626404149719627840
192:148:52240725434803488113259372048568829306643600
192:149:15426791403566130718009478994208244895921600
192:150:4422346869022290805829383978339696870164192
192:151:1230056745026067641356517397948789857926464
192:152:331791622013610350629060613920397264309112
192:153:86742907715976562255963559194875101780160
192:154:21967359746253804727159602653247590710560
192:155:5385546260371900513755257424667151270976
192:156:1277341100216412301339387978927465365552
192:157:292893500686565878014127179881457026496
192:158:64881471671074719813256020859816429920
192:159:13874025388783273419186822070652569920
192:160:2861517736436550142707282052072092546
192:161:568748866869376425879708233952217152
192:162:108834659709572032112783674398263776
192:163:20030918964951907750819081177594560
192:164:3542052743802471492522886305794160
192:165:601075617130116374488732221589312
192:166:97765311219958687416841987848864
192:167:15220946656999556124777794515392
192:168:2265021823958267280472886088600
192:169:321659903994073459948812225600
192:170:43518692893315821051898124640
192:171:5598896161713146568080460480
192:172:683586159278930685637730640
192:173:79027301650743431865633600
192:174:8629417996345547157741600
192:175:887597279624113421939136
192:176:85733828145510955528212
192:177:7749950566825849087296
192:178:653085721923526608480
192:179:51079330206309343680
192:180:3689062737122341488
192:181:244578745002586176
192:182:14782231840815648
192:183:807772231738560
192:184:39510598291560
192:185:1708566412608
192:186:64300886496
192:187:2063130048
192:188:54870480
192:189:1161280
192:190:18336
192:191:192
192:192:1

# binomial(193, k) for 0 <= k <= 193

193:0:1
193:1:193
193:2:18528
193:3:1179616
193:4:56031760
193:5:2118000528
193:6:66364016544
193:7:1772867299104
193:8:41219164704168
193:9:847282830030120
193:10:15590004072554208
193:11:259360976843401824
193:12:3933641482124927664
193:13:54768392943431685168
193:14:704165052129835952160
193:15:8403036288749375695776
193:16:93483778712336804615508
193:17:973331107769624377467348
193:18:9517015275969660579680736
193:19:87656719647088979023375200
193:20:762613460929674117503364240
193:21:6282482320992077253718191120
193:22:49117589055028967619978585120
193:23:365178596887389281000710350240
193:24:2586681727952340740421698314200
193:25:17485968480957823405250680603992
193:26:112986257876958243541619782364256
193:27:698840928350075061905574209438176
193:28:4143128360932587867011618527383472
193:29:23572971708754379243341967483388720
193:30:128865578674523939863602755575858336
193:31:677583526578948457992491908350480928
193:32:3430266603305926568586990286024309698
193:33:16735543125219823561894104122724662466
193:34:78755497059857993232442842930468999840
193:35:357774972357640597827383200741273456416
193:36:1570234600902978179353515158808922392048
193:37:6662887360588312815094645403594616636528
193:38:27352906006625705240914860077914741981536
193:39:108710267462230366983123161848122692490720
193:40:418534529729586912885024173115272366089272
193:41:1561848367039677991985578011869187122235576
193:42:5652403614048358447185901376288486728090656
193:43:19849138272588421523838862972547941766085792
193:44:67667516838369618831268851042777074202565200
193:45:224054666864823849019090195674972979026271440
193:46:720871536869433253365768455649913062954090720
193:47:2254640764251206132867403467671004686260666720
193:48:6857865657930751987471685547499305920709527940
193:49:20293684089795082411906008252804068540875133700
193:50:58445810178609837346289303768075717397720385056
193:51:163877467755709936088615106643820148781843432608
193:52:447511546563669440857372021988893483211957065968
193:53:1190549586141082852092253869819509077978980118896
193:54:3086610038143548135053991514346875387352911419360
193:55:7800705369126421650409178554440285069855539768928
193:56:19223166802490110495651190009156416779286865859144
193:57:46203050034055177857968649671130335066005274082504
193:58:108338186286750072218685109573684923603046849572768
193:59:247892460147648470330889657499109570956124147327520
193:60:553626494329748250405653568414678041802010595698128
193:61:1207087274522237988589375813100855402617498511931984
193:62:2569927745757022814416090440795369566863061347984224
193:63:5343818011018571249023934091177673226334302168030688
193:64:10854630334881472849579866122704648740991551278812335
193:65:21542266356918615347627734305059995193660155614873711
193:66:41778940813417920674187121076479990678613635131876288
193:67:79192917661254864561518871294223265913193009876840128
193:68:146739818019384013746343790927531345662681165360027296
193:69:265833003658304372728883679216542292867176024202948000
193:70:470904177908996317405451088897874918793283242873793600
193:71:815791744828261225927753294851248098754561110894036800
193:72:1382313789847887077266470860720170389556339660126006800
193:73:2291232446186223785606068139001926262141330121578723600
193:74:3715512074896579111793624009192312857526481278235768000
193:75:5895279158835905524045883427918469733942016961467418560
193:76:9153196588718905945229134795978676692173131598067834080
193:77:13908103907533922020672841183500067181613719441219955680
193:78:20683846836845319928180122785718048629066557117711728960
193:79:30109397294141921414439419245032602434717140108061377600
193:80:42905891144152238015576172424171458469471924653987463080
193:81:59856366657891393774816141776930553173460833159266460840
193:82:81755037386388245155846437548978316529605040412656629440
193:83:109335049998663797738541621300440881142001921515721516480
193:84:143176851188726401800471170750577344352621563889635319200
193:85:183603256230249150544133618962505065111008828987885291680
193:86:230571531079847770450772451720355198046383180589437343040
193:87:283576480753375993542904049816988576907620693368618341440
193:88:341580760907475628585770787279554422184179471557653911280
193:89:402988538149269000016920591734305778981335331612962479600
193:90:465675644083599733352886017115197789045098605419423309760
193:91:527083421325393104784035821569949145842254465474731878080
193:92:584375097556414094434474497827552313868586472591550560480
193:93:634643923152664769224536820221320254846529394965017275360
193:94:675153109736877414068656191724808781751627015920231144000
193:95:703580609094219620976810136639537572562221837643188244800
193:96:718238538450349196413827014486194605323934792594087999900
193:97:718238538450349196413827014486194605323934792594087999900
193:98:703580609094219620976810136639537572562221837643188244800
193:99:675153109736877414068656191724808781751627015920231144000
193:100:634643923152664769224536820221320254846529394965017275360
193:101:584375097556414094434474497827552313868586472591550560480
193:102:527083421325393104784035821569949145842254465474731878080
193:103:465675644083599733352886017115197789045098605419423309760
193:104:402988538149269000016920591734305778981335331612962479600
193:105:341580760907475628585770787279554422184179471557653911280
193:106:283576480753375993542904049816988576907620693368618341440
193:107:230571531079847770450772451720355198046383180589437343040
193:108:183603256230249150544133618962505065111008828987885291680
193:109:143176851188726401800471170750577344352621563889635319200
193:110:109335049998663797738541621300440881142001921515721516480
193:111:81755037386388245155846437548978316529605040412656629440
193:112:59856366657891393774816141776930553173460833159266460840
193:113:42905891144152238015576172424171458469471924653987463080
193:114:30109397294141921414439419245032602434717140108061377600
193:115:20683846836845319928180122785718048629066557117711728960
193:116:13908103907533922020672841183500067181613719441219955680
193:117:9153196588718905945229134795978676692173131598067834080
193:118:5895279158835905524045883427918469733942016961467418560
193:119:3715512074896579111793624009192312857526481278235768000
193:120:2291232446186223785606068139001926262141330121578723600
193:121:1382313789847887077266470860720170389556339660126006800
193:122:815791744828261225927753294851248098754561110894036800
193:123:470904177908996317405451088897874918793283242873793600
193:124:265833003658304372728883679216542292867176024202948000
193:125:146739818019384013746343790927531345662681165360027296
193:126:79192917661254864561518871294223265913193009876840128
193:127:41778940813417920674187121076479990678613635131876288
193:128:21542266356918615347627734305059995193660155614873711
193:129:10854630334881472849579866122704648740991551278812335
193:130:5343818011018571249023934091177673226334302168030688
193:131:2569927745757022814416090440795369566863061347984224
193:132:1207087274522237988589375813100855402617498511931984
193:133:553626494329748250405653568414678041802010595698128
193:134:247892460147648470330889657499109570956124147327520
193:135:108338186286750072218685109573684923603046849572768
193:136:46203050034055177857968649671130335066005274082504
193:137:19223166802490110495651190009156416779286865859144
193:138:7800705369126421650409178554440285069855539768928
193:139:3086610038143548135053991514346875387352911419360
193:140:1190549586141082852092253869819509077978980118896
193:141:447511546563669440857372021988893483211957065968
193:142:163877467755709936088615106643820148781843432608
193:143:58445810178609837346289303768075717397720385056
193:144:20293684089795082411906008252804068540875133700
193:145:6857865657930751987471685547499305920709527940
193:146:2254640764251206132867403467671004686260666720
193:147:720871536869433253365768455649913062954090720
193:148:224054666864823849019090195674972979026271440
193:149:67667516838369618831268851042777074202565200
193:150:19849138272588421523838862972547941766085792
193:151:5652403614048358447185901376288486728090656
193:152:1561848367039677991985578011869187122235576
193:153:418534529729586912885024173115272366089272
193:154:108710267462230366983123161848122692490720
193:155:27352906006625705240914860077914741981536
193:156:6662887360588312815094645403594616636528
193:157:1570234600902978179353515158808922392048
193:158:357774972357640597827383200741273456416
193:159:78755497059857993232442842930468999840
193:160:16735543125219823561894104122724662466
193:161:3430266603305926568586990286024309698
193:162:677583526578948457992491908350480928
193:163:128865578674523939863602755575858336
193:164:23572971708754379243341967483388720
193:165:4143128360932587867011618527383472
193:166:698840928350075061905574209438176
193:167:112986257876958243541619782364256
193:168:17485968480957823405250680603992
193:169:2586681727952340740421698314200
193:170:365178596887389281000710350240
193:171:49117589055028967619978585120
193:172:6282482320992077253718191120
193:173:762613460929674117503364240
193:174:87656719647088979023375200
193:175:9517015275969660579680736
193:176:973331107769624377467348
193:177:93483778712336804615508
193:178:8403036288749375695776
193:179:704165052129835952160
193:180:54768392943431685168
193:181:3933641482124927664
193:182:259360976843401824
193:183:15590004072554208
193:184:847282830030120
193:185:41219164704168
193:186:1772867299104
193:187:66364016544
193:188:2118000528
193:189:56031760
193:190:1179616
193:191:18528
193:192:193
193:193:1

# binomial(194, k) for 0 <= k <= 194

194:0:1
194:1:194
194:2:18721
194:3:1198144
194:4:57211376
194:5:2174032288
194:6:68482017072
194:7:1839231315648
194:8:42992032003272
194:9:888501994734288
194:10:16437286902584328
194:11:274950980915956032
194:12:4193002458968329488
194:13:58702034425556612832
194:14:758933445073267637328
194:15:9107201340879211647936
194:16:101886815001086180311284
194:17:1066814886481961182082856
194:18:10490346383739284957148084
194:19:97173734923058639603055936
194:20:850270180576763096526739440
194:21:7045095781921751371221555360
194:22:55400071376021044873696776240
194:23:414296185942418248620688935360
194:24:2951860324839730021422408664440
194:25:20072650208910164145672378918192
194:26:130472226357916066946870462968248
194:27:811827186227033305447193991802432
194:28:4841969289282662928917192736821648
194:29:27716100069686967110353586010772192
194:30:152438550383278319106944723059247056
194:31:806449105253472397856094663926339264
194:32:4107850129884875026579482194374790626
194:33:20165809728525750130481094408748972164
194:34:95491040185077816794336947053193662306
194:35:436530469417498591059826043671742456256
194:36:1928009573260618777180898359550195848464
194:37:8233121961491290994448160562403539028576
194:38:34015793367214018056009505481509358618064
194:39:136063173468856072224038021926037434472256
194:40:527244797191817279868147334963395058579992
194:41:1980382896769264904870602184984459488324848
194:42:7214251981088036439171479388157673850326232
194:43:25501541886636779971024764348836428494176448
194:44:87516655110958040355107714015325015968650992
194:45:291722183703193467850359046717750053228836640
194:46:944926203734257102384858651324886041980362160
194:47:2975512301120639386233171923320917749214757440
194:48:9112506422181958120339089015170310606970194660
194:49:27151549747725834399377693800303374461584661640
194:50:78739494268404919758195312020879785938595518756
194:51:222323277934319773434904410411895866179563817664
194:52:611389014319379376945987128632713631993800498576
194:53:1638061132704752292949625891808402561190937184864
194:54:4277159624284630987146245384166384465331891538256
194:55:10887315407269969785463170068787160457208451188288
194:56:27023872171616532146060368563596701849142405628072
194:57:65426216836545288353619839680286751845292139941648
194:58:154541236320805250076653759244815258669052123655272
194:59:356230646434398542549574767072794494559170996900288
194:60:801518954477396720736543225913787612758134743025648
194:61:1760713768851986238995029381515533444419509107630112
194:62:3777015020279260803005466253896224969480559859916208
194:63:7913745756775594063440024531973042793197363516014912
194:64:16198448345900044098603800213882321967325853446843023
194:65:32396896691800088197207600427764643934651706893686046
194:66:63321207170336536021814855381539985872273790746749999
194:67:120971858474672785235705992370703256591806645008716416
194:68:225932735680638878307862662221754611575874175236867424
194:69:412572821677688386475227470144073638529857189562975296
194:70:736737181567300690134334768114417211660459267076741600
194:71:1286695922737257543333204383749123017547844353767830400
194:72:2198105534676148303194224155571418488310900771020043600
194:73:3673546236034110862872538999722096651697669781704730400
194:74:6006744521082802897399692148194239119667811399814491600
194:75:9610791233732484635839507437110782591468498239703186560
194:76:15048475747554811469275018223897146426115148559535252640
194:77:23061300496252827965901975979478743873786851039287789760
194:78:34591950744379241948852963969218115810680276558931684640
194:79:50793244130987241342619542030750651063783697225773106560
194:80:73015288438294159430015591669204060904189064762048840680
194:81:102762257802043631790392314201102011642932757813253923920
194:82:141611404044279638930662579325908869703065873571923090280
194:83:191090087385052042894388058849419197671606961928378145920
194:84:252511901187390199539012792051018225494623485405356835680
194:85:326780107418975552344604789713082409463630392877520610880
194:86:414174787310096920994906070682860263157392009577322634720
194:87:514148011833223763993676501537343774954003873958055684480
194:88:625157241660851622128674837096542999091800164926272252720
194:89:744569299056744628602691379013860201165514803170616390880
194:90:868664182232868733369806608849503568026433937032385789360
194:91:992759065408992838136921838685146934887353070894155187840
194:92:1111458518881807199218510319397501459710840938066282438560
194:93:1219019020709078863659011318048872568715115867556567835840
194:94:1309797032889542183293193011946129036598156410885248419360
194:95:1378733718831097035045466328364346354313848853563419388800
194:96:1421819147544568817390637151125732177886156630237276244700
194:97:1436477076900698392827654028972389210647869585188175999800
194:98:1421819147544568817390637151125732177886156630237276244700
194:99:1378733718831097035045466328364346354313848853563419388800
194:100:1309797032889542183293193011946129036598156410885248419360
194:101:1219019020709078863659011318048872568715115867556567835840
194:102:1111458518881807199218510319397501459710840938066282438560
194:103:992759065408992838136921838685146934887353070894155187840
194:104:868664182232868733369806608849503568026433937032385789360
194:105:744569299056744628602691379013860201165514803170616390880
194:106:625157241660851622128674837096542999091800164926272252720
194:107:514148011833223763993676501537343774954003873958055684480
194:108:414174787310096920994906070682860263157392009577322634720
194:109:326780107418975552344604789713082409463630392877520610880
194:110:252511901187390199539012792051018225494623485405356835680
194:111:191090087385052042894388058849419197671606961928378145920
194:112:141611404044279638930662579325908869703065873571923090280
194:113:102762257802043631790392314201102011642932757813253923920
194:114:73015288438294159430015591669204060904189064762048840680
194:115:50793244130987241342619542030750651063783697225773106560
194:116:34591950744379241948852963969218115810680276558931684640
194:117:23061300496252827965901975979478743873786851039287789760
194:118:15048475747554811469275018223897146426115148559535252640
194:119:9610791233732484635839507437110782591468498239703186560
194:120:6006744521082802897399692148194239119667811399814491600
194:121:3673546236034110862872538999722096651697669781704730400
194:122:2198105534676148303194224155571418488310900771020043600
194:123:1286695922737257543333204383749123017547844353767830400
194:124:736737181567300690134334768114417211660459267076741600
194:125:412572821677688386475227470144073638529857189562975296
194:126:225932735680638878307862662221754611575874175236867424
194:127:120971858474672785235705992370703256591806645008716416
194:128:63321207170336536021814855381539985872273790746749999
194:129:32396896691800088197207600427764643934651706893686046
194:130:16198448345900044098603800213882321967325853446843023
194:131:7913745756775594063440024531973042793197363516014912
194:132:3777015020279260803005466253896224969480559859916208
194:133:1760713768851986238995029381515533444419509107630112
194:134:801518954477396720736543225913787612758134743025648
194:135:356230646434398542549574767072794494559170996900288
194:136:154541236320805250076653759244815258669052123655272
194:137:65426216836545288353619839680286751845292139941648
194:138:27023872171616532146060368563596701849142405628072
194:139:10887315407269969785463170068787160457208451188288
194:140:4277159624284630987146245384166384465331891538256
194:141:1638061132704752292949625891808402561190937184864
194:142:611389014319379376945987128632713631993800498576
194:143:222323277934319773434904410411895866179563817664
194:144:78739494268404919758195312020879785938595518756
194:145:27151549747725834399377693800303374461584661640
194:146:9112506422181958120339089015170310606970194660
194:147:2975512301120639386233171923320917749214757440
194:148:944926203734257102384858651324886041980362160
194:149:291722183703193467850359046717750053228836640
194:150:87516655110958040355107714015325015968650992
194:151:25501541886636779971024764348836428494176448
194:152:7214251981088036439171479388157673850326232
194:153:1980382896769264904870602184984459488324848
194:154:527244797191817279868147334963395058579992
194:155:136063173468856072224038021926037434472256
194:156:34015793367214018056009505481509358618064
194:157:8233121961491290994448160562403539028576
194:158:1928009573260618777180898359550195848464
194:159:436530469417498591059826043671742456256
194:160:95491040185077816794336947053193662306
194:161:20165809728525750130481094408748972164
194:162:4107850129884875026579482194374790626
194:163:806449105253472397856094663926339264
194:164:152438550383278319106944723059247056
194:165:27716100069686967110353586010772192
194:166:4841969289282662928917192736821648
194:167:811827186227033305447193991802432
194:168:130472226357916066946870462968248
194:169:20072650208910164145672378918192
194:170:2951860324839730021422408664440
194:171:414296185942418248620688935360
194:172:55400071376021044873696776240
194:173:7045095781921751371221555360
194:174:850270180576763096526739440
194:175:97173734923058639603055936
194:176:10490346383739284957148084
194:177:1066814886481961182082856
194:178:101886815001086180311284
194:179:9107201340879211647936
194:180:758933445073267637328
194:181:58702034425556612832
194:182:4193002458968329488
194:183:274950980915956032
194:184:16437286902584328
194:185:888501994734288
194:186:42992032003272
194:187:1839231315648
194:188:68482017072
194:189:2174032288
194:190:57211376
194:191:1198144
194:192:18721
194:193:194
194:194:1

# binomial(195, k) for 0 <= k <= 195

195:0:1
195:1:195
195:2:18915
195:3:1216865
195:4:58409520
195:5:2231243664
195:6:70656049360
195:7:1907713332720
195:8:44831263318920
195:9:931494026737560
195:10:17325788897318616
195:11:291388267818540360
195:12:4467953439884285520
195:13:62895036884524942320
195:14:817635479498824250160
195:15:9866134785952479285264
195:16:110994016341965391959220
195:17:1168701701483047362394140
195:18:11557161270221246139230940
195:19:107664081306797924560204020
195:20:947443915499821736129795376
195:21:7895365962498514467748294800
195:22:62445167157942796244918331600
195:23:469696257318439293494385711600
195:24:3366156510782148270043097599800
195:25:23024510533749894167094787582632
195:26:150544876566826231092542841886440
195:27:942299412584949372394064454770680
195:28:5653796475509696234364386728624080
195:29:32558069358969630039270778747593840
195:30:180154650452965286217298309070019248
195:31:958887655636750716963039386985586320
195:32:4914299235138347424435576858301129890
195:33:24273659858410625157060576603123762790
195:34:115656849913603566924818041461942634470
195:35:532021509602576407854162990724936118562
195:36:2364540042678117368240724403221938304720
195:37:10161131534751909771629058921953734877040
195:38:42248915328705309050457666043912897646640
195:39:170078966836070090280047527407546793090320
195:40:663307970660673352092185356889432493052248
195:41:2507627693961082184738749519947854546904840
195:42:9194634877857301344042081573142133338651080
195:43:32715793867724816410196243736994102344502680
195:44:113018196997594820326132478364161444462827440
195:45:379238838814151508205466760733075069197487632
195:46:1236648387437450570235217698042636095209198800
195:47:3920438504854896488618030574645803791195119600
195:48:12088018723302597506572260938491228356184952100
195:49:36264056169907792519716782815473685068554856300
195:50:105891044016130754157573005821183160400180180396
195:51:301062772202724693193099722432775652118159336420
195:52:833712292253699150380891539044609498173364316240
195:53:2249450147024131669895613020441116193184737683440
195:54:5915220756989383280095871275974787026522828723120
195:55:15164475031554600772609415452953544922540342726544
195:56:37911187578886501931523538632383862306350856816360
195:57:92450089008161820499680208243883453694434545569720
195:58:219967453157350538430273598925102010514344263596920
195:59:510771882755203792626228526317609753228223120555560
195:60:1157749600911795263286117992986582107317305739925936
195:61:2562232723329382959731572607429321057177643850655760
195:62:5537728789131247042000495635411758413900068967546320
195:63:11690760777054854866445490785869267762677923375931120
195:64:24112194102675638162043824745855364760523216962857935
195:65:48595345037700132295811400641646965901977560340529069
195:66:95718103862136624219022455809304629806925497640436045
195:67:184293065645009321257520847752243242464080435755466415
195:68:346904594155311663543568654592457868167680820245583840
195:69:638505557358327264783090132365828250105731364799842720
195:70:1149310003244989076609562238258490850190316456639716896
195:71:2023433104304558233467539151863540229208303620844572000
195:72:3484801457413405846527428539320541505858745124787874000
195:73:5871651770710259166066763155293515140008570552724774000
195:74:9680290757116913760272231147916335771365481181519222000
195:75:15617535754815287533239199585305021711136309639517678160
195:76:24659266981287296105114525661007929017583646799238439200
195:77:38109776243807639435176994203375890299901999598823042400
195:78:57653251240632069914754939948696859684467127598219474400
195:79:85385194875366483291472505999968766874463973784704791200
195:80:123808532569281400772635133699954711967972761987821947240
195:81:175777546240337791220407905870306072547121822575302764600
195:82:244373661846323270721054893527010881345998631385177014200
195:83:332701491429331681825050638175328067374672835500301236200
195:84:443601988572442242433400850900437423166230447333734981600
195:85:579292008606365751883617581764100634958253878282877446560
195:86:740954894729072473339510860395942672621022402454843245600
195:87:928322799143320684988582572220204038111395883535378319200
195:88:1139305253494075386122351338633886774045804038884327937200
195:89:1369726540717596250731366216110403200257314968096888643600
195:90:1613233481289613361972497987863363769191948740203002180240
195:91:1861423247641861571506728447534650502913787007926540977200
195:92:2104217584290800037355432158082648394598194008960437626400
195:93:2330477539590886062877521637446374028425956805622850274400
195:94:2528816053598621046952204329995001605313272278441816255200
195:95:2688530751720639218338659340310475390912005264448667808160
195:96:2800552866375665852436103479490078532200005483800695633500
195:97:2858296224445267210218291180098121388534026215425452244500
195:98:2858296224445267210218291180098121388534026215425452244500
195:99:2800552866375665852436103479490078532200005483800695633500
195:100:2688530751720639218338659340310475390912005264448667808160
195:101:2528816053598621046952204329995001605313272278441816255200
195:102:2330477539590886062877521637446374028425956805622850274400
195:103:2104217584290800037355432158082648394598194008960437626400
195:104:1861423247641861571506728447534650502913787007926540977200
195:105:1613233481289613361972497987863363769191948740203002180240
195:106:1369726540717596250731366216110403200257314968096888643600
195:107:1139305253494075386122351338633886774045804038884327937200
195:108:928322799143320684988582572220204038111395883535378319200
195:109:740954894729072473339510860395942672621022402454843245600
195:110:579292008606365751883617581764100634958253878282877446560
195:111:443601988572442242433400850900437423166230447333734981600
195:112:332701491429331681825050638175328067374672835500301236200
195:113:244373661846323270721054893527010881345998631385177014200
195:114:175777546240337791220407905870306072547121822575302764600
195:115:123808532569281400772635133699954711967972761987821947240
195:116:85385194875366483291472505999968766874463973784704791200
195:117:57653251240632069914754939948696859684467127598219474400
195:118:38109776243807639435176994203375890299901999598823042400
195:119:24659266981287296105114525661007929017583646799238439200
195:120:15617535754815287533239199585305021711136309639517678160
195:121:9680290757116913760272231147916335771365481181519222000
195:122:5871651770710259166066763155293515140008570552724774000
195:123:3484801457413405846527428539320541505858745124787874000
195:124:2023433104304558233467539151863540229208303620844572000
195:125:1149310003244989076609562238258490850190316456639716896
195:126:638505557358327264783090132365828250105731364799842720
195:127:346904594155311663543568654592457868167680820245583840
195:128:184293065645009321257520847752243242464080435755466415
195:129:95718103862136624219022455809304629806925497640436045
195:130:48595345037700132295811400641646965901977560340529069
195:131:24112194102675638162043824745855364760523216962857935
195:132:11690760777054854866445490785869267762677923375931120
195:133:5537728789131247042000495635411758413900068967546320
195:134:2562232723329382959731572607429321057177643850655760
195:135:1157749600911795263286117992986582107317305739925936
195:136:510771882755203792626228526317609753228223120555560
195:137:219967453157350538430273598925102010514344263596920
195:138:92450089008161820499680208243883453694434545569720
195:139:37911187578886501931523538632383862306350856816360
195:140:15164475031554600772609415452953544922540342726544
195:141:5915220756989383280095871275974787026522828723120
195:142:2249450147024131669895613020441116193184737683440
195:143:833712292253699150380891539044609498173364316240
195:144:301062772202724693193099722432775652118159336420
195:145:105891044016130754157573005821183160400180180396
195:146:36264056169907792519716782815473685068554856300
195:147:12088018723302597506572260938491228356184952100
195:148:3920438504854896488618030574645803791195119600
195:149:1236648387437450570235217698042636095209198800
195:150:379238838814151508205466760733075069197487632
195:151:113018196997594820326132478364161444462827440
195:152:32715793867724816410196243736994102344502680
195:153:9194634877857301344042081573142133338651080
195:154:2507627693961082184738749519947854546904840
195:155:663307970660673352092185356889432493052248
195:156:170078966836070090280047527407546793090320
195:157:42248915328705309050457666043912897646640
195:158:10161131534751909771629058921953734877040
195:159:2364540042678117368240724403221938304720
195:160:532021509602576407854162990724936118562
195:161:115656849913603566924818041461942634470
195:162:24273659858410625157060576603123762790
195:163:4914299235138347424435576858301129890
195:164:958887655636750716963039386985586320
195:165:180154650452965286217298309070019248
195:166:32558069358969630039270778747593840
195:167:5653796475509696234364386728624080
195:168:942299412584949372394064454770680
195:169:150544876566826231092542841886440
195:170:23024510533749894167094787582632
195:171:3366156510782148270043097599800
195:172:469696257318439293494385711600
195:173:62445167157942796244918331600
195:174:7895365962498514467748294800
195:175:947443915499821736129795376
195:176:107664081306797924560204020
195:177:11557161270221246139230940
195:178:1168701701483047362394140
195:179:110994016341965391959220
195:180:9866134785952479285264
195:181:817635479498824250160
195:182:62895036884524942320
195:183:4467953439884285520
195:184:291388267818540360
195:185:17325788897318616
195:186:931494026737560
195:187:44831263318920
195:188:1907713332720
195:189:70656049360
195:190:2231243664
195:191:58409520
195:192:1216865
195:193:18915
195:194:195
195:195:1

# binomial(196, k) for 0 <= k <= 196

196:0:1
196:1:196
196:2:19110
196:3:1235780
196:4:59626385
196:5:2289653184
196:6:72887293024
196:7:1978369382080
196:8:46738976651640
196:9:976325290056480
196:10:18257282924056176
196:11:308714056715858976
196:12:4759341707702825880
196:13:67362990324409227840
196:14:880530516383349192480
196:15:10683770265451303535424
196:16:120860151127917871244484
196:17:1279695717825012754353360
196:18:12725862971704293501625080
196:19:119221242577019170699434960
196:20:1055107996806619660689999396
196:21:8842809877998336203878090176
196:22:70340533120441310712666626400
196:23:532141424476382089739304043200
196:24:3835852768100587563537483311400
196:25:26390667044532042437137885182432
196:26:173569387100576125259637629469072
196:27:1092844289151775603486607296657120
196:28:6596095888094645606758451183394760
196:29:38211865834479326273635165476217920
196:30:212712719811934916256569087817613088
196:31:1139042306089716003180337696055605568
196:32:5873186890775098141398616245286716210
196:33:29187959093548972581496153461424892680
196:34:139930509772014192081878618065066397260
196:35:647678359516179974778981032186878753032
196:36:2896561552280693776094887393946874423282
196:37:12525671577430027139869783325175673181760
196:38:52410046863457218822086724965866632523680
196:39:212327882164775399330505193451459690736960
196:40:833386937496743442372232884296979286142568
196:41:3170935664621755536830934876837287039957088
196:42:11702262571818383528780831093089987885555920
196:43:41910428745582117754238325310136235683153760
196:44:145733990865319636736328722101155546807330120
196:45:492257035811746328531599239097236513660315072
196:46:1615887226251602078440684458775711164406686432
196:47:5157086892292347058853248272688439886404318400
196:48:16008457228157493995190291513137032147380071700
196:49:48352074893210390026289043753964913424739808400
196:50:142155100186038546677289788636656845468735036696
196:51:406953816218855447350672728253958812518339516816
196:52:1134775064456423843573991261477385150291523652660
196:53:3083162439277830820276504559485725691358101999680
196:54:8164670904013514949991484296415903219707566406560
196:55:21079695788543984052705286728928331949063171449664
196:56:53075662610441102704132954085337407228891199542904
196:57:130361276587048322431203746876267316000785402386080
196:58:312417542165512358929953807168985464208778809166640
196:59:730739335912554331056502125242711763742567384152480
196:60:1668521483666999055912346519304191860545528860481496
196:61:3719982324241178223017690600415903164494949590581696
196:62:8099961512460630001732068242841079471077712818202080
196:63:17228489566186101908445986421281026176577992343477440
196:64:35802954879730493028489315531724632523201140338789055
196:65:72707539140375770457855225387502330662500777303387004
196:66:144313448899836756514833856450951595708903057980965114
196:67:280011169507145945476543303561547872271005933395902460
196:68:531197659800320984801089502344701110631761256001050255
196:69:985410151513638928326658786958286118273412185045426560
196:70:1787815560603316341392652370624319100296047821439559616
196:71:3172743107549547310077101390122031079398620077484288896
196:72:5508234561717964079994967691184081735067048745632446000
196:73:9356453228123665012594191694614056645867315677512648000
196:74:15551942527827172926338994303209850911374051734243996000
196:75:25297826511932201293511430733221357482501790821036900160
196:76:40276802736102583638353725246312950728719956438756117360
196:77:62769043225094935540291519864383819317485646398061481600
196:78:95763027484439709349931934152072749984369127197042516800
196:79:143038446115998553206227445948665626558931101382924265600
196:80:209193727444647884064107639699923478842436735772526738440
196:81:299586078809619191993043039570260784515094584563124711840
196:82:420151208086661061941462799397316953893120453960479778800
196:83:577075153275654952546105531702338948720671466885478250400
196:84:776303480001773924258451489075765490540903282834036217800
196:85:1022893997178807994317018432664538058124484325616612428160
196:86:1320246903335438225223128442160043307579276280737720692160
196:87:1669277693872393158328093432616146710732418285990221564800
196:88:2067628052637396071110933910854090812157199922419706256400
196:89:2509031794211671636853717554744289974303119006981216580800
196:90:2982960022007209612703864203973766969449263708299890823840
196:91:3474656728931474933479226435398014272105735748129543157440
196:92:3965640831932661608862160605617298897511981016886978603600
196:93:4434695123881686100232953795529022423024150814583287900800
196:94:4859293593189507109829725967441375633739229084064666529600
196:95:5217346805319260265290863670305476996225277542890484063360
196:96:5489083618096305070774762819800553923112010748249363441660
196:97:5658849090820933062654394659588199920734031699226147878000
196:98:5716592448890534420436582360196242777068052430850904489000
196:99:5658849090820933062654394659588199920734031699226147878000
196:100:5489083618096305070774762819800553923112010748249363441660
196:101:5217346805319260265290863670305476996225277542890484063360
196:102:4859293593189507109829725967441375633739229084064666529600
196:103:4434695123881686100232953795529022423024150814583287900800
196:104:3965640831932661608862160605617298897511981016886978603600
196:105:3474656728931474933479226435398014272105735748129543157440
196:106:2982960022007209612703864203973766969449263708299890823840
196:107:2509031794211671636853717554744289974303119006981216580800
196:108:2067628052637396071110933910854090812157199922419706256400
196:109:1669277693872393158328093432616146710732418285990221564800
196:110:1320246903335438225223128442160043307579276280737720692160
196:111:1022893997178807994317018432664538058124484325616612428160
196:112:776303480001773924258451489075765490540903282834036217800
196:113:577075153275654952546105531702338948720671466885478250400
196:114:420151208086661061941462799397316953893120453960479778800
196:115:299586078809619191993043039570260784515094584563124711840
196:116:209193727444647884064107639699923478842436735772526738440
196:117:143038446115998553206227445948665626558931101382924265600
196:118:95763027484439709349931934152072749984369127197042516800
196:119:62769043225094935540291519864383819317485646398061481600
196:120:40276802736102583638353725246312950728719956438756117360
196:121:25297826511932201293511430733221357482501790821036900160
196:122:15551942527827172926338994303209850911374051734243996000
196:123:9356453228123665012594191694614056645867315677512648000
196:124:5508234561717964079994967691184081735067048745632446000
196:125:3172743107549547310077101390122031079398620077484288896
196:126:1787815560603316341392652370624319100296047821439559616
196:127:985410151513638928326658786958286118273412185045426560
196:128:531197659800320984801089502344701110631761256001050255
196:129:280011169507145945476543303561547872271005933395902460
196:130:144313448899836756514833856450951595708903057980965114
196:131:72707539140375770457855225387502330662500777303387004
196:132:35802954879730493028489315531724632523201140338789055
196:133:17228489566186101908445986421281026176577992343477440
196:134:8099961512460630001732068242841079471077712818202080
196:135:3719982324241178223017690600415903164494949590581696
196:136:1668521483666999055912346519304191860545528860481496
196:137:730739335912554331056502125242711763742567384152480
196:138:312417542165512358929953807168985464208778809166640
196:139:130361276587048322431203746876267316000785402386080
196:140:53075662610441102704132954085337407228891199542904
196:141:21079695788543984052705286728928331949063171449664
196:142:8164670904013514949991484296415903219707566406560
196:143:3083162439277830820276504559485725691358101999680
196:144:1134775064456423843573991261477385150291523652660
196:145:406953816218855447350672728253958812518339516816
196:146:142155100186038546677289788636656845468735036696
196:147:48352074893210390026289043753964913424739808400
196:148:16008457228157493995190291513137032147380071700
196:149:5157086892292347058853248272688439886404318400
196:150:1615887226251602078440684458775711164406686432
196:151:492257035811746328531599239097236513660315072
196:152:145733990865319636736328722101155546807330120
196:153:41910428745582117754238325310136235683153760
196:154:11702262571818383528780831093089987885555920
196:155:3170935664621755536830934876837287039957088
196:156:833386937496743442372232884296979286142568
196:157:212327882164775399330505193451459690736960
196:158:52410046863457218822086724965866632523680
196:159:12525671577430027139869783325175673181760
196:160:2896561552280693776094887393946874423282
196:161:647678359516179974778981032186878753032
196:162:139930509772014192081878618065066397260
196:163:29187959093548972581496153461424892680
196:164:5873186890775098141398616245286716210
196:165:1139042306089716003180337696055605568
196:166:212712719811934916256569087817613088
196:167:38211865834479326273635165476217920
196:168:6596095888094645606758451183394760
196:169:1092844289151775603486607296657120
196:170:173569387100576125259637629469072
196:171:26390667044532042437137885182432
196:172:3835852768100587563537483311400
196:173:532141424476382089739304043200
196:174:70340533120441310712666626400
196:175:8842809877998336203878090176
196:176:1055107996806619660689999396
196:177:119221242577019170699434960
196:178:12725862971704293501625080
196:179:1279695717825012754353360
196:180:120860151127917871244484
196:181:10683770265451303535424
196:182:880530516383349192480
196:183:67362990324409227840
196:184:4759341707702825880
196:185:308714056715858976
196:186:18257282924056176
196:187:976325290056480
196:188:46738976651640
196:189:1978369382080
196:190:72887293024
196:191:2289653184
196:192:59626385
196:193:1235780
196:194:19110
196:195:196
196:196:1

# binomial(197, k) for 0 <= k <= 197

197:0:1
197:1:197
197:2:19306
197:3:1254890
197:4:60862165
197:5:2349279569
197:6:75176946208
197:7:2051256675104
197:8:48717346033720
197:9:1023064266708120
197:10:19233608214112656
197:11:326971339639915152
197:12:5068055764418684856
197:13:72122332032112053720
197:14:947893506707758420320
197:15:11564300781834652727904
197:16:131543921393369174779908
197:17:1400555868952930625597844
197:18:14005558689529306255978440
197:19:131947105548723464201060040
197:20:1174329239383638831389434356
197:21:9897917874804955864568089572
197:22:79183342998439646916544716576
197:23:602481957596823400451970669600
197:24:4367994192576969653276787354600
197:25:30226519812632630000675368493832
197:26:199960054145108167696775514651504
197:27:1266413676252351728746244926126192
197:28:7688940177246421210245058480051880
197:29:44807961722573971880393616659612680
197:30:250924585646414242530204253293831008
197:31:1351755025901650919436906783873218656
197:32:7012229196864814144578953941342321778
197:33:35061145984324070722894769706711608890
197:34:169118468865563164663374771526491289940
197:35:787608869288194166860859650251945150292
197:36:3544239911796873750873868426133753176314
197:37:15422233129710720915964670719122547605042
197:38:64935718440887245961956508291042305705440
197:39:264737929028232618152591918417326323260640
197:40:1045714819661518841702738077748438976879528
197:41:4004322602118498979203167761134266326099656
197:42:14873198236440139065611765969927274925513008
197:43:53612691317400501283019156403226223568709680
197:44:187644419610901754490567047411291782490483880
197:45:637991026677065965267927961198392060467645192
197:46:2108144262063348406972283697872947678067001504
197:47:6772974118543949137293932731464151050811004832
197:48:21165544120449841054043539785825472033784390100
197:49:64360532121367884021479335267101945572119880100
197:50:190507175079248936703578832390621758893474845096
197:51:549108916404893994027962516890615657987074553512
197:52:1541728880675279290924663989731343962809863169476
197:53:4217937503734254663850495820963110841649625652340
197:54:11247833343291345770267988855901628911065668406240
197:55:29244366692557499002696771025344235168770737856224
197:56:74155358398985086756838240814265739177954370992568
197:57:183436939197489425135336700961604723229676601928984
197:58:442778818752560681361157554045252780209564211552720
197:59:1043156878078066689986455932411697227951346193319120
197:60:2399260819579553386968848644546903624288096244633976
197:61:5388503807908177278930037119720095025040478451063192
197:62:11819943836701808224749758843256982635572662408783776
197:63:25328451078646731910178054664122105647655705161679520
197:64:53031444445916594936935301953005658699779132682266495
197:65:108510494020106263486344540919226963185701917642176059
197:66:217020988040212526972689081838453926371403835284352118
197:67:424324618406982701991377160012499467979908991376867574
197:68:811208829307466930277632805906248982902767189396952715
197:69:1516607811313959913127748289302987228905173441046476815
197:70:2773225712116955269719311157582605218569460006484986176
197:71:4960558668152863651469753760746350179694667898923848512
197:72:8680977669267511390072069081306112814465668823116734896
197:73:14864687789841629092589159385798138380934364423145094000
197:74:24908395755950837938933185997823907557241367411756644000
197:75:40849769039759374219850425036431208393875842555280896160
197:76:65574629248034784931865155979534308211221747259793017520
197:77:103045845961197519178645245110696770046205602836817598960
197:78:158532070709534644890223454016456569301854773595103998400
197:79:238801473600438262556159380100738376543300228579966782400
197:80:352232173560646437270335085648589105401367837155451004040
197:81:508779806254267076057150679270184263357531320335651450280
197:82:719737286896280253934505838967577738408215038523604490640
197:83:997226361362316014487568331099655902613791920845958029200
197:84:1353378633277428876804557020778104439261574749719514468200
197:85:1799197477180581918575469921740303548665387608450648645960
197:86:2343140900514246219540146874824581365703760606354333120320
197:87:2989524597207831383551221874776190018311694566727942256960
197:88:3736905746509789229439027343470237522889618208409927821200
197:89:4576659846849067707964651465598380786460318929400922837200
197:90:5491991816218881249557581758718056943752382715281107404640
197:91:6457616750938684546183090639371781241554999456429433981280
197:92:7440297560864136542341387041015313169617716765016521761040
197:93:8400335955814347709095114401146321320536131831470266504400
197:94:9293988717071193210062679762970398056763379898647954430400
197:95:10076640398508767375120589637746852629964506626955150592960
197:96:10706430423415565336065626490106030919337288291139847505020
197:97:11147932708917238133429157479388753843846042447475511319660
197:98:11375441539711467483090977019784442697802084130077052367000
197:99:11375441539711467483090977019784442697802084130077052367000
197:100:11147932708917238133429157479388753843846042447475511319660
197:101:10706430423415565336065626490106030919337288291139847505020
197:102:10076640398508767375120589637746852629964506626955150592960
197:103:9293988717071193210062679762970398056763379898647954430400
197:104:8400335955814347709095114401146321320536131831470266504400
197:105:7440297560864136542341387041015313169617716765016521761040
197:106:6457616750938684546183090639371781241554999456429433981280
197:107:5491991816218881249557581758718056943752382715281107404640
197:108:4576659846849067707964651465598380786460318929400922837200
197:109:3736905746509789229439027343470237522889618208409927821200
197:110:2989524597207831383551221874776190018311694566727942256960
197:111:2343140900514246219540146874824581365703760606354333120320
197:112:1799197477180581918575469921740303548665387608450648645960
197:113:1353378633277428876804557020778104439261574749719514468200
197:114:997226361362316014487568331099655902613791920845958029200
197:115:719737286896280253934505838967577738408215038523604490640
197:116:508779806254267076057150679270184263357531320335651450280
197:117:352232173560646437270335085648589105401367837155451004040
197:118:238801473600438262556159380100738376543300228579966782400
197:119:158532070709534644890223454016456569301854773595103998400
197:120:103045845961197519178645245110696770046205602836817598960
197:121:65574629248034784931865155979534308211221747259793017520
197:122:40849769039759374219850425036431208393875842555280896160
197:123:24908395755950837938933185997823907557241367411756644000
197:124:14864687789841629092589159385798138380934364423145094000
197:125:8680977669267511390072069081306112814465668823116734896
197:126:4960558668152863651469753760746350179694667898923848512
197:127:2773225712116955269719311157582605218569460006484986176
197:128:1516607811313959913127748289302987228905173441046476815
197:129:811208829307466930277632805906248982902767189396952715
197:130:424324618406982701991377160012499467979908991376867574
197:131:217020988040212526972689081838453926371403835284352118
197:132:108510494020106263486344540919226963185701917642176059
197:133:53031444445916594936935301953005658699779132682266495
197:134:25328451078646731910178054664122105647655705161679520
197:135:11819943836701808224749758843256982635572662408783776
197:136:5388503807908177278930037119720095025040478451063192
197:137:2399260819579553386968848644546903624288096244633976
197:138:1043156878078066689986455932411697227951346193319120
197:139:442778818752560681361157554045252780209564211552720
197:140:183436939197489425135336700961604723229676601928984
197:141:74155358398985086756838240814265739177954370992568
197:142:29244366692557499002696771025344235168770737856224
197:143:11247833343291345770267988855901628911065668406240
197:144:4217937503734254663850495820963110841649625652340
197:145:1541728880675279290924663989731343962809863169476
197:146:549108916404893994027962516890615657987074553512
197:147:190507175079248936703578832390621758893474845096
197:148:64360532121367884021479335267101945572119880100
197:149:21165544120449841054043539785825472033784390100
197:150:6772974118543949137293932731464151050811004832
197:151:2108144262063348406972283697872947678067001504
197:152:637991026677065965267927961198392060467645192
197:153:187644419610901754490567047411291782490483880
197:154:53612691317400501283019156403226223568709680
197:155:14873198236440139065611765969927274925513008
197:156:4004322602118498979203167761134266326099656
197:157:1045714819661518841702738077748438976879528
197:158:264737929028232618152591918417326323260640
197:159:64935718440887245961956508291042305705440
197:160:15422233129710720915964670719122547605042
197:161:3544239911796873750873868426133753176314
197:162:787608869288194166860859650251945150292
197:163:169118468865563164663374771526491289940
197:164:35061145984324070722894769706711608890
197:165:7012229196864814144578953941342321778
197:166:1351755025901650919436906783873218656
197:167:250924585646414242530204253293831008
197:168:44807961722573971880393616659612680
197:169:7688940177246421210245058480051880
197:170:1266413676252351728746244926126192
197:171:199960054145108167696775514651504
197:172:30226519812632630000675368493832
197:173:4367994192576969653276787354600
197:174:602481957596823400451970669600
197:175:79183342998439646916544716576
197:176:9897917874804955864568089572
197:177:1174329239383638831389434356
197:178:131947105548723464201060040
197:179:14005558689529306255978440
197:180:1400555868952930625597844
197:181:131543921393369174779908
197:182:11564300781834652727904
197:183:947893506707758420320
197:184:72122332032112053720
197:185:5068055764418684856
197:186:326971339639915152
197:187:19233608214112656
197:188:1023064266708120
197:189:48717346033720
197:190:2051256675104
197:191:75176946208
197:192:2349279569
197:193:60862165
197:194:1254890
197:195:19306
197:196:197
197:197:1

# binomial(198, k) for 0 <= k <= 198

198:0:1
198:1:198
198:2:19503
198:3:1274196
198:4:62117055
198:5:2410141734
198:6:77526225777
198:7:2126433621312
198:8:50768602708824
198:9:1071781612741840
198:10:20256672480820776
198:11:346204947854027808
198:12:5395027104058600008
198:13:77190387796530738576
198:14:1020015838739870474040
198:15:12512194288542411148224
198:16:143108222175203827507812
198:17:1532099790346299800377752
198:18:15406114558482236881576284
198:19:145952664238252770457038480
198:20:1306276344932362295590494396
198:21:11072247114188594695957523928
198:22:89081260873244602781112806148
198:23:681665300595263047368515386176
198:24:4970476150173793053728758024200
198:25:34594514005209599653952155848432
198:26:230186573957740797697450883145336
198:27:1466373730397459896443020440777696
198:28:8955353853498772938991303406178072
198:29:52496901899820393090638675139664560
198:30:295732547368988214410597869953443688
198:31:1602679611548065161967111037167049664
198:32:8363984222766465064015860725215540434
198:33:42073375181188884867473723648053930668
198:34:204179614849887235386269541233202898830
198:35:956727338153757331524234421778436440232
198:36:4331848781085067917734728076385698326606
198:37:18966473041507594666838539145256300781356
198:38:80357951570597966877921179010164853310482
198:39:329673647469119864114548426708368628966080
198:40:1310452748689751459855329996165765300140168
198:41:5050037421780017820905905838882705302979184
198:42:18877520838558638044814933731061541251612664
198:43:68485889553840640348630922373153498494222688
198:44:241257110928302255773586203814518006059193560
198:45:825635446287967719758495008609683842958129072
198:46:2746135288740414372240211659071339738534646696
198:47:8881118380607297544266216429337098728878006336
198:48:27938518238993790191337472517289623084595394932
198:49:85526076241817725075522875052927417605904270200
198:50:254867707200616820725058167657723704465594725196
198:51:739616091484142930731541349281237416880549398608
198:52:2090837797080173284952626506621959620796937722988
198:53:5759666384409533954775159810694454804459488821816
198:54:15465770847025600434118484676864739752715294058580
198:55:40492200035848844772964759881245864079836406262464
198:56:103399725091542585759535011839609974346725108848792
198:57:257592297596474511892174941775870462407630972921552
198:58:626215757950050106496494255006857503439240813481704
198:59:1485935696830627371347613486456950008160910404871840
198:60:3442417697657620076955304576958600852239442437953096
198:61:7787764627487730665898885764266998649328574695697168
198:62:17208447644609985503679795962977077660613140859846968
198:63:37148394915348540134927813507379088283228367570463296
198:64:78359895524563326847113356617127764347434837843946015
198:65:161541938466022858423279842872232621885481050324442554
198:66:325531482060318790459033622757680889557105752926528177
198:67:641345606447195228964066241850953394351312826661219692
198:68:1235533447714449632269009965918748450882676180773820289
198:69:2327816640621426843405381095209236211807940630443429530
198:70:4289833523430915182847059446885592447474633447531462991
198:71:7733784380269818921189064918328955398264127905408834688
198:72:13641536337420375041541822842052462994160336722040583408
198:73:23545665459109140482661228467104251195400033246261828896
198:74:39773083545792467031522345383622045938175731834901738000
198:75:65758164795710212158783611034255115951117209967037540160
198:76:106424398287794159151715581015965516605097589815073913680
198:77:168620475209232304110510401090231078257427350096610616480
198:78:261577916670732164068868699127153339348060376431921597360
198:79:397333544309972907446382834117194945845155002175070780800
198:80:591033647161084699826494465749327481944668065735417786440
198:81:861011979814913513327485764918773368758899157491102454320
198:82:1228517093150547329991656518237762001765746358859255940920
198:83:1716963648258596268422074170067233641022006959369562519840
198:84:2350604994639744891292125351877760341875366670565472497400
198:85:3152576110458010795380026942518407987926962358170163114160
198:86:4142338377694828138115616796564884914369148214804981766280
198:87:5332665497722077603091368749600771384015455173082275377280
198:88:6726430343717620612990249218246427541201312775137870078160
198:89:8313565593358856937403678809068618309349937137810850658400
198:90:10068651663067948957522233224316437730212701644682030241840
198:91:11949608567157565795740672398089838185307382171710541385920
198:92:13897914311802821088524477680387094411172716221445955742320
198:93:15840633516678484251436501442161634490153848596486788265440
198:94:17694324672885540919157794164116719377299511730118220934800
198:95:19370629115579960585183269400717250686727886525603105023360
198:96:20783070821924332711186216127852883549301794918094998097980
198:97:21854363132332803469494783969494784763183330738615358824680
198:98:22523374248628705616520134499173196541648126577552563686660
198:99:22750883079422934966181954039568885395604168260154104734000
198:100:22523374248628705616520134499173196541648126577552563686660
198:101:21854363132332803469494783969494784763183330738615358824680
198:102:20783070821924332711186216127852883549301794918094998097980
198:103:19370629115579960585183269400717250686727886525603105023360
198:104:17694324672885540919157794164116719377299511730118220934800
198:105:15840633516678484251436501442161634490153848596486788265440
198:106:13897914311802821088524477680387094411172716221445955742320
198:107:11949608567157565795740672398089838185307382171710541385920
198:108:10068651663067948957522233224316437730212701644682030241840
198:109:8313565593358856937403678809068618309349937137810850658400
198:110:6726430343717620612990249218246427541201312775137870078160
198:111:5332665497722077603091368749600771384015455173082275377280
198:112:4142338377694828138115616796564884914369148214804981766280
198:113:3152576110458010795380026942518407987926962358170163114160
198:114:2350604994639744891292125351877760341875366670565472497400
198:115:1716963648258596268422074170067233641022006959369562519840
198:116:1228517093150547329991656518237762001765746358859255940920
198:117:861011979814913513327485764918773368758899157491102454320
198:118:591033647161084699826494465749327481944668065735417786440
198:119:397333544309972907446382834117194945845155002175070780800
198:120:261577916670732164068868699127153339348060376431921597360
198:121:168620475209232304110510401090231078257427350096610616480
198:122:106424398287794159151715581015965516605097589815073913680
198:123:65758164795710212158783611034255115951117209967037540160
198:124:39773083545792467031522345383622045938175731834901738000
198:125:23545665459109140482661228467104251195400033246261828896
198:126:13641536337420375041541822842052462994160336722040583408
198:127:7733784380269818921189064918328955398264127905408834688
198:128:4289833523430915182847059446885592447474633447531462991
198:129:2327816640621426843405381095209236211807940630443429530
198:130:1235533447714449632269009965918748450882676180773820289
198:131:641345606447195228964066241850953394351312826661219692
198:132:325531482060318790459033622757680889557105752926528177
198:133:161541938466022858423279842872232621885481050324442554
198:134:78359895524563326847113356617127764347434837843946015
198:135:37148394915348540134927813507379088283228367570463296
198:136:17208447644609985503679795962977077660613140859846968
198:137:7787764627487730665898885764266998649328574695697168
198:138:3442417697657620076955304576958600852239442437953096
198:139:1485935696830627371347613486456950008160910404871840
198:140:626215757950050106496494255006857503439240813481704
198:141:257592297596474511892174941775870462407630972921552
198:142:103399725091542585759535011839609974346725108848792
198:143:40492200035848844772964759881245864079836406262464
198:144:15465770847025600434118484676864739752715294058580
198:145:5759666384409533954775159810694454804459488821816
198:146:2090837797080173284952626506621959620796937722988
198:147:739616091484142930731541349281237416880549398608
198:148:254867707200616820725058167657723704465594725196
198:149:85526076241817725075522875052927417605904270200
198:150:27938518238993790191337472517289623084595394932
198:151:8881118380607297544266216429337098728878006336
198:152:2746135288740414372240211659071339738534646696
198:153:825635446287967719758495008609683842958129072
198:154:241257110928302255773586203814518006059193560
198:155:68485889553840640348630922373153498494222688
198:156:18877520838558638044814933731061541251612664
198:157:5050037421780017820905905838882705302979184
198:158:1310452748689751459855329996165765300140168
198:159:329673647469119864114548426708368628966080
198:160:80357951570597966877921179010164853310482
198:161:18966473041507594666838539145256300781356
198:162:4331848781085067917734728076385698326606
198:163:956727338153757331524234421778436440232
198:164:204179614849887235386269541233202898830
198:165:42073375181188884867473723648053930668
198:166:8363984222766465064015860725215540434
198:167:1602679611548065161967111037167049664
198:168:295732547368988214410597869953443688
198:169:52496901899820393090638675139664560
198:170:8955353853498772938991303406178072
198:171:1466373730397459896443020440777696
198:172:230186573957740797697450883145336
198:173:34594514005209599653952155848432
198:174:4970476150173793053728758024200
198:175:681665300595263047368515386176
198:176:89081260873244602781112806148
198:177:11072247114188594695957523928
198:178:1306276344932362295590494396
198:179:145952664238252770457038480
198:180:15406114558482236881576284
198:181:1532099790346299800377752
198:182:143108222175203827507812
198:183:12512194288542411148224
198:184:1020015838739870474040
198:185:77190387796530738576
198:186:5395027104058600008
198:187:346204947854027808
198:188:20256672480820776
198:189:1071781612741840
198:190:50768602708824
198:191:2126433621312
198:192:77526225777
198:193:2410141734
198:194:62117055
198:195:1274196
198:196:19503
198:197:198
198:198:1

# binomial(199, k) for 0 <= k <= 199

199:0:1
199:1:199
199:2:19701
199:3:1293699
199:4:63391251
199:5:2472258789
199:6:79936367511
199:7:2203959847089
199:8:52895036330136
199:9:1122550215450664
199:10:21328454093562616
199:11:366461620334848584
199:12:5741232051912627816
199:13:82585414900589338584
199:14:1097206226536401212616
199:15:13532210127282281622264
199:16:155620416463746238656036
199:17:1675208012521503627885564
199:18:16938214348828536681954036
199:19:161358778796735007338614764
199:20:1452229009170615066047532876
199:21:12378523459120956991548018324
199:22:100153507987433197477070330076
199:23:770746561468507650149628192324
199:24:5652141450769056101097273410376
199:25:39564990155383392707680913872632
199:26:264781087962950397351403038993768
199:27:1696560304355200694140471323923032
199:28:10421727583896232835434323846955768
199:29:61452255753319166029629978545842632
199:30:348229449268808607501236545093108248
199:31:1898412158917053376377708907120493352
199:32:9966663834314530225982971762382590098
199:33:50437359403955349931489584373269471102
199:34:246252990031076120253743264881256829498
199:35:1160906953003644566910503963011639339062
199:36:5288576119238825249258962498164134766838
199:37:23298321822592662584573267221641999107962
199:38:99324424612105561544759718155421154091838
199:39:410031599039717830992469605718533482276562
199:40:1640126396158871323969878422874133929106248
199:41:6360490170469769280761235835048470603119352
199:42:23927558260338655865720839569944246554591848
199:43:87363410392399278393445856104215039745835352
199:44:309743000482142896122217126187671504553416248
199:45:1066892557216269975532081212424201849017322632
199:46:3571770735028382091998706667681023581492775768
199:47:11627253669347711916506428088408438467412653032
199:48:36819636619601087735603688946626721813473401268
199:49:113464594480811515266860347570217040690499665132
199:50:340393783442434545800581042710651122071498995396
199:51:994483798684759751456599516938961121346144123804
199:52:2830453888564316215684167855903197037677487121596
199:53:7850504181489707239727786317316414425256426544804
199:54:21225437231435134388893644487559194557174782880396
199:55:55957970882874445207083244558110603832551700321044
199:56:143891925127391430532499771720855838426561515111256
199:57:360992022688017097651709953615480436754356081770344
199:58:883808055546524618388669196782727965846871786403256
199:59:2112151454780677477844107741463807511600151218353544
199:60:4928353394488247448302918063415550860400352842824936
199:61:11230182325145350742854190341225599501568017133650264
199:62:24996212272097716169578681727244076309941715555544136
199:63:54356842559958525638607609470356165943841508430310264
199:64:115508290439911866982041170124506852630663205414409311
199:65:239901833990586185270393199489360386232915888168388569
199:66:487073420526341648882313465629913511442586803250970731
199:67:966877088507514019423099864608634283908418579587747869
199:68:1876879054161644861233076207769701845233989007435039981
199:69:3563350088335876475674391061127984662690616811217249819
199:70:6617650164052342026252440542094828659282574077974892521
199:71:12023617903700734104036124365214547845738761352940297679
199:72:21375320717690193962730887760381418392424464627449418096
199:73:37187201796529515524203051309156714189560369968302412304
199:74:63318749004901607514183573850726297133575765081163566896
199:75:105531248341502679190305956417877161889292941801939278160
199:76:172182563083504371310499192050220632556214799782111453840
199:77:275044873497026463262225982106196594862524939911684530160
199:78:430198391879964468179379100217384417605487726528532213840
199:79:658911460980705071515251533244348285193215378606992378160
199:80:988367191471057607272877299866522427789823067910488567240
199:81:1452045626975998213153980230668100850703567223226520240760
199:82:2089529072965460843319142283156535370524645516350358395240
199:83:2945480741409143598413730688304995642787753318228818460760
199:84:4067568642898341159714199521944993982897373629935035017240
199:85:5503181105097755686672152294396168329802329028735635611560
199:86:7294914488152838933495643739083292902296110572975144880440
199:87:9475003875416905741206985546165656298384603387887257143560
199:88:12059095841439698216081617967847198925216767948220145455440
199:89:15039995937076477550393928027315045850551249912948720736560
199:90:18382217256426805894925912033385056039562638782492880900240
199:91:22018260230225514753262905622406275915520083816392571627760
199:92:25847522878960386884265150078476932596480098393156497128240
199:93:29738547828481305339960979122548728901326564817932744007760
199:94:33534958189564025170594295606278353867453360326605009200240
199:95:37064953788465501504341063564833970064027398255721325958160
199:96:40153699937504293296369485528570134236029681443698103121340
199:97:42637433954257136180681000097347668312485125656710356922660
199:98:44377737380961509086014918468667981304831457316167922511340
199:99:45274257328051640582702088538742081937252294837706668420660
199:100:45274257328051640582702088538742081937252294837706668420660
199:101:44377737380961509086014918468667981304831457316167922511340
199:102:42637433954257136180681000097347668312485125656710356922660
199:103:40153699937504293296369485528570134236029681443698103121340
199:104:37064953788465501504341063564833970064027398255721325958160
199:105:33534958189564025170594295606278353867453360326605009200240
199:106:29738547828481305339960979122548728901326564817932744007760
199:107:25847522878960386884265150078476932596480098393156497128240
199:108:22018260230225514753262905622406275915520083816392571627760
199:109:18382217256426805894925912033385056039562638782492880900240
199:110:15039995937076477550393928027315045850551249912948720736560
199:111:12059095841439698216081617967847198925216767948220145455440
199:112:9475003875416905741206985546165656298384603387887257143560
199:113:7294914488152838933495643739083292902296110572975144880440
199:114:5503181105097755686672152294396168329802329028735635611560
199:115:4067568642898341159714199521944993982897373629935035017240
199:116:2945480741409143598413730688304995642787753318228818460760
199:117:2089529072965460843319142283156535370524645516350358395240
199:118:1452045626975998213153980230668100850703567223226520240760
199:119:988367191471057607272877299866522427789823067910488567240
199:120:658911460980705071515251533244348285193215378606992378160
199:121:430198391879964468179379100217384417605487726528532213840
199:122:275044873497026463262225982106196594862524939911684530160
199:123:172182563083504371310499192050220632556214799782111453840
199:124:105531248341502679190305956417877161889292941801939278160
199:125:63318749004901607514183573850726297133575765081163566896
199:126:37187201796529515524203051309156714189560369968302412304
199:127:21375320717690193962730887760381418392424464627449418096
199:128:12023617903700734104036124365214547845738761352940297679
199:129:6617650164052342026252440542094828659282574077974892521
199:130:3563350088335876475674391061127984662690616811217249819
199:131:1876879054161644861233076207769701845233989007435039981
199:132:966877088507514019423099864608634283908418579587747869
199:133:487073420526341648882313465629913511442586803250970731
199:134:239901833990586185270393199489360386232915888168388569
199:135:115508290439911866982041170124506852630663205414409311
199:136:54356842559958525638607609470356165943841508430310264
199:137:24996212272097716169578681727244076309941715555544136
199:138:11230182325145350742854190341225599501568017133650264
199:139:4928353394488247448302918063415550860400352842824936
199:140:2112151454780677477844107741463807511600151218353544
199:141:883808055546524618388669196782727965846871786403256
199:142:360992022688017097651709953615480436754356081770344
199:143:143891925127391430532499771720855838426561515111256
199:144:55957970882874445207083244558110603832551700321044
199:145:21225437231435134388893644487559194557174782880396
199:146:7850504181489707239727786317316414425256426544804
199:147:2830453888564316215684167855903197037677487121596
199:148:994483798684759751456599516938961121346144123804
199:149:340393783442434545800581042710651122071498995396
199:150:113464594480811515266860347570217040690499665132
199:151:36819636619601087735603688946626721813473401268
199:152:11627253669347711916506428088408438467412653032
199:153:3571770735028382091998706667681023581492775768
199:154:1066892557216269975532081212424201849017322632
199:155:309743000482142896122217126187671504553416248
199:156:87363410392399278393445856104215039745835352
199:157:23927558260338655865720839569944246554591848
199:158:6360490170469769280761235835048470603119352
199:159:1640126396158871323969878422874133929106248
199:160:410031599039717830992469605718533482276562
199:161:99324424612105561544759718155421154091838
199:162:23298321822592662584573267221641999107962
199:163:5288576119238825249258962498164134766838
199:164:1160906953003644566910503963011639339062
199:165:246252990031076120253743264881256829498
199:166:50437359403955349931489584373269471102
199:167:9966663834314530225982971762382590098
199:168:1898412158917053376377708907120493352
199:169:348229449268808607501236545093108248
199:170:61452255753319166029629978545842632
199:171:10421727583896232835434323846955768
199:172:1696560304355200694140471323923032
199:173:264781087962950397351403038993768
199:174:39564990155383392707680913872632
199:175:5652141450769056101097273410376
199:176:770746561468507650149628192324
199:177:100153507987433197477070330076
199:178:12378523459120956991548018324
199:179:1452229009170615066047532876
199:180:161358778796735007338614764
199:181:16938214348828536681954036
199:182:1675208012521503627885564
199:183:155620416463746238656036
199:184:13532210127282281622264
199:185:1097206226536401212616
199:186:82585414900589338584
199:187:5741232051912627816
199:188:366461620334848584
199:189:21328454093562616
199:190:1122550215450664
199:191:52895036330136
199:192:2203959847089
199:193:79936367511
199:194:2472258789
199:195:63391251
199:196:1293699
199:197:19701
199:198:199
199:199:1

# binomial(200, k) for 0 <= k <= 200

200:0:1
200:1:200
200:2:19900
200:3:1313400
200:4:64684950
200:5:2535650040
200:6:82408626300
200:7:2283896214600
200:8:55098996177225
200:9:1175445251780800
200:10:22451004309013280
200:11:387790074428411200
200:12:6107693672247476400
200:13:88326646952501966400
200:14:1179791641436990551200
200:15:14629416353818682834880
200:16:169152626591028520278300
200:17:1830828428985249866541600
200:18:18613422361350040309839600
200:19:178296993145563544020568800
200:20:1613587787967350073386147640
200:21:13830752468291572057595551200
200:22:112532031446554154468618348400
200:23:870900069455940847626698522400
200:24:6422888012237563751246901602700
200:25:45217131606152448808778187283008
200:26:304346078118333790059083952866400
200:27:1961341392318151091491874362916800
200:28:12118287888251433529574795170878800
200:29:71873983337215398865064302392798400
200:30:409681705022127773530866523638950880
200:31:2246641608185861983878945452213601600
200:32:11865075993231583602360680669503083450
200:33:60404023238269880157472556135652061200
200:34:296690349435031470185232849254526300600
200:35:1407159943034720687164247227892896168560
200:36:6449483072242469816169466461175774105900
200:37:28586897941831487833832229719806133874800
200:38:122622746434698224129332985377063153199800
200:39:509356023651823392537229323873954636368400
200:40:2050157995198589154962348028592667411382810
200:41:8000616566628640604731114257922604532225600
200:42:30288048430808425146482075404992717157711200
200:43:111290968652737934259166695674159286300427200
200:44:397106410874542174515662982291886544299251600
200:45:1376635557698412871654298338611873353570738880
200:46:4638663292244652067530787880105225430510098400
200:47:15199024404376094008505134756089462048905428800
200:48:48446890288948799652110117035035160280886054300
200:49:150284231100412603002464036516843762503973066400
200:50:453858377923246061067441390280868162761998660528
200:51:1334877582127194297257180559649612243417643119200
200:52:3824937687249075967140767372842158159023631245400
200:53:10680958070054023455411954173219611462933913666400
200:54:29075941412924841628621430804875608982431209425200
200:55:77183408114309579595976889045669798389726483201440
200:56:199849896010265875739583016278966442259113215432300
200:57:504883947815408528184209725336336275180917596881600
200:58:1244800078234541716040379150398208402601227868173600
200:59:2995959510327202096232776938246535477447023004756800
200:60:7040504849268924926147025804879358372000504061178480
200:61:16158535719633598191157108404641150361968369976475200
200:62:36226394597243066912432872068469675811509732689194400
200:63:79353054832056241808186291197600242253783223985854400
200:64:169865132999870392620648779594863018574504713844719575
200:65:355410124430498052252434369613867238863579093582797880
200:66:726975254516927834152706665119273897675502691419359300
200:67:1453950509033855668305413330238547795351005382838718600
200:68:2843756142669158880656176072378336129142407587022787850
200:69:5440229142497521336907467268897686507924605818652289800
200:70:10181000252388218501926831603222813321973190889192142340
200:71:18641268067753076130288564907309376505021335430915190200
200:72:33398938621390928066767012125595966238163225980389715775
200:73:58562522514219709486933939069538132581984834595751830400
200:74:100505950801431123038386625159883011323136135049465979200
200:75:168849997346404286704489530268603459022868706883102845056
200:76:277713811425007050500805148468097794445507741584050732000
200:77:447227436580530834572725174156417227418739739693795984000
200:78:705243265376990931441605082323581012468012666440216744000
200:79:1089109852860669539694630633461732702798703105135524592000
200:80:1647278652451762678788128833110870712983038446517480945400
200:81:2440412818447055820426857530534623278493390291137008808000
200:82:3541574699941459056473122513824636221228212739576878636000
200:83:5035009814374604441732872971461531013312398834579176856000
200:84:7013049384307484758127930210249989625685126948163853478000
200:85:9570749747996096846386351816341162312699702658670670628800
200:86:12798095593250594620167796033479461232098439601710780492000
200:87:16769918363569744674702629285248949200680713960862402024000
200:88:21534099716856603957288603514012855223601371336107402599000
200:89:27099091778516175766475545995162244775768017861168866192000
200:90:33422213193503283445319840060700101890113888695441601636800
200:91:40400477486652320648188817655791331955082722598885452528000
200:92:47865783109185901637528055700883208512000182209549068756000
200:93:55586070707441692224226129201025661497806663211089241136000
200:94:63273506018045330510555274728827082768779925144537753208000
200:95:70599911978029526674935359171112323931480758582326335158400
200:96:77218653725969794800710549093404104300057079699419429079500
200:97:82791133891761429477050485625917802548514807100408460044000
200:98:87015171335218645266695918566015649617316582972878279434000
200:99:89651994709013149668717007007410063242083752153874590932000
200:100:90548514656103281165404177077484163874504589675413336841320
200:101:89651994709013149668717007007410063242083752153874590932000
200:102:87015171335218645266695918566015649617316582972878279434000
200:103:82791133891761429477050485625917802548514807100408460044000
200:104:77218653725969794800710549093404104300057079699419429079500
200:105:70599911978029526674935359171112323931480758582326335158400
200:106:63273506018045330510555274728827082768779925144537753208000
200:107:55586070707441692224226129201025661497806663211089241136000
200:108:47865783109185901637528055700883208512000182209549068756000
200:109:40400477486652320648188817655791331955082722598885452528000
200:110:33422213193503283445319840060700101890113888695441601636800
200:111:27099091778516175766475545995162244775768017861168866192000
200:112:21534099716856603957288603514012855223601371336107402599000
200:113:16769918363569744674702629285248949200680713960862402024000
200:114:12798095593250594620167796033479461232098439601710780492000
200:115:9570749747996096846386351816341162312699702658670670628800
200:116:7013049384307484758127930210249989625685126948163853478000
200:117:5035009814374604441732872971461531013312398834579176856000
200:118:3541574699941459056473122513824636221228212739576878636000
200:119:2440412818447055820426857530534623278493390291137008808000
200:120:1647278652451762678788128833110870712983038446517480945400
200:121:1089109852860669539694630633461732702798703105135524592000
200:122:705243265376990931441605082323581012468012666440216744000
200:123:447227436580530834572725174156417227418739739693795984000
200:124:277713811425007050500805148468097794445507741584050732000
200:125:168849997346404286704489530268603459022868706883102845056
200:126:100505950801431123038386625159883011323136135049465979200
200:127:58562522514219709486933939069538132581984834595751830400
200:128:33398938621390928066767012125595966238163225980389715775
200:129:18641268067753076130288564907309376505021335430915190200
200:130:10181000252388218501926831603222813321973190889192142340
200:131:5440229142497521336907467268897686507924605818652289800
200:132:2843756142669158880656176072378336129142407587022787850
200:133:1453950509033855668305413330238547795351005382838718600
200:134:726975254516927834152706665119273897675502691419359300
200:135:355410124430498052252434369613867238863579093582797880
200:136:169865132999870392620648779594863018574504713844719575
200:137:79353054832056241808186291197600242253783223985854400
200:138:36226394597243066912432872068469675811509732689194400
200:139:16158535719633598191157108404641150361968369976475200
200:140:7040504849268924926147025804879358372000504061178480
200:141:2995959510327202096232776938246535477447023004756800
200:142:1244800078234541716040379150398208402601227868173600
200:143:504883947815408528184209725336336275180917596881600
200:144:199849896010265875739583016278966442259113215432300
200:145:77183408114309579595976889045669798389726483201440
200:146:29075941412924841628621430804875608982431209425200
200:147:10680958070054023455411954173219611462933913666400
200:148:3824937687249075967140767372842158159023631245400
200:149:1334877582127194297257180559649612243417643119200
200:150:453858377923246061067441390280868162761998660528
200:151:150284231100412603002464036516843762503973066400
200:152:48446890288948799652110117035035160280886054300
200:153:15199024404376094008505134756089462048905428800
200:154:4638663292244652067530787880105225430510098400
200:155:1376635557698412871654298338611873353570738880
200:156:397106410874542174515662982291886544299251600
200:157:111290968652737934259166695674159286300427200
200:158:30288048430808425146482075404992717157711200
200:159:8000616566628640604731114257922604532225600
200:160:2050157995198589154962348028592667411382810
200:161:509356023651823392537229323873954636368400
200:162:122622746434698224129332985377063153199800
200:163:28586897941831487833832229719806133874800
200:164:6449483072242469816169466461175774105900
200:165:1407159943034720687164247227892896168560
200:166:296690349435031470185232849254526300600
200:167:60404023238269880157472556135652061200
200:168:11865075993231583602360680669503083450
200:169:2246641608185861983878945452213601600
200:170:409681705022127773530866523638950880
200:171:71873983337215398865064302392798400
200:172:12118287888251433529574795170878800
200:173:1961341392318151091491874362916800
200:174:304346078118333790059083952866400
200:175:45217131606152448808778187283008
200:176:6422888012237563751246901602700
200:177:870900069455940847626698522400
200:178:112532031446554154468618348400
200:179:13830752468291572057595551200
200:180:1613587787967350073386147640
200:181:178296993145563544020568800
200:182:18613422361350040309839600
200:183:1830828428985249866541600
200:184:169152626591028520278300
200:185:14629416353818682834880
200:186:1179791641436990551200
200:187:88326646952501966400
200:188:6107693672247476400
200:189:387790074428411200
200:190:22451004309013280
200:191:1175445251780800
200:192:55098996177225
200:193:2283896214600
200:194:82408626300
200:195:2535650040
200:196:64684950
200:197:1313400
200:198:19900
200:199:200
200:200:1
