//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QDATETIME_C_H
#define QDATETIME_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QDateH QDate_create();
C_EXPORT void QDate_destroy(QDateH handle);
C_EXPORT QDateH QDate_create2(int y, int m, int d);
C_EXPORT bool QDate_isNull(QDateH handle);
C_EXPORT bool QDate_isValid(QDateH handle);
C_EXPORT int QDate_year(QDateH handle);
C_EXPORT int QDate_month(QDateH handle);
C_EXPORT int QDate_day(QDateH handle);
C_EXPORT int QDate_dayOfWeek(QDateH handle);
C_EXPORT int QDate_dayOfYear(QDateH handle);
C_EXPORT int QDate_daysInMonth(QDateH handle);
C_EXPORT int QDate_daysInYear(QDateH handle);
C_EXPORT int QDate_weekNumber(QDateH handle, int* yearNum);
C_EXPORT void QDate_shortMonthName(PWideString retval, int month);
C_EXPORT void QDate_shortMonthName2(PWideString retval, int month, QDate::MonthNameType type);
C_EXPORT void QDate_shortDayName(PWideString retval, int weekday);
C_EXPORT void QDate_shortDayName2(PWideString retval, int weekday, QDate::MonthNameType type);
C_EXPORT void QDate_longMonthName(PWideString retval, int month);
C_EXPORT void QDate_longMonthName2(PWideString retval, int month, QDate::MonthNameType type);
C_EXPORT void QDate_longDayName(PWideString retval, int weekday);
C_EXPORT void QDate_longDayName2(PWideString retval, int weekday, QDate::MonthNameType type);
C_EXPORT void QDate_toString(QDateH handle, PWideString retval, Qt::DateFormat f);
C_EXPORT void QDate_toString2(QDateH handle, PWideString retval, PWideString format);
C_EXPORT bool QDate_setYMD(QDateH handle, int y, int m, int d);
C_EXPORT bool QDate_setDate(QDateH handle, int year, int month, int day);
C_EXPORT void QDate_getDate(QDateH handle, int* year, int* month, int* day);
C_EXPORT void QDate_addDays(QDateH handle, QDateH retval, int days);
C_EXPORT void QDate_addMonths(QDateH handle, QDateH retval, int months);
C_EXPORT void QDate_addYears(QDateH handle, QDateH retval, int years);
C_EXPORT int QDate_daysTo(QDateH handle, const QDateH AnonParam1);
C_EXPORT void QDate_currentDate(QDateH retval);
C_EXPORT void QDate_fromString(QDateH retval, PWideString s, Qt::DateFormat f);
C_EXPORT void QDate_fromString2(QDateH retval, PWideString s, PWideString format);
C_EXPORT bool QDate_isValid2(int y, int m, int d);
C_EXPORT bool QDate_isLeapYear(int year);
C_EXPORT uint QDate_gregorianToJulian(int y, int m, int d);
C_EXPORT void QDate_julianToGregorian(uint jd, int* y, int* m, int* d);
C_EXPORT void QDate_fromJulianDay(QDateH retval, int jd);
C_EXPORT int QDate_toJulianDay(QDateH handle);
C_EXPORT QTimeH QTime_create();
C_EXPORT void QTime_destroy(QTimeH handle);
C_EXPORT QTimeH QTime_create2(int h, int m, int s, int ms);
C_EXPORT bool QTime_isNull(QTimeH handle);
C_EXPORT bool QTime_isValid(QTimeH handle);
C_EXPORT int QTime_hour(QTimeH handle);
C_EXPORT int QTime_minute(QTimeH handle);
C_EXPORT int QTime_second(QTimeH handle);
C_EXPORT int QTime_msec(QTimeH handle);
C_EXPORT void QTime_toString(QTimeH handle, PWideString retval, Qt::DateFormat f);
C_EXPORT void QTime_toString2(QTimeH handle, PWideString retval, PWideString format);
C_EXPORT bool QTime_setHMS(QTimeH handle, int h, int m, int s, int ms);
C_EXPORT void QTime_addSecs(QTimeH handle, QTimeH retval, int secs);
C_EXPORT int QTime_secsTo(QTimeH handle, const QTimeH AnonParam1);
C_EXPORT void QTime_addMSecs(QTimeH handle, QTimeH retval, int ms);
C_EXPORT int QTime_msecsTo(QTimeH handle, const QTimeH AnonParam1);
C_EXPORT void QTime_currentTime(QTimeH retval);
C_EXPORT void QTime_fromString(QTimeH retval, PWideString s, Qt::DateFormat f);
C_EXPORT void QTime_fromString2(QTimeH retval, PWideString s, PWideString format);
C_EXPORT bool QTime_isValid2(int h, int m, int s, int ms);
C_EXPORT void QTime_start(QTimeH handle);
C_EXPORT int QTime_restart(QTimeH handle);
C_EXPORT int QTime_elapsed(QTimeH handle);
C_EXPORT QDateTimeH QDateTime_create();
C_EXPORT void QDateTime_destroy(QDateTimeH handle);
C_EXPORT QDateTimeH QDateTime_create2(const QDateH AnonParam1);
C_EXPORT QDateTimeH QDateTime_create3(const QDateH AnonParam1, const QTimeH AnonParam2, Qt::TimeSpec spec);
C_EXPORT QDateTimeH QDateTime_create4(const QDateTimeH other);
C_EXPORT bool QDateTime_isNull(QDateTimeH handle);
C_EXPORT bool QDateTime_isValid(QDateTimeH handle);
C_EXPORT void QDateTime_date(QDateTimeH handle, QDateH retval);
C_EXPORT void QDateTime_time(QDateTimeH handle, QTimeH retval);
C_EXPORT Qt::TimeSpec QDateTime_timeSpec(QDateTimeH handle);
C_EXPORT uint QDateTime_toTime_t(QDateTimeH handle);
C_EXPORT void QDateTime_setDate(QDateTimeH handle, const QDateH date);
C_EXPORT void QDateTime_setTime(QDateTimeH handle, const QTimeH time);
C_EXPORT void QDateTime_setTimeSpec(QDateTimeH handle, Qt::TimeSpec spec);
C_EXPORT void QDateTime_setTime_t(QDateTimeH handle, uint secsSince1Jan1970UTC);
C_EXPORT void QDateTime_toString(QDateTimeH handle, PWideString retval, Qt::DateFormat f);
C_EXPORT void QDateTime_toString2(QDateTimeH handle, PWideString retval, PWideString format);
C_EXPORT void QDateTime_addDays(QDateTimeH handle, QDateTimeH retval, int days);
C_EXPORT void QDateTime_addMonths(QDateTimeH handle, QDateTimeH retval, int months);
C_EXPORT void QDateTime_addYears(QDateTimeH handle, QDateTimeH retval, int years);
C_EXPORT void QDateTime_addSecs(QDateTimeH handle, QDateTimeH retval, int secs);
C_EXPORT void QDateTime_addMSecs(QDateTimeH handle, QDateTimeH retval, qint64 msecs);
C_EXPORT void QDateTime_toTimeSpec(QDateTimeH handle, QDateTimeH retval, Qt::TimeSpec spec);
C_EXPORT void QDateTime_toLocalTime(QDateTimeH handle, QDateTimeH retval);
C_EXPORT void QDateTime_toUTC(QDateTimeH handle, QDateTimeH retval);
C_EXPORT int QDateTime_daysTo(QDateTimeH handle, const QDateTimeH AnonParam1);
C_EXPORT int QDateTime_secsTo(QDateTimeH handle, const QDateTimeH AnonParam1);
C_EXPORT void QDateTime_setUtcOffset(QDateTimeH handle, int seconds);
C_EXPORT int QDateTime_utcOffset(QDateTimeH handle);
C_EXPORT void QDateTime_currentDateTime(QDateTimeH retval);
C_EXPORT void QDateTime_fromString(QDateTimeH retval, PWideString s, Qt::DateFormat f);
C_EXPORT void QDateTime_fromString2(QDateTimeH retval, PWideString s, PWideString format);
C_EXPORT void QDateTime_fromTime_t(QDateTimeH retval, uint secsSince1Jan1970UTC);

#endif
