/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableContainerFactory;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingConstants;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.RelativeDockablePosition;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.docking.SplitContainer;
import com.vldocking.swing.docking.SplitResizer;
import com.vldocking.swing.docking.event.DockingActionAddDockableEvent;
import com.vldocking.swing.docking.event.DockingActionEvent;
import com.vldocking.swing.docking.event.DockingActionSplitComponentEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class RelativeDockingUtilities {
    private RelativeDockingUtilities() {
    }

    private static SplitContainer findBestContainer(Container ancestorContainer, RelativeDockablePosition position) {
        Component centerComp;
        int x = (int)(position.getX() * (double)ancestorContainer.getWidth());
        int y = (int)(position.getY() * (double)ancestorContainer.getHeight());
        int w = (int)(position.getWidth() * (double)ancestorContainer.getWidth());
        int h = (int)(position.getHeight() * (double)ancestorContainer.getHeight());
        int centerX = x + w / 2;
        int centerY = y + h / 2;
        Component splitComp = centerComp = ancestorContainer.findComponentAt(centerX, centerY);
        boolean found = false;
        while (splitComp != null && splitComp != ancestorContainer && !found) {
            if (!((splitComp = splitComp.getParent()) instanceof SplitContainer)) continue;
            Container up = splitComp.getParent();
            while (up instanceof SplitContainer) {
                up = up.getParent();
            }
            if (up != ancestorContainer) continue;
            found = true;
        }
        if (splitComp instanceof SplitContainer) {
            float EPSILON = 0.05f;
            found = true;
            while (found && splitComp.getParent() instanceof SplitContainer) {
                boolean sameOrientation;
                found = false;
                float widthRatio = (float)splitComp.getWidth() / (float)w;
                float heightRatio = (float)splitComp.getHeight() / (float)h;
                SplitContainer parentSplit = (SplitContainer)splitComp.getParent();
                float pWidthRatio = (float)parentSplit.getWidth() / (float)w;
                float pHeightRatio = (float)parentSplit.getHeight() / (float)h;
                boolean bl = sameOrientation = ((SplitContainer)splitComp).getOrientation() == parentSplit.getOrientation();
                if (sameOrientation) {
                    if (parentSplit.getOrientation() == 1) {
                        if (!(Math.abs(pWidthRatio - 1.0f) < Math.abs(widthRatio - 1.0f))) continue;
                        splitComp = splitComp.getParent();
                        found = true;
                        continue;
                    }
                    if (!(Math.abs(pHeightRatio - 1.0f) < Math.abs(heightRatio - 1.0f))) continue;
                    splitComp = splitComp.getParent();
                    found = true;
                    continue;
                }
                if (parentSplit.getOrientation() == 1) {
                    if (!(Math.abs(pWidthRatio - 1.0f) < Math.abs(widthRatio - 1.0f))) continue;
                    splitComp = splitComp.getParent();
                    found = true;
                    continue;
                }
                if (!(Math.abs(pHeightRatio - 1.0f) < Math.abs(heightRatio - 1.0f))) continue;
                splitComp = splitComp.getParent();
                found = true;
            }
        }
        if (splitComp instanceof SplitContainer) {
            int anchors = position.getAnchors();
            boolean anchoredTop = (anchors & 1) > 0;
            boolean anchoredLeft = (anchors & 2) > 0;
            boolean anchoredBottom = (anchors & 4) > 0;
            boolean anchoredRight = (anchors & 8) > 0;
            return RelativeDockingUtilities.findBetterContainer((SplitContainer)splitComp, ancestorContainer, anchoredTop, anchoredLeft, anchoredBottom, anchoredRight);
        }
        return null;
    }

    private static SplitContainer findBetterContainer(SplitContainer split, Container dockingPanel, boolean anchoredTop, boolean anchoredLeft, boolean anchoredBottom, boolean anchoredRight) {
        boolean[] globalAnchors = new boolean[]{anchoredTop, anchoredLeft, anchoredBottom, anchoredRight};
        int globalCount = 0;
        for (int i = 0; i < 4; ++i) {
            if (!globalAnchors[i]) continue;
            ++globalCount;
        }
        SplitContainer betterSplit = split;
        int contacts = RelativeDockingUtilities.findAnchors(split, dockingPanel);
        boolean[] splitAnchors = new boolean[]{(contacts & 1) > 0, (contacts & 2) > 0, (contacts & 4) > 0, (contacts & 8) > 0};
        while (true) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (!globalAnchors[i] || !splitAnchors[i]) continue;
                ++count;
            }
            if (count >= globalCount) {
                return split;
            }
            if (!(split.getParent() instanceof SplitContainer)) break;
            split = (SplitContainer)split.getParent();
        }
        return split;
    }

    private static void hSplitAndResize(Component base, Component left, Component right, double proportion) {
        Container parent = base.getParent();
        SplitContainer newSplit = new SplitContainer(1);
        DockingUtilities.replaceChild(parent, base, newSplit);
        newSplit.setLeftComponent(left);
        newSplit.setRightComponent(right);
        SwingUtilities.invokeLater(new SplitResizer(newSplit, proportion));
    }

    private static void vSplitAndResize(Component base, Component top, Component bottom, double proportion) {
        Container parent = base.getParent();
        SplitContainer newSplit = new SplitContainer(0);
        DockingUtilities.replaceChild(parent, base, newSplit);
        newSplit.setTopComponent(top);
        newSplit.setBottomComponent(bottom);
        SwingUtilities.invokeLater(new SplitResizer(newSplit, proportion));
    }

    public static int findAnchors(Component base, Container ancestorContainer) {
        int contact = 15;
        Component child = base;
        for (Container comp = base.getParent(); comp != null && comp != ancestorContainer && contact != 0; comp = comp.getParent()) {
            if (comp instanceof SplitContainer) {
                SplitContainer sc = (SplitContainer)comp;
                contact = sc.getOrientation() == 0 ? (sc.getTopComponent() == child ? (contact &= 0xFFFFFFFB) : (contact &= 0xFFFFFFFE)) : (sc.getLeftComponent() == child ? (contact &= 0xFFFFFFF7) : (contact &= 0xFFFFFFFD));
            }
            child = comp;
        }
        return contact;
    }

    public static SingleDockableContainer insertDockable(Container relativeAncestorContainer, Dockable dockable, RelativeDockablePosition position) {
        if (position == null) {
            position = new RelativeDockablePosition(0.0, 0.8, 0.5, 0.2);
        }
        SingleDockableContainer dockableContainer = null;
        if (relativeAncestorContainer.getComponentCount() == 0) {
            dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_DESKTOP);
            relativeAncestorContainer.add((Component)((Object)dockableContainer), "Center");
            relativeAncestorContainer.invalidate();
            relativeAncestorContainer.validate();
            relativeAncestorContainer.repaint();
        } else {
            dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
            int x = (int)(position.getX() * (double)relativeAncestorContainer.getWidth());
            int y = (int)(position.getY() * (double)relativeAncestorContainer.getHeight());
            int w = (int)(position.getWidth() * (double)relativeAncestorContainer.getWidth());
            int h = (int)(position.getHeight() * (double)relativeAncestorContainer.getHeight());
            int centerX = x + w / 2;
            int centerY = y + h / 2;
            SplitContainer split = RelativeDockingUtilities.findBestContainer(relativeAncestorContainer, position);
            if (split != null) {
                Component bestComp;
                Point bestCenter;
                int contacts = position.getAnchors();
                boolean anchoredTop = (contacts & 1) > 0;
                boolean anchoredLeft = (contacts & 2) > 0;
                boolean anchoredBottom = (contacts & 4) > 0;
                boolean anchoredRight = (contacts & 8) > 0;
                Component left = split.getLeftComponent();
                Component right = split.getRightComponent();
                Point leftCenter = SwingUtilities.convertPoint(left, left.getWidth() / 2, left.getHeight() / 2, relativeAncestorContainer);
                Point rightCenter = SwingUtilities.convertPoint(right, right.getWidth() / 2, right.getHeight() / 2, relativeAncestorContainer);
                int leftDist = (leftCenter.x - x) * (leftCenter.x - x) + (leftCenter.y - y) * leftCenter.y;
                int rightDist = (rightCenter.x - x) * (rightCenter.x - x) + (rightCenter.y - y) * rightCenter.y;
                if (leftDist < rightDist) {
                    bestCenter = leftCenter;
                    bestComp = left;
                } else {
                    bestCenter = rightCenter;
                    bestComp = right;
                }
                float splitWidthRatio = Math.abs(1.0f - (float)split.getWidth() / (float)w);
                float splitHeightRatio = Math.abs(1.0f - (float)split.getHeight() / (float)h);
                if (split.getOrientation() == 0) {
                    int splitW;
                    float proportionW;
                    Component top = split.getTopComponent();
                    Component bottom = split.getBottomComponent();
                    int topH = top.getHeight();
                    int bottomH = bottom.getHeight();
                    float proportionTopH = (float)h / (float)topH;
                    float proportionBottomH = (float)h / (float)bottomH;
                    if (proportionTopH >= 0.6f) {
                        proportionTopH = 0.6f;
                    }
                    if (proportionBottomH >= 0.6f) {
                        proportionBottomH = 0.6f;
                    }
                    if ((proportionW = (float)w / (float)(splitW = split.getWidth())) >= 0.8f) {
                        proportionW = 0.8f;
                    }
                    if (anchoredTop) {
                        if (anchoredLeft) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, top, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(top);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            }
                        } else if (anchoredRight) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                newSplit.setLeftComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, top, newSplit);
                                newSplit.setLeftComponent(top);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, top, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(top);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionTopH));
                        }
                    } else if (anchoredBottom) {
                        if (anchoredLeft) {
                            if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, bottom, newSplit);
                                newSplit.setTopComponent(bottom);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, bottom, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(bottom);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            }
                        } else if (anchoredRight) {
                            if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, bottom, newSplit);
                                newSplit.setLeftComponent(bottom);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bottom, newSplit);
                            newSplit.setTopComponent(bottom);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                        }
                    } else if (anchoredLeft) {
                        if (anchoredRight) {
                            int yTop = y;
                            int yBottom = split.getHeight() - y - h;
                            int splitTop = top.getHeight();
                            int splitBottom = bottom.getHeight();
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestComp == top) {
                                newSplit.setTopComponent(bestComp);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)(split.getHeight() - yBottom) / (float)split.getHeight()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)yTop / (float)split.getHeight()));
                            } else {
                                newSplit.setBottomComponent(bestComp);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)yTop / (float)split.getHeight()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)splitBottom));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setRightComponent(bestComp);
                            newSplit.setLeftComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                        }
                    } else if (anchoredRight) {
                        SplitContainer newSplit = new SplitContainer(1);
                        DockingUtilities.replaceChild(split, bestComp, newSplit);
                        newSplit.setLeftComponent(bestComp);
                        newSplit.setRightComponent((Component)((Object)dockableContainer));
                        SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                    } else {
                        SplitContainer newSplit = new SplitContainer(0);
                        DockingUtilities.replaceChild(split, bestComp, newSplit);
                        if (bestCenter.y < centerY) {
                            newSplit.setTopComponent(bestComp);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                        } else {
                            newSplit.setBottomComponent(bestComp);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionTopH));
                        }
                    }
                } else {
                    int splitH;
                    float proportionH;
                    float proportionLeftW = (float)w / (float)left.getWidth();
                    float proportionRightW = (float)w / (float)right.getWidth();
                    if (proportionLeftW >= 0.8f) {
                        proportionLeftW = 0.8f;
                    }
                    if (proportionRightW >= 0.8f) {
                        proportionRightW = 0.8f;
                    }
                    if ((proportionH = (float)h / (float)(splitH = split.getHeight())) >= 0.6f) {
                        proportionH = 0.6f;
                    }
                    if (anchoredTop) {
                        if (anchoredLeft) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionLeftW));
                            } else if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            }
                        } else if (anchoredRight) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, right, newSplit);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                newSplit.setLeftComponent(right);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionRightW));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, right, newSplit);
                                newSplit.setBottomComponent(right);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            }
                        } else if (anchoredBottom) {
                            int xLeft = x;
                            int xRight = split.getWidth() - x - w;
                            int splitLeft = left.getWidth();
                            int splitRight = right.getWidth();
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestComp == left) {
                                newSplit.setLeftComponent(bestComp);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)(split.getWidth() - xRight) / (float)split.getWidth()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)xLeft / (float)split.getWidth()));
                            } else {
                                newSplit.setRightComponent(bestComp);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)xLeft / (float)split.getWidth()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)w / (float)splitRight));
                            }
                        } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(split);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(bestComp);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                        }
                    } else if (anchoredBottom) {
                        if (anchoredLeft) {
                            if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent(split);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            }
                        } else if (anchoredRight) {
                            if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - (float)h / (float)split.getHeight()));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, right, newSplit);
                                newSplit.setTopComponent(right);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            }
                        } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            newSplit.setTopComponent(split);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - (float)h / (float)split.getHeight()));
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setTopComponent(bestComp);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                        }
                    } else if (anchoredLeft) {
                        if (anchoredRight) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(split);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                        } else if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(split);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                        } else {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, left, newSplit);
                            newSplit.setRightComponent(left);
                            newSplit.setLeftComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionLeftW));
                        }
                    } else if (anchoredRight) {
                        if (splitWidthRatio < 0.1f && split.getHeight() > h) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(split);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)split.getHeight()));
                        } else {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, right, newSplit);
                            newSplit.setLeftComponent(right);
                            newSplit.setRightComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionRightW));
                        }
                    } else {
                        float widthIfSplitH = bestComp.getWidth() / 2;
                        float heightIfSplitH = bestComp.getHeight();
                        float widthIfSplitV = bestComp.getWidth();
                        float heightIfSplitV = bestComp.getHeight() / 2;
                        float whH = widthIfSplitH / heightIfSplitH;
                        float whBefore = (float)w / (float)h;
                        float whV = widthIfSplitV / heightIfSplitV;
                        if (Math.abs(whBefore - whV) < Math.abs(whBefore - whH)) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestCenter.y < centerY) {
                                newSplit.setTopComponent(bestComp);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            } else {
                                newSplit.setBottomComponent(bestComp);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestCenter.x < centerX) {
                                newSplit.setLeftComponent(bestComp);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionRightW));
                            } else {
                                newSplit.setRightComponent(bestComp);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionLeftW));
                            }
                        }
                    }
                }
            } else {
                float proportionH;
                boolean anchoredTop = y < 5;
                boolean anchoredLeft = x < 5;
                boolean anchoredBottom = Math.abs(y + h - relativeAncestorContainer.getHeight()) < 5;
                boolean anchoredRight = Math.abs(x + w - relativeAncestorContainer.getWidth()) < 5;
                Component singleComp = relativeAncestorContainer.getComponent(0);
                float proportionW = (float)w / (float)relativeAncestorContainer.getWidth();
                if (proportionW >= 0.8f) {
                    proportionW = 0.8f;
                }
                if ((proportionH = (float)h / (float)relativeAncestorContainer.getHeight()) >= 0.6f) {
                    proportionH = 0.6f;
                }
                if (anchoredTop) {
                    if (anchoredLeft) {
                        if (anchoredBottom) {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        } else if (anchoredRight) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        }
                    } else if (anchoredRight) {
                        if (anchoredBottom) {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        }
                    } else {
                        RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                    }
                } else if (anchoredLeft) {
                    if (anchoredBottom) {
                        if (anchoredRight) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        }
                    } else if (anchoredRight) {
                        if (centerY < relativeAncestorContainer.getHeight() / 2) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        }
                    } else {
                        RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                    }
                } else if (anchoredBottom) {
                    if (anchoredRight) {
                        if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        }
                    } else {
                        RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                    }
                } else if (anchoredRight) {
                    RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                } else if (centerY < relativeAncestorContainer.getHeight() / 2) {
                    RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                } else {
                    RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                }
            }
        }
        return dockableContainer;
    }

    public static DockingActionEvent getInsertionDockingAction(Container relativeAncestorContainer, Dockable dockable, DockableState dockableState, DockableState newState) {
        float proportionH;
        RelativeDockablePosition position = dockableState.getPosition();
        DockingDesktop desktop = dockableState.getDesktop();
        DockableState.Location initialState = dockableState.getLocation();
        DockableState.Location nextState = newState.getLocation();
        if (position == null) {
            position = new RelativeDockablePosition(0.0, 0.8, 0.5, 0.2);
        }
        Object dockableContainer = null;
        if (relativeAncestorContainer.getComponentCount() == 0) {
            return new DockingActionAddDockableEvent(desktop, dockable, initialState, nextState, relativeAncestorContainer);
        }
        int x = (int)(position.getX() * (double)relativeAncestorContainer.getWidth());
        int y = (int)(position.getY() * (double)relativeAncestorContainer.getHeight());
        int w = (int)(position.getWidth() * (double)relativeAncestorContainer.getWidth());
        int h = (int)(position.getHeight() * (double)relativeAncestorContainer.getHeight());
        int centerX = x + w / 2;
        int centerY = y + h / 2;
        SplitContainer split = RelativeDockingUtilities.findBestContainer(relativeAncestorContainer, position);
        if (split != null) {
            int splitH;
            float proportionH2;
            Component bestComp;
            Point bestCenter;
            Rectangle splitRect = SwingUtilities.convertRectangle(split, new Rectangle(0, 0, split.getWidth(), split.getHeight()), relativeAncestorContainer);
            boolean anchoredTop = Math.abs(y - splitRect.y) < 5;
            boolean anchoredLeft = Math.abs(x - splitRect.x) < 5;
            boolean anchoredBottom = Math.abs(y + h - splitRect.y - splitRect.height) < 30;
            boolean anchoredRight = Math.abs(x + w - splitRect.x - splitRect.width) < 5;
            Component left = split.getLeftComponent();
            Component right = split.getRightComponent();
            Point leftCenter = SwingUtilities.convertPoint(left, left.getWidth() / 2, left.getHeight() / 2, relativeAncestorContainer);
            Point rightCenter = SwingUtilities.convertPoint(right, right.getWidth() / 2, right.getHeight() / 2, relativeAncestorContainer);
            int leftDist = (leftCenter.x - x) * (leftCenter.x - x) + (leftCenter.y - y) * leftCenter.y;
            int rightDist = (rightCenter.x - x) * (rightCenter.x - x) + (rightCenter.y - y) * rightCenter.y;
            if (leftDist < rightDist) {
                bestCenter = leftCenter;
                bestComp = left;
            } else {
                bestCenter = rightCenter;
                bestComp = right;
            }
            if (split.getOrientation() == 0) {
                int splitW;
                float proportionW;
                Component top = split.getTopComponent();
                Component bottom = split.getBottomComponent();
                int topH = top.getHeight();
                int bottomH = bottom.getHeight();
                float proportionTopH = (float)h / (float)topH;
                float proportionBottomH = (float)h / (float)bottomH;
                if (proportionTopH >= 0.6f) {
                    proportionTopH = 0.6f;
                }
                if (proportionBottomH >= 0.6f) {
                    proportionBottomH = 0.6f;
                }
                if ((proportionW = (float)w / (float)(splitW = split.getWidth())) >= 0.8f) {
                    proportionW = 0.8f;
                }
                if (anchoredTop) {
                    if (anchoredLeft) {
                        if (anchoredBottom) {
                            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, split, DockingConstants.SPLIT_LEFT, proportionW);
                        }
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, top, DockingConstants.SPLIT_LEFT, proportionW);
                    }
                    if (anchoredRight) {
                        if (anchoredBottom) {
                            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, split, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
                        }
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, top, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, top, DockingConstants.SPLIT_TOP, proportionTopH);
                }
                if (anchoredBottom) {
                    if (anchoredLeft) {
                        if (anchoredRight) {
                            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bottom, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionBottomH);
                        }
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bottom, DockingConstants.SPLIT_LEFT, proportionW);
                    }
                    if (anchoredRight) {
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bottom, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bottom, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionBottomH);
                }
                if (anchoredLeft) {
                    if (anchoredRight) {
                        int yTop = y;
                        int yBottom = split.getHeight() - y - h;
                        int splitTop = top.getHeight();
                        int splitBottom = bottom.getHeight();
                        if (bestComp == top) {
                            float hParent = (float)(split.getHeight() - yBottom) / (float)split.getHeight();
                            float hChild = (float)yTop / (float)split.getHeight();
                            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_BOTTOM, hChild, hParent);
                        }
                        float hChild = (float)h / (float)splitBottom;
                        float hParent = (float)yTop / (float)split.getHeight();
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_TOP, hChild, hParent);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_LEFT, proportionW);
                }
                if (anchoredRight) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
                }
                SplitContainer newSplit = new SplitContainer(0);
                DockingUtilities.replaceChild(split, bestComp, newSplit);
                if (bestCenter.y < centerY) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionBottomH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_TOP, proportionTopH);
            }
            float proportionLeftW = (float)w / (float)left.getWidth();
            float proportionRightW = (float)w / (float)right.getWidth();
            if (proportionLeftW >= 0.8f) {
                proportionLeftW = 0.8f;
            }
            if (proportionRightW >= 0.8f) {
                proportionRightW = 0.8f;
            }
            if ((proportionH2 = (float)h / (float)(splitH = split.getHeight())) >= 0.6f) {
                proportionH2 = 0.6f;
            }
            if (anchoredTop) {
                if (anchoredLeft) {
                    if (anchoredBottom) {
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, left, DockingConstants.SPLIT_LEFT, proportionLeftW);
                    }
                    if (anchoredRight) {
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, split, DockingConstants.SPLIT_TOP, proportionH2);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, left, DockingConstants.SPLIT_TOP, proportionH2);
                }
                if (anchoredRight) {
                    if (anchoredBottom) {
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, right, DockingConstants.SPLIT_RIGHT, 1.0f - proportionRightW);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, right, DockingConstants.SPLIT_TOP, proportionH2);
                }
                if (anchoredBottom) {
                    int xLeft = x;
                    int xRight = split.getWidth() - x - w;
                    int splitLeft = left.getWidth();
                    int splitRight = right.getWidth();
                    if (bestComp == left) {
                        float parentW = (float)(split.getWidth() - xRight) / (float)split.getWidth();
                        float childW = (float)xLeft / (float)split.getWidth();
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_RIGHT, childW, parentW);
                    }
                    float parentW = (float)xLeft / (float)split.getWidth();
                    float childW = (float)w / (float)splitRight;
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_LEFT, childW, parentW);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_TOP, proportionH2);
            }
            if (anchoredBottom) {
                if (anchoredLeft) {
                    if (anchoredRight) {
                        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, split, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH2);
                    }
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, left, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH2);
                }
                if (anchoredRight) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, right, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH2);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH2);
            }
            if (anchoredLeft) {
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, left, DockingConstants.SPLIT_LEFT, proportionLeftW);
            }
            if (anchoredRight) {
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, right, DockingConstants.SPLIT_RIGHT, 1.0f - proportionRightW);
            }
            if (bestCenter.y < centerY) {
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH2);
            }
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, bestComp, DockingConstants.SPLIT_TOP, proportionH2);
        }
        boolean anchoredTop = y < 5;
        boolean anchoredLeft = x < 5;
        boolean anchoredBottom = Math.abs(y + h - relativeAncestorContainer.getHeight()) < 5;
        boolean anchoredRight = Math.abs(x + w - relativeAncestorContainer.getWidth()) < 5;
        Component singleComp = relativeAncestorContainer.getComponent(0);
        float proportionW = (float)w / (float)relativeAncestorContainer.getWidth();
        if (proportionW >= 0.8f) {
            proportionW = 0.8f;
        }
        if ((proportionH = (float)h / (float)relativeAncestorContainer.getHeight()) >= 0.6f) {
            proportionH = 0.6f;
        }
        if (anchoredTop) {
            if (anchoredLeft) {
                if (anchoredBottom) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_LEFT, proportionW);
                }
                if (anchoredRight) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
                }
                if (w > h) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_LEFT, proportionW);
            }
            if (anchoredRight) {
                if (anchoredBottom) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
                }
                if (w > h) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
            }
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
        }
        if (anchoredLeft) {
            if (anchoredBottom) {
                if (anchoredRight) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
                }
                if (w > h) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_LEFT, proportionW);
            }
            if (anchoredRight) {
                if (centerY < relativeAncestorContainer.getHeight() / 2) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
            }
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_LEFT, proportionW);
        }
        if (anchoredBottom) {
            if (anchoredRight) {
                if (w > h) {
                    return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
                }
                return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
            }
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
        }
        if (anchoredRight) {
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_RIGHT, 1.0f - proportionW);
        }
        if (centerY < relativeAncestorContainer.getHeight() / 2) {
            return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_TOP, proportionH);
        }
        return new DockingActionSplitComponentEvent(desktop, dockable, initialState, nextState, singleComp, DockingConstants.SPLIT_BOTTOM, 1.0f - proportionH);
    }

    public static SingleDockableContainer applyDockingAction(Dockable dockable, DockingActionEvent action) {
        switch (action.getActionType()) {
            case 1: {
                DockingActionAddDockableEvent addAction = (DockingActionAddDockableEvent)action;
                SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_DESKTOP);
                Container relativeAncestorContainer = addAction.getParentContainer();
                relativeAncestorContainer.add((Component)((Object)dockableContainer), "Center");
                relativeAncestorContainer.invalidate();
                relativeAncestorContainer.validate();
                relativeAncestorContainer.repaint();
                return dockableContainer;
            }
            case 3: {
                SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
                DockingActionSplitComponentEvent splitAction = (DockingActionSplitComponentEvent)action;
                Component base = splitAction.getBase();
                float div = splitAction.getDividorLocation();
                DockingConstants.Split splitPosition = splitAction.getSplitPosition();
                float parentDiv = splitAction.getParentDividorLocation();
                switch (splitPosition.value()) {
                    case 0: {
                        RelativeDockingUtilities.vSplitAndResize(base, (Container)((Object)dockableContainer), base, div);
                        break;
                    }
                    case 1: {
                        RelativeDockingUtilities.hSplitAndResize(base, (Container)((Object)dockableContainer), base, div);
                        break;
                    }
                    case 2: {
                        RelativeDockingUtilities.vSplitAndResize(base, base, (Container)((Object)dockableContainer), div);
                        break;
                    }
                    case 3: {
                        RelativeDockingUtilities.hSplitAndResize(base, base, (Container)((Object)dockableContainer), div);
                    }
                }
                if (parentDiv != -1.0f && base.getParent() instanceof SplitContainer) {
                    SplitContainer parent = (SplitContainer)base.getParent();
                    new SplitResizer(parent, parentDiv);
                }
                return dockableContainer;
            }
        }
        throw new IllegalArgumentException("Action type not managed : " + action.getActionType());
    }
}

