/*
 *  Copyright (c) 2009-2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Source_p.h"

using namespace GTLFragment;

#include <fstream>

#include <GTLCore/String.h>

#include "GTLCore/Debug.h"
#include "Lexer_p.h"
#include "MetadataLexer_p.h"
#include "MetadataParser_p.h"
#include "Metadata.h"

#include "GTLCore/Metadata/Factory_p.h"
#include <GTLCore/CompilationMessages.h>
#include <GTLCore/SharedPointer.h>

Source::Source(Source::Private* nd) : d(nd)
{
  nd->ref();
}

Source::Source() : d(new Private)
{
  d->ref();
}

GTL_SHARED_DATA(Source)

GTLCore::String Source::name() const
{
  d->update();
  return d->name;
}

GTLCore::String Source::source() const
{
  return d->source;
}

void Source::setSource( const GTLCore::String& _source)
{
  deref();
  GTLCore::Metadata::Factory::deleteEntry( d->metadata );
  d->metadata = 0;
  d->metadataCompilationFailed = false;
  d->uptodate = false;
  d->source = _source;
}

void Source::loadFromFile(const GTLCore::String& _fileName)
{
  GTLCore::String source = "";
  std::ifstream in;
  in.open(_fileName.c_str() );
  if(not in)
  {
    GTL_DEBUG( "Impossible to open file " << _fileName );
    return;
  }
  std::string str;
  std::getline(in,str);
  while ( in ) {
    source += str;
    source += "\n";
    std::getline(in,str);
  }
  setSource(source);
}

const Metadata* Source::metadata() const
{
  if(not d->metadata and not d->metadataCompilationFailed)
  {
    d->compileMetaData();
  }
  return d->metadata;
}

GTLCore::CompilationMessages Source::metadataCompilationMessages() const
{
  return d->compilationErrors;
}
