#! /usr/bin/env python
# -*- coding: utf-8 -*-

#	Copyright 2013, Marten de Vries
#
#	This file is part of OpenTeacher.
#
#	OpenTeacher is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	OpenTeacher is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with OpenTeacher.  If not, see <http://www.gnu.org/licenses/>.

import pprint
import contextlib

FILE_TEMPLATE = """
#! /usr/bin/env python
# -*- coding: utf-8 -*-

#	Copyright (C) 2007-2011 Edgewall Software
#	All rights reserved.
#
#	Redistribution and use in source and binary forms, with or without
#	modification, are permitted provided that the following conditions
#	are met:
#
#	 1. Redistributions of source code must retain the above copyright
#	    notice, this list of conditions and the following disclaimer.
#	 2. Redistributions in binary form must reproduce the above copyright
#	    notice, this list of conditions and the following disclaimer in
#	    the documentation and/or other materials provided with the
#	    distribution.
#	 3. The name of the author may not be used to endorse or promote
#	    products derived from this software without specific prior
#	    written permission.
#
#	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
#	OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#	ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#	DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
#	GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
#	IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
#	IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#THIS FILE IS GENERATED. DON'T EDIT IT, SINCE CHANGES WON'T BE
#PERSISTANT!
#
#GENERATED BY: python openteacher.py -p generate-language-code-guesser-table

NAME_TO_CODE = %s
CODE_TO_NAME = %s
""".strip()

class LanguageCodeGuesserTableGeneratorModule(object):
	def __init__(self, moduleManager, *args, **kwargs):
		super(LanguageCodeGuesserTableGeneratorModule, self).__init__(*args, **kwargs)
		self._mm = moduleManager

		self.type = "languageCodeGuesserTableGenerator"
		self.requires = (
			self._mm.mods(type="execute"),
		)
		self.priorities = {
			"default": -1,
			"generate-language-code-guesser-table": 0,
		}

	def enable(self):
		global babel
		try:
			import babel
		except ImportError:
			return

		self._modules = next(iter(self._mm.mods(type="modules")))
		self._modules.default("active", type="execute").startRunning.handle(self._run)

		self.active = True

	def _run(self):
		nameToCode = {}
		codeToName = {}
		for localeCode in babel.Locale("en").languages.keys():
			with contextlib.ignored(babel.UnknownLocaleError):
				locale = babel.Locale(localeCode)
				codeToName[localeCode] = locale.display_name
				nameToCode[localeCode] = localeCode
				for code, name in locale.languages.iteritems():
					nameToCode[name.lower()] = code

		#make the test suite pass ;).
		nameToCode["frisian"] = "fy"
		nameToCode["frysk"] = "fy"
		nameToCode["fy"] = "fy"

		codeToName["fy"] = "Frysk"

		data = FILE_TEMPLATE % (repr(nameToCode), repr(codeToName))

		print data.encode("UTF-8")

	def disable(self):
		self.active = False

		self._modules.default("active", type="execute").startRunning.unhandle(self._run)
		del self._modules

def init(moduleManager):
	return LanguageCodeGuesserTableGeneratorModule(moduleManager)
