/***************************************************************************
                          alsound.h  -  description
                             -------------------
    begin                : Wed Jan 21 2004
    copyright            : (C) 2004 by Harald Krippel
    email                : harald@hte-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef ALSOUND_H
#define ALSOUND_H

/**
  *@author Krippel Harald
  */

#include "qcsound.hpp"
#include "audioenv.hpp"


/*!

 This Class is the glue between openAL and QCake.

*/

class AlSound: public qcSound
{
   Q_OBJECT
   public:
     AlSound(void);
     void   setPosition (float x, float y, float z);
     int   Play();
     int   Stop();
     void   Loop(int flag);
     void   Relative(int flag);
     void   adjustVolume(float gain);
     int   loadFile(const QString &);
     ~AlSound(void);

protected:

   int          snd;     ///< holds the sound index
   sgCoord      pos;     ///< holds the position and rotating
   AudioEnv *Audio;      ///< singleton pointer to the AudioEnv
};

#endif
