# -*- coding: utf-8 -*-
# vim:fenc=utf-8

# Copyright (C) 2012-2019 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
# Copyright (C) 2014 by Josh Lukens <jlukens@botch.com>
#
# X2Go Session Broker is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# X2Go Session Broker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

class X2GoBrokerOptionalScript(object):
    """\
    X2Go Session Broker supports running optional Python code that a site admin
    can add to the broker installation files.

    All those optional scripts need to be inherited from this class.

    """

    def run_me(self, username, password, task, profile_id, ip, cookie, authed, server):
        """\
        Dummy :function:``run_me()`` function. If you deploy your own
        optional scripts with X2Go Session Broker, make sure that your
        class overrides this function. The broker frontends will try to
        execute code presented under this method name at pre-auth,
        post-auth and session-selected.

        :param script_type: name of the script type to be executed (``pre_auth_scripts``, ``post_auth_scripts``, ``select_session_scripts``)
        :type script_type: ``str``
        :param username: name of the X2Go session user a script will run for
        :type username: ``str``
        :param password: password for the X2Go session
        :type password: ``str``
        :param task: the broker task that currently being processed
        :type task: ``str``
        :param profile_id: the session profile ID that is being operated upon
        :type profile_id: ``str``
        :param ip: the client machine's IP address
        :type ip: ``str``
        :param cookie: the currently valid authentication cookie
        :type cookie: ``str``
        :param authed: authentication status (already authenticated or not)
        :type authed: ``bool``
        :param server: hostname or IP address of the X2Go server being operated upon
        :type server: ``str``

        :returns: Pass-through of the return value returned by the to-be-run optional script (i.e., success or failure)
        :rtype: ``bool``

        """
        return username, password, task, profile_id, ip, cookie, authed, server
