/* msm-pixmap.c
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "msm.h"
#include "msm-drm.h"

#define MSMPTR_FROM_PIXMAP(_x)         \
	MSMPTR(xf86Screens[(_x)->drawable.pScreen->myNum])

int
msm_pixmap_offset(PixmapPtr pixmap)
{
    struct msm_pixmap_priv *priv;

    priv = exaGetPixmapDriverPrivate(pixmap);

    if (priv && priv->bo)
	return 0;

     return exaGetPixmapOffset(pixmap);
}

int
msm_pixmap_get_pitch(PixmapPtr pix)
{
  struct msm_pixmap_priv *priv = exaGetPixmapDriverPrivate(pix);

  if (priv && priv->bo) {
    return ((pix->drawable.width + 31) & ~31) *
      (pix->drawable.bitsPerPixel >> 3);
  }

  return exaGetPixmapPitch(pix);
}

Bool
msm_pixmap_in_gem(PixmapPtr pix)
{
  MSMPtr pMsm = MSMPTR_FROM_PIXMAP(pix);
  struct msm_pixmap_priv *priv = exaGetPixmapDriverPrivate(pix);

#if USEDRI2
  if (pMsm->useDRI2 && priv && priv->bo)
    return TRUE;
#endif

  return FALSE;
}

struct msm_drm_bo *
msm_get_pixmap_bo(PixmapPtr pix)
{
  MSMPtr pMsm = MSMPTR_FROM_PIXMAP(pix);
  struct msm_pixmap_priv *priv = exaGetPixmapDriverPrivate(pix);

#if USEDRI2
  if (pMsm->useDRI2 && priv && priv->bo) {
	/* When this fucntion is called then ensure it gets
	  allocated - if this function ever gets used outside of
	  EXA this could cause problems */

	msm_drm_bo_alloc(priv->bo);
	return priv->bo;
  }
#endif

  return NULL;
}

/* For now, all offscreen memory will be in EBI since the only consumer
 * is the MDP in the Xvideo code, so when there is another consumer,
 * then make sure to allow the type to be specified */

struct msm_offscreen_area *
msm_alloc_offscreen_memory(ScreenPtr pScreen, int size)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    MSMPtr pMsm = MSMPTR(pScrn);
    struct msm_offscreen_area *ret =
	xcalloc(1, sizeof(struct msm_offscreen_area));

    if (ret == NULL)
	return NULL;

#if USEDRI2
    if (pMsm->useDRI2) {
	struct msm_drm_bo *bo = msm_drm_bo_create_memtype(pMsm->drmFD, size,
							  MSM_DRM_MEMTYPE_EBI);

	if (bo == NULL)
	    goto err;

	if (msm_drm_bo_map(bo)) {
	    msm_drm_bo_free(bo);
	    goto err;
	}

	ret->priv = (void *) bo;
	ret->ptr = bo->virt;
	ret->type = MSM_OFFSCREEN_GEM;

	return ret;
    }
#endif

    if (pMsm->accel) {
	ExaOffscreenArea *area = exaOffscreenAlloc(pScreen, size, 4, TRUE,
						   NULL, NULL);

	if (area == NULL)
	    goto err;

	ret->priv = (void *) area;
	ret->ptr = pMsm->fbmem + area->offset;
	ret->type = MSM_OFFSCREEN_EXA;

	return ret;
    }

err:
    xfree(ret);
    return NULL;
}

void
msm_free_offscreen_memory(ScreenPtr pScreen, struct msm_offscreen_area *area)
{
    if (area == NULL)
	return;

    if (area->type == MSM_OFFSCREEN_GEM)
	msm_drm_bo_free((struct msm_drm_bo *) area->priv);
    else if (area->type == MSM_OFFSCREEN_EXA)
	exaOffscreenFree(pScreen, (ExaOffscreenArea *) area->priv);

    xfree(area);
}



